// Keep everything in anonymous function, called on window load.
if(window.addEventListener) {
window.addEventListener('load', function () {
  var canvas, context, canvaso, contexto;

  // Variables de herramientas.
  var tool;
  var flagRejilla = true;
  var undoHistory = new Array();//Matriz que guarda imagenes para el deshacer
  var redoHistory = new Array();//Matriz que guarda imagenes para el rehacer
  var tool_default = 'linea';
  var imagenEncima = "imagenes/simetria/rejilla20px.png";
  mariposa = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAu4AAAIhCAYAAAARoz+rAAAABHNCSVQICAgIfAhkiAAAFOpJREFUeJzt3b+SZddVx/G1uqYsEp5A4AC9gAJiyjmBEx7Ag9tVYCSKiJKd+BIhk7k0FGVrCgU8ARGpSYl4ACaAqrGJHKNkNkGfkXp6pqdvd59z9l77fD5Vt3ru/JFWINXvqzM96mytBQAAMLaL3gcAAAB3E+4A AFCAcAcAgAKEOwAAFCDcAQCgAOEOAAAFCHcAAChAuAMAQAHCHQAAChDuAABQgHAHAIAChDsAABQg 3AEAoADhDgAABQh3AAAoQLgDAEABwh0AAAoQ7gAAUIBwBwCAAoQ7AAAUINwBAKAA4Q4AAAUIdwAA KEC4AwBAAcIdAAAKEO4AAFCAcAcAgAKEOwAAFCDcAQCgAOEOAAAFCHcAAChAuAMAQAHCHQAAChDu AABQgHAHAIAChDsAABQg3AEAoADhDgAABQh3AAAoQLgDAEABwh0AAAoQ7gAAUIBwBwCAAoQ7AAAU INwBAKAA4Q4AAAUIdwAAKEC4AwBAAcIdAAAKEO4AAFCAcAcAgAKEOwAAFCDcAQCgAOEOAAAFCHcA AChAuAMAQAHCHQAACnjS+wC2kZnfi4jvdT6D7f0uIp611l71PgQA2JZwn9f3IuJnvY9gFx9n5qV4 B4C5+VQZqO9pRDzPTP8+zyLzFJlteZ16nwPAGDxxP4Z/j4hf9z6C1X0cEd9fvv00IsKTdwCYl3A/ hl+31k69j2BdyxP257FEe4h3AJia31qHopY4v4yIr659t0+bAYBJGXcoTLwDwHEYdihOvAPAMRh1 mIB4B4D5GXSYhHgHgLkZc5iIeAeAeRlymIx4B4A5GXGYkHgHgPkYcJiUeAeAufjKqTCx1tqrzLxc 3voKq1VcfaXjU+crABiMp24wOU/eAWAORhsOQLwDQH0GGw5CvANAbcYaDkS8A0BdhhoORrwDQE1G Gg5IvANAPQYaDkq8A0AtxhkOTLwDQB2GGQ5OvANADUYZEO8AUIBBBiJCvAPA6Iwx8A3xPojMU2S2 5XXqfQ4AYzDEwBvEOwCMyQgDbxHvADAeAwy8k3gHgLEYX+BW4h0AxmF4gfcS7wAwBqML3Em8A0B/ Bhc4i3gHgL6MLXA28Q4A/Rha4F7EOwD0YWSBexPvALA/Aws8iHgHgH096X0AUFdr7VVmXi5vn17/ mJmXS9xzX62dIuLU+QoABuOpGPAonrwDwD6MKvBo4h0AtmdQgVWIdwDYljEFViPeAWA7hhRYlXgH gG0YUWB14h0A1mdAgU2IdwBYl/EENiPeAWA9hhPYlHgHgHUYTWBz4h0AHs9gArsQ7wDwOMYS2I14 P1PmKTLb8jr1PgeAMRhKYFfiHQAexkgCuxPvAHB/BhLoQrwDwP0YR6Ab8Q4A5zOMQFfiHQDOYxSB 7sQ7ANzNIAJDEO8A8H7GEBiGeAeA2xlCYCjiHQDezQgCwxHvAPA2AwgMSbwDwJue9D4A4DattVeZ ebm8fXr9Y2ZeLnE/n9ZOEXHqfAUAg/HUChiaJ+8AcMXoAcMT7wAg3IEixDsAR2fsgDLEOwBHZuiA UsQ7AEdl5IByxDsAR2TggJLEOwBHY9yAssQ7AEdi2IDSxDsAR2HUgPLEOwBHYNCAKYh3AGZnzIBp TBPvmafIbMvr1PscAMZQZ8gAzjBNvAPADUYMmI54B2BGBgyYkngHYDbGC5iWeAdgJoYLmJp4B2AW RguYnngHYAYGCzgE8Q5AdcYKOAzxDkBlhgo4FPEOQFVGCjgc8Q5ARQYKOCTxDkA1T3ofANBLa+1V Zl4ub59e/5iZl0vc9zjsFBGnLn9vAIblqRJwaJ68A1CFUQIOT7wDUIFBAgjxDsD4jBHAQrwDMDJD BHCNeAdgVEYI4AbxDsCIDBDAO4h3AEZjfABuId4BGInhAXgP8Q7AKIwOwB3EOwAjMDgAZxDvAPRm bADOtFu8Z54isy2v02p/XQBKE+4A9+DJOwC9GBmAexLvAPRgYAAeQLwDsDfjAvBA4h2APRkWgEcQ 7wDsxagAPJJ4B2APBgVgBeIdgK0ZE4CViHcAtmRIAFYk3gHYihEBWJl4B2ALBgRgA+IdgLU96X0A wKxaa68y83J5+/T6x8y8XOL+Xb/wFBGnre8DoBZPfQA25Mk7AGsxGgAbE+8ArMFgAOxAvAPwWMYC YCfiHYDHMBQAOxLvADyUkQDYmXgH4CEMBEAH4h2A+zIOAJ2IdwDuwzAAdCTeATiXUQDo7I54zz5X ATAa4X4MH3tyB2O7Jd7/p7XWOp0EwGDE3Lx+d+3b3w+/7Q7Dex3v/xzxny0iWsTPIvPU+SwABiHk 5vUsfM4slNNae/WDiH/tfQcA4xFxk/IH3qAun9QOwLsIuImJdwCAeYi3yYl3AIA5CLcDEO8AAPWJ toMQ7wAAtQm2AxHvAAB1ibWDEe8AADUJtQMS7wAA9Yi0gxLvAAC1CLQDE+8AAHVka633DXS2RPrz uIr2176KiMsl7gEA6MxTVTx5BwAoQJQREeIdAGB0goxviHcAgHGJMd4g3gEAxiTEeIt4BwAYjwjj ncQ7AMBYBBi3Eu8AAOMQX7yXeAcAGIPw4k7iHQCgP9HFWcQ7AEBfgouziXcAgH7EFvci3mEHmafI bMvr1PscAMYgtLg38Q4AsD+RxYOIdwCAfQksHky8AwDsR1zxKOIdAGAfwopHE+8AANsTVaxCvAMA bEtQsRrxDgCwHTHFqsQ7AMA2hBSrE+8AAOsTUWxCvAMArEtAsRnxDgCwnmyt9b6ByS2R/jyuov21 ryLicol7AADu4Kknm/PkHQDg8UQTuxDvAACPI5jYjXgHAHg4scSuxDsAwMMIJXYn3gEA7k8k0YV4 BwC4H4FEN+IdAOB84oiuxDsAwHmEEd2JdwCAu4kihiDeAQDeTxAxDPEOAHA7McRQxDtEROYpMtvy OvU+B4AxCCGGI94BAN4mghiSeAcAeJMAYljiHQDgW+KHoYl3AIArwofhiXcAAOFOEeIdADg6wUMZ 4h0AODKxQyniHQA4KqFDOeIdADgikUNJd8T7B32uAgDYjnCnrPfE+4vM/ETAAwAzydZa7xvgUZZP j3keV9F+3cuI+Dwivmytfb37YQAAKxLuTCEzMyL+MiJ+GhEf3vhhAQ8AlCfcmcry6TE/iojPQsAD ABMR7kxJwAMAsxHuTE3AAwCzEO4cgoAHAKoT7hyKgAcAqhLuHJKABwCqEe4cmoAHAKoQ7hACHgAY n3CHawQ8ADAq4Q7vIOABgNFc9D4ARtRa+7q19iwiPoqIT+Mq1l/7MCK+iIgXmfnJEvmwnsxTZLbl dep9DgBjEO7wHgIeABiFcIczCHgAoDfhDvcg4AGAXoQ7PICABwD2JtzhEQQ8ALAX4Q4rEPAAwNaE O6xIwAMAWxHusAEBDwCsTbjDhgQ8ALAW4Q47EPAAwGMJd9iRgAcAHipba71vgMNa4vxHEfFZXIX7 dS8j4vOI+LK19vXetwEAYxHuMAABDwDcRbjDQAQ8AHAb4Q4DEvAAwE3CHQYm4AGA14Q7FCDgAQDh DoUIeAA4LuEOBQl4ADge4Q6FCXgAOA7hDhMQ8AAwP+EOExHwADAv4Q4TEvAAMJ+L3gcA62utfd1a exYRH0XEp3EV6699GBFfRMSLzPxkiXxGknmKzLa8Tr3PAWAMwh0mJuABYB7CHQ5AwANAfcIdDkTA A0Bdwh0OSMADQD3CHQ5MwANAHcIdEPAAUIBwB74h4AFgXMIdeIuAB4DxCHfgVgIeAMYh3IE7CXgA 6E+4A2cT8ADQT7bWet8AFLXE+Y8i4rO4CvfrXkbE5xHxZWvt671vA4DZCHfg0QQ8AGxPuAOrEfAA sB3hDqxOwAPA+oQ7sBkBDwDrEe7A5gQ8ADyecAd2I+AB4OGEO7A7AQ8A9yfcgW4EPACcT7gD3Ql4 ALibcAeGIeAB4HbCHRiOgAeAt130PgCAGzJPkdmW16n3OQCM4UnvAwBe86QdAG4n3IHuBDsA3E24 A90IdgA4n3AHdifYAeD+hDuwG8EOAA8n3IHNCXYAeDzhDmxGsAPAeoQ7sDrBDgDrE+7AagQ7AGxH uAOPJtgBYHvCHXgwwQ4A+8nWWu8bgGIEOwDszxN34GyCHQD6Ee7Ane4I9t9ExN+HYAeATQl34FaC HQDGIdyBt5wR7J9HxK8EOwDsR7gD3xDsADAu4Q4IdgAoQLjDgQl2AKhDuMMBnRnsX7bW/m/v2wCA dxPucCCCHQDqEu5wAIIdAOoT7jAxwQ4A87jofQCwvsz8IDM/iYgXEfFFvBntv4mIv46Ij1prX4j2 AWWeIrMtr1PvcwAYgyfuMBFP2AFgXsIdJiDYAWB+wh0KE+wAcBzCHQoS7ABwPMIdChHsAHBcwh0K EOwAgHCHgZ0R7D+PiF8JdgCYn3CHAQl2AOAm4Q4DEewAwG2EOwxAsAMAdxHu0JFgBwDOla213jfA 4Qh2AOC+PHGHHd0R7L+Nq/+to2AHAN4i3GEHgh0AeCzhDhsS7ADAWoQ7bECwAwBrE+6wIsEOAGxF uMMKBDsAsDXhDo8g2AGAvQh3eADBDgDsTbjDPQh2AKAX4Q5nOCPYfx4RvxTsAMBWhDu8h2AHAEZx 0fsAGFFmfpCZn0TEi4j4It6M9t9GxN9ExB+11n4h2lld5iky2/I69T4HgDF44g7XeMIOAIxKuEMI dgBgfMKdQxPsAEAVwp1DEuwAQDXCnUMR7ABAVcKdQxDsAEB1wp2pCXYAYBbCnSkJdgBgNsKdqQh2 AGBWwp0pZObvRcRlCHYAYFLCnVn8bUT83Y3vE+wAwDSEO7O4uPbt/42Iz0OwU1Vrp4g4db4CgMEI d2b0y9baL3ofAQCwpou7fwoAANCbcAcAgAKEOwAAFCDcAQCgAOEOAAAFCHcAAChAuAMAQAHCHQAA ChDuAABQgHAHAIAChDvAaDJPkdmW16n3OQCMQbgDAEABwh0AAAoQ7gAAUIBwBwCAAoQ7AAAUINwB AKAA4Q4AAAUIdwAAKEC4AwBAAcIdAAAKEO4AAFDAk94HAHBDa6eIOHW+AoDBeOIOAAAFCHcAAChA uAMAQAHCHQAAChDuAABQgHAHAIAChDsAABQg3AEAoADhDgAABQh3AAAoQLgDAEABwh1gNJmnyGzL 69T7HADGINwBAKAA4Q4AAAUIdwAAKEC4AwBAAcIdAAAKEO4AAFCAcAcAgAKEOwAAFCDcAQCgAOEO AAAFCHcAACjgSe8DALihtVNEnDpfAcBgPHEHAIAChDsAABQg3AEAoADhDgAABQh3AAAoQLgDAEAB wh0AAAoQ7gAAUIBwBwCAAoQ7wGAy84PM/G7vOwAYi3BnRh9npn+2KWcJ9r+KiBcR8S+97wFgLOKG Wfzu2re/HxHPxTtV3Aj2Z6eID1vEn0Rmi8xT3+sAGIWwYRbPIuKra++fhnhncDeDPSI+7HwSAAMT NUyhtfYqIi5DvFPAHcH+8o8j/q3PZQCMTNAwDfHO6O4K9oj4NCI++tOI/+hxHwBje9L7AFhTa+1V Zl4ub59e/5iZl0vcw64y84O4+o/Kn8Tbnw7zMiI+j4gvW2tfL79g1/sAqEG4Mx3xzijuHewA8B7C nSmJd3oS7ABsQbgzLfHO3gQ7AFsS7kxNvLMHwQ7AHoQ70xPvbOVasH8WEX9w44cFOwCrEu4cgnhn TYIdgB6EO4ch3nkswQ5AT9la630D7Gr5YkzP49t4j7j6ok3inXcS7ACMQLhzSOKdcyzB/sO4+kOn gh2AroQ7hyXeuY1gB2BEwp1DE+9cJ9gBGJlw5/DEO4IdgAqEO4R4PyrBDkAlwh0W4v04BDsAFQl3 uEa8z02wA1CZcIcbxPt8BDsAMxDu8A7ifQ6CHYCZCHe4hXivS7ADMCPhDu8h3mvJzO9ExGUIdgAm dNH7ABjZEueXcRXrrz2NiOdL1DOAzPxOZv44Il5ExD/Gm9H+MiI+jYiPWmvPSkR75iky2/I69T4H gDE86X0AjK619iozL5e3T69/zExP3jvyhB2AIxHucAbxPhbBDsARCXc4k3jvT7ADcGTCHe5BvPex BPsPI+KnIdgBOCjhDvck3vcj2AHgW8IdHkC8b0uwA8DbhDs8kHhf37Vg/0lE/OGNHxbsAByacIdH EO/rEOwAcDfhDo8k3h9OsAPA+YQ7rEC8349gB4D7E+6wEvF+N8EOAA+XrbXeN8BUMvMiIp7Ht/Ee EfFVRBw23gU7ADyecIcNiPcrgh0A1iPcYSNHjnfBDgDrE+6woaPFu2AHgO0Id9jYEeJdsAPA9oQ7 7GDWeBfsALAf4Q47mSneBTsA7E+4w46qx/sS7H8eET8NwQ4AuxLusLOK8S7YAaA/4Q4dVIl3wQ4A 4xDu0MnI8S7YAWA8wh06Gi3eBTsAjOui9wFwZEucX8ZVrL/2NCKeL1G/i8z8Tmb+RUT8V0T8U7wZ 7S8j4tOI+Ki19ky07yDzFJlteZ16nwPAGJ70PgCOrrX2KjMvl7dPr3/MzE2fvHvCDgB1CHcYwN7x LtgBoB7hDoPYI94FOwDUJdxhIFvFu2AHgPqEOwxmzXi/Fuw/iYjv3vhhwQ4AhQh3GNBj412wA8B8 hDsM6iHxLtgBYF7CHQZ2brwLdgCYn3CHwd0R7z+OiB+EYAeA6Ql3KOA98f5nEfH7N366YAeACQl3 KOKWeL8e7YIdACaWrbXeNwD3kJkXEfE8vo13wQ4AByDcoaDMzIj4h4j47xDsAHAIwh0AAAq46H0A AABwN+EOAAAFCHcAAChAuAMAQAHCHQAAChDuAABQgHAHAIAChDsAABQg3AEAoADhDgAABQh3AAAo QLgDAEABwh0AAAoQ7gAAUIBwBwCAAoQ7AAAUINwBAKAA4Q4AAAUIdwAAKEC4AwBAAcIdAAAKEO4A AFCAcAcAgAKEOwAAFCDcAQCgAOEOAAAFCHcAAChAuAMAQAHCHQAAChDuAABQgHAHAIAChDsAABQg 3AEAoADhDgAABQh3AAAoQLgDAEABwh0AAAoQ7gAAUIBwBwCAAoQ7AAAUINwBAKAA4Q4AAAUIdwAA KEC4AwBAAcIdAAAKEO4AAFCAcAcAgAKEOwAAFCDcAQCgAOEOAAAFCHcAAChAuAMAQAHCHQAAChDu AABQgHAHAIAChDsAABQg3AEAoADhDgAABQh3AAAoQLgDAEABwh0AAAoQ7gAAUMD/A74hlZNVkO8LAAAAAElFTkSuQmCC";
  pez = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAu4AAAIhCAYAAAARoz+rAAAABHNCSVQICAgIfAhkiAAAGVZJREFU eJzt3VvMZXddxvHnjzUqKCZGpBqj4J1VVBBuDKLEc7zwgGggNKJRE8EIBUE5qYmtiUVnBg0eYtSk VYhgRK9ApLFRbk2gSMUL8ZCoIFqgF4oc/Huxd513ZvZ+Z+/97r3W+q31+dwQZt5516o67Zcfz2xb 7z0AAMC0PWrsFwAAAG5OuAMAQAHCHQAAChDuAABQgHAHAIAChDsAABQg3AEAoADhDgAABQh3AAAo QLgDAEABwh0AAAoQ7gAAUIBwBwCAAoQ7AAAUINwBAKAA4Q4AAAUIdwAAKEC4AwBAAcIdAAAKEO4A AFCAcAcAgAKEOwAAFCDcAQCgAOEOAAAFCHcAAChAuAMAQAHCHQAAChDuAABQgHAHAIAChDsAABQg 3AEAoADhDgAABQh3AAAoQLgDAEABwh0AAAoQ7gAAUIBwBwCAAoQ7AAAUINwBAKAA4Q4AAAUIdwAA KEC4AwBAAcIdAAAKEO4AAFCAcAcAgAKEOwAAFCDcAQCgAOEOAAAFCHcAAChAuAMAQAHCHQAAChDu AABQgHAHAIAChDsAABQg3AEAoADhDgAABQh3AAAoQLgDAEABwh0AAAoQ7gAAUIBwBwCAAoQ7AAAU INwBAKAA4Q4AAAUIdwAAKEC4AwBAAcIdAAAKEO4AAFCAcAcAgAKEOwAAFCDcAQCgAOEOAAAFCHcA AChAuAMAQAHCHQAAChDuAAvSWnv62O8AwGGEO8ACtNZuba3dk+Svxn4XAA4j3AFmrLV2S2vtRUn+ LsntY78PAIe7ZewXAOA0Wmtfn+T1SZ409rsAcHEu7gAzs57F3JvkLyPaAWZDuAPMxHWzmOeN/T4A HJepDMAMmMUAzJ+LO0BhO8xiHhj4lQA4EeEOUNAOs5iPJnlRkqcM+mIAnIypDEAxN5nF9CT3Jnl5 7/2D668f8O0AOBXhDlBEa+3WJK/N9j94+kCSF/be3zncWwEwFFMZgInbZxYj2gHmy8UdYMJ2+LSY e3JmFgPAfAl3gAkyiwHgeqYyABNiFgPANi7uABNhFgPAeYQ7wMjMYgDYhakMwEjMYgDYh4s7wAjM YgDYl3AHGJBZDACHMpUBGIBZDAAX5eIOcGJmMQAcg3AHOBGzGACOyVQG4MjMYgA4BRd3gCPaYRZz b5KXmcUAsC/hDnAEZjEAnJqpDMAFmMUAMBQXd4ADmcUAMCThDrAnsxgAxmAqA7CjHWcxL45ZDAAn 4OIOsAOzGADGJtwBzmEWA8BUmMoAbGAWA8DUuLgDXMcsBoApEu4Aa2YxAEyZqQyweGYxAFTg4g4s mlkMAFUId2CRzGIAqMZUBlgUsxgAqnJxBxbDLAaAyoQ7MHs7zmJ+ovf+V8O9FQDsx1QGmK0dZjEP 5+osRrQDMGku7sAsmcUAMDfCHZgVsxgA5spUBpgFsxgA5s7FHSjPLAaAJRDuQFlmMQAsiakMUI5Z DABL5OIOlLLjLOblvfcPDPdWAHB6wh0oYYdZzHuSvNCFHYC5MpUBJm2PWcyTRTsAc+biDkyWWQwA XCXcgckxiwGAG5nKAJNhFgMA27m4A5NgFgMA5xPuwKjMYgBgN6YywCjMYgBgPy7uwODMYgBgf8Id GIxZDAAczlQGODmzGACmorX2na217x/7PQ7h4g6c1A6zmN9P8jKzGABOqbX2lUkuJXlakieM+zaH cXEHTqK1dmtr7d4kf5nN0f6eJM/ovd8u2gE4ldbaF7TWfivJu5J8S5LLvfePjvxaB2m997HfASiu tfbFSW5L8hVn/vWrkzx6w5c/nORnk7y+9/7JwV5ywVpr1/+N/vG9938f5WUABtJa+4wkL0ryqiSP Xf/wh5M8off+8GgvdgGmMsDOtgT6bUk+d8dvYRYzDf/cWvuDrK5OfzP2ywAcW2vte7P6MIQvu+6n LlWN9sTFHdjgCIF+PZ8WM6INF/ez3p7kcpI/6/6BABTXWvuarP6e9o0bfrr0tT0R7rBoJwj06/1n kl+IWcyoWmt3JfnRJI8758sezOofdr/fe//YIC8GcCSttccnuTPJD2f7n+F8Te/9zuHe6viEOyzA AIH+0azC771n/vW9vfd/OdL354Jaa5+Z5PasPnbztnO+9ENJfiOr/7BlBw9M2nrH/uKsduyfc86X PpTkiZWv7Ylwh1kR6NxMa60l+bYkL8nq0xW2+Z8kdvDAZJ2zY9+k/LU9Ee5QkkDnGFprT0pyR5Ln JvmMc77UDh6YjPWO/UqSb9jxl8zi2p4Id5i0gQP9/yNdoC/Lehv6giQ/Hjt4YKJ22LE/nORXszpI PObMj8/i2p4Id5gEgc4U2MEDU7TDjv1/k/xOklcn+bGsPhThEbO5tifCHQY1UKBfM29J8qBAZx92 8MBU7LBj/4skd/Te391ae2ySf0jyeWd+fjbX9kS4w0kIdOZijx38nye5FDt44Ah22LH/fVb/D/3e cubXvDozvrYnwh0uZIBA/0hu/EOiAp3B2cEDQ1j/veauJD+U7Tv2O5O8rvf+8TO/bvbX9kS4w05G CvT39t7/9UjfH47igB38r/fePzjEuwF17bNj3/Rna5ZwbU+EO1xDoMNu7OCBY2mtPSvJ3dlhx77l 1y/i2p4IdxZq4EA/+ykuAp3ZsYMHDnHIjn3L91nEtT0R7sycQIfh2MEDuzh0x77ley3m2p4Id2Zi oEC/5g+IRqDDRnbwwCYX3bFv+Z6LubYnwp1iRgj0Rz7FRaDDnuzggUesd+yvTfLELV9y7o59y/dc 1LU9Ee5MlECHebGDh2VqrT05q2nchXbsW773oq7tiXBnZAME+oez+VNc/u1I3x/Yw547+CtJ7rWD h3qOuWPf8v0Xd21PhDsjaa09L8nrcu1vuIsQ6FCIHTzM03rHfkeSV+ZIO/Ytz1nctT0R7gystXZL kl9O8qIDv8XZQD/7h0QFOhS05w7+DUku2cHDNJ1ix77lOYu8tifCnQG11h6X5A+TPHOHLxfosDB2 8FDTKXfsW563yGt7ItwZSGvtKUnekuRLrvupjyX56wh0YM0OHmo49Y59yzMXe21PhDsDaK3dnuS3 knzWdT/1j0m+p/f+rsFfCpg8O3iYpqF27FuevdhreyLcOaGb7NnvS/IDvff/HPatgGoO2MFf7r2/ Z4h3g6UZase+5dmLvrYnwp0Tucme/VeS/HTv/VPDvhVQnR08jGO9Y7+S5BlbvuSoO/Yt77Doa3si 3DmBc/bs/53kR3rvbxj+rYA5sYOHYbTWbs1qp37ejv2uJFeOtWPf8h6Lv7Ynwp0js2cHhmQHD6cx 5o59y/ss/tqeCHeOxJ4dGJMdPBzPmDv2Le/j2r4m3Lkwe3ZgSvbcwV9O8jY7eJjGjn0T1/arhDsX Ys8OTNUeO/i/zSrg7eBZpPWO/a4kz8+IO/ZNXNuvJdw5mD07UIEdPGw2tR37Jq7t1xLu7M2eHajI Dh6uaq19X5K7s33Hfn+SFw+1Y9/Etf1Gwp292LMDc2AHz1JNdce+iWv7jYQ7O7NnB+bGDp6lmPKO fRPX9s2EOzuxZwfmbI8d/H9ktYN/vR08FVTYsW/i2r6ZcOdc9uzAktjBMycVduybuLZvJ9zZyp4d WLI9dvDvSHIpdvBMxHraejkFduybuLZvJ9zZyJ4dYMUOniqq7dg3cW0/n3DnBvbs12qt3dZ7f3Ds 9wDGZQfPVK137C9J8ooU2rFv4tp+vk3/aYyFaq3d0lq7kuSe3Bjt9yV56gKj/eeTvHu9EwQWrPf+ sd77byf5yiTfkdVHRW7y+Ulek+SfWmu/u57cwEms//n0viS/mM3Rfn+Sp/Tef6xAtD82q3naWZdF +1Uu7iSxZ99kHe0/t/63n0zynN77H433RsDU2MEzlh127O9P8lNT3bFv4tp+c8Ide/YNWmu3JXl3 klvO/LB4Bzayg2coc9ixb2LbvhvhvnD27Nut/+vHN0a8Azuyg+dUzuzYX5nkszd8SZkd+yau7bsR 7gvl89l3I96BQ/g8eI5p/c+i1yZ5wpYvuT8T/Dz2Xbm27064L5A9+37EO3ARdvAcaj1lvZLk67d8 Sbkd+yau7bsT7gtjz34Y8Q5c1J47+CtJ7rGDX6b1jv0Xk/xgZrRj38S1fT/CfUHs2S9GvAPHYAfP Nuv/27gjM92xb+Lavh/hvgD27Mcj3oFjsYPnrNbas5PcnZnu2Ddxbd+fcJ85e/bjE+/AsdnBL9dS duybuLbvT7jPmD376Yh34BQO2MHf23v/7yHejeNa0o59E9f2wwj3mbJnPz3xDpyKHfx8LXHHvolr +2GE+8zYsw9LvAOntOcO/o1JLtnBT9cSd+ybuLYfTrjPiD37OMQ7MAQ7+LqWvGPfxLX9cMJ9JuzZ xyXegaHYwdexx479db33/xny3cbi2n4xwn0G7NmnQbwDQ7KDn671/25ekuQV2b5j/90kr5rzjn0T 1/aLEe6F2bNPj3gHhrbHDv7jufp58A8M8W5LZMe+nWv7xQn3ouzZp0u8A2Oxgx9Pa+1rk1yOHftW ru0XJ9wLsmefPvEOjMkOfjittS/Maqf+/CRtw5csbse+iWv7cQj3YuzZ6xDvwNgO2MH/eu/9A0O8 W3V27PtxbT8O4V6EPXtN4h2YAjv449pxx36HY9qKa/vxCPcC7NlrE+/AlOy5g7+c5K128CvrHfuV JE/f8iWL37Fv4tp+PMJ94uzZ50G8A1Ozxw7+fVkF/GJ38Osd+yOfx27HvgfX9uMS7hNmzz4v4h2Y oj138L+Z1efBL2IHb8d+ca7txyXcJ8iefb7EOzBVdvDXaq19f5Jfih37wVzbj0+4T4w9+/yJd2Dq lryD33HH/rLe+x8P91Y1ubYfn3CfEHv25RDvQAVL2sHbsR+Xa/tpCPeJsGdfHvEOVDHnHfweO/ZX 994/OOS7VebafhrCfWT27Msm3oFK5raDX+/Y707ypVu+5P7Yse/Ntf10hPuI7NlJxDtQ0x47+PuS XMqEdvB27Kfl2n46wn0k9uycJd6Bqirt4O3YT8+1/bSE+wjs2dlEvAOVTXkHv363lyb5mdixn5Rr +2kJ9wHZs3Mz4h2obmo7eDv24bi2n55wH4g9O7sS78BcjLmDt2Mfnmv76Qn3Adizsy/xDszJkDt4 O/ZxuLYPQ7ifmD07hxLvwNyccgdvxz4u1/ZhCPcTsWfnGMQ7MEfH3sHbsY/LtX04wv0E7Nk5JvEO zNlFdvCttadmNa2xYx+Ra/twhPuR2bNzCuIdmLs9d/C/luRpsWMfnWv7sIT7Edmzc0rnxPtze+9v HuetAI5rjx38JnbsA3NtH5ZwPwJ7doayJd4/1Xu/ZcsvAShpjx38I+6PHfugXNuH96ixX6C69Z79 7dkc7b+S5NtEO8eynsU857of/rQx3gXglPrK23rv35rkq5L8XpJNs5f3J3lW7/2Zon1wP5lro/2h JL860rssgov7BdizM5bW2jW/cXvvmzaeALNyZgf/gqz+IOudsWMfhWv7OIT7gezZGZNwB5astfbo JI/pvX9o7HdZKtv2cZjK7Km1dktr7UqSe3JjtN+X5KmiHQBOp/f+X6J9POtr+x3X/fBl0X56wn0P 9uwAALbtY/FJFDuyZwcAls61fVwu7jtY79nfmRuj/R+TfJ1oBwAWwrV9RML9HPbsAAArru3jE+5b 2LMDAFzDtX1kNu4b2LMDAFzl2j4NLu7XsWcHALiBa/sECPc1e3YAgBu5tk+HcI89OwDAOVzbJ2Lx G3d7dgCAzVzbp2XRF3d7dgCAc7m2T8giw92eHQDgfK7t07O4cLdnBwDYiWv7xCxq427PDgBwc67t 07SYi3tr7XmxZwcA2IVr+wTNPtxba5/WWruU5N7cuGdPkgeSfFFr7dOHfTMAgOlxbZ+u1nsf+x1O prX2qCRvSvKsHb78I0n+JMmbk/x57/0Tp3w3uIjW2jW/cXvvbax3AWBeWmuvTvILZ37ooSRPFO7j m3W4J8n6kv7NSZ6d5Lty7X/ts42IZ9KEOwCnsL62/0Ou7aXX9N7vHOmVOGP24X7WOuK/KauI/+6I eIoS7gCcgmv7tC0q3M86MOI/nORPI+IZmXAH4Nhc26dvseF+1gUj/k1J3iHiGZJwB+DYXNunT7hf R8RTgXAH4Jhc22sQ7ue4QMQ/sokX8ZyEcAfgmFzbaxDuOxLxTIlwB+BYXNvrEO4HEPGMTbgDcCyu 7XUI9wsS8YxBuANwDK7ttQj3IxLxDEW4A3AMru21CPcTuWDEvynJfSKebYQ7ABfl2l6PcB+AiOfY hDsAF+XaXo9wH9gFIv4tWc1pRDzCHYALcW2vSbiP6MCIfyhXN/EifqGEOwAX4dpek3CfCBHPPoQ7 AIdyba9LuE+QiOdmhDsAh3Jtr0u4T5yIZxPhDsAhXNtrqxfu1wXL3i4aOCM+v7X26W9NPv7mrKr8 oR1+zV1JXnmk569fYrH/85/S86//Jju/1Ez++j3f8z3f8z3/sOcffG2fyV9/dY8a+wXYXe/9E9+e 5HeSfCDJW5P8cM4/wX/PEC8GAFRxX5K/OPPvL5nI1OHiPoPnfyKr34XXX+K/PMmDAzx/L57v+Z7v +Z7v+Z4/+vNba89M8tIkz90p3Gf211+VcJ/Z889G/G1Z/Y4c8vk35fme7/me7/me7/meX+35E1Ev 3AEAYIFs3AEAoADhDgAABQh3AAAoQLgDAEABwh0AAAoQ7gAAUIBwBwCAAoQ7AAAUINwBAKAA4Q4A AAUIdwAAKEC4AwBAAcIdAAAKEO4AAFCAcAcAgAKEOwAAFCDcAQCgAOEOAAAFCHcAAChAuAMAQAHC HQAAChDuAABQgHAHAIAChDsAABQg3AEAoADhDgAABQh3AAAoQLgDAEABwh0AAAoQ7gAAUIBwBwCA AoQ7AAAUINwBAKAA4Q4AAAUIdwAAKEC4AwBAAcIdAAAKEO4AAFCAcAcAgAKEOwAAFCDcAQCgAOEO AAAFCHcAAChAuAMAQAHCHQAAChDuAABQgHAHAIAChDsAABQg3AEAoADhDgAABQh3AAAoQLgDAEAB wh0AAAoQ7gAAUIBwBwCAAoQ7AAAUINwBAKAA4Q4AAAUIdwAAKEC4AwBAAcIdAAAKEO4AAFCAcAcA gAKEOwAAFCDcAQCgAOEOAAAFCHcAAChAuAMAQAHCHQAAChDuAABQgHAHAIAChDsAABQg3AEAoADh DgAABQh3AAAoQLgDAEABwh0AAAoQ7gAAUIBwBwCAAoQ7AAAUINwBAKAA4Q4AAAUIdwAAKEC4AwBA AcIdAAAKEO4AAFCAcAcAgAKEOwAAFCDcAQCgAOEOAAAFCHcAAChAuAMAQAHCHQAAChDuAABQgHAH AIAChDsAABQg3AEAoADhDgAABQh3AAAoQLgDAEABwh0AAAoQ7gAAUIBwBwCAAoQ7AAAUINwBAKAA 4Q4AAAUIdwAAKEC4AwBAAcIdAAAKEO4AAFCAcAcAgAKEOwAAFCDcAQCgAOEOAAAFCHcAAChAuAMA QAHCHQAAChDuAABQgHAHAIAChDsAABQg3AEAoADhDgAABQh3AAAoQLgDAEABwh0AAAoQ7gAAUIBw BwCAAoQ7AAAUINwBAKAA4Q4AAAUIdwAAKEC4AwBAAcIdAAAKEO4AAFCAcAcAgAKEOwAAFCDcAQCg AOEOAAAFCHcAAChAuAMAQAHCHQAAChDuAABQgHAHAIAChDsAABQg3AEAoADhDgAABQh3AAAoQLgD AEABwh0AAAoQ7gAAUIBwBwCAAoQ7AAAUINwBAKAA4Q4AAAUIdwAAKEC4AwBAAcIdAAAKEO4AAFCA cAcAgAKEOwAAFCDcAQCgAOEOAAAFCHcAAChAuAMAQAHCHQAAChDuAABQgHAHAIAChDsAABQg3AEA oADhDgAABQh3AAAoQLgDAEABwh0AAAoQ7gAAUIBwBwCAAoQ7AAAUINwBAKAA4Q4AAAUIdwAAKEC4 AwBAAcIdAAAKEO4AAFCAcAcAgAKEOwAAFCDcAQCgAOEOAAAFCHcAAChAuAMAQAHCHQAAChDuAABQ gHAHAIAChDsAABQg3AEAoADhDgAABQh3AAAoQLgDAEABwh0AAAoQ7gAAUIBwBwCAAoQ7AAAUINwB AKAA4Q4AAAUIdwAAKEC4AwBAAcIdAAAKEO4AAFCAcAcAgAKEOwAAFCDcAQCgAOEOAAAFCHcAAChA uAMAQAHCHQAAChDuAABQgHAHAIAChDsAABQg3AEAoADhDgAABQh3AAAoQLgDAEABwh0AAAoQ7gAA UIBwBwCAAoQ7AAAUINwBAKAA4Q4AAAUIdwAAKEC4AwBAAcIdAAAKEO4AAFCAcAcAgAKEOwAAFCDc AQCgAOEOAAAFCHcAAChAuAMAQAHCHQAAChDuAABQgHAHAIAChDsAABQg3AEAoADhDgAABQh3AAAo QLgDAEABwh0AAAoQ7gAAUIBwBwCAAoQ7AAAUINwBAKAA4Q4AAAUIdwAAKEC4AwBAAcIdAAAKEO4A AFCAcAcAgAKEOwAAFCDcAQCgAOEOAAAFCHcAAChAuAMAQAHCHQAAChDuAABQgHAHAIAChDsAABQg 3AEAoADhDgAABQh3AAAoQLgDAEABwh0AAAoQ7gAAUIBwBwCAAoQ7AAAUINwBAKAA4Q4AAAUIdwAA KEC4AwBAAcIdAAAKEO4AAFCAcAcAgAKEOwAAFCDcAQCgAOEOAAAF/B+v+LzT3CSw9gAAAABJRU5E rkJggg== ";
  basicas = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAu4AAAIhCAYAAAARoz+rAAAABHNCSVQICAgIfAhkiAAAIABJREFU eJzt3V2oZelZJ/D/W12SIInBxKA0ySAhkRBGjJLEYSZIgsHYNzOBicEOClb6VHUlczNeylzkRBgQ vNC56a+qtsTRtDMJTDsI0dDQYUhm1DRjJBBCHCR+0IjOJDPahIS0/c7F2tuzT9U+n/vjXe9avx8c 7L092fXUXms9z/+8Z9V+S601AADAuF1pXQAAAHA2wR0AADoguAMAQAcEdwAA6IDgDgAAHRDcAQCg A4I7AAB0QHAHAIAOCO4AANABwR0AADoguAMAQAcEdwAA6IDgDgAAHRDcAQCgA4I7AAB0QHAHAIAO CO4AANABwR0AADoguAMAQAcEdwAA6IDgDgAAHRDcAQCgA4I7AAB0QHAHAIAOCO4AANABwR0AADog uAMAQAcEdwAA6IDgDgAAHRDcAQCgA4I7AAB0QHAHAIAOCO4AANABwR0AADoguAMAQAcEdwAA6IDg DgAAHRDcAQCgA4I7AAB0QHAHAIAOCO4AANABwR0AADoguAMAQAcEdwAA6IDgDgAAHRDcAQCgA4I7 AAB0QHAHAIAOCO4AANABwR0AADoguAMAQAcEdwAA6IDgDgAAHRDcAQCgA4I7TZRSPti6BgCAngju tPIbpZSfbl0EAEAvBHdauS/Jb5ZSPtC6EACAHlxtXQCzdl+S3yqlvFRr/WTrYtieUkptXcM5/UOS B2utn2hdCACcxYo7rV1N8lQp5f2tC2GW7kvycecfMAullJTyZEo5bF0KlyO4T1UphymlLr4OW5dz BuGdlpx/wPSVUpLcSvKhJB/tIBuwhuDOWAhPtOT8A6ZrCO1PJHlo5dnXN6qGDbjHnTFZhqe4531a aq2ldQ13W4T0p3LUB51/wPQchfaDlWefTHK9TUFswoo7Y2Plk71YhPMHk7y48rTzD5iOIbQ/nuOh /XaS66m1lw8RYIXgzlgIT+yd8A5M1hDaH8vxlfXbSW4I7f0S3BkL4YkmhHdgcobQ/miSGyvP3orQ 3j3BnVEQnmjJ+QdMxhDaH0ny8MqzTyR5WGjvn+DOaAhPtOT8AybiJ5LcXHn8eJKbQvs0CO6MivBE S84/oHu1/n6SX1g8eizJh4X26fBxkIxOrfWTw2/6fFQf++f8A7pX6y+llD9O8mmhfVqsuDNKVj5p yfkHdK/W3xfap0dwZ7SEJ1py/gEwNsUPY7RQSjl24p22s+aaHS6TIUw96LaFcbrI8R075x8AY2HF ndGz8klLzj8AxkJwpwvCEy05/wAYA8GdbghPtOT8A5pbfOQV8yW40xXhiZacf0AzpVxJ8mRK+ZXW pdCOz3GnOz5nm5acf8DeDaH9dpJri8dJrT/ftCaasOJOl6x80pLzD9ibu0P74FVum5knwZ1uCU+0 5PwDdm59aL+T5MDmSvMkuNM14YmWnH/Azpwe2l9qUxStCe50T3iiJecfsHVCOycQ3JkE4YmWnH/A 1gjtnEJwZzKEJ1py/gEbE9o5g+A+VaUcppS6+DpsXc6+CE+05PwDNvSeCO2cQnBncoQnWnL+AZdW 66eTLD+fXWjnHjZgYpJskkNLzj/g0mr91ZTypSTPCO3czYo7k2Xlk5acf8Cl1fppoZ11BHcmTXii JecfANskuDN5whMtOf8A2BbBnVkQnmjJ+QfANgjuzIbwREvOPwA2JbgzK8ITLTn/YMZKubLYYAku zQnE7AhPtOT8gxk62hH1tvDOJnyOO7Pkc7ZpyfkHM3IU2q+tPGdjJS7FT33MVs8rn6WUD7augc30 fP4B57QutMMGSq21dQ3MUCnl2IlXay0Na3l/jq98JkOYenCsK5+llBeT/Eyt9bdb17LOmI7v2PV4 /gHnsD6030litZ1Ls+LO7HW68nlfkt8spXygdSFsptPzDziN0M6OuMd94u5e+WS9M+45LrXWTzQr 7mT3JfmtUspLVmb75p53mBChnR1yq8zE9RLcx3IrxQm3LfxDrXVUP+TedVxHd1uFW2Uux20z0Dmh nR1zqwysWLltYdV9LWq5ALdVTITbZqBjQjt7YMV94qy4X87YV4xPOK6jWZkd+/s3dlbeoUOl/FiS zyRZ9juhna0T3GGNsQfPU34gG0W4G/v71wPhHTpUyocyrLr/eoR2dkBwhzXGHjzP+E1K83A39vev F8I7dGhYef+s0M4uCO6wxtiD55rg/mJGFO7G/v71RHgHYMk/ToVp8A8aJ8o/WAVgSXCHCRDups3x BSAR3GEyhLtpc3wBENynqpTDlFIXX4ety2E/hLtpc3wB5k1wh4kR7qbN8YUGSrmSUka1gzbzJLjD BAl30+b4wh4d7Yj6lPBOa05AmKha6ydLKcnxjxJchrv4KMG+Ob6wB0eh/drKcw+m1hdP/N/ADllx hwmzMjttji/s0LrQnvx9Ehsr0YzgDhMn3E2b4ws7sD6030lyYEdUWhLcYQaEu2lzfGGLhHZGTHCH mRDups3xhS0Q2hk5wR1mRLibNscXNiC00wHBHWZGuJs2xxcuQWinE4I7zJBwN22OL1zY25L87Mpj oZ1REtxhpoS7aXN84QJq/aMcXS9CO6NVaq2ta4DRKaUcuzBqraVVLetss75FiFvdxCcZhteDl93E Z+zv35zs4vjCZJXyjiTPCe2MleAOa4w9eG67vm2Hu7G/f3MjvANMg1tlALdVTJzjCzANgjuQRLib OscXoH+CO/CPhLtpc3wB+ia4A8cId9Pm+AL0S3AH7iHcTZvjy6yUciWlvKx1GbANgjuwlnA3bY4v s3C0I+rvpJSXty4HNiW4AycS7qbN8WXSjkL7tSTvTfK0lXd6J7gDpxLups3xZZKOh/al55N8u01B sB2CO3Am4W7aHF8mZX1ov5PkwI6o9E5wB85FuJs2x5dJENqZOMF9qko5TCl18XXYuhymQbibNseX rgntzIDgDlyIcDdtji9dEtqZiautCwD6U2v9ZCklSZ7KUR9ZhrtmdbEdZx3fRbiHcRDamREr7sCl nLYy26YitsnKOx35wSQfXHkstDNZgjtwaaeEOyZAeKcLtf5Jkvcl+VaEdibOgAU2csJtFUyE22bo Qq2/l1J+NMkXhXamzJCduMXdxh9NKR9tW8npaq1ujF617U8Cuujr1Xqh76/JP/3F5L98LPnXL637 Td7df/4FX3/X9Xv9M759/fG9eiX5T79XymM/mfztJq+/8/eHSSml1DO+YU+VTIP525dS6+nnP50a BuFHe7kax9Y47h4Me6/vjMF0dzFn1nfWoLvbRf++i9dfd19Fktzzh1/y9c/N6+/k9e8+vh9NcrjF 1z+3kfUL9uvM4M6FjG3+cjor7tChsTba5U3P68I7/Vs9vv8uJ4R2AHZGcIdx+tjIX+/E139/ki8l b7nrtopN//y91e/1T3/99yd5RfLae26P2dLrA3Ayt8pM1eJWmcWjj43tntDmt6KcYez19aCU8oEk H09yn/cP2Bb9eTPev775OEhgJ2qt/znJzyT5h9a1AJ0q5UpK+c7WZcBYWHGnibH/xD/2+npSSvlg rfXjresAOnO0I+qbkjyQWl8YntafN+H965vgThNjbxxjrw9g0o5C+7XFM59N8t7U+g39eTPev765 VQYAGI97Q3uS/GmSb7YpCMZDcAcAxmF9aL+T5MCOqCC4AwBjILTDmQR3AKAtoR3ORXAHANoR2uHc BHcAoA2hHS5EcAcAWvmBJD+18lhoh1MI7gBAG7V+OckDSV6I0A5nsgETTYx9A4ix1wcwKaW8OclX zhPa9efNeP/6JrjTxNgbx9jrA5gr/Xkz3r++uVVmqko5TCl18XXYuhwAADYjuAMAQAcEdwAA6IDg DgAAHRDcAYDtK+VKSvmu1mXAlAjuAMB2He2I+pmU8urW5cBUCO4AwPYchfZrSX44yTNW3mE7BHcA YDuOh/alL2TYGRXYkOAOAGxufWi/k+TgPDuiAmcT3AGAzQjtsBeCOwBweUI77I3gDgBcjtAOe1Vq ra1rYIZKKcdOvFpraVXLOmOvD6C5RqFdf96M969vVtwBgMv4/iTvW3lspR12THAHAC6u1j9L8p4k X4/QDnvhVhmaGPuv6sZeH8BolPKGJF/dV2jXnzfj/eub4E4TY28cY68PYK705814//rmVhkAAOiA 4A4AAB0Q3AEAoAOCOwAAdEBwBwCOK+VKSnl16zKA4wR3AODI0Y6on0sp39e6HOCI4A4ADI5C+7Uk b07yrJV3GA/BfapKOUwpdfF12LocAEbueGhf+h9J/m+bgvpUSqmrX63rYVoEdwCYu/Wh/U6Sg33t iAqcTXAHgDkT2qEbgjsAzJXQDl0R3AFgjoR26I7gDgBzI7RDlwR3AJif+5M8sPJYaIcOCO4AMDe1 /lWSdyf56wjt0I2rrQsAABqo9csp5e1JnhfaoQ+COwDM1bDyDnTCrTIAANABwR0AADpQaq2ta2CG SinHTrxaa2lVyzpjrw9grsben9XHLllxBwCADgjuADAlpZSU8prWZQDbJ7gDwFSUUpI8kuQPUsrr WpcDbJfgDgBTMIT2R5PcTPLGJM9aeYdp8TnuANC7IbQ/luTGyrPPJPlam4KAXRDcAaBnQ2h/PMn1 lWcfT/KR+Og4mBS3ygBAr9aH9ieSfFhoh+mx4g4APRpC+xNJDlaevZXkptAO0yS4A0BvhtB+K8lD K8/eSvKw0A7TJbgDQE+G0H47yYdWnr0doR0mzz3uANCX1yb58ZXHTya5IbTD9AnuU1XKYUqpi6/D 1uUAsCW1/k2SdyX58yS/luS60A7z4FYZAOhNrV9NKe9I8rdCO8yH4A4APRpW3oEZcasMAAB0QHAH AIAOCO4AANABwR0AADoguAPAWJRSUsr3ti4DGCfBHQDGYNgR9ZEkz6WUN7YuBxgfwR0AWhtC+6NJ biZ5XZJnrbwDd/M57gDQ0hDaH0tyY+XZ303ic9qBYwR3AGhlCO2PJ7m+8uzjST5iR1TgbkVfoIVS yrETr9ZaWtWyztjrAyZgCO1PJDlYefaJJDeF9pONvT+rj12y4g4A+zaE9ltJHlp59laEduAUgjuj cPcKAMDE3U7yobsePyy0T4/5xjb5VBkA2L+/XPnvJ5PcENqBs1hxB4B9q/UwpSTJ65NcF9rPzz3Z zJl/nEoTvf3q0KAA4DzMN3ZJcAcAgA64xx0AADoguAMAQAcEdwAA6IDgDgAAHRDcAQCgA4I7AAB0 QHAHAIAOCO4AANABwR0AADoguAMAQAcEdwAA6IDgDgAAHRDcAQCgA4I7AAB0QHAHAIAOCO4AANAB wR0AADoguAMAQAcEdwAA6IDgDgAAHRDcAQCgA4I7AAB0QHAHAIAOCO4AANABwR0AADoguAMAQAcE dwAA6IDgDgAAHRDcAQCgA4I7AAB0QHAHAIAOCO4AANABwR3OUEr5YOsaAAAEdzhFKeWnk/xG6zoA AAR3OEEp5QNJfjPJfa1rAQAQ3GGNUsr7k/xWhHYAYCTGH9xLOUwpT6aU0roU5mER2p9KcrV1LV0q pSyu2cPWpTBz5gf0xfw407iDyXDgPrp4VFPK9dRaG1bEthw/th9LrYftijkitG9oCEi3knxo8Thj ObbMjPkBfTE/zmXsK+6vX/nvh5I8YeWEXRHaNzRcm09kuFaXXn/Cd8OumR/QC/Pj3MYe3A+SPHnX Y82XrRPaN3TUdA9Wnn3yrsewT+YH9MD8uJBxB/fh15rXk9xeefYgyeOaL9sitG9ouBYfz/EmezuJ WxNox/yA8TM/LmzcwT1ZNt8bOd58ryd5TPNlUyeE9hcbldOf4Rp8LMM1uXQ7yQ1Nl+bMDxgv8+NS xh/ck9Xme2vl2RtJHtV8uaxTQvuDbSrqzHDtPZrhWly6FU2XMTE/YHzMj0vrI7gny+b7cIb7oJYe TvKI5stFnRbaa62fbFNVR4Zr7pEM1+DSE0ke1nQZHfMDxsP82Eg/wT1ZNt+bGe6HWrqZ5CfaFESP hPat+IkM197S40luarqMlvkBY2F+bKCv4J4sm++HM9wXlSS/kFp/v2FFdERo35LhmvuFxaPHknxY 02X0zA9oz/zYSJ+folFrTSkfSfK0pst5Ce1bVusvpZQ/TvJpTZdumB/QnvlxaX0G92S5cqLpci5C +44IPvTI/ID2zI9L6e9WGbggoR0AmILiNxRM2WVDeynl2IVRa/XJEwBAU1bcmSwr7QDAlAjuTJLQ DgBMzXyCu002ZkNo35BrBY5zTcD5uFZ2bh7BvZRfSfJkSpnH33fGhPYNDdfIk4trBjA/4HzMj73o 9+Mgz2s4gf7tyuOD1PpSu4LYFaF9Q0PTvZ3k2uJxUuvPN60JWjI/4HzMj72Z9grC8CubV608cy3J bSsn0yO0b+jupjt4lV97MlvmB5yP+bFX025Aw2ddHiS5s/Ks5jsxQvuG1jfdO0kO7GjHbJkfcDbz Y++m33yGX2tqvhMltG/o9KbrlgDmzfyAk5kfTcyj8Wi+kyS0b0jThbOZH3Av86OZ+TQdzXdShPYN abpwfuYHHDE/mppXw9F8J0Fo35CmCxdnfoD5MQLzazYnN9/3tClopko5TCl18XV4/v+Z0L4F74mm CxdnfoD50dj8gnuyrvn+fGr9dMOKOAehfUuGc335+bqaLlyE+cGcmR/NTX8DppPU+lJKOUjy25ru +AntW1brr6aULyV5RtOFCzI/mDPzo6n5BvdkuXKi6Y6c0L4jAgdcnvnBnJkfzczzVhm6IbQDAAwE d0ZLaAcAOCK4M0pCOwDAcYI7oyO0AwDcS3A/r1Ku2GRj94T2DTlPYXxcl/TAedoFB+g8jnYKs0Pe DgntG3Kewvi4LumB87Qb8/44yPNYt71vKTYc2DKhfUPOUxgf1yU9cJ52xU9VF3ctfiLdql9M3hKh /fLWNV1gjMwPxsX86E6ptbauYfzWn9i2+t2Csa60l1KOXRi11tKqllM5N2HcXKOMlXOzS37qP4/h BD7IcEIvWTnZ0FhDezc0XRg/84MxMj+6ZcX9IpzoW1NKeUuSP8lIQ/voV9ydi9AX1yxj4Vzsmp/2 L8LKydbUWr+U5N+vPDWa0D56mi70x/xgDMyP7mkWF6X5bk2t9TDJxyK0n5+mC/0yP2jJ/JgEt8pc 1r0XQE3yrtT639oV1adSylsWK/CjMdpbZUr5sSSfSbKsR9OF3pgftGB+TIKf8C/r+MpJzXDya7qX MLbQPmrDOXaQ4ZzTdKFH5gctmB+TYMV9U8PKyTs13WkZ7Yr70rBy8llNFzpmftCC+dE1wR3WGH1w BwBmx60yAADQAcEdAAA6ILgDAEAHBHfaKOUwpdTF12HrcgAAxk5w36dSrtpkgxOVciWlXG1dBjBC 5genMT9mQxPYl+GCeip2yGOdow1ZntJ8gWPMD05jfsyKA7wPR033/SvP2fiAwbptqEt5MLW+2Kwm YBzMD05jfsyOn9z346Ukf7/y+FqsnJCsb7rDuWIoA4n5wUnMj1ly4e/D8e2tlzTfuVvfdG1DDRwx P1jH/JgtF/2+aL6s0nSB8zI/WGV+zJoLfp80XxJNF7g484PE/EBw3zvNd940XeCyzI95Mz+I4N6G 5jtPmi6wKfNjnswPFlzkraxvvj+b5G1tCmIP3pbhGC9pusDFmR9zZH6QRHBv63jzfTHJg6n1j9oW xc4Mx/bBDMda0wUuz/yYF/ODhVJrbV0Dw6/A3qbpjkcp5diFUWstW3zxdyR5TtMFNmZ+zIv5MXuC O6yx0+AOAHAJbpUBAIAOCO4AANABwR0AADoguAMAQAcE996U8jKbbIxQKVdSystalwFwIvNjnMwP LsAF3JNSXp7kd2KHvHE52tHudxbHCGBczI9xMj+4oKutC+Cchp/Gn07y3pXnbMDQ2r3bUD+dUv5V av1Ww6oAjpgf42R+cAl+6u7Ht5M8v/L4WqyctHVv002GY/TtNgUBrGV+jI35wSW5aHtxfHvrJc23 lfVN1zbUwPiYH+NifrABF2xPNN9x0HSB3pgf42B+sCEXa2+m0nxLOUwpdfF12Lqcc9N0gV5NZX70 yvxgC1yoPdJ829B0gd6ZH22YH2yJi7RXmu9+abrAVJgf+2V+sEUu0J6tb74fTPKDbQqatB/M8N4u abpAv8yPfTI/2BrBvXfHm++3krwvtf5J26ImaHhP35fhPdZ0gf6ZH/thfrBFNmCaglpfSikHSf6D prtDtf5eSvnRJF/UdIFJMD/2w/xgSwT3qRgagaa7awYbMDXmx36YH2yBW2UAAKADVtxhjVpraV0D AMAqK+4AANABwR0AADoguM9RKd9pk40VpVxJKd/ZugyA0TM/jjM/2LNSa21dA/tUyiuSfCrJn8Zn ya7uaPemJA+k1hcaVwQwTubHceYHDfjHqXMyrAp8Ksk7F19JKfNtvvduQ/2plPLe1PqNhlUBjI/5 cZz5QSN+3TUv38ywUrJ0LcntWf7a896mmwzvzTfbFAQwaubHkvlBQ/O74Obs+PbWS/Nrvuubrm2o AU5ifgzMDxqbz8XGYO7NV9MFuBzzw/yguelfaNxrrs1X0wXYjPlhftDUdC8yTje35qvpAmyH+ZGY HzQyvQuM85tL89V0AbbL/DA/aMLnuLOuMb2Q5O2p9cvtitqiUt6c5PNJXrF4RtMF2AbzA/ZKcGdw 1Hx/KsNGEp9tXNF2lfLODJ9B/IlougDbY37A3gjuHBma7w9MZqXkbsPKyVc0XYAtMz9gLwR3AADo wHT+AQl9KeUwpdTF12HrcgAAxk5wBwCADgjuAADQAcEdAAA6ILhzOaV81yg22SjlSkr5rtZlAHBO 5gdcWvsLh/6U8uokn0nrHfKOPjv4M4uaABgz8wM2crV1AXRmWJ14JskPL76SUva/IcW9u/U9k1Le lVr/bq91AHA+5gdszIo7F/VCki+sPL6Wfa+c3Nt0s6jphb3VAMBFmR+wIcGdixlWRg6S3Fl5dn/N d33TvRPbUAOMm/kBGxPcubhWzVfTBeib+QEbEdy5nH03X00XYBrMD7g0wZ3L21fz1XQBpsX8gEsp tdbWNdC7XTZGTRdguswPuBDBne24t0F+PcnbUuufbfi6b0jyXJLvXjyj6QJMifkB5ya4sz1Hzfd9 Sd6TWv/nll73RzJ89u/T0XQBpsf8gHMR3Nmuofl+/8YrJfe+7huSfFXTBZgo8wPOJLgDAEAHfKoM AAB0QHAHAIAOCO4AANABwR0AADoguNNOKd+TUr6ndRkAdMb8YKam96kypRxe6Ptrvdj3e/1tvf4r k/ybJN9M8pbU+vyWX3/Q7/szz9cHOEsp9yf50uLR+ecHTMAUg/vF/kK1Fq/f8PUH/y/JG1Pr/976 6/f+/szt9QFOM6yy/68kr1o8c/75ARPgVhnG4FVJfnmx+QbAVpRSak9frd+v0RtmxC/nKLQn5gcz c7V1ATvwMa8/2tcvSf5lkreu+f/9XJKaUs7aknrK74/XB1hnCOa3M8yKu/1czjc/oHvTu1WGcTpq utfO+M47STRfYGO9rWJXt5att35+/Pri//7cynPmB5PnV0vs3vqm+4UT/vtaktt+7QnACfPjTpKH Fl93Vp43P5i8Kd4qw5ic3HT/Mke3zPzXJH+88j3XFv9bKyfA1oxtRbu33wjs3cnz42g2lHKweN78 YBb8VMrunNZ0k9WBVRfPWTkB4HyhPcniv80PZsNJzS7dn+SBlccn33+4vvk+sHgNAObF/IA13CrD 7tT6Vynl3UmeTfKpnPWPhmp9aeXXng8keXdq/avdFwrAqJgfsJbgzm7V+uWU8vYkz5/rfsOj5nu/ pgswY+YH3ENwZ/cu2kCHBq3pAsyd+QHHuMcdAAA6ILgDAEAH7JwKwCTd/TnpY/8c97HVB4yPFXcA AOiA4M7llFJSymtal5FSXpNSrFIB9ML8gEsT3Lm4odE9kuQPUsrrGtbxuiR/kOQRzRegA+YHbMTH QXIxQ4N7NMnDi2eeTSn/LLX+nz3X8ZoMG3O8cfFVUsqH4x9tAIyT+QEbs+LO+Q1N97EcNd0keSbJ 1xpU87XFn730cJLHrJwAjJD5AVshuHM+Q0N7PMmNlWcfT/KRJqsUw5/5kUUNSzeSPK75AoyI+QFb I7hztqOme33l2SeStP3V4vBnf3hRy9L1aL4A42B+wFYJ7pxuaGBP5HjTvZXk5ijuBxxquJmhpqXr SZ7QfAEaMj9g6wR3TjY0rltJDlaevZXk4VE03aWhlodzvPkeJLml+QI0YH7ATgjurDc0rNtJHlp5 9nbG1nSXjprv7ZVnH0pyW/MF2CPzA3ZGcOckr03y4yuPn0xyY5RNd2mo7UaGWpd+PMPfBYD9MD9g RwR31qv1b5K8K8mfJ/m1JNe32nRLOUwpdfF1uLXXHWq8nqHmP0/yrsXfBYB92PX82BXzgw7YgImT 1frVlPKOJH/bRdNdqrWmlIMkr9V0ARowP2AnBHdO12vjGgZFn7UDTIH5AVvnVhkAAOiA4A4AAB0Q 3AEAoAOCOwAAdEBwn6NSSkr53tZljEYp32uTDYBzMD+OMz/YM8F9boYG80iS51LKG1uX09zwHjyX 5BHNF+AU5sdx5gcNCO5zMjSWR5PcTPK6JM/OeuVk+Ls/m+G9uJnkUc0XYA3z4zjzg0YE97kYGspj SR5eefZ3M+/Pqv2bDO/B0sNJHtN8AVaYH+uYHzQhuM/B0EgeT3Jj5dnHk3ykqx3ttm34u38kw3ux dCPJ45ovQMyPk5gfNFLmfN3NwlHTvb7y7BNJbs666a46Wk1aHUy3kjzsPYJ+lVKOXb+11lEFqrHX Z36cg/nBnllxn7KhoTyR4033VjTd44b34maG92bpepInrJwAs2R+nI/5wZ4J7lM1NIxbSQ5WnrUK cJLhPXk4x5vvQZJbmi8wK+bHxZgf7JHgPkVDo7id5KGVZ29H0z3dUfO9vfLsQ0lua77ALJgfl2N+ sCfucZ+iUl6d5HNJ3rx45skk1zXdczpabVoOri8n+Rep9WvtigIuauwmBtNnAAAIKElEQVT3kN9d 31jV5Ir5cU7mBzsmuE9VKd+X4TNm/3uSA033go5Wnf55knen1r9uXBFwQYL7doztfRs984MdEtyn bFh5/7rQfklD8/1uKyXQJ8F9O8b2vnXB/GBHBHcAJklw346xvW8wZ1dbFwAAcyQQAxflU2UAAKAD gjsAAHRAcAcAgA4I7r0p5UpKeV3rMjZWymFKqYuvw9blbKyU16UU1xMwXlOZH1NjfnABTpSeDBf2 7SSfTylvPuvb2ZPhWHw+ww55rilgfMyPcTI/uCAnSS+Omu61JMPmSlZO2huOwbMZjsm1aL7A2Jgf 42R+cAlOkB4cb7pLn0ryfJuCWPF8hmOxpPkC42F+jJn5wYU5OcZufdO9k+Qgtb7Upij+0XAMDjIc kyXNF2jP/Bg384NLcGKMmabbB80XGBvzow/mBxfkpBgrTbcvmi8wFuZHX8wPLsAJMUaabp80X6A1 86NP5gfn5GQYG023b5ov0Ir50Tfzg3NwIozPK5K8deWxptub9c33rRmOLcCumB+9Mz84w9XWBXCX Wv8upbwnyTNJvhBNt0+1vpRSDhaP3prkPan171qWBEyc+TEN5genENzHqNavpZR3JXlB0+3YUfN9 haYL7IX5MQ3mBycotdbWNQDA1pVSjg24WmtpVQvANrjHHQAAOiC4AwBABwR3AADogOAOAAAdENz3 qZQrKeUNrctgpEp5g002gLXMD05jfsyGg7wvRzvaPZdSfqR1OYzMcE48FzvkAXczPziN+TErPg5y H+7dhvrrSd6WWv+sXVGMxrCK9lyS7148Y7dD2IJJfByk+cFpzI/Z8ZPZrt3bdJPk6SRfbVIPY/TV DOfE0rVYOQHMD8721Zgfs+LA7tL6puunYY4bzoWDDOfGkuYLc2Z+cB7mx+w4qLui6XIRmi+wZH5w EebHrDigu6DpchmaL2B+cBnmx2w4mNum6Z5PKYcppS6+DluXMxqaL8yX+cEmzI9ZcCC3SdNlGzRf mB/zg20wPybPQdyulyd508pjTZfLWd9835ThHAOmx/xgO8yPSbvauoBJqfUbKeWBJJ9K8qfRdNlE rS+llIPFozcleSC1fqNlScCOmB9sk/kxWYL7ttX6Qkp5b5Jvarps7Kj5vlzThYkzP9gm82OSBPdd cIGwTcMAd07BHJgfbJP5MTnucQcAgA4I7gAA0AHBHQAAOiC4AwBABwT38yrlSkp5c+sy4FSlvNkm GzAy5gc9MD+64ACdx9GOdp9PKe9sXQ6sNZybn48d8mA8zA96YH50o9RaW9cwbvduQ/1Ckren1i+3 KwruMqzmfT7JKxbP2HWR2SulHBtwtday5wLMD8bP/OiKn6pOc2/TTZJPJPlKm4LgRF/JcG4uXYuV E2jH/KAf5kdHHJSTrG+6fgplnIZz8iDDObqk+UIL5gc9MT+64oCso+nSI80X2jM/6JH50Q0H426a Lj3TfKEd84OemR9dcCBWabpMgeYL+2d+MAXmx+g5CEuaLlOi+cL+mB9Mifkxag7Ake9Icv/KY02X vq1vvvdnONeB7TE/mBbzY7R8jvuqUl6e5Okkz0fTZSqOVgPvT/K+1PrNxhXBXuz1c9zND6bI/Bgd wf1upbwsybc1XSZlaL7fkVq/1boU2Je9b8BkfjBF5seoCO4ATFLznVMBtsw97gAA0AHBnTZKOUwp dfF12LocAICxE9wBAKADgjsAAHRgHsG9lCsp5YdalwFdKOWHbLIBC+YHnJ/5sXPTf3OPPoP0D1PK T7YuB0ZtuEb+MHbIA/MDLsL82Itpv7HHt6F+WZKnrZzACYZr4+kM14rtrZk38wPOz/zYm+m+qceb 7tLHk3yxTUEwel/McI0sab7Mk/kBF2V+7Mk039D1TfdObEMNJxuujYMM18qS5su8mB9wcebH3kzv zdR04fI0X+bM/IDLMz/2YlpvpKYLm9N8mSPzAzZnfuzcdN5ETRe2R/NlTswP2B7zY6em8QZqurB9 mi9zYH7A9pkfOzOVN+9KkleuPNZ0x67Ww9RaFl+HrcvhBOub7ysznd4B5gfsgvmxE1dbF7AVtb6Y Uh5cPPr7aLqwPbW+lFIOFo9emeTB1Ppiy5Jga8wP2B3zY+tKrbV1DdtTytUkL2m6sAPDrzevaLr0 opRybMDVWssp32x+wK6YH1szreAOAAsXCu4AHXCfEQAAdEBwBwCADgjuAADQAcEdAAA6MP7gXsqV lPKO1mUAF1DKO2yyAcCFmR+nGvcbc7Sj3edSyvtblwOcw3Ctfi52yKMl5x70x/w403jflFJKjrah vprkKSvvMHLDNfpUhmt2ub21j+Bjv47mB9AL8+Ncxhvchw+Y/4uVZ/5jkucaVQOcz3MZrtWlv4jN Iti3e+cHMH7mxzmMfwOmUg6T/JPYhhr6cHSL21+k1sPG1TBjNmCCzpgfZxp/cE+GX3t2USiQxDXL KAju0CHz41R9BHcAAJi58d7jDgAA/CPBHQAAOiC4AwBABwR3AADogOAOAAAdENwBAKADgjsAAHRA cAcAgA4I7gAA0AHBHQAAOiC4AwBABwR3AADogOAOAAAdENwBAKADgjsAAHRAcAcAgA4I7gAA0AHB HQAAOiC4AwBABwR3AADogOAOAAAdENwBAKADgjsAAHRAcAcAgA4I7gAA0AHBHQAAOiC4AwBABwR3 AADogOAOAAAdENwBAKADgjsAAHRAcAcAgA4I7gAA0AHBHQAAOiC4AwBABwR3AADogOAOAAAdENwB AKADgjsAAHRAcAcAgA4I7gAA0AHBHQAAOvD/AYJWIjlqdV0YAAAAAElFTkSuQmCC ";
  vampiro = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAu4AAAIhCAYAAAARoz+rAAAABHNCSVQICAgIfAhkiAAAHpdJREFU eJzt3U+sdPd91/HPL326QfKfWEggJBJ7h0oQVbfs6jhqsqESdoRDqSJsx1m5cZKmKooTJ44CapvY MUglTUylCnDlWGq7KA220+66YUMVxAYkOwUhUcLjfxUbbP1YzIyfuXNn5s6dmfPnd87rJV0p9/g+ Mz+fWFdvf/2955ZaawA4QSkXv5HWWgY6CQAT9r6hDwAAAFxNuAMAQAOEOwAANEC4AwBAA4Q7AAA0 QLgDAEADhDsAADRAuAMAQAOEOwAANEC4AwBAA4Q7AAA0QLgDAEADhDsAADRAuAMAQAOEOwAANKDU Woc+AwAAcAUTdwAAaIBwBwCABgh3AABogHAHAIAGCHcAAGiAcAcAgAYIdwAAaIBwBwCABgh3AABo gHAHAIAGCHcAAGiAcAcAgAYIdwAAaIBwBwCABgh3AABowI2hDwDQvFLqhc9rLQOdBIAJM3EHAIAG CHcAAGiAcAcAgAYIdwAAaIBwBwCABgh3AABogHAHAIAGCHcAAGiAcAcAgAYIdwAAaIBwBwCABgh3 AABogHAHAIAGCHcAAGiAcAcAgAaUWuvQZwAAAK5g4g4AAA0Q7gAA0ADhDgAADRDuAADQAOEOAAAN EO4AANAA4Q4AAA0Q7gAA0ADhDgAADRDuAADQAOEOAAANEO4AANAA4Q4AAA0Q7gAA0ADhDgAADbgx 9AEAmldKvfB5rWWgkwAwYSbuAADQAOEOAAANEO4AANAA4Q4AAA0Q7gAA0ADhDgAADRDuAADQAOEO AAANEO4AANAA4Q4AAA0Q7sDZlVI+MfQZAGBqhDvQhd8ppfzDoQ8BAFMi3IEu/ESSf1NK+fjQBwGA qRDuQFd+Ism/LaXcP/RBAGAKhDvQpRtJnhfvAHC6G0MfAJi8Vbyn1vri0IfpRK1l6CMAMH0m7kAf TN4B4ETCHeiLeAeAEwh3oE/iHQCOJNyBPryz9r/FOwAcQbgDfXgw4h0ATiLcgc4tnyYj3gHgBMId 6IV4B4DTCHegN+IdAI4n3IFeiXcAOI5wB3on3gHg+oQ7MAjxDgDXI9yBwYh3ADiccAcGJd4B4DDC HRiceAeAqwl3YBTEOwDsJ9yB0Wg23kupFz4AoAPCHRiVZuMdADom3IHREe8AcJlwB0ZJvAPARcId GC3xDgC3CHdg1MQ7ACwId2D0xDsACHegEeIdgLkT7kAzxDsAcybcgaaIdwDmSrgDzRHvAMyRcAea JN4BmBvhDjRLvAMwJ8IdaJp4B2AuhDvQPPEOwBwId2ASxDsAU3dj6AMAnEut9cVSSpI8n1vf31bx vor7Lt64dPK6ALDGxB2YFJN3AKZKuAOTI94BmCLhDkySeAdgaoQ7MFniHYApEe7ApIl3AKai1FqH PgMwMaWUC99Y6gieurKM9PWnzZzdGP4+AZguE3egc6WU24c+w47JOwA0Q7gDXbi58fljg5xig3gH oGXCHejC0xufPz6GqXvyXrx/Ism7Q58FAK7DjjtwdstIfzXJXWuXn6i1fm2gIwFA80zcgbOrtb6V EU/dAaBFwh3oyrO5uOt+V0ay6w4ALRLuQCdM3QHgvIQ70CVTdwA4E+EOdMbUHQDOR7gDXZv+1L2U euEDADog3IFOmboDwHkId6AP05+6A0DHhDvQOVN3ADidcAf6YuoOACcQ7kAvTN0B4DTCHeiTqTsA HEm4A70xdQeA4wl3oG+m7gBwBOEOPSml3F5K+WIp5e8NfZYhmboDwHGEO3RsFexJXk3yVJJPDnui UTB1B4BrKrX67dzQheUE+bEkj2cRpis3k/z1Wuv/G+RgI7H8l5mn1i7dTHLPciLfllIufiOttQx0 EgAmzMQdzmzLhP2ujS+5K8m9vR9sfEzdAeAahDucyQHBvu6Bfk41XnbdAeB6rMrAifasxKz7v0n+ ytrn1mXy3r17NRfv2xO11q8NdKTjWJUBoAcm7nCkAyfsP07yq0n+ZpI31q5bl4mpOwBch3CHa7pm sN9Ta/3ntdabSX5/42tmvy6z1P6ue63lwgcAdMCqDBzowJWYHyf5RpJ/WWv9y40//7Ekf7h2ybrM 0qSeMAMAHRHucIVTg33tdX4yyV8kuXPt8kdrrd8/43GbNJlddwDokFUZ2OHIlZit0Z4ky8m6dZkt 7LoDwNVM3GHDuSbsO17buswOpu4AsJ9wh6Uug33tPazL7GHXHQB2syrD7J17JWYf6zJXav8JMwDQ ERN3ZquPCfuO97Uus4epOwBsJ9yZnaGCfe39rcvsYdcdALazKsNs9LkSs491mf08YQYAtjNxZ/KG nrDvONPmuszrSf6adZkFU3cAuEy4M1ljDPa1s/1kkv+V5P1rl63LrLHrDgAXWZVhcsayErPPcrL+ BxuXP97nGRrgCTMAsMbEnckY84R9m1LKR5P8+7VL1mU2mLoDwC3Cnea1Fuwr1mWuZtcdAG6xKkOz WliJ2ce6zNV2PWFmiLMAwNBM3GlOqxP2bazLXG35//eb69dqrWWg42xXysVvpGM7HwCTINxpxpSC fcW6zGHKRhgLdwDmyKoMo9f6Ssw+1mUAgEOZuDNaU5ywb2Nd5mom7gAg3BmhuQT7yo51mY/VWv9o oCONjnAHAKsyjMiUV2L2WU7Wf3/j8gNDnAUAGC8TdwY3twn7NtZl9jNxBwDhzoAE+y3WZfYT7gBg VYYBzHUlZh/rMgDAVUzc6Y0J+37WZXYzcQcA4U4PBPthrMvsJtwBwKoMHbIScz3WZQCAfUzcOTsT 9uNZl9nOxB0AhDtnJNhPZ11mO+EOAFZlOAMrMedjXQYA2MXEnaOZsHfDusxlJu4AINw5gmDvlnWZ y0Yf7gDQA6syHMxKTD92rMt8fIizAADjYeLOlUopJcmnknw9Juy9sC5zkYk7AJi4c4VSygeTvJzk X8WEvU+vZBHrK+9P8uGBzjI6pZT7hz4DAPRNuLNVWfh0kh8muXfLlwj2DlmXueTdjc+fF+8AzI1w 55K1KftvJrlt4y+/FcHelxc2Pv/7yx9cnaMHk7yz9vmNiHcAZsaOO+9Z7rI/muTXcjnYk+T7SR6p tf6PXg82U54uc9Ey0p/PItpX3knyYK31xWFOBQD9MXEnyZVT9jeTPFRr/aho7491mYuWcW7yDsBs CfeZO2CX/ftJPlRr/df9nowl6zJrxDsAcybcZ8yUvQk/yOWny9w30FlGQbwDMFfCfYZM2duxXJf5 vY3LDwxxljER7wDMkXCfmQOm7A+bso/O9zY+//k5r8usiHcA5ka4z8Q1puzP9XsyDvCDJDfXPr8z M1+XWRHvAMyJcJ+BA57Lbso+YjueLjP7dZkV8Q7AXAj3CTtgyv4fkvxtU/YmWJfZQ7wDMAfCfaIO nLL/nCl7M6zLXEG8AzB1wn1iTNmnybrMYQaL91LqhQ8A6IBwnxBT9smzLnMAk3cApkq4T8CBU3ZP jGmfdZkDiXcApki4N+4aU/b/3vvhOCvrMtcj3gGYGuHeKFP22bIucw3iHYApEe4NMmWfNesy1yTe AZgK4d4QU3Z2rMs8UUr5mMn7buIdgCkotXpyWQuWU/bnsj3Y30ryWcE+D6WUn0vyR1v+0htZRP33 kry8jHzWLCP9+SyifeXdJP+41vr8CS988RtpreXo1wKAHUzcR86UnS0212VW7kzyySR/mOQvSim/ bRIPANNh4j5ipuzsUkr5lSRfSHLXAV/+epI/SPJCklfmOonfMW1/J8mDy1WaU17cxB2Azgn3ESql lCSPJvm1XP7h02QxZX/ED5/O23KSfm8Wj4T8+Rwe8at1mtlEfKfRvngD4Q5A54T7yBwwZf9crfW7 /Z6KsRPxu3Ue7Ys3Ee4AdE64j4QpO+dyYsS/kOQHU4n4XqJ98UbCHYDOCfcRMGWnK3OO+N6iffFm wh2Azgn3AR0wZX8pi1+mZMrOyY6M+Ju5tU7TTMT3Gu2LNxTuAHROuA/ElJ0hTTnie4/2xZsKdwA6 J9x7ZsrO2JwY8at1mneu+PpeDBLtANAT4d4jU3bG7oSI/73cmsQPEvGiHYCpE+49MGWnRS1FvGgH YA6Ee8dM2ZmCEyP+hSR/3FXEi3YA5kK4d8SUnak6MuL/T27txJ8t4kU7AHMi3Dtgys5cnBDxq3Wa oyNetAMwN8L9jEzZmbM+I160AzBHwv1MTNnhlhMj/oUkf7Ir4kU7AHMl3E9kyg77nTPiRTsAcybc T3DAlP3ztdbv9HsqGK8jI/7HWUT8f03y9Yh2AGZKuB+plPIPkvx2TNnhKEdG/DrRDsCsCPcjLCft P8zlaDdlhyMcEfGiHYDZEe7XtNxpfzmX12NeSvJIrfXP+z8VTMcBES/aAZgl4X5NpZRPJ/nNjcv/ tNb6z4Y4D0zZloi/PaIdgJkS7tewY0Xm5VrrRwY6EsxGKeVGkrtrrf9t6LMAwBCE+4F2rMi8neRD 1mMAAOjajau/hKVHc3mv/XOiHUgpFycgtZaBTgLAhJm4H8CKDLCXcAegB+8b+gBjt1yReS4Xo/3t JA8PcyIAAOZIuF/NigwAAIOzKrOHFRngIFZlAOiBifsOVmQAABgT4b7bthWZz1uRAQBgCFZltrAi A1yLVRkAemDivsGKDAAAYyTcL7MiAwDA6FiVWWNFBjiKVRkAemDivmRFBgCAMRPut1iRAQBgtKzK ZOeKzCu11vsGOhLQEqsyAPRg9hP3PSsyDw1zIgAAuGz24R4rMgAANGDWqzJWZAAAaMVsJ+6eIgMA QEtmG+5JPpXLKzK/XGv90RCHAQCAfWa5KmNFBgCA1sxu4m5FBgCAFs0u3GNFBgCABs1qVcaKDAAA rZrNxN2KDAAALZtNuMeKDAAADZvFqsyOFZkfJLmvzuEGAADQvMlP3PesyDwk2gEAaMXkwz3bV2S+ YEUGAICWTHpVxooMAABTMdmJ+44Vmb+MFRkAABo02XCPp8gAADAhk1yVsSIDAMDU3Bj6AOdmRQbo XSkXv7fUWgY6CQATNsVVGSsyAABMzqRWZazIAIMwcQegB5OZuO9ZkXlYtAMA0LrJhHt2r8i8NsBZ AADgrCaxKrNjReaPk3zYtB3onFUZAHrQ/MTdU2QAAJiD5sM921dkvmBFBgCAKWl6VcaKDDAKVmUA 6EGzE3crMgAAzEmz4R4rMgAAzEiTqzJWZIBRsSoDQA+am7hbkQEAYI6aC/dYkQEAYIaaWpWxIgOM klUZAHrQzMTdigwAAHN2Y+gDXIMVGWCcTNgB6EETqzI7VmT+JMm9pu0AAMzB6Fdl9qzI/BPRDgDA XIw+3LN9ReZXrMgAADAno16VsSIDAAALo524e4oMAADcMtpwz+4VmVeHOMymUsoDpZR3Sim1g48v Df3317WO79+nhv77AwA4t9GuypRS3spIV2RKKfcneT7dPU7zZpJ7aq1vdfT6g+rh/r2d5O/UWn/U 0esDAPRuzBP32zY+H8WKTA/RmSR3JXmsw9cfTE/377Ykzy3XrQAAJmHME/cLB6sj+AUnPUXnyutJ 7p7S1L3n+5ckn661frun9wIA6NSYJ+6jsiM630nyQK21nPqR5M4kb6y99vszoal71/dveQ9f2njb X18+mQgAoHnC/QB7ovPBWuuL53iPWuubSZ7ZuPzZUsrt53j9IfVx/5YeSbL+Xyhuy+LJRAAAzRPu V+gxOpNFuE9q6t7n/au1/nmSz29cvreU8ug53wcAYAh23Pefoc9oX73nl5M8uXap2V33Ie7f8n1f SnLf2iVPmQEAmmfivsNQ0ZmJTN0HvH9J8nAWsb5yW5LvdvyeAACdEu5bDBmdU9h1HzjaVyszn9u4 /GErMwBAy6zKXH7fQaNzeYY7kryWxZNmVr5Ua32qj/c/xRju39pZrMzQj43vVxnB42sBmB4T9zVj ic4dU/fHxz51H8v9W2NlBgCYDOG+NMLo3Lbr/ksDnOMgI7x/VmYAgEmxKpNxRmfSzhNmxnr/VqzM 0DmrMgD0YPYT95FH5+in7iO/fytWZgCA5s063Mcenctd96c3Lo9m133s92/FygwAMAWzXZVpJTrH +oSZVu7fOiszdMaqDAA9mOXEvaXoHOPUvaX7t8HKDADQrNmFe6PR+a2MZNe90fuXxMoMANC2WYV7 q9G5Z+p+R5/naPX+rau1fifJyxuXf72U8sEhznOsUsodpZRfHcvPOwAA3ZtNuE8gOgeduk/g/q2b wsrMY0m+nuTVUsoXBTwATN8swn0K0Tnk1H0K92/dcmXm8xuXm1mZWUb6Z5af3pXkqQh4AJi8yYf7 xKJzc+p+Zzqeuk/s/r2n1vpbaXdl5rEsgn2dgAeAiZv04yCnGJ2llCeSfHXt0htZ/DbVNzt4r8nd v3WllA8k+c9ZrMqsvFJrvW/HHxncMshfzeVw33Qzi/9C8+zYftPuJHkcJAA9mOzEfcLR+a0kr699 3snUfcL37z17VmY+NcR5DrQ5bX87i0jfZAIPABMzyXCfcnQup6ed7rpP+f5t2rEy8xvLafyoLOP7 8Y3L30hyT5IncvFf6FYEPABMxOTCfSbR2dnUfSb3b9O2p8w8N9BZ9tmctr+R5Jla61u11q8luTsC fhi1lgsfANCBSYX7XKKzq6n7XO7fphZWZnZM259Z/9kGAQ8A0zaZH06dW3Qug+u1LJ7nvvLlWutX t/+JK19vVvdvm1LKS0nWfzD17SQfWob9oEopX8wiuFeu/KHk5T8jjyX5bC7+c7LOD7ECQCMmMXGf Y3Sec+o+x/u3wyhXZg6Ztm+zMYH/UkzgAaBpzYf7zKNz2677Z3Z87VYzv38XjHhlZutu+6F/eBnw T0XAA0DTml6VEZ2nPdfd/duulPJykg+vXRpsZWbHc9ufrLV+5cTX/KUspvhWaACgEc1O3EXne46a urt/ez2Uyysz3x3oLCdN27cxgQeANjUZ7qLzluU09Jsblz+zb9fd/dtvx8rMfX2vzBy7234oAQ8A bWluVUZ0XrbjCTNb1yncv8MNvTJzzJNkTny/O3JrhebOHV9mhQYABtLUxF10bnfo1N39u7bBVmZ2 TNuf7irak6TW+ubycaJ3J/lyFv+isMkEHgAG0ky4i84rPZs9u+7u3/UNvDKzbbf9Wz28r4AHgJFq ZlUmi8gUnXvsWq3I4pcKifYj9b0ys+NJMkf/cq0znMcKDQCMQEvhvk50brFj1/2lJD8b0X60UsoH k/wwi1WZlZdrrR/p6P163W0/lIAHgGE1syqzRnTusGPX/SMR7Septf4oPa3MDLHbfqiNFZonY4UG AHrV2sRddF5hx9R9xf07QR8rM2Odtm+znMB/ZvmxbwL/eK31d3o7GABMVEsTd9F5gB1T98T9O4eH 0+FTZsY8bd9mOYH/Sq6ewD9t8g4Ap2sl3EXn9TybxaRzxf07g+XKzC9vXD7nysxgT5I5xQEBf1cW f2/TVUq98AEAHWhhVUZ0HmFt5cL9O7MuVmbG9iSZUyxXaJ5J8sm1yzeT3DPZH1jdjPXlL4wDgHMa +8T93ST/SHQe5V8k+d8R7V3oYmVmc9r+ehbx25zlas/jSdZXfKY/dQeAjo053N9N8gu11heGPkiL lvH006L9/PaszDxyzOvt2W1vdjpda30jl//F43G77gBwvDGH+y/WWn936EO0rNb6P4c+w1TVWr+d 5JWNy98opXzgiJfbNm0f/W77AZ6JqTsAnM1ow73W+u+GPgNc4eSVmSlO21dM3QHgvEYb7jB2Z1qZ meq0fcXUHQDORLjDCU5ZmZnytH3F1B0Azke4w+mOXZmZ+rR9xdQdAM5AuMOJjlmZmcO0fcXUHQDO Q7jDGRyxMjOXafuKqTsAnEi4w/kctDKzY9r+zSlO21dM3QHgdMIdzuQaKzPbpu3Pdnm2kTB1B4AT CHc4o+XKzA82Lv/GamVmjtP2FVN3ADiNcIfzeygXV2ZuT/Kd5f+e67R9xdQdAI4k3OHMdqzMfKSU 8rnMdNq+YuoOAMcrtdahzwCTVEp5Jcm9e77k9SR3zynck6SUcmeS15LcsXb5iVrr14Y5EQC0wcQd urO5MrNpVtP2FVN3ADiOcIeO7FiZWZnbbvsmu+4AcE3CHbr1W7n8lJlkptP2FVN3ALg+O+7QsVLK B5P8MItfyJQkN5PcM+dwT+y6A8B1mbhDx7aszDw992hPTN0B4LpM3KEnpZSXk/xMTNvfY+oOAIcz cYf+PJTkK6L9FlN3ADiciTswKFN3ADiMiTswKFN3ADiMcAfGwHPdAeAKwh0YnKk7AFxNuANjYeoO AHsId2AUTN0BYD/hDoyJqTsA7CDcgdEwdQeA3YQ7MDbtTd1LqRc+AKADwh0YFVN3ANhOuANj1N7U HQA6JtyB0TF1B4DLhDswVr1M3Uspd5z7NQGgC8IdGKWup+6llNtLKU8kee0crwcAXRPuwJidfeq+ DPYvZhHsX01y5ymvlyT/5dQXAIADCHdgtJZT9+9tXD5q6r4W7K8meSrJ+89wxJRS7v+7SZ48x4sB wB43hj4AwC6llPuTfHLj8h1JPpTkTw98jduzmNI/nsXE/tzne/6dJF9ZXnvynG8AAGtKrX5XCDA+ qyjOxQHDO0k+UWvdnMJv+/MHB3uttZzjfDeS/FmSnzri9QDgKibuwOjsifYHa60vXvFnO5uw7zvf jeWFn+riDQEgdtyBkTk22rfssG+L9jdy4jbLvmi//5QXBoArWJUBRuOYaD9wwr56tOQztdY3SykX vvEduiqz63zfS25ciHarMgB0QLgDo3DdaD8m2Nf+7LXDfe/5Np98I9wB6IAdd2Bw14n2U4K9s/MV nQ5A94Q7MKhDo32IYL/O+QCga8IdGMwhUXyNYH86ybfOFeyHni+J1RgAeiHcgUFcFcVDBvsh5zvn ewHAIfxwKtC7fVGc5KV0HOxX/XCqaAdgjEzcgV7tieJHk/ytJN/OABP2A84n2gEYlIk70JsdUZwk /ynJB7I72F/P4odOzxLsuybuoh2AMRPuQC/2RPs+r+fWhP2tM57lUriLdgDGzqoM0Lkjor2TYN9F tAPQAhN3oFPXjPZegn1z4p5FpIt2AEbNxB3ozDWivdcJ+xaiHYDRE+5AJw6M9teTfDPJswMF+ybR DsBoWZUBzq6U8tNJ/mN2R/ugwb5lVSYR7QCMnHAHzq6U8r4kLyf52Y2/NIoJ+44dd9EOwKgJd6AT pZS/keTPkvzVjCTYVzbCXbQD0AThDnSmlPKxJD+TkQT7ylq4i3YAmiHcgdlZhvu7ST5Ra31h6PMA wCHeN/QBAAbwbpJfEO0AtMTjIIE5+sVa6++e7dU2f9i11nK21waAJasyAKcS7gD0wKoMAAA0QLgD AEADhDsAADRAuAMAQAOEOwAANEC4AwBAA4Q7AAA0QLgDAEADhDsAADRAuAMAQAOEOwAANEC4AwBA A4Q7AAA0QLgDAEADSq116DMAAABXMHEHAIAGCHcAAGiAcAcAgAYIdwAAaIBwBwCABgh3AABogHAH AIAGCHcAAGiAcAcAgAYIdwAAaIBwBwCABgh3AABogHAHAIAGCHcAAGiAcAcAgAYIdwAAaIBwBwCA Bgh3AABogHAHAIAGCHcAAGiAcAcAgAYIdwAAaIBwBwCABgh3AABogHAHAIAGCHcAAGiAcAcAgAYI dwAAaIBwBwCABgh3AABogHAHAIAGCHcAAGiAcAcAgAYIdwAAaIBwBwCABgh3AABogHAHAIAGCHcA AGiAcAcAgAYIdwAAaIBwBwCABgh3AABogHAHAIAGCHcAAGiAcAcAgAYIdwAAaIBwBwCABgh3AABo gHAHAIAGCHcAAGiAcAcAgAYIdwAAaIBwBwCABgh3AABogHAHAIAGCHcAAGiAcAcAgAYIdwAAaIBw BwCABgh3AABogHAHAIAGCHcAAGiAcAcAgAYIdwAAaIBwBwCABgh3AABogHAHAIAGCHcAAGiAcAcA gAYIdwAAaIBwBwCABgh3AABogHAHAIAGCHcAAGiAcAcAgAYIdwAAaIBwBwCABgh3AABogHAHAIAG CHcAAGiAcAcAgAYIdwAAaIBwBwCABgh3AABogHAHAIAGCHcAAGiAcAcAgAYIdwAAaIBwBwCABgh3 AABogHAHAIAGCHcAAGiAcAcAgAYIdwAAaIBwBwCABgh3AABogHAHAIAGCHcAAGiAcAcAgAYIdwAA aIBwBwCABgh3AABogHAHAIAGCHcAAGiAcAcAgAYIdwAAaIBwBwCABgh3AABogHAHAIAGCHcAAGiA cAcAgAYIdwAAaIBwBwCABgh3AABogHAHAIAGCHcAAGiAcAcAgAYIdwAAaIBwBwCABgh3AABogHAH AIAGCHcAAGiAcAcAgAYIdwAAaIBwBwCABgh3AABogHAHAIAGCHcAAGiAcAcAgAYIdwAAaIBwBwCA Bgh3AABogHAHAIAGCHcAAGiAcAcAgAYIdwAAaIBwBwCABgh3AABogHAHAIAGCHcAAGiAcAcAgAYI dwAAaIBwBwCABgh3AABowP8HawxT8nNfZIwAAAAASUVORK5CYII= ";
  motivo = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAu4AAAIhCAYAAAARoz+rAAAABHNCSVQICAgIfAhkiAAAHrtJREFU eJzt3c+vtGd52PHrtt5sogT8ixCxAkXdVJWNF1lFOA9YSpQuWpMGpHQVRWoXlYnAZFfapELpLthE Slat2ERCAirbq0Yl0Ad7nWL8BwQWUYVS8GsSZYEw3F2cGb8zj8+cmXnm+XU98/lIR/E9Pu+cG+Xo PV8urjNTaq0BwAVK2f+LtNYy000AWLGH5r4AAABwnHAHAIAEhDsAACQg3AEAIAHhDgAACQh3AABI QLgDAEACwh0AABIQ7gAAkIBwBwCABIQ7AAAkINwBACAB4Q4AAAkIdwAASEC4AwBAAqXWOvcdAACA I0zcAQAgAeEOAAAJCHeAC5RSHiql/F4p5UNz3wWAdRPuAJd5IiK+FBF/W0r521LKn859IQDWSbgD XKbZ+ecPRcSvzHQPAFZOuANcpumc2xnuAMAVEO4APZVSHoqIpzsPtzNcBYArINwB+nsiIh7ZOd+P iDdmugsAKyfcAfprOudXa60/m+MiAKyfcAfor+mc2xnuAMCVEO4APdhvB2Bqwh2gH/vtAExKuAP0 03TO9tsBGJVwB+in6ZzbGe4AwBUR7gBnst8OwByEO8D59vbbH4mIn0Z8O0qpUUqd71oArJlwB1Io pdwrpdyb+x4bze7h6fCXKQDj87MGyOKjm48laA4eAGAkS5leARzzyc3//fqcl7htv72Z5yoAXJlS q3VMYNk2KzLf3xx/udb69ox3+XBEfHvnofs/jXhk73++rLVMeysAroFVGSCDZyLisc3HMzPfpemc X/UXKQBT8PMGyOATB/55Dk3n3M5wBwCukFUZYNFKKT8XN2syj24eejNu1mV+MsNdHoqIH8TOS0FG xFN1f3XGqgwAozBxB5buY/Eg2mPzzx+b6S57r98eEfcj4o2Z7gLAlRHuwNJ98sTHptB0zq/WWn82 x0UAuD7CHViszZrMs7f8q2dnejOmpnNuZ7gDAFdKuANL1l2T2Xo0Jn51mdtevz2EOwATEu7Akt21 EjP1uoz9dgBmJdyBRbpjTWZr6nWZpnO23w7ApIQ7sFTdNZk3Nx9bU6/LNJ1zO+HXBgDhDixWdxXm 5c3HrknejMl+OwBL4A2YgMW55U2XIiJ+KyJqRPzVzmNvRsT7a61vj3yfD8f+myzdj4jHrcoAMCUT d2CJbluT+UZEfDPmWZdpOmf77QBMTrgDS/SuNZla609qrT+JedZlms65neBrAsAe4Q4syoFXk/nq zj9/pfPvPj7mq8vYbwdgKYQ7sDSH1mS2pl6X8frtACyCcAeW5tY1me1hhnWZpnO23w7ALIQ7sBgn rMlsTbku03TO7UhfBwDuJNyBJTm2JrM1ybqM/XYAlkS4Q2KllA/MfYeB3bkmszXhusyTYb8dgIUQ 7hxVSnmulPLpUsqHNxNIFqCU8jsR8Xop5b1z32UIZ6zJbE2xLtN0zvbbAZiNCOMU9yLihbh558gf lFJeFvLz2kT7lyPifRHxqZmvM5Tumsz9uH1NZmuKdZmmc24Hfn4AOJno4hTtzj8/EhH/OoT8bHai fTtd/kwp5T0zXmko3TWZl25bk9kae11m8738kc7D7VDPDwDnKrXWue/Awm0C5gexv+t7yP2IeDVu AqeNiDesFgznlmjf+lyt9U9muNIgNmsy34/9iftv1Vr/6sif+82I2P2cH0bEL9da3x7gTk9FxP/Z eeh+RDzu+xmAuZiOctQmVF498dNN5EdyR7RHRDyffOp+7prMVndd5rHNcw2h6ZzttwMwKxHFqdrO +Z/iJq6OEfIDOBLtETfRm3nX/aRXk+k6sC7Tfa6+ms65Heh5AaAXqzKcpJTy4bgJ7637EfFLEfEv 4iZwmrh5vetT1ml2Wa054kC0vx030+bf2HnszYj4YK31Hye83sX6rsns/PnB12UOrIc9VWt9ve9z AsClhDsnOSVkNp/zRAj5wdwR7b8bEV+PiO9FxMM7/y7drvst4X0/It5/ysR98+dvC//frLX+rwvu dN5+eyn7f5HWWvp+bQA4xJoCJzmw5950P6fW+nqt9cVa67MR8XhEPBURn4mIV8JqzVnuivZa69dq rT+KiBc7f+z5UsovTnXHgfRak9kaaV2m6ZzttwMwu6uJIAbRds7NXZ8s5Ps7Fu07j70YEW/tnB+N iD8Y/4bD6PGmS4d034zp2QvfjKnpnNsLngsABmFVhpMd2HPv/fJ4Vmtud0a0bz//jyLij3ceSrPr fumazM7zDLYu02u/3aoMABNY5bSS0bwR+1PyR+ImvHsZcSL/SinlM6WUp7JN5M+N9o3MU/eL1mS2 Bn4zpidjP9rvx833PgDMKlXUMK9T9twvff6BQv5fRcQX4uaXC9OEfM9oj6y77gOuyWx112U+3nNd pumc7bcDsAiLjRgWq+2cm7G+0DWFfN9o35Fx6n7bmy799QXPN9SbMTWdc9vzPgAwKDvunGXoPfcL 7zLUjvxr8WBH/jtT/2cZINq3z5Nq172U8t8j4vd3HvpSrfX3D31+z+f8b7XWf3fGn38obl4Hfvcl No+/frsddwAmINw5y5LfmGagkH8r9n/ZddSQHyraN8/13kjyuu4Hfpn0X9Za/+eFz3vRmzGd/frt D/6gcAdgdItYEyCPsffcLzHQas3Dsb9a88OxVmuGjPaIdLvuQ6/JbF26LtN0zvbbAVgM4U4fbefc zHCHo5Yc8kNH+44su+6DvJpM1wCvLtN0zu0l9wGAIVmV4WxL2nO/xFyrNSNG+/b5F73rPtaazM7z 91qX6b3ffvOHrcoAMDrhztmWvOd+iSlCfuxo33yNRe+6D/WmS3c8f683Y+q9337zh4U7AKOzKsPZ lrznfokJVmv+Q4wc7Zv/HEvfdR9lTWbrgnWZpnO23w7Aogh3+mo752aGO4xqhJD/8xg52ncsctd9 hDddOqTPmzE1nXM72G0AYABWZehlLXvul7hwtWbMaI+IZe66j70ms/N1zlqXuWi//eYJrMoAMDoT d/p6I/Ynzo/ETcRejQsm8qNH+8YSp+7dNZlXho72iF7rMk/GfrTfj5vv8VO/YNn7AIARCHd6Weue +yVODPmfRsS/nSDaF7frfmBNprvSMqRz1mWaztl+OwCLI9y5RNs5NzPcYbEOhPwHa61j7HQfsqSp +1hvunTIbW/G9NEDn9t0zu0I9wGAiwh3LtF2zk8P+c6ia7MJ+b+b+Gsuaeo+yZrM1oF1me4dtvvt T3cebke6FgD0JrK4xNXvuScx+9R9hjWZQ1/jtnWZy/bbAWAiwp3e7LnnsJCp+9RrMlunrMs0nbP9 dgAWSbhzqbZzbma4A8fdNnX/1IRff9I1ma0TX12m6Zzbse4DAJcQ7lyq7ZztuS/Qgan7Z6eYuk/4 pkuHdNdlfnu7LmO/HYBMBBaXsueex1xT99vWZL4+wdfdumtdxn47AGkIdy5izz2PGafus6zJbB1Z l2k6j9tvB2CxhDtDaDvnZoY7cJpJp+4LWJPZOvTqMk3n8XaS2wBAD8KdIbSdsz33hZph6t5dk3kr pl2T2equyzweEc+E/XYAEhFXDMGeey5TTt27azIvT7kms3VgXebzYb8dgESEOxez557LZur+Qufh wafuC1qT2equy/xq52y/HYBFE+4Mpe2cmxnuwOm+GONP3ZeyJrPVXZfpaie6BwD0ItwZSts523Nf sImm7otYk9k6sC6zq53oKgDQi7BiKPbc8xlt6r7ANZmt7rrM1mX77aXUvQ8AGIFwZxD23PMZeeq+ tDWZrUPrMvbbAVg84c6Q2s65meEOnGesqfui1mS27liXaSe+CgCcTbgzpLZztue+cGNM3Re8JrN1 27pMO/UlAOBcoooh2XPPaeip+08jonQe+/4Fzze07rqM128HIAXhzmA2O8KvdR5uZrgKZxh66n7g 9x1+vc9zjWGzLvPSzkP22wFIQbgztLZzbma4A+cbeureds7NBc81ht3VnXauSwDAOYQ7Q2s7Z3vu CYyw6952zkv7PvhGRPxw88/tjPcAgJMt6Qcp6/CdsOee1ZBT9+7vOzwcEU/2fK7B1Vrfjpt1Gfvt AKQh3BmUPfe8Dkzdn+8zdU/yuv5fjYjX7LcDkIVwZwxt59zMcAf66U7dH4v+U/e2c256Ps9YvhkR X5v7EgBwKuHOGNrOeWn7zRww5NQ9Fv59sFmX+cu57wEAp1rMD1FWxZ57bkNN3Re95x4RUWutc98B AE4l3BmcPffchpq6J9lzB4A0hDtjaTvnZoY70N9QU/e2c2563gcArp5wZyxt57yo/WbuNuCue9s5 +z4AgJ78AGUs9tzzu23q/tyZz7H4PfdB1Fr2PgBgBMKdUdhzz2+Id1O15w4AwxHujKntnJsZ7sBl hpi6t51zc8F9AOBqCXfG1HbO9puTGWLqHr4PAGAQfngypu/E/rTWnntOl07dr2PPHQBGJtwZjf3m dbh06u73HQBgGMKdsbWdczPDHbjcpVP3tnNuLrwPAFwd4c7Y2s7ZfnNCd0zdf+HEp2g7Z98HAHAm PzgZmz339bjk3VS7r+tvzx0AziTcGZU99/W4ZOpuzx0ALifcmULbOTcz3IFhfDH2J+fnTN3bzrkZ 4D4AcDWEO1NoO2f7zUlduOveds6+DwDgDH5oMgV77uvSd+re/T6w5w4AZxDujM6e+7rUWv8hekzd fR8AwGWEO1NpO+dmhjswnL5T97Zzbga6DwCsnnBnKm3nbL85sb5T93j398FHfB8AwGn8wGQq9tzX p8/U/bbvg/x77qXUvQ8AGIFwZxL2m9enz9Td9wEA9CfcmVLbOTcz3IFh9Zm6t51zM+B9AGC1hDtT ajtne+7J9dx1bztne+4AcAI/LJmSPfd1Onfqvs49dwAYmXBnMvab1+ncqfvm++C1zsPNCFcDgFUR 7kyt7ZybGe7A8M6duredczPwfQBgdYQ7U2s7Z3vuK9Bj173tnO25A8ARflAyNXvu63XO1P31sOcO AGcR7kzKnvt6nTN1t+cOAOcT7syh7ZybGe7AOG6buj934HPbzrkZ4T4AsBrCnTn8uHO2574SB6bu f3hg173tnO25A8Ad/JBkUqWU34mbqeyu90TEB2a4DuM4dep+256733cAgAOEO5PZRPuXI+LezsNv R8Tv1lr/bp5bMbRTp+723AHgPMKdSRyJ9q/OcytGdOrUve2cm5HuAwDpCXdGdyTavzbPrRjTGbvu befs9x0A4AA/IBmVaL9qp0zdX4+IH+2cc+6511r2PgBgBMKd0Yj263bK1N3r+gPA6YQ7oxDtbJwy dW8752bE+wBAWsKdwYl2tk7cdf9W59/bcweAW/jhyKBEO7c4NnX/dqxhzx0ARibcGYxo5zbHpu5e zx0ATiPcGYRo54hjU/e28/nNyPcBgHSEOxcT7Ryzmbp/ofPwZ3d23dvOv7PnDgAdfjByEdHOGf4s 9qfuj8eDqbs9dwA4QrjTm2jnHHdN3e25A8Bxwp1eRDs93TV1bzuf20xwHwBIQ7hzNtFOX0d23dvO 4/bcAWCHH4qcRbQzgENTd3vuAHAH4c7JRDtDODR1j4ifD3vuAHCQcOckop2BHZq6t53Paya6DwAs nnDnqAPRHhHxzYj4+vQ3Irs7pu5/03nMnjsAbPiByJ1KKR+IiL+Id0d7RMRvRMT3Sil/VEp577Q3 YwVum7r/WmTccy+l7n0AwAiEO3eqtf7fiPhnEfGfIuLNWz7l4Yj44xDwnOnA1P3TEfF657FmkgsB wMKVWg2HOE0p5T0R8amIeD4iHj3waW9FxIsR8WKt9UcHPgci4p3vqe/FzWR96/9FxPt2zq/UWp+d 8l5n607Zay0z3QSAFRPunE3AM6RSyuci4vN3fMr9iHh88+6qyyTcAZiAcKe3UsovRsQfhIDnAgem 7l1P1Vq7KzTLIdwBmIAdd3qrtf5jrfVPIuKDEfG5sANPDwd23buaCa4CAItm4s5gTODp64Sp+7L3 3E3cAZiAcGdwAp4+juy6L3vPXbgDMAHhzmgEPOc4Yeq+3D134Q7ABOy4Mxo78JzjhF33ZqKrAMAi mbgzGRN4jjkydV/unruJOwATEO5MTsBzlzt23Ze75y7cAZiAcGc2Ap7bHJm6L3PPXbgDMAE77szG Djy3ObLr3kx4FQBYFBN3FuOMCfwLEfFFE/j1umPqvsw9dxN3ACYg3FmcTcB/KiI+GwL+ah3YdV/m nrtwB2ACwp3FEvDX7Y6p+zL33AFgZHbcWazNDvx/jZsd+P8Yh3fg/0vc7MD/Zzvw63HHrnsz8VUA YBFM3EnDBP76bKbu3439/38vc88dAEZm4k4aJvDXZzN1f2HnoR9HxN/PdB0AmJWJO2mZwF+HzdT9 5Yj4HxHx5Vrrbf+FDQBWT7iTnoAHAK6BcGc1BDwAsGbCndUR8ADAGgl3Vmsn4J+PiMcOfJqABwBS EO6snoAHANZAuHM1BDwAkJlw5+oIeAAgI+HO1doE/HNx80usAh4AWDThztU7MeDvx4OA/4ep7gYA sCXcYUPAAwBLJtyhQ8ADAEsk3OGAUsovxIM3chLwHFbK/l+ktZaZbgLAigl3OELAc5RwB2ACwh1O JOA5SLgDMAHhDmcS8LyLcAdgAsIdehLwvEO4AzAB4c5qlFJ+LiJ+Wmv92cRfV8BfO+EOwASEO6lt Yv2ZiPhERDwbESUiXo2IdvPxxlQhL+CvmHAHYALCnXRuifVH7/j0+zFxyAv4KyTcAZiAcCeFM2P9 LpOFvIC/IsIdgAkIdxZrwFi/y+ghvwn45yLiD0PAr5NwB2ACwp1F6Rnrb0XEyxHx1Yj4fkT8ekQ0 EfF0RDx85hXuR8Rr8SDkvzNUyAv4FRPuAExAuDO7AWL967XWn9zyvA9FxJNxE/FNLCTkBfwKCXcA JiDcmcVYsX7kaw4R8m/F/mpN75A/I+C/EBF/JuAXTLgDMAHhzmR6xvr9iHglesb6kfssIuQF/AoI dwAmINwZ1dJi/S4Dhvzuas3rp4a8gE9MuAMwAeHO4C6M9a9ExF9PFet3mSvkdwL+sxHx+IFPE/BL ItwBmIBwZxBrifW73BLyH4mIR858mpNDXsADALuEO71dEOvbXzBdfKzfZaCQ/1E82JH/VkR8uxvy Ah4AiBDunOnaY/0uA4b87kT+nZAX8ABw3YQ7R4n1fsYK+Yj4+RDwAHB1hDu3EuvD24T8E7H/y66X hPzfRMSvRcSnQ8ADwOoJd95xYax/JSK+IdZPN2DIvx4R/zwi3nfH5wl4AEhOuF85sb4cA4X8MQIe AJIS7lfoglh/KW7WYMT6BEYOeQEPAMkI9yvRM9bfjAc762J9ZiOFvIAHgCSE+4qJ9XUbOOTfjIgX QsADwGIJ95UppdyLB7H+8RDrV2OgkP/ftdaPDXszAGAIwn0FNrH+0Yj4ZNzE+mMn/DGxvnI9Q/65 Wuufj3szAKCPe3NfABjH5h1XX998vHhCyP84Ir487S0BgFOZuK+MVRlOdUvI/32t9d/PeScA4DDh vmKbX079WNys0PjlVACAxIT7ldiZxIt4AICEhPsVsk4DAytl/y/SWstMNwFgxYT7lRPxMADhDsAE hDvvEPHQk3AHYALCnVuJeDiDcAdgAsKdozoR/2x4gyfYJ9wBmIBw5yybiN99iUkRD8IdgAkId3oT 8bAh3AGYgHBnEDsRv92JF/FcD+EOwASEO4MT8Vwd4Q7ABIQ7oxLxXAXhDsAEhDuTEfGslnAHYALC nVlsIv6jcfOLrSKe3IQ7ABMQ7sxOxJOecAdgAsKdRdmJ+E9ExG+HiCcD4Q7ABIQ7i9WJ+I9HxOMn /LE3I+KleBDxb493Q9gQ7gBMQLiTwibin4mIz0fEr574x34YDyL+myKe0Qh3ACZwb+4LwCGllIci 4smIaDYfT0fEw2c8xWMR8W8i4pci4v2llL+s/psqYxDqAExAuLMYA4R6RMT9iHg1ItrNxxu11p8N dUcAgLkId2Yj1AEATifcmYxQBwDoT7gzGqEOADAc4c5ghDoAwHiEO73dEuofiYhHznwaoQ4AcALh zsmEOgDAfIQ7Bwl1AIDlEO68YxPqT8T+jrpQBwBYAOF+xYQ6AEAewv2KCHUAgLyE+4oJdQCA9RDu KyLUAQDWS7gnJtQBAK6HcE9EqAMAXC/hvmBCHZIope6day0z3QSAFRPuCyLUAQA4pNRaj38Wh3Un bV1nTN5KKb8XEV8658s/Gjd132w+noiIvS946eTv2H++Y3x9X9/X9/V9fV/f14dBmLgvy7eOfcIj 8e5Qf2jUKwEAsATCfUFqrd8tpXw3Ij60fUyoAwAQIdyX6KWI+JXY7Kj/IOLbQh0AADvuAJfyqjIA TMAwFwAAEhDuAACQgHAHAIAEhDsAACQg3AEAIAHhDgAACQh3AABIQLgDAEACwh0AABLwzqkAAJCA iTsAACQg3AEAIAHhDgAACQh3AABIQLgDAEACwh0AABIQ7gAAkIBwBwCABIQ7AAAkINwBACAB4Q4A AAkIdwAASEC4AwBAAsIdAAASEO4AAJDAvbkvAJBeKXXvXGuZ6SYArJiJOwAAJCDcAQAgAeEOAAAJ CHcAAEhAuAMAQALCHQAAEhDuAACQgHAHAIAEhDsAACQg3AEAIAHhDgAACQh3AABIQLgDAEACwh0A ABIQ7gAAkECptc59BwAA4AgTdwAASEC4AwBAAsIdAAASEO4AAJCAcAcAgASEOwAAJCDcAQAgAeEO AAAJCHcAAEhAuAMAQALCHQAAEhDuAACQgHAHAIAEhDsAACQg3AEAIIF7c18AIL1S6t651jLTTQBY MRN3AABIQLgDAEACwh0AABIQ7gAAkIBwBwCABIQ7AAAkINwBACAB4Q4AAAkIdwAASEC4AwBAAsId AAASEO4AAJCAcAcAgASEOwAAJCDcAQAggVJrnfsOAADAESbuAACQgHAHAIAEhDsAACQg3AEAIAHh DgAACQh3AABIQLgDAEACwh0AABIQ7gAAkIBwBwCABIQ7AAAkINwBACAB4Q4AAAkIdwAASEC4AwBA AvfmvgBAeqXUvXOtZaabALBiJu4AAJCAcAcAgASEOwAAJCDcAQAgAeEOAAAJCHcAAEhAuAMAQALC HQAAEhDuAACQgHAHAIAEhDsAACQg3AEAIAHhDgAACQh3AABIQLgDAEACpdY69x0AAIAjTNwBACAB 4Q4AAAkIdwAASEC4AwBAAsIdAAASEO4AAJCAcAcAgASEOwAAJCDcAQAgAeEOAAAJCHcAAEhAuAMA QALCHQAAEhDuAACQgHAHAIAE7s19AYD0Sql751rLTDcBYMVM3AEAIAHhDgAACQh3AABIQLgDAEAC wh0AABIQ7gAAkIBwBwCABIQ7AAAkINwBACAB4Q4AAAkIdwAASEC4AwBAAsIdAAASEO4AAJCAcAcA gARKrXXuOwAAAEeYuAMAQALCHQAAEhDuAACQgHAHAIAEhDsAACQg3AEAIAHhDgAACQh3AABIQLgD AEACwh0AABIQ7gAAkIBwBwCABIQ7AAAkINwBACAB4Q4AAAncm/sCAOmVUvfOtZaZbgLAipm4AwBA AsIdAAASEO4AAJCAcAcAgASEOwAAJCDcAQAgAeEOAAAJCHcAAEhAuAMAQALCHQAAEhDuAACQgHAH AIAEhDsAACQg3AEAIAHhDgAACZRa69x3AAAAjjBxBwCABIQ7AAAkINwBACAB4Q4AAAkIdwAASEC4 AwBAAsIdAAASEO4AAJCAcAcAgASEOwAAJCDcAQAgAeEOAAAJCHcAAEhAuAMAQALCHQAAErg39wUA 0iul7p1rLTPdBIAVM3EHAIAEhDsAACQg3AEAIAHhDgAACQh3AABIQLgDAEACwh0AABIQ7gAAkIBw BwCABIQ7AAAkINwBACAB4Q4AAAkIdwAASEC4AwBAAsIdAAASKLXWue8AAAAcYeIOAAAJCHcAAEhA uAMAQALCHQAAEhDuAACQgHAHAIAEhDsAACQg3AEAIAHhDgAACQh3AABIQLgDAEACwh0AABIQ7gAA kIBwBwCABIQ7AAAkcG/uCwCkV0rdO9daZroJACtm4g4AAAkIdwAASEC4AwBAAsIdAAASEO4AAJCA cAcAgASEOwAAJCDcAQAgAeEOAAAJCHcAAEhAuAMAQALCHQAAEhDuAACQgHAHAIAEhDsAACRQaq1z 3wEAADjCxB0AABIQ7gAAkIBwBwCABIQ7AAAkINwBACAB4Q4AAAkIdwAASEC4AwBAAsIdAAASEO4A AJCAcAcAgASEOwAAJCDcAQAgAeEOAAAJCHcAAEjg3twXAEivlLp3rrXMdBMAVszEHQAAEhDuAACQ gHAHAIAEhDsAACQg3AEAIAHhDgAACQh3AABIoNRaj38WAAAwKxN3AABIQLgDAEACwh0AABIQ7gAA kIBwBwCABIQ7AAAkINwBACAB4Q4AAAkIdwAASEC4AwBAAsIdAAASEO4AAJCAcAcAgASEOwAAJCDc AQAgAeEOAAAJCHcAAEhAuAMAQALCHQAAEhDuAACQgHAHAIAEhDsAACQg3AEAIAHhDgAACfx/JaIM XTC2rpcAAAAASUVORK5CYII= ";
  hoja_arce = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAu4AAAIhCAYAAAARoz+rAAAABHNCSVQICAgIfAhkiAAAHr5JREFU eJzt3X2stHld3/HPb3OTCi7L7o2BrX+5f1htim2VB2uqFgtUQcOutqytgshD0jRlkYemKRaq7WLx n8qWGvsHu0CDre0ukaWNiG1BxaQthQWfapq0FtJahQbuRcpDE42//nHm7D0ze515OHPNdV2/a16v 5ITMzLnP/ELWm/d+/f7mlFprAACAabth7AMAAADbCXcAAGiAcAcAgAYIdwAAaIBwBwCABgh3AABo gHAHAIAGCHcAAGiAcAcAgAYIdwAAaIBwBwCABgh3AABogHAHAIAGCHcAAGiAcAcAgAYIdwAAaIBw BwCABgh3AABogHAHAIAGXBn7AACsKaWuPK61jHQSACbExB0AABog3AEAoAHCHQAAGiDcAQCgAcId AAAaINwBAKABwh0AABog3AEAoAHCHQAAGiDcAQCgAcIdAAAaINwBAKABwh0AABog3AEAoAHCHQAA GlBqrWOfAQAA2MLEHQAAGiDcAQCgAcIdYEJKKTeVUv5NKeXbxj4LANMi3AGm5a4k35XkA6WUD5RS vmnsAwEwDcIdYCJKKY9P8pqlp74tybNGOg4AEyPcAabjlUmuLj2+luQtI50FgIkR7gAT0DFtT5I3 11o/N8Z5AJge4Q4wDabtAGwk3AFGZtoOwC6EO8D4TNsB2Eq4A4zItB2AXQl3gHGZtgOwE+EOMBLT dgD2IdwBxmPaDsDOhDvACEzbAdjXlbEPAHCiLp62l1JXvrPWMtipAJgsE3eAgZm2A3AZwh1geHbb AdibcAcYkGk7AJcl3AGGZdoOwKUId4CBmLYDcAjhDjAc03YALk24AwzAtB2AQwl3gGHcFdN2AA4g 3AGObDFtf+3a06btAOxFuAMcn2k7AAcT7gBHZNoOQF+EO8BxmbYD0AvhDnAkpu0A9Em4AxyPaTsA vRHuAEdg2g5A366MfQCAmbr8tL3WcowDAdA2E3eAnpm2A3AMwh2gf3bbAeidcAfokWk7AMci3AH6 ZdoOwFEId4CeLKbtr1l72rQdgF4Id4D+3JXkiUuPTdsB6I1wB+iBaTsAxybcAfph2g7AUQl3gAOZ tgMwBOEOcLhXxLQdgCMT7gAH8LntAAxFuAMcxrQdgEEId4BLMm0HYEjCHeDyTNsBGIxwB7gE03YA hnZl7AMANOp40/ZS6srjWksvPxeAppm4A+yplHJjTNsBGJhwB9if35IKwOCEO8AeTNsBGItwB9iP aTsAoxDuADsybQdgTMIdYHem7QCMRrgD7MC0HYCxCXeA3Zi2AzAq4Q6whWk7AFMg3AG2M20HYHTC HWAD03YApkK4wwkrpVwppVwZ+xwTZ9oOwCQId+A3SylvLaV8u4hfZdoOwJQIdzhhtdY/TPIrSV6e 5H1JPlVKuW8R8Y8Z93ST8IqYtgMwEaXWOvYZgBGVUr49Z9G+7lqSB5Pcn+T9i8g/GYtp+yeyGu5v qLW+cYA3X/2LudZy9PcEYPKEO5y4xXrMp5Jc3fBtJxfxpZS/k+RNS09dS3KbNRkAxmJVBk7cIsIf 3PJtV5O8NNfXae6d8078Ytr+t9aettsOwKhM3IGUUr4jyc9f4o9eS/LuJA9kRpN403YApki4A1lc RP1kVtdl7klyc5I7Fv+5zSwiftTddgDYwKoMkFrrH+TR6zI311pfkuRJSb4zyTuSfHbDj7ma5GVp f53GJ8kAMEkm7kCSznWZzyZ50iLqz7/nMUmek+QF2X0S/5lcv9j6gSlP4k3bAZgy4Q4kuXBd5jtr re/d8P2zini77QBMmVUZIMmF6zIv2PT9tdb3dqzTPLzhbZ6Ys3WaX0jyycU6zV+awjqNT5IBYOpM 3IFH7LIus8PPeEySZye5M8ntSW7Z4Y99Jtcvto4yiTdtB2DqhDvwiH3XZXb8eZOP+MW0/eNJvmLp abvtAEyKVRngEfuuy+zy82qtP79Yp3lykucleXu2r9O8PNfXad46wDrNK7Ia7T5JBoDJMXEHVvSx LrPDe5xP4s8vto42iTdtB6AVwh1Y0fe6zI7vd9mIvz/JLx4S8XbbAWiFVRlgRd/rMru832Kd5qXZ f53m3+b6Os1z9l2nWUzbX7v2tE+SAWCSTNyBRxliXWaHMxx9Em/aDkBLhDvwKEOvy+x4nmfl7NNp 9on4n83ZTvyjIt5uOwCtEe5Ap1LKfUleuvTUOxafDjOqS0b8p3P9Yusv1lr/cNLT9lJW/2KutYx0 EgAmRLgDnaawLrPNUsSfr9Nc3fwnklyP+O/OVKftwh2ADsId6DS1dZltLhnx56YzbU+EOwCdfKoM 0GnoT5c51OLTad5Xa31ZkluTPDfJ23IW5dv4JBkAJs/EHbhQC+sy2+wwiZ/WtD0xcQegk4k7sMn7 szqxvjnJc0Y6y6XsMIn/R5OKdgC4gIk7sNFUP13mUItf1vQXk/yHWuvnxz7PChN3ADoId2CjOazL NEe4A9DBqgywTfPrMgAwB8Id2Ki1T5cBgLkS7sAuHlh7fPvi01oAgIEId2AX70/y8NLjW2JdBgAG JdyBrRbrMu9ee9q6DAAMSLgDu7IuAwAjEu7ArqzLAMCIhDuwE58uAwDjEu7APu5fe2xd5hhqLStf ABDhDuyna13m2SOdBQBOinAHdnbBusydY5wFAE6NcAf2ZV0GAEYg3IF9WZcBgBEId2Av1mUAYBzC HbgM6zIAMDDhDlyGdRkAGJhwB/ZmXQYAhifcgcuyLgMAAxLuwGVZlwGAAQl34FKsywDAsIQ7cIgH 1h5blwGAIxHuwCH+fazLAMAghDtwadZlAGA4wh04lHUZABiAcAcOZV2mb6XUlS8AiHAHDnTBuswL xjgLAMyZcAf6sL4uc4d1GQDol3AH+mBdBgCOTLgDB7MuAwDHJ9yBvliXAYAjEu5AX6zLAMARCXeg F9ZlAOC4hDsMoJTy9lLK48Y+xwCsywDAkQh3GMYPJvlQKeVrxz7IkVmXAYAjEe4wnKck+Ugp5YVj H+RYrMsAwPEIdxjWlyd5Zynl3lLKY8c+zJFYlwGAIxDuMI6XZb6rM9ZlAOAIhDuM5+uSfHhuqzPW ZQDgOIQ7jOvGzHN1xroMAPRMuMM0zG11xroMAPRMuMM4fjDJF9eem83qjHWZA9VaVr4AIMIdRlFr /WdJnp7kt9ZemtPqjHUZAOiRcIeR1Fp/K2fx/o6Ol+ewOmNdBgB6JNxhRLXWL9ZaX5IZrs5YlwGA fgl3mIAZr85YlwGAngh3mIiZrs5YlwGAngh3mJC5rc5YlwGA/gh3mKCl1Zn/svZSi6sz1mUAoAfC HSZqsTrzjLS/OmNdBgB6INxhwuawOrNYl3nP2tPWZQBgT8IdGjCD1Zn71x5blwGAPQl3aETjqzPW ZQDgQMIdGtLq6ox1GQA4nHBno1LKXy+lvKeU8qpSyp8tpfhnZgIaXZ2xLgMAByi11rHPwISVUm5M 8okkT1w89XCSDyb5pcXXr9da/2iMs7WklLLyf2i11tLTz31ckp9M8pKOl38jyZ211v/ax3sdahHp n8rZmsy559Za3zfSkQCgKaanbFRr/XySn1h66pYktyd5c5KPJfl0KeVBE/lxLFZnXprkxUm+sPby pFZnLliXuXOMswBAi0zc2aqU8vicTd2v7vDtJvIdjjVxX3uPP5mzX3b0pzpevi/JXbXWL/X9vvso pTw3yXuXnno4yZMXUc+5tX9ecoR/XgBoj3BnJ6WU1ye5+xJ/VMhnmHBfvM+kV2esy+xIuAPQQbiz k1LKTUk+nt2m7pucZMgPFe5L7/cDSX4qyZevvfT5JH+j1vrTx3z/TUopb8/Zp+Kce/ti3Ydzwh2A DsKdnXVM3R9OckeSpyZ5ZpJvTXLznj/2WpJfyfWQ/7U6w38ohw73xXtOcnXGuswOhDsAHYQ7O7tg 6v66WuuPL16/IcmfyVnEPzOXC/lZTuTHCPfF+05udca6zA6EOwAdhDt76Zi6fzrJbYtPn1n/XiG/ MFa4L73/pFZnrMtsIdwB6CDc2cu2qfuWP3uyIT92uC/OsGl15t4krxxqdaaU8rwkP7f0lHWZZcId gA7Cnb3tM3Xf8nNOJuSnEO6Lc0xidca6zBbCHYAOwp29HTJ13/JzZxvyUwn3c1NYnbEus4FwB6CD cOdS+pq6b3mP9ZD/lqxOaHcxiZCfWrgn46/OWJfZQLgD0EG4cynHmrpvec9mQ36K4Z6MuzpjXWYD 4Q5AB+HOpQ0xdd/y/s2E/FTD/dxYqzMd6zJvq7W+7Bjv1RThDkAH4c6ljTF133Ke5ZD/CznbkZ9E yE893JNHVmfuT/KUjpePsjpjXeYCwh2ADsKdg3RM3T+T5KuGmrpvsgj5P53Vy66jhHwL4Z48sjrz T5J0XRLtfXVmsS7zf7J6Cdm6jHAHoINw5yBTm7pvMmbItxLu50opL0ryTzPA6ox1mQ7CHYAOwp2D TXnqvsmQId9auCfDrc50rMtcS3LrSa/LCHcAOgh3DtbS1H2TY4Z8i+GeJKWUx+bsU2eOtjpjXQYA diPc6UWrU/dNeg7525efbCXczx17dca6DABsJ9zpxVym7pv0FPJJ2gv35LirM9ZlAGA74U5v5jh1 3+SQkG8x3JPjrc5YlwGA7W4Y+wDMyltyNik998QkrxjpLEdXa/2jWuuv1lrvqbXekeQrknx9klcn eU/O1mRmpdb6pcUKyw8k+cLay1+X5MOllBde4uf+QZIH155+weVOCQDzZOJOr05t6r7Jpol8qxP3 ZaWUr03yQHpanbEuAwCbCXd6dcGu+w/XWt800pEmYznka633jH2ePvS5OmNdBgA2sypDr2qtn0vy 5rWnX1tKuXGM80zJ8mrN2GfpS5+rM9ZlAGAz4c4xdO263zXSWRhArfWdSZ6W5DfXXroxyTtLKW9d TOe3eWDt8R2LSTwAnDzhTu9M3U/TYiXmGUne1vHyy5N8aLEXv8m/S/LZpcdXkzyrnxMCQNuEO8di 6n6CDl2dsS4DABcT7hyFqftpO3B1xroMAHQQ7hyTqfsJW1qdua/j5U2rM9ZlAKCDcOdoTN1ZrM68 PMmLsuPqjHUZAOgm3Dk2U3dSa/3p7Lc6Y10GANYId47K1J1ze67OWJcBgDXCnSGYupNk99WZk1+X KaWufAFAklKr/03g+Eopr09y99JTn0nyVbXWz490JEa2mK4/kOQpHS/fm+QXsroycy3JrYuon7f1 WK+1jHQSACbExJ2hmLqzYofVmTcmWQ5Y6zIAnDThziA27Lo/fozzMA1bVme+Jsn6pPl01mUAYI1w Z0hdU/dXjHQWJmTpU2d+Y8u3+nQZAE6WcGcwpu5sslid+cZ0r86csy4DwMkS7gzN1J0LbVmdOWdd BoCTJNwZlKk7u9iyOmNdBoCTJNwZg6k7W21YnbEuA8BJEu4MztSdXa2tzix/5v+dIx0JAEYj3BmL z3VnZ4vVmafn+uqMdRkATo5wZxQXTN1fY+rORdZWZ25J8uxxTwQAwxLujMnUnb2src48b+zzAMCQ Sq11+3fBkZRSXp/k7qWnPpPktlrr/x3pSDSilHJrrfWTY5/jKEpZ/Yu51vXfIAvACTJxZ2ym7lzK bKMdAC4g3BmVT5gBANiNcGcK1qfuV2Pqzimrtax8AUCEOxNg6g4AsJ1wZypM3QEANhDuTIKpOwDA ZsKdKTF1BwC4gHBnMkzdAQAuJtyZGlN3AIAOwp1JMXUHAOgm3JkiU3cAgDXCnckxdQcAeDThzlSZ ugMALBHuTJKpOwDAKuHOlHVN3V850lkAAEYl3JmsC6burzF1BwBOkXBn6kzdAQAi3Jk4U3cAgDPC nRaYunNaSqkrXwAQ4U4DTN0BAIQ77TB1BwBOmnCnCabuAMCpE+60xNQdADhZwp1mmLoDAKdMuNMa U3cA4CQJd5pi6g4AnCrhTotM3QGAkyPcaY6pOwBwioQ7rTJ1BwBOinCnSabuAMCpEe60zNQdADgZ wp1mbZi63zTGeQAAjkm407quqftdI50FAOBohDvNKqU8Icmrkzxm7SVTdwBgdoQ7zSmlPKGU8iNJ PpHkR5OsX0i9muRvDnws6E+tZeULAJJcGfsAsKvFhP1Vi6+bL/i2a0nuSfJTQ50LAGAIwp3J2zHY H07yE0nesri0CgAwK8KdyRLsAADXCXcmZxHsP5Szi6eCHQAgwp0JEewAABcT7oxuj2B/c5J/LNgB gFMk3BmNYAcA2J1wZ3CLX470qgh2AICdCXcGswj28wn7LRd8m2AHAOgg3Dk6wQ4AcDjhztHsGOyf zfVg//2hzgYA0BrhTu8EOwBA/4Q7vVkE+yuTvCaCHQCgV8Kdgwl2AIDjE+5cmmAHABiOcGdvewT7 PUnuEeywp1LqyuNay0gnAWBChDs7E+wAAOMR7mxVSnl8rgf71Qu+TbADAByRcGejUsozk7wryRMv +BbBDgAwgFJr3f5dnKxSSknyY0le1/HyJ5N8Q63194Y9FcycHXcAOtww9gGYtnrmh5N8f5L/t/by rUn+dSnlK4c/GQDAaTFxZ2ellG9M8mDOgn3Z7ya5vdb6keFPBTNk4g5ABxN3dlZr/VCSpyf52NpL X5nkg6WUO4c/FQDAaRDu7KXW+jtJvjnJz6699Ngk/7KU8qOLvXgAAHok3NlbrfWLSf5Kzi6tLitJ fiRnAf/YwQ8GADBjdtw5SCnl+5Lcl+TL1l76SM723n93+FNB4+y4A9BBuHMwl1ahZ8IdgA5WZTiY S6sAAMcn3OmFS6sAAMcl3OmNS6sAAMdjx52j2HBp9aEkz3dpFTaw4w5AB+HO0bi0CgDQH6syHI1L qwAA/RHuHNXi0uq3xKVVAICDWJVhEIs4vzvJ3+14+YEkL661fmnYUwEAtEO4M6gtl1Zvr7X+7+FP BQAwfcKdwbm0CgCwPzvuDG5xafUZufjS6vcOfyoAgGkT7oyi1vq/4tIqAMDOrMowKpdWAQB2I9yZ BJdWAQA2E+5MhkurAAAXs+POZCxdWv3VtZdcWgUATp5wZ1IWl1a/OS6tAgCssCrDJLm0CgCwSrgz aS6tAgCcEe5M3pZLq3fUWj88/KkAAIZlx53J23Jp9ZddWmV2SqkrXwAQ4U4jli6tvnvtpfNLq3/f pVUAYM6EO82otX4hyV9O8g87Xv57Sf5VKeWxw54KAGAYdtxpUinl+5PcG5dWmaP19Zha/X+TABDu tKuU8udytjrj0irzItwB6GBVhmbVWv9TXFoFAE6EcKdpLq0CAKdCuNO8HS+tPm7YUwEA9MuOO7Pi 0iqzYMcdgA7CndnZcGn193IW7y6tMm3CHYAOVmWYnQ2XVv94XFoFABol3Jkll1YBgLkR7szWDpdW 73dpFQBohR13TsLi0up9Sf7Y2ksurTI9dtwB6CDcORmLS6sPJnny2ksurTItwh2ADlZlOBmLS6tP j0urAECDhDsnxaVVmlBrWfkCgAh3TpBLqwBAi+y4c9I2XFr9aJLnu7QKAEyFcOfkubQKALTAqgwn b4dLq391+FMBAKwS7pCtl1Z/ppTyD1xaBQDGJNxhYcul1TfEpVUAYER23KGDS6sAwNQId7iAS6sA wJRYlYELbLm0+kGXVgGAIQl32GDp0uqDay99WVxaBQAGJNxhi8Wl1e9J8qaOl11aBQAGYccd9lBK eWGSe+PSKgAwMOEOe3JpFQAYg1UZ2NPSpdVfW3vJpVUA4GiEO1zC4tLqn49LqwDAQKzKwAEWcf5j SV7X8fK7kry41vrFYU9F80pZ/Yu5Vv8SCIBwhz64tEqvhDsAHYQ79GTLpdU7aq3/efhT0SThDkAH O+7Qk8Wl1Wek+9LqL7u0CgAcQrhDj2qt/zMurQIARyDcoWd+0yoAcAx23OGItlxavb3W+jvDn4rJ s+MOQAfhDkdWSvmmJO+OS6vsSrgD0MGqDBxZrfU/xqVVAOBAwh0G4NIqAHAo4Q4D2eHS6gMurQIA F7HjDiNwaZWN7LgD0EG4w0hcWuVCwh2ADlZlYCQ7XFr9a8OfCgCYKuEOI9pyafVflFLudmkVAEiE O4xuy6XV18elVQAgdtxhUlxaBQAuItxhYlxaBQC6WJWBiXFpFQDoItxhglxaBQDWCXeYqKVLqz/e 8bJLqwBwYuy4QwNKKS9K8tY8+tLqx5I836VVAJg/4Q6NcGkVAE6bVRlohEurAHDahDs0ZOnS6nvW XnJpFQBmTrhDYxaXVr87Lq0CwEmx4w4Nc2kVAE6HcIfGbbi0+skkt7u0CgDzYFUGGrfh0uqtcWkV AGZDuMMMuLQKAPMn3GEmXFoFgHmz4w4z5NIqAMyPcIeZWlxafTDJk9Zecml16kpZ/Yu5VmtOAFiV gblaXFp9epJfX3vJpVUAaJBwhxlzaRUA5kO4w8zVWj+fzZdW3+XSKgBMnx13OCEurTbCjjsAHYQ7 nJgtl1bvqLV+aPhTsUK4A9DBqgycmC2XVn+plPJ9w58KANhGuMMJ2nJp9Z+XUr5r+FMBAJtYlYET Vkq5IcnPJfmOpaevJbmt1vq5cU6FVRkAupi4w2m7Mckz1p57s2gHgOkR7nDaXpnk6tLja0neMtJZ AIANhDucqFLKTUlevfa0aTsATJRwh9Nl2g4ADRHucIJM2wGgPcIdTpNpOwA0RrjDiTFtB4A2XRn7 AMDgTNunzue2A9DBxB1OiGk7ALRLuMNpMW0HgEYJdzgRpu0A0DbhDqfDtB0AGibc4QSYtgNA+4Q7 nAbTdgBonHCHmTNtB4B5EO4wf6btADADwh1mzLR9OOXMV5dSvnfsswAwT6XWOvYZgCMppbw+yd1L T11LcptwP0wppST56iRPXXw9LcnXJ7kpSarffArAEVwZ+wDAcZi292NbpAPAUIQ7zJfd9j2tRfrT Fv8p0gGYBOEOM2Tavp1IB6A1wh3mybR9yZEi/bNJHlp8/e1DzwgA27icCjOzmLZ/PKvh/oZa6xtH OtKgliL9PND7ivSPJvlIFrFea/3tpfdc+YvU5VQAjsHEHebnZKbtY0T6INb+RSD+RQCACHeYlTnv ti8i/U/keqA/Nck3JHn8AT/2PNIfyiLUB490ANiRcId5mcW0fYBIPw/1/1HtCwLQCOEOM9HqtF2k A8BuhDvMx+Sn7QNF+kNJflukAzA3wh1mYIrT9iNF+u9nNdBFOgAnQ7jDPIw6be+I9Kfl7NNdDo30 lU93iUgH4IQJd2jc0NP2I0f6I5/uEpEOACuEO7TvaNP2tUhf/o2jfUX6eaiLdADYQrhDw/qctot0 AJg24Q5tu9S0faBIfyjJfxfpANAP4Q6N2nXavhTp54Eu0gGgQcId2tU1bf/JUsrXpP9I/1hWP91F pAPAwIr/7YX2LKbtH89quH8uSclhkf65PPrTXUT6FqWUlf9+aq3lwB+4+t/3oT8PgFkwcYc2rU/b k+SmPX/GcqSfh7pIB4CJMnGHxiym7Z9Icssef0ykH5GJOwBDMHGH9vxQNkf7eqQ/lOS/ifSGCHUA Opi4Q0NKKU/I2bT95sVTIn0Cep+4A0AH4Q4NKaU8L8m35izWPxq/zGgShDsAQxDuAAcS7gAM4Yax DwAAAGwn3AEAoAHCHQAAGiDcAQCgAcIdAAAaINwBAKABwh0AABog3AEAoAHCHQAAGiDcAQCgAcId AAAaINwBAKABV8Y+AABrSqkrj2stI50EgAkxcQcAgAYIdwAAaIBwBwCABgh3AABogHAHAIAGCHcA AGiAcAcAgAYIdwAAaIBwBwCABgh3AABogHAHAIAGCHcAAGiAcAcAgAYIdwAAaIBwBwCABlwZ+wAA rKm1jH0EAKbHxB0AABog3AEAoAHCHQAAGiDcAQCgAcIdAAAaINwBAKABwh0AABog3AEAoAHCHQAA GiDcAQCgAcIdAAAaINwBAKABwh0AABog3AEAoAHCHQAAGnBl7AMAsKaUuvK41jLSSQCYEBN3AABo gHAHAIAGCHcAAGiAcAcAgAYIdwAAaIBwBwCABgh3AABogHAHAIAGCHcAAGiA35wK0LOy/ptPL6mX HwLAbJi4AwBAA4Q7AAA0QLgDAEAD7LgDHKjWWnr9gT3tyAMwLybuAADQgFKrwQ4AAEydiTsAADRA uAMAQAOEOwAANEC4AwBAA4Q7AAA0QLgDAEADhDsAADRAuAMAQAOEOwAANEC4AwBAA4Q7AAA0QLgD AEADhDsAADRAuAMAQAOEOwAANODK2AcAYE0pdeVxrWWkkwAwISbuAADQAOEOAAANEO4AANAA4Q4A AA0Q7gAA0ADhDgAADRDuAADQAOEOAAANEO4AANAA4Q4AAA0Q7gAA0ADhDgAADRDuAADQAOEOAAAN EO4AANCAUmsd+wwAAMAWJu4AANAA4Q4AAA0Q7gAA0ADhDgAADRDuAADQAOEOAAANEO4AANAA4Q4A AA0Q7gAA0ADhDgAADRDuAADQAOEOAAANEO4AANAA4Q4AAA0Q7gAA0ADhDgAADRDuAADQAOEOAAAN EO4AANAA4Q4AAA0Q7gAA0ADhDgAADRDuAADQAOEOAAANEO4AANAA4Q4AAA0Q7gAA0ADhDgAADfj/ 010YUdZVvjYAAAAASUVORK5CYII= ";
  rellenoR = 244;
  rellenoG = 237;
  rellenoB = 200;
  var fin = 'round';
  var grid = 20;//Tamao de rejilla
  var colorFondo = '#f3f0e7';//color de fondo y del borrador
  var radioPuntos = 1.5;//radio de crculos en punteado
  var densidad = 5;//factor que marca la distancia entre puntos respecto al grosor del punto en punteado2 y pincelPluma
  var espaciado = densidad * 5;//separacin entre pinceladas en pincel compuesto
  var pincel = 10;//radio del area donde se dibujan los puntos en pincel aleatorio y del borrador
  var anchopluma = 2;//en pincel pluma el ancho en el que hay trazos
  var grosorpluma = 1;//Grosor de los trazos en pincel pluma
  var canvasWidth;
  var canvasHeight;
  function init () {
    // Localiza el elemento canvas.
    canvaso = document.getElementById('imageView');
    if (!canvaso) {
      alert('Error: No puedo encontrar el elemento canvas!');
      return;
    }
   altoNuevo = canvaso.height;
   anchoNuevo = canvaso.width;
    if (!canvaso.getContext) {
      alert('Error: no canvas.getContext!');
      return;
    }

    // Toma el 2D canvas context.
    contexto = canvaso.getContext('2d');
    if (!contexto) {
      alert('Error: failed to getContext!');
      return;
    }
	
    // Crea contexto para canvas que est encima de todo
	
    canvasTop = document.getElementById('imageTop');	
    contextTop = canvasTop.getContext('2d');
    if (!contextTop) {
      alert('Error: failed to getContext!');
      return;
    }	
	
	canvasWidth = canvaso.width;
	canvasHeight = canvaso.height;
	
	//Ponemos fondo color
	fondoColor();
	

    // Aade un canvas temporal.
    var container = canvaso.parentNode;
    canvas = document.createElement('canvas');
    if (!canvas) {
    alert('Error: No puedo crar un nuevo lienzo!');
    return;
    }
    canvas.id     = 'imageTemp';
    canvas.width  = canvaso.width;
    canvas.height = canvasHeight - 22;
	contTemp = document.getElementById('contenedor1');
    contTemp.appendChild(canvas);
    context = canvas.getContext('2d');



    // Activa la herramienta por defecto.
    if (tools[tool_default]) {
      tool = new tools[tool_default]();
    }
	//Pone por defecto el cursor lpiz
	$('canvas').css("cursor","url(imagenes/cursores/cursor_lapiz.png),auto");
	

    // Coloca mousedown, mousemove and mouseup event listeners.
    canvas.addEventListener('mousedown', ev_canvas, false);
    canvas.addEventListener('mousemove', ev_canvas, false);
    canvas.addEventListener('mouseup',  ev_canvas, false);
	canvas.addEventListener('dblclick',  ev_canvas, false);
	canvas.addEventListener('mouseout',  ev_canvas, false);
	canvaso.addEventListener('mouseup',  ev_canvas, false);
	
	//Eventos cuando se presiona una tecla
	window.onkeydown = function(evt) {
	evt = evt || window.event;
	if (evt.keyCode === 17) {
		keyControl = true;
		}
	}
	window.onkeyup = function(evt) {
	evt = evt || window.event;
		if (evt.keyCode === 17) {
			keyControl = false;
		}else if(evt.keyCode === 90 &&(keyControl)){//Deshace al presionar Ctrl + z
		undoDraw();
		}
	}
	//Evita seleccion azul
	document.onselectstart = function() {
	return false;
	}
	
	//Aqu ponemos una imagen de fondo si queremos
	ponerFondo(basicas);
	//Pone imagen por encima
	ponerRejilla();

}
	
	//Abre ventana para escribir texto en canvas
	$('#texto').click( function() {
		document.getElementById('text-controls').style.display = 'block';
		var textE1 = document.getElementById('text');
		//textE1.focus();
	})
	//Coloca texto al aceptar
	$('#botonTexto').click(function (){
		saveActions();
		contexto.save();
		contexto.fillStyle = colorFondo;
		contexto.fillRect(0,523, canvaso.width, 22);//rellena con color de fondo Si fuera una imagen habra que recargarla
		contexto.restore();
		titulo = document.getElementById('text').value;
		contexto.font = "12pt Verdana";
		contexto.fillStyle = "black";
		contexto.fillText(titulo, 20, 540);
		saveLocalStorage();
		document.getElementById('text-controls').style.display = 'none';
	})
	//Cierra ventana de colocar texto
	$('#botonTexCan').click(function (){document.getElementById('text-controls').style.display = 'none'});
	
	// Controlador de evento general. Esta funcin determina la
	// posicion relativa del ratn respecto al elemento canvas.Da las coordenadas del raton dentro del canvas
	function ev_canvas (ev) {
		if (ev.layerX || ev.layerX == 0) { // Firefox
		  ev._x = Math.round(ev.layerX / canvasScale);//multiplicamos por canvasScale para conpensar zoom
		  ev._y = Math.round(ev.layerY / canvasScale);
		} else if (ev.offsetX || ev.offsetX == 0) { // Opera
		  ev._x = Math.round(ev.offsetX / canvasScale);
		  ev._y = Math.round(ev.offsetY / canvasScale);
		}

		// Llama al manejador del evento de la herramienta
		var func = tool[ev.type];
		if (func) {
		  func(ev);
		}
	}

	// Esta funcin dibuja #imageTemp canvas encima de #imageView, despus
	// #imageTemp se limpia. Esto se realiza cada vez que el usuario
	// completa unaa operacin de dibujo.
	function img_update () {
  		saveActions();//Guarda copia de la imagen
		contexto.drawImage(canvas, 0, 0);//copia imagen temporal en definitiva
		context.clearRect(0, 0, canvas.width, canvas.height);//Limpia la imagen temporal
		redoHistory = [];
		saveLocalStorage();

	}
	//Function guarda imagen en array para poder deshacer
	function saveActions() {
		var imgData = document.getElementById("imageView").toDataURL("image/png");
		undoHistory.push(imgData);//guarda imagen en matriz deshacer
	}
	//Guarda imagen en el cache del navegador
	function saveLocalStorage(){
		var imgData = document.getElementById("imageView").toDataURL("image/png");
		localStorage.dibujo_simetria_01 = imgData;//guarda imagen en el cache del navegador
	}
	
	//Funcin pone fondo de color
	function fondoColor(){
	contexto.save();
	contexto.fillStyle = colorFondo;
	contexto.fillRect(0,0, canvaso.width, canvaso.height);
	contexto.restore();
	}
	
	//Pone una imagen como fondo
	function ponerFondo (imagenUrl){
		var img = new Image();
		img.src = imagenUrl;
		img.onload = function(){
		contexto.drawImage(img,0,0);
		}
	}
	
	//Funcion deshacer
	function undoDraw(){
		if(undoHistory.length > 0){
		var imgData = document.getElementById("imageView").toDataURL("image/png");
		redoHistory.push(imgData);//Guarda la imagen actual en array rehacer
        var undoImg = new Image();
			undoImg.onload = function(){//funcion para que le de tiempo a cargar la imagen
			contexto.drawImage(undoImg, 0,0);//copia imagen rescatada en canvas
			var imgData = document.getElementById("imageView").toDataURL("image/png");
			localStorage.dibujo_00 = imgData;//guarda imagen en el cache del navegador
			};
			undoImg.src = undoHistory.pop();//saca ultima imagen guardada en el array y la guarda en undoImg
        } else if(undoHistory.length == 0){
		return
		}		
	}
	
	function redoDraw(){
		if(redoHistory.length > 0){
		saveActions();
        var redoImg = new Image();
			redoImg.onload = function(){//funcion para que le de tiempo a cargar la imagen
			contexto.drawImage(redoImg, 0,0);//copia imagen rescatada en canvas
			var imgData = document.getElementById("imageView").toDataURL("image/png");
			localStorage.dibujo_00 = imgData;//guarda imagen en el cache del navegador
			};
			redoImg.src = redoHistory.pop();//saca ultima imagen guardada en el array y la guarda en redoImg
		}
	}
	
	
		//si existe almacenada imagen de anterior trabajo en navegador la carga
	if (STORAGE){
		if (localStorage.dibujo_simetria_01){
			if (confirm('Quieres recuperar el ltimo trabajo que se hizo con esta aplicacin?')) {
				localStorageImage = new Image();
				localStorageImage.addEventListener("load", function(event){
					localStorageImage.removeEventListener(event.type, arguments.callee, false);
					contexto.drawImage(localStorageImage,0,0);
				}, false);
				localStorageImage.src = localStorage.dibujo_simetria_01;	
			}
		}
	}
	

	//Pone una imagen por encima del canvas de dibujo.Por ejemplo para tener una rejilla
	function ponerRejilla(){
		var imgTop = new Image();
		imgTop.src = imagenEncima;
		imgTop.onload = function(){
		contextTop.drawImage(imgTop,0,0,750,545);
		}
	}
	//Control del boton limpiar
    $('#reset').click(function() {
        if (confirm('Se reiniciar el ejercicio y se perder la imagen actual. Ests seguro?')) {
		//canvaso.width = canvaso.width;
		undoHistory.length = 0;//vacia array con estados anteriores
		redoHistory.length = 0;
		contexto.save();
		contexto.fillStyle = colorFondo;
		contexto.fillRect(0,0, canvaso.width, canvaso.height);//rellena con color de fondo Si fuera una imagen habra que recargarla
		contexto.restore();
		//init();
		ponerFondo(basicas);
        }
    })

	//controlamos el boton guardar imagen
	$('#guardar').click (function() {
	var imgData = document.getElementById("imageView").toDataURL("image/png");
			var ventana = window.open('','imagenGenerada', "toolbar=no,location=no,status=no,menubar=no,resizable=yes,scrollbars=1");
			ventana.document.write('<html><head><title>Imaxe Xerada</title><meta http-equiv="content-type" content="text/html; charset=iso-8859-1"><link rel="stylesheet" type="text/css" href="css/dibujo_00.css" /> ');
			ventana.document.write('</head>');
			ventana.document.write('<body style="background-color:#F4EDC8">');
			ventana.document.write('<div  style="position:absolute; top:40px; left:50%; margin-left: -375px;  width:750px; height:545px; box-shadow: -2px 2px 10px 1px #999;"><div style="position:relative"></div><div><img src="');
			ventana.document.write(imgData);
			ventana.document.write('"width="750" height="545">');
			ventana.document.write('</div><br><div style="border-width:1;border-color:#901420;border-style:dashed;border-radius:15px; margin-top: 50px;margin-left: 150px; margin-right: 150px; margin-bottom: 20px; padding-left:20px; padding-right:20px; font-family:Verdana;font-size:16px;background-color:#f3f0e7;text-align:center">');
			ventana.document.write('<br><br>Para gardar a imaxe fai clic sobre ela co botn dereito. No men que aparece selecciona: "Gardar imaxe como..."');
			ventana.document.write('<br><br><button onclick="window.close();" class="botonVentana">Cerrar Ventana</button><br><br></div><br><br></div></body>');
			ventana.document.close();
	//window.open(document.getElementById("imageView").toDataURL("image/png"),'Canvas Export','height=450,width=625');
	})
	
	//Controla boton para poner o quitar la rejilla
	$('#rejilla').click (function(){
		if(flagRejilla == false){
			ponerRejilla();
			flagRejilla = true;
		}else{
			contextTop.clearRect(0,0,750,545);
			flagRejilla = false;
		}
	})

	// tools Contiene la implementacion de cada herramienta
	var tools = {};
	//Controles para saber que botn se ha seleccionado
	$('#cubo_pintura').click (function (){
	tool = new tools['cubo_pintura']();
	$('canvas').css("cursor","url(imagenes/cursores/cursor_cubo.png),auto");
	})
	$('#rectangulo').click (function (){
	tool = new tools['rect']();
	$('canvas').css("cursor","crosshair");
	})
	$('#borrar').click(function (){
	tool = new tools['borrador']();
	$('canvas').css("cursor","url(imagenes/cursores/cursor_goma.png),auto");	
	})
	$('#circulo').click(function (){
	tool = new tools['circle']();
	$('canvas').css("cursor","crosshair");
	})
	$('#linea').click(function (){
	tool = new tools['linea']();
	$('canvas').css("cursor","url(imagenes/cursores/cursor_lapiz.png),auto");
	})
	$('#poly').click(function (){
	tool = new tools['poly']();
	$('canvas').css("cursor","url(imagenes/cursores/cursor_lapiz.png),auto");
	})
	$('#colorPicker').click(function (){
	tool = new tools['cuentagotas']();
	$('canvas').css("cursor","url(imagenes/cursores/cursor_cuenta.png),auto");	
	})
	$('#deshacer').click (function() {
	undoDraw();
	})
	$('#rehacer').click (function() {
	redoDraw();
	})
	
	$(".fondo").click(function(){
		fondoColor();
		var direccion = $(this).attr('alt');
		direccion = eval(direccion);
		ponerFondo(direccion);
	})

	
    // Coloca una imagen encima
	function ponerImg(urlImg) {
	var img = new Image();
	img.src = urlImg;
		img.onload = function(){
		context = canvas.getContext('2d');
		context.drawImage(img,0,0,canvasWidth,canvasHeight);
		img_update();
		}
	}


	// Herramienta Rectangulo.
	tools.rect = function () {
    var tool = this;
    this.started = false;

		this.mousedown = function (ev) {
		context.fillStyle = rellenoAlfa;
		context.strokeStyle = fileteCol;
		context.lineWidth = fileteAnc;
		context.lineCap = fin;
		tool.started = true;
		tool.x0 = Math.round(ev._x/grid)*grid;
		tool.y0 = Math.round(ev._y/grid)*grid;
		};

		this.mousemove = function (ev) {
			if (!tool.started) {
			return;
			}

		var x = Math.min((Math.round(ev._x/grid)*grid),  tool.x0),
		y = Math.min((Math.round(ev._y/grid)*grid),  tool.y0),
		w = Math.abs((Math.round(ev._x/grid)*grid) - tool.x0),
		h = Math.abs((Math.round(ev._y/grid)*grid) - tool.y0);

		context.clearRect(0, 0, canvas.width, canvas.height);

			if (!w || !h) {
			return;
			}
		context.fillRect(x, y, w, h);
		context.strokeRect(x, y, w, h);
		};

		this.mouseup = function (ev) {
			if (tool.started) {
				tool.mousemove(ev);
				tool.started = false;
				img_update();
			}
		};
  };
	
    // Cuentagotas
	tools.cuentagotas = function () {
    var tool = this;
		this.mousedown = function (ev) {
		  pixelColor = contexto.getImageData( ev._x,ev._y,1,1);
		  rellenoR = pixelColor.data[0];
		  rellenoG = pixelColor.data[1];
		  rellenoB = pixelColor.data[2];
		  alfaColor();
		  $('#paleta').css('backgroundColor', relleno);
		};

	};

// Punteado aleatorio.
	tools.punteado3 = function () {
    var tool = this;
    this.started = false;

		this.mousedown = function (ev) {
		  context.fillStyle = rellenoAlfa;
		  tool.started = true;
		};

		this.mousemove = function (ev) {
		  if (tool.started) {
		  context.beginPath();
		  context.arc( ev._x + Math.sin(Math.random()*Math.PI*2)*Math.random()*pincel, ev._y + Math.cos(Math.random()*Math.PI*2)*Math.random()*pincel, radioPuntos, 0, Math.PI*2, true);
		  context.closePath();
		  context.fill();
		  }
		};

		this.mouseup = function (ev) {
		  if (tool.started) {
			tool.mousemove(ev);
			tool.started = false;
			img_update();
		  }
		};

	};


	//Borrador. Si hubiera imagen de fondo habra que copiarla primero cada vez que se hace imgUpdate
	//o colocarla en otro canvas por debajo
	tools.borrador = function () {
    var tool = this;
    this.started = false;

	saveActions();

		this.mousedown = function (ev) {
		  context.lineWidth = 1;
		  pincel = fileteAnc*3;
		  context.strokeStyle = 'black';
		  contexto.fillStyle = colorFondo;
		  tool.started = true;
		};

		this.mousemove = function (ev) {
		  if (tool.started) {
		  context.clearRect(0, 0, canvas.width, canvas.height);
		  context.strokeRect( ev._x-pincel/2, ev._y-pincel/2, pincel, pincel);
		  // contexto.clearRect( ev._x-pincel/2, ev._y-pincel/2, pincel, pincel);//elimina fondo
		  contexto.fillRect( ev._x-pincel/2, ev._y-pincel/2, pincel, pincel);//pinta con color de fondo
		  }
		};

		this.mouseup = function (ev) {
		  if (tool.started) {
			tool.mousemove(ev);
			tool.started = false;
			context.clearRect(0, 0, canvas.width, canvas.height);
			saveActions();
		  }
		};

	};

    // The circle tool.
    tools.circle = function () {
    var tool = this;
    this.started = false;

		this.mousedown = function (ev) {
		context.fillStyle = rellenoAlfa;
		context.strokeStyle = fileteCol;
		context.lineWidth = fileteAnc*1.5;
		tool.started = true;
		tool.x0 = Math.round(ev._x/grid)*grid
		tool.y0 = Math.round(ev._y/grid)*grid
		};
		this.mousemove = function (ev) {
			if (!tool.started) {
			return;
			}
			dif_x = Math.round(ev._x/grid)*grid - tool.x0;
			dif_y = Math.round(ev._y/grid)*grid - tool.y0;
			radio = Math.sqrt(dif_y*dif_y+dif_x*dif_x);
			context.clearRect(0, 0, canvas.width, canvas.height);
			context.beginPath();
			context.arc( tool.x0, tool.y0, radio, 0, Math.PI*2, true);
			context.closePath();
			context.stroke();
			context.fill();
		}
		this.mouseup = function (ev) {
			if (tool.started) {
			tool.mousemove(ev);
			tool.started = false;
			img_update();
			}
		}
	}


	// The polgono tool.
	tools.poly = function () {
    var tool = this;
    this.started = false;
		this.mousedown = function (ev) {
		  context.lineWidth = fileteAnc;
		  context.strokeStyle = fileteCol;
		  contexto.lineWidth = fileteAnc;
		  contexto.strokeStyle = fileteCol;
		  contexto.fillStyle = rellenoAlfa;
		  context.lineJoin = 'round';
		  if (!tool.started){
		  tool.x0 = Math.round(ev._x/grid)*grid;
		  tool.y0 = Math.round(ev._y/grid)*grid;
		  tool.x1 = Math.round(ev._x/grid)*grid;//Guarda coordenadas del
		  tool.y1 = Math.round(ev._y/grid)*grid;//comienzo del poligono
		  context.beginPath();
		  contexto.beginPath();
		  context.moveTo(tool.x0, tool.y0);
		  contexto.moveTo(tool.x0, tool.y0);
		  tool.started = true;
		  saveActions();
		  }else if ((Math.abs(tool.x1-ev._x)<(grid/2))&&(Math.abs(tool.y1-ev._y)<(grid/2))){
				contexto.closePath();
				contexto.fill();
				contexto.stroke();
				tool.started = false;
				context.clearRect(0, 0, canvas.width, canvas.height);
				saveLocalStorage();
		  }else{
		  contexto.lineTo(Math.round(ev._x/grid)*grid,  Math.round(ev._y/grid)*grid);
		  contexto.stroke();
		  //contexto.fill();//Si el relleno es transparente se van superponiendo Usar relleno solido
		  tool.x0 = ev._x;
		  tool.y0 = ev._y;
		  }

		};
		this.mousemove = function (ev){
		  if (!tool.started) {
			return;
		  }
		  context.clearRect(0, 0, canvas.width, canvas.height);
		  context.beginPath();
		  context.moveTo(Math.round(tool.x0/grid)*grid, Math.round(tool.y0/grid)*grid);
		  context.lineTo(Math.round(ev._x/grid)*grid,  Math.round(ev._y/grid)*grid);
		  context.stroke();
		};

		this.dblclick = function (ev) {
		  if (tool.started) {
			contexto.closePath();
			contexto.fill();
			contexto.stroke();
			tool.started = false;
			saveLocalStorage();
			}
		};
	};

		// The lnea tool. Dibuja lineas rectas siguiendo una cuadrcula de grid px
		tools.linea= function () {
		var tool = this;
		this.started = false;

			this.mousedown = function (ev) {
			  context.lineWidth = fileteAnc;
			  context.strokeStyle = fileteCol;
			  context.lineCap = fin;
			  if (!tool.started){
			  tool.x0 = ev._x;
			  tool.y0 = ev._y;
			  context.beginPath();
			  context.moveTo(Math.round(tool.x0/grid)*grid, Math.round(tool.y0/grid)*grid);
			  tool.started = true;
			  }else{
			  tool.mousemove(ev);
			  img_update();
			  tool.started = false;
			  }
			};

			this.mousemove = function (ev) {
			  if (!tool.started) {
				return;
			  }
			  context.clearRect(0, 0, canvas.width, canvas.height);
			  context.beginPath();
			  context.moveTo(Math.round(tool.x0/grid)*grid, Math.round(tool.y0/grid)*grid);
			  context.lineTo(Math.round(ev._x/grid)*grid,  Math.round(ev._y/grid)*grid);
			  context.stroke();
			  context.closePath();
			};
		};



		// Lnea H y V. Dibuja polilineas rectas consecutivas horizontales o verticales
		tools.linea_4 = function () {
		var tool = this;
		this.started = false;

			this.mousedown = function (ev) {
			  context.lineWidth = fileteAnc;
			  context.strokeStyle = fileteCol;
			  context.lineJoin = 'round';
			  context.lineCap = fin;
			  if (!tool.started){
			  tool.x0 = ev._x;
			  tool.y0 = ev._y;
			  context.beginPath();
			  context.moveTo(tool.x0, tool.y0);
			  tool.started = true;
			  }else{
			  tool.mousemove(ev);
			  img_update();
			  if(control == 1){
			  tool.x0 = ev._x;
			  }else{
			  tool.y0 = ev._y;
			  }
			  context.beginPath();
			  context.moveTo(tool.x0, tool.y0);
			  }
			};

			this.mousemove = function (ev) {
			  if (!tool.started) {
				return;
			  }
			  context.clearRect(0, 0, canvas.width, canvas.height);
			  context.beginPath();
			  context.moveTo(tool.x0, tool.y0);
			  if (Math.atan(Math.abs(ev._y - tool.y0)/Math.abs(ev._x - tool.x0)) <= Math.PI/4){
			  context.lineTo(ev._x, tool.y0);
			  control = 1;
			  }else{
			  context.lineTo(tool.x0, ev._y);
			  control = 0;
			  }
			  context.closePath();
			  context.stroke();
			};

			this.dblclick = function (ev) {
			  if (tool.started) {
			  img_update();
			  tool.started = false;
			  }
			};
		};

	   // The lnea3 tool. Dibuja lneas horizontales separadas 10 px.
		tools.linea_3 = function () {
		var tool = this;
		this.started = false;

			this.mousedown = function (ev) {
			  context.lineWidth = fileteAnc;
			  context.strokeStyle = fileteCol;
			  context.lineCap = fin;
			  if (!tool.started){
			  tool.x0 = ev._x;
			  tool.y0 = ev._y;
			  context.beginPath();
			  context.moveTo(tool.x0, Math.round(tool.y0/10)*10);//10 es la separacin entre lineas paralelas
			  tool.started = true;
			  }else{
			  tool.mousemove(ev);
			  img_update();
			  tool.started = false;
			  }
			};

			this.mousemove = function (ev) {
			  if (!tool.started) {
				return;
			  }
			  context.clearRect(0, 0, canvas.width, canvas.height);
			  context.beginPath();
			  context.moveTo(tool.x0, Math.round(tool.y0/10)*10);
			  context.lineTo(ev._x,  Math.round(tool.y0/10)*10);
			  context.stroke();
			  context.closePath();
			};
		};


		//lnea puntos
		tools.lineapuntos = function () {
		var tool = this;
		this.started = false;

			this.mousedown = function (ev) {
			  context.lineWidth = fileteAnc;
			  context.strokeStyle = fileteCol;
			  context.lineCap = fin;
			  if (!tool.started){
			  tool.x0 = ev._x;
			  tool.y0 = ev._y;
			  tool.started = true;
			  }else{
			  tool.mousemove(ev);
			  img_update();
			  tool.started = false;
			  }

			};

			this.mousemove = function (ev) {
			  if (!tool.started) {
				return;
			  }
			  context.clearRect(0, 0, canvas.width, canvas.height);
			  context.beginPath();
			  context.dashedLineTo(Math.round(tool.x0/grid)*grid , Math.round(tool.y0/grid)*grid , Math.round(ev._x/grid)*grid,  Math.round(ev._y/grid)*grid , [5,10]);
			  context.closePath();
			  context.stroke();
			};
		};


		//Cubo Pintura
		tools.cubo_pintura = function () {
		var tool = this;
		this.started = false;

			this.mousedown = function (ev) {
			curColor = { r:rellenoR, g:rellenoG, b:rellenoB};//toma color seleccionado en rgb
			saveActions();
			colorLayerData = contexto.getImageData(0, 0, canvasWidth, canvasHeight);//copia canvas a colorLayerData
			paintAt(ev._x, ev._y);
			saveLocalStorage();
			};
			floodFill = function (startX, startY, startR, startG, startB) {


					var newPos,
						x,
						y,
						pixelPos,
						reachLeft,
						reachRight,
						drawingBoundLeft = 0,
						drawingBoundTop = 0,
						drawingBoundRight = canvasWidth,
						drawingBoundBottom = canvasHeight-22;
						pixelStack = [[startX, startY]];

					while (pixelStack.length) {

						newPos = pixelStack.pop();
						x = newPos[0];
						y = newPos[1];

						// Get current pixel position
						pixelPos = (y * canvasWidth + x) * 4;

						// Go up as long as the color matches and are inside the canvas
						while (y >= drawingBoundTop && matchStartColor(pixelPos, startR, startG, startB)) {
							y -= 1;
							pixelPos -= canvasWidth * 4;
						}

						pixelPos += canvasWidth * 4;
						y += 1;
						reachLeft = false;
						reachRight = false;

						// Go down as long as the color matches and in inside the canvas
						while (y <= drawingBoundBottom && matchStartColor(pixelPos, startR, startG, startB)) {
							y += 1;

							colorPixel(pixelPos, curColor.r, curColor.g, curColor.b);

							if (x > drawingBoundLeft) {
								if (matchStartColor(pixelPos - 4, startR, startG, startB)) {
									if (!reachLeft) {
										// Add pixel to stack
										pixelStack.push([x - 1, y]);
										reachLeft = true;
									}
								} else if (reachLeft) {
									reachLeft = false;
								}
							}

							if (x < drawingBoundRight) {
								if (matchStartColor(pixelPos + 4, startR, startG, startB)) {
									if (!reachRight) {
										// Add pixel to stack
										pixelStack.push([x + 1, y]);
										reachRight = true;
									}
								} else if (reachRight) {
									reachRight = false;
								}
							}

							pixelPos += canvasWidth * 4;
						}
					}

				},


			clearCanvas = function () {
			contexto.clearRect(0, 0,canvasWidth, canvasHeight);
			}

			matchStartColor = function (pixelPos, startR, startG, startB) {

				r = colorLayerData.data[pixelPos];
				g = colorLayerData.data[pixelPos + 1];
				b = colorLayerData.data[pixelPos + 2];

				// If the current pixel matches the clicked color
				if (r === startR && g === startG && b === startB) {
					return true;
				}

				// If current pixel matches the new color
				if (r === curColor.r && g === curColor.g && b === curColor.b) {
					return false;
				}
				// If current pixel has different colour
				return false;
			}

			colorPixel = function (pixelPos, r, g, b, a) {

				colorLayerData.data[pixelPos] = r;
				colorLayerData.data[pixelPos + 1] = g;
				colorLayerData.data[pixelPos + 2] = b;
				colorLayerData.data[pixelPos + 3] = a !== undefined ? a : 255;
			};
			paintAt = function (startX, startY) {

				var pixelPos = (startY * canvasWidth + startX) * 4,
					r = colorLayerData.data[pixelPos],
					g = colorLayerData.data[pixelPos + 1],
					b = colorLayerData.data[pixelPos + 2],
					a = colorLayerData.data[pixelPos + 3];

				if (r === curColor.r && g === curColor.g && b === curColor.b) {
					// Return because trying to fill with the same color
					return;
				};

				floodFill(startX, startY, r, g, b);
				contexto.putImageData(colorLayerData, 0, 0);
			}
		}; //fin cubo pintura
	
		//Aumenta de tamao el escritorio
		document.getElementById('zoom_in').onclick = function() {
			if (canvasScale > 2) {
				return;	
			}
			canvasScale = canvasScale * scaleFactor;
			altoNuevo = Math.round(altoNuevo* scaleFactor);
			anchoNuevo = Math.round( anchoNuevo* scaleFactor);
			$('#imageView').css('height',altoNuevo);
			$('#imageView').css('width',anchoNuevo);
			$('.lienzo').css('height',altoNuevo);
			$('.lienzo').css('width',anchoNuevo);
			$('#imageTemp').css('height',altoNuevo-(22*canvasScale));
			$('#imageTemp').css('width',anchoNuevo);
			$('#imageTop').css('height',altoNuevo);
			$('#imageTop').css('width',anchoNuevo);
			objeto = document.getElementById('herram');
			objeto.style.height = altoNuevo +'px';
		}
	
		//Disminuye de tamao el escritorio
		document.getElementById('zoom_out').onclick = function() {
			if (canvasScale < 0.9) {
				return;	
			}
			canvasScale = canvasScale / scaleFactor;
			altoNuevo = Math.round(altoNuevo * (1 / scaleFactor));
			anchoNuevo = Math.round(anchoNuevo * (1 / scaleFactor));
			$('#imageView').css('height',altoNuevo);
			$('#imageView').css('width',anchoNuevo);
			$('.lienzo').css('height',altoNuevo);
			$('.lienzo').css('width',anchoNuevo);
			$('#imageTemp').css('height',altoNuevo-(22 * canvasScale));
			$('#imageTemp').css('width',anchoNuevo);
			$('#imageTop').css('height',altoNuevo);
			$('#imageTop').css('width',anchoNuevo);
			objeto = document.getElementById('herram');
			objeto.style.height = altoNuevo +'px';
		}
	
	
		//Importa imagen desde archivo y la coloca como fondo del canvas fabric
		formEl = document.forms[0],
		fileEl = formEl.elements[0],

		formEl.onsubmit = fileEl.onchange = uploadHandler;
//
		function uploadHandler() {
		uploadFile(fileEl.files && fileEl.files[0]);
		return false;
		}		
		$('#subirArc').click(function(){fileEl.click()});
		
		//Sube archivo de imagen desde el ordenador
		function uploadFile(file) {
			if (file && file.type && file.type.match(/^image\/.*/)) {
				var fileReader = new FileReader();
				fileReader.onload = function(e) {
					var dataURL = e.target.result;
					var newImg = new Image();
					newImg.onload = ajustar;
					newImg.src = dataURL;
					
					function ajustar(){
						fondoColor();
						alto = newImg.height;
						ancho = newImg.width;
						altoCanvas =canvaso.height-22;
						if(ancho/alto >= canvaso.width/altoCanvas){
							yCoor = Math.floor((altoCanvas-canvaso.width*alto/ancho)/2);
							altoPNG = Math.floor(canvaso.width*alto/ancho);
							contexto.drawImage(newImg,0,yCoor,canvaso.width,altoPNG);
							return
						}else{
							xCoor = Math.floor((canvaso.width-altoCanvas*ancho/alto)/2);
							anchoPNG = Math.floor(altoCanvas*ancho/alto);
							contexto.drawImage(newImg,xCoor,0,anchoPNG,altoCanvas);
						}
					}
				}
			fileReader.readAsDataURL(file);
			}return
		}

	init();

}, false); }
