// Keep everything in anonymous function, called on window load.
if(window.addEventListener) {
window.addEventListener('load', function () {
  var canvas, context, canvaso, contexto;

  // Variables de herramientas.
  var tool;
  var flagRejilla = true;
  var undoHistory = new Array();//Matriz que guarda imagenes para el deshacer
  var redoHistory = new Array();//Matriz que guarda imagenes para el rehacer
  var tool_default = 'cubo_pintura';
  var imagenFondo = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAu4AAAILCAIAAAA49o6sAAAAA3NCSVQICAjb4U/gAAAgAElEQVR4 nOx9V3Bb6Xn2OQe9FwIgAYJoBAGwkxIpSiuJoiSqUtqV1vbuemN7nIxjTybFk8k48SSTOJPxRS6S mZSLzKQ4WduJ1/ZmvV6rrkRRhRJJSewNBDsIEmABiN6B81+84fkxbAJJAIQoPBcaETg45Tvf935v fV4UySGHHNaAoiiO4yKRqKqqSigURiIRFEX3ftp4PM5gMF68eDE1NYVhWDwe3/s5sx90Oj0YDH78 8ccIgnzwwQfw537fVA45ZAswDCsuLi4rK8MwDMfxlJwTRdFYLHb79m2QXak6bfYD2+8byCGHbAGs /Pz8/EOHDqVQj0EQBMOwYDB46NCh06dPC4VCuFZKzpxDDjm8jiCRSDqdrqKiIrUKB47jGIZduXKl traWQqEgb4yoIe/3DeSQQ3bBYDDw+fxQKJRaEYCiaDQa5XK5jY2Nbrd7eHjYarW+UWZTDjnkgKyZ THQ6vaKiIhqNpuMSOI4rFAqVSjU3NzcyMuL3+w+8qMl5ZXLI4f+A47hMJmMymbFYLE2XAPevUCjU 6XRpukQOOeSQtQCVgkKhqNXqtAaaQdSUlJTk5eUhb4BvJqfK5JDD/4dGo2EwGLFYLH0rH0XRUCiU l5fX0tKiVCrTdJUccsgha8FgMNRqdfpMJgCGYX6/v6Gh4eTJkxwOBznQCk1Olckhh/8PBoNBIpHS 7YlFUTQej9Pp9JKSkrReKIcccshCkEgkJpOZgQuhKBoOh6VSqVQqRXKqTA45vAlQKBRUKjXdphIB HMcZDEZxcfEBli855JADAYgu0Wg0pVKZpiyZTS8aj8cLCgqEQmE8Hj+o0ianyuSQw/9Bo9HQaLSM rfZ4PA5VDAdVuOSQQw6JgJXO4XBAlcnMwkdRNBKJSCSSoqIi5OA6Zg54BRNowQKBQKlUoihaVFSE YRiCIBiG3bx5E6pUDnZedw7Jg8lkwnzI2GpHURQKJnN43QEzR6vVMhgMgUCQl5cXi8UYDIbFYnn6 9OmbQyaUwytBIpEYDAZUFWXmijiOk0gkMvkgb/cH89lArIjF4tLSUqDxyCGHbYBh2JkzZ2g0WjoS fiFcrVarCwsLZ2ZmLBYLlUrNKdAHBiiKarVarVZLp9OJ15p7vzmsA6izUqn06NGjgUAAjOrUAkhl ysvLyWTyyMhIIBAgk8lvyFQ8aKoMKDGFhYV6vZ7L5b4hbzGHvSNN3hEoIjh79qxMJiORSB6PZ2Zm hkajwczEcTwSiaTjujlkAGQy2WAwqFQqsHdz0iaHVwK8I+mgrYpEIiwWq6WlJR6Pk8nk8fFxn89H fBuLxTKWnbMvOGiqDPh4DQYD5G9unC6g64yMjMAWkpM+OWAYptfrqVRq5q8biUSGh4dzoYfXCwTF WVVVVWFh4aYyBMdxKpVqt9vHx8eRnJx54wG5t1wuV6lUZjj3FqaizWabmZlBDu5UPDiqDIqi5eXl xcXF0M9iq+kCU2pmZia3f+QAexKZTNZqtWnKmgI5YjKZqFSqXC5PDECAqWQ2m1N+0RzSBJgkHA6n urpaLBbHYrGt5gzMK7fbvbS0lEuUyYFo7lZYWBgMBlMeXYJsmEgkMjg4WFZWlijNYCo6HA6Xy0Ui kTJWoZlhHARVhkwml5SUqNVqMKwPqtaZQ2oBq53JZJ4+fZpEIqXpKiBioEfB0tLS4uIihUIhMotz 0aXXBTBbeDxeaWmpRCIBi+igFoPkkFqALqvT6SorK0OhUDqyZJC1KNLExEQsFiOTyeFwmKDIIqJL B3hzfI1VGRAufD7/9OnTyYsVOPLy5cu5CqY3GQR9uFarhQLsTQ+Djtbz8/Pt7e0IgmAYplaroZuS Tqdjs9nJWNtgFS0tLS0tLSEIQiaT4/E4lUpdXV29f/9+bgZmP2Arqq6u1ul04XA4GVEDOVJqtZpC oeQqmN5kgNYrFAplMtk2MycejzOZzPb2dovFgiAIj8eTSqWBQIDNZidPpAnCZGpqCv7EMCwWi7HZ 7BcvXkxMTBzsSfhaqjKEPW0wGGQyWSarZ3M4ACCIqsrLy9Vq9TYED9DRWiKRXLlyZWxsbHx8fHJy Er6amZkhnMZsNlssFqtUqiT3OQRBcBw/2Fl4BwPwigsKCvR6PY/HS2Gz9BzeBBC1tNXV1Xw+f5v5 g2FYIBBoaGjQarUDAwMOh8PtdoORMzw8DMcolUpI7GOxWEnS0oCr5gBrMAReP1UGVEuYHFwu96BG /nJIE0C4sNnsyspKmUz2SokARhWJRKqqqtLpdLdv3ybkAgialZUVu90+MzPT399vMBh0Ot32Gx5k zywsLDx9+jTnksly4DheVlZWXFxMoVDehP0ghxQCVrdcLq+oqGCxWK/Ug0Ht4HK5Fy5cGBkZ6e/v X+dHmZ2dRVF0enpaIBDU1tbm5eVtbztBd5Rnz55ZLJaD7ZJBXi9VhtBwDQaDQCBA1qJFuzsbpEfk NpI3CkTGQ2VlZX5+fvKEmyBlqFTq22+/bbFYUBQdHBwMBoNwQphF4XB4YGBgdHRUKpViGFZTU7ON ppKbeFkOFEX1er1KpaLT6QiC7HobyHlx3ljgOK5SqcrKyhgMRvKiBkKTWq1WIpE4HI5AIDAyMkJI EvjX6XQ+ePAgLy+PwWCIxeKSkpKtUokJ6XTg8dqoMmq1msfjgTM/JSdMU+5VDtkMIiQklUp3kX8H QgEKkeRyucPh6Onp8Xg8iSpLJBKBoqSZmZmWlhY6nZ4oxSAiPjMz09nZeeDtpNcLRIm1Wq1msVj5 +fkppBp6Q7aTHNZBpVIxGIydEm+C4cRisVgsFhAwzszMDAwMEAfAdLLb7RiGWSwWm83W1NTk8/kS BRqImra2tsXFxTdB1GS7xQDWrVgsZjAYKTwtOPnv3Lmzbh/aeOkkQwCxWGxoaCgX7cpmwKsUCoVV VVUikWjveQ9QneR2u/v7+5eXlzeVF/n5+bW1tURsGybe9PT0y5cvD7x8odPpwWDw448/RhDkgw8+ gD/3+6Y2AbyXvLy88vJyDoeTWg2GRqMtLy+3tbVtKkkI3Vqr1b6yRhfyx5eXl4k8rVTdZw7pgFar LS0tTWFocn5+vre3d12OHcEoUVJSUlZWRuxBUNbw6NGjrUTTAUMWqTLwSiQSiVKpJJFIhYWFaW24 Ba9/bm6Ow+Hw+fyNWghkE1dXV6+bi1DAwmazZTKZ1+u1Wq3rdGEajTY1NTU0NOT3++l0ut1un5iY yImefQes5+Li4srKylSdE2aR3W73er0Oh2NqamrdiybyRlEULSkpIZFIz58/9/l8b8J8yFpVBga/ vLycRqOJRCIOh5NWUYNhWCgUslqtcrl8o7ICfS3EYrFer1+X+gCipqCggMvlLi4uulyuRB56yOLq 7e2dm5uLxWJ0On10dNTlcr0JU+u1wIkTJ8RicQrfBYqiUN9kNBo3NcJh38Rx/NChQyaTyWQygUPo TZgP+6/KEBqMXq8XCoX7GFqGHPLCwsLm5ma/35+qCFQwGJyamurv77darYlOwhwyDFBlSktLKyoq ki81ShKJZdtvgg2UDLJQlcEwTKvVqtXq1Hp5d3EbPp/v1KlTGo0mVaImHo+7XK7+/v7p6emJiYn5 +fncPNxfnDt3jsPhpPwVxONxFov1+PHj3CtOxD6rMqDH1NfXKxSKrIrOQF+uoqKieDxeVVW1o7yt TQG218TExJ07dwYHB3PzL/OAZV9VVVVeXr4urpzCS0QikampKaJ+8k1G9qgyRB7MmTNnMt+hYhuA 34XP5/P5fDabvXclG3zJHo/n+fPn9+7ds9lsb4hRnoXYmCqXKkBo2+Px9Pf35+ikAfuc9iuXy7Va LY/Hyyo9BlmTfZC/OTc3JxaLa2tr90IsAVFzg8EwPj4+MjICtVc5EXPAAI3ctFotmUzu7+/f79vJ ASHyk0pKSoqKirJKj0ES9iSPxxOPx8fGxoqLiysqKnYtGSDqJBKJKisrBwYGcqrMgQTkBXM4nNra 2qGhoZx7BkGQ/aziKS4urqmpgbLqrAVMmvz8fDqdvkd9CwwmqVSaPpr8HPYd8JY1Gs21a9cggTRX jrtfgF2cwWBUVVXtS8fQ5EGoXAUFBXvXPKD+RSwWp+TecshCgM5Ko9FOnjzZ0NAQj8ff8JrcfXt4 DMPKy8tfC+KpeDwukUgYDMbeu64Eg8GlpaXsf+Qc9gjYjVpaWhobG4GYJKfQZB4w5lAflP1EvfF4 nEKh7F2VAa3I5XKtrq6m6t5yyE4AHblMJnv77bfLysqQN1jOZDrARPS+aW5ufi18YhBiv3379tmz Z+VyeSAQ2AUZCZlM9vv9nZ2dq6ur+575mEMmIRAILl686PF4uru7V1dXc97+jAHEi1KprKurS2EW f5oALpnV1dXf/OY3LS0tu3MAA7vr5OTkwMBAtoXsc0gfILOzpKSkuLh4fn6+u7v7DRQymVNlCGdv fX19lgeVUggURe12+8DAgNPpBGG6vLwMCtwbONveQMC0Z7FYp06d8vl8g4ODNpvttVDiX1/A8BYV FUG5dVoLrbMEIEwmJibGx8dDoRCFQgkEAna7HcnJmTcGENqWy+UymWxxcbG3txdSyN+QCZB2VYbo X61QKAQCQV5e3sE2F4i2FxMTE0wmk9ixUBSF6GZfX9/BHoHsBFGJrdFoduFa2yNgFXC53PLycqVS maMaSh+USqVIJCKS2w5wr1kURUOh0J07d6LR6Lr5TKFQVlZWZmZmckrzvgDDsMbGRgqFslOe31Rd XSaTYRiG4/jIyIjb7X4TRE0aVRkYPoFAoNPpJBIJLLa9p5tkJ2KxWG9vbyQScTgcwIhPp9MzJkTq 6upQFK2oqBCJRCwWC0rHgWa0s7OTCGlhGNbd3f1GqerrwGaz6XT6voQbiKIDDocjk8n0ev3U1NTo 6GiGb+OgAkVRlUpVXFxMNDY5eKIGQtVLS0tGoxFBkKWlJXjADExmwiItLS0lk8l1dXVkMlkgEIB5 RqfT+/v7TSYTdPyhUql2u310dPSNlTMoivJ4vH3UI3Ecz8/PB3JOqNleWVk52HptulQZmMQlJSV6 vX5Hub2Qx1RQUNDU1BSNRonI335JJRRFg8HgpUuXxGIxMIvDWl1aWhoZGcEwbB3bL7K1ZIGnqKmp 6e/vX0c+vaP7gfSdEydO1NXV8Xg8KpUqFArhxtYdLBKJSktLiT+tVuv169f7+vpWVlYCgYDT6TSb zTl60MwDppBOp6PT6b29vft9O689yGRyfX19fn7+jmYy9O07evSoTqfzeDxDQ0OTk5OZtEASAbxT QqHw4sWLBLUMMDj09/c7nU6fz7eR7XebU4lEIpVKtZcWB7DzyeXypqYmnU5HpVKZTCafz990fM6c OXPmzBlQtrxer8vl8vv93d3dkUjE5XLZ7fbp6emcNzrDIJzB9fX1AwMDB7tmO136gUwmq66uZjKZ GwPV8XicSqXW1dVBj2Imk4kgCIZhbrc7GAyurKwMDw8XFBScPXuWsJ7BEHE4HBnTaeAmDx8+/PLl S4FAQKPRYrEYmUxeXV11u92JAmWnCIVCra2tu3CNwPF1dXXXr19ns9l8Pn8X9wA8FisrK3a7fXZ2 1uPxhEIh2xoOqk5DkOMVFxdn1QNiGBYOh2/dunUg5UtaKfKIAgK9Xq/T6TYOIBhFSqWyuLg4FosJ hUKiuZLdbo/FYpOTk7Ozs42NjRqNxufzUSiUUCg0MzMzOTmZsdx8YBgvLi7mcrlDQ0NKpZKotFpc XNxLeIJEIs3MzHR3d+9i90JRlEQiffjhh1VVVVwul0aj7cLFBW5Im822srIyPT2N47jdbl9ZWZmd nfX7/QdS1BAV9Y2Njalqe5wSABe5yWTq7e09qNpMWtQChUJRVVVFpVLXLUUURSORCJvNvnTpUnl5 +cjIyI7WKmzDLpfL6/WCFFtdXR0bGwNlHxZGQ0PD2NjY6urqK52u0Wi0vr5+fHxcIpHI5XKfz8fl cvl8PoZhHo+nt7eXQqHgOG6z2VLrqd6dKkMikQwGw8mTJy9duiSRSAYGBuh0+l5kAQzg4uLiwMCA w+GgUqnhcNhqtdpsNmjzcWAA46xSqcrKyvbO2pwOxGKxu3fvHrzAX/pUGRgoGo1WWlpaXFy88Z2C iqDX669cuUImk8fGxna0XiBusrKyEo1GYaVMTEyArk+UvyoUClAUtjktSDyBQKDRaIaGhiAQHIvF xGIxhUKh0Wgmk8lsNrNYLK/Xu7KyshcbaR12rcqw2exjx44dP368paUFBAKNRtt7ffjY2JjJZAqF QlQq1eVyWa3W+fl5p9N5YOY8oVtXVlYqlcpseyjQsWZmZl68eHEgtZm0yPRNCZthVYOzK9sqmEBp nZ6eHhsbwzAMmqen6Vo7UmVgztXW1l64cOH06dOVlZVkMhnstvn5+YGBgb2w7YFqGAgEVlZW5ufn 5+bmQJIGAoGpqampqamD4RCuqKhQKBTZTI8G8Pl8T58+LSkpcTgcc3NzB0DcpE+VgcGBMPTGzCfQ NkpKSqCCKauSZmC3e/78udfr9fl86ctA35EqQ2zDly9fbmpqampqKioqikaj8Xg8EokMDw9bLJY9 ht5QFHU6nXa7fXJy0uVygaFot9vHxsYg6Sfb9v7kATfP4XCqq6sh1r/fd7QlQEc3m81jY2OHDh3q 6Og4GEIeyVgxNrQa4XA45eXlYrE4FAoZjUaz2RwKhZA1VySbzcYwTKPRlJaWprvGBNbty5cvPR6P 1+tdd7ksmYtgAn7ta1/7sz/7M+jeTiKRLBbLixcvQC7skTWY4IssLCwsLCwsLS01Go0Wi4XBYJSX l5eUlMzOzo6Pj7++3gIMw6qqqpRK5StN53g83tPTY7FYIOgJbZOLioogOyozd8tisc6fP48giFqt Pnz4cCAQMBqNs7OzB0CnySTAZFIqlSUlJRwOx2azjY6OrqysJI4hj8dDUfTIkSNcLjet1HkgZ1wu V09PD4qiKysr6w7IBlEDq1sqlX7ve9/77d/+bZj/GIZ1dHQsLi4Gg8FAIEClUvc4CWFl8Xg8lUpl tVqNRqPT6RSJRHl5eW6322QyvabOYCIhuqamRigUbqMZEEmWPT09Ho+HRCJxuVwymXzs2DEymZyZ NQ4ZGkqlUqlUIghy9erVeDzucDh6enpe96hfhrwykGGnUCjOnz8PZTWQbWoymYD9FtwDBoNBLpcL hUJ4u+m4N8Dq6uqzZ8+CwWAKPbpJInmvDIVC+cEPfvDd736XzWYHg8GhoSGj0ZjWpu3QiK61tZUw ZGOx2Pz8/NjYmM/ne10mOhGxPnbs2I78f263++XLl0TtIpPJJJPJhYWFVVVVGa7fjsfjTCZzYmLi 5cuXr68qsy9eGRA1p06d0uv1AwMDg4ODCIJ4PB6j0ej3++GYeDz+1ltvoSh66NAhjUaTvtUUj8cn Jib6+vqoVGqG106SXhn4Vq/X/+M//uOFCxfi8bjT6ezq6lpaWkpfYiJkB4+Ojvb09BCMFX6/f2Ji YmZm5jWa7URmdHV1NfiZXjlihF+kv78fCr4QBBEIBPF4vK6uTigU7rGf6E4BEYn79+/b7fbXRcJv irQ0A+LxeOBigT+JgHFlZWUsFuvs7HS73QiCGI1G2CMDgYDP54tEIvPz8xMTE263m0qlisXi9Gkz LBZrYmIiHA5nvh1SLBaDZP7t5yuTyfzbv/3b7373u2Qyub29/dmzZ4uLixmYZzQaTa/X4zi+uroK fiAul6vT6aLRKMTdsn+uw8BSqdTq6uod3S2NRlOr1SqVym63B4PBaDQaCoUgD91kMnm9XqlUmhkp A0tGLBZzOBwINmX/sG8EmUyORqNf/vKXEQT55JNP4M/Unp/P59NoNOIT8O+qVCqtVjs9PT0wMIDj uMfjGRgYWFhYCAQCfr/f7/cHAgGTyWS1Wv1+v0Ag4PP56XitsEmEw+HJycnMqzIYhjmdTqvVus3+ RMSv/+Vf/uXMmTPz8/NtbW0DAwM+nw9JJwU+bOcFBQUKhcLtdnu9XgzDKBRKfn5+cXHx3NxcFia0 bQoYW5lMplKpwuFwktYOiqICgUCv1/P5fPBFBYNBSDkfHh6enp6m0+lAwJaBQQBRo9Pp7HY7vIjX UdQgaVJlHA5HUVERUFQBNVw0GhWJREKhcGxszGazkcnkWCzW0dGxqQIO8VQejwfJcam6KzAFwuHw 7du3bTYbLNfMY3tVBj6kUCj//M///J3vfAfDsBs3bkAWy6Znczqd3d3ds7Ozc3NzZrPZYrGYTCZQ BPfiOReJRDqdzmq1+nw+eFkymSw/P9/lcgUCgWyWMoRD5dixY7vLjyGRSBqNBsQTgiBA04zjuNvt HhsbW15elkqlaXUZEsAwzOFwLCwsvKbWUrpVmWAwGIlEVCoVsfOBqFGr1cFg0Gg0ut1uFotlsVjG x8c3yuhoNDo7O+t0OiUSSWq1GXCqmUymR48eeb1eCKNnGK9UZWBd19XV/du//VtDQ8Ps7Ozdu3c3 fUGgeczMzPT19S0sLJjXMDMzI5PJIPa0i/omqBJVq9UikWhqagqsShRFgb8DTKlsFjWgCKrV6tLS UtjIdnq3bDbbYDBIJBKVSrW0tAQSOx6PLywsAHVQfn5+xjK9ZmdnXyPX+0akRZUBGZGfn89kMhkM xsuXL+fn5w8dOkSlUm02G+QfxONxoFRa91v4JBgMWq1WGo2m1WpTNbIEnZRQKBwfH99IkZkZbKPK wDTCMOy999774Q9/+OTJkydPnkAUDEEQyGux2WyPHz8eGhoymUwej6e4uNjtdqvVao/HA2YBiURy Op3T09MWi2Vqamp1dVWhUOxUKMDBGo3G4XA4nU4oRqPT6RqNhsPhzM/PZ62IgRuDZsi7s+2I6hga jQYKTWFhoUAggAIWv98/Pj5uNBrn5uYkEgmbzU6TwIUYmd/vn5ube03lS7pVGQRB3G73ysqKWq2G zsB37twBLdzn80H9EY1Gs9vtm+7o8KfD4bDb7VKpVCqVptC3H4vFeDxeLBabmprKvEsGeZUqg2FY LBYTCAR/8zd/09zc/PHHHxPKBLKW4tPX19fV1TUyMjI+Ps7j8YBRprCwcGlpiVA75ufnZ2dn5+fn TSYTk8nMy8vbqQWF4zibzZZKpVNTU2D3QuqJXq93uVwejydr/QRwq0qlsrCwEGhRd3ceBoPBYDB0 Ol1+fj5wkXu9XhRFl5eXR0dHx8bGvF6vXC5P3yDgOM5gMMxmM1w3O0f7lUiLcQk+K6vVyuVy5+fn FxcXoSxIIpEkM0wwmqurqysrK2BXperGQFHIy8ujUqkpl6qpgkql+td//Vev17uwsAAhHgRBotHo 2NgYVBURC95ut7e2tt69ezcWizmdzq0yzuCRwSl1/vx5MplcXV0tEom2F9xgH5w/f769vX18fBxC 2uCeOX369NjY2MLCQrqGIGsA6iONRuPz+SqVKh6P2+12EPTd3d2tra0IgnC5XAzD5HJ5eXl5BlJq jhw5smlJudVqnZycfH0l0S4AD+t0OpeXl/l8vslkCgaDNpsN9pVkxgHDsEgkAjRLKXQ3QpyLyWQC H25KzplagH/6d3/3d3/rt35rYGAAxCy4Ftxud39/P8xzEDWxWGx8fNxsNnd1dVEoFIfDsfGEhDeU w+EEg0GVSnXs2DEURY8dO/bK3Jd4PC4UCq9du3bjxg2wMOFs9fX1kKj3Wm+xSSIej/P5fARBGhoa SCSSz+dzu910Oh1yxiEOJRKJgEOEx+OlL10dhprH4x0+fDgUCq27SjQaHR0dzUJi1bSoMrAGRkZG UBSl0WiRSIROp+/056FQ6OnTp5cuXUrhjYHk6urqCgaD2SZiYGaAtsFms2/evAmTlUKh9Pf3T0xM xGKxxG0SKGGSCZPF4/Hl5WX4/49//GMEQTgcjlQqLSkpOXHihFKp3KpOh6BDLSoqAnlHIpFwHBcI BIcPHyaRSHNzcyl6+tQAXWO3bGhoSN7CjsfjZDL56tWrLpcLQZDu7m4g2tloxKMoKhKJ4M+zZ8+C ZhwOhwcGBoaGhoaGhqhUKofDodFoR48eTXn2Ip1OP3fu3Fbc2cDsvLi4+OLFi9ReN2sBLygUCnV0 dNTV1QHd1I7WNbx68OcfO3aMKKjc440Bl//s7OzAwEDmCwteCZi0EomksbHR5/P19PQwGAywPzs6 OghNBcYhGo2aTKbJycntq3bhGSEVCUGQ/v7+/v5+FEU/+eSToqKiysrKEydObGToIABOtXfeeWd4 eHhycjISiYBCo9FomExmX1+fx+PJqr0TAgs6nQ7kZzJzBsMwn89XWlp6+PDhpaWlQCDQ1dW1MVkT bEhw1SAIwuPxFAoFfLW6uvr8+fN79+7B5wiCaDQanU6XQgsKrq5SqY4ePer3+7lc7sZjxGJxNBod Hh42m83ZU5RAgthEOqYIiqJLS0sajQZFUafTWVlZKRKJlpeXtw8wEb9FEIROp585cyYxrW+PgL2n qKiosLDQYrFEIpHsSfsFO7KwsPD73/9+b2+vy+WCMEd7e/v09DSSUDu9uLh47949i8USDod3dw/h cBg6Gt6/f//+/ftOp1MsFnO53I1xWbDJ+Hw+j8eDwnXQZkgkUkFBQSQScTqdux6KlANunkajyeXy 5BNlQETOz88XFRXx+fzi4mKFQqHT6cLh8NLS0jbRAbgciUSSyWQGgwHa00xPT3u9XqPRCG4SmUxG JI0l/yCQbDE5OQnCLh6PA+cHDP5Wv8IwjMfjSSQSs9mc/LXSB4goXb58uaqqqrW1FUVRCMan/EKx WGx1dbWmpsZsNvN4vIqKChzHHQ7H9gEmAMgijUZTW1tLuDz3eD/oGrtESUkJlUqdm5uD8pY9nnZH 2CbABKW/X/3qVxsaGjo7O2GU3G73gwcPvF4vHAPaWHd39/Pnz8FDs7vb8Pv9Vqu1v7//1q1b3d3d JBIpPz9/G7Kf/Px8CJFHo1ESiRSNRrlcrlAozLYsPRjVvLw8kUgEoubormcAACAASURBVPuV9wbe XKfT6ff7VSoVj8crLS0tLCzUaDTz8/PJ1KAwGAytVmswGLRarc1mczgcNpttYmJidnbW5XIplcpd hNRBbbp3797S0hKkT2k0GtBjtlKPMAwjk8lSqRRoJLMkAkhqamrSarWwr6djogBbbl5enlwuz8/P J1QZkDVbORXQtUrgaDRaWVmZ8htjMBgzMzNpLWzeCpuqMsT/Gxoa/uRP/gTWPJlMfvTokc1mIzpx MhiM2dnZjo6OFN52KBSanJy8f/9+V1cXl8uVy+XrDkDXOsZptVoWizU9PQ27O4qiBQUFENvKhqmM rKmDkEy3U+0hHA5PT09PT0/zeLy8vDzoLltZWYkgyPz8fJLpDgKBAHQasVhsMpnC4fDExASknXI4 nOQzCUDqJeb8slgssAq2/yGKooFAIKtUmQsXLjQ2No6NjQmFwry8PEj9Sfm1wuHwwsICn8+HgjsE QUCVoVAogUAAciq3+i1UOQmFwuLi4r0kPawDrJpwOGw2m/fOy7JTbKXKgK4Wj8f/8A//sLKysq+v TygULi8vP3r0iIi5E0ZUCt2uEArs6+u7deuWxWIpKioSCoUbt15w+hoMBrvdDs7RaDTKZrOFQqHH 40mTKrwLoGsc4hKJZKcKhMvlMhqNq6urUqmUyWTSaLSSkhKtVru4uOj1epMpKcAwTKFQGAwGg8EQ DodtNpvb7TYajfPz82azGZi0krwZEDVTU1OgKeI4LpFIwEx95UMtLy9nTwk36fr16y6Xq6CgAFx5 Ho8n5YVwgUAgPz8fFgyLxQJ2IBzH4c1t+hN0rR5BqVRWVVWlUO+DcW9razt06BCUn2WmGoXAVqoM PKBYLBaJRGCyeL1eoPqG4cIwLBqNms1mh8ORDkXY4/G8ePHi8ePHFApFoVCsc4yD+BMKhUKhcHJy EgYN3EgzMzMZ5kLYCsSur9Vqd6eax2IxKAezWCyTk5MLCwsul2sX2xuDwTAYDBUVFTMzM16vNxaL zc3NjYyM0Ol0QkyQSCSv13vr1q3x8XG1Wp1YCQKhRp/PNz8/D2+BwWCo1ertnwje0fLystVq3emD pwOEV6a2tnZkZIRMJodCoeLiYplMhiAIMDKkENFo1O/3V1RUuN1uGLRAIEChUPx+/+Li4lZTFOYM g8GoqKhQKpXJl9RuD8KvZjaba2pqTCZThuXMNqoM7F4ymYzBYMRiMRzHrVbr7Ows4RUA4QN0FSlf 1+ABbW1tNRqNBQUFG1UBmMZqtdrr9S4tLdFoNNBmWCwWdMdM7f3sDjCMoJDtQtQQI2y1WmdmZqan p1dWVjwezy7qlcRicU1NjUAgmJmZiUQigUBgbGxsbm6usLAQ/MGgmI6MjLS3t/t8PrVave6GSSTS 0tIShNcRBHmlKoOv0cTPz88TLFw7uud0gAyZpBCWKy4uLi4uJr5DUTQajUKQEj6BQenq6tpp7wz4 od/vB7chvLAjR450dXVtmj0KZ47FYj09PRcvXhSLxXt90ISHQhAkFAq1tbUBmUE2vAYYzPz8/EuX LhFJiw8fPgwGg3CHIG3HxsbGx8dhqafpThwOx49//ONf/vKXv/M7v1NXV0cikQitCwaKz+crFAoQ keBI1+l0Q0NDry8p8DpASBv8hR6PB0GQ7cM62yAajZ4/fz4cDj979gwicZBDAOfkcrlgB8disYcP H548eZLD4RASBEXRcDgM7JGxWIygd9sKoP0EAoFsa7VNJpPBZAyHw2QymUwm02g0gUBQW1tLHANj TuRswbP4/f5nz57t6FogZMlkMiR8gPIkkUjq6+u7uro2HUPI0rDb7YODg9AjaacJN9sAw7DZ2Vmb zbYvRUybAmqXTp48WVZW5vF4mEwmOHqJtF8EQUgkUm9vL9iZ6bvt0dHRH/7whzqd7lvf+pZEIln3 LYqicrnc6XQC2QmkUUOv7zTdT4YBM41QIECz34UaDXmleXl5169fX1xchCXj8/nu3LkDB0DaDQi0 ubm5jo6OxFRCmO3wLUT0Nqb6rgPs5kANnz25Mui1a9dScBYUjcVioKDBJyCMLBaL0WhUq9XV1dXI Wj0Il8tdWVmBI8Ph8MOHDzelTCbSYN9///2zZ8+mitoZVsWNGzcgs2zvJ9zFpTcm0MF2VVlZ+Y// +I+QGfPw4cPE8YzH4ywWq7+/f2RkJDOzB4huv/3tb2u1Wp/PlzhWkAXV3t4O/4esN4ip7+/MRhPS flNY+JYSxOPx7u7u+fn5bYaIzWaTSKSKigqfzwdkoInfYhjW0tKyadovvkaQ/+jRo11nUKUcQO/7 n//5n1VVVd/5znfAHNzjOdcpPchaLr/RaFxaWjp+/DhsitFoFOIXkKuOYZjFYnn+/Pmm2jasPqVS +fWvf720tDQlMSaCr/nJkyeJWkIGQDiENm0cSKFQIpHI97///VOnTi0tLS0sLHR1da0bFjKZfPv2 7YyxjNDp9CNHjnzrW98Cmy3xKxzHBwcHR0dHmUxmJBKJRCJer/fJkyfpvqVXgkj7NRgMhHG+3zf1 f3C73Y8fP96mRBfDMA6Hw2Awqqure3t7l5aWEr8C/uKTJ0+uE/sAmF2Dg4PDw8NZZbumxucJ4Q+o JUsEBPMSPyEcIegaF9zZs2cfP368sbgL/h+Pxy0WC0yUPVpLoBgFg0FggsqG7ifrgOM4kb6zVegt Y4hGo3Nzc3/xF39x/fp1SDglliuKokKhUKVSzc7O4jgOPYebmpo6Ozu336rfZGAYVl9f39DQAMye KysrUOKROOfhpT99+nTTM8Tj8Rs3bohEosOHD7NYrES3PIqis7OzfX19e9cVshyJxR2JeOutt+A/ ICVgscPWCF5MuVxOoVA2HVt4BS6Xa2lpqbKycu/dFUDcG43G58+fZ1iPSRKxWAzcUaFQKBAIsFis fdyTgsEgcGV9+9vfNhgMxKLAcZxKpcrlcrvdvrq6CiopnU6/cOHC/fv3D0wfxJSDy+VeuXIFRVHw 9AwODi4tLSWK5Xg87nK5XC6XzWZb91s4xmKx/PKXvywuLq6oqFgX/ovH4x0dHbOzs0g6PXa7QEbD txCxAq2F+JBOp4vFYiK8vRGxWGxlZaWgoGAvCSJgtno8nra2tv1ixQZVoKWlxev1RqPR3t7edRWG YHNkj6oL0Y1f/epXbrf7vffeg9a4sDGQyWS9Xp9IMQ7cKqurq/vYlgz2Lbfb3dXVdfHixVd6SjMP YDilUqlcLhf66j1//jz5n+M4vry8fOfOHRaLRaPRvF5v9vhgsgcQZoLabAgOwsTgcrl8Pn+rmjsU Rf1+/+rq6o6YIzYC9JihoaH+/n4o1dnL2XYBDMOCwWBhYaFYLA4EAk6nc2PM0efzpTDBOSVwOBx/ 93d/9wd/8Ac1NTWE4QpF4wqFYnFxkclkEnljKpVqenp6H3VEUARNJhODwSgrK8uefGQCOI5zOBwE Qd56661IJDI0NLSj3rTAZDY+Ps7lcnEc32aDzhKQ1nlN0grYBaFMkcvlBgIBHMej0WhRUVE4HN6U eQnHcbPZzOfzNRoNuNZ3MWNAu3c4HMPDw2VlZZCWv18zD0VRGo3GYDA0Gk1ZWZlcLi8pKSGRSFDV JhAI5HJ5JBIZHx9f54WCgohAIJAYeEo3YDOYnJy02+2lpaU0Gg1fI84ik8nArA+EN0Ae6vF4VldX 9708LxQK2Wy29HUKTAnAzSsUCnfRExjy+7LcMIW032vXruXn59+4cQN65mXm0mA1wYKCIiYEQahU amFh4eLi4rpOAuBUhkInhUIhlUp3be2AHtPb24uiaF5eXvK1b+kAiUSi0+l8Ph+840AlBY9PIpGk UqlEIrFarRtvEsdxJpMJdMmZlJM4jnd2dhYUFBQWFoIbGFlz5IfDYafTSWStCYXC2dnZ/e1sAJIQ KkxlMlmWlD5sBHgoxWIxMHzuSDjjOA5e5LTeYUqQUVUGWVMgwA3O5XJPnjy5vLzsdDrVajWCIMDk tnFCcDic6urqXfBzEICM65GRkf3VY9YBdCwKhSISiQwGQ1FREZPJLCoqwnFcKpXOzc0RzwvZSBwO JxAIAHtyxuQjaDNms3l2dra8vJzBYMCl0TW+OCAahpIcDMNcLlc2MBBCTXJxcfG+38k2wDCMRqOB 2rrf95J67KMqg6wtGcgY0Ol0paWlJpOJTqcrlUq73b4uBZjwI8rlcr1ev+stHLy/Vqt1eHjY6XRm FT8enU6HnkcGg4HL5ebn53M4HA6HQ6fTLRZLYgEEjuMCgWB2djbzfk0Mw168eMHhcIgiStAO+Xw+ WHHgSYLUydXV1X0P3qEoCvVxCoUiO7UZ8CCwWCyv17t9e9HXGhkNMBGIx+OBQKCqqorBYABr6tOn T+VyeVlZ2cDAgNFoXOcHw3Hc4XAAJeUursVgMObm5tra2ohtOAuBoigEmOD/PB6PYF4iVIdIJFJY WOh2u6enpzM5I6F/wtDQ0EcfffRXf/VXKysrRDG2Xq83m81QaYUgCIlEyjzr4FaANP7m5mYajZbl DoyMAUXRoqKiioqKdcWWsGG8MjH59QKJRPL7/VKptKioiMViffDBB06n88GDB8ePH8dxvLW1lchs JZZYMBh0Op27izHBGD569GhmZobBYGTtGELqNJjaNBoN+oglHgBaYE1NTU9PT4ZpdiF4/dOf/jQ/ P//EiRN2u51MJkciES6Xq9VqzWYzIV4oFAph5u2jVAcRDSRS2zPLvWmgUqlVVVX5+fnrNDxQrR48 eJBambw/qgxMvo6Ojvr6+sLCQgzDjh8/jmHY+Ph4LBYrKyubnZ3t7u4mROrz58+hSQebzd4dX8jG 3PgsBBHUh3+vXr16+/Ztj8dDJEpDT8fy8nIKhWIymTIsYhAEGRoa+tGPfvThhx8SKxbDMI1GYzQa Q6FQOByWSqUOh8PhcGSJ7h8MBl0uF9FtINsA2UinT59+/PgxTOxUDRqc6tixYzKZbFORsZENGUXR w4cPnzx5EnorcrlcUGHD4fCDBw+IXZ9EIrlcrpGRkSzsw7IORAfWzs7OI0eOsNlsHo93/fr1cDjc 3d3d3NyMIEhHR8fS0hLETD0ez7179/Lz8xsaGvbimMnmMSEAYTWPx6NUKs+dO9fa2pqofgGJVH19 fU9Pz06pN/YImK4//elP6XR6TU0NeGIg80OtVlssFtgLdTrd1NRUNuS5E4UamWcpSxKQPqVUKiOR yODgYAptFXSt99bZs2e3MmLByl2Hq1evCoVCqVSan59PoVCg2H5iYgLK7ohs/YWFhdHR0WTuNi3j HovFmpqaEkkykITE2/7+fsisRlG0q6vr0KFDKpUKBler1ep0OvB2KhSK1dXVnp4eOBg4NnYkXIg6 gsHBQSqVui8peMkDgk1QT3v8+PF4PB6Px48cOfL8+fNEbQbyRvV6PZlMHhkZyeTtQesWo9G4jowH zKM91pcdJEB58IMHD8Lh8NmzZ7fSvzEMIypLIQ6Swt0CTtXV1RWPxw8fPlxSUvJKexFecTAYBNZj +BDyLbRabVlZGZGpgKJoKBSCXYRKpVoslocPH7JYrHA43Nrampk9D+5BIpGcOHFiXRwEltL09LTJ ZIpEIjQazeFwPHv2rKGhATrXUKnUo0eP4jhOFJFNTk6CYY3j+O6iKmQy+eHDhx6PJxaLZbmoAUc1 bGl6vT4YDAqFwrq6ur6+PiIiBqKGz+fX1dX19/cvLy9nzFcHuR2Li4vLy8uJSTwoim66Kb6xSKy6 l8vlb7311qZTF5aD0WgcGRmBAUzhe8TXem/95je/wTDsypUrydOmgNE7PDyMIAiGYSQSic1mNzU1 gcpFPAjk1IJZ8vTp04mJCZFIND4+Pjw8nDgnd88rA/EOgUBQWloqFArhSikMLqAoSqgy8Xi8qqpK o9EkSVZGeMvHxsaS/Ank/cnl8rq6OhzH/X5/W1tbhmMlMKRsNrulpQVME7jzJ0+e2Gw2SLkljozF YjMzMwMDA5m8PbCNvvrVr548eRLukGjhYbVaaTQamUxeWVkZGBjIHscMFPyDPoHj+EZ6HhRFobgX dseTJ0+KxeLd7Wf4GrfbgwcPEnsTnjx5sqCggDgnCJfV1dX79++ne5SIyuSqqiqtVrtV69AkAV1a jh49qlAotmpiB/nIVCq1o6PjyZMn//Ef/0Emk//4j/8YJNTuHgF4X7RaLXRko9FoqdWbJyYmxsbG AoEANASGTvLJ/BA4uBO7F70SMM2OHDlSUFBAoVBGRkaGh4eh8/wenmBngBhTTU3NoUOHoLEa8AQC cShxGDjhfD7fwMCA1WrNmDYDTD8VFRUffvihSqWC3Duw9G7dugWeDwzDJiYmRkdHU+vO3B3gBmQy 2YkTJ4glRiaTb926lVjRSaFQwBsKIbOmpqZt2F+2B+xxo6OjiZwOAoHg9OnTie8IimxevHgxMTGR mdfH4/HeeustJpO5l5xx8JKyWKyzZ89u+nIhrz8YDJLJZKfTee/evd14ZeDHLS0tX/nKVwoLC81m 8507d9hs9lbDhOM4jUabn5+3WCxarRaKu4hvYS/s7Oycm5sDbzbhx4bUFiaTGYvFoEFgMtElOGFH R8fU1FTyeozf79fr9UeOHAkGg4lKQyaBrxG2trW1NTY2Ek968uRJEon08uVLk8kEIg8MaK1WW1RU dPv27UwKQSg6y9jl9g7QYOD/8KJLS0sRBCG0GdBciePb2tqI/5PJZDqdHgqFBAIBuMoIXWTTeUgE AU+cONHa2koc+fjx46NHjyqVStj+QWflcDjHjx/fikVmK4C+GAwG9yX7B179ixcvnjx5IpPJampq gDclcTQI0pczZ85UV1fr9fqBgYHdWQVQ8vr7v//7hw4dEggEra2tk5OTwGO06fGgIw4MDFAoFKVS CTlSxL2RSKRQKNTa2hqLxYhZAdIJ9hgcx/l8vlQqTabVML7GU9Xa2po8FQ2KouFwuLm5WSKRhEIh Npu9L4TjICTHxsbIZHJFRQVUeAkEgnfffTcQCDx48CAYDJJIJHSthS100err68vMdoivsb1nFfXc NoA9a539E4lEmpub29raiHwjYPmDb1dWVj755BPiYDqdDk02wORYx8a78Ypge8ORo6Oj8F5WV1fv 3bt35swZov4L6l3Ky8vj8fjU1FTyrw8ofHAch7mRYUCU1uPx/OY3v4lEIhsdGaAhAA9qfn7+1772 tZ15ZcD//NZbbxUVFVGpVBKJFAwGtxka0BwHBgaGh4ehnIFMJlOp1EAgwGQykbXud0nWJYFJHQqF qqurdTrdpg5zHMfpdPrdu3eheUfyMgI2ueLiYmh8D+G6QCAA8eO2trbV1dXM1FXC3M3Pzz9y5Mg6 aldIrZienu7q6koMbEcikba2tpQQuqAoCkUcifMGwzAwJqC1UGK7MphSc3NzQ0NDHo+HwWAsLy9n lVcGQZALFy6sC3eCUh+LxTweT0dHx66VM/BEwv4EDUCIR05Ujwg2Z2DyhdkF/pvbt2/v8emSAYVC gThRSUnJHh0zBOARwuGwWCw+d+7cxu2fRCLZ7fYPPvhgYGDgBz/4AbAMJHNmUPVYLNaZM2doNBqL xYI9YJvpBG+2ra0NmOAh9A57IUhkKDVIUs6AHEdRFG5go9ZI+NVu3769U7EAm9DZs2cLCwsDgQDY b2A9z8/PP3nyJDPKDagpFApFr9eXlZWto5mBUvanT59arVYglEIQhEQiWSyWjezAu7g0CGqdTldY WJhovpNIJAjPSSSS8vJy8Peja8xVkUhkdHR0YmICxE72eGVARcjLy2tubl63EGCPo1AoRqMR2s7s 4lbBcwwz0+/3U6lUCAXCStlILtXS0kKn02FgoXwJduEMaKIMBoPNZtfW1nK53BT2qKZSqW63+/jx 41vFypPyysCQabVarVYLAwoa6Ct/RaFQHj9+PDU1BWIFbFbQ8hIFfZJPi6Io/Kqnp6enpwdmM+Fq hvlx+vRpBoMBG8wuZkw8Hid2NRRFgZSJwWDsugvPLgBzfXFxcSPHMWyBarW6qKgoEomAiQkh5Obm Zrvd3t/f/0qSPfiWzWaXlZWJRCJo4IBhGIvFUqlUxcXF8FsSiUSlUte9GtAAmEymTqcDx2ZahyJ9 gMlDIpHy8vKuXLmCIEggEHj27Bk0XUoe61bBVp3eYS80Go3T09PhcDjzvHaRSCQWi/X29tpstlOn TqWkzgKkZAqpR2B2cTicsrIymUxG3OFWo5r4Q7/f/8UXXwDFEbJmdK37efJyhjBGb9y4gax5boi4 RiAQKCwsbGxsRBAEGCJ28bDRaJRY4BQKhUwmEwJnF2fbBfA1IkGHwwHNqhK/hYdtbGyEbXhsbGxg YIDJZEql0suXL8/OzkKKwyuBoqhUKi0rK4MUCgzDyGSyQCDQ6/USiQSED5lM3pgEg6JoMBhUKBQI gkAVfYqeO9MApQ1BkPLy8vLycgzDzGbzy5cvd6TTrPMch0Kh7fffBw8ewERdp7hkwKMWCARCodAX X3wBLo9kHJzJIBqNbp+O+QpVBsxNFov153/+51VVVZ9++qnT6UzGaAB/TFtbm9lsTlMYGCTpOvfX rVu3KBQKNK1M+RUzBnhhv/71ry9fvrxRtyW2YTqd/u6770YiEbvd3tPTIxQKT58+TafTe3p6Jicn NyrgFy9eZLPZPp+vqakpMXUDUq6SvDfIaqytrY1Go5Bb/voqNIkAXgAEQcLhMIPB6OrqSnmztET3 ciJAqDU2NioUinv37gFvUMqXDJzQarX+/Oc/V6lUhw4d2nuICsS0zWa7ffv2hQsX9sKrQSaTV1dX T5w48b3vfc/tdn/++efJyA3QA6DqHkXRNNXBghhMVEDNZvN///d/Q+ZQOq6YGUCYaWZm5osvvtjo TkAStuGysrKysrJgMDg1NTU6OqrT6cDm+eKLL0CMwI4A81YqlZ44ccLn83G53PPnzycOEWhsxJ8b y+gIQJFBQUGBSqXyer2Li4uQJvW6A3poyOVyHMfBa3jnzp2UL/ZNo0LoWou6Cxcu+Hy+W7dupfai BGBTePbsGdSgKRSKvXuCwbfU3t4eDofLy8s39ofaTpUhslCvXLkCVSpJKpLA6AwVAYRzMmPYXWoh 6F7QJ725uTm19AAYhtlstu7u7suXL2MYBj1LY7HY4cOH5XL5VnorhUK5cePGhQsXts9CpVAoBQUF ly9fhqfwer1g9MTj8YmJiYmJCSaT2dzcjGGYVCo9fPgwlUqFBJFt5MimIIzmiooKCHUha5NErVbP zc0tLS3J5fLCwkK73Z5VAaYdgUqlxmKxurq6+vr6SCQCjGednZ3pfpyLFy+azeZXdsBOBOwcCoVC KBQmmceAoqhSqaypqUmJNwVMZ6lUevHixcXFxcePHxPtunZ0HshCra6uPnr0KDTQfuVPILzl8/m6 urqA+Gu3D7FLQOrDLn4ICkRbW9upU6c0Gk0KRQ0odh0dHSiKnj9/fnR0tKOjg8vlkkikU6dObTqB CWX01q1bFy9e3F4ZpdPpoNMgCBKJRCCI7/f7vV7vwMCA0+nU6XQVFRU4juv1eoPBADbYLp4OMqOL i4tlMlkkEoH5AMWbWq12fHwcyl2hrTfRXPr1Aoqi8Fxvv/02giCwV3Z2di4sLKRJ1MBppVLpuXPn Pvroo138tqGhYXJyErpBb3+HsL9UV1fL5fKUtMgAEXH8+PHq6uqHDx8Gg8EzZ854PB7izJuLDAzD QqGQUCh87733rly5EgqFPvnkk5cvX8JSSWaUIdS675sZONlUKlVDQwOGYcvLy8+ePbt48eL9+/e3 UiBAQiUmVYRCoebm5ocPHy4sLOyI+QpklsViefr0KWwzv/rVrxIPePr0KTSqVavVR48eTdQ0XS7X 8PCwy+VqbW390z/90+rqapfL9UrfCYZhXC6XaK0HhbWQqCSXy2tqanbdYBxmUnFx8blz5+DMEGCC Vwx+HWiYolKpzGbz3NxchukoUg58rSVhQUFBYkpZJBKBDIz29vbl5eW9PyOO42+//XZ3d3c0GqXR aMkHueBVms1ms9mMJOc9xnHcbDajKLp3rwxMCb1er9FoPvroo7q6ukuXLn3++eeFhYU1NTVJZpCA qKmqqvrGN75hMBiMRuMnn3zCZDKTMYHALwta9b4XP4OgOHHihEwmo9Fojx49otPp4GbbVGiAYRBP aNEaiUT4fP7Fixfv3bu3U9EPllh7ezvQruA4/qMf/Qi+AjKLzz77DETNmTNnRCIRmEYQ8bdYLFC9 9fz587/8y7+MxWLJvDgKhVJYWFhYWIggCOScDQ4OLiwsUCiU0tLS4uLiXbvoYF5dunRJqVQiCDI8 PDw1NcXlcmFPARkI2pJQKDQajX19faCXv76iBkEQsDCPHDkCf6JrXNUUCsXr9T548GCPTwcbUEFB wZEjR27evLlTOxZfI3dI/HMbgCMT9oi9e2WAt+Ly5ctTU1M/+clPzp07t7S09NFHHzU0NKhUKnj7 m6gyEGYuKCj45je/eezYsba2ttnZ2WQmJaRlQRojrId9Dz1A+r3Vav3ss8+ID2/evBmLxd599927 d+/W1tZOTk5KJBIcx4Ewe3Fxsa2t7ezZs4k55BQKZRdvAgo1t88AB8Mukclj3Rni8Xhra6vZbC4t Ld3pnKDT6aWlpaWlpeFw2GKxQOBfIpFUVVUln5MFMpfNZp88eVKlUgFtGoVCqa6uHhoaisViFApl ampqeXlZrVYLBAIGg3H+/PloNPr5559jGJYNHni3281kMlM1GyGuj+P48ePHkYQMYgRBoNXX48eP dyRYURRtamqSSqV37txJXxoN3BKfzz9y5Ajkru3xhKCpg9qKoqjRaFSr1VevXl1YWLh//z6fzz90 6ND2SWYQRKivr/+93/s9FEX/93//1+Vy0Wi07bOwYds2mUxdXV1AZrPHB0kJwAxNbA6KYdjo6GhJ SYnBYGhraztz5kxbW9vp06fb29s9Hg+Lxers7IQtGRwzIDB3apZ1JQAAIABJREFUl/ML7jGi/n/T M4CoefDgwaY/x3F8Zmbm008/FYlEDQ0N6woOtgeJROLz+SdPnkQQxOPxQEtwDoejVCpLS0t39Dg4 jstksmPHjsEUJZFIMplMq9XOzc3RaDTgtUJRVKfTYRimUCi+9KUvrayszMzM7K+ogWeMRCJutzsl gTCwD0Hh4HA477zzDnwOKSMQbXn58iU8eDJvCqSfRCJ599134UXv/Sa3AtySwWDQ6XRQNrj36BKT yXz48CGouePj43V1dUKhcGJiYmBgQK/Xl5SUrFdlwI2h0WiuX79Oo9F+8pOfQIFGktcjk8mXLl26 c+cOFCtlrZpMIpF+/etfIwjS0dGBIMjKyorf7zcYDNXV1aFQiMlkJm7zkDTe1NTU3t4+PT2dZOoP jP74+HhPT8+uUx+IoGNPT09ZWdnVq1cNBsMuEqmoVKpGo9FoNAiCwL4LOlZ/f7/T6ayqqlrHSgSA TVosFtfV1UmlUghLoWtdtBK9MnA82EwQlDx16tTi4uLeix2yH0TqEvwJtNSJ35LJ5EePHkG70E2n AbiaofB7LzlewDHl9Xo3lenwFlwu1+Tk5KFDh1LVLwbML4FAAFkRGIYVFBSo1eq+vj4o6N3+h6dO nWpubu7p6VlYWIBhfOVsIcpQMQxrb2/PMCNL8iCcstAu9N69ewiC3L9/H56az+eD4kIYJ0ROfUtL y927d4kU5iQvdO/ePYjq7mI0YMxDodCnn36al5dntVqvXLkChWM7nSQcDqe+vr6+vh5fqz0mk8lW q7W/v5/D4WxV2AI7d3Fx8eHDh6HiDIAgyMLCwsTEBIfDSZwYsCvFYrGioqJ33nnn448/TlOGWbaB iL1Go9GampqamhriK6Dhvn///jY/BysU6hn3chtMJhO0ik1XK3w4PT2dl5dXWFiYqpZ8cMW6urqK igq/389gMGpqanQ63fj4OLKOIg+cnGKxuLKyUiwWvzKajq6x5PH5/OnpacKeAGogl8u1j11hkwRw Q4HoJ4qxvV4vlCkiCAJLcZtxwDfwrIDK3NvbOzQ0xGKxCJN9L4CQczAYLCsrO3bs2Makp5QDJEV+ fv7Ro0cTSyKJr/r7+4eGhkD43r9/f25uTqlUVlRUCIVCHMeDwWBHR8etW7cWFxc3PTkkoNXX1weD QSIAl6YHwXH89OnTuya+2yMInsqFhYVNHxPDsH/6p38SCATBYLCzs/PTTz+FBravHBA4RqfTSSSS 9vZ2BEHodPr58+dXV1efPXu26awD+opYLNbS0rJ30neYCTQazWAwlJSURCKRRN1l+2JsHMeLi4vL ysogOSkZUaNSqdxut8PhAJ8BnU63Wq1bRXCyDbAJQZQEirHlcjkE+yF9GGTONgITjln3IYZhd+/e haJuMNn3eJ9E4On8+fNAfpPuJQPGgF6vr6urwxIa5YJ+s7q6+uLFC7PZzGKxnE4nBEe0Wq3BYADJ DFnnHR0dsGWuGwH4RKVSVVdXd3d3pzyXf92FOBzOK1OO0gewuu/evbtxGgAfRG1t7Q9+8AOHw+H1 ej///PPkubnh6c6dOzc0NGS1WhEE0Wq1NTU1AwMDJpNp3ZDCwXl5eQ6Hw2Aw1NbWer3ePW5YoOiL RKLq6mqhULgxo4687lCIPkCN7itfBkReVlZWeDzeN77xjQcPHthsNgRBIpHIpUuX7t+/v7y8vF90 c0kiFouB9UPoMdPT0yMjI5cuXYKF8Uqq7E2PiUajlZWVlZWV6bjnVJW37Q74GpnB4OAgTIDx8XG/ 3w+Z+QUFBaBmUanUxsbGY8eObRosgDwqOp3ucDjGx8chtXnv8wTM04WFhUePHiVub6Cw7mPfWjKZ /MpXBlvI0aNHURT97LPPlpaWXilzobrVZDIBSfGLFy+uX7/u8XiePn261Q8hDIHj+Oeffw6p4nsc dhAaZWVlsJsm8xN8jdyhrKwMlJJkRA2VSh0fH29paSGTyY8fP/b7/dC44MKFC/fu3ct+qwkWAqTU NDY2qlSq+/fv5+XlVVdXg6DHXtXufqterfAe04H9bfUM09tqtU5OTvJ4PK/XC7smgiAGgwFmDo7j Eonk61//+vvvv7/pnIcRA2JclUqlUCjYbPbec97B6f7s2bNEPz24V1NIprILJNPbIR6P83i8K1eu oCja1taWTKYRqJXAv4dhGJPJbGxsBNbWjWIKTgX2GBD/1NfX79H8Bv1Eq9UWFBT4/f6NlQHkxOMK CgqqqqoEAkHyLwMYFywWy49//GORSPT+++//4he/ALaJc+fOPXr0yGKxZL/NRBQl4jheV1cnEAiA uO/mzZuXL19mMpkgpjPJLrMVYMAXFxcfPnyoVCoPHz6cvlsCaylx/sGEdrvdn3zyCcgIEok0Pj6+ urqq1Wrz8vISZR+KolQqdZv8MhzHBQIBkemWKhQVFX3ta1/b0U8SvQUwGfr7+00mUyaDpKDKIAjS 2NgoFot//vOfJ8M1Dt/Ozs7Ozs4iCPKzn/3slRciogm/+tWvgLmgubmZz+fvdN8C253NZkul0uR9 yDCptFptaWnpjuxjeC8PHz4ENgE6nX7jxg0ej5eXl3f58uW7d+/uo36fPEAne/bsGdSDAMWoyWSy 2WxXrlxxuVyEP3jfAd7ljo6OmZmZ+vp6tVqdKnLFdcDXiKwSP4zFYmQyuaenBzKiUBQNBAJGo5HF YkGiTOLCxDBs+4hJLBbT6XTEn6mq6z5x4sSJEyeSPJjI5E1MXYjFYo8ePQIysJTcUpKAtLkPPvhA IpF8+umnwB65vayDpUrkWkFYB9m22gC+mpiYmJ6ejsViIpHozJkzu/DzgX4ik8kYDMZWYoqMrA2x QqGoqKjYdetpMpnscDh++ctfHjt2zG63T0xMhEKhpqamqamp4eFhv9+fDXrAK4GiKIvFslqtv/71 r2EPhjVDZHpm/pZAoDx58gTKqgn1Px6P22w2IjE55deFJA+gBVpaWoJcPBRFl5eXP/30U+DywjDs 888/9/l8DAbDZrMtLi5GIhGRSASOvSRJnLMB6zaPeDy+qVMNRM/du3dTW6u/7hLhcLiqqgpF0e7u 7pWVFWgVmyZjAHQ4SOOAq5SVlVVXVydpQoF6sbKyMj4+/vbbb28vpNC1ZqhQ4YLsat7Ccnj8+LFS qbx8+bLJZFpYWOBwONevX+/v75+dnX0tiI5AbeXxeP39/WNjYyiKQkJ9Mm7g9AHqNm7cuJGYpgPh MLBV0iQAYVmNjIzAv9euXePz+WQyub29fXBwkMViUanUubm5Bw8eQC7w6OgoMFqBQryuPUXWIjGT lwCJRIKa0ESAy2d6erq9vT2trUkxDLt8+TKKohDFS8YTvDtAsHtlZeUXv/gF8SHwnCWpb8TjcQ6H 09nZqdFooHHYOgGFXrt2LR6Pq9Xq8vJyBoOREraJcDj8zW9+88GDBzMzMzD5qFTq4uJid3c33EH2 6zTImhv8ypUrmzKXZwA+n+/x48cQEThx4oRWq03fDroVIJXs7NmzWq32wYMHZrMZlhYUZ924cQNi /5v+FvatyspKpVJ5gJN/YXMdGRnp7OyEhkSbHvDkyZNN4/Qoira0tFy7dg0qd2CTC4VCp06dEolE //AP/9DX1+d2ux89epTBZ/q/aDePx7tw4ULyVhS84itXrgBpOplMTsyVkclkJBKpvLxcpVLtfTJA DqBWqz158uR//dd/ESzkFAplcHBwYmICZmb2zzqIbms0mlOnTmUgB24jUBSdnp5+8eIF5J5fuXJl X4rb4fV9+OGHS0tLz54983q9kNQFxRPt7e2bLi5kLY8qPz+/qqpKKBSmkH462wAu+Tt37qysrGya uUEoo+u+ArEjkUg+/PBD6DNITDMSifSVr3zlxYsX//7v/26320dHRzelV00f4FrV1dVlZWVJzn9Y MiqVqqmpidgT0evXr4fD4cuXL+/Cw7wjEJGRL774YpuGcPsOKKzg8/lnz56FfAIGg5EZVQYEsdfr vXnzpkAgOHXq1I5KIjMG0GPGxsZMJlOSRjB4/iBZD7jeD6q4QRAEKHZu3LgBg7NTVQZZy6g4evSo XC7/+OOPo9HorVu3gFlxv1BYWFhbWwvsF688GGRNc3Mzi8V65513hoaG/vqv/1osFgsEggsXLqSq omErwIA/ffp0bGxsq/0vGwCx2sbGRhzHJycnr169mkj5lVbE43E2m93b29vd3X3o0KGqqqo0BY/2 ApCHDodjcHDQZrMlE+2FSASDwaiqqioqKsraXSYlgHkORIgwz3ehyoCAeu+993p6eqD/+S9+8YtN M2DSDTCfqFQqVHEn461B11h8L1++jL7zzjvFxcWlpaVMJnNubm5wcNDtdlMolHA4zOPxVCoVlUpV q9V7f6rXSJWBrsWXL1/OBk6UZAALuKioyOVyud3u9GV4wFRzOp23bt2CDk03b94E2oB4PC6Tybhc Lp/PLyoq2kotxjAsFAopFIrKyko2m32wdRoEQaDQprOz82c/+9ny8vKmqsy1a9daWloSVZmNQFEU uMbv3r27X/3z4KICgaC2tnZdXtSmoFAos7Ozf//3f4+i6He/+93y8nKdTqdSqUKhELCBE8JXpVLx eDyRSCQWi/eeNfkaqTI+n6+2tra2tnZf/DG7AJTjFRQUANFi+i4EaVgvX77s6+sTi8UzMzPPnj0j lo9er0cQRKPRMJnMrVYNuNWrqqpUKtVrkd6wF+Brfdo/++yzW7dubarKFBQUfO1rX6utrd2G6AXO Mzk5+cknnwwNDe1jfTtEXaurq5OUdSSDwSAQCKRS6fz8PDQjhI0QRMzKyorFYpmamtLpdHucuLDd crlchUIxNjaWnesWHhwS0XU63Ws0+0kkEuigX/rSl6LRKIvFunbtWjgctlqtKWm0C1M8EAh0d3f3 9vZCavrTp0+hLgMYa5aXl6PRqEKhiMViz549Gx0d9Xq93d3dOp3u5s2bIyMjRqMxLy9PJBI5HI7p 6Wkwtvh8PmTeHEidBtxRUqm0ubn5gw8+qK6utlqtwDEDLwVFUbBCgIh54yCgawXPX/7ylykUytWr VyUSyfj4OMijzE/RYDBIdBNUKBTbKDQQnbxw4QKKonfu3BGLxRKJhMlkDg0NTUxMIGu0XeCcAOd2 LBZTq9V7dA+DT0ur1QKVbXYWUYJVAJERmUy2v7VCyQNmo9vtVqlU165dGx4evnTpUk1NzcLCAsif VIkam832+PHjxcXFUCjU0dExNjaGIAiUYdvtdrvdzuVyZTKZxWJ5+PCh0+kcHR0NBAJUKvXOnTtG o3FmZsZgMOA4vri4aDKZBgcHI5GIUChMsmLutQPs9xDAvXbt2pe+9CU+nz8xMQHzCl1rIVxVVSWV SrcyILG1/iFvvfWWSCS6cuWKz+fblLs1M3A6nUaj0Wg0KhQKiI1sl4r3zjvvQDOL8fFxn8+3jUEP XBS7zgsmAErSixcvbDZbFm5gr6NXJq2Ir/WIf/nyJYvFIpFITqcTEkUBkDAOueVsNnt4eHhgYGAb dR6+ksvlPB4Px/HKykqv18tms1taWrLWgE4VwEmzuLj4s5/9DJhhqVRqS0vLK70yBJhMZlNTExB9 Dg0NffrppzabLcPGE0hGBoNRUVEBXpZNLZNEr8wf/dEfVVVVKRQKr9cLlVmbnhlb6zu99z5oMNQW i6Wvrw98Htmm0LyOXpl0g0wm37592+l0kkgkILQdHx8HThQqlVpWVqZWqyGrBrQWj8fzSqsdur6o 1WqJRLK6ulpTU3P48OEDP+Aw/58/f/4///M/S0tLCILI5fL333//0KFDr6TfhfHUaDR6vf7mzZte r/f27dutra375Q/Oz8+vra0FkrYt/daJFHnbA8dxvV6v0+mSobTaHhCfe/ny5cLCQlbpyP+Pve/+ bSNN75/hsPcmUpQoUb13WbJsS3KTbO/a3t3s7V1wQfIP3C8BckGAIMgB+QOCBEiAAEGAXHBILjnk u3t3u7Z3LTfJlmQVq1CNIkWxF7H3Xr4/PNGEkWSZIqlqfn4wZHI4887M+z7vUz8P2HNCofDevXun Qqd2BpGpykBIKOdTgQDSaDSLi4tAbM9isfC5tCdp9AI/fDwp6je/+c3U1NQ//uM/UqnUnC0EFEWV SuXXX3+9sbFxYoIGlKeqqqpDCBtxVQZBkJ///OfAKH34adHdLhkdHR1lZWV53gvMN5vN9u7dO0hD OTvaDOgxAwMD2Wc7fgzAVZk8iYIgnw+K2pqbm+vq6vC8wwOTRi8qIG9aqVT+wz/8Q21t7V//9V+D nz6HU6XT6Xg8PjEx8e2333q93hMzn9DsOE6PoMrgmZuFqn9DUXRhYUGv158pbQYALn0gETo74u/s AJRRlUqlUCgOKWLKEhiGhcPhtbW17u5uk8nE4XA+++wzvOldocZ84YGi6M7Ozu9//3tg/j1ugCyT SCQ3btw4cDPOQZVBCp25CdqMy+Wan5+H/qb5nK3gAIWmpaVlTzfZIgAQbPL5fCsrKyaTKc8sQOAO UKlUQD6i1+u7urpGR0dPl9Tu3AFewfLy8jfffKPT6U5Ap4FLXLt2TSqVvo8h9sOqDEymqqoqnU4H HPwymay1tbVQnIk0Gu3Zs2cWi+WMhLTxpOg7d+4UJUv2gHnidDrX19dtNlueKiBYTpcvX25sbLzY Cg1Esn/44QdoEFGonAkCgTAxMfHNN9+4XC7CcXbaw8PwIyMje+LFR1JloHJQLBbT6XSQj0QisaWl pba2Nn9zAhQar9f75MmTfLpcFRagx3R0dHR3d5/BAqKzDCggVyqVwWAw/z2ISCTevXv3LBej5A/g qtne3lYqlffu3QNOvDzPCcvK7XZ/8803ExMTyP/lGi04QKFpbm5ub2/fv16O4JVJpVKNjY1UKnVt ba2jo6Ouri4ajeYvF1K77ek1Gs3ZYR8HrwxkLAL/5unupmCqcrlc6Gtzllt1Ihk5wqurqxBDzE1t B1nf1tbW19d3gV3BeOC/s7OzgN3XAEAttbGx8R//8R8KhYJCocTj8cJaUaBqUCiUe/fuge8Wzk+h UDQazd///d9jGPZnf/ZnWQaY4vE4h8Opq6tzuVwWi+Xu3bt7KKdzBoZhkUgELwHL/4T5A1T2xsbG vr4+KLnYz8h+8kilUmKx2Ov1nn0FC2K1ZrN5fX3d6/WiOXXTRHY16Xv37h2J7P58ARapxWJZWlq6 d+9ewdUOMD9++OGH3/72t36/v1BNwfZcAqgRe3t7Q6EQZE3B50dQZZDdVBLowjA1NVVXV3cg795R AQlKSqVybW0tFoudqZB2PB7/6quvnj17Bgbing01nU4nEokzQjR+loFh2NOnT4PBIHIo0fV+gIgp KSnp6uricrlnME+8IIAs2h9++KGurm7/NMsZOFXDpUuX6uvrFQrFzMyM3+8fGxuz2+1zc3Mg+o/J Z0OlUiORyD//8z/fvXv3T//0T/HxZDNsUGhu3bqlUCi2t7dv3759YEflowLud25uzmKxnJ24Nig0 1dXV7e3tY2NjX3755Z43ApYMgiBn3IY5XcBWbbVaX716RaVSY7HYkX4Os665ubm+vv6MhAgKDtyP MjU1dffuXaTQTPFCoXB4eJjFYj1+/Njlci0tLUG5olqtJpPJiUTi+EJR6I9//ON4PA7aQ5ZSJplM lpeXNzc3czicQokD0GY0Go1cLoeAwunOpGQySaVS79+/PzY25vP57ty5A85/4JWHnoUvXryorKwc Hh6+qFp8YQGuGq1Wq1Qq/X7/kX4LOnRJScnt27cvKhUNiqLhcBhBEAqFcpI36HQ6FxcXd3Z2lpaW 7HY7VAgXZPWBKvOv//qv7e3tP/vZz2prayHOnaU4gwnT2NhYU1NTkCpfHAQCYX5+3mg0nvpcIhAI fr+/t7e3rKzs22+/raysvHXrFh5kjEajLBZrcnJSrVZfvXq1oaHhAvsmCwgokl1bWzMYDEf1PYBa 2d/f39TUdCFD27CDRyIREol0MkY4UJwkEgkourRarfPz87CcD2w2nBvQv/iLv9je3oZN+ki/xF2j AwMDherVDMEmtVr9+vVrvN/QSQJ8AHw+f2RkZI+WBmN78eIFhUIZGRmBfvF37twpSNDxowJYBlar VS6Xu93uLNmr8GzQ7u5usVh88QQ6ELA+e/astLS0tbX1VJJAYZJvbGwsLi6SSCSlUqlQKMCuyMEd TaFQotHor371q7q6ul/84hednZ0bGxs5BJFBkR0dHRWJRIXKJYIsvefPn5vN5lMxwSF4eunSpdbW 1j1xHHAPPHr06ObNm6Wlpd9//31lZWVzc3MxLzgHAAMW9ATM8ukBjWdFRUV7ezuDwbh4nmAos3j5 8uXIyMhpEcrDLgCeglAotLy8vLOzA91tc3MS/48qE4/Hk8lkRUWFUCg0Go12u/1AMwimAvhvIF0R OP47OjpEIlFBXjmIGJPJ9Pz581NsqQ1emTt37jx58gTKwJ4+fWqxWBgMht/vb2pqunr1alGy5AmI c/v9/uXlZZvNluW7TqVSGIZ9+umnx9po7eQBqsz3339fVlbW0dGRf9y2sDCbzXK5PJFIeL3e5eVl h8MBwY50Op1MJg9UBXCvTFtb2y9+8YvW1laFQgEd5uvq6hAEUavV4BLe/1v4EK+eBV2qtra2qakJ jJyCiBoGgzE+Pq7RaE5L1BAIhEAgAKwEKysrX331ldlsfvbsGRB1RqPRO3fuiESiC+keOEmAqNHp dBsbG1mW5YOtXltbOzg4WChb/SwAnJ2hUGhsbOyTTz45O71xgOIvEokolUqNRkMgELRa7crKCl5d dHgoHP2rv/orlUqVZ3oXmBEMBuPTTz8tCNsj1E/Ckj7dSFMikXjw4MHs7KzVaqXRaOFwuKurK/vW wUVkAwjbLS0tGY3GLBXidDrd09NTWVl56jOkgIDFPDU1Bc0Bzpo2sx/p3W4kL1++xLUBFEXNZvPy 8nIymQyFQv/0T//0J3/yJ3/3d39nt9uhNCnP0jao+oG8v/yz9BgMxtzc3Pr6OpVKPUWO9kgkUllZ 2dnZ+e2330IpDYqid+7cYbFYxfh1oQBdFywWy/Lystfr/aA/GHfS9/X1AZ/niQ31uIGiaCAQmJyc HB4ezp/29gQADuPp6ent7W3oUQ2t7sBzTCAQ0H/7t3/TarXLy8vl5eV8Pn9ra4tIJHZ1dYnFYp/P t7GxodPpssxcgZBYW1tbTU1NngILL4GZmZlxOp05n6dQAAE6PDxcwJTMIjIB4e1Hjx5lyVID8aau ri6ZTHYWij4KgnOnyhwODMPcbvfDhw/T6fSTJ08oFMrS0tLOzk5DQ0M0Gt3e3q6urgYvi8lkWl1d dbvdWbYMjMfjAoGgs7NTKBTmme8CWXogA8GiO90dC+olT6s99YUHKK+bm5tTU1PZ5DDg5O/9/f0c Dudcr8dMnDtV5oPAampqJBIJcGvyeLza2trq6moajZZIJKhUKo/HgxShbNJz4FnYbLa1tTWpVMpg MHKWMqA8kUgkqVQaCAT8fv8pBizhurdu3aqoqMjffQX9zy5e/DVPQGmJ0WisrKyMRCLZpEQQCASH w7G8vMzj8YRC4Z7ViKIosAYf88ALCbAC9Xo9k8ksLS09L3153gdw0ff09Kyurv7Lv/yLWCyuqalp amoSCAQikaixsVEsFgMnPfThikajkUgkG00C3Hgqlcput9fW1uYTb8IVIw6H43K5ss+oOA6kUimB QHDv3j0kv9IScGxDBve5nkIFB2wrTqcT+mO4XK5s5Ewikdje3tZoNLW1tXv4R+BRE4nEc0RQDtur z+czm83QMfrsVPPlDOzKlSsSiYRIJJJIJLVanUqlOBwOqCBgI5aWllZXV6Mo6nQ6s9yAMQzb3NyU SCQcDie3FwyXhvKt8vLy1tZWvV4fDodPnt4KRVEMw27duiUUCnPYWmDlkMlkPp9/584dp9N5+fJl o9FYEEqeiwcqlVpfXx+JRLxebzarC+TI1tYWlUqVSCQguPFS3q+++kqv10cikZMZfJ7APaharbam pobP55/3fQgaKrW3t1ut1jdv3jQ0NPB4PARBEomEUqnk8/mgNIAWS6fTq6urS0tLg8Ggz+fLZnUA D6zJZGpqasrZakqn01QqFc7W2trK5/NVKlVhC6ayBPQuvnnzZs4yE6zHy5cvy2QyEonU0NCgUqnO DlnXGQFsbdDFE3SabJ428EwqlcrMejpo4nvt2rX29naVSnUuVivsrdFo9NmzZxiG1dbWvq+R7fkC Njw8LBAIiERiMpnk8XgHptShKCoUCtva2ra2tqC0B9ic8CUH+z3sK1AOQKFQKBQKk8nMrRMpzLbM fJ/m5maz2ez3+084mkAmk3PjtIAISHt7+71791paWjgczvz8fFdX17Nnz4p6zIFAUZTNZhMIBK/X 6/F4shToMNkgTQwaNSeTSTabPTg4SKFQYM6cCx8YXqzudrsrKysFAsH5VWVAXLrd7u+++66hoaG8 vHxpaUkkEoGZhGGYUCjcL2RA729oaGCxWD6f75NPPtne3oYum/hhsHAIBAKVSoW/6XQ6lUplMpm5 DRXn9APjm8PhSKXSzc3NE5YzwKI+NDSUg72EoiiBQHjw4MGlS5c6Ojq0Wm0sFmOz2S9evGAwGMUo VSZAbyaTySwWKxaLeTyeYDCYpaoH70WhUFRXV0M+UyQSaWpq6uzs9Pv9Vqs1h0LgkwfMllgsBskk oJmdX1UGMhO2t7f/R6ZwuVwajabValOpFJvNPtDESSaTbW1tk5OTGIb19vZ2d3fz+XwikVhWVtbS 0tLU1ISi6NDQUE1NTUNDQ319vUAggMBz/s8I1IKGhgYEQdxuN8idPM/5QYCVMzIyQqVSs7f54Fco il6+fHlkZKS0tBT8BEwms7y8/He/+93JDP78AsOwubk5n8+X/V4C2gw4YKqqqpLJJNhPm5ubDx48 6Onp2draCoVCZzmlBijyxsbGjEYjm82GaO85clnvBxhUcsugAAAgAElEQVSsm5ubt27disfjv/rV rwgEAoVC4XK58Xhco9Fwudz9CwE8anw+n8fjvXz5sqWlpb29vb29HcMwUDL6+/tZLFZpaenAwEBV VVVTU1NVVRWDwSjImEGtodPpwDUcCoUKctpsLlpfXz8wMHCk+DWKogwGg0ajffHFF729veBbgp7z brf71atXLBarqMe8DyQSyePxzM/PH1UsYBi2sbEhkUhYLBaCIMFg8O3bt2Qy+ZNPPhGJRKurq2eZ Xg/cDT6f77vvvsMwjMViVVZWnmuvDCwfm82G/eVf/mVJSQl4zzgcDpQhHHhX8GE8HqdSqX6/3+l0 qlQqCoXS19eHoiiJRIJ67OMbMQSbUBR1uVzJZPKYFAK4EIPB+Pzzz4+UvwyuKbCNWltbBQIBsmtr AhHWr3/9awzDzumMOTEkk8nm5ma73e71eo+qzVgsFr/fX1NTA3a2wWDQ6XQCgcBoNMZisTPuCUun 01qt1uFwDAwM1NfXn+vscojayOXyzc3Nzz//PJFI6HS6L774Al4ogUDg8/mHLAQwncF6ttvtTqdT oVC0tbXJZDIQU3gQvOAjx51D5eXluMl+TGsWcona2tru3r3L4/Gy306SyaREIvnRj37U3Nzc1NQE TxVkOpFIXFhYmJycBIv0OIZ9AQBCns1mV1ZW5hAYIpFICoVCIBDweLx0Oh0MBpVKJZRHabXas2wy gV0dDAa3trZIJNLIyMi5TpQBT3YkEpmensaO1LggnU7zeDw+ny8QCPh8fnV1NZ6gcHzDxQEWm0Qi IZFIoM0U/LrA5SAQCO7fv7/nvjAM8/v9w8PDpaWlSqWSRqNlqjg0Gu1HP/pRT08PhUJBdtU+ZFcy bm5uPnnyhEwmF3a0FxIgZerq6jAMO5LOCgaH3W53OBxNTU0+n29qaorL5drt9vx7dx8rYOQ//PCD 0+mk0+kVFRVcLvdcu2QAJBLJaDRev349lUrNzs62tbVl014KlgyRSCwpKeFyuUKhUCAQQPe3EyPn BfNDKpX6/f5gMHgcsh6KIgcGBjo6OvYwO4Bg+fLLL00mUzAYxLdG3Dn9+eefQ/5i5k8gZ/zVq1fr 6+vFuNIHAeoylUqtq6vzer1H0llhwSqVSgaDIZPJlpeXdTodg8HY2dk5y/YS2HsOh+OHH36gUql0 Oj3/WuPTBbwveHFHU2VOHWB5sFiszs5OEolU2A6UBAIhEomUlZXdvn17jx4D/n8ikWi1Wn0+H5lM jsViqVSqrKzsRz/6UUdHR2trK0zizF9BLMloNI6Nje1RfYo4BCCyoZ+73W4/khYCuyCHw6HT6R6P Z3Nzk8lksliss6zKoCgaCAQgxYFKpUqlUjabfa5VGdwro1Kpbt++3draeiQf29kB0BWazeYjRTw/ CPDHXLt2raGhITOoBCoUg8GIx+N6vR7dZcFIJpODg4O3bt3q7OysrKxE/q+cwX84MTGxtbV1Kjzp 5xQgLsrKykwm01GzlGCSc7lcSHGzWq0ikQiiS2dz5YL2ZrPZzGYzHl0616pMplcmr8UJyunOzo7D 4WhtbYX2XeFwmEajHeu7BIOmoaGBTqdPTk6ihWjYhHd0GxwczCzIhLDR/fv3uVzugcbZ+yYukNJu bW2NjY2xWKyis/dIgOKXzs7OeDyuUCiylM4QGoAQ+CeffNLX1/fo0aO3b98ODQ2VlpaewLBzg9/v n5iYgITl3t7eysrK/dGlZDIZjUazPCGdTj+GYR4BoIwW0JkBBuXa2hqfzy8tLY3H40BQftwWAoqi kUjk7t2709PTGo2mIDY3zO0bN25UVFRk0vgC3/ro6Oj7nhvoK/s/B1Hz+PFjo9FY9MccFWBwXr9+ fWxsLBwOZ9mwEyYkWEr9/f2whDEMGxgYAMf8GQSKoltbW+/evYPuS8PDw8hBzX1jsVg2kRYQtqeb GIRm9FTJS5XBc/SgcBSaeq+trTGZzPr6egjCFWjMewEeFIlEMjIyMjs76/P5CnVaIpGYuWfE4/Ev v/ySyWQeVS7j7cjT6fSLFy+KptKRAP0rlpeXKRTK8PCwSqVyu91Z6qywj7rdbpApRCJxfHz87t27 JSUlZ40AHnbKly9fQgiMw+HgoWvYn3Q63fT09IG0+iBM8brQRCKxZ1+8ceMGk8nEMOyES4uhfEmv 10ej0UJdGqIn9fX1CILEYjEKhWKz2ba2tqqrq6VS6bF6sEDzGBgY4HK56+vrePPdPE9LJBLxqgiw oyorK0dHR3PIAgRRc+/evbGxMa1WWxQ1RwJ4+hcWFrq7uz0ej1arzSYMCsAwLBAIhEIhFEXJZLLD 4Xjz5s29e/fOGiMUrnjNzc3B9ABaBABMuampKaPR+L4OHrh7Ip1Ox2IxWHGQjyESicD+L1T2ffaA Uiy9Xk8mkwvpMo3FYouLiyaTKZVKQZXa5ORkSUlJd3f3cSwtdJc+5Nq1a/Pz806nM7erQE7utWvX 0um0wWDY4z7h8XhHNcXAeAqFQsFgkEQiFVsc5ADo6NbU1ASePyqVurCwkE3zFLAVIFFmZGQEpDy8 Yi6Xe3bkC94J5dGjRyiKArf18PAwRNxVKpVWq6VSqeFwGKJOmb8FlY7NZnd2dkokEnAi4gTZExMT gUAAw7DXr1/D8UQisbm5uaam5sRy2mKxWDQajcVisFXH4/ECtoGkUCgmk2llZcXlcvl8vng8TqPR Jicnr1+/nimgCwgwnBobGykUyurqKjCR5KbNJBKJzz777M2bN5FIBLeO4KY4HE5uw8OZC97X0KqI QwDi+vLly+l0uqKiAkVRlUoFpsXhrxhSbdbX1/l8PvhBQSvy+Xw0Gu2khv9hAMGxXC6fn59nMpmR SITL5V69etXj8USj0bm5uUgkAhRNB2ZzEggEiUTS29sLhU7Irp2pUqkWFxfJZLLH4/nuu+/gYA6H 093dzeVyT+bWoB4+Go3G43Gi1+uFrSJPQQN825cuXWKxWBqNRqVSsdlsoIjm8XjH1J4epg6FQhka GorH448fP85tMcM2AC5rEokUiUSgneRPf/pTkFk5hD9JJJJKpVpZWaHT6cfqoLqogJfi8XiglU8O EToURVksFszwN2/e3L59u7KyMhwOH8dojzqwdDqt0Wjm5uZAUYbNbGJiApiTFAoFtCuCaSMQCG7c uIE/AXgynZ2dZWVleKYFrAUymTwyMuLxeORyeTQaDYfDUJq+srKytrZWU1PT3Nx83JmJMDyNRuP3 +1EUpdFoSqXy9evXX375ZTQa3aOWHRVgMkkkEthFTCaTQqFobGzEMOzt27dAnXAcThqgr5BIJLW1 tUqlMkva+wMB7X8JBAKGYRAr7+rqunLlCpCA5ya+Xr165fP5gI2zKGpyg8PhgAaooMFkX7gK5hb4 Lfx+//j4+P379xEEOfWkAti2EonEq1evIDEZNrhgMPjf//3f0Bfl9evXuJmRTqc7Ozubm5vxzRoK faBIGZ9XYGfKZDKpVKrT6VQqFYIgwWAQRVGv1/vq1Ss6nd7Z2SkWi4/7BmEk29vbJBKJ+OLFi+rq aq1W29fXJ5PJ8ilHggfX1NTU1NQEn9TW1l65cgVBkDz5/j+IVCpFJBI/++yzR48eHYkUGOx1YNgc Hx9vb2+H2BuPx/vxj38MSsyRRgIPIRqNTk1NKZXKorM3Z8Ai5PP5Ozs7Wq2WwWB0dnaiKPr69ess EzDT6bTX64U3CEsRMglOt88tjGR7e3thYQGS1sGT9OTJExAH+JQDqz2dTmcSkuI3ArGbA1crl8sd Hh4OBoNLS0s2mw1OmEqltra2tra2ZDJZf3//8fnACQSCwWBAEARGCM5ts9n8+vVrCoXidDrv3r2b jzoFE4PFYl2+fBn/UCaTwR/HWuUE3taGhgYKhfLq1asj9dMGNeWzzz4bHx+32+0UCoVAIPh8vsHB wa6urkQikdszsdvtz549i0Qip8JQfJEgFouVSqXL5ZJKpQ0NDVtbW9lk6cFrjUajgUAAWk7CW2Cz 2R6P5xTrnEE4RCKR+fl5s9kMBYDQ/HV8fHyPWxHuAoJH+IDhw/eRT8K3NTU1VVVV0KETT8wIhULT 09NEIrG/v7+iouI45G16t422xWKh0+mxWIyAoqhWqyUQCJOTkwqF4ux44I8KmEMPHz6sra3N3v2b TqfpdDqDwUin07DJSaXSP/iDP8iZ7R7k7OvXr4t6TP6AUIVYLG5paYE09bdv32ZfSAKT+eXLl6FQ CLIrGhsba2pqTkuVAeGSTCY3NzffvXuHFzsQCITf//73e/QY/CcIgrDZ7Bx2KRqNduvWraqqqsxJ iKKoWq3+9ttvj887BSxtCIKAXQQLE7gMLBZLOBx+8uRJoZLbTh6QOlNeXv7gwQMgScsSKIqy2Wxo xkIgEAKBwOjoaEdHRyAQyHkwUFgL7OFFPSZPJJPJpqYmqGYaGxvT6XRZNkuHSJPZbH779i2NRovH 48Fg8Nq1a6dL2YKiKKgUFosFKLOpVKrBYBgfHz8wdgZDPZJ2juwKqIqKitu3b+8Jq6VSqZcvX87O zh7HE8Br6SUSCeQqEfGrUqnUubk5CoVSXV0dCATOafFwMpns6OgYGBh4+fKlXq8//MXgJZEikWht ba2tra2vry8QCJDJ5ByifZCn+d1335nNZhqNluUyKOJwwM5BIBCGh4eTyeTk5OQHRT8EOGg0GhyJ oij43k9XTQdXyvLy8rt37xgMBog5vB84TJU9Kw70AA6HMzw8jKf0gnrX3t4uEokO18kgw6O7u7uj o+Pdu3cajQaWA6TUPH36VCQSDQwM4CHwQoFEIj1+/DgSieB8m5n3hWFYLBZ7+fLlw4cPE4kEkUg8 d9swmCt0On1kZCQcDj969AjZVx29B3gcHFLo7ty5w2QyQ6EQi8XCvYZZXh2sYY/H89///d/g1Svm xxQE4KEXiUQtLS1qtXp1dfWDGTPQOyydTgeDQQzD4vG4z+djMpmnPp8xDHvy5AnE1kkkEnBYK5XK hYUFPGydCfiws7OzsbERkjvxSX7p0qVkMnnIHeGh7bt373o8njdv3oBuDUrF9va2Xq9vbm4Gc7RQ cxUq4S0Wy/Pnz9lsdjgc/t/zgqh98+bN+vo6NMQuyCVPHqCg3Lhxo6ur64MyGjKY1tbWoCUheNg4 HM6nn3561OkIzYMKVeBQBACERSwWs1gsqVTK6XSyWCwOh/M+0Q/Jj2w2u7W1dXZ2FtlVCE521Adj YmJicXERglzgqAiHw99+++37ZikMOx+jAt2lm+vp6YE+nXhiDYIgNpvtzZs3brc71xs6GNFoFNYR 3pV2zwGwQH77299CksE51fhBglOp1C+++ILP53/weLhrSPjFs2S6u7s7OzuPpI7AruNwOM7OxL4Y gKY9Vqs1HA4HAoFIJMLn8w8xhsHKamtrQ1F0dXX17PjgfT7f7373O7/fDzFH2NlXVlbep8cgu6IG mjHlc2kulzs0NESn0/G1D63NNjY23r17V1ilIplMQmEBhFD+j68epJ7dbl9ZWWGz2RKJ5JzydBF2 W/LS6fTV1VWwaA9c9nDLoIRCvDNnAhIwoPF+FkUpUxCAE6KkpAQiRKWlpa2trRsbG4c8Xkg9YbPZ LpeLSCTevHnT5/PFYjEmkzk5OYkgyElyb4Aq9vz5cyh0pFAooMeQyWS32/3s2bMDpwp82NjY2NXV FQ6HMzPYUqkUi8XKvgMc7LhMJlMgEOh0uj3XcrvdY2NjwGFdqGdiMpmyoVcGlgsqlVpeXs5gMM6p qIG3cOPGjfn5eZPJdGCmDv4JiUSC//r9fjKZnNv9gjOPy+VCdLIoZwoFsIKampog36CpqYnL5a6u rkLV8YHPGTrXRqNRm81WUVFRUlIClZLJZBKKek7M4whCLxgMPnr0CJYeXk/AYDDm5ua2trYO1GOg jPzatWsCgQAKD/GEXwzDcghtCwQCcJPg2dMQDFIoFDab7fr16/l374FdOxgMWq1WPMPs/6gy8C7F YnF9fT3kS55H4QKASofy8vK6ujqDwTAzM3OISgiuMGAUaG9vP+q14Ck9ffrUYrGgKArbVV6jL2If 0rtEqFDDfOAxoI+WlpY2Nzc/f/48M6sGJvPJi/5YLPbixQu3240HHCEN1mq1TkxM7BkPyJru7u6m piZw82ayNeYM8FNCw9fJyclMTQ4k4KtXr65evVpZWZnnvIWFoFKpshl2Op2ur6+HdNfz2wUGkE6n e3p6BgYGZmdntVrt4fdCJpPfvn07MDBw1E4mEMKGPN9EIlHM8z0mgKVBJpOTySQ4Mg/0LIZCoStX rvh8PoVCscc6OvmQH4FAAA6qzFkBdtSbN28MBsN+PQZF0QcPHuCemEI1IIrH47du3Xr69OnOzg5O oJdpvN28eTNPFkFQZXw+n0ajwSkN93plyGSyyWTi8/klJSXn1E7KBKQLlJeX37hxY2FhwePxHL74 MQyLRqMOh0MoFGYvJuDI0dHRb775xu12F7CXQhE4YNc3GAwmk+l9jxcmsMvlAu8L/iGHwwmFQlAV fwI5vzBUh8MxPT0NAUe8lgcEilwuVygU+4XLB928oKvdunVLKBQeie4PJG9dXR2TyZyens48P0Sd JycnI5FIfX19blMXfD9bW1sbGxup3d7vh58KRVGFQtHS0gJ7xnkXNeA+7O/v53A4m5ubH6RZwzDM 7XaLRCLQcbO5fZgwIpHoxo0b33333VEzNIvIHvF4fGVlBTxnB05jsH5XVlbgv+B4IJFILBYLOCBO IEMD5AmUEaysrFCp1D1UxZFIZHx83Ov1ZpZS46DT6YeE6aPRqFAovH79+lFpRVEUDYfDo6OjCwsL ma0607tMWmNjY9evXz9SyjwOOEkgEJidnTUajZl6216vDGwGZ7lN+VEBriYmk3nr1q1wODw/P2+z 2TK/haZODAYD2qxYrdYXL16MjIwclW7rvMviswzYJ3g83sOHD9fW1jQazYGHgXyhUCherzdTX0ml UhwOJ/ugTD7jTKfTRqNxZmYGBrCnvU4sFltbW4OaQVy4wK9GR0e5XC4UQxbEGbN/bNFoVCwWDw8P Q2oe/hVkjM3NzZFIJNwhdKSTw901NDQIBILp6elYLJbNGeh0embuznkHiJqqqqrGxka9Xi+XyyEb NPMYHo8HtFVEIvHdu3fBYLCvr++oM/NiPK6zCUhO6O7uLi8vl8vlTqfzwFYGIFKi0WhmKiu4zaAk +1gHmd4ljFleXt7e3qZSqftzzjwez+zsLFT34Knl6XSax+ONjo7iCspxaMPgQejt7SWRSBsbG3u+ Akd1pkMoe+BEDP39/VwuVy6X497uvXWtiURCIBAIhcILxlGLZ1kPDg4mk8lHjx6BtIXK+7a2NpfL tbKyotPp4vH48PDw2NjYH/7hHx5pRtpstgvgxzrLALtHKpVub28jBwl0WCd79lHYwm/evHmsjQtA GzCZTM+fP6fRaHvWDuz0kUhELpebTKZMPYZCody9exdSrD7o4wVL48WLF/s/l0gkTU1N+BkEAsF+ xzhohFwu99atW1NTU16vN/MMNBptZWUFw7Da2tqj+q6gFEsul0M6Tja/TafTFRUVZDK5UJ7tMwJ4 FGKx+PPPP9/a2nrz5g0QusP2c+XKlUePHiUSiRcvXty8eVOhUFCp1J6eHtgFDz8znkQJPVYvjLV5 1oDuMloJBIKdnZ0DA3lQ7oRk2Crobhuf4eHhY21cAOkvExMTarX6ffyrTqdzZmYGhoHnVFVVVV2+ fDkUCn1weCBnfD7fb37zmz1fYRjW3NxcUlICKbfQUHO/VxVPV6XRaHK5PLMaBv6YmJgYHBw8KqEl DMxqtcrlcmhNg9/7/6oyEJivq6vb0+TsggGsn4cPH757985kMmEY5nQ6vV4vj8djs9k+nw8OCAQC //7v//5Hf/RHKIqOjY319vby+fz3WU4wiV+8eBEKhchkciQSgRiqXC4vdncrFGASezyely9fHqlH cSKRuHnzJu7wKPioQEteXV1VKBR4Yu+eYyC+s7i4aLPZQI8hkUgcDodCofT390OVQTaXQ1EUOmns ybCJRCJms3lnZ2ePzKVSqQ0NDTKZDM9Gx+tubt68abfbp6en8YpTkOALCwuQ/HigNhOPx71eL5PJ BKb2UCjk8XgYDEY4HB4fH4fkjw8+ZHgg3d3dFyO0dCBAlFdXV7PZ7Pn5eWiuabVaJRKJSCQyGo3R aBTa1kxPT0cikatXr5rN5o2Njdu3bx/uoTEYDFNTU8DcSqFQBgcHJycnQ6FQln0Qi/ggQFd49+7d 6upqlgIc7KWSkpKhoaFj1WP8fv/09DSwS+zn+wCVZWdnZ3Z2Fq8hYrPZGIZVVVVlz7kPOgqHw9lz fgKB4Ha75XJ55klAdAgEgtbW1sxSvkxS4I2NjbW1tcwBe73e8fHxa9eusVis/cZMOp0Oh8PhcFgg EMB9ud3uSCTC4/GWlpY2NzfBoZs54dEvvvgC/iKRSJWVlfX19XglVZYP95wCtkYgdJfJZH19fTab bWFhwev1lpSU3L17FzyHN2/ehMYc7xMTYOn++te/vn379uzsrMvlKubKFBbwphwOx8zMzPsSft/3 Q6gu4fF4BX8jcHLoO2YwGN6Xg4lXMIEljVe38fn80dHRbBrXEQiE8vLyvr6+bESq2+2G5kSZPw+H w01NTUAdyWKxMs8Dggmvx8ZtuKampvb29j08EJAjrNFo1Gp1a2srnU6HrlhLS0sHvhcSiaTT6f72 b/8WQZCf//znVVVVsVgMQRAWi9XQ0CCVSj8G10J6tzfW27dv3W53b2+vTCZbXl7WarVer/fq1att bW0Oh6OiouL69etQO3PglAC3jVwu397e7unpefLkyTml/jrLgAi1XC5XKpXQZDGbJwxLTCqVXrly BayFwo4KViU4Wt5HzYJXMD158iRzYKlUqre3t76+/oNKDIqiJBKps7MzGxLRVCql1WohJwx/SvDv lStXgHUW163BRtLr9RsbGyABcNBotCtXrkDxVOZzA//6+vp6IBAYGBiwWCxsNluv16vV6ve9Fwzq GlKpVFlZWVNTE5PJ/Bj0GGQ3UYvP5/f09ITD4enpaT6f39DQYLfb3W63TqeDXoZbW1sNDQ2gnex/ LGDjOhyOqqoqaON3JIdBEdkA3S0nFovFLpcrSyJm8Hzcvn37OELXYCXEYrGFhQWj0Xi48goJnrAC 4/E4NHe8fPny+3yf8CGVSm1vbx8aGqqtrS0vL8/yFmg0WlVVVXNzs8PhwOmDoZXV9va2RqMJBoN8 Ph+fpTQajc/nWywWIDsBf0k4HGYwGNXV1ThdL/S4VqvVk5OTGo2GzWajKMrlcl0u15s3b94n8TEM 83q9d+/eRRDk6dOnXC43Ho+TSKT6+vqqqqqPQcggu/sQmMWNjY0KhWJjY6O7u5tEIgUCga2tLQRB 6urqLBaLz+err68/0CWT3qVLplAo0OkdmNlO44YuMsC/Xl5eTiKRXC5XNpwCuPsNWvQUdlaDEuDx eHw+3+Tk5OHjgRRgp9NJo9GA24nJZA4ODpaXlx+Se4eiKJ/PHxwc7O7urqmpYbPZ2SgAKIpyOJy2 tjaBQGA2m8E6AjXOaDRqNBqdTkcmk0FQwOyFbEWIhOADDgQCVVVVbDYbIlDxeBxBkHg8vrCwMDs7 6/P5BAJBNBotKyt7+/atVqs9JAiLfvHFF6lUqqWlpb6+HmgBPxIRcyCgUNbhcDx+/JjFYt2/fx9e TzAY/PzzzyUSCWxI+PFgl7vdbrFY/Pz5c/j7OHI2i0BRVK/Xv3379oNOL1A6pVJpf3//cUT33G73 1NQUtJMt4HYCGhuPxyORSLW1tTKZLE9yzEgkAgx4+BOD6QqSK7MeMhgMTk9Pu1wu6AWbSCQaGhrK ysp4PN7s7Gx9fT2Xy7VYLFar9UjZqZlemT//8z8vLy8nk8k9PT1isbi4DUMUY3Z2dm5urq+vr7+/ PxgMAk/JT37yk/3PB7RniF+/efOGTCbv7Ox8zLL6mACVhrOzszqd7vAaMdikcU9GYalsQS/Z2tpa Xl4uuJsfzi8QCEgkUk9PT57sISiKmkymqampTM80aHgdHR3Nzc34FfGSCKCIXF9fl8lkQqGwra1N r9c7HI7m5uZUKqXT6Xw+31HnNvrZZ599+umnTCbzgiXf5QyYnYFA4LvvviMSiQ8ePKBQKMlkEsMw n89348aNlpaW9/V+Q1HU6XSC4ctkMpeWlqanp0+mMO9CAvy9RqNxcXERHKQfVGIgHNPW1pZnB+ZM gK0GPHvT09PI8ZSQMJnMgYEBHo9XwFg7DDiT4AHd5SO/evUqh8PBj4xEIm/fvnU6nZFIJJVKQSof PE8Wi8Xlcg0GA5fLFYlEBoMB2nd/ULziqgyBQPjZz342NDQ0ODiYZbT+YwDey2JychI8cFBsAQ/2 pz/9KewxBzqDE4nEzs4OhmEikYhAIHz99ddOp/MiVZ6ePDAMW1pa0mg0WdrzZDK5paVFJpMVarWC 98Lr9aZSKb1ev76+XvB6e1jRFRUVfX19BdyVUBS12WyvX7/OXNqQw1dXV9fR0QHFSjC3rVbr27dv EQRxuVxsNhsnqiASiUABA/FWEokEtH5ZjgH74z/+Yy6XW1RicEDgiUwmNzY2+ny++fl5vCUThULZ 3t52u92lpaV4L8A9P6dQKDweb2ZmBtgeuVyu1+vNpw/wRwvQYzQazdLSEsRuD0lXAgW0oaFhYGBA KpUWJMwHkiUejysUisnJSYPBYDQajyMWjiBIb29vaWkpi8Uq7FTBMKy0tNTv93s8HtxmAkeuy+WC 7BlkNxuppKTE5/NBdAn3GCMIEo1GQbyWlZUZjUaIomazZYJc/uSTT2Kx2NLS0vDw8EUqvc4f4CST SCTl5eVKpVKlUpWUlEBPPhRFl5eXqVQqVKLt/y2BQGCz2UQi8b/+67/m5+cFAkEqlTrWhNOLDRRF 3717p9Vqs/E7slis3t7e7u7uoxJ2HD4An883PfYc2SsAACAASURBVD29srKi1+uBqbywTt94PC4U Cnt6eoB8pFBnhpPT6XSBQGA0GvFtEbQTh8MBZafgK0FRlMlkstlsi8VCJpNxcQcyPBgM+v1+GJ5a rT6SMER/+ctfFvCWLh4IBMLi4qLH4+nu7obsJOgtXlpaOjQ0xOVyD5n6kKmn1+sfP35cLGU6EvDq ZbVardFooL76fQubQqE0NTXJZLL8zX1QX5xOZzKZ1Ov1EJ09JksXriWVSkUi0fLycjwej0QiN27c qKqqKpTrIjM3GTr9AqOJUCgUi8W1tbX4reHNyNbW1tIFYsQnkUhGo/Fv/uZvOjo6/vM//1MgEBTd kwcivUvtuLCwwGaze3t7QVbg/Bzt7e2Hc8+AqHn27NnW1lZR1OQAt9u9vr7ucDje95BhUfD5/I6O jhyaDe8HnmcJnJmQ2Zb/aQ+8UCKRYDKZdXV10Wh0bW0NwzAKhfLgwQPkQzyWR4XT6QRaKQzDgLBN IBDIZDKxWIyHfcBZMDk56XA43pfkngMwvIKpiAORTqdLS0urqqpwZy/sQJFIZHV1VaVSCYVCJpN5 4G/xehCQU83NzTU1NTs7O1CUXyShOQQoikYikc3NTZPJlEqlcCdBMpn0eDxguabTaR6PNzQ01NHR wWazC7L3ezyeiYkJhUJhMpmAJTP/c+4HWEgCgeD27dszMzN43hyJRDIYDAwGo6SkpCABX5iBVCrV ZrPZ7XacgoLP57e3t2dueDAkqVQajUY/mMicJSAme/PmTbFYDP32iuGPAwHCnUKhVFVVSSQS/CmB qHE4HHNzc4FAQCwWH1J/EIvF2Gw21JT19vbSaDSfzycSiXJIO/h4AE/G6XSurq4GAgFc1YYk61gs RqPRILugurr61q1blZWV+Ueu4XVvb2+/evXKZDIZjcbjy+6A1Npr166VlJRMTk7iXa+TyaTBYKiq qiqsqUYkEre3tyE9Ge6ovr4e6F325JhWV1drNBrooV2YSxfkLBcSIDKuXr1aX1+/sLCwvr4ej8fx Fw/es0gk8vTpUwRBMAy7cuUKmUwWiUSZEWsURdlsdl9fX19fH3zS2NiYSCTm5+ehHsHtdmcylRWB oqjX641Go3q93mw2g8KHeywxDAPqArFY3NfXB3tzPkohiBWz2SyXy/HS6OOj6AAhQiKRLl26JBaL v/nmm2Mq3Yde4gsLCx0dHWazGUXRurq67e3tQ/r+oCgKZdsQUyvy4p8MwPUiFotv3rxJJBJfvnxp t9szDwAtR6vVAoFnWVkZNNPeU9dGJpPFYjGY2giC1NfXX7161W63Q5Et0I3sKYX9mAG+Cp/PFwwG t7a2PB5P5rfgUQDbtb29vaWlJRaL5bMccANYoVCo1WrwMR9r4gFINjqdPjo6qtPpFhYW9hAxFAqB QGBzc9NisfT29s7MzDQ2Nup0ug/6lZPJJFAi4R288xxGUZV5L2BXm56enpiY6Ovr+8lPfkImk9Vq 9fz8fCgU2qPMJpNJqEoNh8N9fX0CgUAkEu3s7Ljd7q6urj11T0QicWBgAP4Gz7DRaAQu+YI49s8d YNV5vd5IJDI/P59J14vrKKA7SqXSmpoaPF81t5UJQiQWi2k0GqVSCRWAmdc6JqC79HR1dXWpVOrR o0d79BjwRUFd4pHODKlCdrv96dOndDq9t7c3HA5D/3C8TQyCIO+z6fGrQ5gJcnsTiURut1nEkQCZ eR6P5ze/+Q2LxYIu5QiCvHnzZnt7OzPeAUvAZrONjY3BRBocHEylUlVVVdPT09A1Ys/xQqFwdHQU /y+BQJienlapVOe9f2fOALJKoJRcW1vbb0jAImWz2dXV1RUVFeCMz9lrAs/c5/Otr69bLBb8Eicg 5FOpFI/Ha2xsXFxcNBqNe8KO6XQ6FArlMAxIYZybm1taWmpsbKyrq9PpdFqtlkgkzszMIAiyubmJ ZNESPJ1Oc7lcoVAYDocLMhuLuTJZAXSUnp4ekUgkEAgCgcDCwgKKohaL5X3vDOQOlUqNxWIikWhk ZOR9Lwy0GZvNNj4+ntky42MA2EY6nU6hUOw3GUGs0Ol0Go1WWlra1taWT2IjaDDBYHBzc1Ov159B lwOBQAgGg1evXs2+EVJ6l8xeqVSura190L45vIQBz5JRKBTQoC6fp1TMlckBqVSKSCQODQ0hCFJV VTU/P+9yuXw+H3SIOyRdjEwmB4PBa9eu1dTU7LGdMk+OYdi7d+/W1tbwipLjvZ+zAZj2gUBgY2PD aDS+7xgul0skEtvb2yEHIM/91W63r66unk2nO8yEIzVCgmfo9/vfvXtns9kOdyfjpRjd3d1VVVXv q1QHRjen05m/c7rolckK4ONdW1vb2NiIRCJSqRRqWQOBwPT0NIqikO6QOfVhG4aGFz6fz2w2Q7yw oqJijwQh7Da8HRkZmZmZoVKp4XA4s+flBQNs2KFQyOl0arXazAJUAOg3YrEYQqr4SsjNNkJR1Gq1 EgiE1dVVh8NxKlzMOGcMi8XaHw5Lp9OXLl3K7KXyQbZNUJSdTqdcLqdQKHQ6fWNjI/9aXHDMUKnU kpISJpNZjEecPEAajI+Poyj6/PnzS5cu3bhxg0wmK5VKjUYTj8dtNtt+nSYajcbjcZAbDAbD7/dz OJySkpI9QgnYSnp7eykUisFgoFKpEOA+vtz2UwcerbZYLAcuPQzDgOgocw3mIGogUOh0OuPx+Pz8 /CkyDqAoKhKJ9rxTyKYqKSlpb2/PJOf8oB4DSglw+8pkMrPZXChG+3Q6zWazhUKhz+fL/2xFr0wu QHcbNQ8PD5eUlMBrSKVSs7OzW1tbH6QlQFE0Go1evnxZKBTG4/FkMsnhcPY4h5FdLXh2dtbtdsO+ BY12z6nQ8fv9gUAAwzCr1WowGDKLkuBOORwOJNn19vbS6fScM2DQXYpMaIRewCT53AaTSqWgelMk EuVv6oGto9PpOBwOg8HY3t7e3t72+/1ZToxsiCVgzGq1enFxMR+ZVfTK5A/YIFtbW3t6esBJRiAQ XC7X5ORkZnuKA4HucghBD10EQVKpFBAVZr5TmBLBYHBycpJEIkUiEbvdfk4jUHDLXq8XUlu2t7ed TueeoBuFQuFyueCD6erqynlJghoEdFN6vV6pVObpxcwTOKtWb29vQfxt0D3AZDLJZLJAIKBSqYxG Y5ZiOUuvDIIg0Wh0ZmbGarXm+fSKXplckN6l0Xv8+DH8fenSpfr6+itXrvT392MYtrW1tbi4+D4m Mai9XFxcxD8B3UggEHR3d+NLK5VK1dTU9Pf3Qwq91Wqdm5uz2WwFSZI6bqR3W89MT0/jLX6QXf8E FOmQyeRoNMrj8VpaWvaYQUdinYZreb1ev9/vdrvBeM28YqFuKgeA2jo4OFhaWnrUdtPvO2EikZBI JBQKZWZmRqlU7u+slicge6OkpITNZofD4UKdtogcAO9CpVJtbW3F43GJRNLf3y8UCu/fvw87zfz8 PDSm2T/PYa+NRqPPnz/HPwTdqL29XSKRgJ84kUgwGIyKioqRkRGYSKurq3K5HEpqz76oySSg2s/a wOVyga4pEok0NDSIxeJM3SUH7wuKojabLRaL6XQ6u92OX+vADtUnBhALVCoVKM4L8tYg1llVVRWN Rl+9egXVRoUVp2DmiUQit9uNFwjndqqiV6aQgH26paWlo6MDCoZNJtP8/Lzb7f54wtInBhRF7XZ7 LBYzGAxWq/UMPl7QY+7evVtSUlKQbvNgU37//fcOhyO3cFI2Xhk8LVqpVG5sbORcz1X0yhwfIEH7 8uXLwDabTCblcrlCoYD95gyuhfMLUBkdDkckEtna2goEAqc9or1AdxuS3Lt3ryA0iendBj7ff/99 bnImS68MiBq32720tPTB/JvDUfTKFBKwTygUis3NzVgsVl1dXVtb29/fL5FIvF7vwsKCXq8/7TGe Y4DI1mg0crkcOW13SzaIx+MPHjxgs9kF0WOQXd1oZGTk1atXVqv1qFIG3SXLqq2tLWoV5xoEAiEa jU5MTCAIkk6ne3t7eTze559/zmAwwD8BUemiTpMDYH8NBAJAvJtni6LjBpQ9lpWVjYyMFMTvi2Rk UNy7d29sbCyHonGQVNXV1YWiyPogiqrMsQAUUqPRCNny0NSmo6MDCvygiCAcDu/s7Hi93qLEeR8g cuT3+9Vqtclkwntin30lBlBZWVnYaCCEJsfHx4HvLjdrCeg0IF3gfcdA4Vh5efnq6mqx2fsZB4qi CwsLyO6Lq6+v7+7uptFoYrHY7/cvLCwQCITt7e3TTRo7+4D6ALVa7XA48IBd9gU+pwJ440wms6ys rICtoEHOuN3u8fHx3LYnPAErEokckgQD4qi0tJTL5ZrN5nwKF4pC6iQA1AJv3ryB/2IY1tnZyefz u7q6mExmMpnU6XQ6nY5Cofh8PovF8jH320NR1O12+3w+DMN2dnZMJtO5o0XGgzhdXV1EIrGAIgas pYGBgdevX2c2iTzS2IhEIpvNLmrPFw8w8dRqtVqtRhAklUoJBIK2tjYMwwYHBxEEiUajKysrQF+2 s7NzeIH3xQZsok6nMxqNplIpjUbj8Xhwbe9cCBzQY2g0WktLS21tbQGdHyiKxuNxNpt97dq1ly9f 5uaVgW6pJ5YKXVRlTgHJZBKsKKCrqaurq6urE4vFbDZbKpUiCJJIJN6+fZtKpaBWJRQKXWCJgycI T01NEQgEPP8LP+BciJVMQLpcd3c3FNae9nD+F/CofT7f8vLyrVu3DiHBw0NRXV1dq6urH7NufX4B q+n169fw31QqBSnD4XC4oqKCxWIhCGKxWNbX1xkMRjgc1mq1F/tFQ4KRSqVSKpWQorHnfs+XqIEg Tk1NTfY0VCcGoC9RqVRsNru5uRn40g48Eu6itrY2EAiAYyY3mVlUZU4T8L4NBoPBYNjzFYPBaGtr I5FIQqEQVqBCodBqtReATh6nqgsEAhaLZXNzcz/p7SkOLx+ANcNkMu/fv59MJo9D+0yn0zQaDVI7 j5rwD1JDLBaPjo7iXRqK+EhAIBDm5+fh77m5Ofzz8vLy0tLSWCwmlUphSszMzGQybp9roCjqcrmg jaLb7c4M+J7rG4TwTVdXV09Pz3HoMeDhg+KVnId37dq1xsbGk1GziqrMGUUwGAQe6Eyc8QS0QwBh I7CE+Hy+SqXa3Nyk0+ngebqoDqfjABTTDg4OTk1NGQyGC6DaFnG6MJlMJpNpz4fndJuHbOhAIICi qN/v5/F4eBUxcpy91S4ecFKi0dHRFy9enP1Eq6IqU0ThAcsACNfT6bTFYnG5XMlkUiQS0en09fX1 YDBY3INzBsiUgYEBDMMuhqOuiCJyA4qioVDIbrcnEolwOGwymfx+P5VKFYvFiUTi3bt3CIIca9fG iw0g5L158+bExEQOveFOEkVVpogCgEAgAEE4kUiMRqN2u91qtfr9/j2k6Q6HA/6+qNQXeN7P119/ XVNT09raSiQSj0PPgBKD6urqQCDg8XiK5mYRHwMgmRQoN8HvYrVabTZbZsYrhmHxePx9jZYuDKDr 9fr6usFgaG1tlclkx1TzjKIoh8Opq6tTqVSJROLMajNndFhFnAsQCIS3b9/abLa5uTmn05lIJBwO x/b29sbGRjAYPOMOyeMDtGprb2/X6XSHMHbnA0jKKSsrE4vFJ0PbUEQRpwLQ2p1O59zcnN1un56e RhDE4/E4HI7V1VWDwVDACsHzBUh9KysrE4lEKpXqmCL1cM76+nqgMz6zj7rolSniCAC+HL/fv7i4 KBaL19bWksmk1WpFEATac/B4PBRFz6zmfjIAu/C3v/3t/fv3qVRqYYvJMQxTq9XQVSAWi3V2dpJI pMXFRUg8Ovy3kHCdZQk3HAx1LkUUccIAr8Pa2hp0u9zc3KRQKJDTY7PZ0um0SCTKIfP9IiGVSjGZ zNXV1WAweOPGjQJm14J3ORgMms3muro6sM1GR0dfvXqVZS9JUECz9BZDXUueZdvYF198kfOPi/io AGzWNpvt8ePHsVhsZ2dnTy4Y5NxBY5dTHOdZADyWzc3NZDLJ5/MhzFQQhSaVSvH5/PHxcZvNVlpa imEYn8/v6OigUCh6vf5wOju8D7BEIsnGlkVRNBgM6vX63F4oNNu7efOmWCxeXV2l0+kf7a5TxJEA lCRTU1NyuTwSiUDFQOYBkCJzlp0EJwOwLT0ej1qtZjKZbDa7IKcFBZFMJieTye+//x7OjGFYVVVV Y2Oj2+32eDyHOIHg5zQaDWr+D7flcCKfnZ0dp9OZs2/pY99yijgcUJIXjUY3NzehYtzpdEKvQRRF m5qajikX5LwAAj1CoVAkEu0P9GAYBl0sNBqNSqUCRrJUKpXPE4N0gdHR0VQq9fXXX8/NzUG9Rk1N zc2bNw/vwALp2FnG/qDRoNfr/ch3iyJOEh6PZ3l5ORwOh0KhQCDA5/NpNBqHw6mpqSkGUlOplEwm o1AomV1HcA/K0tKSRqPZ2trSaDTQQT1PPohUKiUUCkdGRt69e/f48WOVSgWMWUNDQ3V1dUC0eOAP wcQNhULZZArjvMCHnDAbFFWZIj6MeDxeU1MDzkwajRaPx20222kP6qwAtJnu7u7h4eE9Pl7wgqhU quXl5aWlJZfLBfpBniUVwPI5PDw8NDRksVhmZ2cdDgeKoiUlJffu3ZNIJMhuhHsPQOoxGIyid6SI M4vu7m6j0Wi322k0mtfrBeLv0x7UmQDE7h88eFBWVpaZhIe3QF9aWlpZWYG4P/hC8lT+oILpiy++ kEqlKysrKysrsVgMQZCurq7BwUEIau+/BHhl6HT6SbZ9KAaYivgASCSS3W6HcKnX6xUIBAQCwePx 8Pn8YDAYDAa5XG4qlTp37QUKBeg853Q6KysrOzs7fT5fZukWOEJkMhmJRFpfX8cwrKGhYWNj4/Xr 1zwej8lk5nZR0Gb4fD6fz7fb7evr6wqFwmq1MhgMCoXS3t6eTCb9fv9+QYOiKI/HyybAhFeL2Gy2 3N5sMcBUxJGAoqjJZOJwOB6PB0VRkDCQEeJyuaCUJhwOf5xyBkEQAoHgdDojkUhvb69IJIK/cT0P OLpqampcLpdSqaysrORyuc+fPzcajSUlJZCJkvOjk0gkGIZpNJqNjY3Nzc1EIkEmk8vKyqqrq71e 757iBrgKkUgsKytjs9kf3BrA8b+zs+P3+3MuxiyqMkUcBtjPWCwWjUajUChg8bvdbuDQDIfDCIJA E5OPVr4gCIJhGJBbMBiM7u5uqVSqVCrxtQ0duHw+H9ROKxSKVCrl8/lEIhGHw8n5ovBqqFRqfX19 eXm5z+dzuVxms9nhcJBIpJ2dHT6fLxKJwuEwUIQBt155efm1a9eyqasqqjJFnDz4fD4oMQKBwO/3 RyKReDwOrFSpVKpIUQ3aTCAQKC8v7+/vj8fjBoMBEvnxBZtOpxsaGuRyeSAQgKTp0tLSPFUZBEH4 fH5rayuFQgGZYDQao9FoPB73+XyVlZV0Ot3n88H5oSHP1atXKysrs2nWXVRlijhRwFKh0Wg0Gm15 efkjz+0lEAihUGhwcLClpcXhcEASoslkWltb29raIhKJkB+HOz+gV0M4HA6Hw16vN5lM2u12EonE 5/PzGQa8FAqFIpPJysvLY7GY1+t1Op3xeNztdpeUlEQikXA4jGEYBMK4XG51dfUH0w5wghylUok3 JD8qiqpMEbkB5qpIJLLb7VqtlkqlfswzJ5lMUiiU+/fv02g0cJAHg8Ht7e2VlRWLxVJeXl5SUmKz 2fCUfxRFPR5PKpUCggy/3+/3+1ksFpPJzEebAVHD5XJra2vZbHYgEHC5XH6/H4wlkUgEYW5k9/VV V1dzudxsRA2ZTDaZTAaDIR9O4Y96NyoiT6TTaaFQ+HHys8EK1Gq1iUTi4cOHPT09mWlr6XQ6nU4/ fPiwt7eXRCKBQpNOp1OpFKS5QTlYQ0NDAWPJbDa7v7//3r17MpkMQRAMw7a2tnLufkwgEGKxmNVq /cjt4CJOHaCs8/n8j7PCABLsVCqVTCb76quvuFwunt0P/g+pVPrll19KpVL8+eC1BUAMUVpaKpFI CpU3TSAQpFLpyMjI0NAQm80GepvNzc2cTw4NbcCBlPNWUvTKFHEE4JOVQCCgKBoOh4PB4Nlvz3FM wDDM4/EAu7FYLJbJZAqFgkKhwLdOp3NjY4NMJt+6dQsYvYCPAW9u0tLSchysLSQSSSKRNDc3U6lU l8sVi8XAJQP7gVQqFYlE2SQ2EYnEUCikVqsPL/B+H6Aac3l5+erVq01NTYuLi8V04yKyBz4/oegv GAxGo9GPU86AFeR0OpPJpMViGRgY8Pl8IE9AmGg0Gr1eX19f393drVAocIMKRdFYLFZRUVFbWwtF zoV9gHQ6va6urqamJhqNQtYBfA7JwjKZDHqqZOOVgUTvbBhr3ociRV4RRwNkywuFQgzDRCKRUqk8 4705jg8QhdnZ2dnZ2dna2kIQZA9PHYqier1er9cjCJInAVQOY6uqqqqqqkokEgaDQaVSQRz6BC5N IBCUSmUqlbLZbA6Hw+/3X9Q+FUUcKyDhVyAQsFisQCCwvb390baeBW0AhAz8i8sTEMixWGx2dhY5 2YZTUHxAJpN7enqgQbdSqQT+5eO+NMjeQCCg0WjS6bRKpSqqMkUcATB3zWazVqstKSlBEEQoFNrt 9o+NOzyRSDQ3N1sslsOpot6HZDIJBs0JpDESiUSZTNbY2KjT6cxmM7TZ+6CdBInMJpPpg5IRz6pR q9UIgiiVSvxpUKlU5D1l4UUUcQggCAupWqFQqKSkBLLKPiqWI/C4MJnMioqKTF/Lkc4Qj8crKipE IlEBuYDfByh6uHTp0vLyMpFIpNFoH9RpQHpYrdZsGsmB/8ZgMHg8Hp/PZzabM7mei6pMEUcAiBip VFpRUZFKpZRKJYIgiUSiuroaCimhWOZi717JZPKTTz7x+XxGozEH6YD3lPl//+//tbS01NbWHvfj IhAI8XhcIBDw+fz8CxlwALW8RqOZmZkhEAgfZx5DEccB2KKAVoBEIrndbrVaDQunrq7OZrO5XK6L XTUJmlxFRcXAwMDKykpuQhVW6MzMzPb2dkdHR0lJyQnQDKZSqdraWuhaUFhR8/z5c7vdnilqMp9J UZUpIi+AWq3VaoFQn0KheL3eC58IjGFYeXl5VVXV9PS0Wq0+UogXN7ZqamoikYhSqayrq4NE4GMa LdDAq9XqYDDY39+fjX0Glds2m81ut799+3b/t5cuXaqurg4Gg1KplMPhaLVacPPCAbAVlZeXO51O Ho9X5GktIk+AERWLxTY2NhAEEQqFbrf7wnNZQcJZV1dXa2vrDz/8cDiX935ArkxlZaVQKAQ7UyqV HvdixDBsaWmpubm5pKTkgwMGB7DD4fD5fHK53GAw7DGKOBzO8PAwiUQKhULXr1/X6XR+v9/lcgFD BMhMIpFYX19fVGWKyBFAtkahUDweTzweJxKJXq8XQZAL7JUBnsCHDx9SqVTwnVZXV0MKXvZhJli9 4XBYLpczGIxPP/0Uyp2Ob9hg4dXU1CAIkg3NAz5Cq9VaVlZ2YGUAiqKRSIRCoVRUVBCJRBKJRCaT W1tbM48hkUhGo1EgECQSiY8zm6qI/AHMb2KxmEQiuVwuMJMcDgeSkRp8wQBEDzU1NYODg8CkgGFY S0vLysrKkUL50KFpZ2dHo9F0dHSA7XHcKzGRSFy5cgVBkCx1JiKR6HQ6g8FgX19fb2/vgcckk0k2 m11VVcVms3d2dpqbm/cLzKIqU8TRALaRy+USiURut1sgELS0tGxsbIRCoQvvjAFA+gikDQkEgp6e HrlcbrFYjpp+D+rC7373O5lMhmFYIpFoaGhgMpnZ25pgdYErvlBPHvSYYDBot9sP0Urx5lxms7m1 tfUnP/mJ3W4HXRYHkUgUiUQn49Yu4oIB3L3QXzCVSgEpXDKZVKvVH4lajKIoiBpYa9XV1RiGyeXy WCx2pCcAZGAbGxtWq1UikUSjUQaD0djYeKSIMPRUolAoBbRUQdTYbLZQKHT4aYFl1Gq19vb2UqlU i8UCGl7mT9Bf/vKXBRlWER8JYAuH0rt0Os3n8/1+v1wuFwgELpfLZDIVcFs9U0gmk1Qq9e7du5kO GBC4Ho9nZWXFbDbnU2EBmsH169crKiqAnR3MUIfDUV1dLZfLCQSCWq2urKyEfnLw/B0OR1lZWVdX 1/uaseG1jiiKAofeB12+FArFaDRqNJqWlhYOhwPVnnCnCoUiGAzu0VnT6bRUKr1y5coelQXoIh4+ fIggyLfffsvj8U6gtKGIiwHY5wKBQCgUQlGUQqEwmUytVqvX68vLy6HN0IXUj8El09TU1N/fv78h gMFgkMvl4XA4H7sxmUwymcx79+4huwxYFApFoVCAA9VoNAaDQbfbndnCMx6PO53OgYEBPp9/iAxB UXR7e7u8vDybgk247vz8PJlMrq2tZTAYdrvdYrHQaDRgRd9/jwQCobe3t6amZr93ueiVKeJoABNB IBDgn7BYrOvXr5vN5mwKXs4pMgl1Mj+HDR7unUKh5JP6Co70yclJKJmOx+PQFhiEF2RbEwgEnU6X SakpEonS6fQPP/wQj8ebm5ulUinEfTJHHo/HxWIxkp3LF+4IGELFYnEgECAQCLW1tfBtVVUVeK2h eiuVSpnNZrfbbTAYdnZ2Ll26VFpamllWUEQRuQGYkOh0Op1Oxz+srq6urKzc3Ny82BMMCGD2L9V0 Or25ubnfIXFUgD/4m2++IRKJ0D27vLzc4/EsLi4iCCIQCCgUCpSP4VdJpVLV1dUajWZ6eprD4bS1 tdHp9Hg8vsdwTafT1dXVcHw2twnlSw0NDRwOJxAIcDgcvJcLHq2GRt9QshSPx6empvR6fWdnJ4PB yEwrLnpliigAUBSFzU+tVucQajn7wLsdxWKx5uZmDMNA89DpdGtra/m0Dik4gAePQCCAK4XP53M4 HJlMxuVysyzDDofDwF3R3d19OC8Z6ElehuNu5AAAIABJREFUr9dqtSoUCgzD2Gz28PAw+I2KXpki Cgu8zZDX611bWztqqOXsAye143K5dDq9trYWakKTyeTa2tr29vaZqtvi8XilpaVer9dgMLBYLB6P x+fzIRCWjTCERn5KpbK2trasrOyDoiYQCPj9fpVKZbVawZHT09ODO66KXpkiCoB0Os1gMLhcLtA7 2u32s7O1FwrpdDoQCOh0umg0SiKR9Hp9NBqFVXSmMp2j0ShQvCAIgqIopLAIBAKBQJCNVwaEaWlp qVgs/iC/KthVQqFQIBAIhcLJyUmfz/fy5cuhoSFo+FKwuyqiiF13BTSbRBBkfX39QrI/QIM2v98f DAZ9Pp/JZMok8D3dsWXC7Xa73W5kt59uKBSKRCIymSxL4Q+iprOzk06nZxP4ptPpDAZDJBLJ5fLN zU21Wh2Px/v7++G3xcYFReQLMOV9Pp9Go7FarcFg8EJaS6lUCtJavV6v2+3OzTyC6IzX65XL5aFQ CMJDxzDe/wGMsK+vr6qqKptu2Ol0mkqlms1mp9N51LpNJpMpEokMBkMsFlMoFAiCCASCWCxWX1+P oqhSqaTRaBdsyynihAGxS5vNptFo3G43dE057UEVGKAWhMPhZDIJTbBzU18gSU6j0WxubtJoNA6H c6zZRdCs4Pr165Cmnc3xJBJpfX2dxWKxWKxsxoYH1sViMeH/s3dmTW2kWd7PTGWm9l1ikQRi3xcD xuDdlO1yVbsWV0d0RHXPREz0J5iribmc6I8wl3M3FxMxddE9U/2Wy+Uql8srNjYYDGZHgFglgfZ9 y8z34rTVHtuFBUhCwPldVEBZUiapJ0/+n7NSlMPhCIVCNptNp9PJZDL0yiD7JTMx2+12r6+vSySS vHZJOdRAREan09XU1Dx69Gh6epqiKKvVSpJkY2OjVCrNbasMkCZZbpIyKcxer3dvs4gNBsONGzde vHixvr4+MTEhCEJJSQl2z0NyBXhlaJpeWlqCCv+i8lIUFTDlsb6+3uPxPHr0iCAItVptNBqlUmlD Q0PO7QxJklKplMi6uzdJkk6nc89Dbzo7Oy0Wy8jIiM/ne/78eVdXF3plkH0B2n92dhaiLeFwOJlM yuVyhUIBpQcHfYJFB+ws4Qb2er2CIICfdmFhwev1wg4jJ/snkE01NTWQOiN8aJicIAgKhWJ4eDiZ TJ49e3bPLSiUSuXGxkY6nfb5fOvr6729vUqlcmZmBr0yyJ4BnR2Px2EhRaPRRCIB3RAIgtht77jj AwyRDQaD8XgcmmhsbW3ZbDae5w0GQ66OAi4WmI+b5RchEol++umn7u7ukpKSPbT+g78LWsyTJLm+ vo5SBtkXUJtdXl7u8XjkcrnJZFIqlbA6g8HgUS1o2ifQxFMikSwtLb15D0cikeXl5enpaZfLJZfL 9+kThnLu1tZWnU6XZe0SwzButxt6Ge/58SCRSOLxeDAYpChqc3Ozr6/PZDJNTk7KZDKUMsjegA0A y7J6vX5jYwNqd0tLSxUKRSAQgIyZgz7HogOMM3RG9nq9GWc5z/Nut3t2dnZ+fj4SiRgMBpZl95lQ rNPp2tvbs7/BIUJkMplgVNNuDw3GCiZKRiIRzJVBcgBoZKVSubCwEI/H29vb5XK53+/3eDxoX95L ZlfR0NDAMMz29vZbL0gkEqurq9ClOxwOG43GvRkaqVRaUVGRjZsHQoSvXr3a2NhQKpUejycej2u1 2j0cl+f50tJSvV4fCAQcDseVK1dKS0tRyiD7B9yZNE2PjY1ZLJaqqiqSJF0uF9QnH/TZFSMwf81k Mlkslmg0+lbmjSAIwWBwfn7e5/N5PB6WZVUq1W6FBbh7tVqt2WzO5vWgSgcHB8Hpu729LZFIoF4k ++OCCWVZ1mKxMAyztbWFuTJIbqBpurW1NRqN2my2ra0tcMngo2sHwGdeVVU1PT391oWCXyORSCQS IQhiZmYG7tiWlpbsryrDMKdPn965pdWbUBQViUTgwSAWi81m88bGhsvl6u7u3lURNVgZo9HY29vr cDiw1S+SWzQaTU9PTywWGx8f93q9H+wVe8zJ5OeVlZU5HI632j7Bz06nkyRJu92u0Wg0Go1er6+p qcnSbgiCUFZWdubMmSzvdHiNx+MBz71MJlMqlWtra3K5vK6uLpvJKm8eWiQS1dTUsCyLUgbJDeCY SSaTi4uLKpWqt7f3yZMn6XT6oM+rqIFbsauri+O4mZkZKH5+1yhzHLeyskIQxNLSkslkEovFtbW1 SqVyh9w9nudbW1uzHIOQGeoGDXI4jguHw3Nzc/Cvy8vLBEHIZDKpVOr3+zmOS6fTFoulvb1dqVQS r+NiWq3WZDK92QcZpuPiMwbJOWq1GlqS9Pf3BwKBzFpF3gtJkul02mAwdHd3Q2uWd+0M/Or3+/1+ v91un5mZKSkpkcvlDQ0Nv3YLg0hSq9UtLS1Z5hHDPsfhcIAvJ5FIJBKJzMDakZERmqYVCgWcCXxg W1tbTU0NeONWV1cDgYDFYnmzSxZkHKOUQXIDLGu9Xt/b2wuFM2KxGKXMzsD9XFFRQRDEwsJCIpHY +fU8z8MIgsXFRYPBoFQqzWZzeXn5u/snnudLSkpYls1mawUdxJ8+fbqxsSGTyd5bcAR9I+BnlmUX FxdLSkpSqZTD4Whra4P52GDyKIqy2+1+v397e3tra+vo9UtEDhxBEGpra0UiUVlZWTwehyZyWDj5 a0DSjEwmU6vVDocjM8F+B6LRqN1uJwhienq6oqJCLBY3NjZCSs2bL+M4TiwWl5SUZD+nNh6PP3v2 jHinc3rmPKHnRcZqvXz50mq1zs3NlZeXG41GrVYrl8vT6TRN03CSwWBwfX0dpQySM9Lp9MLCwvb2 djKZ9Pl8GL3OHkEQPvvss59++ikz3GrnFxME4Xa73W43uEykUmltbW1TU1PGx2swGKAlcTZHh6Fu H2yIDns7i8UCRWrr6+tutzuZTD579qy/v39lZQXc1BRFra+vJ5NJiUSCnn8kH4RCobm5uWQyOTEx AbWTOC7jg8Bu02QyXb169c6dO1m+SxCE1dVVgiAWFhZEIpFare7s7DQYDDDIViKR6HS6LNNcKIpK p9PvBrneBfJgTCYTZPA8efJEpVI9f/68o6OjpKRkZmYmGAyyLBuNRjc3N2maJkkSBxcgOQakdzKZ nJ+fn5mZwRBDNkA+o8fjGR0dhdS8vV00uP87Ozs///xz8Ip90MRAwu+dO3ccDsfe2sn8GgzDrK+v /+lPf+ro6Pjmm2/0ej0OLkByCJgan8/38uVL9P9lCXg+lpeXX716tZ8PUSqVVqv10qVLZ86cydIl w7JsIBC4desWjJnLLeiVQXJDpsEa1EZC4gW6fLMEQsgGg6G3t3dsbAzixHu4dJBJp1Ao4O1ZbpVc LheWsyKHiEyDNTA4705rR36NTKosTdMvX77c20WD0qdUKpX9fBKKohKJhNPpzFMj+CPVXR45QCD6 oFarDQaDIAjRaBSkzEGf16EBLqDRaIRc2t1W/cDrGYa5cuXKlStXdtU+fGRkxO/3MwyDDwPkUABV M9Ad2+/3ZzOUA8kAPmCTybS30kK41JWVlV999VVHR0dmFN3OR2QYJhgMjoyM5GnLhF8/kjPAtSCR SNLp9Pb2tsFgqKqqwqb12UNRVDKZ7Orq+v3vfw8z7rO87TMNxAYGBvr7++GLyPKNUC+NTwLkcCEI glKp9Hq98Xi8uro6y2mpCADa4vPPP//d7363q70TzCEpLy//5JNPampqPjhxlnitnGKx2NbWVv7s DAaYkJwBt4fH43E4HAqFQq1Wh8NhuVwei8UO+tQOE1CjWFlZGQgEgsGgxWKZnJzcOd4E/6RWq6uq qvR6ffZjUEiSHB0dffDggcvlEgRBo9HI5XIoqjKbzfhsQIoWyC6HBpIEQXAcJ5VKccXuCvAE9/T0 PH/+3Gw2h0IhyNz/oKkpLS2trKyUy+VZDqllGMbr9T569GhsbCwcDhMEUVZWRpIk9JKBiqR9fnEo ZZCcATeGRqO5ePGi0+mEJpJoWXYFJOHOz8/zPH/69OlEIpFMJpVKpUwmu3v37nvfAvsktVp9/fr1 5ubm7INEgiA4nU6Ygw2JNdBVgiCI9fX1zMughpN4Pfy2trZWJpPldhwdguwWnudrampMJtPy8vLy 8jKUZOOa3BUURY2OjjY0NHz66acEQWxtbbW1tTkcjqmpqfdOgYX/2dHRce3aNejFkGXPqlgstra2 5nQ6MzUNTqcTXmCz2eAHkUikUqnAttA0XVpaarVas7dmKGWQHAMPxcrKSo1G8+LFi1gslulHgnwQ SI6zWq0EQUCbGZZlS0tLCYK4ceNGKpVaW1sTi8UGgyGdTr98+XJ7e7uiosJisYhEIqVSaTQas9yY UhTFcdzw8PDU1FQqlSJ+faTtmx1lQKG+9QKWZY1G47v9zsVisd1udzgcJ0+exDgjkg9Ylu3s7JRK pTabLZlMZhPvQDLwPH/ixAmCIKC0EGZz1tfX19fXQ18og8GgUCjcbvfIyAhJkm1tbXK5XKPRaLVa hUKRpUuGZVmn0zk4OLixsUH8up3hOA4G68KvGxsbo6OjmX8FAaTRaH6t7SdKGSRfQMYG6pgcQpJk dXU13NUymay9vR1mw9rt9t///vcnTpzIvnc4z/Obm5ubm5ter3efZ5VMJsFIvYVEIiEIIhKJYHcZ JK9Akhnkn+JK2z/Qul2j0cCv5eXl/f39MplsdHS0qakJpqplqWNEIlEkEllbW3O5XNFodM9tJt5s RvzeF2CuH5JjIESysrJy//79a9eunTt3jvh1JY7sCmgGRbxuDqFWq+VyudVqvXbtWk1NTfa9wwVB 2NraGhoaGhoawl4vyCEFnrg//fRTJBL53e9+V1tbi6VMOYGiqLcKDoxGo0Qi6evru3jxolqtzjK0 RJIkjLK5f/++3W7Pq9BErwySYyiKisfjFRUVRqNxbm4uH92QEAA2PSzLgss3y0ZVNE2Hw+HJyUk0 +sihhqKocDh85coVh8ORSblA8gRN0zRNGwwGiUSSZeGSRCJZWlpaXV0Vi8V5P718HwA5VkBv7FAo RBCEXC4XiUTPnj2DtuIHfWpHEPDNtLa2njhxIhqNZiNN4C0QkxaJRF988QVJkl6vN51OJxKJ+fn5 YDCIPeCR4ockyWg0GolEWJZVqVSvXr1aXFyUSqWYlZUnaJq+ePGiVqvNMiEJCrB9Pp/X67VarVar FQbakCTpdrvn5uZya2RQyiC5BDb9Go1GIpFsbm5OTEz89re//fbbb7PsPItkD1iKurq6+vr6eDye zeWFsZEul+vhw4eZGQWCIGi1WvihsrIyHA6HQiGxWBwMBpeXl6VSqUwmwy0vUmwIgiCVSsVisUql +vHHH/V6/cDAwE8//aRSqVDN5Bye57u7u38t5fa9r5fL5YODg/Pz83K5HL4Rmqahct5gMDQ3N3s8 nnQ6zbLs2tqa2+02GAzhcNjlcu1tK4VSBskLMA8smUx+9913tbW1y8vL71a4IHsGdExLS0traytE oLPcJyUSCa/X+17/DeQCy2QymUxGEIRGo6msrBQEIZFItLW1eTwegiACgYBYLNZoNJOTkw6H470V m0B5ebnf75dKpTU1NZjBgOSPdDqt0+nGxsYsFktTU9Py8jIOY8ohYFvOnz9vNBqzFBnQE8/v98OE 2l97jU6ng581Gg1k1YAJCgQCPM+Hw2GtVsvz/NOnT3fI52MYxmAwOBwOlDJIXuA4TiKRNDc3u1yu xcVFYved+JEdgBJHrVYrlUqzSZHJsLi4ODo6KpFIsm8HDIVIUKip1WqVSuXt27flcvmNGzeCwWA0 GlWpVIIg3LlzR6FQlJSUtLe3BwIBeAvIHfTJIXkCItqlpaVNTU3b29vb29uoY3KOXC7X6XQ77Fve Ar6UZ8+eOZ1OsVic/QQV+Bk8NyaTKZFI3Lx58/z58yqVKhwOx2KxioqKiYmJhYUFvV4PXYW2t7cV CkVfXx9KGSTHwKL0+/3Ly8sKhQKai+PDLIfAlTx79mxFRcWudMz09PTExMR+8gkoiopEIufPn4df VSqVSqWCn2/cuJF5GZRxYmUskldA0NtsNtDToVAIsvSQXAGtXAYGBrKfhUIQRCKRePz4sdfrFYvF e7YAHMfRNJ2xKlqtVqvVQmogDHUBSkpK4Af0+iJ5AabANzY2trW1HfS5HCmgQGxXOobnebFYvLa2 trCwkOUmCUEOC5CB0dXVZbFYIEhx0Gd0FIDW7TKZ7MqVK8RuummIRKKXL18Gg8ECj6dFrwySY+Ae kMvlSqUyGo1OTU3J5XKO4xKJBO7R9wlElM+cOWMwGJLJZJb+GFA/Xq83FothiQdyZIBAhslkYll2 aWlpc3NTp9OBqUFBsx/gwqpUqrNnz+6271QoFPL5fBzHFVjKoFcGyRc8zzMMc+LEia6urlQqha3Y 9g/HceCP2VWSP8/zIyMjs7OzqGOQowfoe6PReObMmYqKinA4nOU8eeS9wPXU6/UXLlyQy+W7em8w GPzll18ikQhN0wXeuKJXBskx4JXhOE4sFodCIZvNZrfbGxsbNRrNxMREKBQqsFo/GkCy0cDAgE6n EwQhywsInZdHR0fX1tayT/VFkEMBzJAXiUQURTmdzsnJSY7jzp07Fw6HJyYm0M7sAfDgms3m/v7+ XVUdUhSVTqeHh4dTqdSBSEmUMkiOgUo8lmXD4bDT6ezp6Tlx4sTNmzcTiYRUKmVZFquy94ZcLlep VNn7Y0DHDA0NLS8vYwYucvSACgOWZVdWViiKunHjxuzs7IMHD2CSfDKZPOgTPHxAA3GYUB2LxbLs VkXTdCwWu3fvXpZvyQcoZZDcA44ZhUJhtVofP37scrk+//zzxcXFUCi0tbWVTqfxyZolELSWy+UZ Z2/2nhWKonw+n9/v5zgOBzoiRxJwzFit1s3Nzf/6r/8ym81ff/316Ogox3EbGxu4ZcoeaFXV2NjY 2dkJVzX7VDyO49xuN0yLzPd5/hooZZC8AA3yGYZpb29XKBSRSGRpaSkcDjMMgzome8DFJZPJVCrV bpONotHo4OCg3+/HThvIEYaiqFQqZTQau7u70+n05uamzWaTSCSoY3ZFxh8jlUqznIJCvJ5Nu76+ PjQ0dLARPZQySB4hSRJax967d4/n+cLngh12OI4rLy+/ePHibqtMQ6HQ48ePo9Eo6hjkyAORJpVK NT4+7na7M0M5kCwBP3p/f39dXd1udczy8vLIyMiB2xmUMkgeAaVfV1dnt9sxRSZ7wNlbUVHR19cH m87sLx288sWLF/F4HONKyHEA4rA6na6iosLhcOCWKXsgltTX11dVVSUIQvYzRiAVb2NjY2Ji4sB1 DIFSBikAMIiH4zie5x0OBwzmOPClX7SAjqmpqenp6dnt6CKoI/jll19CoRAKR+RYQVGUTqdraGiA moPNzU28BXYGJODZs2ctFsuuDDLomOXl5efPn+9t+mPOQSmD5BHImJmamlpaWkqn0+Xl5SaTyel0 hsNh3Dm9F7hi7e3tzc3NuzLERVJHgCCFBwJMbrd7YmLC5XLJZLLy8nKz2by5uYkjU3aAYZizZ88a DIbd6hiZTDY3Nzc6Olo8iY8oZZA8wvN8Op1uamo6ceLErVu3Njc3ITUMvTLvJROxrq2t3W05QGao bCQSwTHUyLECRr6LxeKBgQGXy3Xnzp10Og21fqhj3osgCDKZ7OrVqzRN77bdFPSe8fv9yWRSKpUW iSVHk4fkEZIkWZZlGCadTl+7dk2r1eKQlF8DtMiFCxdqamqyz7x78+0bGxsPHjzAVqfIcQN2RxKJ BKZkX716FWcX7ADP8yqV6pNPPhGJRLvVMdCfc3h4uNi6h6NXBikENE3funUrFAoVQ4JYEZJOpy9e vFhaWsrzfPYdHTKQJGm32589e7afUbQIcqjJJKLevXu3qJ6yRUJmIsHFixf3FhgSBIHn+aGhofX1 9WK7wuiVQfKLIAjRaDQcDldVVUkkEqxjei8ikUgmk+0t7kaS5Pz8/NDQENagIscWSDLz+/00TVdX V6fT6YM+oyKFZVmpVLq396bT6UePHm1sbBThFBT0yiD5BVrLCILQ3NzMMMzs7CwWCWeAXjvXr19n GIbn+V0VXWeYnJycnJwstk0SghQSyPylaVqhUJw4cYKiqLW1Ndw1ARRFRaPR+vr6s2fPRqPRvUX5 4/H4o0eP/H5/cbp+Ucog+QVK9e7duwfpqDi1IAPHcUql8pNPPgG37d4+5OXLl3Nzc6hjkGMORJdW V1eHhoZw0NubQHOHzs7O7u7uPdcERKPRBw8eFHPLTZQySH6BdX/mzBmbzba8vMxx3DGvr4GeVEaj 8fz584lEYm8SBJLvRkZGlpeXUccgCBQxlZaWnjt3bnZ2dmtrC6UMOGN6e3utVivHcdm3v3uLYDD4 4MEDGHldnDqGQCmD5BVBECBoIpfLNzc3jUZjMBgMhULHs6kMbI+qq6v7+vp4nidJkqZpgiBEItEX X3zxyy+/bG9vf9B5y/O8RCJ58uTJysqKSCQSi8WoY5BjDnQxSKVSCoVCEASv12u1WldWVo6tmoEM 33PnzlksFpjdxjBMPB5vbm5ubGz8n//5Hwj67/AJELCLRCK//PJLIpEgCKLIt6AoZZA8AsXY8LNI JHK5XCKRqJilfZ6ATgzd3d3Nzc2JRAKGRKZSKaVS+eWXX3777bd/+ctfKIr6oPNWEASxWHznzp3t 7e2DHd6GIMUDFGNTr0mlUk6ncw+VxkcAaJV5+fJlhULB8zzHcSKRKBAInD9/Xq/Xf/fdd3a7/YPN YARBYFnW6/XeuXPnsDR3QCmDFAKe5xsaGgKBwNraWiKROFZeGYqiIpHI+fPn3xzVBhYnHo//5S9/ SaVSWe54aJr+4YcfAoHAsbqACJIlHMfJ5fL29nYwNcfNK8PzPMMwn3322ZsyDq7JxMQESZLZVB5B 1tHm5ua9e/cO0X6pqF1GyGGHoiiO4169epVMJgmCWFxcLCkpaW1tlUqlmJdHvA7AZfNKkiSj0ejN mzeDweBh2SchSGEAL4LL5VpYWGAYJhAIOByO9vZ2i8VSJBOCDhaoVE+n0x80ubDFmp2dvXfvXtFm +L4X9MoghUAkEkHnt7W1NYqieJ4/hmGmPUOSpN/vv3fvHkSmDvp0EKRIgbsjlUql0+np6WnIjsct U5aAjpmcnBwfH5fJZIcrPIdSBskj0DelpaVlbm6O47gvvvhicHBwY2NDKpUWsocVzD+7d++ey+Wq r69vbW0t2KGhiODKlSsWi2W34whgr+nxeO7evQtvRKOMIO8CVYFms9nj8YyPj1ut1p6enu+++45l WZ7nC7ZlglTZcDh8+/ZtgiDOnTtnNBoLc3SYcS2Xy69fv87z/G5VCM/zcrl8eHh4enpaIpEUYQe8 D4JSBsk70Mo2Ho9/++23ly5dgjiuRCKZn58vQINaEARDQ0NbW1sEQSwuLi4sLNTU1PT19eVv8iLs BT/++GNIviMIYrfjCDJd2O/fvw8WOR/niSBHCZZllUrl5ubmzMzM559/fuvWrba2toWFhWg0mu+w LOiYUCj05MkT+D+Dg4OCIAwMDBiNxjzNhIKiyMrKyvPnzyeTSXB47/ZDYKf36NGjpaWlw1sRiVIG yS+gVCorKyGYfffu3cws1kJ2jUyn03AsnucpilpaWgoEAv39/fmQMpB8d+3atT3bBTCLU1NTIyMj h87TiyCFB9JBpFJpc3Oz1+u9e/fujz/+SBDE5OQkQRAFSy8TBCHjb4Zw8L1799rb2+vq6nJu6zI9 fPv7+/cwuC1zkgRB3L59e2trqzjb+GYJShmkEFAUNTMzEw6HCYIo/IOZoqhQKES8bj0MJ+D1er// /nuNRnP16tWczOuGXg5arfbq1avQNmYPdgE8vWNjY+Pj41Kp9DB6ehHkQIBUj1AoNDs7SxAE9FMp JCCnYrFY5t6Hm3dqaurVq1cdHR2tra058QRDUeTJkydbW1vj8Xj2JZDvfs6PP/4IlQSHK8n3XVDK IIVAEIS6urra2lqWZRcXF6enp8Hle4A3D8SA/H7/X//6148++kgikezn08DTazabL1++HIvF9mBZ wM17//59u90uk8kOr6cXQQ4EUBISiaS3t7evry+dTr98+XJtbQ32FQd4YuAJnpiYCAQCPT09+yze BB1z4cKF2tra3abfEW+0gbh58yZBECRJHo2KSJQySCEQiUS3bt0KhUKZRgUFm8RE0/SDBw8CgQDx 2puaAX5NJpOQpnfp0iWdTrcHAQGe3pqamosXL+5t1wX2Bdy8OIgAQfZAJr3s7t27b95EBdAxmQz9 wcFB4h07Q7x2z6ytra2srBgMhrNnz+7txMDUXL161Ww270HHEARB0zT0voNW40eGI/XHIEULx3FX r16VyWQ///wzVDAV4dP6wYMHgiBcvHixtLQ0+zQ92CS1tLT09/fvTcdwHPfjjz/GYjGapg+7mxdB DgoYw6TX6//hH/4hHA5///33xeZvAKPn8Xj++te/yuXyTz/9dFeFnCRJxuPx3/zmNwaDYbcDlUBs 2e32x48fS6XSI6ZjCJQySMGAcsHKyspwOByJRArZrzYYDBKvE2V2eBn866NHj3ie7+7ubmpq8ng8 1dXV/f39NE0Hg8Fbt27lxASAWfH5fD/88ENGu2CjHQTZPyRJQt59bW2t3W4vTF+ZzCgSSL/deZ8G t3kkEvnzn/9MUdRnn33GMEwsFjt79qzZbJZKpS9evBgfH5fL5fvf73Ecp1AohoeHX716BR94VCPX KGWQAgFVOaurq4FAoDBeGdAu9+/fj8VixPu8vu99/ccffzw1NQUVT2Kx2Ol0/vWvf00mk2q1+uuv v06n0yKR6Pvvv+/p6TGZTODjBVmWTYoMiJjl5eXHjx/LZLJD1BccQQ4FGVWxuLgoEokKoGOgtcTG xsbQ0BCRRVkD2BmVSnXp0qWff/7lg34MAAAgAElEQVQZ+vixLDs8PPzixYtIJNLT0/PHP/6R47jV 1dVXr16B8yadTjMMA5+QTZkC2NvBwcH19XWpVFqcjvAcglIGKQQikejHH3+EXJki3BZQFPXRRx/J 5XKZTPbtt9+2tLQ0NDRkokVgFKLR6J///GfidaUSOFFomv6gsweKkh49emSz2TKV1ViahCC55a1c mWKLLoG3pry8vK+vj6Zpj8fz3XffffXVV5maSuL1nzA9PT09PQ12JpO9l9ExOx8ilUrdvHmT47jM tqoI7W0+QCmDFIJ0Ov3pp5/abLbZ2dl4PF7IYAok/GYDVCFdu3aNIIgdXCygbB4+fLjbM0H5giD5 A+bPl5aWfvXVVxMTE4UcJ0lRVDKZTKfT2TSpg1C7Wq3+8ssvd3hxpufe//7v/+7hfHb7lsMOShnk mALeFJlMNjAwADsejPUgCJJzQN/U1dW1t7dD5BonkOQclDJIISBJMp1Ot7S0bG5uhkKhAuT8gq/1 4cOHb9UIgFkpKyvr7e0tNhc0giD7AeyMTCZra2tbWVkpwA0OIaHl5eUXL14Q/zdRBjZLPT09lZWV YO722VEG2YFj54ZCDorMyDeVSpXNuPn9H04QhEx0CTyuvb29paWlFRUVly9fRpuCIEcPqGAiSbKq qoooiKsVAltvpqeIRKKBgQGSJC9fvlxTU4Nh5QKAXhmkEEA10O3bt91ut1gszmt/PMjGjcViT58+ zfxPsG7Dw8MNDQ3Nzc35GySJIMhBAXbG7Xbfvn1bLBYTee6PB7VLCwsL09PTxBuyieO4R48enT17 VqlUplIp3DUVAJQySCGgafqHH36IRCKFSX2FFuY+ny/zqyAInZ2dsFFDEOTokemecP/+fYVCkUwm C3BQkUgUDodTqZRIJIKpT3K5vL+/X6lUFuDoSAaUMkgh4DhuYGBALBb/8ssvm5ub+WtyAGn/wWAQ ejwA/f39ZWVlmNWLIEeYzDzX3/3ud8Fg8Pbt23nNlQGXzPT09MLCAuydVCrV2bNnwRuEFBiUMkgh gKDPwsJCYXJ+E4lEMBikafr8+fNqtZrA6iQEOQZkZiXOzc0VJoIcDAY5jjObzd3d3VhGcIBgugBS CGDDVFNTo1Qq85fzC00zvV7vkydPFArFl19+CToGQZDjAFQwMQxTX1+f10A2uGQmJyeXl5ebm5sv XLiACTEHC3plkEJAkuTS0tL8/HwymcxTugwYF6fT+fjxY4lE0t/fD6FrBEGOA+CSCYfDExMTm5ub +fORQFLO2NjYwsJCdXV1fX19LBZDKXOwoJRBCoRUKs1f4RJ0d1hdXX369KlKpTp9+rRUKs3HgRAE KVoEQRCJRBKJBCYx5cPaQDbe8PCw3W6HckhoVYVS5mBBKYMUCBjEmCf7AjVKW1tbcrn8woULR2+E PYIgHwTsAMdxNE3nL8CUSqUcDkdTU1NTUxMcEXXMgYO5Mkgh4Hm+srIS/tvW1iaTyXLY+BL2Sc+f Pw8GgwMDAwVIK0YQpNiAMiKZTFZeXs7zfGdnZ2Vl5Qenve6WdDp9586d5ubmjI7J4YcjewalDFII kskkTdMcx5lMplAo5PF4GIbJiRWAAPmjR49Ylr169SqULeAmCUGOGyBlwPtL03Rpaena2loOQz8k SUYikZ9//vn8+fN1dXWCIKCOKR7QD4/kF9i4rKyspFIpiqKePn0qEoly0lcG6pVGR0cXFxd7enrq 6+vD4TD28EWQYwhsaYLB4OrqaiKRSCaTP/30E5GLXQ18cjQaffToUTqd/vjjjxmGKcDoFWRXoJRB 8osgCMlksqKiYnFxEUqKcuWMYVn24cOHpaWlX375JYxBQR2DIMcTiqISiYREIikvL5+Zmclh8Jpl WY/HMzY2durUKZVKRfzfmZFIkYCmH8k7LMsqFIqNjY1EIpGrCkmO477//nuTyVRTU5PXiU4IghQ/ kHurUCh4nl9fX8+JnYEkvKWlpaGhod7eXtAxSHGCUgYpBDzPNzQ0SKXSfWb7UhSVSqUGBwe3t7ev Xr1asOG3CIIUOdAfT6lU1tXVpdPp/XwUNKlaX18fHBzU6/XXrl3D5g5FDgaYkEJAUdT8/HwsFttP ti9FUU6nc2Ji4urVqwRBYNodgiAZIKklFArZbLb9ZOOBM2ZwcJBhmIGBgXA4jOXWxQ9KGaQQ8Dzf 3Nw8OTkZi8V2WywN4ert7W2n09ne3m40GlHBIAjyFuCVUalUjY2NS0tLIpFot4YC2vhOTU2p1erT p08nEoloNIoZeIcClDJIfoEKprGxsZWVFZ7n92BfSJJMpVIajUaj0aRSKdweIQjyFrDhcbvdo6Oj fr9/D3aGeD0qrr6+niCIZDKJpuYQgVIGySOQ2vLw4cNAIEBguxcEQfIAzC2x2+3Dw8PQSAYdt8cN lDJIHgE3zMDAAEmSc3NzME5ybxsmBEGQ9wKV2GVlZV999VVmnCRunI4VGAVE8gsYlMXFxbm5uWQy WZjCaRgmp9Fo1Gq1RqOhaToSiVy9erWmpiaVSpWXl+v1erPZ/NVXX12+fJnjOLVarVQqb9y4oVKp UqmUIAgSiUSj0YjFYuwhgSDFD+T8RiKRqamp9fX1giW48DwvFosh/K1QKJLJpEwm+/LLL0mSlEql FotFqVSeOHHiD3/4Q21tLUEQcrm8qanp448/jsfjYBuVSqVKpcKOEvsEvTJIIUgkEjm/UQVBUKlU JEmGw2GRSCSXyxOJhNls1mq1T58+LS0tbWtrU6lUIpHo+fPnFy5cMBqNLperpKTEaDRWVlbKZDKH wzE9Pf2HP/whFosNDw//9a9/lcvlarW6tbXVYrE8f/7c5/OVlJTE4/FYLAb9/RAEKU4g7TeRSOTW HwMiSalUJpPJaDQqk8lYlk0kEl1dXSsrK2tra9XV1TU1NQqFwuVy2e32vr6+WCxmNpvT6XR1dbVW q1UoFI8fP1Yqlf/0T/9ks9lGR0cXFhYMBoNYLO7t7U2lUg8ePJBIJGKxOBaL5cNUHgfI//zP/zzo c0D+DxRFJZPJR48enTt3TiKRHOonqCAI8Xg8mUw+fPgQBhfs6r1SqRQahKtUqmAwKBaLOzs7XS5X e3s7SZKjo6MNDQ3gR9mn8YK3P336tKOjQ6FQMAwzMTExNTV15syZdDo9PT3d39//7NmzaDSqVCpj sVgqldrP4Y4JDMOsr6//6U9/6ujo+Oabb/R6/aFezEcMnuflcvnMzIzb7T5//nwkEjm8pTqQrgsD UkZHR/dQiS2TyaLRqEKhEIvFW1tbLS0tUqmUJMmWlpa1tbWNjY3u7u79JwJDhdTGxsbq6urp06dT qRTP8w8fPozFYteuXbt3715FRQVN0xMTEwzDiMViqAPfzxGPDyhlihqe52Uy2YMHDywWi9ls9nq9 crlcIpEU8/qGvVEymQyHwwsLCy6XK5v7H/yxDMMkEonGxkar1XqAKTUURUUikUQiQRCERCJZWVmx 2+1ffvllPB4XBOH+/funT58Wi8Ucx0ml0hcvXszMzGg0GpFIFAgEWJZVqVQcxwWDwSwPp1KpQqFQ DufeFQkoZQ4LmejM06dPL126FIlEeJ5XKBRFntZGkmQ8Huc4zul02mw28M7ufMLwl8rl8nQ6LRaL Ozo6dDrdwf6NwWBQEARQlg8ePLBarZ2dnRzHLS0tbWxsXLhwIRQKicXiZDL5yy+/hMNhrVYbi8Xi 8bhCoZBKpbFYLBsZCk3/WJYNBoOHV7PuAAaYihoYLdTX10cQBM/z5eXlq6urk5OTUqlUqVSaTCZB EAwGw4Fn7INNSSQSHo9neXnZ5/Nlmse8+3iGAbYKhQI8HAaDoaen590dzwH+RRD/1mq1s7OzPp+v u7u7trY2Ho8TBEGS5JUrV27evHn69Gm48gqFwmQyBYNBtVr9xRdfBIPB7e1tcCD39fWpVKrvvvsO uvmFw2GCIORyOcuyPp+PIAiWZU+dOqXX63/88cc9dNxBkJwAt6REIhkYGCBeL9GRkRGv1yuVSsvK ypRKJcMwGo1mn926c0I0Go3FYpubm3a7/U1f73vTTQRB0Ov1DMNEo9GOjg6z2fzWsLYDv+NUKhXD MI8fP7ZarVeuXBEEIRaL8TxfV1cnEolu3rz52WefJRIJhmG0Wq1Sqdzc3Lxw4UJlZaXf77fb7aur q83Nzb29vRsbGz///HNZWdn29jZBEDzP63S6aDSaTCaTyaTFYunr63O5XA8fPpTJZEcvBRC9Moce kiSHhobi8TjDMPF4vLKy0mg0QoKtVCqVy+U5vFch+OX1esEWkCS5sbGRmXr95isFQYD8FbFYTLzu DdPb26tWq49PbxjwJz969KimpqaystLlchEEUVJS4nA4nj9/DgaLYZjr16/D5RobG4tGoyzLrq6u njhxQiqVzszM9PX1ff/992+64kiSVKvVDMMEAoHsh2hCwSrDMLvdlkGr07Nnz7548SISiWSvt9Ar c2SAlexyucbGxjJR76amJlAPIpEItE6uTA18ZjAYhA51sKNbXl52uVzvLl3oKKNQKGiaJggilUqp VKpTp04dKzvDMIzf75+YmDh//jzP8263W6VSKRSKly9fLiwsgDxqbGzs7+8HIQhhuHg87nK5bty4 8fDhw7q6ulAoND4+DnOs4JNBv6ZSqUAgkL3bmOd5tVqdSCR2NeIX9sNVVVVms3lwcHC3wQeUMkcK qNxJJpNLS0sOhyNjXOLxOLgEBEHQaDT19fXgYt1haYLxGhsbc7lcYrF4h1UF8p9lWUEQoNtmbW1t kWzgigTwHo+OjlIUdeLEiUgkwjCM1+udnp4+derUzZs3T548WVFRAdJEKpVKpdKMYqAoamtr6+HD h3q9PhgMwlPk008/nZycdDqdMpkMzJZEIvF4PG8ZDrApyWQyFouJRCKO48RisUwmC4fDGVXBsiwU be1w/mKxWKlU+ny+ndfMW6CUOfIEAoG5uTlYXQRB8DwfiUTAfykSiUwmU3V19QcfSCKRKB6PP336 dOfHHsSGMvEgnufNZrPVamVZFk1NBrgOjx8/7urqUqlUyWRSIpGMjo5CkdT4+PjVq1dpmvb5fBDT z8yWgss7MjKyurqqVqt9Pp8gCGVlZf39/f/v//0/nU4XDAbj8bjRaIzH45FI5M1YXkbOQv8wgiB4 nlepVIIgRKPRjB0TiUQ75xuRJKlUKimKyuyWd/GHo5Q5VoBAefHihdvtBvGR/Xsht06n0508eRJb YeaQdDoNG0oArjNBECzLEgSRSqX8fr9KpeJ5fmxsbHt7Ox6Pd3V1VVdX22w2p9MZDodLSkr6+/un p6dfvXolkUjOnz+v1+uHhoZsNtvly5fLy8vHx8cXFxdZloVgOZRLsCyr0Wg6Ojru3LmTSqXMZjPL suFwOBgMptPpsrIytVr97Nmz3a6TDChlji3wXIzFYkNDQ3vIzKAoKhaLtbW1VVRU7Gpnj/waEEOE 7+XN2zkej7MsCzrD7/en02mNRuNyuSYmJoLBoFwu7+/vZxjm1atXyWTS4/GcPXtWo9EMDw/b7fa6 urozZ84EAoH79+/TNH39+vVAIPDy5cvt7W21Wh2Px9PptFQqBbNTV1cnlUp/+OGHiooKtVpNkqTP 54vH4zzPNzU1ORyOpaWl/UzOQimDIIcGkiRDodCbPhvQppubmy6X6+TJk36//9mzZxqNpq2tjaZp nuchc3xycnJhYaGiokIQhGAw2NLSEo/HdTpdIpFQKpXRaDQejy8uLtbV1XEcB86blZWVlpaWV69e ra6ukiRJ03RPT8/KyorT6YSDplIpmUwml8vhlNxu91uPHJQyCHIYgXyARCKhUCjedL2IxeKXL1/q 9fq6urrJycnFxcWGhoaqqiqI5cHm9tGjR8lk0mq1OhwOo9EICYWgUWQyWSAQCIfDGxsbp06dmpub q6+vn56eNhgMLMu+fPnS7/eTJFleXm61WsfHx6HwQiwWx+PxsrKyaDQKfp1QKPRumFt048aNwl8p BEH2BmyhMr/CZksmk5WUlECJeHV1dWlpaSYTHArKNBpNe3t7IpHY3t7u6emhaXptbc1sNi8tLWk0 GrlcznFcPB6Xy+UWiyWdTlMUVVlZOTc3Z7PZKIoSi8XXrl3T6/Uw5sZqtZaUlIRCoUAgIBKJTp06 ZbFY5ubm3vQtEQQB6Q4DAwOlpaWTk5MymezAUywRBMkGiqLAK5wBTI3RaITNj0qlqqurA2/xmx76 ioqKpqYmm80GGyqXy8XzPMuyDoejvLxcJBIlEgmO4wwGQ1lZmcfjsVgsEPnyeDwkSdbU1Fy4cIGm adi2dXR0cBwXi8W8Xm9ZWdm5c+fi8fjGxsa7OQ9YwYQghxhBEOx2ezqdbm1tTSQSb4mJDNDZ3WQy mUwm+D8dHR0EQTQ3NxMEwXGcXC6Hn6HIExIJq6qqXC6XQqE4derUxsZGKBTS6/UqlcpgMNTU1JAk OTY2JpPJfD7f8PDwzglVCIIcahKJxMzMTHV1tcFg2GHQFcTHe3p6CIJIp9NWqxX+f319PRSjlJSU lJSUEATBcZxer+d53mAwVFRURKPRtrY2s9k8Pj7OMIxcLlcqlRUVFSaT6dmzZ2tra1qt9smTJysr K3K5/N04FAaYEAT5MG63W6vVchyXSqVevny5tLTU1tbGMMzU1NSvRbgxwIQgSPZQFAUFVjqdLhaL BQKBp0+fptPpkydP2mw2v9+/Q5UcemUQBPkbUIkQi8VsNhtBEF1dXZk28AaDgSAIkUjEMMzAwIDF YmFZFrL2DvikEQQ5hJAk6fV65+fna2trTSZTIpGAPn5Qhi2RSKRS6Y0bNyYnJ0tKSpaXl3c2NShl EAT5GyRJQnvA1tZWgiDerFODWVdarfbu3buhUEir1fr9/lgstp+iAwRBji2CIGi1WmgAmzE1kHEs CALHcbdu3SopKUmn00tLSxzH7VxKiUVuCIJ8GEEQ5HJ5PB6/evWqyWTyeDw9PT1dXV3QxOygzw5B kKMAlIszDAMDxqEn59WrV7Va7c4dQNArgyBItkA9lNlsbmxsTCaTk5OTmO2LIEjOgXavHR0d5eXl CwsL4XD412oaANxOIQiSFdBYYmRkZGRkhOM4r9f7ZkdpBEGQ/QMZe/F4/O7duysrKyRJrqysQEfp HUwNemUQBMkKkiQTiURPT8/29jZ0emAY5qBPCkGQI0VmuOnly5edTqfT6Xx3xt+7oFcGQZBsgQCT Xq9XKpXpdPqgTwdBkKMJTLEtLy9/78Dzd0GvDIIgWUGSZCAQsNlsFotlY2NjeXlZJpNh+RKCIDkE vDIOh2N7e7uqqurZs2fJZHLn6BKBUgZBkCyBFsAWi2VqasrtdmMZNoIg+YAkSZVKFY/H79+/D/m/ H3wLShkEQX4Vj8eztrZ24sQJr9crlUoHBwd9Ph/LspjtiyBIrhAEYX5+XiKRVFZW+v3+ZDL54MED GAK1QwH2m2CuDIIgfwfKB6LRqN/vFwTB6/UGg8HV1VWGYZLJpFqtFovF6IxBEGT/iEQij8eTTCaj 0WgwGHS5XF6vl2XZVCql0+l2tVlCrwyCIH8nM2o7FApNTEwoFAqYSWuz2cRisdvtTqVSNE2jSwZB kH3CcZxGo5mbmxOLxel0OhKJeL3eSCRCEITf7xeJRNl/FHplEAR5D+Xl5c3NzQzDdHZ2Tk9PazQa 6Cb+axNxEQRBdgtFUe3t7RqNprKyUqlUrqyslJSUxGKxLONKGdArgyDI34Cu4YFAwOl0EgQhkUiS yeTExARFUePj4zzP6/X6SCQSj8dxWAGCIPuBoqjNzc1gMEhRlEKhWF9fX1lZkUgkz549YxhGr9d7 vd7sBQ3aIwRB/g5IGY7j2tvby8rK3kyLoSjK5/Mlk0nUMQiC7AeoS9ra2iopKWltbZXL5el0OjNR Mp1O+3y+XTlm0CuDIMjfgH6+5eXlUql0dXX17t27MpkMhQuCILkF9EpbW5tcLn/w4MHS0pJMJmMY Zs8lBWikEAT5W2jJ6/X6fD6VSrW4uPjzzz9jBzwEQXIL+FocDkcqlZLL5T/99FNOmm2ilEEQhCBJ MplMWiwWh8PxH//xH8lk8re//a1EIjno80IQ5EgBRQMWi+Xu3bv//d//3dvb29fXJwgCTCrY88ei lEEQhEgmk6Ojo0tLSzCTNhKJZDn6BEEQJBtAqXg8nqGhIcj2DYVCqVRqPwomA+bKIMhxh+d5tVod j8enp6dZllWr1UtLS4uLiwd9XgiCHB14nqdpWqlUOp1OaLkpl8vv3r0L/7rPLg/olUGQY40gCCzL Tk5OQuljrjZJCIIgGSAbLx6Pj42NEQSRSqX2GVF6C/TKIMixhiRJt9tts9koiorFYolE4oNDaBEE QXYFRVGpVGptbW1zc1Mul7tcrtxKGfTKIMixhqIop9OZSqWSySS6ZBAEyTnQRSaZTELvzWg0mvPN EnplEOSYEg6Hg8GgTqdbW1uLxWIsy6IzBkGQHJLpdycSiZLJ5Pr6ulgszoedQSmDIMcLCFpHo9E7 d+6Ul5e/ePEinU4zDIM6BkGQHMLzvEKhGBsbm5ubMxqNm5ubedIxBEHgZDgEQRAEQQ4xGBdHkL8D BYEGg6Gjo0On0+Uqd4TnealUOjw8vLS0RFHUMWmhK5FI4vH4N998QxDE119/Db8e9EkhSLFAUVRt bW1LS0sOeziRJMlx3A8//AC26/i4KjDtF0H+Btz5paWl3d3dOdQxBEFQFBWPx7u7uwcGBnQ6HfG6 WxSCIMcTkUjU0NDQ1taWW8EBCbafffZZV1cXwzDEsTE1mCuDIP+HpqYmjUaTSCRyawIg/U2lUl24 cCEYDE5NTTkcjmO1bUIQhHi9ZZJIJG1tbel0Oh+HEAShsrKyqqpqbW1teno6Go0eeVODXhkE+RuC IJhMJplMxnFcng4B7l+dTtfQ0JCnQyAIUrSApGAYprq6Oq+BZjA19fX1er2eOAa+GZQyCPJ3ampq pFIpx3H5u/NJkkwkEnq9/vr161arNU9HQRCkaJFKpdXV1fnbMgEURUWj0b6+vvPnzyuVSuJICxqU Mgjyd6RSaQF63ZIkyfO8RCKpr6/P64EQBClCRCKRTCYrwIFg4n15eXl5eTmBUgZBjgOVlZUsy+Z7 q5RBEASpVFpbW3uE7QuCIBkguiQWi61Wa56yZN57UJ7ny8rKdDodz/NH1dqglEGQv1FTUyMWiwt2 t/M8D1UMR9W4IAjyJnCnK5VKkDKFufFhRmxJSUlFRQVxdB0zR7yCCVSwVqu1Wq0kSVZUVFAURRAE RVHff/89VKkc7bxuJHtkMhmsh4Ld7SRJQsEkctiBlVNXVyeVSrVarV6v5zhOKpWur68PDg4en2ZC yAcRiURSqRSqigpzREEQRCIRTR/lx/3R/NvArBiNxubmZmjjgSA7QFHURx99JBaL85HwC+Hq6upq s9lst9vX19dx2tFRgiTJurq6uro6iUSS+Vrx+0XeAuRseXl5f39/LBaDTXVugaYyra2tNE1PT0/H YjGapo/JUjxqUgZEjNlsbmxsVKlUx+RbRPZPnrwjUERw+fJlk8kkEolCoZDdbs8MIhEEIZVK5eO4 SAGgabqpqamqqgr2u2htkA8C3pF8tK1KpVJyufz69es8z9M0vbCwEIlEMv/KcVzBsnMOhKMmZcDH 29TUBPmb7y4X0DrT09PwCEHrg1AU1djYyLJs4Y+bSqWmpqYw9HC4yLQ46+joMJvN77UhgiCwLOvx eBYWFgi0M8ceyL1VqVRWq7XAubewFJ1Op91uJ47uUjw6UoYkydbW1traWphn8WvLBZaU3W7H5wcC zySapuvq6vKUNQV2ZH5+nmVZi8XyZgACtkqrq6s5PyiSJ2CRKJXKzs5Oo9HIcdyvrRlYV8FgcGtr CxNlkMxwN7PZHI/Hcx5dgmyYVCr16tWrlpaWN60ZLEWv1xsIBEQiUcEqNAvMUZAyNE3X19dXV1fD xvqoqk4kt8DdLpPJBgYGRCJRno4CJgZmFGxtbblcLoZhMpnFGF06LMBqUavVzc3NJSUlsCM6qsUg SG4BLdvQ0NDe3p5IJPKRJUO8jiLZbDaO42iaTiaTmRZZmejSEX44HmIpA8ZFo9EMDAxkb1bglb/5 zW+wguk4k2kfXldXBwXY730ZTLTe2Nh4/PgxQRAURVVXV8M0pYaGBoVCkc1uG3ZFW1tbW1tbBEHQ NM3zPMuyPp/v559/xhVY/MCjqLOzs6GhIZlMZmNqIEequrqaYRisYDrOgOrV6XQmk2mHlcPzvEwm e/z48fr6OkEQarW6vLw8FospFIrsG2mCMVlaWoJfKYriOE6hUAwPD9tstqO9CA+llMnsp5uamkwm UyGrZ5EjQKZRVWtra3V19Q4NHmCidUlJyWeffTY3N7ewsLC4uAj/ZLfbM05jhUJhNBqrqqqyfM4R BCEIwtHOwjsawFdcVlbW2NioVqtzOCwdOQ5kamk7Ozs1Gs0O64eiqFgs1tfXV1dXNzEx4fV6g8Eg bHKmpqbgNVarFRL75HJ5lm1pwFVzhBVMhsMnZUBawuJQqVRHNfKH5AkwLgqFor293WQyfdAiwKZK JBJ1dHQ0NDT88MMPGbsAhsbtdns8HrvdPj4+3tTU1NDQsPMDD7JnNjc3BwcH0SVT5AiC0NLSUltb yzDMcXgeIDkE7m6LxdLW1iaXyz+og0F2qFSqa9euTU9Pj4+Pv+VHWVlZIUlyeXlZq9V2dXXp9fqd 904wHeXJkyfr6+tH2yVDHC4pk1G4TU1NWq2WeB0t2tunQXoEPkiOFZmMh/b29tLS0uwbboKVYVn2 iy++WF9fJ0ny1atX8XgcPhBWUTKZnJiYmJmZKS8vpyjqxIkTOygVXHhFDkmSjY2NVVVVEomEIIg9 PwbQi3NsEQShqqqqpaVFKpVmb2ogNFlXV1dSUuL1emOx2PT0dMaSwH/9fv8vv/yi1+ulUqnRaKyv r/+1VOKMdTryHBopU11drScK4fsAACAASURBVFarwZmfkw/MU+4VUsxkQkLl5eV7yL8DowCFSBaL xev1jo6OhkKhNyVLKpWCoiS73X79+nWJRPKmFYOIuN1uHxoaOvL7pMNFpsS6urpaLpeXlpbmsNXQ MXmcIG9RVVUllUp323gTNk5yuVwul0MDRrvdPjExkXkBLCePx0NR1Pr6utPpvHTpUiQSedOggam5 d++ey+U6Dqam2HcMsLs1Go1SqTSHHwtO/tu3b7/1HHr30FmGADiOm5ycxGhXMQNfpU6n6+joMBgM +897gOqkYDA4Pj6+vb39XntRWlra1dWViW3DwlteXh4ZGTny9kUikcTj8W+++YYgiK+//hp+PeiT eg/wvej1+tbWVqVSmVsFIxaLt7e37927915LktHWdXV1H6zRhfzx7e3tTJ5Wrs4TyQd1dXXNzc05 DE1ubGyMjY29lWOX6ShRX1/f0tKSeQZBWcODBw9+zTQdMYpIysBXUlJSYrVaRSKR2WzO68At+PrX 1taUSqVGo3lXhUA2cWdn51trEQpYFAqFyWQKh8MOh+MtLSwWi5eWliYnJ6PRqEQi8Xg8NpsNTc+B A/dzbW1te3t7rj4TVpHH4wmHw16vd2lp6a0vOpM3SpJkfX29SCR6/vx5JBI5DuuhaKUMXPzW1lax WGwwGJRKZV5NDUVRiUTC4XBYLJZ3xQrMtTAajY2NjW+lPoCpKSsrU6lULpcrEAi82YcesrjGxsbW 1tY4jpNIJDMzM4FA4DgsrUPBuXPnjEZjDr8LkiShvml2dva9m3B4bgqC0N3dPT8/Pz8/Dw6h47Ae Dl7KZBRMY2OjTqc7wNAy5JCbzeYrV65Eo9FcRaDi8fjS0tL4+LjD4XjTSYgUGJAyzc3NbW1t2Zca ZcmbZdvHYQ+UDUUoZSiKqqurq66uzq2Xdw+nEYlELl68WFNTkytTw/N8IBAYHx9fXl622WwbGxu4 Dg+Wq1evKpXKnH8FPM/L5fKHDx/iV/wmByxlQMf09vZWVlYWVXQG5nJVVFTwPN/R0bGrvK33Ansv m812+/btV69e4forPHDbd3R0tLa2vhVXzuEhUqnU0tJSpn7yOFM8UiaTB/PRRx8VfkLFDoDfRaPR aDQahUKxf5ENvuRQKPT8+fM7d+44nc5jsikvQt5NlcsVENoOhULj4+PYTho44LRfi8VSV1enVquL SscQr20f5G+ura0Zjcaurq79NJaAqHlTU9PCwsL09DTUXqGJOWLAILe6ujqapsfHxw/6dBAik59U X19fUVFRVDqGeOOZFAqFeJ6fm5urra1ta2vbs2WAqJPBYGhvb5+YmEApcySBvGClUtnV1TU5OYnu GYIgDrKKp7a29sSJE1BWXbTAoiktLZVIJPvUW7BhKi8vz1+bfOTAgW+5pqbmxo0bkECK5bgHBTzF pVJpR0fHgUwMzZ6M5CorK9u/8oD6F6PRmJNzQ4oQ0Kxisfj8+fN9fX08zx/zmtwD++MpimptbT0U jad4ni8pKZFKpfufuhKPx7e2tor/T0b2CTyNrl+/fuHCBWhMgoKm8MA1h/qg4m/Uy/M8wzD7lzKg igKBgM/ny9W5IcUJtCM3mUxffPFFS0sLcYztTKEDTJnZN1euXDkUPjEIsf/www+XL1+2WCyxWGwP zUhomo5Go0NDQz6f78AzH5FCotVqP/nkk1Ao9OLFC5/Ph97+ggHmxWq1njx5ModZ/HkCXDI+n++7 7767fv363hzA0N11cXFxYmKi2EL2SP6AzM76+vra2tqNjY0XL14cQyNTOCmTcfb29vYWeVAph5Ak 6fF4JiYm/H4/GNPt7W0QcMdwtR1DYNnL5fKLFy9GIpFXr145nc5DIeIPL3B5KyoqoNw6r4XWRQIY E5vNtrCwkEgkGIaJxWIej4dAO3NsgNC2xWIxmUwul2tsbAxSyI/JAsi7lMnMr66srNRqtXq9/mhv FzJjL2w2m0wmyzyxSJKE6ObLly+P9hUoTjKV2DU1NXtwre0TuAtUKlVra6vVasVWQ/nDarUaDIZM ctsRnjVLkmQikbh9+3Y6nX5rPTMM43a77XY7iuYDgaKoCxcuMAyz2z6/uTq6yWSiKEoQhOnp6WAw eBxMTR6lDFw+rVbb0NBQUlICN9v+002KE47jxsbGUqmU1+uFjvgSiaRgRuTkyZMkSba1tRkMBrlc DqXj0GZ0aGgoE9KiKOrFixfHSqq/hUKhkEgkBxJuyBQdKJVKk8nU2Ni4tLQ0MzNT4NM4qpAkWVVV VVtbmxlscvRMDYSqt7a2ZmdnCYLY2tqCP7AAizmzI21ubqZp+uTJkzRNa7Va2J5JJJLx8fH5+XmY +MOyrMfjmZmZObZ2hiRJtVp9gDpSEITS0lJozgk12263+2jr2nxJGVjE9fX1jY2Nu8rthTymsrKy S5cupdPpTOTvoKwSSZLxePzTTz81Go3QWRzu1a2trenpaYqi3ur2S/y6ZYG/4sSJE+Pj4281n97V +UD6zrlz506ePKlWq1mW1el0cGJvvdhgMDQ3N2d+dTgcX3311cuXL91udywW8/v9q6ur2B608MAS amhokEgkY2NjB306hx6apnt7e0tLS3e1kmFuX39/f0NDQygUmpycXFxcLOQO5E2g75ROp/vkk08y rWWgg8P4+Ljf749EIu92+93howwGQ1VV1X5GHMCTz2KxXLp0qaGhgWVZmUym0Wjee30++uijjz76 CMRWOBwOBALRaPTFixepVCoQCHg8nuXlZfRGF5iMM7i3t3diYuJo12znSx+YTKbOzk6ZTPZuoJrn eZZlT548CTOKZTIZQRAURQWDwXg87na7p6amysrKLl++nNk9w0bE6/UWTNPASfb09IyMjGi1WrFY zHEcTdM+ny8YDL5pUHZLIpG4e/fuHlwj8PqTJ09+9dVXCoVCo9Hs4Rygj4Xb7fZ4PCsrK6FQKJFI OF9zVDVNpjlebW1tUf2BFEUlk8lbt24dSfuS1xZ5mQKCxsbGhoaGdy8gbIqsVmttbS3HcTqdLjNc yePxcBy3uLi4srJy4cKFmpqaSCTCMEwikbDb7YuLiwXLzYcO47W1tSqVanJy0mq1ZiqtXC7XfsIT IpHIbre/ePFiD08vkiRFItEf/vCHjo4OlUolFov34OICN6TT6XS73cvLy4IgeDwet9u9srISjUaP pKnJVNRfuHAhV2OPcwL0Ip+fnx8bGzuqaiYvsqCysrKjo4Nl2bduRZIkU6mUQqH49NNPW1tbp6en d3WvwmM4EAiEw2GwYj6fb25uDsQ+3Bh9fX1zc3M+n++DTtd0Ot3b27uwsFBSUmKxWCKRiEql0mg0 FEWFQqGxsTGGYQRBcDqdufVU703KiESipqam8+fPf/rppyUlJRMTExKJZD+2AC6gy+WamJjwer0s yyaTSYfD4XQ6YczHkQGuc1VVVUtLy/67NucDjuN+/PHHoxf4y5+UgQslFoubm5tra2vf/U5BIjQ2 Nn722Wc0Tc/Nze3qfoG4idvtTqfTcKfYbDbQ+pny18rKShAKO3wsWDytVltTUzM5OQmBYI7jjEYj wzBisXh+fn51dVUul4fDYbfbvZ890lvsWcooFIrTp0+fPXv2+vXrYBDEYvH+68Pn5ubm5+cTiQTL soFAwOFwbGxs+P3+I7PmM9q6vb3darUW2x8FGstutw8PDx9JNZMXm/7ehs1wV4Ozq9gqmEC0Li8v z83NURQFw9PzdKxdSRlYc11dXdeuXRsYGGhvb6dpGvZtGxsbExMT++m2B9IwFou53e6NjY21tTWw pLFYbGlpaWlp6Wg4hNva2iorK4u5PRoQiUQGBwfr6+u9Xu/a2toRMDf5kzJwcSAM/W7mE6iN+vp6 qGAqqqQZeNo9f/48HA5HIpH8ZaDvSspkHsO/+c1vLl26dOnSpYqKinQ6zfN8KpWamppaX1/fZ+iN JEm/3+/xeBYXFwOBAGwUPR7P3NwcJP0U27M/e+DklUplZ2cnxPoP+ox+FdDoq6urc3Nz3d3dT58+ PRpGnihYMTaMGlEqla2trUajMZFIzM7Orq6uJhIJ4rUrUqFQUBRVU1PT3Nyc7xoTuG9HRkZCoVA4 HH7rcEWyFmEL+I//+I//+q//CtPbRSLR+vr68PAw2IV9dg3O9Is0m81ms7m5uXl2dnZ9fV0qlba2 ttbX16+srCwsLBxebwFFUR0dHVar9YNbZ57nR0dH19fXIegJY5MrKiogO6owZyuXyz/++GOCIKqr q3t6emKx2Ozs7MrKyhHQNIUEtkxWq7W+vl6pVDqdzpmZGbfb/eY1VKvVJEmeOnVKpVLltXUe2JlA IDA6OkqSpNvtfusFxWBq4O4uLy//l3/5lz/+8Y+w/imKevr0qcvlisfjsViMZdl9LkK4s9RqdVVV lcPhmJ2d9fv9BoNBr9cHg8H5+flD6gzOJESfOHFCp9PtoAwySZajo6OhUEgkEqlUKpqmT58+TdN0 Ye5xyNCwWq1Wq5UgiM8//5znea/XOzo6etijfgXyykCGXWVl5ccffwxlNZBtOj8/D91vwT3Q1NRk sVh0Oh18u/k4N8Dn8z158iQej+fQo5sl2XtlGIb5t3/7t3/+539WKBTxeHxycnJ2djavQ9thEN3d u3czG1mO4zY2Nubm5iKRyGFZ6JmI9enTp3fl/wsGgyMjI5naRZlMRtO02Wzu6OgocP02z/Mymcxm s42MjBxeKXMgXhkwNRcvXmxsbJyYmHj16hVBEKFQaHZ2NhqNwmt4nj9z5gxJkt3d3TU1Nfm7m3ie t9lsL1++ZFm2wPdOll4Z+NfGxsZ///d/v3btGs/zfr//2bNnW1tb+UtMhOzgmZmZ0dHRTMeKaDRq s9nsdvshWu2ZzOjOzk7wM33wimX8IuPj41DwRRCEVqvlef7kyZM6nW6f80R3C0Qkfv75Z4/Hc1gs /HvJyzCg/8/elwe1mZ/3v4duoRMhEIeQQAhxgwGDbYxtjA2+1vbuZnezTTKZTppMz0ybaSZtJkmn 0z/6RztNm85kJk2TbjbNJhvXe/lcLhtzGNtgboQECAmBxK37lt7fH095Rz8uCyGE7O7zh8dIeq/v +/0+389zfR4ejwcuFviTDBiXlJQEg8HHjx/bbDYEQdRqNeyRbrfb6XT6/f75+fmpqSmbzUaj0VJS Ug4OzbDZ7KmpKZ/PF/92SMFgEJL5d5+vLBbrH//xH7/97W9TKJSurq6enp7FxcU4zDM6nZ6fn08Q xPr6OviBuFyuUqkMBAIQd0v8uQ4DS6PRysrK9nS3dDpdLpfLZLLV1VWPxxMIBLxeL+ShazQah8Mh kUjio2VgyaSkpHA4HAg2Jf6wbxUKhRIIBN58800EQW7cuAF/xvb8fD6fTqeTn4B/VyaTKRQKnU43 PDxMEITdbh8eHl5YWHC73S6Xy+Vyud1ujUZjMplcLpdAIODz+QfxWmGT8Pl809PT8YcyGIZZLBaT ybTL/kTGr3/60582NDTMz893dHQMDw87nU7kICnwYTtPS0uTSqU2m83hcGAYRqVSU1NTc3Nz5+bm EjChbVuBsU1PT5fJZD6fL0JrB0VRgUCQn5/P5/PBF+XxeCDlfGxsTKfTMRgMIGCLwyCAqlEqlaur q/AiXkZVgxwQlFlbW8vKygKKKqCGCwQCIpFIKBROTk6azWYKhRIMBnt7e7cF4BBP5fF4kBwXq7sC U8Dn8929e9dsNsNyjb/sDmXgQyqV+pOf/ORb3/oWhmG3bt2CLJZtz2axWPr7+/V6/dzcnMFgMBqN Go0GgOB+POcikUipVJpMJqfTCS8rPT09NTXVarW63e5E1jKkQ+XYsWPR5cfgOJ6TkwPqCUEQoGkm CMJms01OTi4vL0skkgN1GZKCYdja2trCwsJLai0dNJTxeDx+v18mk5E7H6gauVzu8XjUarXNZmOz 2UajUavVbtXRgUBAr9dbLBaxWBxbNANONY1G8/DhQ4fDAWH0OMsLoQys66qqqv/4j/+oqanR6/X3 79/f9gUB8pidnR0cHFxYWDBsyOzsbHp6OsSeoqhvgipRuVwuEolmZmbAqkRRFPg7wJRKZFUDQFAu lxcUFMBGtte7TUpKUqlUYrFYJpMtLS2Bxg6FQgsLC0AdlJqaGrdML71e/xK53rfKgUAZ0BGpqaks FovJZD579mx+fv7IkSM0Gs1sNkP+QSgUAkqlTcfCJx6Px2Qy0el0hUIRq5El6aSEQqFWq91KkRkf 2QXKwDTCMOytt976h3/4h0ePHj169AiiYAiCQF6L2Wzu7OwcHR3VaDR2uz03N9dms8nlcrvdDmYB juMWi0Wn0xmNxpmZmfX1dalUulelAD/OyclZW1uzWCxQjMZgMHJycjgczvz8fMKqGLgxaIYcnW1H VsfQ6XQANBkZGQKBAApYXC6XVqtVq9Vzc3NisTgpKemAFC7EyFwu19zc3EuqXw4ayiAIYrPZVlZW 5HI5dAa+d+8eoHCn0wn1R3Q6fXV1ddsdHf5cW1tbXV2VSCQSiSSGvv1gMMjj8YLB4MzMTPxdMsiL oAyGYcFgUCAQ/P3f/31jY+Nvf/tbEkwgGyk+g4ODfX194+PjWq2Wx+MBo0xGRsbS0hIJO+bn5/V6 /fz8vEajYbFYycnJe7WgCIJISkqSSCQzMzNg90LqSX5+vtVqtdvtCesngFvNzs7OyMgAWtTozsNk MplMplKpTE1NBS5yh8OBoujy8vLExMTk5KTD4cjMzDy4QSAIgslkGgwGuG5ijvYL5UCMS/BZmUwm Lpc7Pz+/uLgIZUFisTiSYYLRXF9fX1lZAbsqVjcGQCE5OZlGo8Vcq8ZKZDLZz372M4fDsbCwACEe BEECgcDk5CRUFZELfnV1ta2t7f79+8Fg0GKx7JRxBo8MTqnz589TKJSysjKRSLS74gb74Pz5811d XVqtFkLa4J45c+bM5OTkwsLCQQ1BwgjARzqdzufzZTJZKBRaXV0FRd/f39/W1oYgCJfLxTAsMzOz qKgoDik1R48e3bak3GQyTU9Pv7yaKAqBh7VYLMvLy3w+X6PReDwes9kM+0ok44BhmN/vB5qlGLob Ic7FYrGADzcm54ytgH/6j/7oj/7gD/5geHgY1Cy4Fmw229DQEMxzUDXBYFCr1RoMhr6+PiqVura2 tvWEpDeUw+F4PB6ZTHbs2DEURY8dO/bC3JdQKCQUCq9du3br1i2wMOFs1dXVkKj3Um+xEUooFOLz +QiC1NTU4DjudDptNhuDwYCccYhDiUQi4BDh8XgHl64OQ83j8SorK71e76arBAKBiYmJBCRWPRAo A2tgfHwcRVE6ne73+xkMxl4P93q93d3dFy5ciOGNgebq6+vzeDyJpmJgZgDaSEpKun37NkxWKpU6 NDQ0NTUVDAbDt0mghIkkTBYKhZaXl+H/v/rVrxAE4XA4EokkLy+vrq4uOzt7pzodkg41KysL9B2O 4wRBCASCyspKHMfn5uZi9PSxEXSD3bKmpiZyCzsUClEolCtXrlitVgRB+vv7gWhnqxGPoqhIJII/ z549C8jY5/MNDw+Pjo6Ojo7SaDQOh0On02tra2OevchgMM6dO7cTdzYwOy8uLj59+jS2101YgRfk 9Xp7e3urqqqAbmpP6xpePfjzjx07RhZU7vPGgMtfr9cPDw/Hv7DghQKTViwW19fXO53OgYEBJpMJ 9mdvby+JVGAcAoGARqOZnp7evWoXnhFSkRAEGRoaGhoaQlH0xo0bWVlZJSUldXV1Wxk6SAGn2tWr V8fGxqanp/1+PwCanJwcFos1ODhot9sTau+EwIJSqQT9GcmcwTDM6XQWFBRUVlYuLS253e6+vr6t yZpgQ4KrBkEQHo8nlUrhq/X19SdPnrS0tMDnCILk5OQolcoYWlBwdZlMVltb63K5uFzu1t+kpKQE AoGxsTGDwZA4RQk4xCYOYoqgKLq0tJSTk4OiqMViKSkpEYlEy8vLuweYyGMRBGEwGA0NDeFpffsU 2HuysrIyMjKMRqPf70+ctF+wIzMyMr73ve89f/7carVCmKOrq0un0yFhtdOLi4stLS1Go9Hn80V3 Dz6fDzoatra2tra2WiyWlJQULpe7NS4LNhmfz+fxeFC4DmgGx/G0tDS/32+xWKIeipgL3DydTs/M zIw8UQZU5Pz8fFZWFp/Pz83NlUqlSqXS5/MtLS3tEh2Ay+E4np6erlKpoD2NTqdzOBxqtRrcJOnp 6WTSWOQPAskW09PToOxCoRBwfsDg73QUhmE8Hk8sFhsMhsivdXACEaWLFy+Wlpa2tbWhKArB+Jhf KBgMrq+vl5eXGwwGHo9XXFxMEMTa2truASYQ0EU5OTkVFRWky3Of94NusEvk5eXRaLS5uTkob9nn afckuwSYoPT3y1/+ck1NzePHj2GUbDZbe3u7w+GA3wAa6+/vf/LkCXhoorsNl8tlMpmGhobu3LnT 39+P43hqauouZD+pqakQIg8EAjiOBwIBLpcrFAoTLUsPRjU5OVkkEoHqfuG9gTfXYrG4XC6ZTMbj 8QoKCjIyMnJycubn5yOpQWEymQqFQqVSKRQKs9m8trZmNpunpqb0er3Vas3Ozo4ipA6wqaWlZWlp CdKncnJyAMfsBI8wDKNQKBKJBGgkEyQCiJ8+fVqhUMC+fhATBdhyk5OTMzMzU1NTSSgDumYnpwK6 UQkcCARKSkpifmNMJnN2dvZAC5t3km2hDPn/mpqa73znO7DmKRTKw4cPzWYz2YmTyWTq9fre3t4Y 3rbX652enm5tbe3r6+NyuZmZmZt+gG50jFMoFGw2W6fTwe6OomhaWhrEthJhKiMbcBCS6faKHnw+ n06n0+l0PB4vOTkZusuWlJQgCDI/Px9huoNAIABMk5KSotFofD7f1NQUpJ1yOJzIMwlA64Xn/LLZ bLAKdj8QRVG3251QUKapqam+vn5yclIoFCYnJ0PqT8yv5fP5FhYW+Hw+FNwhCAJQhkqlut1uyKnc 6ViochIKhbm5uftJetgksGp8Pp/BYNg/L8teZScoA1gtFAr9+Z//eUlJyeDgoFAoXF5efvjwIRlz J42oGLpdIRQ4ODh4584do9GYlZUlFAq3br3g9FWpVKurq+AcDQQCSUlJQqHQbrcfEBSOQtANDnGx WLxXAGG1WtVq9fr6ukQiYbFYdDo9Ly9PoVAsLi46HI5ISgowDJNKpSqVSqVS+Xw+s9lss9nUavX8 /LzBYAAmrQhvBlTNzMwMIEWCIMRiMZipL3yo5eXlxCnhxq9fv261WtPS0sCVZ7fbY14I53a7U1NT YcGw2WxgByIIAt7ctoegG/UI2dnZpaWlMcR9MO4dHR1HjhyB8rP4VKOQshOUgQdMSUkRiURgsjgc DqD6huHCMCwQCBgMhrW1tYMAwna7/enTp52dnVQqVSqVbnKMg/oTCoVCoXB6ehoGDdxIs7OzceZC 2EnIXV+hUEQHzYPBIJSDGY3G6enphYUFq9UaxfbGZDJVKlVxcfHs7KzD4QgGg3Nzc+Pj4wwGg1QT OI47HI47d+5otVq5XB5eCQKhRqfTOT8/D2+ByWTK5fLdnwje0fLysslk2uuDH4SQXpmKiorx8XEK heL1enNzc9PT0xEEAUaGGEogEHC5XMXFxTabDQbN7XZTqVSXy7W4uLjTFIU5w2Qyi4uLs7OzIy+p 3V1Iv5rBYCgvL9doNHHWM7tAGdi90tPTmUxmMBgkCMJkMun1etIrAMoH6Cpivq7BA9rW1qZWq9PS 0rZCAZjGcrnc4XAsLS3R6XRAM2w2G7pjxvZ+ohMYRgBkUagacoRNJtPs7KxOp1tZWbHb7VHUK6Wk pJSXlwsEgtnZWb/f73a7Jycn5+bmMjIywB8MwHR8fLyrq8vpdMrl8k03jOP40tIShNcRBHkhlCE2 aOLn5+dJFq493fNBCAUySSEsl5ubm5ubS36HomggEIAgJXwCg9LX17fX3hlwoMvlArchvLCjR4/2 9fVtmz0KZw4GgwMDA83NzSkpKft90LCHQhDE6/V2dHQAmUEivAYYzNTU1AsXLpBJiw8ePPB4PHCH oG0nJye1Wi0s9QO6k7W1tV/96le///3v//AP/7CqqgrHcRJ1wUDx+XypVAoqEhzpSqVydHT05SUF 3iQQ0gZ/od1uRxBk97DOLhIIBM6fP+/z+Xp6eiASBzkEcE4ulwt2cDAYfPDgwcmTJzkcDqlBUBT1 +XzAHhkMBkl6t50E0I/b7U60VtsUCgVMRp/PR6FQKBQKnU4XCAQVFRXkb2DMyZwteBaXy9XT07On a4GSpVAokPAB4EksFldXV/f19W07hpClsbq6OjIyAj2S9ppws4tgGKbX681m86EUMW0rULt08uTJ wsJCu93OYrHA0Uum/SIIguP48+fPwc48uNuemJj4h3/4B6VS+Y1vfEMsFm/6FkXRzMxMi8UCZCeQ Rg29vg/ofuIsMNNIAAHIPgoYDXmlycnJ169fX1xchCXjdDrv3bsHP4C0G1Boc3Nzvb294amEMNvh W4jobU313SSwmwM1fOLkyqDXrl2LwVlQNBgMAkCDT0AZGY1GtVotl8vLysqQjXoQLpe7srICv/T5 fA8ePNiWMplMg3377bfPnj0bK2pnWBW3bt2CzLL9nzCKS29NoIPtqqSk5F//9V8hM+bBgwfh4xkK hdhs9tDQ0Pj4eHxmDxDdfvOb31QoFE6nM3ysIAuqq6sL/g9ZbxBTP9yZjYal/caw8C0mEgqF+vv7 5+fndxmipKQkHMeLi4udTieQgYZ/i2HYpUuXtk37JTYI8h8+fBh1BlXMBeh9f/nLX5aWln7rW98C c3Cf59wEepCNXH61Wr20tHTixAnYFAOBAMQvIFcdwzCj0fjkyZNt0Tasvuzs7K9+9asFBQUxiTGR fM2PHj0KRwlxENIhtG3jQCqV6vf7v/e97506dWppaWlhYaGvr2/TsFAolLt378aNZYTBYBw9evQb 3/gG2GzhXxEEMTIy00hytQAAIABJREFUMjExwWKx/H6/3+93OByPHj066Ft6oZBpvyqVijTOD/um /ldsNltnZ+cuJboYhnE4HCaTWVZW9vz586WlpfCvgL/45MmTm9Q+CMyukZGRsbGxhLJdY+PzhPAH 1JKFCwTzwj8hHSHoBhfc2bNnOzs7txZ3wf9DoZDRaISJsk9rCYCRx+MBJqhE6H6ySQiCINN3dgq9 xU0CgcDc3Nz3v//969evQ8IpuVxRFBUKhTKZTK/XEwQBPYdPnz79+PHj3bfq/8uCYVh1dXVNTQ0w e66srECJR/ich5fe3d297RlCodCtW7dEIlFlZSWbzQ53y6MoqtfrBwcH948VElzCizvC5fjx4/Af 0BKw2GFrBC9mZmYmlUrddmzhFVit1qWlpZKSkv13VwB1r1arnzx5EmccE6EEg0FwR3m9XrfbzWaz D3FP8ng8wJX1zW9+U6VSkYuCIAgajZaZmbm6urq+vg6QlMFgNDU1tba2vjJ9EGMuXC738uXLKIqC p2dkZGRpaSlcLYdCIavVarVazWbzpmPhN0aj8fe//31ubm5xcfGm8F8oFOrt7dXr9chBeuyikLiG byFiBaiF/JDBYKSkpJDh7a0SDAZXVlbS0tL2kyACZqvdbu/o6DgsVmyAApcuXXI4HIFA4Pnz55sq DMHmSByoC9GNjz76yGazvfXWW9AaFzYGCoWSn58fTjEO3Crr6+uH2JYM9i2bzdbX19fc3PxCT2n8 BRhOaTQal8uFvnpPnjyJ/HCCIJaXl+/du8dms+l0usPhSBwfTOIIhJmgNhuCgzAxuFwun8/fqeYO RVGXy7W+vr4n5oitAjhmdHR0aGgISnX2c7YoBMMwj8eTkZGRkpLidrstFsvWmKPT6YxhgnNMZG1t 7Z/+6Z/+7M/+rLy8nDRcoWhcKpUuLi6yWCwyb0wmk+l0ukPEiAAENRoNk8ksLCxMnHxkUgiC4HA4 CIIcP37c7/ePjo7uqTctMJlptVoul0sQxC4bdIIIvslrcqACuyCUKXK5XLfbTRBEIBDIysry+Xzb Mi8RBGEwGPh8fk5ODrjWo5gxgO7X1tbGxsYKCwshLf+wZh6KonQ6nclk5uTkFBYWZmZm5uXl4TgO VW0CgSAzM9Pv92u12k1eKCiIcLvd4YGngxbYDKanp1dXVwsKCuh0OrFBnEWhUIBZHwhvgDzUbrev r68fenme1+s1m80H1ykwJgJuXqFQGEVPYMjvS3DDFNJ+r127lpqaeuvWLeiZF59Lg9UECwqKmBAE odFoGRkZi4uLmzoJgFMZCp2kUqlEIona2gEc8/z5cxRFk5OTI699OwjBcZzBYPD5fPCOA5UUPD6O 4xKJRCwWm0ymrTdJEASLxQK65HjqSYIgHj9+nJaWlpGRAW5gZMOR7/P5LBYLmbUmFAr1ev3hdjYA TQgVpunp6QlS+rBVwEOZkpICDJ97Us4EQYAX+UDvMCYSVyiDbAAIcINzudyTJ08uLy9bLBa5XI4g CDC5bZ0QHA6nrKwsCn4OUiDjenx8/HBxzCYBjEWlUkUikUqlysrKYrFYWVlZBEFIJJK5uTnyeSEb icPhuN1uYE+Om34ENGMwGPR6fVFREZPJhEujG3xxQDQMJTkYhlmt1kRgIISa5Nzc3EO/k10EwzA6 nQ6w9bDvJfZyiFAG2VgykDGgVCoLCgo0Gg2DwcjOzl5dXd2UAkz6ETMzM/Pz86PewsH7azKZxsbG LBZLQvHjMRgM6HmkUqm4XG5qaiqHw+FwOAwGw2g0hhdAEAQhEAj0en38/ZoYhj19+pTD4ZBFlIAO +Xw+WHHgSYLUyfX19UMP3qEoCvVxUqk0MdEMeBDYbLbD4di9vehLLXENMJESCoXcbndpaSmTyQTW 1O7u7szMzMLCwuHhYbVavckPRhDE2toaUFJGcS0mkzk3N9fR0UFuwwkoKIpCgAn+z+PxSOYlEjr4 /f6MjAybzabT6eI5I6F/wujo6HvvvffDH/5wZWWFLMbOz883GAxQaYUgCI7j8Wcd3Ekgjb+xsZFO pye4AyNugqJoVlZWcXHxpmJL2DBemJj8cgmO4y6XSyKRZGVlsdnsd955x2KxtLe3nzhxgiCItrY2 MrOVXGIej8disUQXY4IxfPjw4ezsLJPJTNgxhNRpMLXpdDr0EQv/AaDA8vLygYGBONPsQvD617/+ dWpqal1d3erqKoVC8fv9XC5XoVAYDAZSvVCpVNLMO0StDioaSKR2Z5b7vyY0Gq20tDQ1NXUTwgNo 1d7eHludfDhQBiZfb29vdXV1RkYGhmEnTpzAMEyr1QaDwcLCQr1e39/fT6rUJ0+eQJOOpKSk6PhC tubGJ6CQQX3498qVK3fv3rXb7WSiNPR0LCoqolKpGo0mzioGQZDR0dFf/OIX7777LrliMQzLyclR q9Ver9fn80kkkrW1tbW1tQTB/h6Px2q1kt0GEk0gG+nMmTOdnZ0wsWM1aHCqY8eOpaenb6sytrIh oyhaWVl58uRJ6K3I5XIBwvp8vvb2dnLXx3HcarWOj48nYB+WTUJ2YH38+PHRo0eTkpJ4PN7169d9 Pl9/f39jYyOCIL29vUtLSxAztdvtLS0tqampNTU1+3HMJPKYkAJhNbvdnp2dfe7cuba2tnD4BSRS 1dXVAwMDe6Xe2KfAdP31r3/NYDDKy8vBEwOZH3K53Gg0wl6oVCpnZmYSIc+dLNSIP0tZhALpU9nZ 2X6/f2RkJIa2CrrRe+vs2bM7GbFg5W6SK1euCIVCiUSSmppKpVKh2H5qagrK7shs/YWFhYmJiUju 9kDGPRgMnj59OpwkAwlLvB0aGoLMahRF+/r6jhw5IpPJYHAVCoVSqQRvp1QqXV9fHxgYgB8Dx8ae lAtZRzAyMkKj0Q4lBS9ygWAT1NOeOHEiFAqFQqGjR48+efIkHM1A3mh+fj6FQhkfH4/n7UHrFrVa vYmMB8yjfdaXvUoC5cHt7e0+n+/s2bM74W8Mw8jKUoiDxHC3gFP19fWFQqHKysq8vLwX2ovwij0e D7Aew4eQb6FQKAoLC8lMBRRFvV4v7CI0Gs1oND548IDNZvt8vra2tvjseXAPYrG4rq5uUxwElpJO p9NoNH6/n06nr62t9fT01NTUQOcaGo1WW1tLEARZRDY9PQ2GNUEQ0UVVKBTKgwcP7HZ7MBhMcFUD jmrY0vLz8z0ej1AorKqqGhwcJCNioGr4fH5VVdXQ0NDy8nLcfHWQ27G4uLi8vByexIOi6Lab4v9Z Ca+6z8zMPH78+LZTF5aDWq0eHx+HAYzheyQ2em999tlnGIZdvnw5ctoUMHrHxsYQBMEwDMfxpKSk 06dPA+QiHwRyasEs6e7unpqaEolEWq12bGwsfE5GzysD8Q6BQFBQUCAUCuFKMQwuoChKQplQKFRa WpqTkxMhWRnpLZ+cnIzwEMj7y8zMrKqqIgjC5XJ1dHTEOVYCQ5qUlHTp0iUwTeDOHz16ZDabIeWW /GUwGJydnR0eHo7n7YFt9OUvf/nkyZNwh2QLD5PJRKfTKRTKysrK8PBw4jhmoOAf8ARBEFvpeVAU heJe2B1PnjyZkpIS3X5GbHC7tbe3h/cmPHnyZFpaGnlOUC7r6+utra0HPUpkZXJpaalCodipdWiE Al1aamtrpVLpTk3sIB+ZRqP19vY+evToP//zPykUyl/+5V+ChoruEYD3RaFQQEc2Op0eW9w8NTU1 OTnpdruhITB0ko/kQODgDu9e9EKBaXb06NG0tDQqlTo+Pj42Ngad5/fxBHsTiDGVl5cfOXIEGqsB TyAQh5I/Ayec0+kcHh42mUxxQzPA9FNcXPzuu+/KZDLIvQNL786dO+D5wDBsampqYmIitu7M6ARu ID09va6ujlxiFArlzp074RWdVCoVvKEQMjt9+vQu7C+7C+xxExMT4ZwOAoHgzJkz4e8IimyePn06 NTUVn9fH4/GOHz/OYrH2kzMOXlI2m3327NltXy7k9Xs8HgqFYrFYWlpaovHKwMGXLl360pe+lJGR YTAY7t27l5SUtNMwEQRBp9Pn5+eNRqNCoYDiLvJb2AsfP348NzcH3mzSjw2pLSwWKxgMQoPASKJL cMLe3t6ZmZnIcYzL5crPzz969KjH4wkHDfEUYoOwtaOjo76+nnzSkydP4jj+7NkzjUYDKg8MaIVC kZWVdffu3XgqQSg6i9vl9i+AYOD/8KILCgoQBCHRDCBX8vcdHR3k/ykUCoPB8Hq9AoEAXGUkFtl2 HpJBwLq6ura2NvKXnZ2dtbW12dnZsP0DZuVwOCdOnNiJRWYnAbzo8XgOJfsHXv3Tp08fPXqUnp5e Xl4OvCnho0GSvjQ0NJSVleXn5w8PD0dnFUDJ65/+6Z8eOXJEIBC0tbVNT08Dj9G2vweMODw8TKVS s7OzIUeKvDccx71eb1tbWzAYJGcFaCfYYwiC4PP5EokkklbDxAZPVVtbW+RUNCiK+ny+xsZGsVjs 9XqTkpIOhXAclOTk5CSFQikuLoYKL4FA8Prrr7vd7vb2do/Hg+M4utHCFrpoDQ4Oxmc7JDbY3hOK em4XgT1rk/3j9/sbGxs7OjrIfCNg+YNvV1ZWbty4Qf6YwWBAkw0wOTax8W69Itje8MuJiQl4L+vr 6y0tLQ0NDWT9F9S7FBUVhUKhmZmZyF8fUPgQBAFzI84CUVq73f7ZZ5/5/f6tjgxACMCDmpqa+pWv fGVvXhnwPx8/fjwrK4tGo+E47vF4dhkaQI7Dw8NjY2NQzkChUGg0mtvtZrFYyEb3uwjrksCk9nq9 ZWVlSqVyW4c5QRAMBuP+/fvQvCNyHQGbXG5uLjS+h3Cd2+2G+HFHR8f6+np86iph7qamph49enQT tSukVuh0ur6+vvDAtt/v7+joiAmhC4qiUMQRPm8wDANjAloLhbcrgyk1Nzc3Ojpqt9uZTOby8nJC eWUQBGlqatoU7gRQHwwG7XZ7b29v1OAMPJGwP0EDEPKRw+ERyeYMTL4wu8B/c/fu3X0+XSRCpVIh TpSXl7dPxwwp8Ag+ny8lJeXcuXNbt38cx1dXV995553h4eEf/ehHwDIQyZkB6rHZ7IaGBjqdzmaz YQ/YZTrBm+3o6AAmeAi9w14IGhlKDSLUM6DHURSFG9iKGkm/2t27d/eqFmATOnv2bEZGhtvtBvsN rOf5+flHjx7FB9wATKFSqfn5+YWFhZtoZqCUvbu722QyAaEUgiA4jhuNxq3swFFcGhS1UqnMyMgI N99xHIfwnFgsLioqAn8/usFc5ff7JyYmpqamQO0kjlcGIEJycnJjY+OmhQB7HJVKVavV0HYmilsF zzHMTJfLRaPRIBQIK2UrudSlS5cYDAYMLJQvwS4cByTKZDKTkpIqKiq4XG4Me1TTaDSbzXbixImd YuUReWVgyBQKhUKhgAEFBPrCo6hUamdn58zMDKgVsFkB5YUr+gifFkVROGpgYGBgYABmM+lqhvlx 5swZJpMJG0wUMyYUCpG7GoqiQMrEZDKj7sIThcBcX1xc3MpxDFugXC7Pysry+/1gYkIIubGxcXV1 dWho6IUke/BtUlJSYWGhSCSCBg4YhrHZbJlMlpubC8fiOE6j0Ta9GkAALBZLqVSCY/NAh+LgBCYP juPJycmXL19GEMTtdvf09EDTpchl0yrYqdM77IVqtVqn0/l8vvjz2vn9/mAw+Pz5c7PZfOrUqZjU WYCWjCH1CMwuDodTWFiYnp5O3uFOoxp+oMvl+vzzz4HiCNkwujYdHrmeIY3RW7duIRueGzKu4Xa7 MzIy6uvrEQQBhogoHjYQCJALnEqlUigUUuFEcbYohNggElxbW4NmVeHfwsPW19fDNjw5OTk8PMxi sSQSycWLF/V6PaQ4vFBQFJVIJIWFhZBCgWEYhUIRCAT5+flisRiUD4VC2ZoEg6Kox+ORSqUIgkAV fYyeO94CoA1BkKKioqKiIgzDDAbDs2fP9oRpNnmOvV7v7vtve3s7TNRNwCUOHjW32+31ej///HNw eUTi4IxEAoHA7umYL4AyYG6y2ey//du/LS0tvXnzpsViicRoAH9MR0eHwWA4oDAwaNJN7q87d+5Q qVRoWhnzK8ZN4IV98sknFy9e3IptyW2YwWC8/vrrfr9/dXV1YGBAKBSeOXOGwWAMDAxMT09vBeDN zc1JSUlOp/P06dPhqRuQchXhvUFWY0VFRSAQgNzylxfQhAvwAiAI4vP5mExmX19fzJulhbuXwwWU Wn19vVQqbWlpAd6gmC8ZOKHJZPrd734nk8mOHDmy/xAVqGmz2Xz37t2mpqb98GpQKJT19fW6urq/ /uu/ttlsn376aSR6A3AAVN2jKHpAdbCgBsMBqMFg+O///m/IHDqIK8ZHIMw0Ozv7+eefb3UnIGHb cGFhYWFhocfjmZmZmZiYUCqVYPN8/vnnoEZgR4B5K5FI6urqnE4nl8s9f/58+BABYiP/3FpGRwoU GaSlpclkMofDsbi4CGlSL7tAD43MzEyCIMBreO/evZgv9m2jQuhGi7qmpian03nnzp3YXpQU2BR6 enqgBk0qle7fEwy+pa6uLp/PV1RUtLU/1G5QhsxCvXz5MlSpRAgkgdEZKgJI52TcJLrUQsBe0Ce9 sbExtvQAGIaZzeb+/v6LFy9iGAY9S4PBYGVlZWZm5k64lUql3rp1q6mpafcsVCqVmpaWdvHiRXgK h8MBRk8oFJqampqammKxWI2NjRiGSSSSyspKGo0GCSK76JFthTSai4uLIdSFbEwSuVw+Nze3tLSU mZmZkZGxurqaUAGmPQmNRgsGg1VVVdXV1X6/HxjPHj9+fNCP09zcbDAYXtgBO1xg55BKpUKhMMI8 BhRFs7Ozy8vLY+JNAdNZIpE0NzcvLi52dnaS7br2dB7IQi0rK6utrYUG2i88BMJbTqezr68PiL+i fYgoBVIfojgQAERHR8epU6dycnJiqGoA2PX29qIoev78+YmJid7eXi6Xi+P4qVOntp3AJBi9c+dO c3Pz7mCUwWAApkEQxO/3QxDf5XI5HI7h4WGLxaJUKouLiwmCyM/PV6lUYINF8XSQGZ2bm5uenu73 +2E+QPGmQqHQarVQ7gptvcnm0i+XoCgKz/Xaa68hCAJ75ePHjxcWFg5I1cBpJRLJuXPn3nvvvSiO rampmZ6ehm7Qu98h7C9lZWWZmZkxaZEBKuLEiRNlZWUPHjzweDwNDQ12u5088/YqA8Mwr9crFArf euuty5cve73eGzduPHv2DJZKJKMModZD38zAySaTyWpqajAMW15e7unpaW5ubm1t3QlAgIYKT6rw er2NjY0PHjxYWFjYE/MV6Cyj0djd3Q3bzEcffRT+g+7ubmhUK5fLa2trw5Gm1WodGxuzWq1tbW3f /e53y8rKrFbrC30nGIZxuVyytR4U1kKiUmZmZnl5edQNxmEm5ebmnjt3Ds4MASZ4xeDXgYYpMpnM YDDMzc3FmY4i5kJstCRMS0sLTynz+/2QgdHV1bW8vLz/ZyQI4rXXXuvv7w8EAnQ6PfIgF7xKg8Fg MBiQyLzHBEEYDAYURffvlYEpkZ+fn5OT895771VVVV24cOHTTz/NyMgoLy+PMIMEVE1paenXvvY1 lUqlVqtv3LjBYrEiMYHALwuo+tCLn0FR1NXVpaen0+n0hw8fMhgMcLNtqzTAMAiFtWj1+/18Pr+5 ubmlpWWvqh8ssa6uLqBdIQjiF7/4BXwFZBYff/wxqJqGhgaRSASmEUT8jUYjVG89efLkBz/4QTAY jOTFUanUjIyMjIwMBEEg52xkZGRhYYFKpRYUFOTm5kbtooN5deHChezsbARBxsbGZmZmuFwu7Cmg AwEtCYVCtVo9ODgIuPzlVTUIgoCFefToUfgT3eCqplKpDoejvb19n08HG1BaWtrRo0dv3769VzuW 2CB3CP9zFwFHJuwR+/fKAG/FxYsXZ2Zm3n///XPnzi0tLb333ns1NTUymQze/jZQBsLMaWlpX//6 148dO9bR0aHX6yOZlJCWBWmMsB4OPfQA6fcmk+njjz8mP7x9+3YwGHz99dfv379fUVExPT0tFosJ ggDC7MXFxY6OjrNnz4bnkFOp1CjeBBRq7p4BDoZdOJPHpjOEQqG2tjaDwVBQULDXOcFgMAoKCgoK Cnw+n9FohMC/WCwuLS2NPCcLdG5SUtLJkydlMhnQplGp1LKystHR0WAwSKVSZ2ZmlpeX5XK5QCBg Mpnnz58PBAKffvophmGJ4IG32WwsFitWsxHi+gRBnDhxAgnLIEYQBFp9dXZ27kmxoih6+vRpiURy 7969g0ujgVvi8/lHjx6F3LV9nhCQOsBWFEXVarVcLr9y5crCwkJrayufzz9y5MjuSWYQRKiurv7j P/5jFEX/53/+x2q10un03bOwYdvWaDR9fX1AZrPPB4mJgBka3hwUw7CJiYm8vDyVStXR0dHQ0NDR 0XHmzJmuri673c5msx8/fgxbMjhmQGFGl/ML7jGy/n/bM4CqaW9v3/ZwgiBmZ2dv3rwpEolqamo2 FRzsLjiO8/n8kydPIghit9uhJTiHw8nOzi4oKNjT4xAEkZ6efuzYMZiiOI6np6crFIq5uTk6nQ68 ViiKKpVKDMOkUukbb7yxsrIyOzt7uKoGntHv99tstpgEwsA+BMDB4XCuXr0Kn0PKCERbnj17Bg8e yZsC7ScWi19//XV40fu/yZ0EbkmlUimVSigb3H90icViPXjwAGCuVqutqqoSCoVTU1PDw8P5+fl5 eXmboQy4MXJycq5fv06n099//30o0IjwehQK5cKFC/fu3YNipYSFyTiOf/LJJwiC9Pb2IgiysrLi crlUKlVZWZnX62WxWOHbPCSNnz59uqurS6fTRZj6A6Ov1WoHBgaiTn0gg44DAwOFhYVXrlxRqVRR JFLRaLScnJycnBwEQWDfBYw1NDRksVhKS0s3sRKBwCadkpJSVVUlkUggLIVudNEK98rA78FmgqDk qVOnFhcX91/skPhCpi7Bn0BLHf4thUJ5+PAhtAvddhqAqxkKv/eT4wUcUw6HY1udDm/BarVOT08f OXIkVv1iwPwSCASQFYFhWFpamlwuHxwchILe3Q88depUY2PjwMDAwsICDOMLZwtZhophWFdXV5wZ WSIX0ikL7UJbWloQBGltbYWn5vP5AFxI44TMqb906dL9+/fJFOYIL9TS0gJR3ShGA8bc6/XevHkz OTnZZDJdvnwZCsf2Okk4HE51dXV1dTWxUXtMoVBMJtPQ0BCHw9mpsAV27tzc3MrKSqg4A0EQZGFh YWpqisPhhE8M2JWCwWBWVtbVq1d/+9vfHlCGWaIJGXsNBALl5eXl5eXkV0DD3drausvhYIVCPeN+ boPFYgGq2Ha1woc6nS45OTkjIyNWLfngilVVVcXFxS6Xi8lklpeXK5VKrVaLbKLIAydnSkpKSUlJ SkrKC6Pp6AZLHp/P1+l0pD0B1EBWq/UQu8JGKMANBaqfLMZ2OBxQpoggCCzFXcaB2MKzApD5+fPn o6OjbDabNNn3IxBy9ng8hYWFx44d25r0FHMBTZGamlpbWxteEkl+NTQ0NDo6Csq3tbV1bm4uOzu7 uLhYKBQSBOHxeHp7e+/cubO4uLjtySEBrbq62uPxkAG4A3oQgiDOnDkTNfHdPoXkqVxYWNj2MTEM +7d/+zeBQODxeB4/fnzz5k1oYPvCAYHfKJVKsVjc1dWFIAiDwTh//vz6+npPT8+2sw7oK4LB4KVL l/ZP+g4zgU6nq1SqvLw8v98fjl12L8YmCCI3N7ewsBCSkyJRNTKZzGazra2tgc+AwWCYTKadIjiJ JrAJQZQEirEzMzMh2A/pw6BzdlGY8JtNH2IYdv/+fSjqBpN9n/dJBp7Onz8P5DcHvWTAGMjPz6+q qsLCGuUCvllfX3/69KnBYGCz2RaLBYIjCoVCpVKBZoas897eXtgyN40AfCKTycrKyvr7+2Oey7/p QhwO54UpRwcnYHXfv39/6zQAPoiKioof/ehHa2trDofj008/jZybG57u3Llzo6OjJpMJQRCFQlFe Xj48PKzRaDYNKfw4OTl5bW1NpVJVVFQ4HI59blgA9EUiUVlZmVAo3JpRR9n0U4g+QI3uC18GRF5W VlZ4PN7Xvva19vZ2s9mMIIjf779w4UJra+vy8vJh0c1FKMFgEKwfEsfodLrx8fELFy7AwnghVfa2 vwkEAiUlJSUlJQdxz7Eqb4tOiA0yg5GREZgAWq3W5XJBZn5aWhrALBqNVl9ff+zYsW2DBZBHxWAw 1tbWtFotpDbvf56AebqwsPDw4cPw7Q0A6yH2raVQKC98ZbCF1NbWoij68ccfLy0tvVDnQnWrRqMB kuKnT59ev37dbrd3d3fvdCCEIQiC+PTTTyFVfJ/DDkqjsLAQdtNIDiE2yB0KCwsBlESiamg0mlar vXTpEoVC6ezsdLlc0LigqamppaUl8a0mWAiQUlNfXy+TyVpbW5OTk8vKykDRYy9qd79Tr1Z4jwch h9vqGaa3yWSanp7m8XgOhwN2TQRBVCoVzByCIMRi8Ve/+tW333572zkPIwbEuDKZTCqVJiUl7T/n HZzuPT094X56cK/GkEwlComkt0MoFOLxeJcvX0ZRtKOjI5JMI4CVwL+HYRiLxaqvrwfW1q1qCk4F 9hgQ/1RXV+/T/AZ8olAo0tLSXC7X1soASvjv0tLSSktLBQJB5C8DGBeMRuOvfvUrkUj09ttvf/jh h8A2ce7cuYcPHxqNxsS3mciiRIIgqqqqBAIBEPfdvn374sWLLBYL1HQ82WV2EhjwxcXFBw8eZGdn V1ZWHtwtgbUUPv9gQttsths3boCOwHFcq9Wur68rFIrk5ORw3YeiKI1G2yW/jCAIgUBAZrrFSrKy sr7yla/s6ZBwbwFMhqGhIY1GE88gKUAZBEHq6+tTUlJ+97vfRcI1Dt/q9Xq9Xo8gyAcffPDCC5HR hI8++giYCxqMiNPvAAAgAElEQVQbG/l8/l73LbDdk5KSJBJJ5D5kmFQKhaKgoGBP9jG8lwcPHgCb AIPBuHXrFo/HS05Ovnjx4v379w8R30cugMl6enqgHgQoRjUajdlsvnz5stVqJf3Bhy7gXe7t7Z2d na2urpbL5bEiV9wkxAaRVfiHwWCQQqEMDAxARhSKom63W61Ws9lsSJQJX5gYhu0eMQkGg0qlkvwz VnXddXV1dXV1Ef6YzOQNT10IBoMPHz4EMrCY3FKEAmlz77zzjlgsvnnzJrBH7q7rYKmSuVYQ1kF2 rTaAr6ampnQ6XTAYFIlEDQ0NUfj5AJ+kp6czmcyd1BQF2RhiqVRaXFwcdetpCoWytrb2+9///tix Y6urq1NTU16v9/Tp0zMzM2NjYy6XKxFwwAsFRVE2m20ymT755BPYg2HNkJme8b8lUCiPHj2CsmoS /odCIbPZTCYmx/y6kOQBtEBLS0uQi4ei6PLy8s2bN4HLC8OwTz/91Ol0MplMs9m8uLjo9/tFIhE4 9iIkcU4E2bR5hEKhbZ1qoHru378f21r9TZfw+XylpaUoivb396+srECr2AMyBgDDQRoHXKWwsLCs rCxCEwrgxcrKilarfe2113ZXUuhGM1SocEGimrewHDo7O7Ozsy9evKjRaBYWFjgczvXr14eGhvR6 /UtBdASwlcfjDQ0NTU5OoigKCfWRuIEPTqBu49atW+FpOhAOA1vlgBQgLKvx8XH499q1a3w+n0Kh dHV1jYyMsNlsGo02NzfX3t4OucATExPAaAWAeFN7ioSV8ExeUnAch5rQcAGXj06n6+rqOtDWpBiG Xbx4EUVRiOJF4gmOTiDYvbKy8uGHH5IfAs9ZhHgjFApxOJzHjx/n5ORA47BNCgq9du1aKBSSy+VF RUVMJjMmbBM+n+/rX/96e3v77OwsTD4ajba4uNjf3w93kPiYBtlwg1++fHlb5vI4iNPp7OzshIhA XV2dQqE4uB10J4FUsrNnzyoUivb2doPBAEsLirNu3boFsf9tj4V9q6SkJDs7+xVO/oXNdXx8/PHj x9CQaNsfPHr0aNs4PYqily5dunbtGlTuwCbn9XpPnTolEol+/OMfDw4O2my2hw8fxvGZ/jfazePx mpqaIrei4BVfvnwZSNMpFEp4rkx6ejqO40VFRTKZbP+TAXIAFQrFyZMn/+u//otkIadSqSMjI1NT UzAzE3/WQXQ7Jyfn1KlTcciB2yooiup0uqdPn0Lu+eXLlw+luB1e37vvvru0tNTT0+NwOCCpC4on urq6tl1cyEYeVWpqamlpqVAojCH9dKIJuOTv3bu3srKybeYGCUY3fQVqRywWv/vuu9BnkJxmOI5/ 6Utfevr06c9//vPV1dWJiYlt6VUPTuBaZWVlhYWFEc5/WDIymez06dPknohev37d5/NdvHgxCg/z noSMjHz++ee7NIQ7dIHCCj6ff/bsWcgnYDKZ8YEyoIgdDsft27cFAsGpU6f2VBIZNwEcMzk5qdFo IjSCwfMHyXrA9f6qqhsEQYBi59atWzA4e4UyyEZGRW1tbWZm5m9/+9tAIHDnzh1gVjwsycjIqKio APaLF/4YdE1jYyObzb569ero6Ojf/d3fpaSkCASCpqamWFU07CQw4N3d3ZOTkzvtf4kgEKutr68n CGJ6evrKlSvhlF8HKqFQKCkp6fnz5/39/UeOHCktLT2g4NF+BPTh2trayMiI2WyOJNoLkQgmk1la WpqVlZWwu0xMBOY5ECHCPI8CyoCCeuuttwYGBqD/+YcffrhtBsxBC5hPNBoNqrgj8dagGyy+Fy9e RK9evZqbm1tQUMBisebm5kZGRmw2G5VK9fl8PB5PJpPRaDS5XL7/p3qJoAx0Lb548WIicKJEIrCA s7KyrFarzWY7uAwPmGoWi+XOnTvQoen27dtAGxAKhdLT07lcLp/Pz8rK2gkWYxjm9XqlUmlJSUlS UtKrjWkQBIFCm8ePH3/wwQfLy8vbQplr165dunQpHMpsFRRFgWv8/v37h9U/Dy4qEAgqKio25UVt K1QqVa/X//M//zOKot/+9reLioqUSqVMJvN6vcAGTipfmUzG4/FEIlFKSsr+syZfIijjdDorKioq KioOxR8ThUA5XlpaGhAtHtyFIA3r2bNng4ODKSkps7OzPT095PLJz89HECQnJ4fFYu20asCtXlpa KpPJXor0hv0IsdGn/eOPP75z5862UCYtLe0rX/lKRUXFLkQvcJ7p6ekbN26Mjo4eYn07RF3Lysoi 1HW4SqUSCAQSiWR+fh6aEcJGCCpmZWXFaDTOzMwolcp9TlzYbrlcrlQqnZycTMx1Cw8OiehKpfIl mv04jgMGfeONNwKBAJvNvnbtms/nM5lMMWm0C1Pc7Xb39/c/f/4cUtO7u7uhLgMYa5aXlwOBgFQq DQaDPT09ExMTDoejv79fqVTevn17fHxcrVYnJyeLRKK1tTWdTgfGFp/Ph8ybVxLTgDtKIpE0Nja+ 8847ZWVlJpMJOGbgpaAoClYIEDFvHQR0o+D5zTffpFKpV65cEYvFWq0W9FH8p6jH4yG7CUql0l0A DUQnm5qaUBS9d+9eSkqKWCxmsVijo6NTU1PIBm0XOCfAuR0MBuVy+T7dw+DTUigUQGWbmEWUYBVA ZCQ9Pf1wa4UiF5iNNptNJpNdu3ZtbGzswoUL5eXlCwsLoH9ipWrMZnNnZ+fi4qLX6+3t7Z2cnEQQ BMqwV1dXV1dXuVxuenq60Wh88OCBxWKZmJhwu900Gu3evXtqtXp2dlalUhEEsbi4qNFoRkZG/H6/ UCiMsGLupRPY7yGAe+3atTfeeIPP509NTcG8QjdaCJeWlkokkp0MSGyjf8jx48dFItHly5edTue2 3K3xEYvFolar1Wq1VCqF2MhuqXhXr16FZhZardbpdO5i0AMXRdR5waQASHr69KnZbE7ADexl9Moc qIQ2esQ/e/aMzWbjOG6xWCBRFAQSxiG3PCkpaWxsbHh4eBc4D19lZmbyeDyCIEpKShwOR1JS0qVL lxLWgI6VgJNmcXHxgw8+AGZYGo126dKlF3plSGGxWKdPnwaiz9HR0Zs3b5rN5jgbT6AZmUxmcXEx eFm2tUzCvTJ/8Rd/UVpaKpVKHQ4HVGZte2Zso+/0/vugwVAbjcbBwUHweSQaoHkZvTIHLRQK5e7d uxaLBcdxILTVarXAiUKj0QoLC+VyOWTVAGqx2+0vtNqh64tcLheLxevr6+Xl5ZWVla/8gMP8f/Lk yW9+85ulpSUEQTIzM99+++0jR468kH4XxjMnJyc/P//27dsOh+Pu3bttbW2H5Q9OTU2tqKgAkrYd /dbhFHm7C0EQ+fn5SqUyEkqr3QXic8+ePVtYWEgojAz2nEgkam5uPhQ6tQSUcCgDIaGoTwUKSKfT PX/+HIjtORwOOZc2JY2+woNPJkV9+OGHPT09//7v/85gMKK2EFAU1Wg0N2/enJiYiJuiAfAkk8l2 IWwkoQyCIN/5zneAUXr306IbXTJKS0vT09P3+Sww35aWlvr7+yENJXHQDOCY2trayLMd/y8ICWX2 SRQE+XxQ1FZQUKBQKMi8w22TRl9VgbxpjUbzk5/8JDc39wc/+AH46aM4FUEQfr+/s7Pzs88+s1qt cTOf0Mg4TvcAZcjMzVjVv6EoOjAwYDAYEgrNgIBLH0iEEkf9JY4AGNVqtWq1epcipggFx3G32z02 NlZRUTE/P8/j8V577TWy6V2s7vmVFxRFFxcXP/30U2D+PWgBXSaRSE6fPr3tZhwFlEFinbkJaGZt be3Zs2fQ33Q/Z4u5AKApLCzc1E32CwGBYJPNZhsZGZmfn99nFiBwB2i1WiAfMRgM5eXl586dO1xS u5dO4BUMDQ199NFHer0+DpgGLnHixInMzMydGGJfDGVgMslkMr1eDxz82dnZRUVFseJMZDKZra2t JpMpQULaZFL0+fPnv9AskQvMk9XV1fHx8aWlpX1CQLCcampq8vPzX21AA5Hs+/fvQ4OIWOVMYBjW 2dn50Ucfra2tYQfZaY8Mwzc2Nm6KF+8JykDlYGpqKovFAv1IoVAKCwtzc3P3b04AoLFarXfv3t1P l6vYCuCY0tLSioqKBCwgSmSBAnKNRuN0Ove/B1EolKampkQuRtm/AFfNzMyMRqNpbm4GTrx9nhOW 1fr6+kcffdTZ2Yn8/1yjMRcANAUFBSUlJVvXyx68MqFQKD8/n8FgjI2NlZaWKhQKr9e7f70Q2mhP r9PpEod9HLwykLEI/JuHu5uCqcrn86GvTSK36kTCcoRHR0chhhgdbAddX1xcXF1d/Qq7gsnAf1lZ WQy7r4EAtdTExMRvfvMbtVpNp9P9fn9srSiAGnQ6vbm5GXy3cH46na7T6X784x/jOP5Xf/VXEQaY /H4/j8dTKBRra2smk6mpqWkT5XTUguO4x+MhS8D2f8L9C0D2/Pz86upqKLnYysgefwmFQqmpqVar NfEBFsRqFxYWxsfHrVYrGlU3TWQDSTc3N++J7P7lElikJpNpcHCwubk55rADzI/79+9//PHHdrs9 Vk3BNl0CqBErKytdLhdkTcHne4AyyEYqCXRh6OnpUSgU2/Lu7VUgQUmj0YyNjfl8voQKafv9/jff fLO1tRUMxE0bKkEQgUAgQYjGE1lwHP/888+dTieyK9H1VgEVk5KSUl5ezufzEzBPPCYCWbT3799X KBRbp1nUQlI1VFVV5eXlqdXqvr4+u93e0tKyvLz89OlTUP0H5LNhMBgej+dnP/tZU1PTt7/9bfJ+ IrltADQNDQ1qtXpmZubs2bPbdlTeq8DzPn361GQyJU5cGwCNXC4vKSlpaWl5/fXXN70RsGQQBElw G+ZwBbZqs9n84MEDBoPh8/n2dDjMuoKCgry8vAQJEcRcSD9KT09PU1MTEmumeJFIVF9fz+Fw7ty5 s7a2Njg4COWK09PTNBotEAgcXCgK/dKXvuT3+wE9RKhlgsFgRkZGQUEBj8eLlToANKPT6YaHhyGg cLgzKRgMMhiMS5cutbS02Gy28+fPg/MfeOWhZ2F7e7tUKq2vr39VUXxsBVw1s7OzGo3Gbrfv6VjA 0CkpKWfPnn1VqWhQFHW73QiC0On0eD7g6urq8+fPFxcXBwcHl5eXoUI4JqsPoMwvf/nLkpKSP/mT P8nNzYU4d4TqDCZMfn5+Tk5OTKp8ScEw7NmzZ0aj8dDnEoZhdru9srIyPT39s88+k0qlDQ0NZJDR 6/VyOJzu7u7p6enjx48rlcpX2DcZQ4Ei2bGxsbm5ub36HgBWHj16VKVSvZKhbdjBPR4PlUqNjxEO FCeBQACKLs1m87Nnz2A5b9tsODpBv/vd787MzMAmvacjSddobW1trHo1Q7Bpenr60aNHZL+heAr4 AIRCYWNj4yaUBvfW3t5Op9MbGxuhX/z58+djEnT8PyVgGZjN5uHh4fX19QjZq8hs0IqKitTU1FdP oQMBa2tra1paWlFR0aEkgcIkn5iYeP78OZVK1Wg0arUa7Ioo3NF0Ot3r9b7//vsKheKHP/xhWVnZ xMREFEFkALLnzp0Ti8WxyiWCLL22traFhYVDMcEheFpVVVVUVLQpjgPugdu3b585cyYtLe3evXtS qbSgoOCLvOAoBBiwoCdghKMHNJ5ZWVklJSVsNvvV8wRDmUVHR0djY+NhEcrDLgCeApfLNTQ0tLi4 CN1to3MS/y+U8fv9wWAwKytLJBIZjcbl5eVtzSCYCuC/gXRF4PgvLS0Vi8UxeeWgYubn59va2g6x pTZ4Zc6fP3/37l0oA/v8889NJhObzbbb7SqV6vjx419oln0KxLntdvvQ0NDS0lKE7zoUCuE4fvHi xQNttBZ/AShz79699PT00tLS/cdtYysLCwvDw8OBQMBqtQ4NDa2srECwgyCIYDC4LRQgvTLFxcU/ /OEPi4qK1Go1dJhXKBQIgkxPT4NLeOux8CFZPQtYKjc3V6VSgZETE1XDZrMfPnyo0+kOS9VgGOZw OICVYGRk5M0331xYWGhtbQWiTq/Xe/78ebFY/Eq6B+IpoGr0ev3ExESEZflgq+fm5tbV1cXKVk8E AWeny+VqaWm5cOFC4vTGAYo/j8ej0Wh0Oh2GYbOzsyMjI2R10e6hcPT73/++VqvdZ3oXmBFsNvvi xYsxYXuE+klY0ocbaQoEApcvX37y5InZbGYymW63u7y8PPLWwV9IJAJhu8HBQaPRGCEgJgjiyJEj Uqn00GdIDAUWc09PDzQHSDQ0s1WIjW4kHR0dJBpAUXRhYWFoaCgYDLpcrp/+9Kdf/epX/+Vf/mV5 eRlKk/ZZ2gZVP5D3t/8sPTab/fTp0/HxcQaDcYgc7R6PRyqVlpWVffbZZ1BKg6Lo+fPnORzOF/Hr WAl0XTCZTENDQ1ar9YX+YNJJX11dDXyecbvVgxYURR0OR3d3d319/f5pb+Mg4DDu7e2dmZmBHtXQ 6g48xxiGoe+9997s7OzQ0FBGRoZQKJyamqJQKOXl5ampqTabbWJiQq/XR5i5AiGx4uLinJycfSos sgSmr69vdXU16vPESkCB1tfXxzAl8wsJFwhv3759O0KWGog3lZeXZ2dnJ0LRR0zkpYMyuwuO4+vr 61euXCEI4u7du3Q6fXBwcHFxUalUer3emZkZuVwOXpb5+fnR0dH19fUIWwb6/f7k5OSysjKRSLTP fBfI0gMdCBbd4e5YUC95WO2pX3kB8Do5OdnT0xNJDgNJ/n706FEej/dSr8dweemgzAsFz8nJkUgk wK0pEAhyc3PlcjmTyQwEAgwGQyAQQIpQJOk5MBZLS0tjY2OZmZlsNjtqLQPgiUqlZmZmOhwOu91+ iAFLuG5DQ0NWVtb+3VfQ/+zVi7/uU6C0xGg0SqVSj8cTSUoEhmErKytDQ0MCgUAkEm1ajSiKAmvw Ad94LAWsQIPBkJSUlJaW9rL05dlJwEV/5MiR0dHRn//856mpqTk5OSqVKjk5WSwW5+fnp6amAic9 9OHyer0ejycSJAFuPK1Wu7y8nJubu594EwmMeDze2tpa5BkVByGhUCg5Obm5uRnZX2kJOLYhg/ul nkIxF9hWVldXoT/G2tpaJHomEAjMzMzodLrc3NxN/CMw1BQK5SUiKIft1WazLSwsQMfoxKnmi1rw Y8eOSSQSCoVCpVKnp6dDoRCPxwMIAjZiWlqaXC5HUXR1dTXCDRjH8cnJSYlEwuPxonvBcGko38rI yCgqKjIYDG63O/70ViiK4jje0NAgEomi2Fpg5dBoNKFQeP78+dXV1ZqaGqPRGBNKnldPGAxGXl6e x+OxWq2RrC7QI1NTUwwGQyKRgOImS3nffPNNg8Hg8Xjic/P7FNKDOjs7m5OTIxQKX/Z9CBoqlZSU mM3mrq4upVIpEAgQBAkEAhqNRigUAmgAFMtiseRyeVpamtPptNlskawO4IGdn59XqVRRW00EQTAY DDhbUVGRUCjUarWxLZiKUKB38ZkzZ6LWmWA91tTUZGdnU6lUpVKp1WoTh6wrQQS2NujiCZgmktEG nkmNRhNeTwdNfE+cOFFSUqLVal+K1Qp7q9frbW1txXE8Nzd3p0a2L5fg9fX1ycnJFAolGAwKBIJt U+pQFBWJRMXFxVNTU1DaA2xO5JKD/R72FSgHoNPpdDo9KSkpuk6kMNvC830KCgoWFhbsdnucowk0 Gi06TguIgJSUlDQ3NxcWFvJ4vGfPnpWXl7e2tn6BY7YVFEW5XC6GYVar1WKxRKjQYbJBmhg0ag4G g1wut66ujk6nw5x5KXxgZLH6+vq6VCpNTk5+eaEMqMv19fVbt24plcqMjIzBwUGxWAxmEo7jIpFo q5IB3K9UKjkcjs1mu3DhwszMDHTZJH8GCwfDMAaDAf9nsVgMBiMpKSm6WyU5/cD45vF4mZmZk5OT cdYzwKJ+8uTJKOwlFEUxDLt8+XJVVVVpaens7KzP5+Nyue3t7Ww2+4soVbgAbqbRaBwOx+fzWSwW p9MZIdSD96JWq+VyOeQzeTwelUpVVlZmt9vNZnMUhcDxF5gtPp8PkkkAmb28UAYyE2ZmZv5Xp/D5 fCaTOTs7GwqFuFzutiZOMBgsLi7u7u7GcbyysrKiokIoFFIolPT09MLCQpVKhaLoyZMnc3JylEpl Xl5ecnIyBJ73P0YAC5RKJYIg6+vroHf2ec4XClg5jY2NDAYjcpsPjkJRtKamprGxMS0tDfwESUlJ GRkZn3zySXxu/uUVHMefPn1qs9ki30sAzYADRiaTBYNBsJ8mJycvX7585MiRqakpl8uVyCk1QJHX 0tJiNBq5XC5Ee18il/VWAYN1cnKyoaHB7/e///77GIbR6XQ+n+/3+3U6HZ/P37oQwKMmFAoFAkFH R0dhYWFJSUlJSQmO4wAyjh49yuFw0tLSamtrZTKZSqWSyWRsNjsm9wywhsViAdewy+WKyWkjuWhe Xl5tbe2e4tcoirLZbCaTee3atcrKSvAtQc/59fX1Bw8ecDicL3DMTkKlUi0Wy7Nnz/aqFnAcn5iY kEgkHA4HQRCn0/n48WMajXbhwgWxWDw6OprI9HrgbrDZbLdu3cJxnMPhSKXSl9orA8tnaWkJ/5u/ +ZuUlBTwnvF4PChD2Pap4EO/389gMOx2++rqqlarpdPp1dXVKIpSqVSoxz64O4ZgE4qia2trwWDw gAABXIjNZl+9enVP+cvgmgLbqKioKDk5GdmwNYEI64MPPsBx/CWdMXGTYDBYUFCwvLxstVr3imZM JpPdbs/JyQE7e25uTq/XJycnG41Gn8+X4J4wgiBmZ2dXVlZqa2vz8vJe6uxyiNoMDw9PTk5evXo1 EAjo9fpr167BC8UwTCgU7rIQwHQG63l5eXl1dVWtVhcXF2dnZ4OaIoPgMb9z0jmUkZFBmuwHtGYh l6i4uLipqUkgEES+nQSDQYlE8sYbbxQUFKhUKhhV0OkUCmVgYKC7uxss0oO47VdAQMlzuVypVBpF YIhKparV6uTkZIFAQBCE0+nUaDRQHjU7O5vIJhPY1U6nc2pqikqlNjY2vtSJMuDJ9ng8vb29+J4a FxAEIRAIhEJhcnKyUCiUy+VkgsLB3S4pYLFJJBIqlQpoJubXBS6H5OTkS5cubXouHMftdnt9fX1a WppGo2EymeEQh8lkvvHGG0eOHKHT6cgG7EM2NOPk5OTdu3dpNFps7/aVFNAyCoUCx/E9YVYwOJaX l1dWVlQqlc1m6+np4fP5y8vL++/dfaACd37//v3V1VUWi5WVlcXn819qlwwIlUo1Go2nTp0KhUJP njwpLi6OpL0ULBkKhZKSksLn80UiUXJyMnR/ixs5L5gfmZmZdrvd6XQehK6Hosja2trS0tJNzA6g WF5//fX5+Xmn00lujaRz+urVq5C/GH4I5Iw/ePBgfHz8i7jSCwXgMoPBUCgUVqt1T5gVFqxGo2Gz 2dnZ2UNDQ3q9ns1mLy4uJrK9BPbeysrK/fv3GQwGi8Xaf63x4Qq8L3hxe4Myhy5geXA4nLKyMiqV GtsOlBiGeTye9PT0s2fPbsIx4P+nUChms9lms9FoNJ/PFwqF0tPT33jjjdLS0qKiIpjE4UdBLMlo NLa0tGyCPl/ILgIqG/q5Ly8v7wmFwC7I4/FYLJbFYpmcnExKSuJwOIkMZVAUdTgckOLAYDAyMzO5 XO5LDWVIr4xWqz179mxRUdGefGyJI0BXuLCwsKeI5wsF/DEnTpxQKpXhQSWAUGw22+/3GwwGdIMF IxgM1tXVNTQ0lJWVSaVS5P/XM+SBnZ2dU1NTh8KT/pIKqIv09PT5+fm9ZinBJOfz+ZDiZjabxWIx RJcSc+UCeltaWlpYWCCjSy81lAn3yuxrcQI4XVxcXFlZKSoqgvZdbrebyWQe6LsEg0apVLJYrO7u bjQWDZvIjm51dXXhBZkQNrp06RKfz9/WONtp4gIp7dTUVEtLC4fD+cLZuyeB4peysjK/369WqyPU zhAagBD4hQsXqqurb9++/fjx45MnT6alpcXhtqMTu93e2dkJCcuVlZVSqXRrdCkYDHq93ghPyGKx DuA29yAARmPozACDcmxsTCgUpqWl+f1+ICg/aAsBRVGPx9PU1NTb26vT6WJic8PcPn36dFZWVjiN L/Ctnzt3bqdxA7yy9XNQNXfu3DEajV/4Y/YqYHCeOnWqpaXF7XZH2LATJiRYSkePHoUljON4bW0t OOYTUFAUnZqa6u/vh+5L9fX1yHbNfX0+XySRFlC2h5sYhIb1VNkXlCFz9KBwFJp6j42NJSUl5eXl QRAuRve8WcCDIpFIGhsbnzx5YrPZYnVaCoUSvmf4/f7XX389KSlpr3qZbEdOEER7e/sXptKeBPpX DA0N0en0+vp6rVa7vr4eIWaFfXR9fR10CoVCefjwYVNTU0pKSqIRwMNO2dHRASEwHo9Hhq5hf9Lr 9b29vdvS6oMyJetCA4HApn3x9OnTSUlJOI7HubQYypcMBoPX643VpSF6kpeXhyCIz+ej0+lLS0tT U1NyuTwzM/NAPViAPGpra/l8/vj4ONl8d5+npVAoZFUE2FFSqfTcuXNRZAGCqmlubm5paZmdnf1C 1exJwNM/MDBQUVFhsVhmZ2cjCYOC4DjucDhcLheKojQabWVlpaurq7m5OdEYoUjg9fTpU5geQIsA AlOup6fHaDTu1MGDdE8QBOHz+WDFQT6GWCwG+z9W2feRC5RiGQwGGo0WS5epz+d7/vz5/Px8KBSC KrXu7u6UlJSKioqDWFroBn3IiRMnnj17trq6Gt1VICf3xIkTBEHMzc1tcp8IBIK9mmJgPLlcLqfT SaVSv2hxEIVARzeVSgWePwaDMTAwEEnzFLAVIFGmsbERtDy8Yj6fnzj6heyEcvv2bRRFgdu6vr4e Iu5arXZ2dpbBYLjdbog6hR8LkI7L5ZaVlUkkEnAikgTZnZ2dDocDx/FHjx7B7ykUSkFBQU5OTtxy 2nw+n95X0pUAACAASURBVNfr9fl8sFX7/f4YtoGk/z/23rO7jfQ8H5+C3jtIAiTYe6dIURJVqCWj tXe1ln1iJ5uTT5C3yRfwB8h38IvkxPFxXLK7WluyCiVR7EVgAwGCIIneewdm/i/uPyf4USQFgmDV XC90IHAw80y7n/u5y3Wx2Xa7fWVlJRAIRCKRbDbL5XInJyfv379faKDLCFg4tbS0sNns1dVVYCIp zZvJ5XLffPPNu3fvUqkUtTqCkxKLxaUNj2IuOErQisYxAHN98+ZNkiSrq6tRFDWZTLC0OP4WQ6nN +vq6TCaDOCh4RZFIhMvlntfwPw0gONbr9fPz8wKBIJVKSSSS27dvh0KhdDo9NzeXSqWAounQak4M wyorKwcGBqDRCdlfZ5pMpqWlJRaLFQqFvv/+e9hYLBb39fVJJJLzOTXoh0+n09lslhEOh2GqOKWh Ab7tGzduCIVCi8ViMplEIhFQREul0jOSp4dHh81m3717N5vNPn36tLSXGaYBCFkzmcxUKgVykt9+ +y3YrBLSn0wm02Qyrays8Hi8Mw1QXVfATQmFQiDlU0KGDkVRoVAIT/i7d++++OKLmpqaZDJ5FqM9 6cBIkrRYLHNzc+Aow2T25s0bYE4yGAwgVwSPjVwuf/DgAXUF4Mr09PRUVVVRlRbwLrBYrLGxsVAo pNfr0+l0MpmE1vSVlZW1tbX6+vq2trazrkyE4Vkslmg0iqIol8s1Go1v3779xS9+kU6nD7hlJwUs mSorK2EWsdvtBoOhpaUFx/Hp6WmgTjiLIA3QV1RWVjY0NBiNxiJp7w8FyP9iGIbjOOTKe3t7b926 BSTgpZmv169fRyIRYOOkTU1p8Pl8IIAKHkzxjauw3IK4RTQanZiY+OqrrxAEufCiApi2crnc69ev oTAZJrh4PP773/8edFHevn1LLTNIkuzp6Wlra6Mma2j0gSZl6rmCdaZOp9Nqtbu7uyaTCUGQeDyO omg4HH79+jWPx+vp6VGr1Wd9gjCS7e1tJpPJePnyZV1d3c7OzuDgoE6nO007Ely41tbW1tZW+Kah oeHWrVsIgpyS7/+TIAiCwWB88803P/zww4lIgWG9DgybExMTXV1dkHuTSqW//OUvwYk50UjgIqTT 6ffv3xuNRjrYWzLgJZTJZG63e2dnh8/n9/T0oCj69u3bIgswSZIMh8NwB+FVhEqCi9W5hZFsb28v Li5C0TpEkn788UcwB9QjB6t2kiQLCUmpE4HczaFvq0QiuXfvXjweX15e9ng8sEOCILa2tra2tnQ6 3dDQ0NnFwDEMs1qtCILACCG47XA43r59y2az/X7/o0ePTuNOwYMhFApv3rxJfanT6eDDmXY5QbS1 ubmZzWa/fv36RHra4KZ88803ExMTXq+XzWZjGBaJREZGRnp7e3O5XGnXxOv1/u1vf0ulUhfCUHyd oFarjUZjIBDQarXNzc1bW1vFVOnBbU2n07FYDCQn4S6IRKJQKHSBfc5gHFKp1Pz8vMPhgAZAEH+d mJg4EFaEs4DkETVg+PIo8kn4a319fW1tLSh0UoUZiURiamqKwWAMDQ1VV1efhb0l92W0nU4nj8fL ZDIYiqI7OzsYhk1OThoMhssTgT8p4Bl6/PhxQ0ND8eFfkiR5PB6fzydJEiY5rVb785//vGS2e7Cz b9++pf2Y0wNSFWq1ur29HcrUp6eni28kgYf51atXiUQCqitaWlrq6+svypUB45LP5zc3NxcWFqhm BwzD/vd///eAH0P9BEEQkUhUwizF5XIfPnxYW1tb+BCiKGo2m7/77ruzi04BSxuCILAughcTuAyc Tmcymfzxxx/LVdx2/oDSGY1G8/XXXwNJWpFAUVQkEoEYC4ZhsVhsfHy8u7s7FouVPBhorAX2cNqP OSXy+Xxrayt0Mz1//nx3d7dIsXTINDkcjunpaS6Xm81m4/H4nTt3LpayBUVRcCmcTidQZnM4HKvV OjExcWjuDIZ6Iu8c2TdQ1dXVX3zxxYG0GkEQr169mp2dPYsrQPXSV1ZWQq0Sgzoqh8OZm5tjs9l1 dXWxWOyKNg/n8/nu7u7h4eFXr17t7e0df2OolkiVSrW2ttbZ2Tk4OBiLxVgsVgnZPqjT/P777x0O B5fLLfI1oHE8YObAMOzevXv5fH5ycvKTph8SHFwuF7ZEURRi7xfrpkMo5cOHDwsLC3w+H8wcpQcO j8qBNw78ALFYfO/ePaqkF9y7rq4ulUp1vE8GFR59fX3d3d0LCwsWiwVeByipefbsmUqlGh4eplLg 5QKTyXz69GkqlaL4NgvPC8fxTCbz6tWrx48f53I5BoNx5aZhWK7weLyxsbFkMvnDDz8gH3VHHwCV B4cSur/7u78TCASJREIoFFJRwyKPDqvhUCj0+9//HqJ6dH1MWQARepVK1d7ebjabV1dXP1kxA9ph JEnG43Ecx7PZbCQSEQgEF/484zj+448/Qm6dyWQCh7XRaFxcXKTS1oWAL3t6elpaWqC4k3rIb9y4 kc/njzkjKrX96NGjUCj07t078K3Bqdje3t7b22tra4PlaLmeVeiEdzqdL168EIlEyWTy//YLpvbd u3fr6+sgiF2WQ54/wEF58OBBb2/vJ200VDCtra2BJCFE2MRi8U9/+tOTPo4gHlSuBgcaADAWmUzG 6XQSBOH3+4VCoVgsPsr0Q/GjSCTq6OiYnZ1F9h2C8x314Xjz5s3S0hIkuSBQkUwmv/vuu6OeUhj2 aRYV6D7dXH9/P+h0UoU1CIJ4PJ53794Fg8FST+hwpNNpeI8oVdoDG8AL8qc//QmKDK6oxw8WnMPh PHnyRCaTfXJ7OGso+KWqZPr6+np6ek7kjsCs4/P5Ls+DfT0Aoj0ulyuZTMZisVQqJZPJjlkMwyqr s7MTRdHV1dXLE4OPRCJ//vOfo9Eo5BxhZl9ZWTnKj0H2TQ2IMZ3m0BKJ5O7duzwej3r3QdpsY2Nj YWGhvE5FPp+HxgJIofw/sXqwel6vd2VlRSQSVVZWXlGeLmxfkpfH462ursKK9tDXHk4ZnFDId5ZM QAILaErPgrYyZQEEIZRKJWSIKioqOjo6NjY2jrm8UHoiEokCgQCDwRgdHY1EIplMRiAQTE5OIghy ntwb4Iq9ePECGh3ZbDb4MSwWKxgM/u1vfzv0UYEvW1paent7k8lkYQUbQRBCobB4BTiYcQUCgVwu 393dPXCsYDD4/Plz4LAu1zWx2+3F0CsDywWHw9FoNHw+/4qaGrgLDx48mJ+ft9vth1bqUN8wmUz4 bzQaZbFYpZ0vBPMkEglkJ2k7Uy7AKqi1tRXqDVpbWyUSyerqKnQdH3qdQbk2nU57PJ7q6mqlUgmd kvl8Hpp6zi3iCEYvHo//8MMP8OpR/QR8Pn9ubm5ra+tQPwbayO/cuSOXy6HxkCr4xXG8hNS2XC6H MAlVPQ3JIIPB4PF47t+/f3r1Hpi14/G4y+WiKsz+H1cG7qVarW5qaoJ6yatoXADQ6aDRaBobG61W 68zMzDEuIYTCgFGgq6vrpMeCq/Ts2TOn04miKExXpxo9jY9A7hOhQg/zoduAP1pRUdHW1vbixYvC qhp4mM/f9GcymZcvXwaDQSrhCGWwLpfrzZs3B8YDtqavr6+1tRXCvIVsjSUD4pQg+Do5OVnoyYEF fP369e3bt2tqak753MKLYDKZihk2SZJNTU1Q7np1VWAAJEn29/cPDw/Pzs7u7Owcfy4sFmt6enp4 ePikSiaQwoY631wuR9f5nhFgpcFisfL5PAQyD40sJhKJW7duRSIRg8FwYHV0/ik/DMOAg6rwqYB1 1Lt376xW68d+DIqiX3/9NRWJKZcAUTabffjw4bNnz9xuN0WgV7h4Gx0dPSWLILgykUjEYrFQlIYH ozIsFstut8tkMqVSeUXXSYWAcgGNRvPgwYPFxcVQKHT8y4/jeDqd9vl8CoWieDMBW46Pj//xj38M BoNl1FKgQQFmfavVarfbj7q88AAHAgGIvlBfisXiRCIBXfHnUPMLQ/X5fFNTU5BwpHp5wKDo9XqD wfCxcflkmBd8tYcPHyoUihPR/YHlbWxsFAgEU1NThfuHrPPk5GQqlWpqairt0YXYz9bW1sbGBrGv /X78rlAUNRgM7e3tMGdcdVMD4cOhoSGxWLy5uflJmjUcx4PBoEqlAh+3mNOHB0alUj148OD7778/ aYUmjeKRzWZXVlYgcnboYwyr35WVFfgvBB6YTKZQKAQOiHOo0AB7Am0EKysrHA7nAFVxKpWamJgI h8OFrdQUeDzeMWn6dDqtUCju379/UlpRFEWTyeT4+Pji4mKhVCe5z6T1/Pnz+/fvn6hkngLsJBaL zc7O2my2Qr/tYFQGJoPLLFN+UkCoSSAQPHz4MJlMzs/Pezyewr+CqBOfzweZFZfL9fLly7GxsZPS bV11W3yZAfOEVCp9/Pjx2tqaxWI5dDOwL2w2OxwOF/orBEGIxeLikzKnGSdJkjabbWZmBgZwQF4n k8msra1BzyBlXOBX4+PjEokEmiHLEoz5eGzpdFqtVt+7dw9K86g/QcXY3Nwck8mkAkIn2jmcXXNz s1wun5qaymQyxeyBx+MV1u5cdYCpqa2tbWlp2dvb0+v1UA1auI1UKgXaKgaDsbCwEI/HBwcHT/pk Xo/LdTkBxQl9fX0ajUav1/v9/kOlDMCkpNPpwlJWCJtBS/aZDpLcJ4z58OHD9vY2h8P5uOYsFArN zs5Cdw9VWk6SpFQqHR8fpxyUs/CGIYIwMDDAZDI3NjYO/AkC1YUBoeJBETEMDQ1JJBK9Xk9Fuw/2 teZyOblcrlAorhlHLVVlPTIyks/nf/jhB7C20Hnf2dkZCARWVlZ2d3ez2ey9e/eeP3/+D//wDyd6 Ij0ezzWIY11mwLpHq9Vub28jhxl0eE8OzKMwhY+Ojp6pcAF4A3a7/cWLF1wu98C7AzN9KpXS6/V2 u73Qj2Gz2Y8ePYISq0/GeGGl8fLly4+/r6ysbG1tpfYgl8s/DoyDRyiRSB4+fPj+/ftwOFy4By6X u7KyguN4Q0PDSWNX0Iql1+uhHKeY35IkWV1dzWKxyhXZviSAS6FWq3/2s59tbW29e/cOCN1h+rl1 69YPP/yQy+Vevnw5OjpqMBg4HE5/fz/MgsfvmSqiBI3Va7PavGxA9xmt5HK52+0+NJEH7U5IwVoF 3ZfxuXfv3pkKF0D5y5s3b8xm81H8q36/f2ZmBoZB1VTV1tbevHkzkUh8cnhgZyKRyO9+97sDf8Jx vK2tTalUQsktCGp+HFWlylW5XK5ery/shoEPb968GRkZOSmhJQzM5XLp9XqQpqHO/f9cGUjMNzY2 HhA5u2aA1c/jx48XFhbsdjuO436/PxwOS6VSkUgUiURgg1gs9p//+Z//9E//hKLo8+fPBwYGZDLZ USsneIhfvnyZSCRYLFYqlYIcql6vp9XdygV4iEOh0KtXr06kUZzL5UZHR6mAR9lHBV7y6uqqwWCg CnsPbAP5naWlJY/HA34Mk8kUi8VsNntoaAi6DIo5HIqioKRxoMImlUo5HA63233A5nI4nObmZp1O R1WjU303o6OjXq93amqK6jgFC764uAjFj4d6M9lsNhwOCwQCYGpPJBKhUIjP5yeTyYmJCSj++ORF hgvS19d3PVJLhwJMeV1dnUgkmp+fB3FNl8tVWVmpUqlsNls6nQbZmqmpqVQqdfv2bYfDsbGx8cUX XxwfobFare/fvwfmVjabPTIyMjk5mUgkitRBpPFJgK+wsLCwurpapAGH9ZJSqbx79+6Z+jHRaHRq agrYJT7m+wCXxe12z87OUj1EIpEIx/Ha2triOffBRxGLxQf2j2FYMBjU6/WFOwHTIZfLOzo6Clv5 CkmBNzY21tbWCgccDocnJibu3LkjFAo/XsyQJJlMJpPJpFwuh/MKBoOpVEoqlS4vL29ubkJAt/CB R588eQKfmExmTU1NU1MT1UlV5MW9ooCpEQjddTrd4OCgx+NZXFwMh8NKpfLRo0cQORwdHQVhjqPM BKx0/+u//uuLL76YnZ0NBAJ0rUx5AXfK5/PNzMwcVfB71A+hu0QqlZb9jsDOQXfMarUeVYNJdTDB SprqbpPJZOPj48UI12EYptFoBgcHizGpwWAQxIkKf55MJltbW4E6UigUFu4HDBPVj02t4VpbW7u6 ug7wQECNsMViMZvNHR0dPB4PVLGWl5cPvS9MJnN3d/ff//3fEQT513/919ra2kwmgyCIUChsbm7W arWfQ2iB3NfGmp6eDgaDAwMDOp3uw4cPOzs74XD49u3bnZ2dPp+vurr6/v370Dtz6CMBYRu9Xr+9 vd3f3//jjz9eUeqvywzIUOv1eqPRCCKLxVxheMW0Wu2tW7dgtVDeUcFbCYGWo6hZqA6mH3/8sXBg BEEMDAw0NTV90olBUZTJZPb09BRDIkoQxM7ODtSEUVcJ/r116xawzlK+NayR9vb2NjY2wAJQ4HK5 t27dguapwusG8fX19fVYLDY8POx0OkUi0d7entlsPuq+4NDXQBBEVVVVa2urQCD4HPwYZL9QSyaT 9ff3J5PJqakpmUzW3Nzs9XqDweDu7i5oGW5tbTU3N4N38vFlgTWuz+erra0FGb8TBQxoFAN0v51Y rVYHAoEiiZgh8vHFF1+cReoaVgmZTGZxcdFmsx3vvEKBJ7yB2WwWxB1v3rx5VOwTvuRwOF1dXXfv 3m1oaNBoNEWeApfLra2tbWtr8/l8FH0wSFltb29bLJZ4PC6TyainlMvlymQyp9MJZCcQL0kmk3w+ v66ujqLrBY1rs9k8OTlpsVhEIhGKohKJJBAIvHv37iiLj+N4OBx+9OgRgiDPnj2TSCTZbJbJZDY1 NdXW1n4ORgbZn4dgWdzS0mIwGDY2Nvr6+phMZiwW29raQhCksbHR6XRGIpGmpqZDQzLkPl0ym80G pXdgZruIE7rOgPi6RqNhMpmBQKAYTgEq/AYSPeV9qsEJCIVCkUhkcnLy+PFACbDf7+dyucDtJBAI RkZGNBrNMbV3KIrKZLKRkZG+vr76+nqRSFSMA4CiqFgs7uzslMvlDocDVkfgxtlsNovFsru7y2Kx wFDA0wvVipAJoQYci8Vqa2tFIhFkoLLZLIIg2Wx2cXFxdnY2EonI5fJ0Ol1VVTU9Pb2zs3NMEhZ9 8uQJQRDt7e1NTU1AC/iZmJhDAY2yPp/v6dOnQqHwq6++gtsTj8d/9rOfVVZWwoREbQ/r8mAwqFar X7x4AZ/PomaTBoqie3t709PTnwx6gdOp1WqHhobOIrsXDAbfv38PcrJlnE7AY5NKpUwms6GhQafT nZIcM5VKAQMedcXgcQXLVdgPGY/Hp6amAoEAaMHmcrnm5uaqqiqpVDo7O9vU1CSRSJxOp8vlOlF1 amFU5t/+7d80Gg2Lxerv71er1fQ0DFmM2dnZubm5wcHBoaGheDwOPCW/+tWvPr4+4D1D/vrdu3cs Fsvtdn/OtvqMAJ2Gs7Ozu7u7x/eIwSRNRTLKS2ULfsnW1taHDx/KHuaH/cvlciaT2d/ff0r2EBRF 7Xb7+/fvCyPT4OF1d3e3tbVRR6RaIoAicn19XafTKRSKzs7Ovb09n8/X1tZGEMTu7m4kEjnps41+ 8803P/3pTwUCwTUrvisZ8HTGYrHvv/+ewWB8/fXXbDY7n8/jOB6JRB48eNDe3n6U9huKon6/Hxa+ AoFgeXl5amrqfBrzriUg3muz2ZaWliBA+kknBtIxnZ2dp1RgLgSs1YBnb2pqCjmbFhKBQDA8PCyV SsuYa4cBFxI8oPt85Ldv3xaLxdSWqVRqenra7/enUimCIKCUD66nUCiUSCRWq1UikahUKqvVCvLd nzSvlCuDYdi//Mu/3L17d2RkpMhs/ecASsticnISInDQbAEX9ttvv4U55tBgcC6Xc7vdOI6rVCoM w/7whz/4/f7r1Hl6/sBxfHl52WKxFLmeZ7FY7e3tOp2uXG8rRC/C4TBBEHt7e+vr62Xvt4c3urq6 enBwsIyzEoqiHo/n7du3ha821PA1NjZ2d3dDsxI82y6Xa3p6GkGQQCAgEokoogoGgwEUMJBvZTKZ QOtX5Bjwf/7nf5ZIJLQTQwESTywWq6WlJRKJzM/PU5JMbDZ7e3s7GAxWVFRQWoAHfs5ms6VS6czM DLA9SiSScDh8Gh3gzxbgx1gsluXlZcjdHlOuBA5oc3Pz8PCwVqstS5oPLEs2mzUYDJOTk1ar1Waz nUUuHEGQgYGBiooKoVBY3kcFx/GKiopoNBoKhag1EwRyA4EAVM8g+9VISqUyEolAdomKGCMIkk6n wbxWVVXZbDbIohYzZYJd/slPfpLJZJaXl+/du3edWq9PDwiSVVZWajQao9FoMpmUSiVo8qEo+uHD Bw6HA51oH/8WwzCRSMRgMP77v/97fn5eLpcTBHGmBafXGyiKLiws7OzsFBN3FAqFAwMDfX19JyXs OH4AkUhkampqZWVlb28PmMrLG/TNZrMKhaK/vx/IR8q1Z9g5j8eTy+U2m42aFsE78fl80HYKsRIU RQUCgUgkcjqdLBaLMndgw+PxeDQaheGZzeYTGUP0N7/5TRlP6foBw7ClpaVQKNTX1wfVSaAtXlFR cffuXYlEcsyjD5V6e3t7T58+pVuZTgSqe9lsNlssFuivPurFZrPZra2tOp3u9Mt9cF/8fn8+n9/b 24Ps7BmtdOFYWq1WpVJ9+PAhm82mUqkHDx7U1taWK3RRWJsMSr/AaKJQKNRqdUNDA3VqlBjZ2toa WSZGfCaTabPZfv3rX3d3d//2t7+Vy+V0ePJQkPvUjouLiyKRaGBgAGwFxc/R1dV1PPcMmJq//e1v W1tbtKkpAcFgcH193efzHXWR4aWQyWTd3d0liA1/DKrOEjgzobLt9Ls99EC5XE4gEDQ2NqbT6bW1 NRzH2Wz2119/jXyKx/Kk8Pv9QCuF4zgQtsnlcp1Op1arqbQPBAsmJyd9Pt9RRe4lAKc6mGgcCpIk KyoqamtrqWAvzECpVGp1ddVkMikUCoFAcOhvqX4QsFNtbW319fVutxua8mkSmmOAomgqldrc3LTb 7QRBUEGCfD4fCoVg5UqSpFQqvXv3bnd3t0gkKsvcHwqF3rx5YzAY7HY7sGSefp8fA1ZIcrn8iy++ mJmZoermmEym1Wrl8/lKpbIsCV94Ajkcjsfj8Xq9FAWFTCbr6uoqnPBgSFqtNp1Of7KQuUhATnZ0 dFStVoPeHp3+OBRg3Nlsdm1tbWVlJXWVwNT4fL65ublYLKZWq4/pP8hkMiKRCHrKBgYGuFxuJBJR qVQllB18PoAr4/f7V1dXY7EY5WpDkXUmk+FyuVBdUFdX9/Dhw5qamtNnruF2b29vv3792m6322y2 s6vugNLaO3fuKJXKyclJSvU6n89brdba2tryLtUYDMb29jaUJ8MZNTU1Ab3LgRrTuro6i8UCGtrl OXRZ9nItASbj9u3bTU1Ni4uL6+vr2WyWuvEQPUulUs+ePUMQBMfxW7dusVgslUpVmLFGUVQkEg0O Dg4ODsI3LS0tuVxufn4e+hGCwWAhUxkNFEXD4XA6nd7b23M4HODwURFLHMeBukCtVg8ODsLcfBqn EMyKw+HQ6/VUa/TZUXSAEWEymTdu3FCr1X/84x/PqHUftMQXFxe7u7sdDgeKoo2Njdvb28fo/qAo Cm3bkFOjefHPBxB6UavVo6OjDAbj1atXXq+3cAPwcnZ2doDAs6qqCsS0D/S1sVgstVoNS20EQZqa mm7fvu31eqHJFuhGDrTCfs6AWEUkEonH41tbW6FQqPCvEFGAtWtXV1d7e3smkznN60AtgA0Gg9ls hhjzmRYegGXj8Xjj4+O7u7uLi4sHiBjKhVgstrm56XQ6BwYGZmZmWlpadnd3PxlXzufzQIlEKXif chi0K3MkYFabmpp68+bN4ODgr371KxaLZTab5+fnE4nEAWc2n89DV2oymRwcHJTL5SqVyu12B4PB 3t7eA31PDAZjeHgYPkNk2GazAZd8WQL7Vw7w1oXD4VQqNT8/X0jXS/ko4Dtqtdr6+nqqXrW0NxOM SCaTsVgsRqMROgALj3VGQPfp6RobGwmC+OGHHw74MRCLgr7EE+0ZSoW8Xu+zZ894PN7AwEAymQT9 cEomBkGQo9b01NEhzQS1vblcrrTTpHEiQGVeKBT63e9+JxQKQaUcQZB3795tb28X5jvgFfB4PM+f P4cHaWRkhCCI2traqakpUI04sL1CoRgfH6f+i2HY1NSUyWS66vqdJQPIKoFScm1t7eOFBLykIpGo rq6uuroagvElR03gmkcikfX1dafTSR3iHIw8QRBSqbSlpWVpaclmsx1IO5IkmUgkShgGlDDOzc0t Ly+3tLQ0Njbu7u7u7OwwGIyZmRkEQTY3N5EiJMFJkpRIJAqFIplMluVppGtligL4KP39/SqVSi6X x2KxxcVFFEWdTudR9wzsDofDyWQyKpVqbGzsqBsG3ozH45mYmCiUzPgcAGuj3d1dg8Hw8ZIRzAqP x+NyuRUVFZ2dnacpbAQPJh6Pb25u7u3tXcKQA4Zh8Xj89u3bxQshkftk9kajcW1t7ZPrm+NbGKgq GYPBAAJ1p7lKdK1MCSAIgsFg3L17F0GQ2tra+fn5QCAQiURAIe6YcjEWixWPx+/cuVNfX39g7VS4 cxzHFxYW1tbWqI6Ssz2fywF47GOx2MbGhs1mO2obiUTCYDC6urqgBuCU86vX611dXb2cQXd4Ek4k hATXMBqNLiwseDye48PJVCtGX19fbW3tUZ3qwOjm9/tPH5ymozJFAWK8a2trGxsbqVRKq9VCL2ss FpuamkJRFModCh99mIZB8CISiTgcDsgXVldXH7Ag2L7g7djY2MzMDIfDSSaThZqX1wwwYScSCb/f v7OzU9iACgD/Rq1WQ0qVehNKWxuhKOpyuTAMW11d9fl8F8LFTHHGCIXCj9NhJEneuHGjUEvlk2yb SYDVJQAAIABJREFU4Cj7/X69Xs9ms3k83sbGxul7cSEww+FwlEqlQCCg8xHnD7AGExMTKIq+ePHi xo0bDx48YLFYRqPRYrFks1mPx/OxT5NOp7PZLNgNPp8fjUbFYrFSqTxglICtZGBggM1mW61WDocD Ce6zq22/cFDZaqfTeeirh+M4EB0VvoMlmBpIFPr9/mw2Oz8/f4GMAyiKqlSqA/cUqqmUSmVXV1ch Oecn/RhwSoDbV6fTORyOcjHakyQpEokUCkUkEjn93uioTClA94Wa7927p1Qq4TYQBDE7O7u1tfVJ WgIURdPp9M2bNxUKRTabzefzYrH4QHAY2feCZ2dng8EgzFsgtHtFjU40Go3FYjiOu1wuq9Va2JQE ZyoWi6HIbmBggMfjlVwBg+5TZIIQehmL5EsbDEEQ0L2pUqlOv9SDtc7u7q5YLObz+dvb29vb29Fo tMgHoxhiCRiz2WxeWlo6jc2iozKnB0yQHR0d/f39ECTDMCwQCExOThbKUxwKdJ9DCDR0EQQhCAKI CgvvKTwS8Xh8cnKSyWSmUimv13tFM1BwyuFwGEpbtre3/X7/gaQbm82WSCQQg+nt7S35lQQ3COim 9vb2jEbjKaOYpwTFqjUwMFCWeBuoB9jtdp1OF4vFTCaTzWYr0iwXGZVBECSdTs/MzLhcrlNePToq UwrIfRq9p0+fwucbN240NTXdunVraGgIx/Gtra2lpaWjmMSg93JpaYn6BnwjuVze19dHvVoEQdTX 1w8NDUEJvcvlmpub83g8ZSmSOmuQ+9IzU1NTlMQPsh+fgCYdFouVTqelUml7e/uBZdCJWKfhWOFw OBqNBoNBWLwWHrFcJ1UCwG0dGRmpqKg4qdz0UTvM5XKVlZVsNntmZsZoNH6srHZKQPWGUqkUiUTJ ZLJcu6VRAuBemEymra2tbDZbWVk5NDSkUCi++uormGnm5+dBmObj5xzm2nQ6/eLFC+pL8I26uroq KyshTpzL5fh8fnV19djYGDxIq6urer0eWmovv6kpJKD6mLVBIpEAXVMqlWpublar1YW+SwnRFxRF PR5PJpPZ3d31er3UsQ5VqD43gFngcDhAcV6Wuwa5ztra2nQ6/fr1a+g2Kq85hWWeSqUKBoNUg3Bp u6KjMuUEzNPt7e3d3d3QMGy32+fn54PB4OeTlj43oCjq9XozmYzVanW5XJfw8oIf8+jRI6VSWRa1 eVhT/uUvf/H5fKWlk4qJylBl0UajcWNjo+R+Ljoqc3aAAu2bN28C22w+n9fr9QaDAeabS/guXF2A y+jz+VKp1NbWViwWu+gRHQS6L0jy5ZdfloUmkdwX8PnLX/5Smp0pMioDpiYYDC4vL3+y/uZ40FGZ cgLmCYPBsLm5mclk6urqGhoahoaGKisrw+Hw4uLi3t7eRY/xCgNMtsVi0ev1yEWHW4pBNpv9+uuv RSJRWfwYZN83Ghsbe/36tcvlOqmVQffJshoaGmiv4koDw7B0Ov3mzRsEQUiSHBgYkEqlP/vZz/h8 PsQnICtN+zQlAObXWCwGxLunlCg6a0DbY1VV1djYWFnivkhBBcWXX375/PnzEprGwVLV1dWViyLr k6BdmTMBOKQ2mw2q5UHUpru7Gxr8oIkgmUy63e5wOExbnKMAmaNoNGo2m+12O6WJffmdGEBNTU15 s4GQmpyYmAC+u9JWS0CnAeUCR20DjWMajWZ1dZUWe7/kQFF0cXER2b9xTU1NfX19XC5XrVZHo9HF xUUMw7a3ty+2aOzyA/oDzGazz+ejEnbFN/hcCOCOCwSCqqqqMkpBg50JBoMTExOlTU9UAVYqlTqm CAbMUUVFhUQicTgcp2lcoI3UeQCoBd69ewf/xXG8p6dHJpP19vYKBIJ8Pr+7u7u7u8tmsyORiNPp /Jz19lAUDQaDkUgEx3G32223268cLTKVxOnt7WUwGGU0MbBaGh4efvv2baFI5InGxmAwRCIR7T1f P8CDZzabzWYzgiAEQcjl8s7OThzHR0ZGEARJp9MrKytAX+Z2u49v8L7egEnU7/en02mCICwWSygU ory9K2FwwI/hcrnt7e0NDQ1lDH6gKJrNZkUi0Z07d169elVaVAbUUs+tFJp2ZS4A+XweVlFAV9PY 2NjY2KhWq0UikVarRRAkl8tNT08TBAG9KolE4hpbHKpA+P379xiGUfVf1AZXwqwUAsrl+vr6oLH2 oofzf4BLHYlEPnz48PDhw2NI8KhUVG9v7+rq6ufsW19dwNv09u1b+C9BEFAynEwmq6urhUIhgiBO p3N9fZ3P5yeTyZ2dnet9o6HAyGQyGY1GKNE4cL5Xy9RAEqe+vr54GqpzA9CXmEwmkUjU1tYGfGmH bgln0dDQEIvFIDBTms2kXZmLBNxvq9VqtVoP/InP53d2djKZTIVCAW+gwWDY2dm5BnTyFFVdLBZz Op2bm5sfk95e4PBOA1jNCASCr776Kp/Pn4X3SZIkl8uF0s6TFvyD1VCr1ePj45RKA43PBBiGzc/P w+e5uTnqe41GU1FRkclktFotPBIzMzOFjNtXGiiKBgIBkFEMBoOFCd8rfYKQvunt7e3v7z8LPwYi fNC8UvLw7ty509LScj5uFu3KXFLE43HggS7EJS9AOwaQNoKVkEwmM5lMm5ubPB4PIk/XNeB0FoBm 2pGRkffv31ut1mvg2tK4WNjtdrvdfuDLKzrNQzV0LBZDUTQajUqlUqqLGDlLbbXrB4qUaHx8/OXL l5e/0Ip2ZWiUH/AaAOE6SZJOpzMQCOTzeZVKxePx1tfX4/E4PQeXDLApw8PDOI5fj0AdDRqlAUXR RCLh9XpzuVwymbTb7dFolMPhqNXqXC63sLCAIMiZqjZebwAh7+jo6Js3b0rQhjtP0K4MjTIAwzAg CGcwGOl02uv1ulyuaDR6gDTd5/PB5+tKfUHV/fzhD3+or6/v6OhgMBhn4WdAi0FdXV0sFguFQvRy k8bnACgmBcpNiLu4XC6Px1NY8YrjeDabPUpo6doAVK/X19etVmtHR4dOpzujnmcURcVicWNjo8lk yuVyl9abuaTDonElgGHY9PS0x+OZm5vz+/25XM7n821vb29sbMTj8UsekDw7gFRbV1fX7u7uMYzd pwEU5VRVVanV6vOhbaBB40IAXrvf75+bm/N6vVNTUwiChEIhn8+3urpqtVrL2CF4tQClb1VVVSqV ymQynVGmHvbZ1NQEdMaX9lLTURkaJwDw5USj0aWlJbVavba2ls/nXS4XgiAgzyGVSlEUvbSe+/kA 1oV/+tOfvvrqKw6HU95mchzHzWYzqApkMpmenh4mk7m0tASFR8f/Fgqui2zhho2hz4UGjXMGRB3W 1tZA7XJzc5PNZkNNj8fjIUlSpVKVUPl+nUAQhEAgWF1djcfjDx48KGN1LUSX4/G4w+FobGyEtdn4 +Pjr16+L1JIEB7TIaDH0tZyybRt/8uRJyT+m8VkB2Kw9Hs/Tp08zmYzb7T5QCwY1dyDscoHjvAyA y7K5uZnP52UyGaSZyuLQEAQhk8kmJiY8Hk9FRQWO4zKZrLu7m81m7+3tHU9nR+kAV1ZWFrOWRVE0 Ho/v7e2VdkNBbG90dFStVq+urvJ4vM921qFxIgAlyfv37/V6fSqVgo6Bwg2gROYyBwnOB7C2DIVC ZrNZIBCIRKKy7BYcRBaLlc/n//KXv8CecRyvra1taWkJBoOhUOiYIBD8nMvlQs//8Ws5isjH7Xb7 /f6SY0uf+5RD43hAS146nd7c3ISOcb/fD1qDKIq2traeUS3IVQEkehQKhUql+jjRg+M4qFhYLBaT yQSMZARBnOaKQbnA+Pg4QRB/+MMf5ubmoF+jvr5+dHT0eAUWKMcuMvcHQoPhcPgzny1onCdCodCH Dx+SyWQikYjFYjKZjMvlisXi+vp6OpFKEIROp2Oz2YWqI1QEZXl52WKxbG1tWSwWUFA/JR8EQRAK hWJsbGxhYeHp06cmkwkYs+7evdvY2AhEi4f+EJa4iUSimEphihf4mB0WA9qVofFpZLPZ+vp6CGZy udxsNuvxeC56UJcF4M309fXdu3fvQIwXoiAmk+nDhw/Ly8uBQAD8g1O2VADL57179+7evet0Omdn Z30+H4qiSqXyyy+/rKysRPYz3AcAVo/P59PRERqXFn19fTabzev1crnccDgMxN8XPahLAcjdf/31 11VVVYVFeJQE+vLy8srKCuT9IRZySucPOpiePHmi1WpXVlZWVlYymQyCIL29vSMjI5DU/vgQEJXh 8XjnKftAJ5hofAJMJtPr9UK6NBwOy+VyDMNCoZBMJovH4/F4XCKREARx5eQFygVQnvP7/TU1NT09 PZFIpLB1CwIhOp2OyWSur6/jON7c3LyxsfH27VupVCoQCEo7KHgzMplMJpN5vd719XWDweByufh8 PpvN7urqyufz0Wj0Y0ODoqhUKi0mwUR1i3g8ntLuLJ1gonEioChqt9vFYnEoFEJRFCwMVIQEAgFo pUkmk5+nnUEQBMMwv9+fSqUGBgZUKhV8pvw84Oiqr68PBAJGo7GmpkYikbx48cJmsymVSqhEKfnS VVZW4jhusVg2NjY2NzdzuRyLxaqqqqqrqwuHwweaG+AoDAajqqpKJBJ9cmqAwL/b7Y5GoyU3Y9Ku DI3jAPOZUCjkcrlsNhtW/MFgEDg0k8kkgiAgYvLZ2hcEQXAcB3ILPp/f19en1WqNRiP1boMCVyQS gd5pg8FAEEQkElGpVGKxuOSDwq3hcDhNTU0ajSYSiQQCAYfD4fP5mEym2+2WyWQqlSqZTAJFGHDr aTSaO3fuFNNXRbsyNM4fMpkMnBi5XB6NRlOpVDabBVYqgiBoimrwZmKxmEajGRoaymazVqsVCvmp F5YkyebmZr1eH4vFoGi6oqLilK4MgiAymayjo4PNZoNNsNls6XQ6m81GIpGamhoejxeJRGD/IMhz +/btmpqaYsS6aVeGxrkCXhUul8vlcj98+PCZ1/ZiGJZIJEZGRtrb230+HxQh2u32tbW1ra0tBoMB 9XFU8AO0GpLJZDKZDIfD+Xze6/UymUyZTHaaYcBNYbPZOp1Oo9FkMplwOOz3+7PZbDAYVCqVqVQq mUziOA6JMIlEUldX98myA4ogx2g0UoLkJwXtytAoDfCsqlQqr9e7s7PD4XA+5ycnn8+z2eyvvvqK y+VCgDwej29vb6+srDidTo1Go1QqPR4PVfKPomgoFCIIAggyotFoNBoVCoUCgeA03gyYGolE0tDQ IBKJYrFYIBCIRqOwWFKpVJDmRvZvX11dnUQiKcbUsFgsu91utVpPwyn8Wc9GNE4JkiQVCsXnyc8G b+DOzk4ul3v8+HF/f39h2RpJkiRJPn78eGBggMlkgkNDkiRBEFDmBu1gzc3NZcwli0SioaGhL7/8 UqfTIQiC4/jW1lbJ6scYhmUyGZfL9Zmvg2lcOMBZl8lkn2eHARTYmUwmnU7393//9xKJhKruh/iH Vqv9xS9+odVqqetD9RYAMURFRUVlZWW56qYxDNNqtWNjY3fv3hWJREBvs7m5WfLOQdAGAkglTyV0 VIbGCUA9rBiGoSiaTCbj8fjll+c4I+A4HgqFgN1YrVbrdDqDwcBms+Gvfr9/Y2ODxWI9fPgQGL2A j4ESN2lvbz8L1hYmk1lZWdnW1sbhcAKBQCaTgZAMzAdarValUhVT2MRgMBKJhNlsPr7B+yhAN+aH Dx9u377d2tq6tLRElxvTKB7U8wlNf/F4PJ1Of552BlZBfr8/n887nc7h4eFIJAL2BIyJxWLZ29tr amrq6+szGAzUggpF0UwmU11d3dDQAE3O5b2APB6vsbGxvr4+nU5D1QF8D8XCOp0ONFWKicpAoXcx jDVHgabIo3EyQLW8QqHAcVylUhmNxkuuzXF2gCyM2+12u91bW1sIghzgqUNRdG9vb29vD0GQUxJA lTC22tra2traXC5ntVpNJhPkoc/h0BiGGY1GgiA8Ho/P54tGo9dVp4LGmQIKfuVyuVAojMVi29vb n630LHgDYGTgX8qegEHOZDKzs7PI+QpOQfMBi8Xq7+8HgW6j0Qj8y2d9aLC9sVjMYrGQJGkymWhX hsYJAM+uw+HY2dlRKpUIgigUCq/X+7lxh+dyuba2NqfTeTxV1FHI5/OwoDmHMkYGg6HT6VpaWnZ3 dx0OB8jsfXKdBIXMdrv9k5aRqqoxm80IghiNRupqcDgc5Ii2cBo0jgEkYaFUK5FIKJVKqCr7rFiO IOIiEAiqq6sLYy0n2kM2m62urlapVGXkAj4K0PRw48aNDx8+MBgMLpf7SZ8GrIfL5SpGSA7iN1ar NRQKRSIRh8NRyPVMuzI0TgAwMVqttrq6miAIo9GIIEgul6urq4NGSmiWud6zVz6f/8lPfhKJRGw2 WwnWgdKU+Z//+Z/29vaGhoazvlwYhmWzWblcLpPJTt/IQAGo5S0Wy8zMDIZhn2cdA42zAExRQCvA ZDKDwaDZbIYXp7Gx0ePxBAKB6901CZ5cdXX18PDwyspKaUYV3tCZmZnt7e3u7m6lUnkONIMEQTQ0 NIBqQXlNzYsXL7xeb6GpKbwmtCtD41QAt3pnZwcI9dlsdjgcvvaFwDiOazSa2traqakps9l8ohQv tdiqr69PpVJGo7GxsREKgc9otEADbzab4/H40NBQMesz6Nz2eDxer3d6evrjv964caOuri4ej2u1 WrFYvLOzA2Fe2ACmIo1G4/f7pVIpzdNK45SARVQmk9nY2EAQRKFQBIPBa89lBQVnvb29HR0df/3r X4/n8v4YUCtTU1OjUChgnanVas/6ZcRxfHl5ua2tTalUfnLAEAD2+XyRSESv11ut1gOLIrFYfO/e PSaTmUgk7t+/v7u7G41GA4EAMESAzWQwGE1NTbQrQ6NEANkam80OhULZbJbBYITDYQRBrnFUBngC Hz9+zOFwIHZaV1cHJXjFp5ng7U0mk3q9ns/n//SnP4V2p7MbNqzw6uvrEQQphuaBGqHL5aqqqjq0 MwBF0VQqxWazq6urGQwGk8lksVgdHR2F2zCZTJvNJpfLc7nc51lNReP0AOY3tVrNZDIDgQAsk3w+ H1JQGnzNAEQP9fX1IyMjwKSA43h7e/vKysqJUvmg0OR2uy0WS3d3N6w9zvpNzOVyt27dQhCkSJ+J wWD4/f54PD44ODgwMHDoNvl8XiQS1dbWikQit9vd1tb2scGkXRkaJwOsjQKBgEqlCgaDcrm8vb19 Y2MjkUhc+2AMAMpHoGxILpf39/fr9Xqn03nS8ntwF/785z/rdDocx3O5XHNzs0AgKH6tCasuCMWX 68qDHxOPx71e7zFeKSXO5XA4Ojo6fvWrX3m9XvBlKTAYDJVKdT5hbRrXDBDuBX1BgiCAFC6fz5vN 5s/ELUZRFEwNvGt1dXU4juv1+kwmc6IrAGRgGxsbLpersrIynU7z+fyWlpYTZYRBU4nNZpdxpQqm xuPxJBKJ43cLLKMul2tgYIDD4TidTvDwCn+C/uY3vynLsGh8JoApHFrvSJKUyWTRaFSv18vl8kAg YLfbyzitXirk83kOh/Po0aPCAAwY3FAotLKy4nA4TtNhAZ7B/fv3q6urgZ0dlqE+n6+urk6v12MY Zjaba2pqQE8Orr/P56uqqurt7T1KjI3qdURRFDj0PhnyZbPZNpvNYrG0t7eLxWLo9oQzNRgM8Xj8 gM9KkqRWq71169YBlwXoIh4/fowgyHfffSeVSs+htYHG9QDMc7FYLJFIoCjKZrMFAsHOzs7e3p5G owGZoWvpH0NIprW1dWho6GNBAKvVqtfrk8nkadaN+XxeIBB8+eWXyD4DFpvNNhgMEEC12WzxeDwY DBZKeGazWb/fPzw8LJPJjrEhKIpub29rNJpiGjbhuPPz8ywWq6Ghgc/ne71ep9PJ5XKBFf3jc8Qw bGBgoL6+/uPoMh2VoXEywBJBLpdT3wiFwvv37zscjmIaXq4oCgl1Cr+HCR7Onc1mn6b0FQLpk5OT 0DKdzWZBFhiMF1RbYxi2u7tbSKmpUqlIkvzrX/+azWbb2tq0Wi3kfQpHns1m1Wo1UlzIF84IGELV anUsFsMwrKGhAf5aW1sLUWvo3iIIwuFwBINBq9Xqdrtv3LhRUVFR2FZAg0ZpACYkHo/H4/GoL+vq 6mpqajY3N6/3AwYEMB+/qiRJbm5ufhyQOCkgHvzHP/6RwWCAerZGowmFQktLSwiCyOVyNpsN7WPU UQiCqKurs1gsU1NTYrG4s7OTx+Nls9kDC1eSJOvq6mD7Yk4T2peam5vFYnEsFhOLxZSWC5WtBqFv aFnKZrPv37/f29vr6enh8/mFZcV0VIZGGYCiKEx+ZrO5hFTL5QeldpTJZNra2nAcB89jd3d3bW3t NNIhZQfw4GEYBqEUmUwmFot1Op1EIimyDTuZTAJ3RV9f3/G8ZOAnhcNhl8tlMBhwHBeJRPfu3YO4 ER2VoVFeUDJD4XB4bW3tpKmWyw+K1E4ikfB4vIaGBugJzefza2tr29vbl6pvSyqVVlRUhMNhq9Uq FAqlUqlMJoNEWDHGEIT8jEZjQ0NDVVXVJ01NLBaLRqMmk8nlckEgp7+/nwpc0VEZGmUASZJ8Pl8i kQC9o9frvTxTe7lAkmQsFtvd3U2n00wmc29vL51Ow1t0qSqd0+k0ULwgCIKiKJSwyOVyuVxeTFQG jGlFRYVarf4kvyqsqxQKhVwuVygUk5OTkUjk1atXd+/eBcGXsp0VDRr74QoQm0QQZH19/VqyP4BA WzQajcfjkUjEbrcXEvhe7NgKEQwGg8Egsq+nm0gkUqmUTqcr0viDqenp6eHxeMUkvnk8Hp/PV6lU er1+c3PTbDZns9mhoSH4LS1cQOO0gKV8JBKxWCwulysej1/L1RJBEFDWGg6Hg8FgacsjyM6Ew2G9 Xp9IJCA9dAbj/f8BIxwcHKytrS1GDZskSQ6H43A4/H7/Sfs2BQKBSqWyWq2ZTMZgMCAIIpfLM5lM U1MTiqJGo5HL5V6zKYfGOQNylx6Px2KxBINBUE256EGVGeAWJJPJfD4PItiluS9QJGexWDY3N7lc rlgsPtPqIhAruH//PpRpF7M9k8lcX18XCoVCobCYsVGJdbVajWGY0+mMRqNbW1symYzH49FRGRqn BaWY7fP5bDYbh8M5U5aUKw3IyMhksvr6+rdv366vr2MYptPpUBRtaWnhcrnlpcoA16TIRRJVwhwI BErTIlYoFE+ePFlYWLDZbHq9niRJlUpFs+fRKBcgKsNgMLa3t6HD/1JFKS4VQOWxqanJ7/e/ffsW QRCxWKxUKrlcbnNzc9ntDIqiXC4XKZrdG0VRl8tVsuhNT0+PVqudn58PBoOzs7N9fX10VIbGqQC+ v8FggGxLLBbLZDJ8Pl8gEEDrwUUP8NIBVpbwAgcCAZIkIU5rMpkCgQCsMMqyfgK3qb6+HkpnyE+J yZEkKRAI5ubmMpnMnTt3SqagEAqFdrs9l8sFg0GbzTY4OCgUCjc2NuioDI2SAX52KpWCBymRSKTT aWBDQBDkpNxxnw9ARDYSiaRSKSDR8Hg8W1tbBEEoFIpyHQVCLKCPW+SNwHH82bNn/f39KpWqBOo/ OC+gmEdR1Gaz0a4MjVMBerMrKyv9fj+fz6+qqhIKhfB0RiKR69rQdEoAiSeHw9ne3i58h+PxuMVi WV9fd7vdfD7/lDFhaOfu6OiQyWRF9i4xmUyfzwdcxiVPDxwOJ5VKRSIRDMMcDsfNmzerqqpWV1d5 PB7tytAoDbAAYLFYcrncbrdD765arRYIBOFwGCpmLnqMlw5gnIEZORAIUMFygiB8Pp/BYDAajfF4 XKFQsFisUxYUy2Syrq6u4l9wyBBVVVWBVNNJDw3GChQl4/E4XStDowwAH1koFJpMplQq1dXVxefz Q6GQ3++n7cuhoFYVzc3NTCbT6/Ue2CCdTu/t7QFLdywWUyqVpRkaLpdbXV1dTJgHUoQrKyt2u10o FPr9/lQqJZVKSzguQRBqtVoul4fDYafTOTY2plaraVeGxukB4UwGg7G0tKTVamtra1EUdbvd0J98 0aO7jAD9taqqKq1Wm0gkDlTekCQZiUSMRmMwGPT7/SwWSyQSndSxgHCvVCrVaDTFbA9e6eTkJAR9 vV4vh8OBfpHijwsmlMViabVaJpPp8XjoWhka5QGDwejo6EgkEltbWx6PB0Iy9NR1DCBmXltbu76+ fuBCwX/j8Xg8HkcQZGNjA97Y9vb24q8qk8m8devW8ZRWhcAwLB6Pw8TAZrM1Go3dbne73f39/Sdq ogYro1QqBwcHnU4nTfVLo7yQSCQDAwPJZPLDhw+BQOCTXLGfOaj6vIqKCqfTeYD2CT67XC4URXd2 diQSiUQikcvl9fX1RdoNkiQrKipu375d5JsO2/j9fojc83g8oVBotVr5fH5jY2MxyiqFh8ZxvL6+ nsVi0a4MjfIAAjOZTMZsNotEosHBwffv3+dyuYse16UGvIp9fX35fH5jYwOanz82yvl8fnd3F0GQ 7e3tqqoqNpvd0NAgFAqPqd0jCKKjo6NIGQRK1A0IcvL5fCwW29zchL9aLBYEQXg8HpfLDYVC+Xw+ l8tptdquri6hUIjs58WkUmlVVVUhDzKo49JzDI2yQywWAyXJ8PBwOBymnlUahwJF0Vwup1Ao+vv7 gZrlYzsD/w2FQqFQaGdnZ2NjQ6VS8fn85ubmo15hcJLEYnF7e3uRdcSwznE6nRDLSafT6XSaEqyd n59nMBgCgQBGAjvs7Oysr6+HaNze3l44HNZqtYUsWVBxTLsyNMoDeKzlcvng4CA0zrDZbNqVOR7w PldXVyMIYjKZ0un08dsTBAESBGazWaFQCIVCjUZTWVn58fqJIAiVSsVisYpZWgGD+NTUlN1u5/F4 hzYcAW8EfGaxWGazWaVSZbNZp9PZ2dkJ+thg8jAM29nZCYVCXq/X4/FcP75EGhcOkiQbGhrOmdo0 AAAgAElEQVRwHK+oqEilUkAiRzdOHgUomuHxeGKx2Ol0Ugr2xyCRSOzs7CAIsr6+Xl1dzWazW1pa oKSmcLN8Ps9ms1UqVfE6talUamZmBvmIOZ0aJ3BeUFZreXlZp9Ntbm5WVlYqlUqpVMrn83O5HIPB gEFGIhGbzUa7MjTKhlwuZzKZvF5vJpMJBoN09rp4kCT59ddfP3v2jBK3On5jBEF8Pp/P54OQCZfL bWhoaG1tpWK8CoUCKImLOTqIun2SEB3WdlqtFprUbDabz+fLZDIzMzPDw8O7u7sQpsYwzGazZTIZ DodDR/5pnAWi0ejm5mYmk9Hr9dA7SctlfBKw2qyqqhofH3/+/HmRvyJJcm9vD0EQk8mE47hYLO7p 6VEoFCBky+FwZDJZkWUuGIblcrmPk1wfA+pgqqqqoILn/fv3IpFodna2u7tbpVJtbGxEIhEWi5VI JBwOB4PBQFGUFi6gUWaA653JZIxG48bGBp1iKAZQz+j3+xcXF6E0r7SLBu9/T0/P48ePISr2SRMD Bb/Pnz93Op2l0ckcBSaTabPZfv3rX3d3d//2t7+Vy+W0cAGNMgJMTTAYXF5epuN/RQIiHxaLZWVl 5TQ7EQqFOp3uwYMHt2/fLjIkw2KxwuHw06dPQWauvKCjMjTKA4pgDXojofCCDvkWCUghKxSKwcHB paUlyBOXcOmgkk4gEMDPi1wqud1uup2VxhUCRbAGBudjtXYaR4EqlWUwGMvLy6VdNGh9ymazxeuT YBiWTqddLtcZEcFfK3Z5GhcIyD6IxWKFQkGSZCKRAFfmosd1ZQAXUKlUQi3tSbt+YHsmkzk2NjY2 NnYi+vD5+flQKMRkMunJgMaVAHTNADt2KBQqRpSDBgWIAVdVVZXWWgiXuqam5uc//3l3dzclRXf8 EZlMZiQSmZ+fP6MlE337aZQNEFrgcDi5XM7r9SoUitraWpq0vnhgGJbJZPr6+r799lvQuC/ytacI xEZHR4eHh+FGFPlD6JemZwIaVwskSQqFwkAgkEql6urqilRLpQEA3+Lx48e//OUvT7R2Ah2SysrK L7/8sr6+/pOKs8i+55RMJj0ez9nZGTrBRKNsgNfD7/c7nU6BQCAWi2OxGJ/PTyaTFz20qwToUayp qQmHw5FIRKvVrq6uHp9vgj+JxeLa2lq5XF68DAqKoouLixMTE263myRJiUTC5/OhqUqj0dBzA41L C6guBwJJBEHy+TyXy6Wf2BMBIsEDAwOzs7MajSYajULl/idNjVqtrqmp4fP5RYrUMpnMQCDw9u3b paWlWCyGIEhFRQWKosAlAx1Jp7xxtCtDo2yAF0Mikdy/f9/lcgGJJG1ZTgQowjUajQRB3Lp1K51O ZzIZoVDI4/FevHhx6E9gnSQWi7/66qu2trbik0QkSbpcLtDBhsIaYJVAEMRms1GbQQ8nsi9+29DQ wOPxyitHR4PGSUEQRH19fVVVlcVisVgs0JJNP5MnAoZhi4uLzc3NP/nJTxAE8Xg8nZ2dTqdzbW3t UBVY+LK7u/vRo0fAxVAkZ1UymbRarS6Xi+ppcLlcsMHW1hZ8wHFcJBKBbWEwGGq1WqfTFW/NaFeG RpkBk2JNTY1EIllYWEgmkxQfCY1PAorjdDodgiBAM8NisdRqNYIgT548yWazVquVzWYrFIpcLre8 vOz1equrq7VaLY7jQqFQqVQWuTDFMCyfz8/Nza2trWWzWeRoSdtCRhnwUA9swGKxlErlx3znbDZ7 Z2fH6XTeuHGDzjPSOAuwWKyenh4ul7u1tZXJZIrJd9CgQBBEb28vgiDQWgjanE1NTU1NTcALpVAo BAKBz+ebn59HUbSzs5PP50skEqlUKhAIigzJsFgsl8s1OTlpt9uRo+1MPp8HYV34r91uX1xcpP4K DpBEIjmK9pN2ZWicFaBig/ZjyggURevq6uCt5vF4XV1doA27s7Pz7bff9vb2Fs8dThCEw+FwOByB QOCUo8pkMmCkDoDD4SAIEo/HaXYZGmcKKDKD+lP6STs9gLpdIpHAfysrK4eHh3k83uLiYmtrK6iq FenH4Dgej8etVqvb7U4kEiXTTBSSER+6AV3rR6PMgBTJ7u7u69evHz16NDIyghztidM4EYAMCtkn hxCLxXw+X6fTPXr0qL6+vnjucJIkPR7P9PT09PQ0zfVC44oCZtxnz57F4/Ff/vKXDQ0NdCtTWYBh 2IGGA6VSyeFwbt68ef/+fbFYXGRqCUVRkLJ5/fr1zs7OmTqadFSGRpmBYVgqlaqurlYqlZubm2fB hkQDAIseFosFId8iiaoYDEYsFltdXaWNPo0rDQzDYrHY2NiY0+mkSi5onBEYDAaDwVAoFBwOp8jG JQ6Hs729vbe3x2azz3x4Z30AGp8VgBs7Go0iCMLn83Ecn5mZAVrxix7aNQTEZjo6Onp7exOJRDGu CfwEctI4jn/zzTcoigYCgVwul06njUZjJBKhOeBpXH6gKJpIJOLxOIvFEolEKysrZrOZy+XSVVln BAaDcf/+falUWmRBEjRgB4PBQCCg0+l0Oh0I2qAo6vP5Njc3y2tkaFeGRjkBi36JRMLhcBwOh16v /8UvfvGnP/2pSOZZGsUDLEVjY2NTU1MqlSrm8oJspNvtfvPmDaVRQJKkVCqFDzU1NbFYLBqNstns SCRisVi4XC6Px6OXvDQuG0iS5HK5bDZbJBL99a9/lcvlo6Ojz549E4lEtDdTdhAE0d/ff1TJ7aHb 8/n8yclJo9HI5/PhjjAYDOicVygUbW1tfr8/l8uxWCyr1erz+RQKRSwWc7vdpS2laFeGxpkA9MAy mcx3333X0NBgsVg+7nChUTLAj2lvb+/o6IAMdJHrpHQ6HQgEDo3fQC0wj8fj8XgIgkgkkpqaGpIk 0+l0Z2en3+9HECQcDrPZbIlEsrq66nQ6D+3YBFRWVoZCIS6XW19fT1cw0Dg75HI5mUy2tLSk1Wpb W1stFgstxlRGgG25e/euUqks0skATrxQKAQKtUdtI5PJ4LNEIoGqGjBB4XCYIIhYLCaVSgmCmJqa Oqaej8lkKhQKp9NJuzI0zgT5fJ7D4bS1tbndbrPZjJyciZ/GMYAWR6lUyuVyiymRoWA2mxcXFzkc TvF0wNCIBI2aUqlUKBT+5S9/4fP5T548iUQiiURCJBKRJPn8+XOBQKBSqbq6usLhMPwE3B06Jkfj jAAZbbVa3dra6vV6vV4v7ceUHXw+XyaTHbNuOQC4KTMzMy6Xi81mF6+gAp8hclNVVZVOp7///vu7 d++KRKJYLJZMJqurq/V6vclkksvlwCrk9XoFAsHNmzdpV4ZGmQEPZSgUslgsAoEAyMXpyayMgCt5 586d6urqE/kx6+vrer3+NPUEGIbF4/G7d+/Cf0UikUgkgs9PnjyhNoM2TrozlsaZAhz6ra0t8Kej 0ShU6dEoF4DKZXR0tHgtFARB0un0u3fvAoEAm80u2QLk83kGg0FZFalUKpVKoTQQRF0AKpUKPtBR XxpnAlCBb2lp6ezsvOixXCtAg9iJ/BiCINhsttVqNZlMRS6SaNC4KoAKjL6+Pq1WC0mKix7RdQBQ t/N4vLGxMeQkbBo4ji8vL0cikXOWp6WjMjTKDHgH+Hy+UChMJBJra2t8Pj+fz6fTaXqNfkpARvn2 7dsKhSKTyRQZjwHvJxAIJJNJusWDxrUBJDKqqqpYLNb29rbD4ZDJZGBqaIfmNIALKxKJ7ty5c1Le qWg0GgwG8/n8ObsydFSGxlmBIAgmk9nb29vX15fNZmkqttMjn89DPOZERf4EQczPzxsMBtqPoXH9 AP69Uqm8fft2dXV1LBYrUk+exqGA6ymXy+/du8fn80/020gk8vLly3g8zmAwznnhSkdlaJQZEJXJ 5/NsNjsajW5tbe3s7LS0tEgkEr1eH41Gz9lbvx6AYqPR0VGZTEaSZJEXEJiXFxcXrVZr8aW+NGhc CYCGPI7jGIa5XK7V1dV8Pj8yMhKLxfR6PW1nSgBEcDUazfDw8Im6DjEMy+Vyc3Nz2Wz2QlxJ2pWh UWZAJx6LxYrFYi6Xa2BgoLe39/vvv0+n01wul8Vi0V3ZpYHP54tEouLjMeDHTE9PWywWugKXxvUD dBiwWKzd3V0Mw548eWIwGCYmJkBJPpPJXPQArx6AQBwUqpPJZJFsVQwGI5lMvnr1qsifnAVoV4ZG +QGBGYFAoNPp3r1753a7Hz9+bDabo9Gox+PJ5XL0zFokIGnN5/OpYG/xkRUMw4LBYCgUyufztKAj jWsJCMzodDqHw/Ef//EfGo3mH//xHxcXF/P5vN1up5dMxQOoqlpaWnp6euCqFl+Kl8/nfT4fqEWe 9TiPAu3K0DgTAEE+k8ns6uoSCATxeHx7ezsWizGZTNqPKR4Q4uLxeCKR6KTFRolEYnJyMhQK0Uwb NK4xMAzLZrNKpbK/vz+Xyzkcjq2tLQ6HQ/sxJwIVj+FyuUWqoCD72rQ2m216evpiM3q0K0PjDIGi KFDHvnr1iiCI868Fu+rI5/OVlZX3798/aZdpNBp99+5dIpGg/Rga1x6QaRKJRB8+fPD5fJQoB40i AXH04eHhxsbGk/oxFotlfn7+wu0M7crQOEOAp9/Y2Lizs0OXyBQPCPZWV1ffvHkTFp3FXzrYcmFh IZVK0XklGp8DIA8rk8mqq6udTie9ZCoekEu6efNmbW0tSZLFa4xAKZ7dbtfr9RfuxyC0K0PjHABC PPl8niAIp9MJwhwX/uhfWoAfU19fPzAwcFLpIugjePnyZTQapR1HGp8VMAyTyWTNzc3Qc+BwOOhX 4HiAC3jnzh2tVnsigwx+jMVimZ2dLU39seygXRkaZwiomFlbW9ve3s7lcpWVlVVVVS6XKxaL0Sun QwFXrKurq62t7USG+JL0EdCgcf6ABJPP59Pr9W63m8fjVVZWajQah8NBS6YcAyaTeefOHYVCcVI/ hsfjbW5uLi4uXp7CR9qVoXGGIAgil8u1trb29vY+ffrU4XBAaRgdlTkUVMa6oaHhpO0AlKhsPB6n ZahpfFYAyXc2mz06Oup2u58/f57L5aDXj/ZjDgVJkjweb3x8nMFgnJRuCrhnQqFQJpPhcrmXxJLT Jo/GGQJFURaLxWQyc7nco0ePpFIpLZJyFMAXuXfvXn19ffGVd4U/t9vtExMTNNUpjc8NsDricDig kj0+Pk5rFxwDgiBEItGXX36J4/hJ/Rjg55ybm7ts7OF0VIbGeYDBYDx9+jQajV6GArFLiFwud//+ fbVaTRBE8YwOFFAU3dnZmZmZOY0U7f/X3p19RZVdDQC/Q91bw60JirkKkElldEAEW7GlbTQdO61m rayV1XnIyp+SPyNveUseupP2c25FBURQFAQZRIqhmEuoebi37vg97LZitINMVRSyfw9Z3bZUFaTq sM8+e++D0J6WLETt6OjIqN+yGSJ5I8GXX365tYMhTdNUVe3r61tYWMi0nzBmZVBqaZoWj8ej0eiB AwcMBgP2Mf0qmqZNJtPWzt1Iknzz5k1fXx/2oKJ9C4rMgsGgTqcrKyuTZXm3X1GGYlnWaDRu7Wtl We7u7l5cXMzAW1AwK4NSC0bLaJpWXV3NMMzr16+xSTgJZu1cunSJYRhVVTfVdJ00MjIyMjKSaZsk hNIJKn91Op3ZbD569ChFUfPz87hrAhRFxePxqqqq06dPx+PxrZ3yC4LQ3d0dDAYzM/WLoQxKLWjV e/jwIZSj4q0FSYqiWCyW3/zmN5C23dqDvHz5cmJiAuMYtM/B6dLc3FxfXx9e9PY+GO5w5MiR48eP b7knIB6Pd3Z2ZvLITQxlUGrB+/6LL75wu90zMzOKouzz/hqYSZWbm9va2ppIJLYWgkDx3fPnz2dm ZjCOQQiamPLz88+cOfP69eu3b99iKAPJmKamptLSUkVRNj7+7gPhcLizsxOuvM7MOIbAUAallKZp cGjCcdzS0lJubm44HI5EIvtzqAxsj8rKypqbm1VVJUlSp9MRBEHT9HfffffgwYPV1dVPJm9VVTUY DE+ePPF4PDRN6/V6jGPQPgdTDCRJMpvNmqb5/f7S0lKPx7Nvoxmo8D1z5ozL5YK72xiGEQShurr6 0KFD//rXv+DQf51HgAO7WCz24MGDRCJBEESGb0ExlEEpBM3Y8M80TXu9XpqmMzm0TxGYxHD8+PHq 6upEIgGXREqSZLFYLl++/NNPP/34448URX0yeatpml6vv3fv3urq6u5e3oZQ5oBmbOodSZJWVla2 0Gn8GYBRmefPnzebzaqqKopC03QoFGptbXU4HNevX5+dnf3kMBhN01iW9fv99+7d2yvDHTCUQemg qurBgwdDodD8/HwikdhXWRmKomKxWGtr6/tXtcGKIwjCjz/+KEnSBnc8Op3u9u3boVBoX/0AEdog RVE4jquvr4elZr9lZVRVZRjm22+/fT+Mg5/J8PAwSZIb6TyCqqOlpaWHDx/uof1SRqeM0F5HUZSi KK9evRJFkSCIqampvLy82tpao9GIdXnEuwO4jfxNkiTj8fiNGzfC4fBe2SchlB6QRfB6vZOTkwzD hEKh5eXl+vp6l8uVITcE7S7oVJdl+ZNLLmyxXr9+/fDhw4yt8P1VmJVB6UDTNEx+m5+fpyhKVdV9 eMy0ZSRJBoPBhw8fwsnUbr8chDIUfDokSZJleWxsDKrjccu0QRDHjIyMDA0NmUymvXU8h6EMSiGY m1JTUzMxMaEoynfffdfT07O4uGg0GtM5wwruP3v48KHX662qqqqtrU3bU0MTwddff+1yuTZ7HQHs NX0+X0dHB3whLsoIfQy6Ap1Op8/nGxoaKi0tbWxsvH79OsuyqqqmbcsEpbLRaPTOnTsEQZw5cyY3 Nzc9zw53XHMcd+nSJVVVNxuFqKrKcVx/f//Y2JjBYMjACXifhKEMSjkYZSsIwk8//XTu3Dk4xzUY DG/evEnDgFoICPr6+t6+fUsQxNTU1OTkZHl5eXNzc+puXoS94IULF6D4jiCIzV5HkJzC/ujRI1iR U/E6EfqcsCxrsViWlpbGx8d/97vf3bp1q66ubnJyMh6Pp/pYFuKYSCTy5MkT+JOenh5N09ra2nJz c1N0JxQ0RZaUlLS2toqiCAnvzT4I7PS6u7unp6f3bkckhjIotSBSKSkpgcPsjo6O5F2s6ZwaKcsy PJeqqhRFTU9Ph0KhlpaWVIQyUHx38eLFLa8LsCyOjo4+f/58z2V6EUo/KAcxGo3V1dV+v7+jo+Pu 3bsEQYyMjBAEkbbyMk3TkvlmOA5++PBhfX19ZWXljq91yRm+LS0tW7i4LfkiCYK4c+fO27dvM3OM 7wZhKIPSgaKo8fHxaDRKEET6fzFTFBWJRIh3o4fhBfj9/ps3b9rt9vb29h25rxtmOWRlZbW3t8PY mC2sC5DpHRwcHBoaMhqNezHTi9CugFKPSCTy+vVrgiBgnko6QTjF83zysw8f3tHR0VevXjU0NNTW 1u5IJhiaIk+cOFFbWysIwsZbID9+nLt370Inwd4q8v0YhjIoHTRNq6ysrKioYFl2ampqbGwMUr67 +OGBM6BgMHjt2rWvvvrKYDBs59Eg0+t0Os+fP8/z/BZWFkjzPnr0aHZ21mQy7d1ML0K7AiIJg8HQ 1NTU3Nwsy/LLly/n5+dhX7GLLwwywcPDw6FQqLGxcZvNmxDHnD17tqKiYrPld8R7YyBu3LhBEARJ kp9HRySGMigdaJq+detWJBJJDipI201MOp2us7MzFAoR77KpSfCvoihCmd65c+eys7O3EEBApre8 vPzLL7/c2q4L1hdI8+JFBAhtQbK8rKOj4/0PURrimGSFfk9PD/HROkO8S8/Mz897PJ6cnJzTp09v 7YXBUtPe3u50OrcQxxAEodPpYPYdjBr/bHxW3wzKWIqitLe3m0ym+/fvQwdTBv627uzs1DTtyy+/ zM/P33iZHmySampqWlpathbHKIpy9+5dnud1Ot1eT/MitFvgGiaHw/GnP/0pGo3evHkz0/INsOj5 fL5r165xHPfNN99sqpGTJElBEH7729/m5ORs9kIlCLZmZ2cfP35sNBo/sziGwFAGpQ20C5aUlESj 0Vgsls55teFwmHhXKLPOX4P/2t3drarq8ePHDx8+7PP5ysrKWlpadDpdOBy+devWjiwBsKwEAoHb t28nYxcctIPQ9pEkCXX3FRUVs7Oz6Zkrk7yKBMpv19+nwcc8Fov98MMPFEV9++23DMPwPH/69Gmn 02k0Gl+8eDE0NMRx3Pb3e4qimM3m/v7+V69ewQN+rifXGMqgNIGunLm5uVAolJ6sDMQujx494nme +LWs76/+/QsXLoyOjkLHk16vX1lZuXbtmiiKNpvtj3/8oyzLNE3fvHmzsbGxqKgIcrwQlm2kRAaC mJmZmcePH5tMpj00FxyhPSEZVUxNTdE0nYY4BkZLLC4u9vX1ERtoa4B1xmq1njt37v79+zDHj2XZ /v7+Fy9exGKxxsbGv/zlL4qizM3NvXr1CpI3siwzDAOPsJE2BVhve3p6FhYWjEZjZibCdxCGMigd aJq+e/cu1Mpk4LaAoqivvvqK4ziTyfTTTz/V1NQcPHgweVoEi0I8Hv/hhx+Id51KkETR6XSfTPZA U1J3d7fb7U52VmNrEkI764NamUw7XYJsTWFhYXNzs06n8/l8169fv3r1arKnknj3LYyNjY2NjcE6 k6zeS8Yx6z+FJEk3btxQFCW5rcrA9TYVMJRB6SDL8jfffON2u1+/fi0IQjoPU6DgdyOgC+nixYsE QayTYoHIpqura7OvBMMXhFIH7p/Pz8+/evXq8PBwOq+TpChKFEVZljcypA6O2m022+XLl9f5y8mZ e//+97+38Ho2+yV7HYYyaJ+CbIrJZGpra4MdD571IIR2HMQ3lZWV9fX1cHKNN5DsOAxlUDqQJCnL ck1NzdLSUiQSSUPNL+Rau7q6PugRgGWloKCgqakp01LQCKHtgHXGZDLV1dV5PJ40fMDhSGhmZubF ixfEfxfKwGapsbGxpKQElrttTpRB69h3aSi0W5JXvlmt1o1cN7/9p9M0LXm6BBnXpqam/Pz84uLi 8+fP45qC0OcHOphIkjxw4ACRllQrHGy9X55C03RbWxtJkufPny8vL8dj5TTArAxKB+gGunPnztra ml6vT+l8PKjG5Xm+t7c3+YewuvX39x88eLC6ujp1F0kihHYLrDNra2t37tzR6/VEiufjQe/S5OTk 2NgY8V7YpChKd3f36dOnLRaLJEm4a0oDDGVQOuh0utu3b8disfSUvsII80AgkPxXTdOOHDkCGzWE 0OcnOT3h0aNHZrNZFMU0PClN09FoVJIkmqbh1ieO41paWiwWSxqeHSVhKIPSQVGUtrY2vV7/4MGD paWl1A05gLL/cDgMMx5AS0tLQUEBVvUi9BlL3uf6hz/8IRwO37lzJ6W1MpCSGRsbm5ychL2T1Wo9 ffo0ZINQmmEog9IBDn0mJyfTU/ObSCTC4bBOp2ttbbXZbAR2JyG0DyTvSpyYmEjPCXI4HFYUxel0 Hj9+HNsIdhGWC6B0gA1TeXm5xWJJXc0vDM30+/1Pnjwxm82XL1+GOAYhtB9ABxPDMFVVVSk9yIaU zMjIyMzMTHV19dmzZ7EgZndhVgalA0mS09PTb968EUUxReUysLisrKw8fvzYYDC0tLTA0TVCaD+A lEw0Gh0eHl5aWkpdjgSKcgYHBycnJ8vKyqqqqniex1Bmd2Eog9LEaDSmrnEJpjvMzc319vZardZT p04ZjcZUPBFCKGNpmkbTtMFggJuYUrHaQDVef3//7OwstEPCqCoMZXYXhjIoTeAixhStL9Cj9Pbt W47jzp49+/ldYY8Q+iRYBxRF0el0qTtgkiRpeXn58OHDhw8fhmfEOGbXYa0MSgdVVUtKSuB/6+rq TCbTDg6+hH3Ss2fPwuFwW1tbGsqKEUKZBtqITCZTYWGhqqpHjhwpKSn55G2vmyXL8r1796qrq5Nx zA4+ONoyDGVQOoiiqNPpFEUpKiqKRCI+n49hmB1ZBeCAvLu7m2XZ9vZ2aFvATRJC+w2EMpD91el0 +fn58/PzO3j0Q5JkLBa7f/9+a2trZWWlpmkYx2QOzMOj1IKNi8fjkSSJoqje3l6apndkrgz0Kw0M DExNTTU2NlZVVUWjUZzhi9A+BFuacDg8NzeXSCREUfz555+JndjVwCPH4/Hu7m5Zli9cuMAwTBqu XkGbgqEMSi1N00RRLC4unpqagpainUrGsCzb1dWVn59/+fJluAYF4xiE9ieKohKJhMFgKCwsHB8f 38HDa5ZlfT7f4ODgyZMnrVYr8d93RqIMgUs/SjmWZc1m8+LiYiKR2KkOSUVRbt68WVRUVF5entIb nRBCmQ9qb81ms6qqCwsLO7LOQBHe9PR0X19fU1MTxDEoM2Eog9JBVdWDBw8ajcZtVvtSFCVJUk9P z+rqant7e9ouv0UIZTiYj2exWCorK2VZ3s5DwZCqhYWFnp4eh8Nx8eJFHO6Q4fCACaUDRVFv3rzh eX471b4URa2srAwPD7e3txMEgWV3CKEkKGqJRCJut3s71XiQjOnp6WEYpq2tLRqNYrt15sNQBqWD qqrV1dUjIyM8z2+2WRqOq1dXV1dWVurr63NzczGCQQh9ALIyVqv10KFD09PTNE1vdqGAMb6jo6M2 m+3UqVOJRCIej2MF3p6AoQxKLehgGhwc9Hg8qqpuYX0hSVKSJLvdbrfbJUnC7RFC6AOw4VlbWxsY GAgGg1tYZ4h3V8VVVVURBCGKIi41ewiGMiiFoLSlq6srFAoROO4FIZQCcG/J7Oxsf38/DJLBxO1+ g6EMSiFIw7S1tZEkOTExAddJbm3DhBBCvwo6sQsKCq5evZq8ThI3TvsKngKi1IIFZWpqamJiQhTF 9DROw2VydrvdZrPZ7XadTheLxdrb28vLyyVJKiwsdDgcTqfz6tWr58+fVxTFZrNZLEfT+YwAABF3 SURBVJYrV65YrVZJkjRNMxgMdrtdr9fjDAmEMh/U/MZisdHR0YWFhbQVuKiqqtfr4fjbbDaLomgy mS5fvkySpNFodLlcFovl6NGj33//fUVFBUEQHMcdPnz4woULgiDA2mixWKxWK06U2CbMyqB0SCQS O/5B1TTNarWSJBmNRmma5jgukUg4nc6srKze3t78/Py6ujqr1UrT9LNnz86ePZubm+v1evPy8nJz c0tKSkwm0/Ly8tjY2Pfff8/zfH9//7Vr1ziOs9lstbW1Lpfr2bNngUAgLy9PEASe52G+H0IoM0HZ byKR2Nl8DARJFotFFMV4PG4ymViWTSQSx44d83g88/PzZWVl5eXlZrPZ6/XOzs42NzfzPO90OmVZ Lisry8rKMpvNjx8/tlgsf/7zn91u98DAwOTkZE5Ojl6vb2pqkiSps7PTYDDo9Xqe51OxVO4H5N// /vfdfg3ov1AUJYpid3f3mTNnDAbDnv4NqmmaIAiiKHZ1dcHFBZv6WqPRCAPCrVZrOBzW6/VHjhzx er319fUkSQ4MDBw8eBDyKNtcvODLe3t7GxoazGYzwzDDw8Ojo6NffPGFLMtjY2MtLS1Pnz6Nx+MW i4XneUmStvN0+wTDMAsLC3/9618bGhr++c9/OhyOPf1m/syoqspx3Pj4+NraWmtraywW27utOlCu CxekDAwMbKET22QyxeNxs9ms1+vfvn1bU1NjNBpJkqypqZmfn19cXDx+/Pj2C4GhQ2pxcXFubu7U qVOSJKmq2tXVxfP8xYsXHz58WFxcrNPphoeHGYbR6/XQB76dZ9w/MJTJaKqqmkymzs5Ol8vldDr9 fj/HcQaDIZPf37A3EkUxGo1OTk56vd6NfP4hH8swTCKROHToUGlp6S6W1FAUFYvFEokEQRAGg8Hj 8czOzl6+fFkQBE3THj16dOrUKb1eryiK0Wh88eLF+Pi43W6naToUCrEsa7VaFUUJh8MbfDqr1RqJ RHbw3rsMgaHMXpE8nent7T137lwsFlNV1Ww2Z3hZG0mSgiAoirKysuJ2uyE7u/4Lhu+U4zhZlvV6 fUNDQ3Z29u5+j+FwWNM0iCw7OztLS0uPHDmiKMr09PTi4uLZs2cjkYherxdF8cGDB9FoNCsri+d5 QRDMZrPRaOR5fiNhKAz9Y1k2HA7v3Zh1HXjAlNHgaqHm5maCIFRVLSwsnJubGxkZMRqNFoulqKhI 07ScnJxdr9iHNSWRSPh8vpmZmUAgkBwe8/GvZ7jA1mw2Q4YjJyensbHx4x3PLn5HcP6dlZX1+vXr QCBw/PjxiooKQRAIgiBJ8uuvv75x48apU6fgJ282m4uKisLhsM1m++6778Lh8OrqKiSQm5ubrVbr 9evXYZpfNBolCILjOJZlA4EAQRAsy548edLhcNy9e3cLE3cQ2hHwkTQYDG1tbcS7t+jz58/9fr/R aCwoKLBYLAzD2O32bU7r3hHxeJzn+aWlpdnZ2fdzvb9abqJpmsPhYBgmHo83NDQ4nc4PLmvb9U+c 1WplGObx48elpaVff/21pmk8z6uqWllZSdP0jRs3vv3220QiwTBMVlaWxWJZWlo6e/ZsSUlJMBic nZ2dm5urrq5uampaXFy8f/9+QUHB6uoqQRCqqmZnZ8fjcVEURVF0uVzNzc1er7erq8tkMn1+JYCY ldnzSJLs6+sTBIFhGEEQSkpKcnNzocDWaDRyHLeDn1U4/PL7/bAWkCS5uLiYvPX6/b+paRrUr+j1 euLdbJimpiabzbZ/ZsNAPrm7u7u8vLykpMTr9RIEkZeXt7y8/OzZM1iwGIa5dOkS/LgGBwfj8TjL snNzc0ePHjUajePj483NzTdv3nw/FUeSpM1mYxgmFApt/BJNaFhlGGaz2zIYdXr69OkXL17EYrGN x1uYlflswDvZ6/UODg4mT70PHz4M0QNN0xDr7NRSA48ZDodhQh3s6GZmZrxe78dvXZgoYzabdTod QRCSJFmt1pMnT+6rdYZhmGAwODw83Nraqqrq2tqa1Wo1m80vX76cnJyE8OjQoUMtLS0QCMIxnCAI Xq/3ypUrXV1dlZWVkUhkaGgI7rGCR4b4VZKkUCi08bSxqqo2my2RSGzqil/YDx84cMDpdPb09Gz2 8AFDmc8KdO6Iojg9Pb28vJxcXARBgJSApml2u72qqgpSrOu8NWHxGhwc9Hq9er1+nXcVhP8sy2qa BtM2KyoqMmQDlyEgezwwMEBR1NGjR2OxGMMwfr9/bGzs5MmTN27cOHHiRHFxMYQmRqPRaDQmIwaK ot6+fdvV1eVwOMLhMPwW+eabb0ZGRlZWVkwmEyxbBoPB5/N9sHDAmiKKIs/zNE0riqLX600mUzQa TUYVLMtC09Y6r1+v11sslkAgsP575gMYynz2QqHQxMQEvLsIglBVNRaLQf6SpumioqKysrJP/kKi aVoQhN7e3vV/7cHZUPI8SFVVp9NZWlrKsiwuNUnwc3j8+PGxY8esVqsoigaDYWBgAJqkhoaG2tvb dTpdIBCAM/3k3VLw433+/Pnc3JzNZgsEApqmFRQUtLS0/N///V92dnY4HBYEITc3VxCEWCz2/lle MpyF+WEEQaiqarVaNU2Lx+PJdYym6fXrjUiStFgsFEUld8ub+MYxlNlXIEB58eLF2toaBB8b/1qo rcvOzj5x4gSOwtxBsizDhhLAz5kgCJZlCYKQJCkYDFqtVlVVBwcHV1dXBUE4duxYWVmZ2+1eWVmJ RqN5eXktLS1jY2OvXr0yGAytra0Oh6Ovr8/tdp8/f76wsHBoaGhqaoplWTgsh3YJlmXtdntDQ8O9 e/ckSXI6nSzLRqPRcDgsy3JBQYHNZnv69Olm3ydJGMrsW/B7kef5vr6+LVRmUBTF83xdXV1xcfGm dvbof4EzRPj/5f2PsyAILMtCnBEMBmVZttvtXq93eHg4HA5zHNfS0sIwzKtXr0RR9Pl8p0+fttvt /f39s7OzlZWVX3zxRSgUevTokU6nu3TpUigUevny5erqqs1mEwRBlmWj0QjLTmVlpdFovH37dnFx sc1mI0kyEAgIgqCq6uHDh5eXl6enp7dzcxaGMgjtGSRJRiKR93M2EJsuLS15vd4TJ04Eg8GnT5/a 7fa6ujqdTqeqKlSOj4yMTE5OFhcXa5oWDodramoEQcjOzk4kEhaLJR6PC4IwNTVVWVmpKAokbzwe T01NzatXr+bm5kiS1Ol0jY2NHo9nZWUFnlSSJJPJxHEcvKS1tbUPfuVgKIPQXgT1AIlEwmw2v596 0ev1L1++dDgclZWVIyMjU1NTBw8ePHDgAJzlwea2u7tbFMXS0tLl5eXc3FwoKIQYxWQyhUKhaDS6 uLh48uTJiYmJqqqqsbGxnJwclmVfvnwZDAZJkiwsLCwtLR0aGoLGC71eLwhCQUFBPB6HvE4kEvn4 mJu+cuVK+n9SCKGtgS1U8l9hs2UymfLy8qBFvKysLD8/P1kJDg1ldru9vr4+kUisrq42NjbqdLr5 +Xmn0zk9PW232zmOUxRFEASO41wulyzLFEWVlJRMTEy43W6KovR6/cWLFx0OB1xzU1pampeXF4lE QqEQTdMnT550uVwTExPv55YIgoByh7a2tvz8/JGREZPJtOsllgihjaAoCrLCSbDU5ObmwubHarVW VlZCtvj9DH1xcfHhw4fdbjdsqLxer6qqLMsuLy8XFhbSNJ1IJBRFycnJKSgo8Pl8LpcLTr58Ph9J kuXl5WfPntXpdLBta2hoUBSF53m/319QUHDmzBlBEBYXFz+uecAOJoT2ME3TZmdnZVmura1NJBIf BBNJMNm9qKioqKgI/qShoYEgiOrqaoIgFEXhOA7+GZo8oZDwwIEDXq/XbDafPHlycXExEok4HA6r 1ZqTk1NeXk6S5ODgoMlkCgQC/f396xdUIYT2tEQiMT4+XlZWlpOTs85FV3A+3tjYSBCELMulpaXw 51VVVdCMkpeXl5eXRxCEoigOh0NV1ZycnOLi4ng8XldX53Q6h4aGGIbhOM5isRQXFxcVFT19+nR+ fj4rK+vJkycej4fjuI/PofCACSH0aWtra1lZWYqiSJL08uXL6enpuro6hmFGR0f/1wk3HjAhhDaO oihosMrOzuZ5PhQK9fb2yrJ84sQJt9sdDAbX6ZLDrAxC6BfQicDzvNvtJgji2LFjyTHwOTk5BEHQ NM0wTFtbm8vlYlkWqvZ2+UUjhPYgkiT9fv+bN28qKiqKiooSiQTM8YM2bIPBYDQar1y5MjIykpeX NzMzs/5Sg6EMQugXJEnCeMDa2lqCIN7vU4O7rrKysjo6OiKRSFZWVjAY5Hl+O00HCKF9S9O0rKws GACbXGqg4ljTNEVRbt26lZeXJ8vy9PS0oijrt1JikxtC6NM0TeM4ThCE9vb2oqIin8/X2Nh47Ngx GGK2268OIfQ5gHZxhmHggnGYydne3p6VlbX+BBDMyiCENgr6oZxO56FDh0RRHBkZwWpfhNCOg3Gv DQ0NhYWFk5OT0Wj0f/U0ANxOIYQ2BAZLPH/+/Pnz54qi+P3+9ydKI4TQ9kHFniAIHR0dHo+HJEmP xwMTpddZajArgxDaEJIkE4lEY2Pj6uoqTHpgGGa3XxRC6LOSvNz0/PnzKysrKysrH9/x9zHMyiCE NgoOmBwOh8VikWV5t18OQujzBLfYFhYW/uqF5x/DrAxCaENIkgyFQm632+VyLS4uzszMmEwmbF9C CO0gyMosLy+vrq4eOHDg6dOnoiiuf7pEYCiDENogGAHscrlGR0fX1tawDRshlAokSVqtVkEQHj16 BPW/n/wSDGUQQv+Tz+ebn58/evSo3+83Go09PT2BQIBlWaz2RQjtFE3T3rx5YzAYSkpKgsGgKIqd nZ1wCdQ6Ddjvw1oZhNB/QPtAPB4PBoOapvn9/nA4PDc3xzCMKIo2m02v12MyBiG0fTRN+3w+URTj 8Xg4HPZ6vX6/n2VZSZKys7M3tVnCrAxC6D+SV21HIpHh4WGz2Qx30rrdbr1ev7a2JkmSTqfDlAxC aJsURbHb7RMTE3q9XpblWCzm9/tjsRhBEMFgkKbpjT8UZmUQQr+isLCwurqaYZgjR46MjY3Z7XaY Jv6/bsRFCKHNoiiqvr7ebreXlJRYLBaPx5OXl8fz/AbPlZIwK4MQ+gVMDQ+FQisrKwRBGAwGURSH h4cpihoaGlJV1eFwxGIxQRDwsgKE0HZQFLW0tBQOhymKMpvNCwsLHo/HYDA8ffqUYRiHw+H3+zce 0OB6hBD6DwhlFEWpr68vKCh4vyyGoqhAICCKIsYxCKHtgL6kt2/f5uXl1dbWchwny3LyRklZlgOB wKYSM5iVQQj9Aub5FhYWGo3Gubm5jo4Ok8mEgQtCaGdBvFJXV8dxXGdn5/T0tMlkYhhmyy0FuEgh hH45WvL7/YFAwGq1Tk1N3b9/HyfgIYR2FuRalpeXJUniOO7nn3/ekWGbGMoghAiSJEVRdLlcy8vL f/vb30RR/P3vf28wGHb7dSGEPivQNOByuTo6Ov7xj380NTU1NzdrmgY3FWz5YTGUQQgRoigODAxM T0/DnbSxWGyDV58ghNBGQKTi8/n6+vqg2jcSiUiStJ0IJglrZRDa71RVtdlsgiCMjY2xLGuz2aan p6empnb7dSGEPh+qqup0OovFsrKyAiM3OY7r6OiA/7rNKQ+YlUFoX9M0jWXZkZERaH3cqU0SQggl QTWeIAiDg4MEQUiStM0TpQ9gVgahfY0kybW1NbfbTVEUz/OJROKTl9AihNCmUBQlSdL8/PzS0hLH cV6vd2dDGczKILSvURS1srIiSZIoipiSQQjtOJgiI4oizN6Mx+M7vlnCrAxC+1Q0Gg2Hw9nZ2fPz 8zzPsyyLyRiE0A5KzrujaVoUxYWFBb1en4p1BkMZhPYXOLSOx+P37t0rLCx88eKFLMsMw2AcgxDa Qaqqms3mwcHBiYmJ3NzcpaWlFMUxBEH8PyL8ftFP+WYGAAAAAElFTkSuQmCC ";
  //var imagen_Encima = //En este ejercicio se usa la misma del fondo
  rellenoR = 128;
  rellenoG = 128;
  rellenoB = 128;
  var fin = 'round';
  var grid = 20;//Tamao de rejilla
  var colorFondo = '#ffffff';//color de fondo y del borrador
  var radioPuntos = 1.5;//radio de crculos en punteado
  var densidad = 5;//factor que marca la distancia entre puntos respecto al grosor del punto en punteado2 y pincelPluma
  var espaciado = densidad * 5;//separacin entre pinceladas en pincel compuesto
  var pincel = 10;//radio del area donde se dibujan los puntos en pincel aleatorio y del borrador
  var anchopluma = 2;//en pincel pluma el ancho en el que hay trazos
  var grosorpluma = 1;//Grosor de los trazos en pincel pluma
  var canvasWidth;
  var canvasHeight;

  
  function init () {
    // Localiza el elemento canvas.
    canvaso = document.getElementById('imageView');
    if (!canvaso) {
      alert('Error: No puedo encontrar el elemento canvas!');
      return;
    }
   altoNuevo = canvaso.height;
   anchoNuevo = canvaso.width;
    if (!canvaso.getContext) {
      alert('Error: no canvas.getContext!');
      return;
    }

    // Toma el 2D canvas context.
    contexto = canvaso.getContext('2d');
    if (!contexto) {
      alert('Error: Necesitas un navegador ms moderno para poder ver esta aplicacin!');
      return;
    }
	
    // Crea contexto para canvas que est encima de todo
	
    canvasTop = document.getElementById('imageTop');	
    contextTop = canvasTop.getContext('2d');
    if (!contextTop) {
      alert('Error: failed to getContext!');
      return;
    }	
	
	canvasWidth = canvaso.width;
	canvasHeight = canvaso.height;
	
	//Ponemos fondo color
	fondoColor();
	

    // Aade un canvas temporal.
    var container = canvaso.parentNode;
    canvas = document.createElement('canvas');
    if (!canvas) {
    alert('Error: No puedo crar un nuevo lienzo!');
    return;
    }
    canvas.id     = 'imageTemp';
    canvas.width  = canvaso.width;
    canvas.height = canvasHeight - 22;
	contTemp = document.getElementById('contenedor1');
    contTemp.appendChild(canvas);
    context = canvas.getContext('2d');



    // Activa la herramienta por defecto.
    if (tools[tool_default]) {
      tool = new tools[tool_default]();
    }
	//Pone por defecto el cursor lapiz
	$('canvas').css("cursor","url(imagenes/cursores/cursor_cubo.png),auto");
	

    // Coloca mousedown, mousemove and mouseup event listeners.
    canvas.addEventListener('mousedown', ev_canvas, false);
    canvas.addEventListener('mousemove', ev_canvas, false);
    canvas.addEventListener('mouseup',  ev_canvas, false);
	canvas.addEventListener('dblclick',  ev_canvas, false);
	canvas.addEventListener('mouseout',  ev_canvas, false);
	canvaso.addEventListener('mouseup',  ev_canvas, false);
	
	//Eventos cuando se presiona una tecla
	window.onkeydown = function(evt) {
	evt = evt || window.event;
	if (evt.keyCode === 17) {
		keyControl = true;
		}
	}
	window.onkeyup = function(evt) {
	evt = evt || window.event;
		if (evt.keyCode === 17) {
			keyControl = false;
		}else if(evt.keyCode === 90 &&(keyControl)){//Deshace al presionar Ctrl + z
		undoDraw();
		}
	}
	//Evita seleccion azul
	document.onselectstart = function() {
	return false;
	}
	
	//si existe almacenada imagen de anterior trabajo en navegador la carga

	if (localStorage.dibujo_warhol){
		if (confirm('Quieres recuperar el ltimo trabajo que se hizo con esta aplicacin?')) {
			localStorageImage = new Image();
			localStorageImage.addEventListener("load", function(event){
				localStorageImage.removeEventListener(event.type, arguments.callee, false);
				contexto.drawImage(localStorageImage,0,0);
			}, false);
			localStorageImage.src = localStorage.dibujo_warhol;	
		}else{ponerFondo(imagenFondo);return}
	}else{ponerFondo(imagenFondo);return}

	//Pone imagen por encima
	//ponerRejilla();

}
	
	//Abre ventana para escribir texto en canvas
	$('#texto').click( function() {
		document.getElementById('text-controls').style.display = 'block';
		var textE1 = document.getElementById('text');
		//textE1.focus();
	})
	//Coloca texto al aceptar
	$('#botonTexto').click(function (){
		saveActions();
		contexto.save();
		contexto.fillStyle = colorFondo;
		contexto.fillRect(0,523, canvaso.width, 22);//rellena con color de fondo Si fuera una imagen habra que recargarla
		contexto.restore();
		titulo = document.getElementById('text').value;
		contexto.font = "12pt Verdana";
		contexto.fillStyle = "black";
		contexto.fillText(titulo, 20, 540);
		saveLocalStorage();
		document.getElementById('text-controls').style.display = 'none';
	})
	//Cierra ventana de colocar texto
	$('#botonTexCan').click(function (){document.getElementById('text-controls').style.display = 'none'});
	
	// Controlador de evento general. Esta funcin determina la
	// posicion relativa del ratn respecto al elemento canvas.Da las coordenadas del raton dentro del canvas
	function ev_canvas (ev) {
		if (ev.layerX || ev.layerX == 0) { // Firefox
		  ev._x = Math.round(ev.layerX / canvasScale);//multiplicamos por canvasScale para conpensar zoom
		  ev._y = Math.round(ev.layerY / canvasScale);
		} else if (ev.offsetX || ev.offsetX == 0) { // Opera
		  ev._x = Math.round(ev.offsetX / canvasScale);
		  ev._y = Math.round(ev.offsetY / canvasScale);
		}

		// Llama al manejador del evento de la herramienta
		var func = tool[ev.type];
		if (func) {
		  func(ev);
		}
	}

	// Esta funcin dibuja #imageTemp canvas encima de #imageView, despus
	// #imageTemp se limpia. Esto se realiza cada vez que el usuario
	// completa unaa operacin de dibujo.
	function img_update () {
  		saveActions();//Guarda copia de la imagen
		contexto.drawImage(canvas, 0, 0);//copia imagen temporal en definitiva
		context.clearRect(0, 0, canvas.width, canvas.height);//Limpia la imagen temporal
		redoHistory = [];
		saveLocalStorage();

	}
	//Function guarda imagen en array para poder deshacer
	function saveActions() {
		var imgData = document.getElementById("imageView").toDataURL("image/png");
		undoHistory.push(imgData);//guarda imagen en matriz deshacer
	}
	//Guarda imagen en el cache del navegador
	function saveLocalStorage(){
		var imgData = document.getElementById("imageView").toDataURL("image/png");
		localStorage.dibujo_warhol = imgData;//guarda imagen en el cache del navegador
	}
	
	//Funcin pone fondo de color
	function fondoColor(){
	contexto.save();
	contexto.fillStyle = colorFondo;
	contexto.fillRect(0,0, canvaso.width, canvaso.height);
	contexto.restore();
	}
	
	//Funcion deshacer
	function undoDraw(){
		if(undoHistory.length > 0){
		var imgData = document.getElementById("imageView").toDataURL("image/png");
		redoHistory.push(imgData);//Guarda la imagen actual en array rehacer
        var undoImg = new Image();
			undoImg.onload = function(){//funcion para que le de tiempo a cargar la imagen
			contexto.drawImage(undoImg, 0,0);//copia imagen rescatada en canvas
			var imgData = document.getElementById("imageView").toDataURL("image/png");
			localStorage.dibujo_bodegon_punto = imgData;//guarda imagen en el cache del navegador
			};
			undoImg.src = undoHistory.pop();//saca ultima imagen guardada en el array y la guarda en undoImg
        } else if(undoHistory.length == 0){
		return
		}		
	}
	
	function redoDraw(){
		if(redoHistory.length > 0){
		saveActions();
        var redoImg = new Image();
			redoImg.onload = function(){//funcion para que le de tiempo a cargar la imagen
			contexto.drawImage(redoImg, 0,0);//copia imagen rescatada en canvas
			var imgData = document.getElementById("imageView").toDataURL("image/png");
			localStorage.dibujo_bodegon_punto = imgData;//guarda imagen en el cache del navegador
			};
			redoImg.src = redoHistory.pop();//saca ultima imagen guardada en el array y la guarda en redoImg
		}
	}
	
	
	//Pone una imagen como fondo
	function ponerFondo (imagenUrl){
		var img = new Image();
		img.src = imagenUrl;
		img.onload = function(){
		contexto.drawImage(img,0,0,canvas.width,523,0,0,canvas.width,523);
		}
	}
	//Pone imagen de lnea negra por encima para mantenerla siempre
	function ponerRejilla(){
		var imgTop = new Image();
		imgTop.src = imagenFondo;
		imgTop.onload = function(){
		contexto.drawImage(imgTop,0,0,canvas.width,523,0,0,canvas.width,523);
		}
	}
	//Control del boton limpiar
    $('#reset').click(function() {
        if (confirm('Se reiniciar el ejercicio y se perder la imagen actual. Ests seguro?')) {
		//canvaso.width = canvaso.width;
		undoHistory.length = 0;//vacia array con estados anteriores
		redoHistory.length = 0;
		contexto.save();
		contexto.fillStyle = colorFondo;
		contexto.fillRect(0,0, canvaso.width, canvaso.height);//rellena con color de fondo Si fuera una imagen habra que recargarla
		contexto.restore();
		ponerRejilla();
        }
    })

	//controlamos el boton guardar imagen
	$('#guardar').click (function() {
	var imgData = document.getElementById("imageView").toDataURL("image/png");
			var ventana = window.open('','imagenGenerada', "toolbar=no,location=no,status=no,menubar=no,resizable=yes,scrollbars=1");
			ventana.document.write('<html><head><title>Imagen Generada</title><meta http-equiv="content-type" content="text/html; charset=iso-8859-1"><link rel="stylesheet" type="text/css" href="css/dibujo_00.css" /> ');
			ventana.document.write('</head>');
			ventana.document.write('<body style="background-color:#F4EDC8">');
			ventana.document.write('<div  style="position:absolute; top:40px; left:50%; margin-left: -375px;  width:750px; height:545px; box-shadow: -2px 2px 10px 1px #999;"><div style="position:relative"></div><div><img src="');
			ventana.document.write(imgData);
			ventana.document.write('"width="750" height="545">');
			ventana.document.write('</div><br><div style="border-width:1;border-color:#901420;border-style:dashed;border-radius:15px; margin-top: 50px;margin-left: 150px; margin-right: 150px; margin-bottom: 20px; padding-left:20px; padding-right:20px; font-family:Verdana;font-size:16px;background-color:#f3f0e7;text-align:center">');
			ventana.document.write('<br><br>Para guardar la imagen haz clic sobre ella con el botn derecho. En el men que aparece selecciona: "Guardar imagen como..."');
			ventana.document.write('<br><br><button onclick="window.close();" class="botonVentana">Cerrar Ventana</button><br><br></div><br><br></div></body>');
			ventana.document.close();
	//window.open(document.getElementById("imageView").toDataURL("image/png"),'Canvas Export','height=450,width=625');
	})
	
	//Controla boton para poner o quitar la rejilla
	$('#rejilla').click (function(){
		if(flagRejilla == false){
			ponerRejilla();
			flagRejilla = true;
		}else{
			contextTop.clearRect(0,0,canvas.width,canvas.height);
			flagRejilla = false;
		}
	})

	// tools Contiene la implementacion de cada herramienta
	var tools = {};
	//Controles para saber que botn se ha seleccionado
	$('#lapiz').click(function (){
	tool = new tools['pencil']();
	$('canvas').css("cursor","url(imagenes/cursores/cursor_lapiz.png),auto");
	})
	$('#cubo_pintura').click (function (){
	tool = new tools['cubo_pintura']();
	$('canvas').css("cursor","url(imagenes/cursores/cursor_cubo.png),auto");
	})
	$('#borrar').click(function (){
	tool = new tools['borrador']();
	$('canvas').css("cursor","url(imagenes/cursores/cursor_goma.png),auto");	
	})
	$('#colorPicker').click(function (){
	tool = new tools['cuentagotas']();
	$('canvas').css("cursor","url(imagenes/cursores/cursor_cuenta.png),auto");	
	})
	$('#deshacer').click (function() {
	undoDraw();
	})
	$('#rehacer').click (function() {
	redoDraw();
	})
	
    // Coloca una imagen encima
	function ponerImg(urlImg) {
	var img = new Image();
	img.src = urlImg;
		img.onload = function(){
		context = canvas.getContext('2d');
		context.drawImage(img,0,0,canvasWidth,canvasHeight);
		img_update();
		}
	}
	// Lapiz dibujo libre.
	tools.pencil = function () {
		var tool = this;
		this.started = false;

		// This is called when you start holding down the mouse button.
		// This starts the pencil drawing.
		this.mousedown = function (ev) {
			context.lineWidth = fileteAnc;
			context.lineJoin = "round";		
			context.lineCap = fin;
			context.strokeStyle = relleno;
			//context.strokeStyle = fileteCol;
			context.beginPath();
			context.moveTo(ev._x, ev._y);
			tool.started = true;
		};

		// This function is called every time you move the mouse. Obviously, it only
		// draws if the tool.started state is set to true (when you are holding down
		// the mouse button).
		this.mousemove = function (ev) {
		  if (tool.started) {
			context.lineTo(ev._x, ev._y);
			context.stroke();
		  }
		};

		// This is called when you release the mouse button.
		this.mouseup = function (ev) {
			if (tool.started) {
			tool.mousemove(ev);
			tool.started = false;
			img_update();
			}
		};
	};

    // Cuentagotas
	tools.cuentagotas = function () {
    var tool = this;
		this.mousedown = function (ev) {
		  pixelColor = contexto.getImageData( ev._x,ev._y,1,1);
		  rellenoR = pixelColor.data[0];
		  rellenoG = pixelColor.data[1];
		  rellenoB = pixelColor.data[2];
		  alfaColor();
		  $('#paleta').css('backgroundColor', relleno);
		};

	};

	//Borrador. Si hubiera imagen de fondo habra que copiarla primero cada vez que se hace imgUpdate
	//o colocarla en otro canvas por debajo
	tools.borrador = function () {
    var tool = this;
    this.started = false;

	saveActions();

		this.mousedown = function (ev) {
		  context.lineWidth = 1;
		  pincel = fileteAnc*3;
		  context.strokeStyle = 'black';
		  contexto.fillStyle = 'white';
		  tool.started = true;
		};

		this.mousemove = function (ev) {
		  if (tool.started) {
		  context.clearRect(0, 0, canvas.width, canvas.height);
		  context.strokeRect( ev._x-pincel/2, ev._y-pincel/2, pincel, pincel);
		  // contexto.clearRect( ev._x-pincel/2, ev._y-pincel/2, pincel, pincel);//elimina fondo
		  contexto.fillRect( ev._x-pincel/2, ev._y-pincel/2, pincel, pincel);//pinta con color de fondo
		  }
		};

		this.mouseup = function (ev) {
		  if (tool.started) {
			tool.mousemove(ev);
			tool.started = false;
			context.clearRect(0, 0, canvas.width, canvas.height);
			img_update ();
			saveActions();
		  }
		};

	};

		//Cubo Pintura
		tools.cubo_pintura = function () {
		var tool = this;
		this.started = false;

			this.mousedown = function (ev) {
			curColor = { r:rellenoR, g:rellenoG, b:rellenoB};//toma color seleccionado en rgb
			saveActions();
			colorLayerData = contexto.getImageData(0, 0, canvasWidth, canvasHeight);//copia canvas a colorLayerData
			paintAt(ev._x, ev._y);
			saveLocalStorage();
			};
			floodFill = function (startX, startY, startR, startG, startB) {


					var newPos,
						x,
						y,
						pixelPos,
						reachLeft,
						reachRight,
						drawingBoundLeft = 0,
						drawingBoundTop = 0,
						drawingBoundRight = canvasWidth,
						drawingBoundBottom = canvasHeight-22;
						pixelStack = [[startX, startY]];

					while (pixelStack.length) {

						newPos = pixelStack.pop();
						x = newPos[0];
						y = newPos[1];

						// Get current pixel position
						pixelPos = (y * canvasWidth + x) * 4;

						// Go up as long as the color matches and are inside the canvas
						while (y >= drawingBoundTop && matchStartColor(pixelPos, startR, startG, startB)) {
							y -= 1;
							pixelPos -= canvasWidth * 4;
						}

						pixelPos += canvasWidth * 4;
						y += 1;
						reachLeft = false;
						reachRight = false;

						// Go down as long as the color matches and in inside the canvas
						while (y <= drawingBoundBottom && matchStartColor(pixelPos, startR, startG, startB)) {
							y += 1;

							colorPixel(pixelPos, curColor.r, curColor.g, curColor.b);

							if (x > drawingBoundLeft) {
								if (matchStartColor(pixelPos - 4, startR, startG, startB)) {
									if (!reachLeft) {
										// Add pixel to stack
										pixelStack.push([x - 1, y]);
										reachLeft = true;
									}
								} else if (reachLeft) {
									reachLeft = false;
								}
							}

							if (x < drawingBoundRight) {
								if (matchStartColor(pixelPos + 4, startR, startG, startB)) {
									if (!reachRight) {
										// Add pixel to stack
										pixelStack.push([x + 1, y]);
										reachRight = true;
									}
								} else if (reachRight) {
									reachRight = false;
								}
							}

							pixelPos += canvasWidth * 4;
						}
					}

				},


			clearCanvas = function () {
			contexto.clearRect(0, 0,canvasWidth, canvasHeight);
			}

			matchStartColor = function (pixelPos, startR, startG, startB) {

				r = colorLayerData.data[pixelPos];
				g = colorLayerData.data[pixelPos + 1];
				b = colorLayerData.data[pixelPos + 2];

				// If the current pixel matches the clicked color
				if (r === startR && g === startG && b === startB) {
					return true;
				}

				// If current pixel matches the new color
				if (r === curColor.r && g === curColor.g && b === curColor.b) {
					return false;
				}
				// If current pixel has different colour
				return false;
			}

			colorPixel = function (pixelPos, r, g, b, a) {

				colorLayerData.data[pixelPos] = r;
				colorLayerData.data[pixelPos + 1] = g;
				colorLayerData.data[pixelPos + 2] = b;
				colorLayerData.data[pixelPos + 3] = a !== undefined ? a : 255;
			};
			paintAt = function (startX, startY) {

				var pixelPos = (startY * canvasWidth + startX) * 4,
					r = colorLayerData.data[pixelPos],
					g = colorLayerData.data[pixelPos + 1],
					b = colorLayerData.data[pixelPos + 2],
					a = colorLayerData.data[pixelPos + 3];

				if (r === curColor.r && g === curColor.g && b === curColor.b) {
					// Return because trying to fill with the same color
					return;
				};

				floodFill(startX, startY, r, g, b);
				contexto.putImageData(colorLayerData, 0, 0);
			}
		}; //fin cubo pintura
	
		//Aumenta de tamao el escritorio
		document.getElementById('zoom_in').onclick = function() {
			if (canvasScale > 2) {
				return;	
			}
			canvasScale = canvasScale * scaleFactor;
			altoNuevo = Math.round(altoNuevo* scaleFactor);
			anchoNuevo = Math.round( anchoNuevo* scaleFactor);
			$('#imageView').css('height',altoNuevo);
			$('#imageView').css('width',anchoNuevo);
			$('.lienzo').css('height',altoNuevo);
			$('.lienzo').css('width',anchoNuevo);
			$('#imageTemp').css('height',altoNuevo-(22*canvasScale));
			$('#imageTemp').css('width',anchoNuevo);
			$('#imageTop').css('height',altoNuevo);
			$('#imageTop').css('width',anchoNuevo);
			objeto = document.getElementById('herram');
			objeto.style.height = altoNuevo +'px';
		}
	
		//Disminuye de tamao el escritorio
		document.getElementById('zoom_out').onclick = function() {
			if (canvasScale < 0.9) {
				return;	
			}
			canvasScale = canvasScale / scaleFactor;
			altoNuevo = Math.round(altoNuevo * (1 / scaleFactor));
			anchoNuevo = Math.round(anchoNuevo * (1 / scaleFactor));
			$('#imageView').css('height',altoNuevo);
			$('#imageView').css('width',anchoNuevo);
			$('.lienzo').css('height',altoNuevo);
			$('.lienzo').css('width',anchoNuevo);
			$('#imageTemp').css('height',altoNuevo-(22 * canvasScale));
			$('#imageTemp').css('width',anchoNuevo);
			$('#imageTop').css('height',altoNuevo);
			$('#imageTop').css('width',anchoNuevo);
			objeto = document.getElementById('herram');
			objeto.style.height = altoNuevo +'px';
		}
		
		//Psteriza la imagen a blanco, negro y dos grises
		function filtroGrises(xC,yC,anc,alt){
		canvasData = contexto.getImageData(0, 0, canvasWidth, canvasHeight);
		pixel = canvasData.data;
			for (var x = 0; x < canvasWidth; x++) {
				for (var y = 0; y < canvasHeight; y++) {

					var idx = (x + y * canvasWidth) * 4;

					var r = pixel[idx + 0];
					var g = pixel[idx + 1];
					var b = pixel[idx + 2];
					var a = pixel[idx + 3];
				
					
					var v = (r+g+b)/3;
					if (v <= 60){
					pixel[idx + 0] = pixel[idx + 1] = pixel[idx + 2] = 0;
					}else if (v > 60 && v <= 120){
					pixel[idx + 0] = pixel[idx + 1] = pixel[idx + 2] = 80;
					}else if (v >120 && v <= 180){
					pixel[idx + 0] = pixel[idx + 1] = pixel[idx + 2] = 160;
					}else {
					pixel[idx + 0] = pixel[idx + 1] = pixel[idx + 2] = 254;
					}
				}
			}
			fondoColor();	
			anc2 = anc/2-1;
			alt2 = alt/2-1;
			context.putImageData(canvasData, 0, 0);
			contexto.drawImage(canvas, 0, 0, anc,alt,xC,yC,anc2,alt2);
			contexto.drawImage(canvas, 0, 0, anc,alt,375,yC,anc2,alt2);
			contexto.drawImage(canvas, 0, 0, anc,alt,xC,262,anc2,alt2);
			contexto.drawImage(canvas, 0, 0, anc,alt,375,262,anc2,alt2);
			context.clearRect(0, 0, canvas.width, canvas.height);
		}

		//Importa imagen desde archivo y la coloca como fondo del canvas fabric
		formEl = document.forms[0],
		fileEl = formEl.elements[0],

		formEl.onsubmit = fileEl.onchange = uploadHandler;
//
		function uploadHandler() {
		uploadFile(fileEl.files && fileEl.files[0]);
		return false;
		}		
		$('#subirArc').click(function(){fileEl.click()});
		
		//Sube archivo de imagen desde el ordenador
		function uploadFile(file) {
			if (file && file.type && file.type.match(/^image\/.*/)) {
				var fileReader = new FileReader();
				fileReader.onload = function(e) {
					var dataURL = e.target.result;
					var newImg = new Image();
					newImg.onload = ajustar;
					newImg.src = dataURL;
					contexto.clearRect(0, 0, canvas.width, canvas.height);	
					function ajustar(){
						
						alto = newImg.height;
						ancho = newImg.width;
						altoCanvas =canvaso.height-22;
						if(ancho/alto >= canvaso.width/altoCanvas){
							yCoor = (Math.floor(altoCanvas-canvaso.width*(alto/ancho)))/2;
							altoPNG = Math.floor(canvaso.width*alto/ancho);
							contexto.drawImage(newImg,0,0,canvaso.width,altoPNG);
							filtroGrises(0,yCoor,750,altoPNG);
							return
						}else{
							xCoor = (Math.floor(canvas.width-altoCanvas*(ancho/alto)))/2;
							anchoPNG = Math.floor(altoCanvas*ancho/alto);
							contexto.drawImage(newImg,0,0,anchoPNG,altoCanvas);
							filtroGrises(xCoor,0,anchoPNG,523);
						}
					}
				}
			fileReader.readAsDataURL(file);
			}return
		}

	init();

}, false); }
