// Keep everything in anonymous function, called on window load.
if(window.addEventListener) {
window.addEventListener('load', function () {
  var canvas, context, canvaso, contexto;

  // Variables de herramientas.
  var tool;
  flag1 = 0;
  flagSnap = 1;
  polygons2 = [];
  var flagRejilla = true;
  var undoHistory = new Array();//Matriz que guarda imagenes para el deshacer
  var redoHistory = new Array();//Matriz que guarda imagenes para el rehacer
  var tool_default = 'poligono';
  var imagenEncima = "";
  var imagenFondo = "";
  rellenoR = 255;
  rellenoG = 0;
  rellenoB = 0;
  grid = 1;
  var fin = 'round';
  var colorFondo = '#f3f0e7';//color de fondo y del borrador
  var radioPuntos = 1.5;//radio de crculos en punteado
  var densidad = 5;//factor que marca la distancia entre puntos respecto al grosor del punto en punteado2 y pincelPluma
  var espaciado = densidad * 5;//separacin entre pinceladas en pincel compuesto
  var pincel = 10;//radio del area donde se dibujan los puntos en pincel aleatorio y del borrador
  var anchopluma = 2;//en pincel pluma el ancho en el que hay trazos
  var grosorpluma = 1;//Grosor de los trazos en pincel pluma
  var canvasWidth;
  var canvasHeight;
	
	//Variables de poligono regular
  	lado=80;
	angulo = 90;
	nlados = 7;
	
	
  function init () {
    // Localiza el elemento canvas.
    canvaso = document.getElementById('imageView');
    if (!canvaso) {
      alert('Error: No puedo encontrar el elemento canvas!');
      return;
    }
   altoNuevo = canvaso.height;
   anchoNuevo = canvaso.width;
    if (!canvaso.getContext) {
      alert('Error: no canvas.getContext!');
      return;
    }

    // Toma el 2D canvas context.
    contexto = canvaso.getContext('2d');
    if (!contexto) {
      alert('Error: failed to getContext!');
      return;
    }
	
    // Crea contexto para canvas que est encima de todo
	
    canvasTop = document.getElementById('imageTop');	
    contextTop = canvasTop.getContext('2d');
    if (!contextTop) {
      alert('Error: failed to getContext!');
      return;
    }
	
	// Crea contexto para canvas que est debajo de todo
	
    canvasBot = document.getElementById('imageBot');	
    contextBot = canvasBot.getContext('2d');
    if (!contextBot) {
      alert('Error: failed to getContext!');
      return;
    }
	
	canvasWidth = canvaso.width;
	canvasHeight = canvaso.height;

	/*
	//Ponemos fondo de color
	contexto.save();
	contexto.fillStyle = colorFondo;
	contexto.fillRect(0,0, canvaso.width, canvaso.height);
	contexto.restore();
	*/

    // Aade un canvas temporal.
    var container = canvaso.parentNode;
    canvas = document.createElement('canvas');
    if (!canvas) {
    alert('Error: No puedo crar un nuevo lienzo!');
    return;
    }
    canvas.id     = 'imageTemp';
    canvas.width  = canvaso.width;
    canvas.height = canvasHeight;
	contTemp = document.getElementById('contenedor1');
    contTemp.appendChild(canvas);
    context = canvas.getContext('2d');

    // Activa la herramienta por defecto.
    if (tools[tool_default]) {
      tool = new tools[tool_default]();
    }
	//Pone por defecto el cursor lpiz
	$('canvas').css("cursor","url(imagenes/cursores/cursor_lapiz.png),auto");

    // Coloca mousedown, mousemove and mouseup event listeners.
    canvas.addEventListener('mousedown', ev_canvas, false);
    canvas.addEventListener('mousemove', ev_canvas, false);
    canvas.addEventListener('mouseup',  ev_canvas, false);
	canvas.addEventListener('dblclick',  ev_canvas, false);
	canvas.addEventListener('mouseout',  ev_canvas, false);
	canvaso.addEventListener('mouseup',  ev_canvas, false);
	
	//Eventos cuando se presiona una tecla
	window.onkeydown = function(evt) {
	evt = evt || window.event;
	if (evt.keyCode === 17) {
		keyControl = true;
		}
	}
	window.onkeyup = function(evt) {
	evt = evt || window.event;
		if (evt.keyCode === 17) {
			keyControl = false;
		}else if(evt.keyCode === 90 &&(keyControl)){//Deshace al presionar Ctrl + z
		undoDraw();
		}
	}
	//Asignamos canvas a Generador de poligonos regulares
	rpGen = new RegularPolygonGenerator('imageTemp');
	
	//Evita seleccion azul
	document.onselectstart = function() {
	return false;
	}
	//Ponemos fondo color
	fondoColor();
	sinRelleno();
}

	//Abre ventana para escribir texto en canvas
	$('#texto').click( function() {
		document.getElementById('text-controls').style.display = 'block';
		var textE1 = document.getElementById('text');
		//textE1.focus();
	})
	//Coloca texto al aceptar
	$('#botonTexto').click(function (){
		saveActions();
		contexto.save();
		contexto.fillStyle = '#ffffff';
		contexto.fillRect(0,523, canvaso.width, 22);//rellena con color de fondo Si fuera una imagen habra que recargarla
		contexto.restore();
		titulo = document.getElementById('text').value;
		contexto.font = "12pt Verdana";
		contexto.fillStyle = "black";
		contexto.fillText(titulo, 20, 540);
		saveLocalStorage();
		document.getElementById('text-controls').style.display = 'none';
	})
	//Cierra ventana de colocar texto
	$('#botonTexCan').click(function (){document.getElementById('text-controls').style.display = 'none'});
	
	// Controlador de evento general. Esta funcin determina la
	// posicion relativa del ratn respecto al elemento canvas.Da las coordenadas del raton dentro del canvas
	function ev_canvas (ev) {
	
	rect = canvas.getBoundingClientRect();//
	root = document.body;

        // posicion relativa del ratn
        ev._x = (ev.pageX - rect.top - root.scrollTop)/ canvasScale;
        ev._y = (ev.pageY - rect.left - root.scrollLeft)/ canvasScale;
		if(flagSnap == 1){	
			for (i = 0; i < polygons2.length; i++)
			{
				dx = polygons2[i].x - ev._x;
				dy = polygons2[i].y - ev._y;
				d = dx * dx + dy * dy;

				if (d < 100)
				{
					ev._x = polygons2[i].x;
					ev._y = polygons2[i].y;
				}
			}
		}
		// Llama al manejador del evento de la herramienta
		var func = tool[ev.type];
		if (func) {
		  func(ev);
		}
	}

	// Esta funcin dibuja #imageTemp canvas encima de #imageView, despus
	// #imageTemp se limpia. Esto se realiza cada vez que el usuario
	// completa unaa operacin de dibujo.
	function img_update () {
  		saveActions();//Guarda copia de la imagen
		contexto.drawImage(canvas, 0, 0);//copia imagen temporal en definitiva
		context.clearRect(0, 0, canvas.width, canvas.height);//Limpia la imagen temporal
		redoHistory = [];
	}
	//Function guarda imagen en array para poder deshacer
	function saveActions() {
		var imgData = document.getElementById("imageView").toDataURL("image/png");
		undoHistory.push(imgData);//guarda imagen en matriz deshacer
	}

	
	//Funcion deshacer
	function undoDraw(){
		if(undoHistory.length > 0){
		var imgData = document.getElementById("imageView").toDataURL("image/png");
		redoHistory.push(imgData);//Guarda la imagen actual en array rehacer
		
        var undoImg = new Image();
			undoImg.onload = function(){//funcion para que le de tiempo a cargar la imagen
			contexto.clearRect(0,0, canvaso.width, canvaso.height);//necesario si no tenemos fondo
			contexto.drawImage(undoImg, 0,0);//copia imagen rescatada en canvas
			};
			undoImg.src = undoHistory.pop();//saca ultima imagen guardada en el array y la guarda en undoImg
        } else if(undoHistory.length == 0){
		return
		}		
	}
	
	function redoDraw(){
		if(redoHistory.length > 0){
		saveActions();
		
        var redoImg = new Image();
			redoImg.onload = function(){//funcion para que le de tiempo a cargar la imagen
			contexto.clearRect(0,0, canvaso.width, canvaso.height);//necesario si no tenemos fondo
			contexto.drawImage(redoImg, 0,0);//copia imagen rescatada en canvas
			var imgData = document.getElementById("imageView").toDataURL("image/png");
			localStorage.dibujo_00 = imgData;//guarda imagen en el cache del navegador
			};
			redoImg.src = redoHistory.pop();//saca ultima imagen guardada en el array y la guarda en redoImg
		}
	}
	
	

	
	//Funcin pone fondo de color
	function fondoColor(){
	contexto.save();
	contexto.fillStyle = colorFondo;
	contexto.fillRect(0,0, canvaso.width, canvaso.height);
	contexto.restore();
	}
	//Control del boton limpiar
    $('#reset').click(function() {
        if (confirm('Se reiniciar el ejercicio y se perder la imagen actual. Ests seguro?')) {
		//canvaso.width = canvaso.width;
		undoHistory.length = 0;//vacia array con estados anteriores
		redoHistory.length = 0;
		contexto.clearRect(0,0, canvaso.width, canvaso.height);//Limpia
		polygons2 = [];
		fondoColor();
		}
    })

	
	//controlamos el boton guardar imagen
	$('#guardar').click (function() {
		context.save();
		context.fillStyle = colorFondo;
		context.fillRect(0,0, canvaso.width, canvaso.height);
		context.restore();
		context.drawImage(canvaso,0,0,750,545);
		context.drawImage(canvasTop,0,0,750,545);//Descomentar si se quiere que aparezca la imagen de fondo por debajo
		
		imgData = canvas.toDataURL("image/png");
			var ventana = window.open('','imagenGenerada', "toolbar=no,location=no,status=no,menubar=no,resizable=yes,scrollbars=1");
			ventana.document.write('<html><head><title>Imagen Generada</title><meta http-equiv="content-type" content="text/html; charset=iso-8859-1"><link rel="stylesheet" type="text/css" href="css/dibujo_00.css" /> ');
			ventana.document.write('</head>');
			ventana.document.write('<body style="background-color:#F4EDC8">');
			ventana.document.write('<div  style="position:absolute; top:40px; left:50%; margin-left: -375px;  width:750px; height:545px; box-shadow: -2px 2px 10px 1px #999;"><div style="position:relative"></div><div><img src="');
			ventana.document.write(imgData);
			ventana.document.write('"width="750" height="545">');
			ventana.document.write('</div><br><div style="border-width:1;border-color:#901420;border-style:dashed;border-radius:15px; margin-top: 50px;margin-left: 150px; margin-right: 150px; margin-bottom: 20px; padding-left:20px; padding-right:20px; font-family:Verdana;font-size:16px;background-color:#f3f0e7;text-align:center">');
			ventana.document.write('<br><br>Para guardar la imagen haz clic sobre ella con el botn derecho. En el men que aparece selecciona: "Guardar imagen como..."');
			ventana.document.write('<br><br><button onclick="window.close();" class="botonVentana">Cerrar Ventana</button><br><br></div><br><br></div></body>');
			ventana.document.close();
		context.clearRect(0,0, canvaso.width, canvaso.height);
	})
	
	// tools Contiene la implementacion de cada herramienta
	var tools = {};
	//Controles para saber que botn se ha seleccionado
	$('#cubo_pintura').click (function (){
	flagSnap = 0;
	tool = new tools['cubo_pintura']();
	$('canvas').css("cursor","url(imagenes/cursores/cursor_cubo.png),auto");
	})
	$('#poliReg').click (function (){
	flagSnap = 1;
	tool = new tools['poligono']();
	$('canvas').css("cursor","crosshair");
	})
	$('#colorPicker').click(function (){
	tool = new tools['cuentagotas']();
	$('canvas').css("cursor","url(imagenes/cursores/cursor_cuenta.png),auto");	
	})
	$('#deshacer').click (function() {
	undoDraw();
	})
	$('#rehacer').click (function() {
	redoDraw();
	})

	// Cuentagotas
		tools.cuentagotas = function () {
		var tool = this;
			this.mousedown = function (ev) {
			  pixelColor = contexto.getImageData( ev._x,ev._y,1,1);
			  rellenoR = pixelColor.data[0];
			  rellenoG = pixelColor.data[1];
			  rellenoB = pixelColor.data[2];
			  alfaColor();
			  $('#paleta').css('backgroundColor', relleno);
			  $('#paleta').html('&nbsp');
			};

		};
	
  // Herramienta Poligono Regular.
	tools.poligono = function () {
    var tool = this;
    this.started = false;

		this.mousedown = function (ev) {
		tool.started = true;
		tool.x0 = ev._x;
		tool.y0 = ev._y;
		};

		this.mousemove = function (ev) {
			if (!tool.started) {
			return;
			}
			
			xCoo = tool.x0;
			yCoo = tool.y0;
			w = Math.abs(ev._x - tool.x0),
			h = Math.abs(ev._y - tool.y0);
			lado = Math.sqrt(w * w + h * h);
			difX = Math.abs(ev._x - tool.x0);
			difY = Math.abs(ev._y - tool.y0);
			angulo = (Math.atan(difY/difX)*360)/(2*Math.PI);
			if(Math.abs(ev._y) < tool.y0){
				if(Math.abs(ev._x) < tool.x0){
				angulo = angulo + 180;
				}else{
				angulo = 360 - angulo;
				}
			}else{
				if(Math.abs(ev._x) < tool.x0){
				angulo = 180 - angulo;
				}else{
				angulo = angulo;
				}				
			}
			context.clearRect(0, 0, canvas.width, canvas.height);
			rpGen.clear();
			if (!lado) {
				return;
			}
			var Poligono = {
				n:nlados,
				strokeStyle:fileteCol,
				fillStyle:rellenoAlfa,
				lineWidth:fileteAnc,
				lSide:-lado,
				x:xCoo,
				y:yCoo,
				rotationAngle:angulo+360/nlados
			};
			
			rpGen.generate(Poligono);
			rpGen.draw();
			
		};
		this.mouseup = function (ev) {
			if (tool.started) {
				flag1 = 1;
				tool.mousemove(ev);
				flag1 = 0;
				tool.started = false;
				img_update();
			}
		};
	};

	$('#numLados').change(function (){nlados = $('#numLados').val()});
	
	//Cubo Pintura
	tools.cubo_pintura = function () {
    var tool = this;
    this.started = false;

		this.mousedown = function (ev) {
		curColor = { r:rellenoR, g:rellenoG, b:rellenoB};//toma color seleccionado en rgb
		saveActions();
		colorLayerData = contexto.getImageData(0, 0, canvasWidth, canvasHeight);//copia canvas a colorLayerData
		paintAt(ev._x, ev._y);
		saveLocalStorage();
		};
		floodFill = function (startX, startY, startR, startG, startB) {


				var newPos,
					x,
					y,
					pixelPos,
					reachLeft,
					reachRight,
					drawingBoundLeft = 0,
					drawingBoundTop = 0,
					drawingBoundRight = canvasWidth,
					drawingBoundBottom = canvasHeight-22;
					pixelStack = [[startX, startY]];

				while (pixelStack.length) {

					newPos = pixelStack.pop();
					x = newPos[0];
					y = newPos[1];

					// Get current pixel position
					pixelPos = (y * canvasWidth + x) * 4;

					// Go up as long as the color matches and are inside the canvas
					while (y >= drawingBoundTop && matchStartColor(pixelPos, startR, startG, startB)) {
						y -= 1;
						pixelPos -= canvasWidth * 4;
					}

					pixelPos += canvasWidth * 4;
					y += 1;
					reachLeft = false;
					reachRight = false;

					// Go down as long as the color matches and in inside the canvas
					while (y <= drawingBoundBottom && matchStartColor(pixelPos, startR, startG, startB)) {
						y += 1;

						colorPixel(pixelPos, curColor.r, curColor.g, curColor.b);

						if (x > drawingBoundLeft) {
							if (matchStartColor(pixelPos - 4, startR, startG, startB)) {
								if (!reachLeft) {
									// Add pixel to stack
									pixelStack.push([x - 1, y]);
									reachLeft = true;
								}
							} else if (reachLeft) {
								reachLeft = false;
							}
						}

						if (x < drawingBoundRight) {
							if (matchStartColor(pixelPos + 4, startR, startG, startB)) {
								if (!reachRight) {
									// Add pixel to stack
									pixelStack.push([x + 1, y]);
									reachRight = true;
								}
							} else if (reachRight) {
								reachRight = false;
							}
						}

						pixelPos += canvasWidth * 4;
					}
				}

			},


		clearCanvas = function () {
		contexto.clearRect(0, 0,canvasWidth, canvasHeight);
		}

		matchStartColor = function (pixelPos, startR, startG, startB) {

			r = colorLayerData.data[pixelPos];
			g = colorLayerData.data[pixelPos + 1];
			b = colorLayerData.data[pixelPos + 2];

			// If the current pixel matches the clicked color
			if (r === startR && g === startG && b === startB) {
				return true;
			}

			// If current pixel matches the new color
			if (r === curColor.r && g === curColor.g && b === curColor.b) {
				return false;
			}
			// If current pixel has different colour
			return false;
		}

		colorPixel = function (pixelPos, r, g, b, a) {

			colorLayerData.data[pixelPos] = r;
			colorLayerData.data[pixelPos + 1] = g;
			colorLayerData.data[pixelPos + 2] = b;
			colorLayerData.data[pixelPos + 3] = a !== undefined ? a : 255;
		};
		paintAt = function (startX, startY) {

			var pixelPos = (startY * canvasWidth + startX) * 4,
				r = colorLayerData.data[pixelPos],
				g = colorLayerData.data[pixelPos + 1],
				b = colorLayerData.data[pixelPos + 2],
				a = colorLayerData.data[pixelPos + 3];

			if (r === curColor.r && g === curColor.g && b === curColor.b) {
				// Return because trying to fill with the same color
				return;
			};

			floodFill(startX, startY, r, g, b);
			contexto.putImageData(colorLayerData, 0, 0);
		}
	}; //fin cubo pintura
	
	//Aumenta de tamao el escritorio
	document.getElementById('zoom_in').onclick = function() {
		if (canvasScale > 2) {
			return;	
		}
		canvasScale = canvasScale * scaleFactor;
		altoNuevo = Math.round(altoNuevo* scaleFactor);
		anchoNuevo = Math.round( anchoNuevo* scaleFactor);
		$('#imageView').css('height',altoNuevo);
		$('#imageView').css('width',anchoNuevo);
		$('.lienzo').css('height',altoNuevo);
		$('.lienzo').css('width',anchoNuevo);
		$('#imageTemp').css('height',altoNuevo);
		$('#imageTemp').css('width',anchoNuevo);
		$('#imageTop').css('height',altoNuevo);
		$('#imageTop').css('width',anchoNuevo);
		$('#imageBot').css('height',altoNuevo);
		$('#imageBot').css('width',anchoNuevo);
		objeto = document.getElementById('herram');
		objeto.style.height = altoNuevo +'px';
	}
	
	//Disminuye de tamao el escritorio
	document.getElementById('zoom_out').onclick = function() {
		if (canvasScale < 0.9) {
			return;	
		}
		canvasScale = canvasScale / scaleFactor;
		altoNuevo = Math.round(altoNuevo * (1 / scaleFactor));
		anchoNuevo = Math.round(anchoNuevo * (1 / scaleFactor));
		$('#imageView').css('height',altoNuevo);
		$('#imageView').css('width',anchoNuevo);
		$('.lienzo').css('height',altoNuevo);
		$('.lienzo').css('width',anchoNuevo);
		$('#imageTemp').css('height',altoNuevo);
		$('#imageTemp').css('width',anchoNuevo);
		$('#imageTop').css('height',altoNuevo);
		$('#imageTop').css('width',anchoNuevo);
		$('#imageBot').css('height',altoNuevo);
		$('#imageBot').css('width',anchoNuevo);
		objeto = document.getElementById('herram');
		objeto.style.height = altoNuevo +'px';
	}
	

	init();

}, false); }
