	var undoHistory = new Array();//Matriz que guarda imagenes para el deshacer
	var redoHistory = new Array();//Matriz que guarda imagenes para el rehacer
    BRUSH_PRESSURE = 1,
    STORAGE = window.localStorage,
    mouseX = 0,
    mouseY = 0,
	rellenoR = 0;
	rellenoG = 0;
	rellenoB = 0;
	colorFondo = "#cccccc";
    shiftKeyIsDown = false,
    altKeyIsDown = false;

init();

function init()
{
	var embed, localStorageImage;
	canvas = document.getElementById('imageView');
	context = canvas.getContext("2d");
	canvasTop = document.getElementById('imageTop');
	contextTop = canvasTop.getContext("2d");
	canvasBot = document.getElementById('imageBot');
	contextBot = canvasBot.getContext("2d");
	contextBot.fillStyle = colorFondo;
	contextBot.fillRect(0,0, canvas.width, canvas.height)

	//Evita seleccion azul
	document.onselectstart = function() {
	return false;
	}
	document.addEventListener("dragenter", onDocumentDragEnter, false);  
	document.addEventListener("dragover", onDocumentDragOver, false);
	document.addEventListener("drop", onDocumentDrop, false);  
	
	canvas.addEventListener('mousedown', onCanvasMouseDown, false);
	canvas.addEventListener('touchstart', onCanvasTouchStart, false);
	brush = new shaded(context);
	
	
}


// WINDOW

function onWindowMouseMove( ev )
{	
	rect = canvas.getBoundingClientRect();//
	root = document.body;
	mouseX = Math.round((ev.pageX - rect.top - root.scrollTop)/ canvasScale);
	mouseY = Math.round((ev.pageY - rect.left - root.scrollLeft)/ canvasScale);
}
// DOCUMENT



function onDocumentDragEnter( event )
{
	event.stopPropagation();
	event.preventDefault();
}

function onDocumentDragOver( event )
{
	event.stopPropagation();
	event.preventDefault();
}

function onDocumentDrop( event )
{
	event.stopPropagation();  
	event.preventDefault();
	
	var file = event.dataTransfer.files[0];
	
	if (file.type.match(/image.*/))
	{
		/*
		 * TODO: This seems to work on Chromium. But not on Firefox.
		 * Better wait for proper FileAPI?
		 */

		var fileString = event.dataTransfer.getData('text').split("\n");
		document.body.style.backgroundImage = 'url(' + fileString[0] + ')';
	}	
}



function onMenuMouseOver()
{
	isMenuMouseOver = true;
}

function onMenuMouseOut()
{
	isMenuMouseOver = false;
}



function onMenuSend()
  {
	formulario();
  }



// CANVAS
	$('canvas').css("cursor","url(imagenes/cursores/cursor_lapiz.png),auto");
	altoNuevo = canvas.height;
	anchoNuevo = canvas.width;
function onCanvasMouseDown( event )
{
	var data, position;
	rect = canvas.getBoundingClientRect();//
	root = document.body;

	BRUSH_PRESSURE =  1;
		img_update ();
	brush.strokeStart(((event.pageX - rect.top - root.scrollTop)/ canvasScale), ((event.pageY - rect.left - root.scrollLeft)/ canvasScale));

	window.addEventListener('mousemove', onCanvasMouseMove, false);
	window.addEventListener('mouseup', onCanvasMouseUp, false);
}

function onCanvasMouseMove( event )
{
	BRUSH_PRESSURE =  1;

	rect = canvas.getBoundingClientRect();//
	root = document.body;
	brush.stroke(((event.pageX - rect.top - root.scrollTop)/ canvasScale), ((event.pageY - rect.left - root.scrollLeft)/ canvasScale));
}

function onCanvasMouseUp()
{
	brush.strokeEnd();
	
	window.removeEventListener('mousemove', onCanvasMouseMove, false);
	window.removeEventListener('mouseup', onCanvasMouseUp, false);
	
}


//

function onCanvasTouchStart( event )
{
	cleanPopUps();		

	if(event.touches.length == 1)
	{
		event.preventDefault();
		
		brush.strokeStart( event.touches[0].pageX, event.touches[0].pageY );
		
		window.addEventListener('touchmove', onCanvasTouchMove, false);
		window.addEventListener('touchend', onCanvasTouchEnd, false);
	}
}

function onCanvasTouchMove( event )
{
	if(event.touches.length == 1)
	{
		event.preventDefault();
		brush.stroke( event.touches[0].pageX, event.touches[0].pageY );
	}
}

function onCanvasTouchEnd( event )
{
	if(event.touches.length == 0)
	{
		event.preventDefault();
		
		brush.strokeEnd();

		window.removeEventListener('touchmove', onCanvasTouchMove, false);
		window.removeEventListener('touchend', onCanvasTouchEnd, false);
	}
}

function saveToLocalStorage()
{
	localStorage.canvas = canvas.toDataURL('image/png');
}
	//Aumenta de tamao el escritorio
	document.getElementById('zoom_in').onclick = function() {
		if (canvasScale > 2) {
			return;	
		}
		canvasScale = canvasScale * scaleFactor;
		altoNuevo = Math.round(altoNuevo* scaleFactor);
		anchoNuevo = Math.round( anchoNuevo* scaleFactor);
		$('#imageView').css('height',altoNuevo);
		$('#imageView').css('width',anchoNuevo);
		$('.lienzo').css('height',altoNuevo);
		$('.lienzo').css('width',anchoNuevo);
		$('#imageTemp').css('height',altoNuevo);
		$('#imageTemp').css('width',anchoNuevo);
		$('#imageTop').css('height',altoNuevo);
		$('#imageTop').css('width',anchoNuevo);
		$('#imageBot').css('height',altoNuevo);
		$('#imageBot').css('width',anchoNuevo);
		objeto = document.getElementById('herram');
		objeto.style.height = altoNuevo +'px';
	}
	
	//Disminuye de tamao el escritorio
	document.getElementById('zoom_out').onclick = function() {
		if (canvasScale < 0.9) {
			return;	
		}
		canvasScale = canvasScale / scaleFactor;
		altoNuevo = Math.round(altoNuevo * (1 / scaleFactor));
		anchoNuevo = Math.round(anchoNuevo * (1 / scaleFactor));
		$('#imageView').css('height',altoNuevo);
		$('#imageView').css('width',anchoNuevo);
		$('.lienzo').css('height',altoNuevo);
		$('.lienzo').css('width',anchoNuevo);
		$('#imageTemp').css('height',altoNuevo);
		$('#imageTemp').css('width',anchoNuevo);
		$('#imageTop').css('height',altoNuevo);
		$('#imageTop').css('width',anchoNuevo);
		$('#imageBot').css('height',altoNuevo);
		$('#imageBot').css('width',anchoNuevo);
		objeto = document.getElementById('herram');
		objeto.style.height = altoNuevo +'px';
	}
	$('#deshacer').click (function() {
	undoDraw();
	})
	$('#rehacer').click (function() {
	redoDraw();
	})
	//Eventos cuando se presiona una tecla
	window.onkeydown = function(evt) {
	evt = evt || window.event;
	if (evt.keyCode === 17) {
		keyControl = true;
		}
	}
	window.onkeyup = function(evt) {
	evt = evt || window.event;
		if (evt.keyCode === 17) {
			keyControl = false;
		}else if(evt.keyCode === 90 &&(keyControl)){//Deshace al presionar Ctrl + z
		undoDraw();
		}
	}
		//Abre ventana para escribir texto en canvas
	$('#texto').click( function() {
		document.getElementById('text-controls').style.display = 'block';
		var textE1 = document.getElementById('text');
		//textE1.focus();
	})
	//Coloca texto al aceptar
	$('#botonTexto').click(function (){
		//saveActions();
		context.save();
		context.fillStyle = '#ffffff';
		context.fillRect(0,523, canvas.width, 22);//rellena con color de fondo Si fuera una imagen habra que recargarla
		context.restore();
		titulo = document.getElementById('text').value;
		context.font = "12pt Verdana";
		context.fillStyle = "black";
		context.fillText(titulo, 20, 540);
		//saveLocalStorage();
		document.getElementById('text-controls').style.display = 'none';
	})
	//Cierra ventana de colocar texto
	$('#botonTexCan').click(function (){document.getElementById('text-controls').style.display = 'none'});
	
		//Control del boton limpiar
    $('#reset').click(function() {
        if (confirm('Se reiniciar el ejercicio y se perder la imagen actual. Ests seguro?')) {
		//canvaso.width = canvaso.width;
		undoHistory.length = 0;//vacia array con estados anteriores
		redoHistory.length = 0;
		context.clearRect(0,0, canvas.width, canvas.height);//Limpia
		init();
		}
    })
	
		//controlamos el boton guardar imagen
	$('#guardar').click (function() {
		contextTop.save();
		contextTop.fillStyle = colorFondo;
		contextTop.fillRect(0,0, canvas.width, canvas.height);
		contextTop.restore();
		contextTop.drawImage(canvas,0,0,750,545);
		//context.drawImage(canvasTop,0,0,750,545);//Descomentar si se quiere que aparezca la imagen de fondo por debajo
		
		imgData = canvasTop.toDataURL("image/png");
			var ventana = window.open('','imagenGenerada', "toolbar=no,location=no,status=no,menubar=no,resizable=yes,scrollbars=1");
			ventana.document.write('<html><head><title>Imagen Generada</title><meta http-equiv="content-type" content="text/html; charset=iso-8859-1"><link rel="stylesheet" type="text/css" href="css/dibujo_00.css" /> ');
			ventana.document.write('</head>');
			ventana.document.write('<body style="background-color:#F4EDC8">');
			ventana.document.write('<div  style="position:absolute; top:40px; left:50%; margin-left: -375px;  width:750px; height:545px; box-shadow: -2px 2px 10px 1px #999;"><div style="position:relative"></div><div><img src="');
			ventana.document.write(imgData);
			ventana.document.write('"width="750" height="545">');
			ventana.document.write('</div><br><div style="border-width:1;border-color:#901420;border-style:dashed;border-radius:15px; margin-top: 50px;margin-left: 150px; margin-right: 150px; margin-bottom: 20px; padding-left:20px; padding-right:20px; font-family:Verdana;font-size:16px;background-color:#f3f0e7;text-align:center">');
			ventana.document.write('<br><br>Para guardar la imagen haz clic sobre ella con el botn derecho. En el men que aparece selecciona: "Guardar imagen como..."');
			ventana.document.write('<br><br><button onclick="window.close();" class="botonVentana">Cerrar Ventana</button><br><br></div><br><br></div></body>');
			ventana.document.close();
		contextTop.clearRect(0,0, canvas.width, canvas.height);
	})
	
	//Funcion deshacer
	function undoDraw(){
		if(undoHistory.length > 0){
		var imgData = document.getElementById("imageView").toDataURL("image/png");
		redoHistory.push(imgData);//Guarda la imagen actual en array rehacer
		
        var undoImg = new Image();
			undoImg.onload = function(){//funcion para que le de tiempo a cargar la imagen
			context.clearRect(0,0, canvas.width, canvas.height);//necesario si no tenemos fondo
			context.drawImage(undoImg, 0,0);//copia imagen rescatada en canvas
			var imgData = document.getElementById("imageView").toDataURL("image/png");
			localStorage.dibujo_harmony = imgData;//guarda imagen en el cache del navegador
			};
			undoImg.src = undoHistory.pop();//saca ultima imagen guardada en el array y la guarda en undoImg
        } else if(undoHistory.length == 0){
		return
		}		
	}
	
	function redoDraw(){
		if(redoHistory.length > 0){
		saveActions();
		
        var redoImg = new Image();
			redoImg.onload = function(){//funcion para que le de tiempo a cargar la imagen
			context.clearRect(0,0, canvas.width, canvas.height);//necesario si no tenemos fondo
			context.drawImage(redoImg, 0,0);//copia imagen rescatada en canvas
			var imgData = document.getElementById("imageView").toDataURL("image/png");
			localStorage.dibujo_harmony = imgData;//guarda imagen en el cache del navegador
			};
			redoImg.src = redoHistory.pop();//saca ultima imagen guardada en el array y la guarda en redoImg
		}
	}
	
		//Si existe almacenada imagen de anterior trabajo en navegador la carga
	if (STORAGE){
		if (localStorage.dibujo_harmony){
			if (confirm('Quieres recuperar el ltimo trabajo que se hizo con esta aplicacin?')) {
				localStorageImage = new Image();
				localStorageImage.addEventListener("load", function(event){
					localStorageImage.removeEventListener(event.type, arguments.callee, false);
					context.drawImage(localStorageImage,0,0);
				}, false);
				localStorageImage.src = localStorage.dibujo_harmony;	
			}
		}
	}
		//Function guarda imagen en array para poder deshacer
	function saveActions() {
		var imgData = document.getElementById("imageView").toDataURL("image/png");
		undoHistory.push(imgData);//guarda imagen en matriz deshacer
	}
	//Guarda imagen en el cache del navegador
	function saveLocalStorage(){
		var imgData = document.getElementById("imageView").toDataURL("image/png");
		localStorage.dibujo_harmony = imgData;//guarda imagen en el cache del navegador
		
	}
		function img_update () {
  		saveActions();//Guarda copia de la imagen
		redoHistory = [];
		saveLocalStorage();
	}
	
	
				//Importa imagen desde archivo y la coloca como fondo del canvas fabric
		formEl = document.forms[0],
		fileEl = formEl.elements[0],

		formEl.onsubmit = fileEl.onchange = uploadHandler;
//
		function uploadHandler() {
		uploadFile(fileEl.files && fileEl.files[0]);
		return false;
		}		
		$('#subirArc').click(function(){fileEl.click()});
		
		//Sube archivo de imagen desde el ordenador
		function uploadFile(file) {
			if (file && file.type && file.type.match(/^image\/.*/)) {
				var fileReader = new FileReader();
				fileReader.onload = function(e) {
					var dataURL = e.target.result;
					var newImg = new Image();
					newImg.onload = ajustar;
					newImg.src = dataURL;
					contextBot.clearRect(0, 0, canvas.width, canvas.height);	
					//fondoColor();
					function ajustar(){
						
						alto = newImg.height;
						ancho = newImg.width;
						altoCanvas =canvas.height-22;
						if(ancho/alto >= canvas.width/altoCanvas){
							yCoor = Math.floor((altoCanvas-canvaso.width*alto/ancho)/2);
							altoPNG = Math.floor(canvas.width*alto/ancho);
							contextBot.drawImage(newImg,0,yCoor,canvas.width,altoPNG);
						return
						}else{
							xCoor = Math.floor((canvas.width-altoCanvas*ancho/alto)/2);
							anchoPNG = Math.floor(altoCanvas*ancho/alto);
							contextBot.drawImage(newImg,xCoor,0,anchoPNG,altoCanvas);
						}
					}
				}
			fileReader.readAsDataURL(file);
			}return
		}
