// Keep everything in anonymous function, called on window load.
if(window.addEventListener) {
window.addEventListener('load', function () {
  var canvas, context, canvaso, contexto;

  // Variables de herramientas.
  var tool;
  var undoHistory = new Array();//Matriz que guarda imagenes para el deshacer
  var redoHistory = new Array();//Matriz que guarda imagenes para el rehacer
  var tool_default = 'cubo_pintura';
  var imagenFondo = "data:image/png;base64,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";
  rellenoR = 207;
  rellenoG = 207;
  rellenoB = 207;
  var fin = 'round';
  var grid = 20;//Tamao de rejilla
  var colorFondo = '#f3f0e7';//color de fondo y del borrador
  var radioPuntos = 1.5;//radio de crculos en punteado
  var densidad = 5;//factor que marca la distancia entre puntos respecto al grosor del punto en punteado2 y pincelPluma
  var espaciado = densidad * 5;//separacin entre pinceladas en pincel compuesto
  var pincel = 10;//radio del area donde se dibujan los puntos en pincel aleatorio y del borrador
  var anchopluma = 2;//en pincel pluma el ancho en el que hay trazos
  var grosorpluma = 1;//Grosor de los trazos en pincel pluma
  var canvasWidth;
  var canvasHeight;

  function init () {
    // Localiza el elemento canvas.
    canvaso = document.getElementById('imageView');
    if (!canvaso) {
      alert('Error: No puedo encontrar el elemento canvas!');
      return;
    }
   altoNuevo = canvaso.height;
   anchoNuevo = canvaso.width;
    if (!canvaso.getContext) {
      alert('Error: no canvas.getContext!');
      return;
    }

    // Toma el 2D canvas context.
    contexto = canvaso.getContext('2d');
    if (!contexto) {
      alert('Error: Necesitas un navegador ms moderno para poder ver esta aplicacin!');
      return;
    }
	
    // Crea contexto para canvas que est encima de todo
	
    canvasTop = document.getElementById('imageTop');	
    contextTop = canvasTop.getContext('2d');
    if (!contextTop) {
      alert('Error: failed to getContext!');
      return;
    }	
	
	canvasWidth = canvaso.width;
	canvasHeight = canvaso.height;
	
	//Ponemos fondo color
	fondoColor();
	

    // Aade un canvas temporal.
    var container = canvaso.parentNode;
    canvas = document.createElement('canvas');
    if (!canvas) {
    alert('Error: No puedo crar un nuevo lienzo!');
    return;
    }
    canvas.id     = 'imageTemp';
    canvas.width  = canvaso.width;
    canvas.height = canvasHeight - 22;
	contTemp = document.getElementById('contenedor1');
    contTemp.appendChild(canvas);
    context = canvas.getContext('2d');



    // Activa la herramienta por defecto.
    if (tools[tool_default]) {
      tool = new tools[tool_default]();
    }
	//Pone por defecto el cursor lpiz
	$('canvas').css("cursor","url(imagenes/cursores/cursor_cubo.png),auto");
	

    // Coloca mousedown, mousemove and mouseup event listeners.
    canvas.addEventListener('mousedown', ev_canvas, false);
    canvas.addEventListener('mousemove', ev_canvas, false);
    canvas.addEventListener('mouseup',  ev_canvas, false);
	canvas.addEventListener('dblclick',  ev_canvas, false);
	canvas.addEventListener('mouseout',  ev_canvas, false);
	canvaso.addEventListener('mouseup',  ev_canvas, false);
	
	//Eventos cuando se presiona una tecla
	window.onkeydown = function(evt) {
	evt = evt || window.event;
	if (evt.keyCode === 17) {
		keyControl = true;
		}
	}
	window.onkeyup = function(evt) {
	evt = evt || window.event;
		if (evt.keyCode === 17) {
			keyControl = false;
		}else if(evt.keyCode === 90 &&(keyControl)){//Deshace al presionar Ctrl + z
		undoDraw();
		}
	}
	//Evita seleccion azul
	document.onselectstart = function() {
	return false;
	}
	
	//si existe almacenada imagen de anterior trabajo en navegador la carga

	if (localStorage.dibujo_escala_acromatica){
		if (confirm('Quieres recuperar el ltimo trabajo que se hizo con esta aplicacin?')) {
			localStorageImage = new Image();
			localStorageImage.addEventListener("load", function(event){
				localStorageImage.removeEventListener(event.type, arguments.callee, false);
				contexto.drawImage(localStorageImage,0,0);
				filtroByN(0);
			}, false);
			localStorageImage.src = localStorage.dibujo_escala_acromatica;	
		}else{ponerFondo(imagenFondo);return}
	}else{ponerFondo(imagenFondo);return}

}
	//Carga imagen para patrn y lo crea.
	$('.textura').click(function (){
		var img = new Image();
			var direccion = $(this).attr('id');
			var textFondo = $(this).css('backgroundImage');
			img.src =  eval(direccion);
			img.onload = function(){
			var ptrn = context.createPattern(img,'repeat');
			relleno = ptrn;
		}
		$('#paleta3').css('backgroundImage', textFondo);
	})
	
	
	//Abre ventana para escribir texto en canvas
	$('#texto').click( function() {
		document.getElementById('text-controls').style.display = 'block';
		var textE1 = document.getElementById('text');
		//textE1.focus();
	})
	//Coloca texto al aceptar
	$('#botonTexto').click(function (){
		saveActions();
		contexto.save();
		contexto.fillStyle = colorFondo;
		contexto.fillRect(0,523, canvaso.width, 22);//rellena con color de fondo Si fuera una imagen habra que recargarla
		contexto.restore();
		titulo = document.getElementById('text').value;
		contexto.font = "12pt Verdana";
		contexto.fillStyle = "black";
		contexto.fillText(titulo, 20, 540);
		saveLocalStorage();
		document.getElementById('text-controls').style.display = 'none';
	})
	//Cierra ventana de colocar texto
	$('#botonTexCan').click(function (){document.getElementById('text-controls').style.display = 'none'});
	
	// Controlador de evento general. Esta funcin determina la
	// posicion relativa del ratn respecto al elemento canvas.Da las coordenadas del raton dentro del canvas
	function ev_canvas (ev) {
		if (ev.layerX || ev.layerX == 0) { // Firefox
		  ev._x = Math.round(ev.layerX / canvasScale);//multiplicamos por canvasScale para conpensar zoom
		  ev._y = Math.round(ev.layerY / canvasScale);
		} else if (ev.offsetX || ev.offsetX == 0) { // Opera
		  ev._x = Math.round(ev.offsetX / canvasScale);
		  ev._y = Math.round(ev.offsetY / canvasScale);
		}

		// Llama al manejador del evento de la herramienta
		var func = tool[ev.type];
		if (func) {
		  func(ev);
		}
	}

	// Esta funcin dibuja #imageTemp canvas encima de #imageView, despus
	// #imageTemp se limpia. Esto se realiza cada vez que el usuario
	// completa unaa operacin de dibujo.
	function img_update () {
  		saveActions();//Guarda copia de la imagen
		contexto.drawImage(canvas, 0, 0);//copia imagen temporal en definitiva
		context.clearRect(0, 0, canvas.width, canvas.height);//Limpia la imagen temporal
		redoHistory = [];
		saveLocalStorage();

	}
	//Function guarda imagen en array para poder deshacer
	function saveActions() {
		var imgData = document.getElementById("imageView").toDataURL("image/png");
		undoHistory.push(imgData);//guarda imagen en matriz deshacer
	}
	//Guarda imagen en el cache del navegador
	function saveLocalStorage(){
		var imgData = document.getElementById("imageView").toDataURL("image/png");
		localStorage.dibujo_escala_acromatica = imgData;//guarda imagen en el cache del navegador
	}
	
	//Funcin pone fondo de color
	function fondoColor(){
	contexto.save();
	contexto.fillStyle = colorFondo;
	contexto.fillRect(0,0, canvaso.width, canvaso.height);
	contexto.restore();
	}
	
	//Funcion deshacer
	function undoDraw(){
		if(undoHistory.length > 0){
		var imgData = document.getElementById("imageView").toDataURL("image/png");
		redoHistory.push(imgData);//Guarda la imagen actual en array rehacer
        var undoImg = new Image();
			undoImg.onload = function(){//funcion para que le de tiempo a cargar la imagen
			contexto.drawImage(undoImg, 0,0);//copia imagen rescatada en canvas
			var imgData = document.getElementById("imageView").toDataURL("image/png");
			localStorage.dibujo_bodegon_punto = imgData;//guarda imagen en el cache del navegador
			};
			undoImg.src = undoHistory.pop();//saca ultima imagen guardada en el array y la guarda en undoImg
        } else if(undoHistory.length == 0){
		return
		}		
	}
	
	function redoDraw(){
		if(redoHistory.length > 0){
		saveActions();
        var redoImg = new Image();
			redoImg.onload = function(){//funcion para que le de tiempo a cargar la imagen
			contexto.drawImage(redoImg, 0,0);//copia imagen rescatada en canvas
			var imgData = document.getElementById("imageView").toDataURL("image/png");
			localStorage.dibujo_bodegon_punto = imgData;//guarda imagen en el cache del navegador
			};
			redoImg.src = redoHistory.pop();//saca ultima imagen guardada en el array y la guarda en redoImg
		}
	}
	
	
	//Pone una imagen como fondo
	function ponerFondo (imagenUrl){
		var img = new Image();
		img.src = imagenUrl;
		img.onload = function(){
		contexto.drawImage(img,0,0,750,523,0,0,750,523);
		}
	}

	//Control del boton limpiar
    $('#reset').click(function() {
        if (confirm('Se reiniciar el ejercicio y se perder la imagen actual. Ests seguro?')) {
		//canvaso.width = canvaso.width;
		undoHistory.length = 0;//vacia array con estados anteriores
		redoHistory.length = 0;
		contexto.save();
		contexto.fillStyle = colorFondo;
		contexto.fillRect(0,0, canvaso.width, canvaso.height);//rellena con color de fondo Si fuera una imagen habra que recargarla
		contexto.restore();
		ponerFondo(imagenFondo);
        }
    })

	//controlamos el boton guardar imagen
	$('#guardar').click (function() {
	var imgData = document.getElementById("imageView").toDataURL("image/png");
			var ventana = window.open('','imagenGenerada', "toolbar=no,location=no,status=no,menubar=no,resizable=yes,scrollbars=1");
			ventana.document.write('<html><head><title>Imagen Generada</title><meta http-equiv="content-type" content="text/html; charset=iso-8859-1"><link rel="stylesheet" type="text/css" href="css/dibujo_00.css" /> ');
			ventana.document.write('</head>');
			ventana.document.write('<body style="background-color:#F4EDC8">');
			ventana.document.write('<div  style="position:absolute; top:40px; left:50%; margin-left: -375px;  width:750px; height:545px; box-shadow: -2px 2px 10px 1px #999;"><div style="position:relative"></div><div><img src="');
			ventana.document.write(imgData);
			ventana.document.write('"width="750" height="545">');
			ventana.document.write('</div><br><div style="border-width:1;border-color:#901420;border-style:dashed;border-radius:15px; margin-top: 50px;margin-left: 150px; margin-right: 150px; margin-bottom: 20px; padding-left:20px; padding-right:20px; font-family:Verdana;font-size:16px;background-color:#f3f0e7;text-align:center">');
			ventana.document.write('<br><br>Para guardar la imagen haz clic sobre ella con el botn derecho. En el men que aparece selecciona: "Guardar imagen como..."');
			ventana.document.write('<br><br><button onclick="window.close();" class="botonVentana">Cerrar Ventana</button><br><br></div><br><br></div></body>');
			ventana.document.close();
	//window.open(document.getElementById("imageView").toDataURL("image/png"),'Canvas Export','height=450,width=625');
	})

	// tools Contiene la implementacion de cada herramienta
	var tools = {};
	//Controles para saber que botn se ha seleccionado
	$('#cubo_pintura').click (function (){
	tool = new tools['cubo_pintura']();
	$('canvas').css("cursor","url(imagenes/cursores/cursor_cubo.png),auto");
	})
	$('#colorPicker').click(function (){
	tool = new tools['cuentagotas']();
	$('canvas').css("cursor","url(imagenes/cursores/cursor_cuenta.png),auto");	
	})
	$('#deshacer').click (function() {
	undoDraw();
	})
	$('#rehacer').click (function() {
	redoDraw();
	})
	
    // Coloca una imagen encima
	function ponerImg(urlImg) {
	var img = new Image();
	img.src = urlImg;
		img.onload = function(){
		context = canvas.getContext('2d');
		context.drawImage(img,0,0,canvasWidth,canvasHeight);
		img_update();
		}
	}

    // Cuentagotas
	tools.cuentagotas = function () {
    var tool = this;
		this.mousedown = function (ev) {
		  pixelColor = contexto.getImageData( ev._x,ev._y,1,1);
		  if(pixelColor.data[0] + pixelColor.data[1] + pixelColor.data[2] == 0){
			  rellenoR = 1;
			  rellenoG = 1;
			  rellenoB = 1;		  
			}else{
			  rellenoR = pixelColor.data[0];
			  rellenoG = pixelColor.data[1];
			  rellenoB = pixelColor.data[2];
			}  
			  alfaColor();
			  $('#paleta').css('backgroundColor', relleno);
		};
	};

		//Cubo Pintura
		tools.cubo_pintura = function () {
		var tool = this;
		this.started = false;

			this.mousedown = function (ev) {
			curColor = { r:rellenoR, g:rellenoG, b:rellenoB};//toma color seleccionado en rgb
			saveActions();
			colorLayerData = contexto.getImageData(0, 0, canvasWidth, canvasHeight);//copia canvas a colorLayerData
			paintAt(ev._x, ev._y);
			saveLocalStorage();
			};
			floodFill = function (startX, startY, startR, startG, startB) {


					var newPos,
						x,
						y,
						pixelPos,
						reachLeft,
						reachRight,
						drawingBoundLeft = 0,
						drawingBoundTop = 0,
						drawingBoundRight = canvasWidth,
						drawingBoundBottom = canvasHeight-22;
						pixelStack = [[startX, startY]];

					while (pixelStack.length) {

						newPos = pixelStack.pop();
						x = newPos[0];
						y = newPos[1];

						// Get current pixel position
						pixelPos = (y * canvasWidth + x) * 4;

						// Go up as long as the color matches and are inside the canvas
						while (y >= drawingBoundTop && matchStartColor(pixelPos, startR, startG, startB)) {
							y -= 1;
							pixelPos -= canvasWidth * 4;
						}

						pixelPos += canvasWidth * 4;
						y += 1;
						reachLeft = false;
						reachRight = false;

						// Go down as long as the color matches and in inside the canvas
						while (y <= drawingBoundBottom && matchStartColor(pixelPos, startR, startG, startB)) {
							y += 1;

							colorPixel(pixelPos, curColor.r, curColor.g, curColor.b);

							if (x > drawingBoundLeft) {
								if (matchStartColor(pixelPos - 4, startR, startG, startB)) {
									if (!reachLeft) {
										// Add pixel to stack
										pixelStack.push([x - 1, y]);
										reachLeft = true;
									}
								} else if (reachLeft) {
									reachLeft = false;
								}
							}

							if (x < drawingBoundRight) {
								if (matchStartColor(pixelPos + 4, startR, startG, startB)) {
									if (!reachRight) {
										// Add pixel to stack
										pixelStack.push([x + 1, y]);
										reachRight = true;
									}
								} else if (reachRight) {
									reachRight = false;
								}
							}

							pixelPos += canvasWidth * 4;
						}
					}

				},


			clearCanvas = function () {
			contexto.clearRect(0, 0,canvasWidth, canvasHeight);
			}

			matchStartColor = function (pixelPos, startR, startG, startB) {

				r = colorLayerData.data[pixelPos];
				g = colorLayerData.data[pixelPos + 1];
				b = colorLayerData.data[pixelPos + 2];

				//Si el color que clickeamos es el negro
				if(r+g+b < 3){
				return false;
				}
				
				// If the current pixel matches the clicked color
				if (r === startR && g === startG && b === startB) {
					return true;
				}

				// If current pixel matches the new color
				if (r === curColor.r && g === curColor.g && b === curColor.b) {
					return false;
				}
				// If current pixel has different colour
				return false;
			}

			colorPixel = function (pixelPos, r, g, b, a) {

				colorLayerData.data[pixelPos] = r;
				colorLayerData.data[pixelPos + 1] = g;
				colorLayerData.data[pixelPos + 2] = b;
				colorLayerData.data[pixelPos + 3] = a !== undefined ? a : 255;
			};
			paintAt = function (startX, startY) {

				var pixelPos = (startY * canvasWidth + startX) * 4,
					r = colorLayerData.data[pixelPos],
					g = colorLayerData.data[pixelPos + 1],
					b = colorLayerData.data[pixelPos + 2],
					a = colorLayerData.data[pixelPos + 3];

				if (r === curColor.r && g === curColor.g && b === curColor.b) {
					// Return because trying to fill with the same color
					return;
				};

				floodFill(startX, startY, r, g, b);
				contexto.putImageData(colorLayerData, 0, 0);
			}
		}; //fin cubo pintura
	
		//Aumenta de tamao el escritorio
		document.getElementById('zoom_in').onclick = function() {
			if (canvasScale > 2) {
				return;	
			}
			canvasScale = canvasScale * scaleFactor;
			altoNuevo = Math.round(altoNuevo* scaleFactor);
			anchoNuevo = Math.round( anchoNuevo* scaleFactor);
			$('#imageView').css('height',altoNuevo);
			$('#imageView').css('width',anchoNuevo);
			$('.lienzo').css('height',altoNuevo);
			$('.lienzo').css('width',anchoNuevo);
			$('#imageTemp').css('height',altoNuevo-(22*canvasScale));
			$('#imageTemp').css('width',anchoNuevo);
			$('#imageTop').css('height',altoNuevo);
			$('#imageTop').css('width',anchoNuevo);
			objeto = document.getElementById('herram');
			objeto.style.height = altoNuevo +'px';
		}
	
		//Disminuye de tamao el escritorio
		document.getElementById('zoom_out').onclick = function() {
			if (canvasScale < 0.9) {
				return;	
			}
			canvasScale = canvasScale / scaleFactor;
			altoNuevo = Math.round(altoNuevo * (1 / scaleFactor));
			anchoNuevo = Math.round(anchoNuevo * (1 / scaleFactor));
			$('#imageView').css('height',altoNuevo);
			$('#imageView').css('width',anchoNuevo);
			$('.lienzo').css('height',altoNuevo);
			$('.lienzo').css('width',anchoNuevo);
			$('#imageTemp').css('height',altoNuevo-(22 * canvasScale));
			$('#imageTemp').css('width',anchoNuevo);
			$('#imageTop').css('height',altoNuevo);
			$('#imageTop').css('width',anchoNuevo);
			objeto = document.getElementById('herram');
			objeto.style.height = altoNuevo +'px';
		}
	
				//Transforma imagen importada a blanco y negro
		function filtroByN(flag){
		canvasData = contexto.getImageData(0, 0, canvasWidth, canvasHeight);
		pixel = canvasData.data;
			for (var x = 0; x < canvasWidth; x++) {
				for (var y = 0; y < canvasHeight; y++) {

					var idx = (x + y * canvasWidth) * 4;

					var r = pixel[idx + 0];
					var g = pixel[idx + 1];
					var b = pixel[idx + 2];
					var a = pixel[idx + 3];
					//var v = 0.2126*r + 0.7152*g + 0.0722*b;//filtro a grises
					
					
					var v = (r+g+b)/3;
					if (v <= 80){
					pixel[idx + 0] = 0;
					pixel[idx + 1] = 0;
					pixel[idx + 2] = 0;
					}else{
					pixel[idx + 0] = 255;
					pixel[idx + 1] = 255;
					pixel[idx + 2] = 255;
					pixel[idx + 3] = 0;
					}
				}
			}
			contextTop.putImageData(canvasData, 0, 0);
			imagenFondo = canvasTop.toDataURL("image/png");
			if(flag == 1){
			fondoColor();
			ponerFondo(imagenFondo);
			img_update ();
			}else{
			return;
			}
		}
	
		//Importa imagen desde archivo y la coloca como fondo del canvas fabric
		formEl = document.forms[0],
		fileEl = formEl.elements[0],

		formEl.onsubmit = fileEl.onchange = uploadHandler;
//
		function uploadHandler() {
		uploadFile(fileEl.files && fileEl.files[0]);
		return false;
		}		
		$('#subirArc').click(function(){fileEl.click()});
		

		//Sube archivo de imagen desde el ordenador
		function uploadFile(file) {
			if (file && file.type && file.type.match(/^image\/.*/)) {
				var fileReader = new FileReader();
				fileReader.onload = function(e) {
					var dataURL = e.target.result;
					var newImg = new Image();
					newImg.onload = ajustar;
					newImg.src = dataURL;
					contexto.clearRect(0, 0, canvas.width, canvas.height);	
					function ajustar(){
						
						alto = newImg.height;
						ancho = newImg.width;
						altoCanvas =canvaso.height-22;
						if(ancho/alto >= canvaso.width/altoCanvas){
							yCoor = Math.floor((altoCanvas-canvaso.width*alto/ancho)/2);
							altoPNG = Math.floor(canvaso.width*alto/ancho);
							contexto.drawImage(newImg,0,yCoor,canvaso.width,altoPNG);
							filtroByN(1);
							return
						}else{
							xCoor = Math.floor((canvaso.width-altoCanvas*ancho/alto)/2);
							anchoPNG = Math.floor(altoCanvas*ancho/alto);
							contexto.drawImage(newImg,xCoor,0,anchoPNG,altoCanvas);
							filtroByN(1);
						}
					}
				}
			fileReader.readAsDataURL(file);
			}return
		}

	init();

}, false); }
