// Keep everything in anonymous function, called on window load.
if(window.addEventListener) {
window.addEventListener('load', function () {
  var canvas, context, canvaso, contexto;

  // Variables de herramientas.
  var tool;
  var flagRejilla = true;
  var undoHistory = new Array();//Matriz que guarda imagenes para el deshacer
  var redoHistory = new Array();//Matriz que guarda imagenes para el rehacer
  var tool_default = 'pencil';
  var imagenEncima = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAu4AAAILCAYAAAC3lBn7AAAABHNCSVQICAgIfAhkiAAAIABJREFU eJzs3Xe8HFX5x/HPSYXQQw01lBB6Rwk1tFCVJgQUBGlSRNqPLqI0KYJIE6QIiiAgSJPeBKT33mvo ARIgAdLO74/vjDM7d3fv7t69/ft+ve5rZ2Znd8+9uReeeeY5zwkxxoiZmZmZmXVpfTp7AGZmZmZm 1joH7mZmZmZm3YADdzMzMzOzbsCBu5mZmZlZN+DA3czMzMysG3DgbmZmZmbWDThwNzMzMzPrBhy4 m5mZmZl1Aw7czczMzMy6AQfuZmZmZmbdgAN3MzMzM7NuwIG7mZmZmVk34MDdzMzMzKwbcOBuZmZm ZtYNOHA3MzMzM+sGHLibmZmZmXUDDtzNzMzMzLoBB+5mZmZmZt2AA3czMzMzs27AgbuZmZmZWTfg wN3MzMzMrBtw4G5mZmZm1g04cDczMzMz6wYcuJuZmZmZdQMO3M3MzMzMugEH7mZmZmZm3YADdzMz MzOzbsCBu5mZmZlZN+DA3czMzMysG+jX2QMws/qFEH4MfA9YJvmaJ3lqUu7rS+A54Bng6RjjPzth qGZmZtYkIcYYO3sQZlZdCGEp4AfA5sDqQN8G3uZ1YIMY49tNHJqZmZl1EAfuZl1YCGE0cDiwYiun fgzMXcNbjkHB+8ttHZuZmZl1LAfuZl1QCOHnwCHAYlVOewH4F3ADsB7wO+At4FRgJmBxYClgBBBy r/sUGBVjfKr5IzczM7P24sDdrAsJIRwKHAgMqXLa28ABwE3A9sBRwBLAWcBhwLdo4vn0wARgEWAv 4GfAHMl7fI4y7082/ZswMzOzduGuMmZdQAjhxBDCOOAUqgftAHsAswPPA5cBA4GNgP1R0H4yMBX4 GhgP/AMYgLL3NyfvMRi4M4SwQnO/EzMzM2svzribdZIQwsLA/wG7oux4vb4BTkLB/re54/sCm6CA fnDyNT0K+O8DHicrwfkMWC/G+EwDn29mZmYdyIG7WQcLISyHSlpG03pL1vdQlnxnYLrk2GTgb8Cx wDsNDGFr4Jrc/lgUvD/bwHuZmZlZB3Efd7MOEkJYE3WIeYbSyaLlvIMmm/4HuBvVtX+KsuVnAO+2 YShDgUeAVVG53BxokquZmZl1Ya5xN2tnIYTNQggPAA+gPuzVgvZ3UEnLMOBa4EYUZK8MrA0cRNuC doBBQH/gotyxRUMIZ7Xxfc3MzKwdOXA3aychhHVCCA8C/wbWbOX0j4FfohaOF6Lg/vpke2tgYhOH dl7yOZ8A7+eO/zyEsGATP8fMzMyayIG7WZOFEEaEEG5FZS6rt3L6Z6id46KoneOMqHZ9OlTXfjLQ 7HkoY4HtgB8BO6IONKDOM8c1+bPMzMysSXrd5NRkYuCcqJ3e7KhkYEryNRn4AHg9xvhGpw3SuqUQ whLAH1BHl9Z8ApwOnIPaNvYDjkRdZh4ANm2nYeb1AaYBvwcOTo5NA1b24kxmZmZdT9MD9xDCsBjj a818z7YKISyDFrXZEgXrtZiCJgS+DjwFPAY8FmN8rz3GaN1bCOFY1ClmYCunfoomnZ5PVv4yELgT ldNcjbLgk9pnpGVNDzxL1iLyzhjjBh34+WZmZlaDHp9xDyHMAzwBzNekt/yIJIgHHo0x3tqk97Vu KIQwCjiXLOit5lq0gumnheNnoMWTzgf2QVnvjtQXZf5/nju2aYzx5grnm5mZWSfokoF7CGF4jPGV Jr3X/cBazXivKt5EgfzNMcZL2/mzrAsIIcyHSl1G13D6OGA/tMrp/94CWAHdzXkbuA44oLmjrFlA k2PnzB17Psa4TCeNx8zMzMrokpNTmxi0n0XloH0sWjL+TrTATTELWo9FUAB3aQhhcgjhthDCnm14 P+vCQggHAC9TW9B+PbAMWdAeUMnWE2QZ7g1Qm8fOEoGzC8eWCSHs3hmDMTMzs/K6ZMa9GUIIPwX+ mjs0FpUkXI16ZX9X5mXDgHWBJYFlgeXR4jSNmgY8iEokrosxvtmG97JOFkL4MeoAs3QNp7+Nsuw3 5Y7NiH4XNgSuQl1jvm3uKBs2EHgO/Q2k3o0xuj2kmZlZF9EjA/cQwmLA0yhQSu0CNFLGMhQtfLNO 8lhLLXMlr6Ds/i0xxtvb8D7WgUIII1CrxlVqOH0y6tJyPKW91/uh7PumaHLqUTS/zWNbjQJuKxzb P8b4x84YjJmZmZXqqYH7bcBGuUPvAwvSnEl/86IA5wfJ44zVT69oInAXCuRvjjG+04SxWRMld20O RndeWvMFcAma5Jm2Ep0d9XH/N/A31Dt9b7SoUld1JRpn6sMY45DOGoyZmZllelzgHkIYjuqP88vK j0N1xffR3CznQGAksBlayn7hNrzXS6je/q4Y43VtH5o1KoRwBCpzmbeG0x9HXWX+AXyTHBsAHA4c irrF9EX93bdFF2pd2VzAI+hOU+qXMcYzO2c4ZmZmluqJgfsuKPNZzofAq6jGPf/1LuqqMb6NHz8M WA9NNtwAmLXB95mCauNvBf4ZY3y1jeOyVoQQFkG9/ncFZmjl9EmoRv1M1E0obyRwHjALqmG/HfVJ nx0Y07wRt6th6I7SyajE5/0YY7PaqZqZmVmDemLgvj/QaE3udyiA/xitbJlufwi8hjL571Bb1r4v sBqwMSrbWZnyXXzepjS7Wc6TwBXAlTHGd2v4bKtRUr9+ILAN+jer5n3Ua/3P6Pcibw5U274zcAua U/FJM8faCU5FK7kC7BtjPKczB2NmZtbb9cTA/WjguNyhzVHwvCUwfxM+4gvgDhScXQ1MaOX8GVCG dhZUEz8a2ATonzw/gdYzvKkI/Be4wkFU24QQRqOAfbUaTr8blcNcj+6GFM0F3A8shEpk/kjXm3ja iCWBh9Dv7nsxxgU6eTxmZma9Wpfs495G/Qv7z6J65QWB7wO/Au6lfDvIWsyGJu/9BZXY/JbqLSN/ iWqfb0NB3xZooZsdgH+VGW81AVgTOCeEMCWEcIf7xdcuhDAkhHBMCOEDNAmzWtA+AfgTsBSwPnAN WdDel9Ls/A7ogm4V1HK0JwTtfYC/k7WrXCCEsFcnjsfMzKzX64kZ91+i2uPUe8CPgEcLp06PFmfa AHX+mAVlvtOvQZROcK1mInARKpUolrL0BfYFVkXdRf5ReD69ENgRWKOOz8ybgrLCV8QY/9LA63u0 EMLqwC/Q78GAVk5/E3WGuYiWcx6+jy4Ct0IXUE81d6Rdzo/QXaXUOzHGhTprMGZmZr1dTwzct0KZ 7LzJwNHAaSjInRn4srW3AqYjC+LTr0VR6c1oWpa4TEZB33HA58m571C+vAJ08RDI+n0PRX2+R6K+ 8XO1MsZyJqE7CjcBN/XWRZ9CCEPQxdDPUNa8NXehC76baNk2dCbUwnE7VOe+D3BD0wab6YPmQ2yL yromodV9n0eTlTv63zKgFV5XzB3bI8Z4QQePw8zMzOiBgTtACOFbFHQXfYhKZIaibOpzydelqAVe PWZGgeF+wBKF574AjgUuR105PqjwHsuhpebnRhNfnwcuJusDvjQK4keibjWD6xwjwIsoGL0xxnh/ A6/vFkII86E7FuliWcvQ+t2Liai/+lnAC1XO2xe1czwX+DWtX/Q1Ylu0MNOiyX5Ek1tnRBeIEZVb nY3mVzRjTYJabIVWe029HGMs/r6bmZlZB+ipgfvlwI8Lhx9Frf4WRRnY9GsIcAIKylJDUdnLS8nX i2gl1nL6AFsDR1KamQR4HfgJLct0imYFVkCB+lTUTrCoHyrPGIHKbr4H1Nuibzwq73g6fYwxPlPn e3QJIYSV0c9iBCp1qrWH/jQ0kfQq1Knni9xzI9DdlK9RR5XUQDQvoT3aOU6fjGXzZP814DBUVjUJ Be0/RL9Ho9CciGfQZOu322E8RX3Q73H+5zvKK/+amZl1vJ4auA9FGexi1v1otBR9a+ZCZQlpKcxz KFBOJ+r1R0H/W5RmX7dAFwFL545NQNnUW2odP7oQ2AmV2dwB3ENWTpM3BAXxq6CLhhWpP5ifhL7X D1GLwwmo5Kfa1yT0s8h/fVfm2MRmtK9MWjYuh1pqrgQsi4LpWuWD9Wto2cpxBZTt3hh1UdkdXay1 txlQFn2NZP/vwF7owqGcZZJzlgM+Rdnw/7bzGAEOQHccUpfFGHfsgM81MzOznB4ZuAOEEE4Ajirz 1E7AZSiTuDEK0m+nZTnL7Cg4j6i+OF+acCYqkZmCAsKfkmVj+6Ns7f6586egYPDSGoe/cDLGEajc 48vktWei7Gc1c5IF8Sskj8Po3A5C44GPyPri57++QHMHZk6+ZkIThRdDP/9GF/4ZC/wHLWJ1Iy2D 9dTBaKGhiej35Rw6rgzlEtT3fSL6fXoFTZheAJVFzYZ+/+5G38dz6ILlTGDP5HWr0v4XGTOh3++Z k/0vYoyztfNnmpmZWUGPDdwBkrZ/xWXrp6IJi/8ky2JHVDpyEwrSx6IWjl+hrjRFo1GwNxgFNeeg riV526HOJDPmjh2evK5Wg1E2fRkUyD6XjOdF6puoOAhlqZdPvpZFdwUaqZnvqj5Hgfq96A7F85Rv yziQ0lagh6DM95+pPBehPewE/BVd1G2ELsgeQxeSH6F/47HJ8+sB86CJsaegsq470NyH59HdoG/a ebx/QJn31IYxxjva+TPNzMwsp6cH7puhft0zFp6KKNDeidYX4PkAZeT3oXxwNBNZVrxoSTSxLz+Z 70wUADXycx+AgrmZ0MTFNFC9l8ayrkPQRcHSqPZ/keRxKPWVonSkScCrZHMPXkQTS1+k8s90fmCz 5GswmsDaUVn1SuN5Ht1Z+A5Njj0E/R7Nhi5C8gKacPtrYF00gfkYtKLunGg11/busb4QKgMbjeZb nBtj3KedP9PMzMxyenTgDhBCGIZKJcp1wjgMBUUjUDD9KQpiV0EZ7gVRecDDKDh6P/faai0l50TZ /AkoyL4Y9cROXYnKayY18C0tD2yIAqmFUH30YGAcmgR7JSqzaeS9UwGVqCyKynZmQhcNA5OvAYXH /mSLErX2NRBdSOW/BqGgewL6mY5PHr9EJS5pkP4S6rhTqb1m0SIoO70R6q//O/Rv0ZafTTMcAZyI Vm49HJUx1dr6cw/0u3gFmpdwcHJ8LvT7297uRRcRH8QYi3ezzMzMrB31+MAd/he8P44ynHkR2AWV LNRje1SffA2qi3678Pzj6ELhIFSCAcqW/oasReHdaHJhW1sL9kF17Buj8pzlgJNQcAjKjl6EJouO QRcfY5Kvd6k8EbIjpfX3bcmCz40C//z3cykqJ+kqAXvqWDRRegtUOjUcXdTU+rf4b9TvfwzK3oPu HNXb0rQRv0LrFACsFmN8uAM+08zMzOjcCYsdJsb4GgqSi51ZAvAXYJM63/LXKHP8Y9Sar9hh42iU hT4fZVZBwdqPyeqr10OlLvPU+dlF09AiOSegbPxwVKefmgJcgEprRqEg9mZUT/0GytzOnTt/VTS5 dg/UfnL2No6vFjH5nGXQ7+RQYAf0c/w9ao/5N/Rv9TuUoU/tDjyAss/7Ft53Z5R1P4+uE7SDOvOA /u2+Qb+H09fx+nNy7/NKsr1Ic4bWqntz2z/ooM80MzMzeknGPRVCGImylcUVT8ehrPXbNb5VX5TZ 3hoFmENRSUl+IuvKqGxlUZShvzI5vgZwHTBHsv8WKuV4rdbvo50NQXcJ1iMLkD9FAeIrKJj+sPCa c9CE16/ISlzGoZ/neWSZ5HnRxcXiqBRpkeRrKGrd+TK6wPohLSfxfgJcDfwDtUCMyWuuSsZ3O9nP uKv7CSpn+imwGyo9mQP4rMbXB/SzXRD9rGdGd35OrPKaZhlA1gno0Rjj9zrgM83MzAyVUfQaMcZ7 Qwhro9Z6+aztrKi/e629qaeiLjRPoez7RrSsu34CBaknogl9aVD5X1RTfzsK9hdOjm2GsuCd7UOU Se2L2jGuhLLhM6AgsThxEhRwb4ky95PQhN53UYA3M6pZB60ku07udd+hSZrnoi4/D6OA/F30bzIJ lYM8jGrci6U036Igv7tJV8adh+znuSi1B+4RuAt1R/pfi8amja66SegOxyg0F8TMzMw6SK/KuKdC CNugQDHkDk9DNfDNqPnui4L7auZDwdfwZH8CsA1akKe76kP1OvX5UJZ4EMqSv0jtE017ktnR9/8g yrz/Cfg/4LQ63mNXNHchtTpaPKqcAejCYDi6o/IF6k40NhnHR7T++5p3KNkdke1ijFfV8VozMzNr UK8M3AFCCIfRshxjUerrj17OYcCRqDb7REoDohlQlvR6VFYzFwrel0men4wCssvaOAbr+u4A1keT Sh9E8x3Wr+P1w1BbTNDF0szo4g80/2Ld5P3WR2Vdfau811coi34vcB9aL2BClfNXRhOwAS6IMe5R x7jNzMysQb02cAcIIbxP6cqcS6Kyj7ZYF2XzB6MAfWuyLHS66M63wG/RYjqzo+B92eSciHp615N9 te5nS+BfqNRqJPq92QgF9LWYE2XK+6BAe6Xk9aNR+VCxg1I9pqEa+jfRysBnojkLqT6oTeccwDsx xoXa8FlmZmZWo94euD9HFjCDarpfasJbLwCcgYL2DVBgntocZfqXQln5Q1DwfjNaATN1A2on+QbW EwVU3z8ALZ50BypbWRnV9VczPWpHul2y/z6arzJ3pRe00Rg0kfae3LHL0CRbgOExxldavMrMzMya qle0g6yiOKEvlD2rfu+hevURtFzR9CZUurANaiUJmpS4HsrQp36IVgQ9BXVdsZ4lohaei6F2pHuj VVOfpHp70q1RB6Ltcsfmo3rQ/jm6g7MUypIPQReXq6GLyFcrvxRQr/g7UR1+6ubc9oatvN7MzMya oLdn3G+ktBf1MihYbg+7osDpKLJe7kXTo5U0j6S0409E2c6LgGtRqY31DPegUpn9UK37H1HL0AtQ VvtBNE+iD/rdOJ7aLzCfRGUuV9L678xw1FXpUHQXoJIzgf1RKdgnqHb+hhhjd+zuY2Zm1q309ox7 cUGm9tQPLU//BCqHKBqBVr68HQVRF5It1BNQRv7vqF3jubgVX0+xA2oD+kfUPnQtVKc+Ck0UHY8m j05BGfpagvan0aqsK6PVY8sF7UuiC4HjgANR+82j0QJc1eZ5/BIF95+jNp2g+nwzMzNrZ709cP+m sN+sUply/ow6zswPPAr8ovD8CFRv/wAqj9kTlVGcS2mGflZUVvEY8CwKuoa247itfX2Eetv/C7gY tYa8GVgaTQ6dAZiR2n43xwH7oID9htzx4Sjoz5e6bJwc+xVwOgrCz0G/owuhbH0lJ6Jg/fZkf6YQ wuo1jM/MzMzaoLeXyvwJBcGp5VCHjvY0B8p0TkOZy1QfVE6zI9AflfCki/PMiyax/hyV05TzMgr4 bkGZ2knNHri1q4DqzQ9Bcx76UV9nmMvRZOaPc8dmQ8H4aPT79S1qG5neyVkcTYzdGZW+gDL7P0Ml WY+QtSot+iz5vEuT/aNjjMfVMV4zMzOrU28P3P+AMtap5VEWu6uaE3Xy2APVy1fyNepkc0vy9W77 D83aYAD6dz0ElbDU42N0QXd9med2Bo5F5Ta3AFegMpqi6YDt0dyKw1HQTjKWx1DWPzUxGW8/tELu POii4N4Y48g6x25mZmZ16O2B+69RYJNagazTS0cZhbL8H1Y5ZyFUIvMcWU/4NVG29EdowZ1qxqDs 6cPJ1+N4gmtXsDRqs7gjuqtSj/eAs1EJ1rjk9R+0cTwBTYTO2w3Nt0hNRuU0pxfO+y7G2NrvoZmZ mbVBb69xf72w35ZFaxp1Ccryb17lnJNQpvQNVF7TF9XC74hq5g+h5feSNz9qP3kqWlBnPPAQahG4 FcrkW8eYG93leRL1cT+U2oP2aagt42hgETQXYm7UeeZ9VLdeSR80j+II4Co0z+IIWnYvKrqU0ovK /uj38MrCeQNDCKNq/D7MzMysAb09cH+tsL9GJ4xhVxRI34hKG8o5CZUvzIvqoPPZzrFoIafF0fL2 lyTvV80A1MP7oOR9P0E18hejtoRrowy/NcdMqBTmZhRgnw6sWMfrPwd+gy7ANkSB9xQUwD+FAvL7 KD8/Y0k0wfkD4D9AOol0VTTJ9PAyr1mR7KJgCvqdytsEBf3FQH+9mr8jMzMzq1uvLpUBCKGkWcct wKadMIzpUOZ1V1RnXynwnhUFbm+itpKpPsDuKAv/IiqdWRtl8TcBhjU4rndQ6dDTyeOzyWdPq/Yi A9QRaKPka0P0b1yPl1F2/Q7gVlpONh4E/A1NEr0QZdCL5kfZ8Yguyk5G/6Yk4/o9KrNZq/C6k1A5 zKXALii7n1/B911UvjUeTXZNPRpjzK/+a2ZmZk3kwD2ET8lKRb5EnTg6KzBdGNWep6UJh6EA7lYq L9oEqnO/Otl+HvgrcB7q/w1qFzkK2ADVxg9pwxgnoouD55Ovl9HKm2+h7GxvNQu64zEq+Vq4gff4 CmXlL0RBO6gsanMUJN/byusHojaN96Lfo9nRXZVzUaa/KKCs+keF43OjQH0gsCD6fXwdWDR3zjBa 3rGaGmPs28oYzczMrEEO3EO4Hi1Wk1oJlR90toCyreujrOolaCJiueXpZ0RlD9uhoAtUz35omXNB QeUI1OpvyeRrUUrrnes1GWXjX0se30TBfPo4oQ3v3VUtgYLqH6ASlEZ+ftNQP/QLgH+TXaAF9Ht5 Auog9EryeUV90b/7NiiL/jS6cCiuUVDJQijzfjG645Q6AXWZ+Tn6vbsUTaRNrYtWfQUF9unF4A9j jPke8mZmZtYkDtxD2A84K3dof7Sse1cwG1qpcl90VyACWwPXVXnNjMB8KMP6de59nkVlEg8Bd6OM 7uTc6/qjLOrSKFBcOvkaljzXVh9TGszng/sxdI/ym9mAkehiaiNUDtOIiDr7XINWw/0S1Yd/iLr/ gALja9GF2qvAHyi/KNLtqBTnW1TicgL13flYCZVdfYUy9OnvxKzAP9FdnydQAH9e7nXbA/9Itg9P PhvgjBjjAXV8vpmZmdXIgXsISwIv5Q5dD2zZScOpZDqU0V0NZWRPyz03L6pBrtbicRYUIM+WO/YF yuIflOyPQpnb51Em9VkUYPZHK28uj9plLocy9fW2L6xmErqoeAWV4byI/k1eIiv36WgD0J2IVYHv J19L07YJ3U+jzPVVaLLoDmhewzro53wscExybl9gau61c6JymXytex9UwvIUcDDwdoPjegT4Hvp3 faHCOauhi77UPqgEB7RS6yVo5d/HYoyrNjgOMzMzq6LXB+4AIYQxaCIfKPO7HJUDmK7mQNSlZAJw G7rwuBl1m8mbGWWKp0cXAgNRsHxz8vwTKPua+gyV6pxJacCWGowCvWVzX8tQOlmxGd4jC+TToP41 1AmnGWZAAfpSqFxoGPpehtP2Ow0R3U24AZWipBnzYcCf0L8H6CLpV6izUNEI4Ljk3B+hLH1eP9o+ t2Ak+t3ZGpXrlDMruthLHYnKs0Dfzw/RBeXkGGMz7tCYmZlZgQN3IIRwPAqcUjehuuXuoC9wPAq6 Fk+OTUPZ0P2S/RlQGUS1FVSHo040y6AAdlFUCz8QXRyckTs3JMenUlpuE1DN9LKFr8VpTrlN3pdo AuXraHLlxNzXhDL7U9DPYK5kPEslXwsl426raeiOwWO5r+eSz5+erOZ8RdT9ZxDKdJ+KSmKKf4ez AuejuyARBcWHNGGclayWjKfafw8+IptDcTnw42R7HvSzTS9214ox3t8egzQzM+vNHLgDIYR5UPY5 v/LjSNT3ujuZL/maFdVFv50c3xplah9EGflLUc15a/qgQLfYdWQrFGyCMvsvoPKas1DP8aIBKFge jiZYDs99dcaiV83wDVqF9j/JV1onDvq57YS6+KyFOu+kiyPNjS6obgH+W+X9dwH+gu40/BwtnNXZ 7iLr1T6NrGxoELqA+xr9DR0aYzyl44dnZmbWszlwT4QQLkb1xqlHUV1zTzADCq4XSvYfRyUY+RKL wagGfjzKZhf7hufNCpyNMq2TUdnKeyjQTPt9B3QXY3bUnvDu5H2L5kQtB+dHkz3TLP2SKFPdWSai MX9Q+PowefyEyhNqL0f169+gn8kxtCxdSs2MAvPR6OewHppnMBOa13AP1f8t2tMhwKdkCzD9EU2W zhtPtljXU2gexFUxxu06YoBmZma9iQP3RAhhOKqfzveh3hZ11ugJBqNg/QNU0jGx8PyfgL1y+9+g jP2hqHSoXgujrjGpKShD/S/U+rC1Sad9yAL5JVGmeo4yX/UubJSahu4kvJv7ei0Z406oF35xJdIT 0DyA71Bm+Rt0N6NoM5SFvpXs+wxoQm++n/puqARmFvTvcShwToPfT7P1QaVQn5F1NNoDtYbMu4cs C38ZWiH2jRjjopiZmVlTtaVvd48SY3wlhPBnYM/c4ZNQecAX5V/VrXxO5YmHoJr4F1FpzFwoKP2U 0guZeryF2hRuiwLw6VAwu1tyfJPcuZsnzz2DgudpyVfaCrGa2VEwvTiqy58flWyMy319UWb/Y0rr 85dC3z9UriXflmwV2qlk3X3mRhcqDyf75X7OkZaLIAV0cXAXKl96q+J32f7mQ3MlfkNWNhbRz3dJ skW3ivIr+KbjX6TdRmlmZtaLOeNeEEL4DAUrqcdQoDm+c0bU5SwG/A3Vrb+Ogu0raDzoXBmV7qQ+ RvXz51Da2WcLNGF4DlR28noyjnIrgjbi5yjonwsF4TegcqDUbCj7/Bm6yDkf3b2YD9Wffw6sUuZ9 h6As9AgUAF8DHN2kMTfTySjjvz1wZXLsPlSjvxPKps9GyzkM+fN3BS5KtteLMd7dngM2MzPrbZxx b+kE1F4xtSqaSLgRnddTvCtZDE0qnQ1lurdDdymGk636Cap1XhN1Knma0ux23hMoC78eqvGeFQWL r1AauJ+IsuJ5Afhdbn8rVLoyPHmfF9BiVZcmz++UfKU96D9DFw0HAwsARyXHX6fl38Ysyec9QNZr nWTsCyevH0RpCdKWqNQqvWvxKgqGu6LPksd8r/+/oX+LQcn+F6i8aJ6h17+hAAAgAElEQVTcOfmM +9u57RFNHp+ZmVmv58C9IMZ4eghhIlmwAgpC/o3KOyZ0ysC6jltRvXy/5Ks/ClanFs77I2ovCQro r0MTG8v1X784+apmPTRhsx8KhCfTsozmIHSxAAoyJ1DaAvPnwBrJ9geoy84tyf7HKMC/mPLB9dso oP9e4fjKyWM/dJGX70S0LOrR/izKWN9F9XaLnekKVBr2We7Y5cAp6O5K6m2ywP0z9DNJ5e+6rI+Z mZk1lQP38sotaLMWWiBnM7Ke3L3ZlOSr0mqtW6Ngew3UI3zh5PGG5PklUVD4CQr4XkUB7ssV3u8T Wm9huT4KpN+iZQtLUEZ+BKrhTleGTZ3VynuDgvz9UHb9PWB3sosTUBeYfOB+XPLVHbyHyn/ydewT UCnMG7lj+X/vR8q8x1R0YTUQMzMzayrXuJcRQtX1eG5H9daVAlarzTJoRdYZc8ci6p+fz3gPQMHk /CjYfgplyu9DAXgz9KFya8d+KMOcrq77GgrYV0QlNnmnAIc1aUxd1W3AqGT7RLLyotTbqO3ov2OM m3XguMzMzHo8Z9wLQggLUT0gHIUWMXLw3jbPo24sc6MJod+hiaafFs6bjMqU1kdlKt9HbStfI1sp NnUGyvAPIasr/wnqx57aEd0NWArVwc+SnLsYWVnNscnnLIbq7t9EdfNjUMD+NWqReD7KsH+IutXk 21/2VPl5DOXmLbyNAvdGuxGZmZlZBQ7cW+pT5thU1GrwWjQhcxQq+dgCl820xURU1lKtI00EDky2 Z0bZ79konbiamhtl6Cej8o5XKe3FPitwHlqQiuS8V9AKpvna7s3QHYGnUZeUy3LPpaU8Z1QZc0/2 XSvPv5c8rlH1LDMzM6ubA/fafIOy8CPRAkLroxaRN6IWhQ7eO8aXlF99NbVDK68fhzLtq6G+5K9Q PmucBp1d6Y7KUuj3bu1kexoa3yNo0uvdNKdl6ZxowvEHyf5hwLqoe1BxRd1yF7ljkseZQghrxxi7 ahcdMzOzbseBe23SFn9fAZsCfwd+hAKpf6MFhIorkVrXlK6SWk1bAvbp2vj6vEGoE89P0B2AclYB 9kUThR9Ad4Uup/QOQj3uRaU/GyT786BWqIcDR1KacZ+Xlt7LbW/Y4BjMzMysjHIZM2spn1GfBIwG Lkz21wVuJiu/sJ6vP/r3z/+bBzRZcwwqyWmrRdHiX7+jctD+JarXH4naWC4HnIlKj37Z4Od+jLL6 Myf756Ls/krJfj5wX7TM6/OB+zYNjsHMzMzKcOBem2I5xTRgD7KFmtZBwfuMWG+wK1p4ad/csZlR H/nZgY2b9BnpglNTUI/5PVD2ex00yfYHqHTrP6hH/TzJOVNQH/2rqP938u/owmSjZP81VI6TBun5 wH2RMq//ILe9VAjBCzGZmZk1iQP3lsrVPM9c5hioHeD1yfbawF/aZUTW1fwL3YU5gKxf+XhUpgLZ okxtsUpu+2xgF5TlnxnVs1+WPK6UO29ycs4SaMXWbdGCWVX7mxZcg4LzFXLH9kV3E6B0jsH8lC7O BDA2tz01xvhQHZ9tZmZmVThwL4gxjilzuFrpw8/I2kduDkzf9EFZV/MJCpCHADvljh8LPEzrNe6B 1oPpVZPHz4DfJNvLoPr1tNViX3Snp1hK8wmaqPsCmmi7ZyuflTcOXYDelTv2FNlF6Re5432AoYXX 5xe+6htCuLSOzzYzM7MqHLiX90VhfwCaKFjp3O1RtnM61Gvcer5T0YTkPXLHXkYrsx7dymv7oXKU ShZFLS9B5Vhpt5hDc6/7KPmaGwXW51JaFjMFrfIKcFJyXq32prT3fd64wn6xXOY7SrPuW9TxuWZm ZlaFA/fyPipzbLYyx1IPAzujWuBypTbW87wHHIMu1MpN0qxmMqVtFYuWyG2fk9vO90afB/gcTYbt h4Lt24CZcufcA1yN7hgdW+cYKykukFWuzj1/16p4EWxmZmYNcuBeXrnAvbVOIVeg/uAPNn841kX9 HnUVeqPB11f6+1swefySLNs+By2D5KVQnXlqdeB2SjPvR6LJ1LsUzm3Uo4X9chct+QmqC4cQGu1w Y2ZmZjkO3Mv7uMyxahl3673ubeA16foJscLzCyWP+Vr5xWp879WAQ3L7r6M6+AGF4/U6IHnvT8hW j4XSuwOpsYX977fhc83MzCzhwL28D8scc+ButVoCeAmYpcLz05LHSDbRNC8tR5mLrPTlWWovwzoI rYCaOjN53JmsC05rZiLrUz8z8Ae0eiqUZt3LBeXFcppmZPrNzMx6PQfu5f23zLHZO3wU1h2sT8sy qgNQ8L5OhddMy22Xy7rfmttePHmcCDxR45hmBI7K7d+FutPMglb+bc0qqEzniGT/S1TTv2yy/3ju 3NlzY0wVV21dvobPNDMzs1Y4cC8jxvhPWk4eXKncudarrQbciRZLyrsteVy7hveYVubYC2QTPPOl KPfVMba9yNYfmEbWJWbdGl47T/I4R+7Y/WSBe/ECYvXCfnFC6qwhhOE1fK6ZmZlV4cC9sv8U9ovB iVnamnHDwvEb0OJcz9bwHpX6uadZ9+1zx4q/k9UMpHRNga+Tx1rKbaYkj/kONfej8ps+wNPA1Nxz xQuUcp1k1qzhc83MzKwKB+6V3VjYX56s5tcMFMw+gnq35/+WpqL+639t5fXVFmH6R/K4ObBesn0f 8H6NY7uY0knW6SJN39Tw2oeS8/JB/oXAAih7PxHV8KeKJUHlAvftyxwzMzOzOjhwr6wYuPfDiytZ S6eg2vGlGnhtpHJnmbtQ8A1wGvpb/Rr4aZXXgDrRjCVbfAl0R2BlFHRfW8O4xgOXUVouNoXSNo8P 5bYXoXQCarnAff0aPtfMzMyqcOBeQYzxLVRrnOdyGSu6DvgjlVfWbYsDgXeAFVBHGFCt+mm5cyah zP9NwI9R0D0LWe38ymiNgT7ARcCTNX72vsCvqjx/b2E/Xy7zeZnz+4QQaqmvNzMzswocuFdXzLo7 cLeiaaiLTHFhIoAzqB78tuZL4Gcow34SKlUBdYy5P9kegHq8zwmcCMyNau9XAX6AVk+dHXiVrEtM LSajnu2VFOvt85O38xn3fE/3pev4fDMzMytw4F5ducC9XN9ts6K+wP7A7m18n3tQH/a50O/jjCjL Pgo4D9WbD0H91IfmXncGcD2aYPoWKlUptmmsx9yUrpL6PlrcKZX/7PFk5Ty7ka0mvAxmZmbWMAfu VcQY/0tpxnBWnHW32o1Dq6C2dW7E4Whi6vKo1eTiqJZ9b9S6cT2U9X8u95qV0eTX91DQPob6zIqC 7rQ15NHoQiDv3tz20Nz2VPS9g8p2Tk+2/bdjZmbWBg7cW3dzYf+HnTIK6+oOpLTl4VTg98n2tm18 72+BzdDCYKujNpOnoG42e6Kg/SiyPuupB9BFw1sNfOYWqJPMXsn+YFTqkp+E+kBue2jh9W8mj3Og OwXjyozPzMzM6uDAvXVXFfZ3xW0hrdTMKJA+pHD8j8CnKOhuq6/RBNBdUB/1A1EJyu/RxeScuXOn JJ+9HvBRg5/3ZfK4cfJ4S/K4Qe6c53Pbs6MyntRryeM8qLTncSCEELZocDxmZma9Xr/OHkBXF2O8 KYTwGjAsOTQYZTn/0Hmjsi7mS+BlYFMUqKbB8tdoUulhTfqcacClydcglHEfgYLm6VBpzH3oLtG4 Cu9Rq3+jMptV0H8nbkQTVgfnznkZ1bKn/eiHkgXzaeC+SPL4DAr612rjuMzMzHotZ9xrc1Zh/yCy VTPNQL8j/VCf9byzablAUTNMRL3ej0fZ971RWcvltD1oB2XJR6OJpnMk73k3pZOzJwDv5vaH5rbT wH2x5PGZ5HGNJozNzMysVwoxxmqLuVgihJD2x07tCvylk4ZjXU9fNFkzrQXvKfqh0htQfXt/Smvm bwY2Sbb3QxcqoDsBDwJfoVKi5VDw/m2Mcbp2HrOZmVmP5Ix77S4u7B9K9SXrrXeZCowENu/kcTTb lNz2GFpOdH01t71QbjvNuM+EyodeQln86UIInqRqZmbWAAfutTsVlSeklgC27KSxWNc0lfIdXH5P 2/u5dwUBmL5w7LXc9ty57bFkJTsrofr4l5L9JdtldGZmZj2cA/caxRg/QJ068po16dB6rvmAg4Ed O3sgDToQWCHZ/i2akJqXX4RpzsJzaVCfTkhN69yXaNrozMzMehEH7nWIMR5B6XLu30flEWaVvI9a Qo6g+7URHYLuFhyQ7K8CLEjpJNT3cttzFF7/YvK4dvKYBu7OuJuZmTXAgXv9TirsH94po7CuaFk0 IXOhwvGHgAG0T3eZ9jQv+m/EvMl+2st95dw543PbxYz7PcnjquiixRl3MzOzNnDgXqcY48koi5ra CGVTzdZDvwv7FI6fmTyu27HDaZq0dv2m5HFQ7rl868li4H5H8tgfZd3TwH14U0dnZmbWSzhwb8zx hf1TOmUU1tVcCXyHVjfN9/m/K/maqxPG1BYvAN+SrYj6FvAApZ1mJqBJuaCAPh/Uf0AWrG+AJqy+ DwwKISyCmZmZ1cWBewNijH+itLZ3TcBLudtHaFXTuVCgmrcBsG+Hj6htvgX+i1o6pn6MVlXN+yy3 Xcy6X588rp88poH8is0YoJmZWW/iwL1xvyuz37fcidar/Bb1Nt+6zHNfd/BYmuEuSv878R7wZeGc T3LblQL35ZLn0sB9ZJPGZ2Zm1ms4cG9QjPFctCBNakm0mqr1bh8Aa9CydWhqAN1rZdXTgVGtnPNp brtYDvQk+jsJaA6AA3czM7MGOXBvm2KHmd9SWuNrvdNY4PkKzw0n62veHXyHgu+8gYX9fMa9XB1/ mnXfgCxwX6btQzMzM+tdHLi3zf2F/SHAHp0xEOsW5kAtFZfr7IG0wfpoQuohuWP5jPuQMq+5O3nc AC3K9BUQQgg/apcRmpmZ9VAO3NtmWpljB1PaUcQsdRZaSbW7ZZvzFxr90FyOrXLH8hn3eWnpweRx aPJef0/21y9zrpmZmVXgwL1tppY5tgCwU0cPxLqcPVAHlrx3ksfuVOM+Nypv2SjZfwB1m1mZ7AI1 H7iXy7h/RFZusz1wdrK9Q1NHamZm1sM5cG+bxSscPwx3mOnNZkTB6WloUmbq4uRxMNmiRl3dx8Cb wDHJ/gTgNjTJdp7kWGulMgDnJ487Aa+gVVVnDSEUF6syMzOzChy4t02lGt3F6V4TEK25vkXB7jzA qrnjrwK3JtvDOnpQbXAJsERu/2DgXWrPuANchmrbh6A1D85Kjv+yaaM0MzPr4Ry4t80PctsfoxKI H6OsYnHiqvUeU8gmb25SeG4LFAQ/0KEjapsTKA2w3wAWRRcnUFvgPhG4OtneG7gBBf9LhBCKPyMz MzMrI8QYY2cPojsKIWwO3JQ7dCHuKGOl7kwei6uo9jSDUAlNanbg8zLnjUATVSO6eNkaLVx2a4xx 4/YepJmZWXfnjHvjimUyt5Y9y3qzPYErO3sQHWAi8Fluf2iF8x4CnkN1/3sBF6Cyoo1CCEu25wDN zMx6Agfujdsitx3RZDuzvDdRcNobvJPbXqjKeekk1V1QwH8lCuR/1T7DMjMz6zkcuDcghDAUmC13 6HXKlwaY9VS/BjbL7b+e264WuF+CsvOzAaOBM9CF7/YhhCWqvM7MzKzXc+DemKGF/Uc6YxDWrQ0B tumgz9oI1dt/C3yNJpO+DbwI/BMtpjSglfeYFdg3OW9e4LfAcbnnX8ttD63yPhOAM5PtvYGnUceZ vsDvW/tGzMzMejMH7o0ZWth34G7V/BA4qnBsL9RlZaOWpzfdgWiV0oHADMCcKCu+JLp4uBZ4Clih ynvsgnrTHwV8CIxJXp+uV/Bk7twNWxnPOcA3wPeAlYAjUdnM5smkbzMzMyvDgXtjhhb2H+2MQVi3 EFCd+2/Qqrqpj5LnTm7nz98KrXJ6ZLI9ClgDBenDUPB9ODAcXYDuW+F9LkY1+1uh0pargemAxZLn 838DS1G9k85nwDXJ9t7oIiDNtp9R27dlZmbW+zhwb8zQwv4znTEI6xYi8BegH7Bz7vi1qN/78sA6 7fTZpyafMwcqi7kOuAO1ZHwG1aW/jC4eNgTGoaz6JSg7n/dlMs4n0X83rkqOp3XpY1AmPrVfK2P7 a/K4AzALcArwAbBYCKF4d8LMzMxw4N6ouXLbXwHfddZArFs4GQXFu6AsO2jBrluS7QXb4TNHoBVO QR2Pbmjl/HuANdGdgJ1RgF8M3seg72Eays7fTWn/9nzWfXO0SFMldwHvo9KdnybvkwbsR4UQ2uNn YmZm1q05cG/MlNy2u8lYa75AwfuiwNq54xcmj4+3w2f+DF0kTAR2Q5l/gE1RGctwtGBYfqXT11At /FhgLeDcKu8fk3PvzB17LLfdB5UHVTINuCLZ3it5vBS4Fy3odFqV15qZmfVKDtwbMzm3/VnFs8wy ZwL3k5WWgFbevQF4qcmf1Z+sY82VwFvJ9k7Av1Ed+TrAn1F3mZPI7gS8iMpmvgV2pb7ON8W5HqNR mU4llyWPSyXjieiC4ytg2xDC6Do+28zMrMdz4N4YB+5Wr4ko235+7tg0ShfyapYNgcHJ9s254/sk j4PIutkMAA4jqzkHtWi8KNmup978MbLMPugC4idVzn8GeD7Z/mXy+DZwULJ9bghhnjo+38zMrEdz 4N6YSbntwRXPMuscm+a2n00eFwFWS7YXBrYuvGZH4Pu5/VPQBeqKqPa9FuMo7ecOqomv5tLkcSvU HhJUQnQbMDtwXo2fbWZm1uM5cG/Mu7ntFXHwbl3L1OTxG7IVTZep4XX5VpDvkq1PsFbu+OLA7sn2 QFRac2nu+WK5zApU7w9/IVoUKlBa174HMB7YMoSwfQ1jNzMz6/EcuDfmqdx2H2C9zhqI9QgBWLWJ 7zc+efwOleNA6YTqSrZDvdlTaRlLfmz7o770P0zef0FUyz5T8ny5NQ1+VuUzx5GVD61JVlrzHllp z1k1jN3MzKzHc+DemKcK+9UWmzFLDUUZ5tkLx89EvdWb9XuUBu6z5j7rDtQnvZov0KTU1IvJ4/y5 Y6ejOvY0wP4nyryPSvYfLvO+e5GV6ZRzKsq6p++fjvly9POaM4TwZLkXmln7CiGsHkIY1tnjMDNx 4N6AGOObZMERtL7Euxmojnw3SmvQAeZGCzQ1a+Ghu3Pb6cqmk1H5SWx5OqDymj0Kx/omjwNyx95A 9edrJPtHoMz8DMn+E7ScsD0ArZRaaaLpx8CJyfZcyXumjkAXFCuFENwi0qyDxRgfjDEW566YWSdx 4N64p3Pbi6AJf2bVpPXmxU4raUC6DtUXLarVU2QtJpfOHb8Z+EOZ88cDm6H2lHlzJ4/9C8f/L/f+ HwLLknWlmYYWcyqaFwXvxUWdUqeRTWzdjexCYCyaKAuwr7vMmJlZb+bAvXH3Fva37IxBWLdyDfAO KonJB6CPAFehWvfVm/RZf08eD6L07/xw4KHc/t/Q5NHbyrzH0OTx48LxF6h+l+mB3PaLZAs5rU62 6FTRJFQ/Dyrxyf89nYVWdJ0OOLTK55qZmfVoDtwbd31hf+dOGYV1J5PRaqJ90UTQvP1RffeDTfqs C9GqvksDPy2MYRRaiAm02NHbZV4/PVlJz3N1fvaNue3FUbnL2cn+jlQuCboFuC7Z/gswMtmegC44 AH4RQmjGXQkzM7Nux4F7g2KMT6J63tTyVG97ZwZqnfgrSluKgjLKB6Ma8mb4GDgg2T6e0gmmX6OF n85FnVuKPd1BfdVnTrbrDdzfJPvb6IcWe9ofrRILcBzw4wqvPQAF6v3RXYgFk+N/RXe5BqDJrGZm Zr2OA/e22b+wv3vZs8wyETiBLLPcnv6GguX5gP+QBcGgyaj7onUI7iu8bgbg6GT7LRRAt2YtSgPq /Gu2QrXvO6DVVQO6gCm3auw7aCVXgDmBa1GJTAT2RF1vtg4huAWrmZn1OiHGWKnLhNUghHAzWUnB OGAIpS31zGo1EBhBy/kTbdEfZbgPBd5HWfbnUd/1mYAZgZfJSmcALka916cAa1NaE1/J5qhE5ieo jeNQFPQDfIm6xXyHJrw+hCZzT0L94Iv19QFNcF0n2f89cEiyfTjwO+CZGOPyNYzLzMysx3Dg3kYh hGOA3+YObUz5iX5mrTkEdVDZALirye89EmXYN0bBet5EYBvURvI3ZO0Yf42C/koOAdZFwTdo0aSB qMvSOLQYU7p401ZkdxmWQLX8s6HVXTemZdZ/EeBZlP2fiia2PopKbx5HpWmHxBhdNmNmZr2GS2Xa IISwNHBg4XCzuoJYz1ZssQjKdE8kyy43073AtsAcKIjPd3cZhCaGTiQL2s8m661eyUBgE2B7lJ0/ AgXjaf16vlxmx9z2y6hrzHdoEuxNwPcK7/0m8PNkuy/62QxIPmd3FMyfEEJYuZUxmpmZ9RjOuLdB COFdSuuGI7ASpT3ezYp+ido0Lk/pQl6gNo47oNrzZ9pxDAH1Tl8VGIbKZqagSaXnoNaVrZkFdaR5 D1guOfZX1MlmZWAhso41k9Hfyke51++Avt+AFllal5bf85VkHXiORGUyoPKZg4EXY4xL1TBWMzOz bs8Z9waFEM6mNGgHTQZ00G6tGYSC2mJLSFB9eCCbHNpeIrp4WAv1lJ8BBeLrUVvQDrro2A8F6mmL xl3J+ra/g3rUg+4w7Fl4/RUoGAdl6u9AZTR5u5MtzHQwWZnPr1EN/VIhhNNrHK+ZmVm35ox7A0II i6NFaPLlDp8CS9JyuXezoqXRBNEHUOCcNwD9Ls2AJnJ2h9+nuYBPKjy3M3BJsv0BumCZUjjnZLKF lT5A9fCP5p5fAU1onQ71uj84Ob4BcDu6CBkZYyzWyZuZmfUozrg3Zj9a1ijvR/cIsqzzvYCy2muQ rU6amoRqvvsCP+jYYTWsUtAOuoPwfrI9L5oEW3QY2aJM86Ig/XR08QK6i5X2pN8fBewAdybn9UEL NpmZmfVoDtwbs0lh/0ZUi2tWq98kj+UWIro6edy8Y4bSriYDZ+b2K028PRGV0kxA/106EN2V2Ch5 /nx0EdAXTXpdLDl+OLpzsWgIodYSHzMzs27JpTJ1CiEsBryeO/QtCiLeL/8Ks4quQ5M6F0MLFKX6 Ak8C/yIL8LuzWdAE1pmS/fVR68lyFgDOoHQ118tQID8RuB9NAH8FWBMYi7L0T6LSol/FGI9v8vjN zMy6BGfc67dZYf9uHLRbY05DCxGtXzg+FdV1/6ajB9Rk66DVT8cDF+SOH1r+dEAB/jaozv2D5NiO qLxoWXQX4l1gOHAruhj4AE30nQwcF0LYoXnfgpmZWdfhwL1+cxf2X+2UUVhP8F/gY7JykLzueCds KNncj0FoEamr0H9nLsqdtxFqhVnNdcBSwJ/Rz2IudJG8MipVG5ds34Amrd4H7I068lwSQlizzd+N mZlZF+PAvX6fF/Y/7pRRWE8wDfUu7wmrf/ZDK52elOxPQpNWR6Ls+YtoxdNUtax7ajxahGkbtMLq IBTQr4Ey7xOT978y+fyL0GTVgcC1IYRiu9amCCGsFkLYPoSwYwjhpyEE95E3M7MO4cC9fsXOMcVA 3qweL9EzLv6moEmiv0A1+1PQaqeQrS78h9z5o2nZUaeSf6H+8mNR/f+fgVEooJ8M/JBsYaZDgJtR hv76+r+NlkIIe4cQ7gwhvB9CAHgY+Aeqvb8UeDGE8EoIoT1WvDUzM/sfB+71KwbuxdIZs2aaC7gl eezqDkeB9SnJ/h/RSqlrAN9DZTNvJc/1JevHXouHgRFkE8N/DWxPFrAfBGyI7mJsj2riVwwhNNzt KYTwqxDCJ8CfUAvK6VELypNRTf2iqGXlOsDMwKnJwmxmZmbtwoF7/cYW9hfulFFYT7II6lVe7iJw NLAxWR/zruxZVKqyFQqyP0XZ8HHAHigLf2Lu/F2p74LkdbRg1UvJ/s6o1Ohb9N+yfwDfB75CPfDH AqNDCEe2fKvKQghHhRC+Bo5Pxvdi8n3Mji4ODkctO99EJTz3of7yAHuFEJas5/PMzMxq5cC9fh8U 9otLtJvVaySarLlfmedeSR53QVnqru4o4F6UZQd4DAXTaR3/pWRZ90HUl3UHZfBHoow6KJCfLtke jFZSXTn5jLSU5vgQQnHthbJCCP8CTgBmRH/ru6OWnTe28tKr0ffdDzirpu/EzMysTu7j3oCkzjU1 Cd0m/65zRmM9wPIo4z4GWIjSnu4BBalLolakN3f46OoXUFnJxArP707WHvJrVOte76rDc6KuNcsm +9+hn81WKNO+NsrM7wucDXwBrBpjfL3lW/1vfYbrgaVRF5tjUUnMN3WMaXnUT74PsF2M8ar6viUz M7PqnHGvUwhhvcKh71BWz6xRzwCPAPOjSZd5kay8ZNuOHFQbRCoH7QB/JbtzNSOqT6/Xp2jC6jPJ /kBUanQrMAdwB7oIOge4ApgNdaRpIYQwCt0ZSIP2n6Me+vUE7SRjSdtenlbna83MzFrlwL1+xeDp V5RmSM0akZZX7FrmuStQPfVqHTecdjUJ1cKn9kOBdb3GouD9qWR/9eQLYD7U930RYE+UfV8mKYX5 nxDCLmjyb/r5+1C6WFS9jgYmAAuEEA5vw/uYmZm14MC9fvnA/RbgzM4aiPUoV6Nykc1R9jhvKgpI t+roQTVB/r8xf0ETPacHzkflK6DVTw+kMZ+jlWcfTPZnBm5DFzqLoBaVCwM/QgH1ViGEMwFCCHsl Y0rnDvwaOK/C5wwBDkNZ9d9TeVLtx2RtLx24m5lZU7nGvQ4hhF+SBepfAsugJdrNmmFtFMT+u7MH 0iR/ReUq66OOMlegVo17owD5OHTHCrTY0sJkwXy9BgH/RKuqFn2eHJ8XuAZdTNyELpJAJTHHUHkh rF1Q7/j+uWMTgZ8m71c0M5qvMBOwb4zxnDq+DzMzs4qcca9PvgPGkThot+a6j54TtIPq19dGpSqg yZ6Qtbb8I1kt/Cxo8aRGTQS2QIsiFQ1G/de/Icvsb47q2S8FhmCB6+8AACAASURBVFM5aD8cZeX7 F44PQiu2bl/mNV+iixbQhGIzM7OmcOBeoxDCTih7CMqm/bkTh2O9Ux+6R0vIVBoMp1n1p1EZy3Bg BVSjflHu/P1QVrxRk1EW/JQyz6V3MvqTlbKEZDyVLsCPJFvgqZx0FdcFyjx3afJYnMxuZmbWMAfu tftFbvsV3EnGOt5+KEvdXTyEOrR8RFa3fzD629ky2T8NldGAMvSVMt+1iqgWfX9aThrvi+rTBwM3 JMfOB4aVeZ8lUPlMa2aidFGp1OPAh8B0IYTda3gfMzOzVjlwr10+CJix00ZhPV2o8txfUe/y7uTP wEpk6xy8gFYfvSTZfwe4MHf+j9Gqq211Jlp19tsyz+1MtkrtTGhi8AyFc84FBtT4WT+h5QrKEbWm BC1KZWZm1mYO3Gs3Jre9KloAxqyZFkJ3cyqVV3wBPIcyyt3Zf4C3c/tHobKZVFuz7ql/op/l2DLP fT+3vTxwD9nf9E7AunV8TkDlP0Vpr/q5yzxnZmZWNwfutbstt90H+GFnDcR6rBGobGPfCs8vCNyL 6q7n66AxtZcNyC5APgeOyD23BvCDJn3OQ+jnWnbF1JxVk3PXQ+U09VqozLEvk8epDbyfmZlZCw7c axRjvBD4Kndoy0rnmjXoWuAT1PGk3IJEu6GAPaAykO4mXwa0D3AS2fdxEfBw7vlTadnJpVGvo4uB 56uc8wmwKCpFqtSjPe8L4OXcvgN3MzNrdw7c63NFbntDYGgnjcN6pkmo3nsAsE2Z548h68LS3QL3 gcCnqB4c9L1MQ5NTp0M14TuTtYccTuOLMpXzCeon/2KF529EbR9rtRvK0KfKdZZJ18hw4G5mZk3h wL0+F+e2B+JVU635zkeB3rYVnt8b1WOvAszeUYNqgimom8x5KLP9HPA3dAchLZl5FTg095qj0eqn zfIJKoV5ucxzu6GLhoNo2Y2mnJtQ7/nU/GXOSWvmHbibmVlTOHCvQ4zxYRRcpH6Aa92tud5FJTPr obaFRZOB7dBk6ZEdN6yKhgBnAdclX+egrHpxQuZUdNExI1okKaBJqZ+hAD2dkHsucHuyPSOaYDpd E8f7MVoU6skyz+0LrAjsSPluNHkzUvrvUy1wr+VCwMzMrFUO3OsQQjgNmKNw+EJKO1SYtdXxqOd4 pXkUY9Fkyjs6bEQtzY8mcb6O1jjYApWP7YMC8/fQyqJr5V5zHVr86BNURvI+sEPy3PHJYwR2RTXk oED6tCaP/VN00XNPmed2Qhfk30N3BSoZQunFiTPuZmbW7kKMMbZ+moUQNqRyoPQtqs+9quNGZD3c 5cCswKadPZCcBVCf9fVQV5j0wv954HCUKV8X2B1ddKSTSx9EK5q+UeF9d0CrnQ4jy3RvT+mckh+g 8pRmGph8xlaF45OAQUA/tLjSgWQTa8eiOwWXA+MoXcl2DnQHIXUPukB4N8a4YJPHbmZmvZAD9zqE ECLZ/8AfQpn2NHiJaFXLY8i6SZg1ahjqd74kML6TxwKwCSpbGYgC2adR/fnLwCNlzp8L2AutlDoz 8DXKzF9a4f37ka2gmrqcLCP/KbAsKnVppr5okahdc8e+QT//95P99dGCUfOjPvuboSA93wUHYGlK J79+CMwDPB1jXKHJ4zYzs17IgXsdQghPACsnuycA1wMXoAVcUh+j7OOlZF0lzBrRH9W0d7YhwLMo WD0N+L86XrsAqttPbYdWKq3FbKhcJe1Zfyu6A9Eef1cnUzox9nNgT+CaZH8wKv3ZAF1IvUjLFV7X RX32QWP/PNm+Nsa4dfOHbGZmvY1r3OuTX4RpbeAxVGt8DFmANTdqK/cQsEyHjs56mq4QtIPq0ucA 3gF+DSyFguinUfnY39GF7M9oOaH2Q0prvC9GdxFq8UXynmmgvjFwSP3Dr8lhlAbug9EdhmPRXbbP gVHAHsnzxaAdSldTzn+PbzZvmGZm1ps5cK9PPnD/Hup2MRn9z30VVNqQ+j7wOAoI/HO2ttgeBcud YRaUJQdNRp2Iut5shO40bYDq3o9EQfkLlHZamkJpJ6YZk/Mr2RTVlaf18XegC+PUiWgSbHs4FbWF zF9oHA38A5geXUBcCKxJaS17Kr9w02K57beaO0wzM+utHFDWIcb4H7LVUwcCv8w9/SyaiLYGWn0x Peck4H5K/0duVo+z0N2danXSO9A+Ae1qKOP8Larz7oOC2ErmQSVkFwEzJMfK1YKnDiLLYoNq6Y9A Pd5Tx6MyFVBN+j+AJWr9Bup0MfAjSttBbocuyock+8+TlcTkDchtD8ltf9DE8ZmZWS/mwL1+1+S2 f0eWjUw9iLKQ25BNpFsdeAb1iQ6Y1edU1OXkb+hisGhhNJHznHb47LQkZCyaYDoNzesoGot+z9dG LSJ3Rb3SV6L0TlT6nul/e36BFmVaPdlP20WOJls9Nl1V9YFkfzDq2NJewft1qCwnP8l8VeBRsoun AcUXoS4zqXzg/lFTR2dmZr2WA/f65Rdu6YOCqQ3KnHctKm9IW0QOAs5GLfPKLY9uVskpqERjGVRL XjQ2+RpGtpBRs6QlOvkgdq7CORNQwP4Quru0KsqyL446zhRXgZ2HrM3lb9Df0SXob+RNYHNUknMy WcnMd6jF5Ku592jP4P0/wDqUdrGZH108nEJpf/pUPnCfJ7f9YdNHZ2ZmvZID9xqEEJYNIXw/hPAo cGZy+LvkcQDK0JVbLOdzlDn8CVlLvw1Qp4yftt+IrQfaC00CPQgFxHlfoRaNAL9q8uemJSOz5I6N LJxzAPBSbn8cmsj5X9TmcbMy7/uL5PGvKIM/jGyhpceS19xDaZ/0z1DA/2my397B+9Oo9C0/uXQG NEF21jLn5wP3/OJMra3CamZmVhMH7q0IIRyMsuyPoAmpU1BwtDgqCQD9z/xaKgdNl6PJq88m+7Og dpEXUP6Wu1nRVFQu8kPKB4KXobs766Jgs1kmJI/zotr2/pQGym+guwFFX6GLjEpGoWAdFMTfjzLc qXtR7Xvxe30D/Qy+SfbbO3h/A/08n23tRLL5L6C7B6mLQwjzFE82MzOrlwP3KkII56MsYHq7/h0U XJyAelOvSxa8B+A4NIluEC29jmp786ur7o4mss5Z5nyzoqlo9dB3Kzw/GnWgmaXC8434OnkMqFTn ArK/B1BbyEoeRyU85QRgn2R7EroTtXSFc4seBnZC9fbQ/sH7R+jvvrXgPR+45yfwbgq8EUL4XbMH ZmZmvYsD9wpCCBcAP88dugFNTHswd2wMpcE7aLLqdZSfhDoRBVdHk/WmXhPVzXpJdKvHLJT/HbsS uLmJn5Mv/1gNZf2Ln1fJNPS3kPcM8ESyPZrse5hEfQsrXUNpT/f2Dt7HoTr+U6g82TQfuOdXgZ2E 7sodEUIYH0I4qn2GaGZmPZ0D9zJCCBeRtaiLKNDektIgJpUG7y/kjm1I9cWXjkdBS1onvziqB651 YRrr3c5CixNt1QGf9Vhuu9jR5itKL2TLubiw/zhq5wjqvFLrBevNwJ2U3k04nWzOCbR/8D4ercsw P1pVdUrh+Xzgng/uR6AL+kfR+E8IIXwcQtivncZpZmY9lAP3ghDCXmgRltT/oUC7WjZwDFqMZmfg NfQ/8DGtfNTVqOVc+j/7+VGd77CKrzCTj1Cm+hTKt4cE/T7tR/lJlPV4mKwkZWlKFyd6qLBfzkOo 73lqA/6fvfMOm6Oq/vjnvikEEjqhBQgtCKF36UWaSK8qIB3pqCDSVJCiKAhIVaSqIEWl994VQgm9 E0JNSIA0Asn7zu+P78xv7szO7s723fc9n+eZZ3dn7szcLbNz7rnnfI8M2IgFKI4fkvMf4DvAA6iK a8RPgIu914023kHv+VLi+H/Q/4P/2jfcbwxf/8JbtwBwvnPuBedc3hAhwzAMo49jhruHc245pCMd cRHy6uWhGylkLIOMpc9z7PMQKuI0CsW6n4+VRzfKcwZKhl4KDSyzmISM2lHAqjWcaxLwSPh8H5Iq L48VtM7mVO/5cFRxODL4ixnuCyP1mAeAOZChfDnShb/Waxeg+gi+hn0zjPfo3BHTiAc4kJSRXAJ9 hg+m9p+OBvzPOOcOxzAMwzDKYIZ7kguJk8reJxlDWwk95Zv8P1cixZnNgFMo78E0jKgg0YPAr4mL F/lMQuFds6IQk1pyKNLhLhEv5Nz/BpJe9/2BV8LnsxfZ52MUHrMJMt5nD/f7KZKjPMhrGyBlmlO8 dQsSa8o3iine80mpbXmKLr0L3I6+owucc7fXq2OGYRhG78QM9xDn3G4ki9f8FHnRDKMdmQJsiYzq o4u0eREVMxqMJEmr5UbiOgQ+eaVMA1RoKWJn4nCXrLyRaJ+9kWG7OhrgApwLrEgy3CbiZKR3Hw1+ 50NG/+Y5+1kp/qzaxNS2PIb7cijh9wJk+H/POfeKc26h0rsZhmEYfRUz3GPO9p4/iEIRDKOdmYEM 1Z1LtHkWDUg/IFumNA9foQrBaQZXcIx/E3vo+6HEVCgdGjYD2AlJqO6EQmIAXkPFkbL4M9J5j7zh Q5Dxv0cFfc2LP+hIG+5+qMzFwH5I7/6rVLt5kXrVmUhuciTwiHPOVKYMwzCMAsxwB5xzZwKLhi97 iKtQGkZv4Amk717LDNLJFGqyD6lg/7TXHWRQv1Zmv2+AH6CwtX8WadM/9foOFD40Jnw9ABWoqndV 2fHe81Ie9/eBK5BS1aoklXqi/kU1IJ5DCeqPOOeWrGtvDcMwjI6nzxvuzrmRJA31i8gfu2sY7cBs KJzlAgqN2CyuRKozlTCBwkqolXrwH0m9/kPO/XqAs8I+pPlluD5d3OhFVOn4cW9dZBwvSn0Y6z1P 98033Id5z19H8pDHkawK24UKuz2IwoAWBx51zm3qnBvmnFvbObezc+4o59wfnHN/cc79zjl3tHNu b+fc1s651Z1zZb9X59zW+d+iYRiG0U64IAgqKXrS63DOPYuUKkA34pEkk84Mo91Zjbio0eUk5Uyz eAEpu+xInCSal0eADcLnJyKFm7wsiJJOI5aidhWlVZE60xzAr0gq2IDkMv9MsnDUdBSacgby6FfL McSDj7MoTGafHp7/VhS+k2ZppFq1bWr9BWh25BhKO1cCsotwBWgG4FMUzjMZxdBPRkm+u4bH/wAN bG4OgiBdKMswDMNoQ/q0xz0sQb6at+pgzGg3Oo9nUTjJZBRL/Zsy7bdFnvnnkad61tLNE5zuPa/0 /yOdzJpndqAczwHbIyP5NygkyOdrJGP5C2K1p0FIjed5YO0azv2R9zxrNiBaVyxe/S1k0O9CMl7+ cCSTuRXwYWqfAOULfBe9j/lQSND1wHkoJOgu4G00mPk2SmLeFf02dg2PMxuSrt0XuMk5N80592/n 3F7F365hGIbRaupx4+xInHPrk5y6v4b6loo3jGbyT+R1vw6Fj4xG4TNZvI9kEq9FIRtDULGmPPge 3n5FW2UzIPV6emarynkIJa/egGLJ36FQdeb3aHbhGmIJyuWQx/lMJCVZqffdL7iUjnH3t5dTifkX +u6uRYY2aIZgCTQr8htkxIMGG3sQf3YTkAE+AM0WjkOe9EhZZwAK1VkSaejvgAYxHwND0SzIcsig 3x7YyTn3FfDvIAgakdBrGIZh1ECfDZVxzr2DbmagpLvlKEy+M4xOYyCq9HsQivF+o0TbLqRoMh0Z vHk4GXmrQWEpv6qgb8uRDM2Zi2yZyXJ0IS/ySyTjzNcEbkPx7ZsV2XckcAsK0/F5Bnm+xxTsUZyz iKU4N0EDCJ/ngFWAmeh7Kfdf2x/NaPyceID0JZpFWB0NLvoB9yDv+rzIKN8E2Ii4iu504GVU9fZB pOOf53NeFH2f+4bn+U8QBDvm2M8wDMNoEn3ScHfOXUYyDnhP4B8t6o5hNIIVkTf2o3INK+QeYl30 06lMqWVlYhnHHmSoVvP/syQKM/kU6dSP8rYthbzUZ5XYfy50vaeTNCcib/ZdOfqwO7HKzUfI6E0X XnsMWM87Z95BylbAVcD84etuFPc+K8nCU3mZgWYXb0azEuU05k8mHpz9PgiCY6s4p2EYhtEA+lyM u3NuG5JG+52Y0W70Pl6kcqN9duCHKOEzi/5IESUiKzGyFH6M+2SqM9pBoTAHojjwh4nDS0Cx3aWM dlA8+XbAX1Lr50ESlSdT+r9xQOoc15JdLdmX35wvY3sx7gJWIg7d6wccRWy0j83aqQQDgO8Af0Jh NGuUaX86+v0A/Nw5t0GpxoZhGEbz6HOGO8mb9RSUkGoYvZn1kLe1nAE2GXmzn0DqNOnY7FVJare/ XGE//Bj3YhVT83IZcAhKsryFbInHWdEMwafESZkR3ShMKB3q04W8zXegUJQsNiMpp/n3Iu38GPh5 irQpxqfA91Ci6tepbT1IzaYaXf5+FK+0GzEDOD587ijU3zcMwzBaRJ8y3J1zfwEW9lb9AiXqGUZv ZiPkYX6AQgM2zWnA8si7PhrwVUY2TLV9oMJ+zO49f6/CfbOIZB6/QqEoaWagIknzI9WViylMkD01 PEbaON4SqfWsmXHcHbzn/6N4FVffcJ+zSJtyXIgGXP7/1HD0fW4OPFrFMXei/AzA7d45zeNuGIbR JvQZw905ty5wgLfqAXQjN4zezu+Qckp/VHxp2TLt3wF+hNRKnvLW+2EyL1M+VjrNct7ztOpLtfwN qa+8mLFtJopZ/yGK9z8YuJdCI/pqlOD5aWr9YihO3Z+V64di6CPOK9E333CfvWir8jyNZGvv9dZ9 Cw1cdkMF5GZUcLyBKBG3HK9G7Z1zq5VsaRiGYTSFPmO4oxCZ6P1OQXHufS4x1+iT9CDZx8WRQsnH JVvHfA686b1e0Xt+fxX98Pevl+EO2fHlPtciNZnr0ezD1RltnkTe9dtJDkgGogH+1SgsZ0MkowhS obqhxHn9UJY5yvSxHBNQ0urpxP9bKyDVmOuQBz4dOnMdcA4KF0rHxa9HefzvvtxgzzAMw2gCfcJw d84dh25yET+nPlP1htFJjEFVPKuRYJwVVfqMqMZwX8V7Xk/DPQ/jkBLMVsRqMOn/v7FIpWYxlAjq x+HvhRJhz/HW3URpT3e9PO4RPUjFZ3vv2MuG/XoBxd5/7rUPgJ+hsJ/FiJViIDl7UgxfSnS5oq0M wzCMptHrDXfn3GKoIE3E/WiK2TAMhcPcgZIRSxVkW574/6IHGYuVMBgppYA82o3MLZkTSUTejt6f z93IAz8o7MedFMbHz0DJvLMTFzICqbGs7L0u5W2HpOFeq8fd51YU6hINGkaE615A8eiRmtCuJBVk /AJzS6HvpBS+4f6tajtrGIZh1I9eb7ijGNToBhWVhLcQGcMQU1AIyBko7GLhIu38MJfXqdxrvzbx wKDR3vYv0WB9fRT7fiZJNRxQkaKrkQf+EQoVdMYhw31eNABIM5Hyybm+4V7OSK6Uu1ChpOi/bHWk bvMqCoN5E8XjX0osw5n+zsrJeb7jPZ+7ls4ahmEY9aFXG+7OuW1JJpKdiqnIGIbPR0jj+1RgXRQP neV59w33p6s4z7re8/9WsX+l3IH03Z8CjkWDjRGpNscgacSRwOMUVlP9Chm7u1OoHPMflPxaCj/m fNa8Ha+Af5CUdtwRyUS+hwYtb6PwpIvC7dNT+5frv18HoF/VvTQMwzDqRq823JGUWsRblFaAMIy+ SjfSM98MeI5CAxbiKp5QneHuJ0M+UcX+1fAqSkbdHOnSv5nR5o/Atijh9HEUEpRmKgqpiZgJnJ3j /L7HvRGGOyjm/gLv9c+Q9vs4pAP/GUrEP5JCCchuSjMVzciAGe6GYRhtQa813J1z56KErIifAd+0 qDuG0Qk8iJIwX8/Y9pX3vFLD3RFXN51Zxf61ch8KnZkF5bc8SjL2+04UG/4o8GGRY/jVWS8glkos RTMMd1B+gu8dPw8lpL6O4tx70EDjyNR+5Qx3iBV2SuU/GIZhGE2iVxruzrlvAUd4qx5AyVuGYeRj EAoxiWKzI8N9JsULDhVjYeIE0NEkDdpmMgMN3tdHXv/dvG3PIyM3q6LrD5DOO6ig0yk5z9foUJmI KcDvvdddaHAxAHgI9bc/sI/X5kvKy2hCbLibx90wDKMN6JWGOyrRHd1oAmSAGIaRnxVQUudx4eso ProflRtxvqLKczX2qxZ60ID+h8izfkiOfUaiGhARJ5Ft3GfRLMMd4K8kve5LA4eGz08Fbku1zypY lUVUlMoMd8MwjDag1xnuzrnNkYcs4jIkDWcYRn6eQbHSj4WvI4+7I6nnngdfw7zSaquN4Fokb7hl mXb9gWuIFWmeRwZyXnxjd5YK9quGqcij7itm/YZYRevg1LbROY/rD9gMwzCMFtMb4xYv8Z6/jcqB G4ZROX5ytx/jvgz5DT9IGu6fFm1VXxzq5/qo2ula4bqvcy5TgEWJddunoKJMecJLIgZ6z5vxX3sv miE5M3w9B3Jc7IX6/iaxrn3e7y9SnumN9wrDMIyOo1f9GTvnfk0y/nQvYlUEwzCqx5cSTBc1Koef FP5ZHfqSxiE1mHWR/OHKqNhTWrs9Yhr67xtYZHuaqUihpdKkWt/L3iyP9e/RgONwb93GqDiT/35f y3m8yHA3j7thGEYb0KsMd+J4XFDRlCdb1RHD6GVM8J5Xarj7MeHro1CVerEPUkyZJ2PbWKQU8wjw LPL2j0ezBwsgA34gMvBnB1ZFRZl8pgHbhMeolGZ73COOQgWldvbWpWPs89azMMPdMAyjjeg1hrtz 7njgt96q01vVF8PohdyHYqQdSSnFPLyCjOhFUf7JsdRHWeZE4LTw+ZNIonF7lIx5C/Au8nqvhLTp N0cG/qzIqP0iPMZLwJxIMtbnXuS5fqPK/vke96WA1dAAotH0AHugAUlWHH9AcdnLNJHhXjZG3zk3 HFgOJfQuigYHbwJvBEFQ7WdoGIZheLggCILyzdof59xnxAVGHgQ2bWF3DKM3MgoZnwEqWDShdPME v0TJkqC8k3Nr7MvGSObVAXchKceb0XU/HngZDQ42Jpa0zMsYNLi4vsY+7kXSg9+D8gaOpzmSmIPQ Z7JFav14kgW1SnEu8uB/FATBwv4G59wGwHdR4a7lKf05z0R6+T8NguCtnOc2DMMwUvQKVRnn3Kkk qwKat90w6s8d4aMDvlPhvpcQx8kfjTTGqyUqpORQKMsBwJ7Eg/WhyGD/HpUZ7S8AeyPVnFqNdiiM oe9CcpQvIWO30UwnTlT1+biCY0Qe94EAzrnvOecudc6NQ2FIJ6DE38FIMehmNPP5J+CfqAhUgGZ3 twVeds61zf+zc24V59xWzrl1nHMjnXPDWt0nwzCMUnR8qIxzbkGkHhPxP+D+FnXHMHoztyMdc5A3 uRLjdjzwN+BAYBHkIb+myn5sThxnfxcK+9jK2/410ot/MlyeRgWglgMuIi4G9RUyNB9F721Mlf0p xhJF1i+OwnAuQ4OYL+t8Xp+NUq8nkpTLLUekojOvc64bfU4+HyID/RqKhwEthDz3O6FB14nOufeA HYMgaImuv3PuTDTYKygm5pwDzSbdA/wpCALLlTIMo23o+FAZ59yFwGHeqh2Bm1rUHcPozXShBM/5 kCd2GDCugv0XQ+E28yHD6BLgHCoLuQEloUf5LPsAVyF99f1T69I4VD01SrSciYzKRijdgDzry5dp 8wEadLzcgPMPRoOReb11lYYpXYa04NM8g8KJHiYpkTkUheh8QFI3HjTLMme438/RbMkPgyBoyv+1 c24pFLL1A5Ix+2+j72oKCmGagpSJNkW/mQeBPYIg+AjDMIxWE3QwKOHrG3SDCNDNz7Xy8zSMXs6l xNdbNTUSNkAe8egY91RxjLO9/XcM1w0GngjXfUrxUJTIoIyWQ4u0q5XhqfP8GHnad0dea3/beJQ7 UG9+lTrPA1QeHpnua7T8JdVuFTQQ+yrc/hWaydif7MTWSBN/JnBIE+4VP0RGuf8engZ2KfGZjADO QgO7d4FlGt1PwzCMcnS64X5t6o/4R5XdkwzDqJDlkdc6ICPMICf7krxud69w/029fU/11vdD3vhp Xv+OQQP8iL+nzv2Yt21rVFG1HvgDnACFw6zrbT8QxaD72zeu07lBYTq+ofoFUnqplGfINtxnokHY t9BnmNUmWk4scuyjvDa/bOB9YjXiweIXwH+oLEdjYeSVHw+s3qh+GoZh5KFjDffwz7jH++N/j14Q s28YHcDFxNfd5lUe43jvGO+TQ27Qox/yqgdkVwAdDlxH0ngcDZyMvKxpwzIyqAcQx7/Xwkhk2KbP MxlY22u3Bnrv0fbpwA51OD8UDhwqHRyBZi8/o7hBPo14EFdqKRXHfoLXbrcG3SuiBNkXgNmq+BxA A6EPUEz/go3op2EYRh462XC/K3Vz+EmVf8iGYVTGUsSG6XNUH572R6oPu/mtt+9xRdqsjf4n/AF+ 1vIB8qrWi3R4yQkorvt9FM/vx72PQHkCvid73xrPvxnJ93xJlcdZgdKfW95lcpnznBG2mwKsWOf7 xPnhsT8nOfNSDcuh7+qRevbRMAyjEjoyOdU5tziKOYwMhi/RNHC5G4RhGPXhOmC38PleKASlUmZB oQuDUBjCwsTyg+UYhBJdR6J46hEULyq0BDJmFw7PMxlYE0kzRowCNkRe5FroQp7zSO7yXWQwBuG2 zVDYha+EtQZKgBzirTse+F0V518SKWtFCalPoRCcr6s41uHI8AWp4Ayn8qq5EQMo/d1ej5SG3gqC YOkqz5HAObc5yqFwwHbAbUjIYFPgHeAXQHeFhz0AzWacFQTBMfXop2EYRkW0dtxQHch75Xt0zmrp h2gYfY/VSYapVRLq4vMX4CNk1G1U4b6rkkxOvxdYoIL9ryL5P/JvYsWZahmWOmZeycz10YDC3/dP VJZMOjtSR4n2HwssWMH+af7lHSsK8dkWVUOtxOP+ao5zLYgGcQHwhzrdJ8aGx3sgPMdFXp++orpZ lkvC/buBDerRT8MwjEro1AJMfhzoTHSDMwyjeYwC7gufKippcAAAIABJREFUD0fe2Wo4HXnvJ6OC SZXwHEoojWT6NkNxzN/Nuf8BJGs+7AhcQW2F6ZZMvY706udJrb8WacyvFL5+DOULfOK1OQJppOcd FF1GHIbzFfqf/KR485I4kgOpx5CneVR4juPIP8N5aY42n6BZBoCfOufWyHnsTJxzf0P1AkCf8znA IeHrccCWxL+bSngkfOwCrqyhi4ZhGNXR6pFDpSCPWjex5+Tuln6AhtF32Yz4OpwAzFHFMQYiNahx xFrm86PwmzVzHmNekt7hALiT2CguxRzI2Pf3rcV43887zkvE8ogfowqjIK/+DcRx3f6AZSHg8VR/ Hkf66KXwk30D4PtV9j9iW+9Y75L0VJ+D/ofnQ+E86ZkCfxlP/oTQLhTaEwAP1nCPWCvVBz9R+H2q U9eJcMCL3vEuruPtzTAMoyydaLj7N8YAec0Mw2gNo4ivxVPLtM3CoZCX18JjLIGu6eiYdwBz5zzW Wsh7Hxlq3cCNKKynFMOAN0j+r9yNZhJKsRCwSWrdzd4xvoOKTkUSlOOIq6l2AaeFfZyJ5CEjBhCH ZETLO2QXcxqMPPp+29PL9DsPD3vHWwepeN3irZuCBgsDkAG/ByqqlA4/OqHC8/qDwapCUYgHRWNI Gu0zSEpyVsOOxIpG0fLdet/nDMMwitGJhrsv8/Y1+W/qhmHUH98zOxl5yytlCAod6SaugrwzSjqP jNZVKjjecKRYM8nr2zMo0XIvZGSeiJRpIi/43ChsxjfIpgCXI4/4GsB6KLFxVhTz/Tkq4BOxGLGh OIGkPO2GyLO/Raqv30He+JkUasgfQdLwnErSUbEkhbMFF1F7Ebpve8dLa/WvgUKkou2jw/YRP/O2 fUIy4TYPvkb/pVXeI6Lv8UCSv4HfFjtpGb6PfgfFYvu/BFau973OMAwji0403H1d4Vuq/CM2DKN+ +IbcaVXsPysyjLpRiEvE0shwDJBiTKUJsHMAR6Pk2Sxj6yrkbY/oT1KjvthyMjLaA6RqE3GG1+aK Cvo5LzK4Nw1fr+D1awvvXNFyLfJMj0utr4fR3oVUaaJjFitqtwXKMYhmNh5EMfbTvH0PruL8u3j7 X1nlPeJe4kGF//lsX0V/1iYZmhkgXfgTgF966z4CFq/3/c4wDCNNRxnuyNvj/4H+oIo/YsMw6stK xMbNaxXu64A5iT3uX5GMiR4E/AHFPlerXEN4juWBrZAHfVCJtocTV9ostXxBXLBpCZJG61Y5+nQ4 mrFIE3mM/4EGNcuiWYdSfamH0Q5wqHfMRykd6++AvZEOfro/o6iuIN5B3jEuq/I+cXdGfwJgxSr6 42vyP4VmXYahQcCJJPXyXwcWqcN9bhEkuzkCzarUfEzDMHoPnWa4+wlYU1F8p2EYrecK4mtzZJm2 Pg7FSN9EbPxvWnKP5rAC2VVW08s3yFB8wlv3CuWN6EW99hekts0G3Bpu+294rGFIVrGRRvswYknG KWjGIw+zoSRVv087V9mH47xjnFvlfeJRsj+nSuUflyDpbb+WZE5H1jIGWD7VnyVRLsS+wClodukm NEvxHBqUTSS72q5/3N8Di9bnbmoYRqdSjUeklfjeqVuQ8W4YRuv5J7BP+HwnZLzmITJKFyM2PkcS a2+3ipdQ7PaqKKFxI1TIKC3rOIDCuPWzkLFVirHIW30uiut/gVg2cRoqGLQ38Gs0W/AZMkiX9Y4R AOcRx5XXQhdKop0zfH0k8FbOfaehEKNfhK8/RIZpNfif75fOuUVQcuyqyAvdg5JMP0cqRC8GQfBY 6hjFFHiWoTIJyP1IzjhESj1Twj5k5VctBrzknHsDzZYMI1lsq1oWQ8m/P3XOXRAEQbXyq4ZhdDqt HjnkBSk4+NOS27X0gzMMw2cQcajIqAr2mxPJC04lvrbHIkMli2Eojr5WucNq6ELqKj9HXvZI6jFa uomN17zMg8JTViiyfSAyIMd455mKNMTzyF3m5UTv+NdVsf8S3v431tCPv3rH+YLiHmh/mQz8Ddgy vFdMKNLuMCrDD5MJ0GDuKOLBzYIo1+CnKL7/v5SWxpyKBkN3oAHboSg5eVH0OxgaHjMayC6JwmU2 zujLZ8ABrb4vG4bRfDrJcD/E+9OaiG5ohmG0D3cQX6N5tbIXQmXpo5CE6HEi2Z7TuYiTNe+p4DyN YBAq5HMisCfZco3V4lDxpkgmMxrQHIoqpNaTNZAHOUCJvHOWbJ3NesT9rEWO8hGKG755lrdIOnjS IUWV8La37zo593FoELMlUhJaAf3Ga8nPiNgQqSP57+mvrb43G4bRXDopVMZXBPgXii01DKN9eIy4 aul2wIU59pkLSUg6JN03CnnUx6LiPWm+QDKJf0OVRp9ERtLLGW0bzXTkea9nEbj+yGD/BbByuO4T pFjzF5Q0W09mRZ9lfxRj/UOkuFMpvjrP61X2ZQhJaUmfHvIVxVqqxLZisxpZDAQW914/nXO/ABWs ejdH20FocDp/+DgUfQZd4dINXI1Cc0CDmjWR0s9FKLdgf+fcTUEQ7IBhGH2CTjLcN/KeVzOVaxhG Y3nKe74r+Qz3RZFHMkBG+GGUjwn+OzLW90QG48PI41utwdguLIOKKUUFoyaghMQLUBhSI/gdcdz8 L1CSbTX4Mx/Vfg8bo5wBgLORlCdoYPQDpLk/HIWVzINizKPncyKjdwiakRhMYcLu8uG6PPkAs5Mc KByAkkjHhMv03O8qZijymm+KQmTSuv1ZHIUSfV8KXwdIxnQsSmCeDdjBOXdcEAS/q6JPhmF0GB1h uDvnvodi/EBeuYdb2B3DMLJ5mtgzuhHynj5Vcg9YAHnde5DX/P2MNuugUIOHvHX7IM/wYUgH/QLk ge9UdkSe78Hoszgf6YRPbuA5N0OzF6D/1D/WcCy/8Na4Ko/hVzWNBi9TUDz4DCqb2XDAf0jO1M6D DOc894/0vfFi73mAEnCvQEo/n6JZkc/Q9zcf+k3OFy4rooFlMUM9QEmzPRSGfi0DPI4Svu/31j+A xBpuQ7MmpzvnNg2CoNVJ3YZhNJiOMNyBrb3n96A/ccMw2ovJaDp/4/D1ScA2ZfaZB/0P9SAv5syM Nr9EITjnoUTAKBb+cBTzezYaKMyLvNTtxLZoVmAK8tS+iYw8n58hJRqHQmH2QOGAjWQelOAaeaWP rfF4k7zn1c4OrOU93zh8HIKKcgVIL/4VFMf+YbhMIM53+jRcFyXy3kVh0aW9qdxwfwjlGvwYfV4O aa3/MsdxspiGZjYiOcg5UdLzOmggm87fmgN9BsejRO6ecP0DwK9QnYN+wD+dc8ODIBhTZb8Mw+gE WhphnxOSCVr7tPQDMwyjFLuSTJ5btUz7k5ARPiN8noWveHIFhbHOQ6muuE6j2ZfCBMlupEoTsUtq W57CTfXgJu+819fheD/2jldN8qxDMygBMqxPRAoz9wJvUKjgU2r5GHnbn83YNplkga9iDPf2uSRc tzfFE1/zLBPRrMrvw8dnKazKWm55gqQkaD+S9QaebfX92jCMxtIpHnd/ivGulvXCMIxy3IQMp4XC 1ydRuhjPcsgQ70Fxu1n8FiXyHYcG7pNQ7G/EeOJE1n4o7OQTlCzbKlYlNvgmAAcTx0b77/No7/nv aM7/26EkPdFn1uGYfiLxbFQe4rMY8iyDYrfPymgzf9huMWRYL4Y830NRSMpQNOuyIBAla6YL9Q0B dkOzDaXw740Lho9XAc+jJNc5wzbRMhDJN+6JHE1ZA8m5w+21sA7y0p+MPqNuNAv1aLh9Vefc9UEQ 7FbjeQzDaFPa3nB3zu0E/Dt8OZnCaWbDMNqHGUj95Nfh6x2Q0kexhNO5vOcTi7TpQWEJ1yLVk1IS kLMDf0ahIFcgI7WaRMJaOY445GFPsg3yzYhVVF4m/swayWootMjnVvT5XokMwWr4zHs+HIWtVMIy 3vPRRdqMC5dnyhyrCw3gQL+dUcQKPaD3/wTy5BfDT2BdCP2ulkRG/GzhOn8QsQhxYm2jZ38GoUHe riiE5iOSA5TdnHMnBUFwGoBzbsGw3wuG/V4YhW/5jwuiz2oC+i6jwfB0YpUbf3FF1s9AA+tomVzk +ZdBEHR6MrlhtIYWe/zLgrxB0TTgi639tAzDyMGcyMCKrtvzSrSN4pd7UKx3PdgExYoHyMgbVrp5 Q3ggPP90Ch0kC6CiSn4I4O5N6NMGxBr4Wct/0QxINYz0jrNrFfsf7O2/YJm2lbIehSEub5AMOUkz gFjb/iM001NtiEwrlh4kyfq3NuhLqWUaUut5ArgBzSIcAGzQatvDMNqVtve4A2t7zy3pxjDany+B E4BLw9f7Io/upIy2frz6iDqd/0GU4HkdUie5HhmtPaV2qjNvowHELKggz5vetuGoSFFkoPYAtzS4 PzugGYtB4eu7kCNkd+IqtWuhMIxfE4dh5CXtca+UId7zes+qPo700Pf21o1A73UpZJinmYGKUS2N vNT3o9Cr9b02ARqgvo/uTS+jUJrRKFxsP6R2FDEVVZW9N9w38lz3Q2E0aU33oWh2qZriTQ5Ji+aJ 58/LBCRLOYNkmFB6mTU87+DweVqW02dWdH0skd7gnAPNwr2KfqujgdFBELQyBM4wWk4nGO6re88/ aFkvDMOohMuBg1DBmNmB/ZEiRjEclRXI8RmGDChfberG8JwXIpnBVVHIRLPwZwc3J2m4/w8ZybcA qyAD7l/Iq1utlGIW/dHnfyiFsdUHoVj7E5FayYkotGcWFIaxIxpwvZrzXBOQod+PZOGivPhKKlHO Qz05FsX1+6FZg5Aiyx5F9nkBGe6gPKsNUBz+HMgj/xGlC2LdipKPX0SG//3ExZTyMgCF3qyJlHY2 Jh7w/RipKf0QDQTSBrIf2/8++g1OTi1T0IBiSmpJr5tKdcW/HDLOB4fLbGiQtigKPVoqXEagAWT6 PcyDZkzW+/8DyqAfg5KYbwyCoNGDXsNoL1rt8i8HyWm1q1r7aRmGUQErIHnHAFWS7JfR5lbi63sK 1TkT7gmXIRnbFkHa3VnnbiSrEb+vsSR1ziMGAr9BVaAD5LU+ARky81Bdn5cHjkSDgkilJVrGEavJ vEzsaQd9V0+n2k9HBm/efowN97utin77ykGNcigdRna4RjElnx29NrXKZdaT4Sg3IjJyd0cDjPVR nsLf0eAw6vuXyHhudwYjR91eqFLwTaiYV/QfUmyZhGbV9mi1vWIYzaDTDPc7m/s/YhhGjdxFfP3+ KGP7BcTxx93I0K6UV8L9n0aqIu3CPcTv/UGKG6SrkC1dGMUAj0NxwKNRddl7kdzhv5AXdxQKzfmi yDFmIg/7IGTAPRyu/5BkImU/VD01Lb34FKXjwSOeCNtXk4u0l3e+AWXaVks/lPOQ/nw+J3u2ZwBK 0AyAOxrUp0YS5Q10em7YQPT97AacigpxFcvVmAHcBxzeatvFMBpFWxvuaErQvyjLqQkYhtFe7El8 /b5Boff2AGKP2kzylYFPswGayg+Q8TiodPOmsQixFzqgdGXS/sgj/B76HKaE+76AYrHfpXRiaTRj MQrFNv8K+D4y9LM8xrujeOVxFIYnLEtshEfLV0h/vpT3/b6wbTXVXtfyztXI728VsrXTPyA5AxFx LvFn26gBRaPYGfX99nINOxCHEqkPQKpzkyj8TqejkL2VWm3LGEY9aXfDfXjqQswqh24YRvsymKTB +f3U9tXQDTYKFak2TGIJYg/3DRRPiJsFJSluW+V5KmUFku8/a9ahEpYGLvKO9zFKPM2KDwaFCUUz GulKnw59/ln7dSF98GhAFC2jSFY49fkwbDOxyDFLMad3jqXLtK2Va7xzXUSsgPQqhTM2m3lt16ez OJr4PfZ2BgDfQUnIWcW67ge2brVNYxj1oN0N9xEUjqANw+gsDiS+hl8madQtg8JB6hUKtzMKO1m5 yPYzvL5cQnWKHZWyDvLYBsiIPqEOx9wFuIwMNY4MtiY2To/O2L4gMrrfQgmPvld9BCru4/8Pd6Pq n35C6Tze9n9V8D58orCU7arcPy/LEnvdn0aDlygf4EmSSiwrEL+vAxvcr3pzPur3Ma3uSJOZF/3O 3yDbgB/ZatvGMGqh3Q33RTIuvGrKaRuG0ToccVz1DJJa4XMhtYvIkG408yJZv+j/5H/EVV4byXdI eq+vprZBw0DgT0jZ5EXKhxgthEIm3iuy/VRiz/zdJBN9I+97NMCKltHAGmGbo7z1h1T0TmJeDvc/ rsr9K8H3uq+KPOtRkvBtxDM/83vt0jMW7c5tqN+lKhf3Zhy67rIGnn5M/Nvo97BNq20ew8hDWxvu QVCQnBogxQXDMDqLbYg9zn8i1m/vQprmM1E8dzNwSOrwI+IQvJWacN5lSCq3PI60uovRj1gmz2ct FJ8eHec+8ocYLVNi21rEg5ori+z7OMn/45mo2NTH4evxZKv75OGR8Bh/qXL/StiJ+D1EWus/8tZd Hq4bmNGuU4h+I6u2uiNtwF7EMzqllvuAxVtt9xhGKTrBcJ+eurDWaf41bxhGjcyJvFs9SObNl6fb ACWX9SADv1kMBk5CqjT7Numc/ZF3O0rIHY/07VdBIRqrAkcgFZPIQ/8B8hwuhXTHfXm8Z1DxnmrY imyjbmOKh4V0IenGYhJ9tVS/jaQqr6/hGHmZi6RUacQvid/LGeG6aKbhxib0q55E4VlzlWvYRxiK ipCVM94nYt53o43pBMP9o9RF1ej4R8MwGkOUPPopSQ/3rMTxqBOpv6TjYBQ/v3+dj1sL66JQE/+/ rYfyRoU/xX8y1SudRCouPcB5lFZyyUo0XY1kyFE0wKhFEeay8Dh31XCMSogUd7pJ9vsfxO/pCOKZ gE6q2Bkl+05sdUfakO2IE6mLLT3A6a22fwwji04w3F9KXVAHtOBCNwyjdvYnvo7PT207jNhwrbcK xsneea8hWVGy1ayPvOjPIifFeDTA+StwJpoR+C1wMSqscymSdly4xvN2IcnIaEbzZVTUJ81aaKA1 CiW5pvEL/RxcY5/OCo/zRI3HycsviPvuDyRnQ2FbkVE/MXw+pkn9qgdLoj4/2+qOtClzoeup3AB5 NHBoq+0gw/DpBMP94dSFVA9FBsMwms88yFMcoPLpfqJ5P2Lt8JkkCwPVyvpIWzz6D3kBSc0WYw4U A51lyPY2lkEe5u5wOZ+kqspApCATJfSd621zwGvh+repXef8vPBYn9d4nLxsQfyb2DW1bUlig92f 5eiiM1gT9fnRVnekzdmFfLHvU4E/t9oeMowgCIJO+BNKT/WVSuYyDKN9mYiqfoJivTf3tnUDe6Ab ZD9kxNWLx5BqSFTAbSVUDbSYQtWxSNLwSZSMuXwd+9JuvIE+93nRAOdKNKiK+AZ9Hhsh9Z/DicNK tidWszkZGba1ECW1flXjcfIy1nueTtp9hzjGPaI/zVEgqgfRIKrW76S3cyMK+/q0TLvZgIOcc6Od c4s3ulOGUYpONNznb0kvDMOoB9eEj5HEoB8//S6xlOAmyDCsF/9FXshtUYjIkRSv8HkSCt2ZhmLR n0aqFL2ZL9BAZRQaRKV5DGmab43Ca/ojTzyocNE/6tCHKITp9TocKw8feM+z1HaezFi3aIP6Um8m hY9muJdnLPADsn/3Ed3o/2Al4Gnn3AbN6JhhZGGGu2EYzeQmdAMEWJtC/fG/hW1AMpH1/o+6Dam6 3FCm3UVI6eUplDx7NfDzOvelndkAxb2fAywQrvsGxd8D7I6kKkGe6Z46nDPyuL9Sh2PlYTJxUb+s aq3PorAtnwUb2qP6EQ1KzXDPx4NoQJ/FY6jQ2Uro9zIUuN85t2aT+mYYCTrRcLdQGcPoXKYAt4bP ByDVjjRnh4/L09ziMWkt9DdR+MgRwC00z6BsByahWP+fIAN27dT2aBDzNpLYqweRmtDbdTpeOWYn DvvJMnC/QoMXn2qlN5vNF+GjGe75+S2SYU3zFPLKv43CyrpR7kczZEsNo4BONNwXyGxlGEan4IdV 7E1hwZ7HUMgGwI+b0iM4DcXAr5Za340K72yPKo/2FV5AHsYbkYLNwyhhF2BLYOXw+RmUDjHIywIo lInwvD9DRtKsRfeoHb+w1fgibf6Xej1Pg/pSb6agUKD5UM6IUZ4AhcS9n1q/HzLUAf4N/BDNPi3h nHvaObeIc+6Y5nXT6PO0Oju2HCQr3EX6qgNLvSfDMNqaAUg5JLqm98toswfx9b5kg/sz1OvLdGCf Bp+v09gXhV58jAzp+9Fn9Rb1MwoPJ1vN4wsUtrRGnc7js7V3nmJVUQ9M9ef0BvSjEQxCuQfPU7va T19jMwp/h9/LaBMpVT2FZucOarW9ZPQNOsHj/l7qtaNzEoQMwyhkBkmZun0y2twAfIau92JVPOvF RKRi8w0wC3AF+Tz9C6K6EsciY3bz0s07litQLsK/kVd803D9hdTH2w6KmQe4GbgcGUSgQkKHoATh t9DMSFY8ejX4HvdiCbGd6nF3aNAzD5I+zSqiZWRzHyoG5pMO2bsPJdB/jsLIlqa2qsGGkZ9Wjxzy QOHod5OWfmiGYdTKz0nOomXpqv8x3P4ZjQ2ZiFgIOBEVO9onR/sTSP4v/a5hPWsffkz8nS1Sp2Mu HR5vJrG6y2YUVpb1l0eBg6hNrOAM73jfKdKmP5Iojdr9s4bzNZO5kNTnaJQrYoZ7ZcyPwo2i7/3D Iu38/7EAOLfV9pLR++kUw31y6uLYp8EXrWEYjWUdktf0sRltRnrb27Ficn+k9x718U3qZ8y2K1eh 95r2RNfjmFdmbFsV+BMavGUZ8N0o/v6nVD4Te693nFKVaB/z2t1aol274FCewEfAc5jhXi0nkvyt zZfRZjCFv81dW20zGb2bTgiVgaTeLpSuemgYRvvzDMlCO3tmtHkFhUhA48NlqmEmmkL/MfLOLY3k EosVduoNrBc+3l2n4y2D8hm+QaE3Z6NiTkuF259DmvsLAd9FYTtfePt3ARui2ZkxyMg+kvL3iLmB jcPnryEjtxjPec9nKXPcdqALfa6TUDGtZekMIYp242KS/1FZ1ZynEqvLREWcLnPOLdvIjhl9m065 mMemXi+W2cowjE5hBiqKFLEihZKDEHth1yJWMmkla1EYtvMXZLSfgWJeO0UysFLmJzao61Uk6WSU 4HopMt43AX6N4tkfRUY56PdyF0pknh8p21yIjPUIhwYW56HcqNEomXQTYtnHiG2I5T+vK9PHF73n nWC4gxJS50WfaVCmrZHNRFT3IWKlIu1uDB9HoUHe7GgmzjAaQ6td/nlAF4Y/FXVvyTdlGEYn8BuS 1/UfM9rMjZReim1vJjuH/fiU7EFGb+cw4u+qHu9/LRTbPpW4sJFDVSyfJ46lv4LSOQ4roFjj/5Ed ThMgz+nDwFlIm35suP4byie7+mFdz1fw/lpFf/Qep6BZq10wSchq2ZP4u08nrEb0QzHw04HV0UxH APyh1baT0TvpFMP9WpJ/wq81+GI1DKPxbE7yuh5Ldizu9eH2d5rXtUwOIu7rNGDH1nan4SyAPNM/ Qmou7xO//1oriHYhGb1SSb2bAX9HBuhVOY+7drjP1xQ34v3ltBzHnCO1T7rab7sxEPg9ir1+GXmK Lca9OnxpyFEl2l1CPKCNJES/Boa32n4yeh+dYrhfTfKPc2oDL1TDMJrDEBQC4V/bWdPRvt52K8Nl BqLiUX5iZJYGvY8D1m1wvxqFn3ibXpav8diHhMf5gji06PvA0RQmmQ4imTy6MHGRrhMz2hMec1M0 q/Nf9F2l38MrFIbQFOM9b79rcu7TKgYDDxF73HfCPO7VsjHx9/41xQdAkYTpOmhQGikiXdZq+8no fXSK4f5XCv90582+fgzD6CDS4Q0/yWjTDyUPBigmupU45Hn/EPXnbUobf6uF7R6hsCprO7MmpT3V 6YI0lbAwMtgDZHhHROErM1Fs8bZF9l8ZGUaRMf45qmxbinlRvkTU/x7g2xX0+bbUvu1cwXsgCgma igYcWWooRj7WJ/m7H1ykXTSgj2oc7Be+nt5q+8nofXRKcuqMjHVWhMkwOp9HUq83zmjTjcIfoPXh KQFKRh2GDKKlUWxrMWZFRv4GaJByZKM7WCd+7j1/GA1WvvbW1VLJ9DJUWGkccK63fjPgFBSS8z3g FuCmsK3PC2hmZi4UbnURinMHDayyiiRNQB7oiEtQqE5e/ARV552vHYk09mdDMfxZ908jHz2p18UM 92nhY5SLcWf4OItzbt+698ro03SK4Z6+eEDyYIZhdDaPpl4vUaRdFOO8ErBk47pTERMor9jxOFJi OQiFdtTiqW4mq4aP01Gy6KXAFug9g2ppVKqeszKqiLtV+Pr3JMMeXyeWgtwCVWrdBinDZDEZVbA8 0WtzPortfgkNPqLQBgfsED7/EDiuwr6n8yuWyWzVPkShRV+Rff808jFb6nUxw31S+DgkfPyYOJG5 lkGuYRTQKYZ7VlltM9wNo/OJittEFCtg9DKxnvYORdq0K18jw3dtCvs+O+0ZA/9u+DiAWMv6ERTD +wawODKai0nzDkbqX5E+/x/R97dL+Hoy+kyyiJTDdkaDtMsr6PcxwC+BoWhgcEW4fj00SwIy2icV 7lqS8anXf0AzB9+j/SQio+RpgAcpPSNklCZdk2FIZiv4MqP9HeHjKnXtkdHn6RTD3TzuhtE7mQC8 6r2eh+JerUhTudXhMuXoorgx91Xq9dbIK3887aX8cXH42A84wlv/JjLeH0Ax+8+gwkhppqK437XQ 5zGc5Pt7kXzG8/vAs6l1Pw/Pv1NG++nI+z4cFcZaAskj7hZu/wJ5/StlXOr1YBTHfBvy8N+ABint kHvVjT43MB33Wkkb7sXyWaLf8hzeuigMsJ3DqowOpJMN91Ilqg3D6BweS70uFoZwFzJC1kVFeNqV E5GB+BAyHkt5ZB9DN/0zkEf6R8jL3WpuIa5YfTTJ/9uJKJTldyjO/w5k6KcHXJHH8SMKjexVqd5T PR/KGfhXeN7+GW2mo1yEjdD9Y9dw/T9JxurnJe12N8RxAAAgAElEQVRx9xmCZhL+hgz8J5DXv1jB nmYyjuwZayMfaQ/7N0XaRdesb+iPDh/ndM6NqGuvjD5NpxjuWX88wzLWGYbReTyeer1ckXYvIMO9 C9iuoT2qjS7kmdsIJUG+jRIvs/gQGBG2WwHF8r+HwjlaWYG1Gw0mQMmhf87YfjyqYPoxcDCKK/81 qoK7CHAP8tZHCiyvIQ89KImv2pmTXyA5yquAAyiv8b4cse78lVWe84vU67tRAmJ61qALzUj8Bv1e nwP2ovmDsWh2Yynaayan00jPoBQLO4pCxnxD/2M0GwPtGQ5ndCqtlrXJA3AmhXJkpYohGIbROYwk eW2fWqTd7MQSgDcWadMODCJOvPQ1348otRP6HG4hfo9v0/r46dOJ38OxRdrMh/6jn0FSjgFJff53 iZNdI03+mRSPF66E4SSlGVdF8fFHIllE0AAq6ku1BnQ/4oFjQKwOtBBJqchiywfAUZSuAFtPzgrP +zfMcK+Fu0l+j8OLtLsl3H58av0D4fpLWm1HGb2HTvG4Z8lZFUtiMwyjs3iNpLpIMY97D/Bp+LzY DbQdmI6M3GHAoSj++TxiibhivIJmEhYDfobiyVutwX0iUmoBGecXUmj8foa84GsgD+W2KL4dZESv TZxYHOlcv0hSnrFaxhD/JkCDn/XR5/0Imi2IvKZTqV4asRsViIpYPHz8GCnfHEycEJrFMCR9+R4K Pcpb+Kla3gof58Ji3KtlIPot+RTzuEf/R2NT6/8XPq5Zr04ZRqd43E8k24vRam+UYRj14Sni6/rt Eu1OQd7aD0q06Y2s2MJzO2S0R170V5A6TjFP7tzA08gTnf6PfiU8xsXpnepIZCRPBc5G8fUBirWv hQHEv9F0/QGAbyEVm0nk88AfRHZ8fj3YIjzPCw06fl9gEwq/t3RNgYjPw+0bpdZvF67/ptV2lNF7 6BTD/WcZF1BA7PUwDKOz+RXJypRZN8guVHCnmzhWui8wH/JOX0TjDL08LAvcTvw9vYq+t11RsugI VI30ba/NNBTrfiySaozW79OE/s6DVGWWIQ7PqdXTPT081hQUPpPFrMDuKJxrGqUN+DfCtvUOZ1k6 PH46Nt/IzwUkv6uvyQ61msdrk64xMdTbtmarbSmjd9AphvuhZP/p2fSTYfQOViZ5bW+c0aY/SuLs Bg5rWs8aw0rI8P075RPt5yX24j5MnGjZKtZFHvPxlPcsZy1jaW4IUBexAV2r0sunxO9jVfTdXQqc RHb41mAkRXk9yZyH9PIoSritFwOI8w3mKNPWKKQfye86QJr4WaxDPDAcmLH9zXD7Ia22pYzeQafE uKe1jyOGNrUXhmE0itHECgwgjfA0CyKjsQvdDDuZQ5AHew9kwB9FcQ/uBFTE5SlgQ6Rr3kpt6CdQ /xdCVVBPRDHtzwD3IwWao5Diy7nIS/8a8sS/CmxP8rtuND3EMfbL1nisL73nK6BZ3x1QQvW7aEDj zxZNRUb7biiJdk/ihEWf9cM+HlNj/yJmEMdbt3M+SLuyCYWSs/cUaRsNBt8lWy7y6fBx9Tr0yzA6 Jsb9+2R7KfZu4UdnGEZ9uZ742r43tW0A0kSfiG6OxYo0dQoLIAN3CvF7HkXp8uj9kczgTJQMauQn Cns4pcbjPEOhsszcKBk2+i7zxO+PQMovkym8r91IYeGfarg3PN72dThWX+OfFH4vxQzvS8PttxTZ HoX6Pt9qW8roHXSKx71YwQzzuBtG7+F+7/nGKHY04iSkbT4H8jz7KjSdyKdoIDISuDVctxry6s1W ZJ+ZKKZ8bhQyFDEUk/wrxQjiGZyRNR5rsvc80tlfFBnJw4CfAC97bTZHMxLbkKyb8ibyrq+AJAd9 dkZe2lr7GlUkrnWWoa+xAIUFwz6jsIJvRKSUVCwROJrtqWcolNGXafXIIQ/ojyzL4/67Fn50hmHU lxEkr+9I93xb4njdmRRKtPUGdkCFhKopLPcwKmJVylvfF1kAeb99Tflixlc5ojCme7xjnYvCtyai cJwTMva7zmv/JrGRl2YfCmPgp6DE1WqJcsOuqOEYfZEsFbvLirRd12uzeZE2c3tt1m61PWV0Pp1i uO+dcSGVupgMw+hMXiW+vr9BlS4/8tb1pRCRLuT5K5eMGhVJ6gGuxmpcgGLss8JQPq/iWI7YcPdV dS5A35FvzKdj1B1S3bkffT8fUzzMa3VUSdfvbw9wYBV9Bg0SAuDJKvfvi8yCviP/O+im+KzFJcQJ 16UiGMaE7Q5rtT1ldD5tb7ijqeFvyDbcb675MjUMo50oVrMhIBke0hc4hXiW4QSKh8MMBH6LQgoD 5Lk9ib5b52I34t/MVOR5XpvYKJ4XFflanOIJwT4DiWUAb/aO/Q4KdemPvp/pyLtfTOt7OaSHXyqx eFGU5Jg23vfJ0c80C1H9YKWvsj/ZOQdZDCFWeypW7TkiGvBd0Wqbyuh82tpwR+Wai93EAzQNaRhG 76Ef0iufiDztDyAjtNZ4307kSGS0Rf93dxDHVWexNHHp9QA4rdEdbEP6IQWbyOD1jeTfEodYTkK/ sxGoumhebiR5DxqPdNtBoTlHEn9HcwNbIoWSYvr7q1EYYrEkhZ73bqRAVClfhPu3WkK0E+iHdPXT dkaWwhWogFb0O1uizLH/ELZ9qdV2ldH5tK3hDjyUcQGll4uqv0YNwzDano1IGhN/yLHPSsA5wMEN 7Fe7sj3xZ/VoattCJAsizUBSmxci5bLvhPuX8ojfR/IedGiRdoNIKga9DeyYatOF5CUDFBLmG/fL AeNS55qJZhMqIapIvHGF+/VFjqfQxrirSNt+KAm5VBuffcK2M1ttWxmdT1sa7igL27947s+4oAIk jWYYhtGbGQgcjry9WYm5eaupLkTsHe6t/IP4/pAlXrA88AjJ+8h0FALzKvA6Ms6vD9v9BBm9+wCX p/b7bZm+HIASh6NqqwFKFPW/r/VQwmxAoVTlKijMxT/nDAoHAKW4KtyvLw7iKmFF4lCzaJmEBlBZ HOS12ybH8dfy2q/RahvL6GzaznBHf7b+xXMeiu0cS6HhflQ1V6hhGEYv4TDktT0TxdyW4i/Ia/sw 8FMUWtPbOI1kDHpWwqBD946vvLYzUchDDwpL8UOU0svHSJs7L4PQzMmvUPXNH6a2dyFP+gMZ+36b wiTbb8hfzOdXxPdRI5sBwPMU5hVsW6T9gsRVVZ/KeY7ZvWPv32o7y+hsXBAEQS2/+HrinFsPTW9G f7Y3ISnIHhTf+d3ULnsiD4thGEZfZBRxDO7HSHXn78hASDMCeZZ9L+IHKA77lQb2sZl0Af8mLjp0 PjKyZ2a0nQ/dX1ZHsxr+MgQpiSyE4sQfRkbawyjf4j2SdQcaySbo/jfIW/c8sCbZ78tnD/R7uBtV uTUKOZ1CKc9fkp0j0h997xuGrzdCMzN5GAMsBlwQBMHhVfSzaTjnlkCDjTnCx9lRsvtUFAIWLVOD IHi7Vf3ss7R23JAE6dxGo9Kx6EcT4SddRYv9ERmG0ZcZBvyX5P/ilSXaDyT2/I4GbiBWTOkt9COW 6QuQkX08UpOplKEklWf2QcbyO+RTpCnGwmiwdDGlE44jtqZQXe3YHPt9O2z7bnXd7PXsTlwjIlpu pbiC01leu2JqM8W4M9yvJRVUgW+hmZ0TULXXe9EA8G2UZO2HdFW6TENFw/6KwvpWbsV77Cu0jeFO MmYsQN52n2szfixrVnjhGIZh9DYc8qxGSaz/qeFY96AKkFchT/V3kFpKJ3IQycTeqUjQoFwl0Q2Q LKCvNjMAJbFGx7qzxr5tSmwwPpaxfXcKvcB7UWgsLVnmPPOHbbtJeuwN5Qr4xbkC4CWSDkMfvxDk dMp/9mnOJg7D+U2D7akl0W/oLCT0kVXToNHLpygiYh9gWCPfb1+jbUJlnHPPkKz89y9gF+/1H1Fc ps8yyEtvGIZhSEP8yxr2vwzYL2P9RGBfNPPZSThkJB+Mwmei2YWHUcz/rcioiVgReAbNTEwD/gm8 iIyPlcM2jyPP5Uc19m1tVH312yiM6a1wfX/kjR+BCjqd7e1zLVLAibiP4hU7Iyaj0J8VkBKKITWg c0nONn2Mvov3M9ovC/wPhYyABrXnVHjOA5CnO+IV4OQgCK6v8DgJnHPDkBNzDe8x7+zSN2g25m30 +/ssXPcNGtREj4NQ4TB/GYIGhguEy/yUTpR/BXn57wmC4Pbcb9AooC0Md+fcKmjKJqIbWBX9YUYc iP5ofeZHUzyGYRhG7cwK/Brd/AeES+SxPRpNh3cqC6L7yI9RiBHIMHkExYB3A99DswxZfIPins8I 29aL9dAsxxRv3dJogNCD4qJnhOvnRQbQ/F7bvVAcezFeRnH530Ox8n2ZhVE4Rzpf7hOU6zE6Y58l 0EBv0fD11aiae6VsgwaKaaYiRaOXkarRBJRXES0zUFhWv7D/30IDiW+FS7lQq6nEhnn6cSz6jdWD /sC66LPdGsnSFqMb2XenB0FwQ53O33doobf//yEZNxZQaKADzIZGg367vloZ0DAMIy/9UTG7Caho 3Yp1PPZSqNrtWSjJ75fAz1HSXrvSH4U93EnxqtwTkTPpeTSDcSPFpQEbxWLAk2hm2Wd3kn19n9L3 wrvDdoc0oI+dxJ7oe01/168Aw4vssxjKkYjaPkX1dsfa3nG6M/pR6/I1GlhfjOLMNyMeoLaCYSiE 7zz0Oy4WQ/8EsHmr7dBOol0M97e8L3EqyuTP4jepL9ySUw3DMEqzGcn/zR5kiNbDgP8j2Tfjk4u0 z5JnbCVzIW38LZCncEXicIhWsBmwjve6WOLwQyQ/75+UOOZfwzbldOd7K8ugmYas3+m9FK+cuwjy TPsG/nw19GNJ71inokHBbihk578UH0RmLR+hfJQ/onyMNWl/R+YANHg5EynspN/TQ8DIVtujnUDL DXeShQmiH3Qx5iNZja7T4i0NwzBawZrIQPiQ+P/z5jocdzVkNB6Mwgd2B7ajeELr31BS5hfIUzwK eYSvRveCvsxI4u/miBLtVkAhCf59cxzFBxy/Dtv0NenkNVGidpZ3uweFPRUbSC5EMrH5HWr3Xvta 7mdmbJ8FhUhtiK6jPZFhvwMKc9ocDeryqBC1OwORdG1WjYIzWm2XtjvtYLj/yfvSplLe23Gm174b jVoNwzCM8jhkGBxIcZWRk5Bc5EMo/GWzOp7/KArl96Ll7Iz2P0dT/zcjo/9sZOD2VvZEeVtfogTA NEORQQmxvGC0/KrIMfejbzm6FkeDlGJFtN6gdCjX0iSN9jFUriBTjOiYlSa29lYWQgm76f+EMcCO rbZP25V2MNz9MJm7cnzRQ5GBH+1zef1/S4ZhGH0S3+vrL49RGGvtU65qa7rtUJRotxhK+luYbKfN +Iy+7JNqMw8yTr+PBhlDK+hLO7IuilfePbV+DfQ9/Dt8vSbJz+VLstVEdgu39/bE1PlRPPXXFA8x uRDlyxVjQ5K5dK8TJ6XWg2gwcUEdj9kbGIFCutLhQncAS7baTm032sFw95djcn7Jp6T2O6W+vyHD MIw+SReajv8FqqURGc7jkXGd5mIko/cNcqJ8q879mQ15QDdCOU1bUaizfQ6FBtpbSJmsU/kBCo/w iWqZjPLWpQsT/i7jWLuE2+6pfzfbgqFoJr6UVvk4pOpSiiNIGv3PkFTvqQdR2E6WAIehQdKfSH4P 04ATW22rthMtNdyBbUleXKvk/HJnJZnpHaAsasMwDKN+OKSmkhVWE1Xl9Jdu4EdN651YEd3s70MJ hB+gQjpZMckjUJLm/iikopNYFHnVZyC9ftDgxA8JmUphfsFO4bYHmtPNpjEMDdr8Gfis5SpK65rP gSoI+/v8h9Ke+WqJQkKubMCxexNLAteT/E5eBTZppc3aLrTacD/D+1LGU7zMcBbrkByV9aD4QMMw DKPxDEJFmc5B4RuPI4OnlPLGIBTnfgSxVnwzOYRCz/xJtG9V0Y1Q4Z6ISApyS2/dv0i+p3NTx9gh XP9I47rZVJZCHutSITEBUoQpV5xqNZLhuj3ILmmU+lFUqfWaBh2/t7EukuD0v9ezW2m3tgOtNtwf 8L6M66r4UvdPfaEz0J+UYRiG0V4MQJrN/n/2NGRQnonii9OsAVwE/B44CIXN1MI8SGv+30jVJurH lTUetxEsjLSvo4KEEWcjVY6I9MzHVyRnG7YL1z/RyM42gTWQwVssuTlaJgKHUXpQ2IUSn33jfzyN l5iOzndjg8/Tm3DAkeh3HX1X97bSdm01rTbcfWnHA6v8Us8nedF+jSrJGYZhGO1DF3ACEiEYQ6Hq x1Op9kOQbGTaMCs2s/oDVIp+TfLP3i4QHi9LwQVaW8AGJFkYIHWfUrxE8jO62Nu2Tbjuf43oYINZ HA20XqG0sR6Faf2Z8lrra6NCRf6+D9Cc7zoqQvSvGo/TD/1m50MhVCNQpdK10CxNJB25fLh9Tppb Q6EL6eCvBGyAKql+G33G/ao85gooXMafUVmhlTZsq2iZ4Y7i2f0Lp1q5pT3Ivohvpb7Z4IZhGEb9 mA15kvdGXuSNUtsdCqu5BslTPo80ybMMkO+R/P8fnXG8SlkMeXc/QqEZtR6vGrpQAmq5xNJjSb7/ b4ilkr8brnu2QX2sN/1QSNBDFJd0TC8PA6uXOe78wGWpY05B3vlKwnSrpT9xcuo/i7SZD6k3LY+M 3q2Q+MY9KAl8EpUVavKXHjQQfgiFA21D6dj/UswV9nFLFPlwMvps70VKPMWqpEaREe+jmbaTqSyJ fA7gNu9Yk+mDVVdbabgf7H34Y6v88cwNfFriBzIZ/fFXO8IzDMMw2p8fosRN////yIx2WyJDbTfK F7LpjxJe/WPeQfO98F3Io1qKYRQWGooEG7Yge0aj3RiEchD8aqXlllGUD28ZApxI4ezNfdRPnz0P w71zX4sGJ2cDt6M4+1LGbqOWHuBNVATtL+hzOhYNFs5CMzdXI2P5aWRwl8stqGZ5H4WrHYAGBKVs tv4kk4mnA9u0ypZtBS4IgqDEB9QwnHOXI+1d0LTRLlUc5jLvGKV4ANgRjVYNwzCM3scgFB6wHrrx n4aM2YiFUAXMKBF1JtJFP4fSxYlWA45H6ixdyADcntYne/4VhUD8EHkxHwA28bbfjHK+NkQe6fso n6zZCoai/IUjyS+/+BoKoYkSc7OIBgLHk9T2fw84mlgPv1lsQG2/mS+Qk/P98HEsMmKHhsv83uO8 NNdhOQPlFkxCA+hJqWUyGlyujWYUys1wTEOzZqPRNfsumnEYj1Sk/oMGP5HdOAPYPQiCZn+nLaF/ C8/tSz/+t4r9N0CKBlnMJPneNkUXzHfRl28YhmH0LqajkJoHi2wfigyBZdGUe39gY8oX8XsW2DXc 7zhkKH9We3cr5hw0Y7ATMly7keHyJfJU3kDScN8YGW/Tw9dTmtXRnKyFEkR3IL8t8j7yBl9FclDm Mwty6J2A4qwjpiEp0LOIP5NmUqzKewB8jn5TH6D3GBnn7wNjgyB4BYWnzIUM11w451ZEA1Z/mR8l 7vYLly7veallctg/fxkLfBAEwccoXyQtRVqsX99FA+JvIUN+GZQ4HjEbion/dsbuX6CB6A/Qb2D3 8P1c75zbPQiCaoROOotWufpJTrdsVEXX7yF7yuUKNP31Qsa2d+nd5bINwzCM8iyEHDl7ZGxbBYkl FEtyLWaANZq70H0s8tpuQHxvOwBYkMJwmbVRrHSAQh5ajUOx1Q9TWSjFxyjsdZYSx54V+CnwYcb+ N5E04lvB8cT9ORRYpVX2V7uC5B8PRHacL9OZXqIcgX5oEBetnwns2er30WhaYriTLNU8k+IZ/cUY UuTLfI34wh6MpsLSbb6ksCKdYRiGYaxNMvlvHPB32qNY0xzAi6hfW6PBR1R86CsUNvMYyfvdicib GQAXNr/L/88sKIkxjzpMtHQDdwI7U1racVZkCI/JOMYzaMa9HbiM8H21wu7qRFBewKFk5z38Nvxc u1B8vv+72bfVfW8krTLcj/Q+5NFVXADLZ3yJAZoa9HFoWi2dmd6NpugMwzAMI2J74BMK7xmH5tj3 1+h+swUyJhvBWmF/PgEmeP27Ndx+Ksl+P4jU1QKkhd9s1gQuQGEgeQ326UjWsVxCbqTJPy7jGM8g /fp24hHUtzGtsLs6HVTPIf09HxV+tg7lfETre4Aft7rPjaJVhvs13gd8VRUXwNYZX2Cpgga7kl0W +SpKT70ZhmEYfY/ZkNH5M3RvyaMk41d4/ADYh/rKDDqkxhYVIPoauD/s47LIcEl7nb8Clguf30tz KtUOA35BZd71ACU3nk75OOnhwHkk68BEy+O074x6pIDXp4sH1QLx4Mc30L8ffr5dKGHV33ZYq/vc CFpluPvTHj+p4gI4kMILtpwk1CpkT6U9Sf5MdsMwDMPIYj90P/kMeYE/RAl09cIh5ZibkDNqSLh+ T6TcERnz6XvcNciIuZbGCVJ0oSTTuymMsy+3vI9i04cUHDXJSsA/kIJI+hh3oJj/dmVp4r5e2Aq7 qzeAZo8+Ifndfw1sFn7OA5BClL/9yFb3u960ynAvFd6Sh1NSx/iAfNJH8wOPUnjRv0F7xDAahmEY 7ctg5NUdg+LH52rSebM85fOjJL3oPvYesASSzEvf37qRPne9Dff50OfwHtlGeallNKpyXm4WYDUk /5cV8nojlRXwaRX74TkrW2F39RbQTFg6gmIS+p2AZEDv97b1ALu0ut/1pOmGOzLU/Q+8mj8+P5Yp IE5SyMPAjP0j43/5KvpiGIZh9A12J3nf+BI4k5wyeFXgUMGoCUjr3OeJVF/+EK5/JrV+DIob34f6 aXuPQPKUWSGo5ZYHkaJPOdZCsfvp/b9GEp7fqtN7aQZXEvf/u822u3obKBclPbPzKQoLAw2wn/S2 TQPWanW/60UrDPefeR/mO1VeBP4XEgArVHGMI4ljBaNlAtm6oYZhGIYxF3AShWGXH1O+Emul9EdF lAJUIdSv8rkE8iS+ggosTQJ+F267MdW38UgnfA9qM9wHhsd4iOJGebFlJnAdsEaO86xLLH3pL5+H 73HhGt5Dq3iX+H0Ma7bd1RshKXISLVNRHgioCNUbJK/RxVrd73rQCsPdl+35VxUXwECSpYFfquoy EpuhhBj/i5+CilwYhmEYRhZdSCThZmIH0OIl2q8GrF/hOa4Ij3sRElFYBPgbknf8CXG4yPxIySYq vnQ2hbMCr6LcsGpCZUaiWe0oubKSZSpwPhpolGMDVN01fYxxSAN99ir63g5Eqj4B8Fmzba7eDCrC mXbABsBtaBZsaZKKRqNb3ed60ArD3S+cdFIVF0EkhxUtp1Z9OYmlKcx+/4b6JhUZhmEYvZORKEG0 FEeje8udSAEmi9lQvPic4esfESukbEkcu74fiuN9KXydljZOeyLHAX8Kj5+XuZEE5v8obpSXWj5F Uo3z5jjXhiRjkqPlIzRDX0m/25E9iN/TXc22uXo7wGlk/wY/Ab6Dwmr89be3us+10grD3Z+62KaK i+Dg1JdQD+/4HGiE5h+3Bw0KOv1PwzAMw2geXRnr5gX+S+wBT9+3tkPhFFOA1VPHOhXdj75GRnnE msjb+BZJ2cntKAwxGZiz76ujglP+rHYly9soFn9QjnNtjOLd/f2/QvHgO9B7pJqjcKcAOKLZNldf AHiB7N9jN7pmfp1af36r+1wLrTDcfbmqtaq4CC7x9u+hfln9XchDkJ52GYs8H3n/+AzDMIy+yXBU 3fQF4BgKFVN+gIQQZiIn1FrE8dwvUJhweVy47U1i1Qyf88PtfijKyhSGq5SiC9iRQo3sSpaPgEMy 3m8WG1BosH+DQoI6MX69FD8gfo+TgQWabXP1BZDct1/xOL2ci+r2+OuObXW/q6WphjsqzOB/cHkS VdL4RS5ervJiKsV6ZEtbTUDV3DakvkU1DMMwjN7BPiTvGy8go8JnMHAGsVe7BxUUSnup50fG3l8p Ht89H/LgD0MOpi2QM8vvw/Qi+86OKk9mlZPPu3yKBhd5ZqbXIDvp9HoUstrbWJhkDt2vmmlv9TWA X1H6t3obSvL2Hb8/anW/q6HZhvt6qQ+yGv3VqNBEgP7QGsHsyEgv9gMYg7LbV8OMeMMwDCPm+8Br xPeLL8ieGf52uP2QjG37ImfRTTnONy9yKAXA60g5ZrJ3/rThvhKScvyS0oZOqeUFpMGeZyZ6BaTD 7u/fE7631Uvs18kMQnr//+9kbKat1VdBYWH+7z6t/T8p9XoGHSjP2WzDfc/Uh5b2RJRj4dT++1d/ XeVifeB2Sv+BfQhcBuxG84pxGIZhGO1LP3S/ex/dJ04r0u4jFNd+AjL2RhLfc6aTX6vcERvi+6KE VN9I/g+qoPohpe9n5ZZHkJpOHkaE5/T1trvDdb25Zkp/4N/E73kasFIzba2+CslwmA+Q0lK5GaXJ wMqt7nslNNtwPyn1gVVquG+a2n+laq+sCtkYxeRlyQ75y0zgMTRlsw71K3ZhGIZhdB5zIwNiBtIn T/Nbsr2BzwErVniu573jpD2NtS53o9j0PMwBXErh/fImiivq9BYckuz0bYLtm2ln9WWAbUn+5pZF oWnnUfqaGAss3Or+56XZhnu6Ymmlhvshqf2HVHlxVcs8KNnkOvJVjPsMuBrYBf14DMMwjL7BIOLk 0enIA/8fJA/o823gFmLD4nXyJXmmyaoyWsvSgxRR1sx5/lmQgscnqeO8gJxffYGLSX5++zTTxjKC gGQI2DHed7MjhaEy/vJ0q/uel2Yb7g+kPqi8fwgR53r7jg/XzVfhMerF7GhK8gHyeTemoCnCbeg9 MleGYRhGISORukxArCd9HvH94PKMfVYCHkX3kyUztpfCUXsYjH+vuoj8YToLI8lKPzwnQDH6h9J3 Zp7/QNJoP6iZ9pUhkJxp9D08lPqORlI6dObAVvc/D8023D9IfUibVXhh3Ont+zSwIBpBbVHhcerN 4kglIO1pKPXHeAvwY2Cp5nfXMAzDaBBbopaCHHkAACAASURBVP/4AFUHj5xLyxEXUQpQJdQ0DjiW yuuTRImutSzvo2JOeXO1NkaKMDNSx/kMxex3aqXTavAVTbqB/ZppWxkxJCU4Z1D4e14MCYxkXQMf t7r/eWi24Z6OeduqwovjHW/fW9Cf3GtoGrKaYk71ZgCwK3Aj8R93nuUj9Ad4JFLa6SseCsMwjN7G 6kh1LCtG/Qj0nz8VOXzS7IbuaYdWeM4zqd5gfx4ZO/1znGcWVLl1dMZxxiNpyGaHsLaan5I02jtS YrC3gBy6/u9yp4zvbCmKz1Cd0ur3UA4XBEHQ8J91iHMFyolbAvdUcIgZxH8ulyNVmRXCYyyIPPJn osz3VjMI2BxVgNuOykJ6JgNPoj/H18LldeTJMIx2Zw6kK51eFkK5HrMi3edZU88dmkH7Mlz859Ey EXkG3wuXKU15R4ZRG13Ab5An2iH99D8hJ82sxL/jjdH9bABSl9kPhaCUO/abVB5e8xqKAb49R9sF 0GDiYKQv7zMOOAuF15Qr9tTbOAAl4kJstP+jhf0xAOfc68ShXhcCh2c0WwF4gsKZoa+Qyswbjeth bTTNcHfOLft/7d15nFxVnffxz+mskBWSECABAgTZQVkVEREQdwXEfVRccHRcGfXRWR5xRsdxZhT3 eUZEUXHBZURFHUZwA0VZJcgSwhpIQiAh+770ef743sO9VV1VXd1dXVW3+/t+vc7rVlVXV9/urrr3 d8/5nd9BB4qik1Gt02ZtIJ/k+e/Ah7Lb01APx1+jg+J1qA77f1N/8Yl2GoNq2J+NAvl5g3ydJ6gM 5NPtB9BBw2ywxqED2NQabQrqRZuMPn+TCreLj01FwXk7e9yeQO//9JlYlLX7GH1BhHXemWju02uq Hv8h8HIU5L4zuz8NLQpzMsrLfTPqnDoO+DbwFLTA0Rto3MH1YjQxtVnr0EXE57OfV08P6lx7C6rW UV2zfRGafPs1VPJwtHkN+r/1oGyC18UYv9fZXTKAEMLFwNuyu0uBfVBverUXoM9OdZbDdTHGZqso tV+7uvbpu/hSREszD0Rx8ssHUC928WrpJODGwnNWoV6A59Bd6SdPBT6KZtsPNS8xAlvRKrLfAt6H TgSjbbjSZByaLPZUlIr2RnSBexEKBv4XlSy9FfXSPYZ6GFrxPuym1ovm1Pwa+C/g/cDLUCrajEH/ dc3qm4c6UFajYK7o3eiYXxx5PZLKeVHXoItf0ChUqlCymcarjP+S5j4T29H5cHY/v8c04G/RxW/1 a+xEFxsvYHQvPvhS8tz+bcA57YqlrH/Aa6l83z6jwf+yulphah/u9O9RTzsD97Nq/GEGOjHzocL3 nod6Au6hbz33Z6Lhq+IqWo+h3oGBVrIZbnNQuciLUHrMVloTuOwE7kKLQ70VDQtVn0ysHHZFvW/P RqsyXoBGmL6K5npcj4LwNXQ+YC5LWw/cgYKQL6JJea9GtaoPwJWfbHB+i95fzU4unY1KLqb35Z+q vv5CdO56mL4pKqCc8mYC9u+iY0gjB6LKbcVVV1NbgY4585r8vUayM9BIfkTn65e2K46y5qC4qvj+ /XQ//9PiegrFGOp5nf5damlnqsz55LlgyRw0MbNZd6JyPqDhwcWo13o7mtX9KdTTloxHB75XAS8i 751fiOqrfwsV3u8mE9Dkpmdk7SSUftAKa1Bq0rXA74Bb0BCfdc4u6OQ9Bw3n7VtjW8Ye4ohS2zag QGAdupBObU2N+1vQ7zoD9UymNgONIO2CegMPormJdEP1ODrGPJxt0+0l6LiRRgDNkiPQ4kk/Qued 5Hr0nnkTfdNKetBo2Kuz+6ei43PyzOz+D7PnjEFpN+8HTmiwL6uBS4HPoPdsPacA/xeVrKzuRb8B 5Qh/HwWpo90ZaCGpSejvcU6MsZk5AtZmIYSV5CNci+i/vOmX6DspfA1wYozxnhbv3pC0M3B/N+rx LtqXgQXON5EPGZ6I0mLOQQe9iajH+jz0T6o2ER303ku+8FMvcDXK9UulJrvRfuSB/PHo5NCKUlub 0EnmFpQ6cSe6qGk04e8p1P77jiYT0AFhVqFNoXKiZX/byagHbSrdLVIZdK/KtivRiM5y+k4mXUe+ QNlwmIBWxDsMTUov/i/2yNosFOQPp20of3IJ8GihLatqa4d5P6y7fBoNv88kD9LPQOeYK1DlmGrj UM/7LJTaWX0Mvhg4H9WGn4MWA6xlG1og8HJ0bquXwz4FLQj1dvqOWK9Ha45cjM4LJu9AscJY1Mlw Vozxqs7uktUTQrgVOKbw0Fx0vK77LWhu5PlVj98TY2x2TYO26HSP+3xUDL9Z16H8bVAAf0t2+xTU GzEL5QP+PbpIqDdh80Tg9ahHJF2R3YuGzC9FB65uFoD90QH3SFQf+DB0RTlxiK8d0YS/NeQB2Vb0 t+zNttVtR53HW9Va/R4dh4K/6jYx205u0Haj+1fB3Yjewxuy25uythH9P4s93qmnG/T/XUcenK/K vl7Wic/jyYP4vVBHQXWbw/D33m9CAXwK6peS9+Kn7RPDvA/WPpOBu1En0Y8Kj38c+Ad03P5Lje8b Q9/P2lFoNPkcGueUP4DOj5+gccfKs1Cv/yvpexx7GC0i9HVcraloDEohSpVJNqH0mGs6t0vWnxDC t9DFafIG4LImvvUzaK5g0VUxxoGWLx827Qzc/wqlphR9ApVvXNfky1xNvmjTq9DwXTITXQ2n2fwP oJ6PS1EwX8s4lIv4GjRxbRIKeC5Fgf99Te5Xt+hB+bnzUUCyJ0rD2BflJs5j+HshrfW2oDzX5Vl7 tHC72FajE25v7ZexGnpQUD8HTeqt1Rr1cLbKRhTUr67RVjVoTl/oTgeQ//+Ss1CP+3voO/pcNBOd 395A/VSYnShQ/wlK3XiowevNRZPUz0Pnhmp/QXOsvoN67C03DcUZaZHHjcCLY4y/6dwuWTNCCO9B MWFyCX170+v5CPBPVY99Osb4/lbs21C1M3A/F/WKV9uBUl6+jao/NAo6riRfaOkKahfWPx1Nokkp NStQT/qXaNyrNR3lN70X9dL1ooPif6AUnJFiOjqpHIgO4ml7AApQPIF1+G1F78vH62yrH3PvV+ft Qn4BvF92e89Cm0v/1TqGw0b0Hile2D2GjnUpuE+3H6f5ThJrvdOAX6F88o9njwU0UnpSoR1C/d71 G1AH2PfQ8aGemajowavQiHT1cX0LCvgvyfbJ+pqPYo5DsvvrgRfGGK/r3C5Zs0IIJ6LPS3Ifmh/V rHcDn6Pys3h2jPGKFuzekLQzcH8xquDQyHnANxp8/QfoYAQKrA+l9rBgyJ73EZQPDgqWfo56FX5O /fruu6ChxA+gdBRQbv2ns58/knszx6EJkfuT99DvX9juxcgvAbatRts6yMfWoGCpGIQ/TvenYtng TEMn+WI7GH2muqU8axq9SW056ul/pKr5YrH1Xoo6g25D+e5HAU+n8eTzbaigwFWos+reBs8dgxb9 ewPq1KpVGekPqDDD99HxyWo7Fa0Dk0ba1gHPjzFe37E9sgELIWxGMV1yLAObt/EGlIGRLnzXAE+L MT7Ymj0cnHYG7qfT98r+QlTabjrwIAqyGy3k8C3gdYX7T0MHwbo/Fg1PfpDKOp7r0IfyMqDekNdY 1FvxIfKlq+9FCz99k9E5pDiBvKcxkue8V2+bfaz6a9UXRdXvzeG+bzZcpqJe+TmF7Zyqx2bSPRfG a8iD+CXoYnMHmuxYb7uZfD5FrZa+XqZjZ0AXZLtlbTLq4EiVklLbgM4Zu6FAfA/ytMUD0TnkMPr/ /24HbkZpMKn6V6OLqB4U/L8ana9qlYxcijqrvownmzbjbWiUflx2fxGqHnNH53bJBiOE8Gs00pV8 GnXKDsTb0ZoKyQ0xxhOHum9D0c7A/Rn0TTl5DTqQ/wQdsE5GaTP1XIJqtyezUHWLZpyI8pteRWXv 153oQ3oZtVdaDMArgH8hzw9cit4AX8MVI8ysNcajnPoUzO9DXhI0lQed1bG9a52dNA7ua41m1Xru FvILhx1Vt6vvp9vjUHC9O3kwXu/2bqhTqZn0wV50rhjohddmVLv92qz9if5XIZ2B5ma9KNtW99jv RIs5/QCdc+8a4D6NVlNRgPbawmM/ijHWSsm1Eggh/F/gY4WHlqHj6EAzJ6onrH4ixvj3Q9y9QWtb 4A41hy1+hoYP/w31ij+Kyh3WK9nzRbRcNOjgNJ6B/wMmoUD8zWiGfbIWDYl8idqTUsdl3/MO8hVf t6CLjm/SuPSWmVkrTEApa3tn273I696n7d7o5NTtpUZHm+2oitpC8mD9Zpo7bzwVBeovRD3stS4m bkZzxS5HKVDWvNNQx2BKj90MfCjG+Pn632LdLoRwDH1HmZ6LLmwHYjxai+HY7P4O4NgY44Kh7eHg tDtw/ykK1Is+gXLRf4aWaL8ZTaapVQnm02gpZlCu8FAng81H+exvIl/kKKJl4b9A/drux6PhtFeT 994/gdJvLkfDmyM5F97Mut8UFMCnClOp7YbWE5hUaFPIe5m9auzQbEUret+BRnTvRL3eD9L8gnfj UJ71OeicuXeN50TUo/4jdO55aAj7PFrthhZufHPhsWuAt8UYH+jMLlkrhRCuR5O+k2+iKksDNR9d BKQ1dG6KMR4/xN0bnOFblLUvlOZSa0nm89GQ5D3Z/e/W2d1PFL6nlflmY9EB8pco4E4/4z7g/6CT Xy2TUQ/8H6n8fZahuq/PwFVazKxcdkGB4uFo1c6XoePcx4Cvog6NBWjCda3j+Who21GlnsXA7SgY eAuakDxm4H9yQH/3s7LXWlXn5+4Afo1GnmsF89a8c9Aof/rbbgLe3c6YyIYf6mAtfoY2MvjRyPOr Xuu9nfid2t3jvif6oFTnAe5Ak04XoCHE6WgRpX+tet6FwEez279FK8y12gHAW1Ev/J7ZYxHNxv8u yhusVYZrPqqK80aUo5qsQOk030ZDo+6JN7ORYjx56s4s1AnS02QbU+N2rcfGolGA8YVW7/44lMJY b2JsddvY4LEd5JPwiyfrXlpTP38PFOifhHrXn4VGQqptQIUdrkTnkmbndVltM1FKbHEF25uA18cY F3Zml2w4hRBWUDk/qFiSdaB+TR57rgcOiTE2WpG19dp9pYCC11o9Cb2ogsuZqDdjJ8rnK/pw4fn/ Pcx/mjFo4s830T+n2NNyFQrQa1219aAcqq+gdJ7i7/goWkb6RQx9hVMzM2u9faisQjYUu6BqMi9D 57dLUa5svR711O5GqaFnoAsSa41T0Ry69HfeCnyk3XGQtReaR1n8fK1CF3CDcVLVa32j7b9P238g vITGB6yLUfmdiEqSHVL4g11QeN7/DPKPPhi7ouGWn6HAPe3DZtQD/1xqVxMYg67MvkjlwSIN1/wC LfjkIU8zs+5wHSrxeHQ/zxuP5lkdjeZnvRWlE30bBefFNIz+2jpUsvGd5BMkrXX2QmlexdGTPwKH tzsGsvZDVbmKsVtEk5EH60eF1+kFjmvn79PWVJkkhLCAxgfFq1Ht1HcCD6MykY+glU2/lD3nRlTi sd1mobSe86j8He5FK79eRu1UmoCWr34+6sk/gTwXshel/vwI5dk3WmTDrExSHewZqNTelKxNRYHP 2KyNKdxOrRcdbGu1bWhCeFo1dAUapTMbig+itTpAHTPLUarKBvRenp61aVRWSGvWRjR3ahE6zi8C bkGTV51G2XpjUefYheSTCjcA/xBj/FzH9srarkZpyIh6z/80iJc7CE06T7X+fxdjfPbQ9rB5HQnc AUIIF6HAvF4Fg7tQb8YMdIB7Nkox+Ur29YEuXzscTkS1PV9O/g/cgYLwH6N8xCV1vnc6cDr6nV5O ZdrNfSif/ttowq5ZpwX0WdwTDTFOJ69zXdym27uTB+tj27B/EQXyj5EH80vQ5ye1x9uwH1Zuy8gr jA3GWtTZVN0eQaUglw11B61pp6LR7sMLj10FvD3G+FAndsg6K4RwLapamDyG0tEGU+zkC8C7Cvdf EGNsSyZIxwJ3gBDC/qh34xVNPH0RWqb5H7P7q2i8VHQ77YEms56PVslLIupN+THqTb+7zvfviv4G 56ELlGLaza3Ad7Lvf7CVO22GSgHui4KV2Sgwn111e0/yiYettj5rW8kX3tla1SL5ipQzstuDqdyx BgXwC6kM6O+jNZMNrfx+iDpStqOUmdWFlt6rG2rc3oCCgHXt32WrMgWVeHxb4bGVwAUxxss6s0vW DUIIc4HfUNnp+wSq43/7AF9uJroYT52uf44xPm3IO9mEjgbuT+5ECOeg5ZgHsipgRAFFN/WiBXT1 9teo9u64qq/fjnrSv4N6YWrZF6XivAw4jsoA5QE0o/lalEN5f6t23EaMSehCsthmFW6nhXpSa8Ui PZtQYLOKykCnv/urab6udVFKWUi/Q/XvNAvlCc9Hn6f+gvxeVAP7TpSCdyOqMrF6EPtm5XYBcBFK u5qOAnIrjzNR7nKxhPMPY4zndmh/rAuFEG5E6crJPcARDPx89GEqqx++Ksb4vSHuXr+6InBPQgif R3nszfbsvRFVfelG04AXoMm4z0cpA0mqrvN91Btfb/h0Oprc+lx0QVCdGvQYmmBzU9ZuQcGRlds4 9P6ZXmObWnFZ9mJgPpi822Q76n2obivrPL4K9WJvG8LPHG7jgHloJGx+jdYoqL+XPJC/EbgNlRq0 kevp6JgKmlv1hw7ui/UvZG0cqtrz0ex+mi/w8RjjRzqza9bNQgj/g2K05AOoktNATETZIOlCcVGM 8Skt2L2GuipwBwghHIr+eNWlIGu5By1Bu3FYd2roetBE1tPR73UyeW98BG7I2m2olv1d1B663w8F 8Gdkr1VrhGIl6pm/H6XWPIJyfZdm25XZz7ThMwEtzjWNyrzv3aruF4Px4u1atZwHazO6wGumrWnB zxtDZd77dPIJqcU2GY0O7IoOfjtRb0dq1ff7+9pqdAG8NNs201s+EeW/Ho2WlD8x29Yrv7cdrex8 DVpd+QYGN2Jg3Ws8SneZgFIfh1J5wobfBOBstEDYcehc+yga3f5CjHGgS9vbKBJCuJg8pWonmnP4 vwN8mddT2YF8fozxK/We3ApdF7gnIYTnoyHLw/p56uUotaRMM/KnoQD+Zdl2StXXd6A83AVZuwMF 9Y8WnhNQwPEs4KisHY6CoUa2kgc4S+psH0VBymiyC/ky8JPpO9myOvCcWuOxyVmrTpFqhZ0osK5O NUktfS1N0Ext/RB+5gSUhjITXSQWt8XbxQuSKdQujdpuW6gM5IstvdcX0zfwHo9Gto4EjgGehoL5 WjV/N6LP5S0ooL8FfW7LdCyyvm5B//uLgPd3eF+stjHoePNhlJrai6rR/RT4dYzxkQ7um5VICOFj aEEm0Hn0RNSL3vRLoGNGym+/L8Y4v3V7WOMHdmvgnoQQ3gn8M40non4PXfWUMdgcj3rPzwJeTOOa 7ktRL9/1KNd9AZVBQsi+/6CsHUg+6fAglPfbTFDViwLAWsHhxhptc6FtaXA/jSKEOttGX0tDoruQ 99ZOrrrd32MpMJ9UuL1r1nqa+LsMRi/Kk12L/qYrsrYS9eylv9EWKv9exSB9DUOf9DaRvjnhjbYz 6XtBORi9VP5ezW53oAuHiYNozS5YswPNNbkvawuzdid909fmoAPzMWiU7xgqV0hONgJ/Jg/mb0Yj g119nLUKv0OVJ36GUh2tO/Sg4/8JqJf9JOBgdAH+2eHu5bSRK4TwXeA12d17UMrcQEagT0OrGydn xhh/2aLd66PrA/ckhPAp4N3ULx95I5pJfgXlHr6egUYZqlutgH41CuT/RJ7j/liD154EHIomYRwO HIAm+O6VbYeSHz0SpaB7HQq0VxS2K9DfP128bChs0+112e1WfMYmU/m/mkbe619rW317sKMAEb2n HiWvl168qFhbo6ULks105mK6B/3uc7M2p9AORL3ps/t5jYeB36Mc5z8Af6FvT/os8iA+9c7Xujhe hwL4G9Hclmvp/vS+0exqlI74ezSiaZ03DjgXnQvPQuexpcDXgUtijPWKPZg1JYRwD7oQBJUNfSED O3dfT77i8ldjjG9p4e5VKE3gDk+Wj/wXdGVUr+d4Gar1/jXqV24po9noKvAZ2fY4aqfFLEEBfGoL 0AGuGdPIA8PZqCd6l8K2ulU/visKMFPqyHBdCETyntlNVPb+b6D2qMDG7LlbGrTU45teZ9Mw7X8y BgWT89CF2R7o7562xdut/luuRxWZGrVUf3oklkqchQL41I7IWr1Us3XoAjkF8zdQO/iehj6bz0K9 tk+n7/9uG5oAeTXq3b0NVy/pJj9HJ+3byIe/rf0Cugg/Hs0LOwtdKG8HLooxXtjBfbMRJoTwNHRc TyO2Z6PiIc16LVp7B+CJGOOwlSsvVeCehBCOAz6BSj/V04tWIf0Wqts50ha+GIMCjhTIPx2oN5t5 AwrAHq7aPopWBlyOelJbnZs7hjyIn5TdL7aeGo+NQQfs6pSb6vSbbjORvBd8WuH2dBQkplYsz7g3 g6uNvoU8uF5FXlO6Vm3p6ttrsu/bPIifO9IF1GN+ZFU7iL7/px2oF34BmgiXWvWqyeNQIH9K1p6J 3htFEaXq/Dlrt2VteQt+Jxu4K1CQ2A2L/I1GPagQwwnoHH8WOpYG9Bn7ZDtK7tnoE0K4EPin7O5t aCS12Rh5PIqt0mjuc2OMV7d2D6WUgXsSQjgdLeB0bBNPX46GMq5BvWZ3MvImkc2gslf+INSj28xi NTtRQLecPKB/DKWGrKQyDSK19ZQ/AAzowmIalQF3vfu1bk+l+bzqejaii8uUkvJ4g+1QJpzawE1A qWWnoPKsp6ALslqWUxnI344WXkslM1OFqRTIn4wu4mp5nHyC+u3Z9m7KOZenTC4HXoX+l0NZRdUG 7jBUF/sk9Bkbg0Y+fwL8ALg9xuj1S2zYhBBWkFfsG2ive3E11YtjjG9r9OTBKnXgnoQQLkApNAMp o7ceHaA/iALSkWosqjG6H0rJmIeC+eLKmM0G97XsQH/LYjC/rsZj69HFQc8gWhjk91W3VB+9WBs9 9eS0UrECTL1KMI+RVzxZysh+D440PSit5mR0gXwsyo2s9xnagSY83Y4qRN2DasTfh4KSg8lTa56F PqP17EDlXu+p0bppMboy+yYqdrCB1kzQtv7tj+aonUVeKGADCtYvdA67tUsI4Z+AlIY10F73c9F7 FmBZjLFRsZFBGxGBO0AI4QDgUuDZDZ62HvgMCpo2o6DyCkZez/tAjUWB/QFo8l7a7kMe4E6j/sTg kWQnCqbWkY8w1JqAWf216qXRR8Tnypq2K+pJfxp5CckjUApVPRHNSUnVbBagHMt1aPLdUwrtYLQK bKOLzDWoR/5OdIGQWqMJ69bXJcBb0P9nuKpNmUwD/g54H/n5ZRVwGfCvMUani1nbhRC2kB+7B9Lr PptCiuNwhdcjJnBPQgh/i/Lf650wbwfeBNzatp0aOSaQ91anqiWpvOJk6pdarH6s+LWx6ATZm21r tVpf24oC7GbaxgE8t5tXAbVyGYuC92NRIH84SgXor6LNBjSx/Ho0EfZ6dEE4KXu94mTaI5p4vZXk QfwilIf5IOr1L3uq23D4T7SgD+h/uLOD+zJSTQbeg1ar3C17bBXw7zHGT3Zsr8yAEMIlwFuzuzej CdLNWo/e3wCHxBgXtnLfYAQG7gAhhMPQcOdxdZ6yE/giWh65Vq3O3dFBxMys1WaST3w9Kts2Wjwt otWUr0Pzc/6EVkYuvl4K6NNrNqqQU3zdJSiAX1Ro96J0nDKX1R2KzwLvzW5PwBfzrTQXlXU+nzxg 7wW+HGN8R93vMmujEMJpaK2cZE+aH7l8nDxH/ogY4x2t3DcYoYF7EkL4O7QiVr3c95Uol+kSKg/O nyM/cJuZDbcelKJWHdDPp3a6xgo0angrqkRzE/BQ4eshe71DarRaq8BW20E+UTq15XXur272lyyJ f0dzn0DnDo9KDN0JwAUoBzhVaNqGUmL+Yzh6Jc2GIoSwiTx2PA1VJ2zGI+SL8x0dY1zQ8n0byYE7 QAhhHvB54KUNnrYSLZV8Bao6043lBs1s9JmGluA+ibxa1NQ6z12BcuT/SL4oW60KRLuhOS37onks 89AFwnw0t2WgawZsQ8fQZainPk28vTdr3TRpdgIaidibfO5A2u4BvB+N1P5j9vypuIrTYAW08uwH qFzIai1wMVrttNk1RszaKoTwMDpGArwALcrUn/EoNXcsEGOMrS58oX0b6YF7EkI4Ffg4qgTRyAb0 D7oy29Y76cxFJ9Pvt2gXzcz6kyranFRoB9Z5bi9KsfkLmrR6d3b/XhqXlJxNXoFqPxTcz0HB7hw0 bDyQ9QfWo9TD6vkmG6g90TtVo3oEBX9pcbfquTTF283e76961qmous8/Z/d3Y2BLn5v+V3+FetgP KTy+CPhcjPFLHdkrswEIISwiXxvnLFSStD9HoSIDoNKlRw3Lvo2WwD0JIZyB8uteRuOKD6Ac0DvI c0uvpe8qpE9FK2ZdjXrrR9Xf08w6bg/yIP4ZqMe40bFtO+oRT0H8fShnPq0j0F8Pcw8K7vdFgX2t Vm9UoBv0osm5i9AIwX3kFzYPAx8C0gTJmcATHdjHMpqPJvW+iTx/HZTO9a8xxh/U/C6zLhRCuAN1 kgC8krzMYyNvBL6e3f5sjPF9w7Broy9wLwohvAPNHG5mAafkAeC3KN/pNyiQPwvlyk9EQf5mlCPp SU1muTGo53NHoY32UqzDYTwqJ5ny5Q9FqSAH0FxP+SYUwKeF2B4ttCXoGPgwjSevTke987tnbbeq 29NRD3haWTnd3hW9J3bWaTtQKmNaWbnR7ertRvIgvVHe+gXARdnt2XRXqk+3GQO8CHgn8FzycqUR +DnqYR+W1SPNhlMIYQl5rvrrgW818W2/QGk1AC+NMf50WPZtNAfuSQjhONRT8FoGnt95HwrW/wA8 HzgHlSp8AB38v4snN9noMQkNjx+MhM9r+QAAFG5JREFUeuAOQour7INSLaoDx0gekFW34uPbUbrF ChRIrUBBZKqEsgSPdvVnHAre55Ov1ZBy2/dnYKv/7kDB+yLUcw9KKXkga/dT3oD3najqGDjHvZ49 UKfXX5PnAYP+998BvhFjvLcTO2bWCiGE7eiYCXAmyqpoZC+U3jcG2B5jHNfP8we/b6M9cA8h7B1j XBZCOBr1FpwLvBqdzAZjJxoaTHU/V6GJOJeRn+DMymo86kndt0Y7GOVFD8uEnH5sQkHkzaju+fXZ /VF9fBuAHnRxNb9G25/+S0vWsoE8kE/B/AOo+s1DdG8RgPPRMTuik7DfQ7mTgL8BXkHlhd6dKB2m mV5Js64XwpOnse1ohHBTP9/yQVSRCuDqGONzh2nXHLgnIYQ5McalIYS5McYlIYQTUTWHtJLoXNRj OIvBraaXhg4/iIacvcS9daMxKIDbv0abh3oVOhGYD8YqNBL2+6zdjNPXBmsKmpS6F/kk1eq2N833 2kdUSvKhrC2uur2Y/k+UrbAnmoB2JHqPLADeAHwD9bR3c65+u8xGHVpvRXO6iq4FLooxNruypFnX CyEchRbrBJ1D+itqMg4VATg4u//qGOPlw7R7DtwHI4RwADrYH4Ly409BE7KasQ0FR9cBX8u2i3Gv jrXPNPT+3Q8F4/ujC9QDs8eGOsS3GgVlK9EIVCAP9hvdnkie8zyFgaet9WcL6om/Cvhf8gOztUZA kznThd8BVdv9yJe1b8ZKlH6zrtDW17idtluy159Y2E6suj8JjQ4dSN+RhEtQb/vrUD7rMnRBMhrt gdI+Xwk8m8rOqqXowuZSp8PYSBRCeDvwX9ndj6P1gBr5JJrUDrAkxji30ZOHyoF7i4QQ9kO1ak9B w4mH0n/psWQjeW9TsS1GAdDjdO+wsnWvvcgX3Tk42x6GAqvB6EW55PeTpz0sI3+PPhZjXDLEfa4Q QtgHBYMzgRmF29X398i2AwkMlwG/RIH81Xi15OEW0HtyHvlF4z7kPfl7Zq2/al+ttgFNKnsPei+/ D/gMsBAdx0eLmeTB+qlUnr+2obVOvhZj/EX7d82sfUIIvwJOz+6eTuUqqtVOBX5FfnH7jhjj/xu+ vXPgPqxCCE8HnoYm6KUT1XzU4zlQG8gDpIdR0PRg1h5AkyIa1Wa2kakHva8OR0H54eSB+mCG+dNF ZMpJfjJIL8vqhiGEg1BAmD5z+6G/y7HUT3PrRQsWXQPciNJqlg33vlpN08iD+D3JL9J2r2ozsufu gi7YxpFXkUm14tegC7Insm317aVo7tHOws//FFqI6Sa04udINhYtkvQ24Az6Th6/C7gkxnhR9Tea jUQhhBcDP8vurkHHoK11nv5S4Kvkq1HfF2Mc7PzIpjlw75AQwjNRQJ9W7Uvl2nZt9H0N9KLSbQ9n bTX5IidrUE79mkJbnbW1uCRfGexBHpCnii2pOshAUkqKveapfvcDwEMxxhtbucPdKITwBlS+7kwq a03X8igK4G9FaTUL0N/Kx8yR7Xuo1/lXKJgdiQ4C3ozqTu9V9bVFaGHBH8YYb2v3jpl1UgjhUfLP xH+hioPVpqOqgW8qPLYBeGaMcUGN57eUA/culPXUpxSBGYXtHujqbzaaJNtsKk4jEQXvqSdqOflC LMtQT/6SbOsJtcNrAuohrk5vOYT+g8yi7ajXPAXmT25jjHe3bnfLLYRwCvA81BN/NH0DmFo2ojrg d2btrqw9hAP6keIP5Ktiv6rD+9JKuwIvB96C8taLHkYXLJfHGG9p946ZdYMQwhXA2dndXrQS6p1V TzsX+AKKxZItwCtijFcO+07iwL3UQgh7owB/32w7j8oqIIMp4dbIGvKKDytQj32x935N1XYVTt9J pqILrmIKwF7k6RzzGFjFloiCxRQ4puD8/hjjg63b7dElhHAmCuKPQ6uQ7tv4O560CQX0d5EH9Xfg iedltBj9378IvLvD+zJUY1GO7qtR0D6l8LUnULD+7RjjHzqwb2ZdI4TwdeC8wkNfp7JH/TmoKuAL qLQUOCvGeNMw7l4FB+4jWAhhPsrtrVXWb0r972ypNeQL5qRtup1691MPf1kXqhqL/q5PKbQ5KFBP bbAT7naigDwFhXcBd8cYbx7iPluTQgjPRsH80agH5giaT0/aiFIPFpMvWHR71jyC1X16UD7rWOAj wMc6uzuDMgl4MUoJeyEarU02AVeiYH1YVnU0K5sQwpfRYmLJejRn7Angr9AF/JE1vvVm4CUxxkeH fScLHLiPYiGE41FP/QyUirEbtSeB7Y6WJB9uy1Alh4VUrlYY+rnd39erb+9EJ+ct2Ta17TRexXM6 Slfag7z3/CCaX0q+nrXkv/dC1JO+DFjmcmvdKYRwCHkw/9RsO5DSgREF7zdT+b9/kMqJktZee5FP Sn478OUO7stA7IvSvl6I5m8U50ptQ+VPL48xfrsD+2ajXAghlV8tlofdhXzu3dpCK95fHWNcNIz7 NRelpP6q6kv3ALcBz6d+MZEbY4wdmbzuwN2aFkLYCwXx41EP8lSUf59qgM/PtnvWe41RbBOaK7AY 9Z4/GazFGF29ZIQIITwfBfFHot75Q2h+USLQBeQi9N64m/y9ch+a/GTD6xTgd9nts4FuXljoGOD1 qHe9upLFWlTq9MoY4zfbvWM2eoUQXoIC3gPQ8W9fhj4fbzU6fy5BqSlL0Sh9mou3PMb4SJ39ORZd kKeF4vZDwfphqENyMbqQGIgdwDExxo6sBeLA3YZFCOFQtNrsLBTcp+3Mwv30WCsm2XbSSioPKBW3 Y4x3dHDfrMOyz0KxXOfhKJ1qIAE9KL3sybkMqFfo9mzrXvrWeBeaeAb6P93VwX2ptgvwTJSzfjb5 Ko3JRpSX+x3nrFs7hRCegRYueyUake6UXnTRug51Ls5uwWvupG+M8ukY4/tb8NqD4sDdukII4XA0 vDsOBTQD2abbPeSrcfbXqPP4DpRrv6WwTbc3owNCKqm5Nsa4tPV/DRsNQgiHoXz5lGpzMINbuXYr CjAXoNSbm9Dy22WdM9JJF6PVUzehEcVOXhBNBI5Hk+JOQ5Olqy/2tqA0mB/GGC9r7+7ZaBZCeCVK z3oe6qRrJKJ88ccL7Qn6lqrehILtuYW2d/bYTOqvw9FKjwM3AH/K2ly0UnCyNMbY0RWVHbibmXWR LB+0uqU1H5rtpe9F+fJ3kFe4uROl3Wxr8S6PJHej4f0/opKQ7RJQasHxKEBPi/fVuohbjAKKnzpn ffQIIZyMLvAfijH+vInn74livJZMnAwhnIouIp+H3qeNRso3oEnQP0OdCotQUD4UY9AofSr4sGeD 2zNoHORvIb+QuIu8YMDtVC68Nw0dO4sXJq+IMf5giL/LkDhwNzMriSzt5gjylJvDUVDfbC/9DpRu Ux3Q348D+mOAVMP8SyhtZjhMRvMfjiKvVHQktSt9rUMr+f4RTYZrS51oqy+EMA+NjqXFEw9CAWMq 8rAdpS2tpXKV3upVe1ehUbExWRtbuD0GjUAfh9KjjkXrfCQb0ega6KJvd5SiMoPaAXXxQv7JFmP8 S43fb2/gUHQBezS6iDy8zuuCjhu3oWPLUlRi9Bd0dsRvDKquNBGlmE1Ex8j0P2nmIiKgtRzOLTx2 RYzx7DrPbxsH7mZmJRdCqA7mj0ABRbNDyztRNaN7UO/YosLtpYyOWvSfAlLe6luAr7XgNaegnvNj C+0p1P6/rEEpTrehC4hbagVWNrxCCH9EpYqvQWkau6MUtgNRKeViAL0TBYETULBYrF7WjrSOodqO LtwXo9/zKOpXUSlaCFwFXI0mc28crh3soIuACwr3H4oxzuvQvlRw4G5mNkKFEE4kz6F/KjoxD7S0 60bUW7cMBTSPZtu0JsNyNCF7VWv2uiPGozr7aTLbCWiuwEBNR6uSPidrR9A3gNuMhudTz+dfUO/n kkH8PGuhEMKVwEsG8C23ApejYHcaql4SUW/5CagHPs2fSrFW9fuhN2tP7kbVc7ajnOtr0XyW2ahS y/FUVnDbTL744SPka0fMQb32td6LzVoL/AYF61dlrz2SXQh8tHB/O/DMGOONndmdSg7czcxGkWxh ttRDfyga7j8YTcYcilTytFhZ6RGUmnMvOtn31v3u9hmPAuydaNgc4DXAdwrPaTZwnwqcjCaPPgdd HFUHRwtR0HUjSnfpSAk5618IYQe11+RYjC6wUpnWhainuriI2hh0UZy256IAew56v23KvnYgypke iwLt36CJ5VvQe2cWSutItcTvyL5WrQel0ixFlc229vPrTUSjcAej+RT7ojSS6oIP21Hq3KJCa+sC Qx3Ug6pK/U3V4xfEGD/Tgf2pyYG7mZmldRoOQSf2+ejEvl+2nc3Qh/63ooDgXhQMPIQCotTW1/ie HhRM1KooNSnbr7Qo2iwUME1CPZ6TCm0KCp6mU7nq7Qbgz+hCZreqn70SuA5NWHsYjTjMRWU9U9un xj6vAv4H+Dnw6xjj8oZ/FesKIYTnoQo9yS+Bf0PB80BHk4qVy8aSTyofg96DY9FI1jYU/Pcy8HS0 nux7HMO1xgTgW1TmtAP8OMZ4Vgf2py4H7mZm1q8QwhyU87s36rFLi64dioL7UP+7m7IG9YIXg/My 5AmvRRMFfwtcHWP8U2d3xwYjhPBm8nkNvwDOQr3PNvJNBX4CnFr1+AMxxgPavzuNOXA3M7MhCyEc Qr6s+bzC7YNobsJbt9uEet/vQCMG9wJ3xxgXdnSvrCVCCG9DdfxBiwl9p8HTbeSYjfL2n1r1+P3A aTHGrsvnr5XLZWZmNiD9BbAhhGehIH5/lIKT2mwq01cGYwsqnbgOpdwUt2vJV1NcS99ScM8Gzstu PwE8hnr/F6NJubcDt2W/39OzZiPPhsLtWSitpdtWJE5lI3vQvu3IHutvZGACynEfT56WEwqPj0Of wwNRSthClB420jt2j0I97fOqHr8HBe1ducCie9zNzKwrZItPTc3aBJQDvD3bVrQY4yMt/LmvA14I fMjVXUavEMJGNCci6W3QNqMFfNaSr7Bdr6VVuLdWbbcU7he/9gSaY1HtOcBrUfC+FFWVCdnrT0WB +WRUz30SuiCeSX5hvJP8AncnugDoQcH/NJR/n+q1byIvC7sQVUK6DfVEd9sFzWCcC3ydyv83aETt jG6em+LA3czMzEa9EMK7gM/T+bkVvcDv0UXrFBSMT0EVaqqlcpPtsg1Vwfld1n6PRqjKogf4Z+Af anztthhjdcpM13HgbmZmZgaEEPZB1ZXmoxSKfbM2F6WU7EQpJOPRqFCx6lG3iWhEYBV5ylgxbWxt 9pzDUY73/oP4Gb2oVOa1KJC/hsoymd3kKLQq8slVj/cCX4wxvqf9uzRwDtzNzMzM2iCEkGq4jyts d0Url+6O0lxmoQuHp2TbXVH5yB8Cl6JUmmK+ei+6oNiO0sgGle4VQtgTeBZwStaOZOCjDztQGdWf AD+mOxZrOhz4IJp0XD2382bgXWWqBuXA3czMzMz6CCG8BAXxJ6Me6+qc8P4sAK4EfoaC5Hbmx58M fAh4EX3TiZYBF8YYv9LG/WkJB+5mZmZm1q8QwrEobWg6WrRsdzQBdla2nUf9lJsNKHi/IWu3oOo1 rbI7ush4DnA66mmvthz4ZIzxsy38uW3lwN3MzMzMWiKEcADwvKydhire1LMSuBW4E1WsuR94BPWI b0fzCFIbX3V/NloA7jC0+vER1J+ouwL4txjjp4bwq3UFB+5mZmZmNiyyNRzOREH8CbR3Iu9K4FMx xk+28WcOKwfuZmZmZtYWIYQzgZNQEH8impDbCgtR+s0MNGn3yhjjf7botbuGA3czMzMz64gQwn5o 4uuR5Csrz0GrulZX4FkLLCm0pdn2phjjQ+3e905w4G5mZmZmVgKdXh3MzMzMzMya4MDdzMzMzKwE HLibmZmZmZWAA3czMzMzsxJw4G5mZmZmVgIO3M3MzMzMSsCBu5mZmZlZCThwNzMzMzMrAQfuZmZm ZmYl4MDdzMzMzKwEHLibmZmZmZWAA3czMzMzsxJw4G5mZmZmVgIO3M3MzMzMSsCBu5mZmZlZCThw NzMzMzMrAQfuZmZmZmYl4MDdzMzMzKwEHLibmZmZmZWAA3czMzMzsxJw4G5mZmZmVgIO3M3MzMzM SsCBu5mZmZlZCThwNzMzMzMrAQfuZmZmZmYl4MDdzMzMzKwEHLibmZmZmZWAA3czMzMzsxJw4G5m ZmZmVgIO3M3MzMzMSsCBu5mZmZlZCThwNzMzMzMrAQfuZmZmZmYl4MDdzMzMzKwEHLibmZmZmZWA A3czMzMzsxJw4G5mZmZmVgIO3M3MzMzMSsCBu5mZmZlZCThwNzMzMzMrAQfuZmZmZmYl4MDdzMzM zKwEHLibmZmZmZWAA3czMzMzsxJw4G5mZmZmVgIO3M3MzMzMSsCBu5mZmZlZCThwNzMzMzMrAQfu ZmZmZmYl4MDdzMzMzKwEHLibmZmZmZWAA3czMzMzsxJw4G5mZmZmVgIO3M3MzMzMSsCBu5mZmZlZ CThwNzMzMzMrAQfuZmZmZmYl4MDdzMzMzKwEHLibmZmZmZWAA3czMzMzsxJw4G5mZmZmVgIO3M3M zMzMSsCBu5mZmZlZCThwNzMzMzMrAQfuZmZmZmYl4MDdzMzMzKwEHLibmZmZmZWAA3czMzMzsxJw 4G5mZmZmVgIO3M3MzMzMSsCBu5mZmZlZCThwNzMzMzMrAQfuZmZmZmYl4MDdzMzMzKwEHLibmZmZ mZWAA3czMzMzsxJw4G5mZmZmVgIO3M3MzMzMSsCBu5mZmZlZCThwNzMzMzMrAQfuZmZmZmYl4MDd zMzMzKwEHLibmZmZmZWAA3czMzMzsxJw4G5mZmZmVgIO3M3MzMzMSsCBu5mZmZlZCThwNzMzMzMr AQfuZmZmZmYl4MDdzMzMzKwEHLibmZmZmZWAA3czMzMzsxJw4G5mZmZmVgIO3M3MzMzMSsCBu5mZ mZlZCThwNzMzMzMrgf8P35Vdc8V7V9IAAAAASUVORK5CYII= ";
  var imagenFondo = "";
  rellenoR = 255;
  rellenoG = 0;
  rellenoB = 0;
  var fin = 'round';
  var grid = 5;//Tamao de rejilla
  //var colorFondo = '#f3f0e7';//color de fondo y del borrador
  var colorFondo = '#ffffff';
  var radioPuntos = 1.5;//radio de crculos en punteado
  var densidad = 5;//factor que marca la distancia entre puntos respecto al grosor del punto en punteado2 y pincelPluma
  var espaciado = densidad * 5;//separacin entre pinceladas en pincel compuesto
  var pincel = 10;//radio del area donde se dibujan los puntos en pincel aleatorio y del borrador
  var anchopluma = 2;//en pincel pluma el ancho en el que hay trazos
  var grosorpluma = 1;//Grosor de los trazos en pincel pluma
  var canvasWidth;
  var canvasHeight;
	
	//Variables de poligono regular
  	lado=80;
	angulo = 90;
	nlados = 3;
	
	
  function init () {
    // Localiza el elemento canvas.
    canvaso = document.getElementById('imageView');
    if (!canvaso) {
      alert('Error: No puedo encontrar el elemento canvas!');
      return;
    }
   altoNuevo = canvaso.height;
   anchoNuevo = canvaso.width;
    if (!canvaso.getContext) {
      alert('Error: no canvas.getContext!');
      return;
    }

    // Toma el 2D canvas context.
    contexto = canvaso.getContext('2d');
    if (!contexto) {
      alert('Error: failed to getContext!');
      return;
    }
	
    // Crea contexto para canvas que est encima de todo
	
    canvasTop = document.getElementById('imageTop');	
    contextTop = canvasTop.getContext('2d');
    if (!contextTop) {
      alert('Error: failed to getContext!');
      return;
    }
	
	// Crea contexto para canvas que est debajo de todo
	
    canvasBot = document.getElementById('imageBot');	
    contextBot = canvasBot.getContext('2d');
    if (!contextBot) {
      alert('Error: failed to getContext!');
      return;
    }
	
	canvasWidth = canvaso.width;
	canvasHeight = canvaso.height;

	/*
	//Ponemos fondo de color
	contexto.save();
	contexto.fillStyle = colorFondo;
	contexto.fillRect(0,0, canvaso.width, canvaso.height);
	contexto.restore();
	*/

    // Aade un canvas temporal.
    var container = canvaso.parentNode;
    canvas = document.createElement('canvas');
    if (!canvas) {
    alert('Error: No puedo crar un nuevo lienzo!');
    return;
    }
    canvas.id     = 'imageTemp';
    canvas.width  = canvaso.width;
    canvas.height = canvasHeight;
	contTemp = document.getElementById('contenedor1');
    contTemp.appendChild(canvas);
    context = canvas.getContext('2d');

	//Carga imagen para patrn y lo crea.
	/* var img = new Image();
	  img.src = 'punto1.png';
      img.onload = function(){
       // create pattern
       var ptrn1 = context.createPattern(img,'repeat');
       relleno = ptrn1;
    }*/

    // Activa la herramienta por defecto.
    if (tools[tool_default]) {
      tool = new tools[tool_default]();
    }
	//Pone por defecto el cursor lpiz
	$('canvas').css("cursor","url(imagenes/cursores/cursor_lapiz.png),auto");

    // Coloca mousedown, mousemove and mouseup event listeners.
    canvas.addEventListener('mousedown', ev_canvas, false);
    canvas.addEventListener('mousemove', ev_canvas, false);
    canvas.addEventListener('mouseup',  ev_canvas, false);
	canvas.addEventListener('dblclick',  ev_canvas, false);
	canvas.addEventListener('mouseout',  ev_canvas, false);
	canvaso.addEventListener('mouseup',  ev_canvas, false);
	
	//Eventos cuando se presiona una tecla
	window.onkeydown = function(evt) {
	evt = evt || window.event;
	if (evt.keyCode === 17) {
		keyControl = true;
		}
	}
	window.onkeyup = function(evt) {
	evt = evt || window.event;
		if (evt.keyCode === 17) {
			keyControl = false;
		}else if(evt.keyCode === 90 &&(keyControl)){//Deshace al presionar Ctrl + z
		undoDraw();
		}
	}
	//Asignamos canvas a Generador de poligonos regulares
	rpGen = new RegularPolygonGenerator('imageTemp');
	
	//Evita seleccion azul
	document.onselectstart = function() {
	return false;
	}
	//Ponemos fondo color
	fondoColor();
	//Aqu ponemos una imagen de fondo si queremos
	ponerFondo(imagenEncima);
	
	//Ponemos imagen por detras del canvas
	//ponerBot();
	
	//Pone imagen por encima
	ponerRejilla();
}

	//Abre ventana para escribir texto en canvas
	$('#texto').click( function() {
		document.getElementById('text-controls').style.display = 'block';
		var textE1 = document.getElementById('text');
		//textE1.focus();
	})
	//Coloca texto al aceptar
	$('#botonTexto').click(function (){
		saveActions();
		contexto.save();
		contexto.fillStyle = '#ffffff';
		contexto.fillRect(0,523, canvaso.width, 22);//rellena con color de fondo Si fuera una imagen habra que recargarla
		contexto.restore();
		titulo = document.getElementById('text').value;
		contexto.font = "12pt Verdana";
		contexto.fillStyle = "black";
		contexto.fillText(titulo, 20, 540);
		saveLocalStorage();
		document.getElementById('text-controls').style.display = 'none';
	})
	//Cierra ventana de colocar texto
	$('#botonTexCan').click(function (){document.getElementById('text-controls').style.display = 'none'});
	
	// Controlador de evento general. Esta funcin determina la
	// posicion relativa del ratn respecto al elemento canvas.Da las coordenadas del raton dentro del canvas
	function ev_canvas (ev) {
	
	rect = canvas.getBoundingClientRect();//
	root = document.body;

        // return relative mouse position
        ev._x = Math.round((ev.pageX - rect.top - root.scrollTop)/ canvasScale);
        ev._y = Math.round((ev.pageY - rect.left - root.scrollLeft)/ canvasScale);

		// Llama al manejador del evento de la herramienta
		var func = tool[ev.type];
		if (func) {
		  func(ev);
		}
	}

	// Esta funcin dibuja #imageTemp canvas encima de #imageView, despus
	// #imageTemp se limpia. Esto se realiza cada vez que el usuario
	// completa unaa operacin de dibujo.
	function img_update () {
  		saveActions();//Guarda copia de la imagen
		contexto.drawImage(canvas, 0, 0);//copia imagen temporal en definitiva
		context.clearRect(0, 0, canvas.width, canvas.height);//Limpia la imagen temporal
		redoHistory = [];
		saveLocalStorage();

	}
	//Function guarda imagen en array para poder deshacer
	function saveActions() {
		var imgData = document.getElementById("imageView").toDataURL("image/png");
		undoHistory.push(imgData);//guarda imagen en matriz deshacer
	}
	//Guarda imagen en el cache del navegador
	function saveLocalStorage(){
		var imgData = document.getElementById("imageView").toDataURL("image/png");
		localStorage.dibujo_converse = imgData;//guarda imagen en el cache del navegador
		
	}
	
	//Funcion deshacer
	function undoDraw(){
		if(undoHistory.length > 0){
		var imgData = document.getElementById("imageView").toDataURL("image/png");
		redoHistory.push(imgData);//Guarda la imagen actual en array rehacer
		
        var undoImg = new Image();
			undoImg.onload = function(){//funcion para que le de tiempo a cargar la imagen
			contexto.clearRect(0,0, canvaso.width, canvaso.height);//necesario si no tenemos fondo
			contexto.drawImage(undoImg, 0,0);//copia imagen rescatada en canvas
			var imgData = document.getElementById("imageView").toDataURL("image/png");
			localStorage.dibujo_00 = imgData;//guarda imagen en el cache del navegador
			};
			undoImg.src = undoHistory.pop();//saca ultima imagen guardada en el array y la guarda en undoImg
        } else if(undoHistory.length == 0){
		return
		}		
	}
	
	function redoDraw(){
		if(redoHistory.length > 0){
		saveActions();
		
        var redoImg = new Image();
			redoImg.onload = function(){//funcion para que le de tiempo a cargar la imagen
			contexto.clearRect(0,0, canvaso.width, canvaso.height);//necesario si no tenemos fondo
			contexto.drawImage(redoImg, 0,0);//copia imagen rescatada en canvas
			var imgData = document.getElementById("imageView").toDataURL("image/png");
			localStorage.dibujo_00 = imgData;//guarda imagen en el cache del navegador
			};
			redoImg.src = redoHistory.pop();//saca ultima imagen guardada en el array y la guarda en redoImg
		}
	}
	
	
	//Si existe almacenada imagen de anterior trabajo en navegador la carga
	if (STORAGE){
		if (localStorage.dibujo_converse){
			if (confirm('Quieres recuperar el ltimo trabajo que se hizo con esta aplicacin?')) {
				localStorageImage = new Image();
				localStorageImage.addEventListener("load", function(event){
					localStorageImage.removeEventListener(event.type, arguments.callee, false);
					contexto.drawImage(localStorageImage,0,0);
				}, false);
				localStorageImage.src = localStorage.dibujo_converse;	
			}
		}
	}
	
	//Pone una imagen como fondo
	function ponerFondo (imagenUrl){
		var img = new Image();
		img.src = imagenUrl;
		img.onload = function(){
		contexto = canvaso.getContext('2d');
		contexto.drawImage(img,0,0,750,545);
		}
	}
	//Pone una imagen por encima del canvas de dibujo.Por ejemplo para tener una rejilla
	function ponerRejilla(){
		var imgTop = new Image();
		imgTop.src = imagenEncima;
		imgTop.onload = function(){
		contextTop.drawImage(imgTop,0,0,750,545);
		}
	}
	
	//Pone una imagen por debajo del canvas de dibujo.Por ejemplo para calcar un dibujo.No aparece en captura
	function ponerBot(){
		var imgBot = new Image();
		imgBot.src = imagenFondo;
		imgBot.onload = function(){
		contextBot.drawImage(imgBot,0,0,750,545);
		}
	}
	
	//Funcin pone fondo de color
	function fondoColor(){
	contexto.save();
	contexto.fillStyle = colorFondo;
	contexto.fillRect(0,0, canvaso.width, canvaso.height);
	contexto.restore();
	}
	//Control del boton limpiar
    $('#reset').click(function() {
        if (confirm('Se reiniciar el ejercicio y se perder la imagen actual. Ests seguro?')) {
		//canvaso.width = canvaso.width;
		undoHistory.length = 0;//vacia array con estados anteriores
		redoHistory.length = 0;
		contexto.clearRect(0,0, canvaso.width, canvaso.height);//Limpia
		init();
		}
    })

	
	//controlamos el boton guardar imagen
	$('#guardar').click (function() {
		context.save();
		context.fillStyle = colorFondo;
		context.fillRect(0,0, canvaso.width, canvaso.height);
		context.restore();
		context.drawImage(canvaso,0,0,750,545);
		context.drawImage(canvasTop,0,0,750,545);//Descomentar si se quiere que aparezca la imagen de fondo por debajo
		
		imgData = canvas.toDataURL("image/png");
			var ventana = window.open('','imagenGenerada', "toolbar=no,location=no,status=no,menubar=no,resizable=yes,scrollbars=1");
			ventana.document.write('<html><head><title>Imagen Generada</title><meta http-equiv="content-type" content="text/html; charset=iso-8859-1"><link rel="stylesheet" type="text/css" href="css/dibujo_00.css" /> ');
			ventana.document.write('</head>');
			ventana.document.write('<body style="background-color:#F4EDC8">');
			ventana.document.write('<div  style="position:absolute; top:40px; left:50%; margin-left: -375px;  width:750px; height:545px; box-shadow: -2px 2px 10px 1px #999;"><div style="position:relative"></div><div><img src="');
			ventana.document.write(imgData);
			ventana.document.write('"width="750" height="545">');
			ventana.document.write('</div><br><div style="border-width:1;border-color:#901420;border-style:dashed;border-radius:15px; margin-top: 50px;margin-left: 150px; margin-right: 150px; margin-bottom: 20px; padding-left:20px; padding-right:20px; font-family:Verdana;font-size:16px;background-color:#f3f0e7;text-align:center">');
			ventana.document.write('<br><br>Para guardar la imagen haz clic sobre ella con el botn derecho. En el men que aparece selecciona: "Guardar imagen como..."');
			ventana.document.write('<br><br><button onclick="window.close();" class="botonVentana">Cerrar Ventana</button><br><br></div><br><br></div></body>');
			ventana.document.close();
		context.clearRect(0,0, canvaso.width, canvaso.height);
	})
	
	// tools Contiene la implementacion de cada herramienta
	var tools = {};
	//Controles para saber que botn se ha seleccionado
	$('#lapiz').click(function (){
	tool = new tools['pencil']();
	$('canvas').css("cursor","url(imagenes/cursores/cursor_lapiz.png),auto");
	})
	$('#cubo_pintura').click (function (){
	tool = new tools['cubo_pintura']();
	$('canvas').css("cursor","url(imagenes/cursores/cursor_cubo.png),auto");
	})
	$('#rectangulo').click (function (){
	tool = new tools['rect']();
	$('canvas').css("cursor","crosshair");
	})
	$('#poliReg').click (function (){
	tool = new tools['poligono']();
	$('canvas').css("cursor","crosshair");
	})
	
	$('#borrar').click(function (){
	tool = new tools['borrador']();
	$('canvas').css("cursor","url(imagenes/cursores/cursor_goma.png),auto");	
	})
	$('#circulo').click(function (){
	tool = new tools['circle']();
	$('canvas').css("cursor","crosshair");
	})
	$('#linea').click(function (){
	tool = new tools['linea']();
	$('canvas').css("cursor","url(imagenes/cursores/cursor_lapiz.png),auto");
	})
	$('#poly').click(function (){
	tool = new tools['poly']();
	$('canvas').css("cursor","url(imagenes/cursores/cursor_lapiz.png),auto");
	})
	$('#punteado3').click(function (){
	tool = new tools['punteado3']();
	$('canvas').css("cursor","url(imagenes/cursores/cursor_lapiz.png),auto");	
	})
	$('#colorPicker').click(function (){
	tool = new tools['cuentagotas']();
	$('canvas').css("cursor","url(imagenes/cursores/cursor_cuenta.png),auto");	
	})
	$('#deshacer').click (function() {
	undoDraw();
	})
	$('#rehacer').click (function() {
	redoDraw();
	})

    // Coloca una imagen encima
	function ponerImg(urlImg) {
	var img = new Image();
	img.src = urlImg;
		img.onload = function(){
		context = canvas.getContext('2d');
		context.drawImage(img,0,0,canvasWidth,canvasHeight);
		img_update();
		}
	}
	// Lapiz dibujo libre.
	tools.pencil = function () {
		var tool = this;
		this.started = false;

		// This is called when you start holding down the mouse button.
		// This starts the pencil drawing.
		this.mousedown = function (ev) {
			context.lineWidth = fileteAnc;
			context.lineJoin = "round";		
			context.lineCap = fin;
			opac = opac/30;
			context.strokeStyle = rellenoAlfa;
			context.strokeStyle = 'rgba(' + rellenoR +','+ rellenoG + ',' + rellenoB + ',' + opac + ')';
			context.beginPath();
			context.moveTo(ev._x, ev._y);
			tool.started = true;
		};

		// This function is called every time you move the mouse. Obviously, it only
		// draws if the tool.started state is set to true (when you are holding down
		// the mouse button).
		this.mousemove = function (ev) {
		  if (tool.started) {
			context.lineTo(ev._x, ev._y);
			context.stroke();
		  }
		};

		
		
		// This is called when you release the mouse button.
		this.mouseup = function (ev) {
			if (tool.started) {
			tool.mousemove(ev);
			tool.started = false;
			opac = opac*30;
			img_update();
			}
		};
	};


	// Linea Pluma.
	tools.lineapluma = function () {
    var tool = this;
    this.started = false;

		this.mousedown = function (ev) {
		context.lineWidth = grosorpluma;
		context.strokeStyle = rellenoAlfa;
		context.lineCap = fin;
	    x = ev._x;
        y = ev._y;
        tool.started = true;
		};

		this.mousemove = function (ev) {
			if (tool.started) {
				for (i=0;i<densidad;i++){
				context.beginPath();
				context.moveTo(ev._x + (Math.random()*10-5)*anchopluma + Math.cos(x),ev._y+ (Math.random()*10-5)*anchopluma + Math.cos(y));
				//context.lineTo(x+Math.random()*i*4,y+Math.random()*i*4);
				context.lineTo(ev._x + (Math.random()*10-5)*anchopluma + Math.cos(x),ev._y+ (Math.random()*10-5)*anchopluma + Math.cos(y));
				context.stroke();
				context.closePath();
				x = ev._x;
				y = ev._y;
				}
			}
		};

		this.mouseup = function (ev) {
			if (tool.started) {
			tool.started = false;
			img_update();
			}
		};
	};


	// Herramienta Rectangulo.
	tools.rect = function () {
    var tool = this;
    this.started = false;

		this.mousedown = function (ev) {
		context.fillStyle = rellenoAlfa;
		context.strokeStyle = fileteCol;
		context.lineWidth = fileteAnc;
		context.lineCap = fin;
		tool.started = true;
		tool.x0 = Math.round(ev._x/grid)*grid;
		tool.y0 = Math.round(ev._y/grid)*grid;
		};

		this.mousemove = function (ev) {
			if (!tool.started) {
			return;
			}

		var x = Math.min((Math.round(ev._x/grid)*grid),  tool.x0),
		y = Math.min((Math.round(ev._y/grid)*grid),  tool.y0),
		w = Math.abs((Math.round(ev._x/grid)*grid) - tool.x0),
		h = Math.abs((Math.round(ev._y/grid)*grid) - tool.y0);

		context.clearRect(0, 0, canvas.width, canvas.height);

			if (!w || !h) {
			return;
			}
		context.fillRect(x, y, w, h);
		context.strokeRect(x, y, w, h);
		};

		this.mouseup = function (ev) {
			if (tool.started) {
				tool.mousemove(ev);
				tool.started = false;
				img_update();
			}
		};
  };

  // Herramienta Poligono Regular.
	tools.poligono = function () {
    var tool = this;
    this.started = false;

		this.mousedown = function (ev) {
		tool.started = true;
		tool.x0 = Math.round(ev._x/grid)*grid;
		tool.y0 = Math.round(ev._y/grid)*grid;
		};

		this.mousemove = function (ev) {
			if (!tool.started) {
			return;
			}
			
			xCoo = tool.x0;
			yCoo = tool.y0;
			w = Math.abs((Math.round(ev._x/grid)*grid) - tool.x0),
			h = Math.abs((Math.round(ev._y/grid)*grid) - tool.y0);
			lado = Math.sqrt(w * w + h * h);
			difX = Math.abs(Math.round(ev._x/grid)*grid - tool.x0);
			difY = Math.abs(Math.round(ev._y/grid)*grid - tool.y0);
			angulo = (Math.atan(difY/difX)*360)/(2*Math.PI);
			if(Math.abs(Math.round(ev._y/grid)*grid) < tool.y0){
				if(Math.abs(Math.round(ev._x/grid)*grid) < tool.x0){
				angulo = angulo + 180;
				}else{
				angulo = 360 - angulo;
				}
			}else{
				if(Math.abs(Math.round(ev._x/grid)*grid) < tool.x0){
				angulo = 180 - angulo;
				}else{
				angulo = angulo;
				}				
			}
			context.clearRect(0, 0, canvas.width, canvas.height);
			rpGen.clear();
			if (!lado) {
				return;
			}
			var Poligono = {
				n:nlados,
				strokeStyle:fileteCol,
				fillStyle:rellenoAlfa,
				lineWidth:fileteAnc,
				lSide:-lado,
				x:xCoo,
				y:yCoo,
				rotationAngle:angulo+360/nlados
			};
			
			rpGen.generate(Poligono);
			rpGen.draw();
			
		};
		this.mouseup = function (ev) {
			if (tool.started) {
				tool.mousemove(ev);
				tool.started = false;
				img_update();
			}
		};
	};

	$('#numLados').change(function (){nlados = $('#numLados').val()});
	
	// Cuentagotas
		tools.cuentagotas = function () {
		var tool = this;
			this.mousedown = function (ev) {
			  pixelColor = contexto.getImageData( ev._x,ev._y,1,1);
			  rellenoR = pixelColor.data[0];
			  rellenoG = pixelColor.data[1];
			  rellenoB = pixelColor.data[2];
			  alfaColor();
			  $('#paleta').css('backgroundColor', relleno);
			};

		};

	// Punteado aleatorio.
		tools.punteado3 = function () {
		var tool = this;
		this.started = false;

			this.mousedown = function (ev) {
			  context.fillStyle = rellenoAlfa;
			  tool.started = true;
			};

			this.mousemove = function (ev) {
			  if (tool.started) {
			  context.beginPath();
			  context.arc( ev._x + Math.sin(Math.random()*Math.PI*2)*Math.random()*pincel, ev._y + Math.cos(Math.random()*Math.PI*2)*Math.random()*pincel, radioPuntos, 0, Math.PI*2, true);
			  context.closePath();
			  context.fill();
			  }
			};

			this.mouseup = function (ev) {
			  if (tool.started) {
				tool.mousemove(ev);
				tool.started = false;
				img_update();
			  }
			};

		};


		//Borrador. Si hubiera imagen de fondo habra que copiarla primero cada vez que se hace imgUpdate
		//o colocarla en otro canvas por debajo
		tools.borrador = function () {
		var tool = this;
		this.started = false;

		saveActions();

			this.mousedown = function (ev) {
			  context.lineWidth = 1;
			  pincel = fileteAnc*3;
			  context.strokeStyle = 'black';
			  contexto.fillStyle = colorFondo;
			  tool.started = true;
			};

			this.mousemove = function (ev) {
			  if (tool.started) {
			  context.clearRect(0, 0, canvas.width, canvas.height);
			  context.strokeRect( ev._x-pincel/2, ev._y-pincel/2, pincel, pincel);
			  // contexto.clearRect( ev._x-pincel/2, ev._y-pincel/2, pincel, pincel);//elimina fondo
			  contexto.fillRect( ev._x-pincel/2, ev._y-pincel/2, pincel, pincel);//pinta con color de fondo
			  }
			};

			this.mouseup = function (ev) {
			  if (tool.started) {
				tool.mousemove(ev);
				tool.started = false;
				context.clearRect(0, 0, canvas.width, canvas.height);
				saveActions();
			  }
			};

		};

		// The line tool.
		tools.line = function () {
		var tool = this;
		this.started = false;

			this.mousedown = function (ev) {
			context.lineCap = 'round';
			context.lineWidth = fileteAnc;
			context.strokeStyle = fileteCol;
			context.lineCap = fin;
			tool.started = true;
			tool.x0 = ev._x;
			tool.y0 = ev._y;
			context.beginPath();
			context.moveTo(Math.round(tool.x0/grid)*grid, Math.round(tool.y0/grid)*grid);
			};

			this.mousemove = function (ev) {
			  if (!tool.started) {
				return;
			  }

			  context.clearRect(0, 0, canvas.width, canvas.height);
			  context.beginPath();
			  context.moveTo(Math.round(tool.x0/grid)*grid, Math.round(tool.y0/grid)*grid);
			  context.lineTo(Math.round(ev._x/grid)*grid,  Math.round(ev._y/grid)*grid);
			  context.stroke();
			  context.closePath();
			};

			this.mouseup = function (ev) {
			  if (tool.started) {
				tool.mousemove(ev);
				tool.started = false;
				img_update();
			  }
			};
		};


		// The circle tool.
		tools.circle = function () {
		var tool = this;
		this.started = false;

			this.mousedown = function (ev) {
			context.fillStyle = rellenoAlfa;
			context.strokeStyle = fileteCol;
			context.lineWidth = fileteAnc*1.5;
			tool.started = true;
			tool.x0 = Math.round(ev._x/grid)*grid
			tool.y0 = Math.round(ev._y/grid)*grid
			};
			this.mousemove = function (ev) {
				if (!tool.started) {
				return;
				}
				dif_x = Math.round(ev._x/grid)*grid - tool.x0;
				dif_y = Math.round(ev._y/grid)*grid - tool.y0;
				radio = Math.sqrt(dif_y*dif_y+dif_x*dif_x);
				context.clearRect(0, 0, canvas.width, canvas.height);
				context.beginPath();
				context.arc( tool.x0, tool.y0, radio, 0, Math.PI*2, true);
				context.closePath();
				context.stroke();
				context.fill();
			}
			this.mouseup = function (ev) {
				if (tool.started) {
				tool.mousemove(ev);
				tool.started = false;
				img_update();
				}
			}
		}


	// Lnea poligonal .
	tools.poly = function () {
    var tool = this;
    this.started = false;
		this.mousedown = function (ev) {
		  context.lineWidth = fileteAnc;
		  context.strokeStyle = fileteCol;
		  contexto.lineWidth = fileteAnc;
		  contexto.strokeStyle = fileteCol;
		  contexto.fillStyle = rellenoAlfa;
		  context.lineJoin = 'round';
		  if (!tool.started){
		  tool.x0 = Math.round(ev._x/grid)*grid;
		  tool.y0 = Math.round(ev._y/grid)*grid;
		  tool.x1 = Math.round(ev._x/grid)*grid;//Guarda coordenadas del
		  tool.y1 = Math.round(ev._y/grid)*grid;//comienzo del poligono
		  context.beginPath();
		  contexto.beginPath();
		  context.moveTo(tool.x0, tool.y0);
		  contexto.moveTo(tool.x0, tool.y0);
		  tool.started = true;
		  saveActions();
		  }else if ((Math.abs(tool.x1-ev._x)<(grid/2))&&(Math.abs(tool.y1-ev._y)<(grid/2))){
				contexto.closePath();
				contexto.fill();
				contexto.stroke();
				tool.started = false;
				context.clearRect(0, 0, canvas.width, canvas.height);
				saveLocalStorage();
		  }else{
		  contexto.lineTo(Math.round(ev._x/grid)*grid,  Math.round(ev._y/grid)*grid);
		  contexto.stroke();
		  //contexto.fill();//Si el relleno es transparente se van superponiendo Usar relleno solido
		  tool.x0 = ev._x;
		  tool.y0 = ev._y;
		  }

		};
		this.mousemove = function (ev){
		  if (!tool.started) {
			return;
		  }
		  context.clearRect(0, 0, canvas.width, canvas.height);
		  context.beginPath();
		  context.moveTo(Math.round(tool.x0/grid)*grid, Math.round(tool.y0/grid)*grid);
		  context.lineTo(Math.round(ev._x/grid)*grid,  Math.round(ev._y/grid)*grid);
		  context.stroke();
		};

		this.dblclick = function (ev) {
		  if (tool.started) {
			contexto.closePath();
			contexto.fill();
			contexto.stroke();
			tool.started = false;
			saveLocalStorage();
			}
		};
	};

  	// The lnea tool. Dibuja lineas rectas siguiendo una cuadrcula de grid px
    tools.linea= function () {
    var tool = this;
    this.started = false;

		this.mousedown = function (ev) {
		  context.lineWidth = fileteAnc;
		  context.strokeStyle = fileteCol;
		  context.lineCap = fin;
		  if (!tool.started){
		  tool.x0 = ev._x;
		  tool.y0 = ev._y;
		  context.beginPath();
		  context.moveTo(Math.round(tool.x0/grid)*grid, Math.round(tool.y0/grid)*grid);
		  tool.started = true;
		  }else{
		  tool.mousemove(ev);
		  img_update();
		  tool.started = false;
		  }
		};

		this.mousemove = function (ev) {
		  if (!tool.started) {
			return;
		  }
		  context.clearRect(0, 0, canvas.width, canvas.height);
		  context.beginPath();
		  context.moveTo(Math.round(tool.x0/grid)*grid, Math.round(tool.y0/grid)*grid);
		  context.lineTo(Math.round(ev._x/grid)*grid,  Math.round(ev._y/grid)*grid);
		  context.stroke();
		  context.closePath();
		};
	};


	//Cubo Pintura
	tools.cubo_pintura = function () {
    var tool = this;
    this.started = false;

		this.mousedown = function (ev) {
		curColor = { r:rellenoR, g:rellenoG, b:rellenoB};//toma color seleccionado en rgb
		saveActions();
		colorLayerData = contexto.getImageData(0, 0, canvasWidth, canvasHeight);//copia canvas a colorLayerData
		paintAt(ev._x, ev._y);
		saveLocalStorage();
		};
		floodFill = function (startX, startY, startR, startG, startB) {


				var newPos,
					x,
					y,
					pixelPos,
					reachLeft,
					reachRight,
					drawingBoundLeft = 0,
					drawingBoundTop = 0,
					drawingBoundRight = canvasWidth,
					drawingBoundBottom = canvasHeight-22;
					pixelStack = [[startX, startY]];

				while (pixelStack.length) {

					newPos = pixelStack.pop();
					x = newPos[0];
					y = newPos[1];

					// Get current pixel position
					pixelPos = (y * canvasWidth + x) * 4;

					// Go up as long as the color matches and are inside the canvas
					while (y >= drawingBoundTop && matchStartColor(pixelPos, startR, startG, startB)) {
						y -= 1;
						pixelPos -= canvasWidth * 4;
					}

					pixelPos += canvasWidth * 4;
					y += 1;
					reachLeft = false;
					reachRight = false;

					// Go down as long as the color matches and in inside the canvas
					while (y <= drawingBoundBottom && matchStartColor(pixelPos, startR, startG, startB)) {
						y += 1;

						colorPixel(pixelPos, curColor.r, curColor.g, curColor.b);

						if (x > drawingBoundLeft) {
							if (matchStartColor(pixelPos - 4, startR, startG, startB)) {
								if (!reachLeft) {
									// Add pixel to stack
									pixelStack.push([x - 1, y]);
									reachLeft = true;
								}
							} else if (reachLeft) {
								reachLeft = false;
							}
						}

						if (x < drawingBoundRight) {
							if (matchStartColor(pixelPos + 4, startR, startG, startB)) {
								if (!reachRight) {
									// Add pixel to stack
									pixelStack.push([x + 1, y]);
									reachRight = true;
								}
							} else if (reachRight) {
								reachRight = false;
							}
						}

						pixelPos += canvasWidth * 4;
					}
				}

			},


		clearCanvas = function () {
		contexto.clearRect(0, 0,canvasWidth, canvasHeight);
		}

		matchStartColor = function (pixelPos, startR, startG, startB) {

			r = colorLayerData.data[pixelPos];
			g = colorLayerData.data[pixelPos + 1];
			b = colorLayerData.data[pixelPos + 2];

			// If the current pixel matches the clicked color
			if (r === startR && g === startG && b === startB) {
				return true;
			}

			// If current pixel matches the new color
			if (r === curColor.r && g === curColor.g && b === curColor.b) {
				return false;
			}
			// If current pixel has different colour
			return false;
		}

		colorPixel = function (pixelPos, r, g, b, a) {

			colorLayerData.data[pixelPos] = r;
			colorLayerData.data[pixelPos + 1] = g;
			colorLayerData.data[pixelPos + 2] = b;
			colorLayerData.data[pixelPos + 3] = a !== undefined ? a : 255;
		};
		paintAt = function (startX, startY) {

			var pixelPos = (startY * canvasWidth + startX) * 4,
				r = colorLayerData.data[pixelPos],
				g = colorLayerData.data[pixelPos + 1],
				b = colorLayerData.data[pixelPos + 2],
				a = colorLayerData.data[pixelPos + 3];

			if (r === curColor.r && g === curColor.g && b === curColor.b) {
				// Return because trying to fill with the same color
				return;
			};

			floodFill(startX, startY, r, g, b);
			contexto.putImageData(colorLayerData, 0, 0);
		}
	}; //fin cubo pintura
	
	//Aumenta de tamao el escritorio
	document.getElementById('zoom_in').onclick = function() {
		if (canvasScale > 2) {
			return;	
		}
		canvasScale = canvasScale * scaleFactor;
		altoNuevo = Math.round(altoNuevo* scaleFactor);
		anchoNuevo = Math.round( anchoNuevo* scaleFactor);
		$('#imageView').css('height',altoNuevo);
		$('#imageView').css('width',anchoNuevo);
		$('.lienzo').css('height',altoNuevo);
		$('.lienzo').css('width',anchoNuevo);
		$('#imageTemp').css('height',altoNuevo);
		$('#imageTemp').css('width',anchoNuevo);
		$('#imageTop').css('height',altoNuevo);
		$('#imageTop').css('width',anchoNuevo);
		$('#imageBot').css('height',altoNuevo);
		$('#imageBot').css('width',anchoNuevo);
		objeto = document.getElementById('herram');
		objeto.style.height = altoNuevo +'px';
	}
	
	//Disminuye de tamao el escritorio
	document.getElementById('zoom_out').onclick = function() {
		if (canvasScale < 0.9) {
			return;	
		}
		canvasScale = canvasScale / scaleFactor;
		altoNuevo = Math.round(altoNuevo * (1 / scaleFactor));
		anchoNuevo = Math.round(anchoNuevo * (1 / scaleFactor));
		$('#imageView').css('height',altoNuevo);
		$('#imageView').css('width',anchoNuevo);
		$('.lienzo').css('height',altoNuevo);
		$('.lienzo').css('width',anchoNuevo);
		$('#imageTemp').css('height',altoNuevo);
		$('#imageTemp').css('width',anchoNuevo);
		$('#imageTop').css('height',altoNuevo);
		$('#imageTop').css('width',anchoNuevo);
		$('#imageBot').css('height',altoNuevo);
		$('#imageBot').css('width',anchoNuevo);
		objeto = document.getElementById('herram');
		objeto.style.height = altoNuevo +'px';
	}
	
	//Importa imagen desde archivo y la coloca como fondo
	formEl = document.forms[0],
	fileEl = formEl.elements[0],

	formEl.onsubmit = fileEl.onchange = uploadHandler;
//
	function uploadHandler() {
	uploadFile(fileEl.files && fileEl.files[0]);
	return false;
	}		
	$('#subirArc').click(function(){fileEl.click()});	
	
	//Sube archivo de imagen desde el ordenador
	function uploadFile(file) {
		if (file && file.type && file.type.match(/^image\/.*/)) {
			var fileReader = new FileReader();
			fileReader.onload = function(e) {
				var dataURL = e.target.result;
				var newImg = new Image();
				newImg.onload = ajustar;
				newImg.src = dataURL;
				contextBot.clearRect(0, 0, canvas.width, canvas.height);	
				function ajustar(){
					alto = newImg.height;
					ancho = newImg.width;
					altoCanvas =canvaso.height-22;
					if(ancho/alto >= canvaso.width/altoCanvas){
						yCoor = Math.floor((altoCanvas-canvaso.width*alto/ancho)/2);
						altoPNG = Math.floor(canvaso.width*alto/ancho);
						contextBot.drawImage(newImg,0,yCoor,canvaso.width,altoPNG);
						return
					}else{
						xCoor = Math.floor((canvaso.width-altoCanvas*ancho/alto)/2);
						anchoPNG = Math.floor(altoCanvas*ancho/alto);
						contextBot.drawImage(newImg,xCoor,0,anchoPNG,altoCanvas);
					}
				}
			}
		fileReader.readAsDataURL(file);
		}return
	}
	
	init();

}, false); }
