// Keep everything in anonymous function, called on window load.
if(window.addEventListener) {
window.addEventListener('load', function () {
  var canvas, context, canvaso, contexto;

  // Variables de herramientas.
  var tool;
  var flagRejilla = true;
  var undoHistory = new Array();//Matriz que guarda imagenes para el deshacer
  var redoHistory = new Array();//Matriz que guarda imagenes para el rehacer
  var tool_default = 'circle';
  var imagenEncima = "imagenes/simetria/rejilla20px.png";
  rellenoR = 255;
  rellenoG = 0;
  rellenoB = 0;
  var fin = 'round';
  var grid = 20;//Tamao de rejilla
  //var colorFondo = '#f3f0e7';//color de fondo y del borrador
  var colorFondo = '#ffffff';

  var canvasWidth;
  var canvasHeight;

  function init () {
    // Localiza el elemento canvas.
    canvaso = document.getElementById('imageView');
    if (!canvaso) {
      alert('Error: No puedo encontrar el elemento canvas!');
      return;
    }
   altoNuevo = canvaso.height;
   anchoNuevo = canvaso.width;
    if (!canvaso.getContext) {
      alert('Error: no canvas.getContext!');
      return;
    }

    // Toma el 2D canvas context.
    contexto = canvaso.getContext('2d');
    if (!contexto) {
      alert('Error: failed to getContext!');
      return;
    }
	
    // Crea contexto para canvas que est encima de todo
	
    canvasTop = document.getElementById('imageTop');	
    contextTop = canvasTop.getContext('2d');
    if (!contextTop) {
      alert('Error: failed to getContext!');
      return;
    }
	
	// Crea contexto para canvas que est debajo de todo
	
    canvasBot = document.getElementById('imageBot');	
    contextBot = canvasBot.getContext('2d');
    if (!contextBot) {
      alert('Error: failed to getContext!');
      return;
    }
	
	canvasWidth = canvaso.width;
	canvasHeight = canvaso.height;

    // Aade un canvas temporal.
    var container = canvaso.parentNode;
    canvas = document.createElement('canvas');
    if (!canvas) {
    alert('Error: No puedo crar un nuevo lienzo!');
    return;
    }
    canvas.id     = 'imageTemp';
    canvas.width  = canvaso.width;
    canvas.height = canvasHeight;
	contTemp = document.getElementById('contenedor1');
    contTemp.appendChild(canvas);
    context = canvas.getContext('2d');

    // Activa la herramienta por defecto.
    if (tools[tool_default]) {
      tool = new tools[tool_default]();
    }
	//Pone por defecto el cursor lpiz
	$('canvas').css("cursor","crosshair");

    // Coloca mousedown, mousemove and mouseup event listeners.
    canvas.addEventListener('mousedown', ev_canvas, false);
    canvas.addEventListener('mousemove', ev_canvas, false);
    canvas.addEventListener('mouseup',  ev_canvas, false);
	canvas.addEventListener('dblclick',  ev_canvas, false);
	canvas.addEventListener('mouseout',  ev_canvas, false);
	canvaso.addEventListener('mouseup',  ev_canvas, false);
	
	//Eventos cuando se presiona una tecla
	window.onkeydown = function(evt) {
	evt = evt || window.event;
	if (evt.keyCode === 17) {
		keyControl = true;
		}
	}
	window.onkeyup = function(evt) {
	evt = evt || window.event;
		if (evt.keyCode === 17) {
			keyControl = false;
		}else if(evt.keyCode === 90 &&(keyControl)){//Deshace al presionar Ctrl + z
		undoDraw();
		}
	}

	//Evita seleccion azul
	document.onselectstart = function() {
	return false;
	}
	//Ponemos fondo color
	fondoColor();
	//Pone imagen por encima
	ponerRejilla();
	
}

	//Abre ventana para escribir texto en canvas
	$('#texto').click( function() {
		document.getElementById('text-controls').style.display = 'block';
		var textE1 = document.getElementById('text');
		//textE1.focus();
	})
	//Coloca texto al aceptar
	$('#botonTexto').click(function (){
		saveActions();
		contexto.save();
		contexto.fillStyle = '#ffffff';
		contexto.fillRect(0,523, canvaso.width, 22);//rellena con color de fondo Si fuera una imagen habra que recargarla
		contexto.restore();
		titulo = document.getElementById('text').value;
		contexto.font = "12pt Verdana";
		contexto.fillStyle = "black";
		contexto.fillText(titulo, 20, 540);
		saveLocalStorage();
		document.getElementById('text-controls').style.display = 'none';
	})
	//Cierra ventana de colocar texto
	$('#botonTexCan').click(function (){document.getElementById('text-controls').style.display = 'none'});
	
	// Controlador de evento general. Esta funcin determina la
	// posicion relativa del ratn respecto al elemento canvas.Da las coordenadas del raton dentro del canvas
	function ev_canvas (ev) {
		if (ev.layerX || ev.layerX == 0) { // Firefox
		  ev._x = Math.round(ev.layerX / canvasScale);//multiplicamos por canvasScale para conpensar zoom
		  ev._y = Math.round(ev.layerY / canvasScale);
		} else if (ev.offsetX || ev.offsetX == 0) { // Opera
		  ev._x = Math.round(ev.offsetX / canvasScale);
		  ev._y = Math.round(ev.offsetY / canvasScale);
		}

		// Llama al manejador del evento de la herramienta
		var func = tool[ev.type];
		if (func) {
		  func(ev);
		}
	}

	// Esta funcin dibuja #imageTemp canvas encima de #imageView, despus
	// #imageTemp se limpia. Esto se realiza cada vez que el usuario
	// completa unaa operacin de dibujo.
	function img_update () {
  		saveActions();//Guarda copia de la imagen
		contexto.drawImage(canvas, 0, 0);//copia imagen temporal en definitiva
		context.clearRect(0, 0, canvas.width, canvas.height);//Limpia la imagen temporal
		redoHistory = [];
		saveLocalStorage();

	}
	//Function guarda imagen en array para poder deshacer
	function saveActions() {
		var imgData = document.getElementById("imageView").toDataURL("image/png");
		undoHistory.push(imgData);//guarda imagen en matriz deshacer
	}
	//Guarda imagen en el cache del navegador
	function saveLocalStorage(){
		var imgData = document.getElementById("imageView").toDataURL("image/png");
		localStorage.dibujo_circulos2 = imgData;//guarda imagen en el cache del navegador
		
	}
	
	//Funcion deshacer
	function undoDraw(){
		if(undoHistory.length > 0){
		var imgData = document.getElementById("imageView").toDataURL("image/png");
		redoHistory.push(imgData);//Guarda la imagen actual en array rehacer
		
        var undoImg = new Image();
			undoImg.onload = function(){//funcion para que le de tiempo a cargar la imagen
			contexto.clearRect(0,0, canvaso.width, canvaso.height);//necesario si no tenemos fondo
			contexto.drawImage(undoImg, 0,0);//copia imagen rescatada en canvas
			var imgData = document.getElementById("imageView").toDataURL("image/png");
			localStorage.dibujo_circulos2 = imgData;//guarda imagen en el cache del navegador
			};
			undoImg.src = undoHistory.pop();//saca ultima imagen guardada en el array y la guarda en undoImg
        } else if(undoHistory.length == 0){
		return
		}		
	}
	
	function redoDraw(){
		if(redoHistory.length > 0){
		saveActions();
		
        var redoImg = new Image();
			redoImg.onload = function(){//funcion para que le de tiempo a cargar la imagen
			contexto.clearRect(0,0, canvaso.width, canvaso.height);//necesario si no tenemos fondo
			contexto.drawImage(redoImg, 0,0);//copia imagen rescatada en canvas
			var imgData = document.getElementById("imageView").toDataURL("image/png");
			localStorage.dibujo_circulos2 = imgData;//guarda imagen en el cache del navegador
			};
			redoImg.src = redoHistory.pop();//saca ultima imagen guardada en el array y la guarda en redoImg
		}
	}
	
	
	//Si existe almacenada imagen de anterior trabajo en navegador la carga
	if (STORAGE){
		if (localStorage.dibujo_circulos2){
			if (confirm('Quieres recuperar el ltimo trabajo que se hizo con esta aplicacin?')) {
				localStorageImage = new Image();
				localStorageImage.addEventListener("load", function(event){
					localStorageImage.removeEventListener(event.type, arguments.callee, false);
					contexto.drawImage(localStorageImage,0,0);
				}, false);
				localStorageImage.src = localStorage.dibujo_circulos2;	
			}
		}
	}
	//Pone una imagen por encima del canvas de dibujo.Por ejemplo para tener una rejilla
	function ponerRejilla(){
		var imgTop = new Image();
		imgTop.src = imagenEncima;
		imgTop.onload = function(){
		contextTop.drawImage(imgTop,0,0,750,545);
		}
	}

	
	//Control del boton limpiar
    $('#reset').click(function() {
        if (confirm('Se reiniciar el ejercicio y se perder la imagen actual. Ests seguro?')) {
		//canvaso.width = canvaso.width;
		undoHistory.length = 0;//vacia array con estados anteriores
		redoHistory.length = 0;
		contexto.clearRect(0,0, canvaso.width, canvaso.height);//Limpia
		}
    })

	//controlamos el boton guardar imagen
	$('#guardar').click (function() {
		context.save();
		context.fillStyle = colorFondo;
		context.fillRect(0,0, canvaso.width, canvaso.height);
		context.restore();
		//context.drawImage(canvasBot,0,0,750,545);//Descomentar si se quiere que aparezca la imagen de fondo por debajo
		context.drawImage(canvaso,0,0,750,545);
		imgData = canvas.toDataURL("image/png");
			var ventana = window.open('','imagenGenerada', "toolbar=no,location=no,status=no,menubar=no,resizable=yes,scrollbars=1");
			ventana.document.write('<html><head><title>Imagen Generada</title><meta http-equiv="content-type" content="text/html; charset=iso-8859-1"><link rel="stylesheet" type="text/css" href="css/dibujo_00.css" /> ');
			ventana.document.write('</head>');
			ventana.document.write('<body style="background-color:#F4EDC8">');
			ventana.document.write('<div  style="position:absolute; top:40px; left:50%; margin-left: -375px;  width:750px; height:545px; box-shadow: -2px 2px 10px 1px #999;"><div style="position:relative"></div><div><img src="');
			ventana.document.write(imgData);
			ventana.document.write('"width="750" height="545">');
			ventana.document.write('</div><br><div style="border-width:1;border-color:#901420;border-style:dashed;border-radius:15px; margin-top: 50px;margin-left: 150px; margin-right: 150px; margin-bottom: 20px; padding-left:20px; padding-right:20px; font-family:Verdana;font-size:16px;background-color:#f3f0e7;text-align:center">');
			ventana.document.write('<br><br>Para guardar la imagen haz clic sobre ella con el botn derecho. En el men que aparece selecciona: "Guardar imagen como..."');
			ventana.document.write('<br><br><button onclick="window.close();" class="botonVentana">Cerrar Ventana</button><br><br></div><br><br></div></body>');
			ventana.document.close();
		context.clearRect(0,0, canvaso.width, canvaso.height);
	})
	
	//Controla boton para poner o quitar la rejilla
	$('#rejilla').click (function(){
		if(flagRejilla == false){
			ponerRejilla();
			flagRejilla = true;
		}else{
			contextTop.clearRect(0,0,750,545);
			flagRejilla = false;
		}
	})

	// tools Contiene la implementacion de cada herramienta
	var tools = {};
	//Controles para saber que botn se ha seleccionado
	$('#borrar').click(function (){
	tool = new tools['borrador']();
	$('canvas').css("cursor","url(imagenes/cursores/cursor_goma.png),auto");	
	})
	$('#cubo_pintura').click (function (){
	tool = new tools['cubo_pintura']();
	$('canvas').css("cursor","url(imagenes/cursores/cursor_cubo.png),auto");
	})
	$('#circulo').click(function (){
	tool = new tools['circle']();
	$('canvas').css("cursor","crosshair");
	})
	$('#sector').click(function (){
	tool = new tools['sector']();
	$('canvas').css("cursor","crosshair");
	})
	$('#colorPicker').click(function (){
	tool = new tools['cuentagotas']();
	$('canvas').css("cursor","url(imagenes/cursores/cursor_cuenta.png),auto");
	})
	$('#deshacer').click (function() {
	undoDraw();
	})
	$('#rehacer').click (function() {
	redoDraw();
	})
	
    // Coloca una imagen encima
	function ponerImg(urlImg) {
	var img = new Image();
	img.src = urlImg;
		img.onload = function(){
		context = canvas.getContext('2d');
		context.drawImage(img,0,0,canvasWidth,canvasHeight);
		img_update();
		}
	}
	//Funcin pone fondo de color
	function fondoColor(){
	contexto.save();
	contexto.fillStyle = colorFondo;
	contexto.fillRect(0,0, canvas.width, canvas.height);
	contexto.restore();
	}
 		// Cuentagotas
		tools.cuentagotas = function () {
		var tool = this;
			this.mousedown = function (ev) {
			  pixelColor = contexto.getImageData( ev._x,ev._y,1,1);
			  rellenoR = pixelColor.data[0];
			  rellenoG = pixelColor.data[1];
			  rellenoB = pixelColor.data[2];
			  alfaColor();
			  $('#paleta').css('backgroundColor', relleno);
			  $('#paleta').html('&nbsp');
			};

		};



		//Borrador. Si hubiera imagen de fondo habra que copiarla primero cada vez que se hace imgUpdate
		//o colocarla en otro canvas por debajo
		tools.borrador = function () {
		var tool = this;
		this.started = false;

		saveActions();

			this.mousedown = function (ev) {
			  context.lineWidth = 1;
			  pincel = fileteAnc*3;
			  context.strokeStyle = 'black';
			  contexto.fillStyle = colorFondo;
			  tool.started = true;
			};

			this.mousemove = function (ev) {
			  if (tool.started) {
			  context.clearRect(0, 0, canvas.width, canvas.height);
			  context.strokeRect( ev._x-pincel/2, ev._y-pincel/2, pincel, pincel);
			  // contexto.clearRect( ev._x-pincel/2, ev._y-pincel/2, pincel, pincel);//elimina fondo
			  contexto.fillRect( ev._x-pincel/2, ev._y-pincel/2, pincel, pincel);//pinta con color de fondo
			  }
			};

			this.mouseup = function (ev) {
			  if (tool.started) {
				tool.mousemove(ev);
				tool.started = false;
				context.clearRect(0, 0, canvas.width, canvas.height);
				saveActions();
			  }
			};

		};



		// Sector circular.
		tools.sector = function () {
		var tool = this;
		this.started = 0;

			this.mousedown = function (ev) {

				if (tool.started == 0) {
				  tool.x0 = ev._x;
				  tool.y0 = ev._y;
				  context.save();
				  context.strokeStyle = 'rgba(255,0,0,1)';
				  context.lineWidth = 1;
				  context.beginPath();
				  context.moveTo(Math.round(tool.x0/grid)*grid, Math.round(tool.y0/grid)*grid);
				  tool.started = 1;
				}
			};
			this.mousemove = function (ev) {
				if (tool.started == 0) {
				return;
				}else if (tool.started == 1) {
				  context.clearRect(0, 0, canvas.width, canvas.height);
				  context.beginPath();
				  context.moveTo(Math.round(tool.x0/grid)*grid, Math.round(tool.y0/grid)*grid);
				  context.lineTo(Math.round(ev._x/grid)*grid,  Math.round(ev._y/grid)*grid);
				  context.stroke();
				  context.closePath();
				}else if (tool.started == 2) {
				context.join = "round";
				context.fillStyle = rellenoAlfa;
				context.strokeStyle = fileteCol;
				context.lineWidth = fileteAnc;
				dif_x = Math.round(ev._x/grid)*grid - Math.round(tool.x0/grid)*grid;
				dif_y = Math.round(ev._y/grid)*grid - Math.round(tool.y0/grid)*grid;
				if(dif_x < 0){
				angFin = Math.atan(dif_y/dif_x)/Math.PI+1;
				}else{
				angFin = Math.atan(dif_y/dif_x)/Math.PI;
				}
				context.clearRect(0, 0, canvas.width, canvas.height);
				context.beginPath();
				context.moveTo(Math.round(tool.x0/grid)*grid, Math.round(tool.y0/grid)*grid);;
				context.arc( Math.round(tool.x0/grid)*grid, Math.round(tool.y0/grid)*grid, radio, Math.PI*angIni, Math.PI*angFin, true);
				context.lineTo( Math.round(tool.x0/grid)*grid, Math.round(tool.y0/grid)*grid);
				context.closePath();
				context.stroke();
				context.fill();
				}
			}
			this.mouseup = function (ev) {
				if (tool.started == 1) {
					dif_x = Math.round(ev._x/grid)*grid - Math.round(tool.x0/grid)*grid;
					dif_y = Math.round(ev._y/grid)*grid - Math.round(tool.y0/grid)*grid;
					if(dif_x < 0){
					angIni = Math.atan(dif_y/dif_x)/Math.PI+1;
					}else{
					angIni = Math.atan(dif_y/dif_x)/Math.PI;
					}
					radio = Math.sqrt(dif_y*dif_y+dif_x*dif_x);
					tool.started = 2;
				}
				else if (tool.started == 2) {
				tool.mousemove(ev);
				tool.started = 0;
				img_update();
				}
			}
		}
		
		// Sector circular.
		tools.sectorBak = function () {
		var tool = this;
		this.started = false;

			this.mousedown = function (ev) {
			context.fillStyle = rellenoAlfa;
			context.strokeStyle = fileteCol;
			context.lineWidth = fileteAnc;
			tool.started = true;
			tool.x0 = Math.round(ev._x/grid)*grid
			tool.y0 = Math.round(ev._y/grid)*grid
			};
			this.mousemove = function (ev) {
				if (!tool.started) {
				return;
				}
				dif_x = Math.round(ev._x/grid)*grid - tool.x0;
				dif_y = Math.round(ev._y/grid)*grid - tool.y0;
				if(dif_x < 0){
				angIni = Math.atan(dif_y/dif_x)/Math.PI+1;
				}else{
				angIni = Math.atan(dif_y/dif_x)/Math.PI;
				}
				angFin = angIni+0.5;
				radio = Math.sqrt(dif_y*dif_y+dif_x*dif_x);
				context.clearRect(0, 0, canvas.width, canvas.height);
				context.beginPath();
				context.moveTo( tool.x0, tool.y0);
				context.arc( tool.x0, tool.y0, radio, Math.PI*angIni, Math.PI*angFin, true);
				context.lineTo( tool.x0, tool.y0);
				context.closePath();
				context.stroke();
				context.fill();
			}
			this.mouseup = function (ev) {
				if (tool.started) {
				tool.mousemove(ev);
				tool.started = false;
				img_update();
				}
			}
		}
		
// The circle tool.
		tools.circle = function () {
		var tool = this;
		this.started = false;

			this.mousedown = function (ev) {
			context.fillStyle = rellenoAlfa;
			context.strokeStyle = fileteCol;
			context.lineWidth = fileteAnc*1.5;
			tool.started = true;
			tool.x0 = Math.round(ev._x/grid)*grid
			tool.y0 = Math.round(ev._y/grid)*grid
			};
			this.mousemove = function (ev) {
				if (!tool.started) {
				return;
				}
				dif_x = Math.round(ev._x/grid)*grid - tool.x0;
				dif_y = Math.round(ev._y/grid)*grid - tool.y0;
				radio = Math.sqrt(dif_y*dif_y+dif_x*dif_x);
				context.clearRect(0, 0, canvas.width, canvas.height);
				context.beginPath();
				context.arc( tool.x0, tool.y0, radio, 0, Math.PI*2, true);
				context.closePath();
				context.stroke();
				context.fill();
			}
			this.mouseup = function (ev) {
				if (tool.started) {
				tool.mousemove(ev);
				tool.started = false;
				img_update();
				}
			}
		}

		//Cubo Pintura
	tools.cubo_pintura = function () {
    var tool = this;
    this.started = false;

		this.mousedown = function (ev) {
		curColor = { r:rellenoR, g:rellenoG, b:rellenoB};//toma color seleccionado en rgb
		saveActions();
		colorLayerData = contexto.getImageData(0, 0, canvasWidth, canvasHeight);//copia canvas a colorLayerData
		paintAt(ev._x, ev._y);
		saveLocalStorage();
		};
		floodFill = function (startX, startY, startR, startG, startB) {


				var newPos,
					x,
					y,
					pixelPos,
					reachLeft,
					reachRight,
					drawingBoundLeft = 0,
					drawingBoundTop = 0,
					drawingBoundRight = canvasWidth,
					drawingBoundBottom = canvasHeight-22;
					pixelStack = [[startX, startY]];

				while (pixelStack.length) {

					newPos = pixelStack.pop();
					x = newPos[0];
					y = newPos[1];

					// Get current pixel position
					pixelPos = (y * canvasWidth + x) * 4;

					// Go up as long as the color matches and are inside the canvas
					while (y >= drawingBoundTop && matchStartColor(pixelPos, startR, startG, startB)) {
						y -= 1;
						pixelPos -= canvasWidth * 4;
					}

					pixelPos += canvasWidth * 4;
					y += 1;
					reachLeft = false;
					reachRight = false;

					// Go down as long as the color matches and in inside the canvas
					while (y <= drawingBoundBottom && matchStartColor(pixelPos, startR, startG, startB)) {
						y += 1;

						colorPixel(pixelPos, curColor.r, curColor.g, curColor.b);

						if (x > drawingBoundLeft) {
							if (matchStartColor(pixelPos - 4, startR, startG, startB)) {
								if (!reachLeft) {
									// Add pixel to stack
									pixelStack.push([x - 1, y]);
									reachLeft = true;
								}
							} else if (reachLeft) {
								reachLeft = false;
							}
						}

						if (x < drawingBoundRight) {
							if (matchStartColor(pixelPos + 4, startR, startG, startB)) {
								if (!reachRight) {
									// Add pixel to stack
									pixelStack.push([x + 1, y]);
									reachRight = true;
								}
							} else if (reachRight) {
								reachRight = false;
							}
						}

						pixelPos += canvasWidth * 4;
					}
				}

			},


		clearCanvas = function () {
		contexto.clearRect(0, 0,canvasWidth, canvasHeight);
		}

		matchStartColor = function (pixelPos, startR, startG, startB) {

			r = colorLayerData.data[pixelPos];
			g = colorLayerData.data[pixelPos + 1];
			b = colorLayerData.data[pixelPos + 2];

			// If the current pixel matches the clicked color
			if (r === startR && g === startG && b === startB) {
				return true;
			}

			// If current pixel matches the new color
			if (r === curColor.r && g === curColor.g && b === curColor.b) {
				return false;
			}
			// If current pixel has different colour
			return false;
		}

		colorPixel = function (pixelPos, r, g, b, a) {

			colorLayerData.data[pixelPos] = r;
			colorLayerData.data[pixelPos + 1] = g;
			colorLayerData.data[pixelPos + 2] = b;
			colorLayerData.data[pixelPos + 3] = a !== undefined ? a : 255;
		};
		paintAt = function (startX, startY) {

			var pixelPos = (startY * canvasWidth + startX) * 4,
				r = colorLayerData.data[pixelPos],
				g = colorLayerData.data[pixelPos + 1],
				b = colorLayerData.data[pixelPos + 2],
				a = colorLayerData.data[pixelPos + 3];

			if (r === curColor.r && g === curColor.g && b === curColor.b) {
				// Return because trying to fill with the same color
				return;
			};

			floodFill(startX, startY, r, g, b);
			contexto.putImageData(colorLayerData, 0, 0);
		}
	}; //fin cubo pintura
		
	//Aumenta de tamao el escritorio
	document.getElementById('zoom_in').onclick = function() {
		if (canvasScale > 2) {
			return;	
		}
		canvasScale = canvasScale * scaleFactor;
		altoNuevo = Math.round(altoNuevo* scaleFactor);
		anchoNuevo = Math.round( anchoNuevo* scaleFactor);
		$('#imageView').css('height',altoNuevo);
		$('#imageView').css('width',anchoNuevo);
		$('.lienzo').css('height',altoNuevo);
		$('.lienzo').css('width',anchoNuevo);
		$('#imageTemp').css('height',altoNuevo);
		$('#imageTemp').css('width',anchoNuevo);
		$('#imageTop').css('height',altoNuevo);
		$('#imageTop').css('width',anchoNuevo);
		$('#imageBot').css('height',altoNuevo);
		$('#imageBot').css('width',anchoNuevo);
		objeto = document.getElementById('herram');
		objeto.style.height = altoNuevo +'px';
	}
	
	//Disminuye de tamao el escritorio
	document.getElementById('zoom_out').onclick = function() {
		if (canvasScale < 0.9) {
			return;	
		}
		canvasScale = canvasScale / scaleFactor;
		altoNuevo = Math.round(altoNuevo * (1 / scaleFactor));
		anchoNuevo = Math.round(anchoNuevo * (1 / scaleFactor));
		$('#imageView').css('height',altoNuevo);
		$('#imageView').css('width',anchoNuevo);
		$('.lienzo').css('height',altoNuevo);
		$('.lienzo').css('width',anchoNuevo);
		$('#imageTemp').css('height',altoNuevo);
		$('#imageTemp').css('width',anchoNuevo);
		$('#imageTop').css('height',altoNuevo);
		$('#imageTop').css('width',anchoNuevo);
		$('#imageBot').css('height',altoNuevo);
		$('#imageBot').css('width',anchoNuevo);
		objeto = document.getElementById('herram');
		objeto.style.height = altoNuevo +'px';
	}
	init();

}, false); }
