// Keep everything in anonymous function, called on window load.
if(window.addEventListener) {
window.addEventListener('load', function () {
  var canvas, context, canvaso, contexto;

  // Variables de herramientas.
  var tool;
  var flagRejilla = true;
  var undoHistory = new Array();//Matriz que guarda imagenes para el deshacer
  var redoHistory = new Array();//Matriz que guarda imagenes para el rehacer
  var tool_default = 'pencil';
  var imagenEncima = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAvIAAAILCAYAAACKBnidAAAABHNCSVQICAgIfAhkiAAAIABJREFU eJzs3Xd0VOXWBvDnncykSygJCSHUUEJLpF1Aegm9g/SAFEFAVJQmxQaoQAARaSJ8dLDQpIcuKBBa Aigl1EAqNYX05P3+CBOjUpOZOWdmnt9ady2knHdzSXlmzz77iELOr60AIPFP8hk/5q+p49fGA7AD EREREVmrE1oAA5SugoiIiIiIXo1W/4PvFi/6xy9IKXP/xzN/TRrh1178e/P6517u7/TC60DZv/+c WYFITU3FjTu3hYuLC4iIiIjIOpw+dUr6N20GIFeQ79O3r1CsInolC76dL1NTU5Uug4iIiIgUpFG6 ACIiIiIienUa/PcGSyIiIiIiUrmcjvy/57CJiIiIiEi9OFpDRERERGSGGOSJiIiIiMwQZ+SJiIiI iMyP4Iw8EREREZGZEOLvjfEcrSEiIiIiMkMM8kREREREZogz8kREREREZogz8kREREREZoijNURE REREZohBnoiIiIjIDHFGnoiIiIjI/HCPPBERERGRuRDgHnkiIiIiIrPGIE9EREREZIZyZuQ5WkNE REREZD7YkSciIiIiMkMM8kREREREZojrJ4mIiIiIzA/XTxIRERERmQ3B9ZNERERERGaNQZ6IiIiM TkqJx48fIysrS+lSiCyGFpyRJyIiIgN5+PAhzpw6LU+dOonTp07h6pUwPHr0CAkJCcjMzIRGo0Hh woVRxNUVZcuWRdv27dC6bVtRpEgRpUsnMjta/Q84I09ERER5ER4eHrR6xUr/LZs24dq1a8/8fU5O TkhJScG9e/dw7949XL50Cbt27oSNjY2sW68e2nXogHbt2+8tUbJESxOWT2S2tC/+LURERET/JKXE rp075Yrly3Fg3/6ckRk7OztUrVYNtWrXQs1ateHr54sirq7CxcUFWq0WUkrEx8fj3r178uhvv2HH 9u04cvg3/H70KH4/ehQTx4/3r1O3rpwROAu+fn7iBWUQWTUGeSIiInolDx48wIihw2TQnj0AADt7 e3Tt1hUBAwagRs2awtbW9pl/VggBFxcXuLi4CG9vbwwYOBCJiYnYFxQkd+7YgaDde3Di+HE0b9wE w98dKSdOmiTsHRxM9VcjMivcI09EREQvLfjECdm4fgMZtGcPXFxc8Pm0qfjz8iWxYPFiUbdeveeG +GdxdnZG565dxffLlokLly+JYcPfgZQS3837Fl07dZZxcXFG+JsQmb2/98iDM/JERET0HOfPnZMd 2rRFxJ07qFGzJg79fvTcqPffF4ULFzbYGc7Ozvhq5kyx9+BBlCpVCsePHUP71m3kvXv3DHYGkTkT 3CNPREREryItLQ3Dhw5Deno6+vTti117g0SpUqX8jHVe9RrVxa69QS0rVKyIPy9cwAfvjmLHkehf GOSJiIjohWZ8+ZX8688/Ua58ecz+Zq7Q6XRGP9OjWLG9W7dv83NxccHOHTuweeNGhnmiXDgjT0RE RM+VlZWFpUuWAAC+W7QQdvb2Jjvb3cPj3NQvpwMAJk+cxHXZRLnkdOT5iUFERERPc+XyZZmYmIji Xl74X506Jl8J2a9/f1G2bFlERUbi7JkzDCxET3C0hoiIiJ7r9KlTAIA6desqVkOrNq0BAEG79yhW A5HaMMgTERHRc12+fBkAUKVqFcVqqFS5MgAgIiJCsRqI1IYz8kRERPRcbm5uAIBHDx8pVkNaWhoA IC976okslMg1I69kHURERKRWxYp5AgBiYqIVqyHpcRIAwN7BdDfaEqkR98gTERHRSyvmWQwAEBUZ pVgNISEhAIAqVasqVgOR2nC0hoiIiJ6rQoUKQqPRIDg4GImJiYrUcPzYMQBAnTp1FDmfSI3+Hq1h niciIqKncCtaFG/Ur4/UlBTs2rHT5IHhaliYjIyIQOHCheFdrpzJ118SqRVHa4iIiOiFunbvBgDY smmTyc9etnQpAKBt+/YmP5tIzRjkiYiI6IU6dOoktFotDuzfj0ePTLe9Jj4+HmtWrQYAjHh3pMnO JTIHnJEnIiKiFypSpAhatW6N1NRUzP9mnsmyw+oVK+Xjx4/RtHkz+FSqxLEaolxyrZ9kniciIqJn mzBpIjQaDRYvWoiY6GhfY5+XmZmJ75csBgCMGPmusY8jMjeCozVERET0UqpUrSq6vdkdyUnJmPHV 16HGPm/7r7/K2+G3UdHHB81aNGc3nghArjXynJEnIiKil/fx5MkxOp0Oa1atwrWrV436dv7C7xYA yJ6Nz/0QHCLKxhl5IiIiemmlS5f2GDBwIDIyMvDZlE+Mds7hQ4fkyeBguLq6okfPnkzxRE/BGXki IiJ6JWPGjfVwcHTAju3bceb0aaMEiC8++wwA8P7o0bCztzfGEURmj6M1RERE9EqKurvHDHl7KABg 6udfGPz627ZulWdPn0ExT08MGfo2u/FEz8AgT0RERK/s/Q9HC2dnZxw+eBBHjxwxWFc+MzMT076Y CgAYN2E8u/FEz8EZeSIiInplhQsXxvCR2Q9omjt7tsGuu2PbNhl25QrKli2LvgEB7MYTPQdn5ImI iChPho0YLjQaDf74/Q+kpqYa5JoH9h8AAAwYNBBardYg1ySyUNwjT0RERHlTuHBhVKlaFakpKTh9 6pRBOoK/HToEAGjYqLEhLkdkcXKvYmWQJyIiojyr36A+AODokSP5vtbt8NtBN2/ehIuLC3z9fDlW Q/QCnJEnIiKiPKv3xhsAgFMnT+b7WieDT/jrr6nRsNdI9CKckSciIqI8K1ioEAAgNSX/M/IpT+bs CxUulO9rEVkDvtwlIiKiPMvKygIAdtCJFMDPOiIiIso7/Tv6giPtRKaWMyPP0RoiIiJ6VVlZ2flB o2GQJzI1duSJiIgozx4nPQYA2Nvl/wmsWpvsvfFpaWn5vhaRpcq1fpJ75ImIiCjvbl6/AQAoXaZ0 vq/lVcILAHDr5q18X4vIGnD9JBEREeXZtWvXAABlypbN97XKli3bEgCuP7kmET0f108SERFRnulD d9my3vm+lruHx14HRwc8ePAAcXFx+b4ekaXjaA0RERHlWU5H3jv/HXkhBMqUyb7O9avX2GEkegEG eSIiIsqTlORkREVGQqvVokSJEgZZW1P2yYjO9evXDXE5IovGGXkiIiLKk+vXr0spJUqWLAmtVmuQ a5bJCfKckyd6Ec7IExERUZ6Eh4cDAEqVKW2wa5YqXSr72rfCDXZNIgvF9ZNERESUNxF37gAAihf3 Mtg1PYsXBwBERkYY7JpEliTXHnnOyBMREVHeREZEAvh7/7shFH8S5CPuMMgTvQhn5ImIiChPIiKe dOS9DNqRFwAQGcEgT/QinJEnIiKiPMnpyD/pohtCkSJFYGdvj8TERCQkJBjsukSWiKM1RERElCc5 M/IG7MgDQHFPT/312WUkeg4GeSIiIsqTyMjsjnzx4l4G2SGvp39hoO/4E9HTcUaeiIiIXtm9e/eQ mpqKwoULw8HRwaDX9iz+pCP/ZAafiJ6OM/JERET0yiLuREjA8GM1wN/rLNmRJ3ou7pEnIiKiV6ff 8+5lhCD/d0eem2uI/o175ImIiChfjHWja+5rcrSG6PlyZuQ5WkNEREQvS//ApuJehls9qef5ZGsN R2uIno8deSIiInplf4/WlDD4tYt7efGhUEQvgUGeiIiIXpkxO/KFCxeGvYMDEhIS+FAooudgkCci IqJXljMjX9xrrzGuXzxnvCaCs79Ez8AZeSIiInpl0TExEEKgmGexlsa4vkexYgCAmJgYY1yeyCKw I09ERESvJDUlBakpKXBycoJWqzXKGS4uLgCA+Ph4o1yfyAJwjzwRERG9Gn24LvAkbBtDAZcC/ziL iLL9e488Z2qIiIjopcXFxUkAKFCggNHO0F87Po5BnuhZ/u7Ic0aeiIiIXkJOR96oQV4/WhNntDOI zB1Ha4iIiOiVxD3KDtcuBY04WlOAozVEL8IgT0RERK8kLu4RACN35F04WkP0IpyRJyIiolfy92gN O/JESsrpyEsp3ZUshIiIiMxDXFz2aA1n5ImUxdEaIiIieiX6cRf9+IsxcLSG6IWEcZ7iQERWLyMj A+fOnZPnz59HdHQ0YmJiEBMTg9jYWCQnJyMtLQ1paWlIT0/P+fHTfs7GxgZ2dnaws7ODra3tC3+s /2+NRoO0tDSkpqYiNTX1mT/+93+np6dDq9XC1tYWOp0Otra2//hf7p+zs7ND4cKF4eHhAXd3d7i7 u6NcuXKoXbu2MGankkhp+o68izH3yHO0huipcu+R14Iz8kRkQJs2bZLffPMNTp8+jaSkpHxfLyMj AxkZGXj8+LEBqns56enpSE9Pz/Of12g0snLlymjXrh2mTp0qdDqdAasjUp5+3MXIM/ItAQQxyBM9 W05H/smMfIyCtRCRmfvll19kjx49IJ88l6JixYqoXbs2vLy84OHhgWLFiqFo0aI5Xe1/dbz32tra jrG1tT2X++czMzNzd859U1NTV6empvq+qMOelZX1sh38/ra2tqv1/63T6ZCRkfHvdwdmpaWljfn3 Owbp6el4+PAhIiMjERUVhcjISPz11184ffo0Lly4gAsXLiA8PFyuW7dOvOD/OiKzol8/adzRGpe9 ADvyRM/D0RoiMpgvv/wSUkpMmjQJo0ePFkWKFMn3NbVaLbRaLZycnADgHAC/fF/0BXQ6HXQ6nf5M ABj75H8vJTU1FYcOHZJdunTBhg0b8MUXX8hy5coxzJPFMMXNro6OjtBqtUhJTkZ6ejr4zhbRf/Fm VyIyiPT0dISEhECj0WDKlCkGCfHmys7ODq1atRLt2rWDlBIhISFKl0RkUKZ4sisAvPbaa/84j4j+ iXvkicggYmJiZkkp4ebmBjs7O6XLUQVPT08AQHR0tMKVEBlWrptdA415Tq4bXplViJ6Ce+SJyCCi o6PHAEDx4sWVLkU1XF1dATDIk+WJ14/WuLi89MhZXhR4shWHKyiJno6jNURkELa2tgCyt8zQP+lv /iWyBFlZWUhMTIRGo4Gzs7NRz/q7I8+HQhHp5Vo/KRjkicggypUrJ4QQCAsLY3B94uLFiwCA8uXL K1wJkeHEx8dDSglnZ+d/7LM2Bv2ees7IEz1dzoy8lNJD4VqIyIw5OjqiePHiSE5Oxp07d1YpXY8a MMiTJYqPjw8CjLt6Uu+1Ak9uduVoDdFTsSNPRAZTpUoVAMD27dsDFC5FcbGxsfjrr7+g1WpRqVIl rp4ki5GYkOAPAK+9Zvwg7+ycHeQfP040+llE5ohBnogMZvDgwQCAOXPmICsrS+FqlDV//nyZlpaG Hj16oHDhwkqXQ2Qw+qcsG3s+Hsh+py/3mUT0TwzyRGQwXbt2FWXKlMHVq1dRq1YtefDgQasblo+I iBjTv39/OX36dADARx99pHBFRIb1ODE7VDs5O73gd+af/gz9mUT0T1r8PSPP9ZNElC82NjZYunQp hgwZgrNnz6JZs2Zo3Lix7Ny5M9q1a4fy5ctb5IjJo0ePsHfvXrlz50789NNPSEpKgr29PSZNmoQa NWpY5N+ZrNfjpCcdeSfjd+T1Z3C0hujp2JEnIoNq3ry5uHjxopg6dSocHR1x+PBhjB49GhUqVECF ChXk6NGj5R9//CHNfbNNeHh40Jw5c2SjRo2km5ub7NGjB1asWIGkpCR06dIFFy9ejJk8eTJDPFkc fXfc+TXjB3l9Rz6RHXmip2KQJyKDs7e3x+TJk8WtW7fE6tWr0a9fPxQtWhRhYWH45ptvUL9+fZQs WVJ++OGHMiYmxmzeDczMzMTixYtl3bp1ZenSpf0/+ugjHDlyBEIING3aFLNmzcKff/6JTZs2idKl S3MTGFkkfXfcyQQdeaecjjyDPJFe7j3yOaM1RESG5urqin79+ol+/fpBSolTp07Jn3/+GT///DNu 3ryJuXPnYsWKFdHLly9H586dVd29Dg8PD+rcubP/2bNnAWTf6NeuXTu8+eabaNmypXjttdcUrpDI NHJm5J1MOSPP0Rqip8npyHNGnoiMSQiB2rVri5kzZ4obN26I4OBgtGnTBg8fPsSAAQNw+/ZtVe+e HzhwoP/Zs2dRokQJrF27FrGxsWLDhg2iW7duDPFkVXJm5E0xWvPkxQI78kRPx9EaIlJE7dq1xc6d O0WnTp0QHx+PJUuWqHb3/Pnz5+WBAwfg6uqKM2fOiD59+ggHBwelyyJShD5Um2K0Rr/ikje7Ej0d gzwRKWrQoEEAgKNHjypcybPpa2vTpg1cXV0VroZIWTk3u5pi/aQTb3Yleh4NOCNPRAqqX7++EEIg ODgYaWlpSpfzVEeOHAEANGzYUOFKiJSXlGTKB0I57QU4WkP0LLlm5MEZeSIyuSJFisDHxwfJyck4 ffq0KhsL+iDfoEEDhSshUl5iwpOtNSYI8oUKF2oJAA8ePDD6WUTmiKM1RKQ4fadbjeM1N2/ejL5z 5w5cXV3h4+Oj6s06RKYQHR0NACha1Pj9P2dnZxQsWBApycm4Gxtr9POIzIxgkCcixek73WoM8keO HHEHgPr16+fe3UtktW7fvg0A8CrhZZJPiBIlS+rPVeU7dkSmlvt7EWfkiUhx+iD/+++/Q21PfOV8 PNHfUlNTcTc2FvYODia78btEiRIAgPBbt0xyHpE5yb1Hnk8hJCJFlClTRnh6euL+/fu4dOmSqpK8 /l0CBnkiICIiQkop4eXlZbIzS5TMDvL6dwKI6G8crSEiVVDjnPy9e/dw8eJFODo6okaNGpyrIat3 OzwcwN/h2hRKlHgyWhPOIE/0bwzyRKQK+vEa/SiLGhw9elQCQN26daHVapUuh0hxd+7cAQB4eZku yHuVyO7+c7SG6L9yZuQlR+WJSEFqvOGVayeJ/un2LdN35MtXqAAAuHDhguruoSFSGjvyRKQKvr6+ okCBArhx4wYiIyMDlK4HAP744w8AnI8n0jt86BAAoMKTcG0KlSpXFmXKlEFkRAROnzrFJE+UC4M8 EamCRqOBr68vAODcuXOrFC4HAHDx4kUAgJ+fH+fjyepFRUYGBJ84AQdHB7Ro2dKknxMdO3cGAGze tMmUxxKpHffIE5F6+Pj4AAAuX76scCVAdHS0b1xcHAoVKgQ3NzelyyFS3K9bf10lpUTLVq3h6Oho 0rM7d+0KANi6eQvHa8jqPXWPvJTS+I9oIyJ6jooVKwJQR5C/fPlyKPB3TUTWbuvmzQCALl27mPxs v9f9csZr1q1ZwyRP9AQ78kSkGvqO/JUrVxSuBLh06RIABnkiAFi9cqU8fuwYnJyc0LJVK0VGzUaP +QgAMGb0hzh7+gzDPBEY5IlIRVTWkQfAIE906MBB+dEHowEAc7/9FvYODorU0a9/fzFk6FCkpqYi oG9fxERH+ypSCJGKMMgTkWqULVtW2NraIiIiAo8fP1a0FgZ5IiA0JFS+FRCAjIwMjBk3Dt17vKno jd9fzvhaNG7SBJEREWjfpm1obEwMx4LJqnFGnohUw8bGBt7e3pBSIiwsTNG3zhnkydqdPX1Gdm7f HvHx8ejUpQs+njxJ8e1NWq0W/7d6lajm64trV6+ic4eO0ffv31e6LCLFsCNPRKqihs01qampuHnz JmxsbFCuXDnFwwuRqZ06eVJ26dgRcXFx6NCxI75f9oPIvSlDSQULFsSmX7eKSpUr49LFi+jasZN8 9OiR0mURKYJBnohURQ1z8levXpWZmZkoVaoU7OzsFKuDSAnHjx2TXTt2Qnx8PLp2745lK1cInU6n dFn/UKRIEWzZ9qsoX6ECzp87h26dO8vkpGSlyyIyiVwvqkXOaA0RkRqooSPPsRqyVndjYxHQuw8S ExPRs3cvLPlhqdBqtUqX9VRuRYti6/ZtLcuUKYOzp8/g0ylTmGfI6uR05DkjT0RqoA/PSq6g1K+e 1L+oILIWo0aMlPfv30ebtm2xYPFiYWNjo3RJz+VRrNje5atWQafTYdnSpTh04CDDPFkVjtYQkar4 +PgIgB15IlNbtWKFDNqzB66urpi34Duh0ZhHRPB73U+MnTAeUkq8O2IE4uLilC6JyGTM47OUiKxG wYIFUbRoUSQkJCAqKspfiRoY5Mna3LhxQ06a8DEAYM638+Dq6qpwRa9m9EcfiZq1aiEyIgITx49n V56sBmfkiUh19AH66tWrQUqcHxYWBgCoUKFCfyXOJzK1zyZPwePHj9Gzdy+079BBHetpXoGNjQ0W /7AUdnZ2+HH9Bty8eTNa6ZqITCH3jLySdRAR5fDy8gIAREZGmvzs1NRUPHjwADY2NvDw8Fht8gKI TOzWrVuhO7Zvh62tLT774gs/pevJK29vb9H9zTeRlZWFRd99x/v+yCpwtIaIVKdYsWIAlAnyUVFR 0QDg4eEBc5kRJsqP7xct8s3KykLX7t3g7uFxTul68mPke6MAAGtXr8HDhw8VrobI+PhdiohURx/k o6KiTH52dHS0e+4aiCxZYmIi1qzKfuNp+MiRCleTfz6VKonm/i2QlJSE5T/8wFEDskxP2yPP0Roi Ugslg7z+TE9PT5OfTWRqG9atkwkJCWjYqBGq+fqa3Wz804wY+S4AYP2atQpXQmR87MgTkeooPFrz jxqILNnhg4cAAL379lW2EANq0KihcHB0wPXr1xETHe2rdD1ExsQgT0Sqw448kWmcOH4cAPBGg/p7 FS7FYHQ6Hf5Xpy4A4PixY6EKl0NkVAzyRKQ6xYoVE4CyQZ4debJ0165dk/fu3YNHsWIoWbJkS6Xr MaT6DeoDAI4fO6ZwJUTG9fceec7IE5FKFCxYEPb29nj06BGSk5NNejY78mQt9N34uvXqKVyJ4dVv 0AAAgzxZPnbkiUiVPDw8AABRUVEm7TJER2c/R4YdebJ0oWfPAgBq166tcCWGV9HHRwDArZu3lC6F yKgY5IlIlZSak881WmNRowZE/xYXFwcAKFykiMKVGN5rr70GIHu9JpElY5AnIlVSYnNNVlYWYmNj YWNjA3d3d4u5+Y/oaR4nPgYAODk7KVyJ4el0Otg7OCAjIwMpJh7PIzI2wT3yRKR2SnTkY2NjfTMz M1G0aFE+1ZUs3uOk7CDv7OSscCXGoe/KJ7ArTxaM36mISJWUCPJRUVGhAG90JetgyR15AHB2yv57 PX78OFrhUoiMhkGeiFRJidEa3uhK1iQjIx3AP96mtygPHjwAABQpUsRD4VKIjIZBnohUSaGOPAB2 5Mk6eHoWBwDcDg9XuBLDi4+PR1xcHAoUKJAzYkNkiTgjT0Sq5ObmBgC4f/++yc7Un+Xi4mKyM4mU UrJ0KQBAuAUG+fBbtyQAlChZUulSiIyKHXkiUqUCBQoAyO6smYr+LHbwyBqULJkd5C1x17r+xYmX l5fClRAZF4M8EamSi4uLB/D3rmtT0J+lfxFBZMlK5XTkLS/I37x+AwA78mT5ckZriIjUpECBAjGA Mh15jtaQNajo4wMACD0bgszMTIWrMayjR44AAF6vUV3hSogM79975AFwRp6I1MXBwQFarRapqalI S0szyZn6IM+OPFmDMmXKiAoVK+L+/fs4GRxsMSEgLS0Nvx0+DCEEWrRowY01ZNE4WkNEqmXqOXkG ebI2bdq2BQDs2rFT4UoM59gff8ikpCRU8/VFUXf3GKXrITImBnkiUi39iEt8fLxJuoUM8mRt2rR7 EuR3Wk6Q379vHwCghb+/wpUQGR9n5IlItfSB2lQ3vPJmV7I2tWrXFm5ubrgaFoawK1csIg8E7d4D AGjRkkGeLB9n5IlItZQarXFxcWlpkgOJFKbRaNCuQwcAwKIFCxWuJv+OHjkir1y+DFdXV9SqXdsy H1lLlAtHa4hItXKN1pjkvFyjNXtNciCRCrz7/nuwsbHB2tWrcTv8dpDS9eTHkoWLAACDhgyBVqtV uBoi42OQJyLVMmVHPiMjA0lJSbCxsYGTk5PRzyNSi7Jly4oevXoiPT0ds2fNMtt5lJs3b0bv2rkT tra2GDRkMLfVkDUQOTPyHK0hIrUxZZBPSEgAwKe6knX6aNw42NjYYP3atQgPDzfLrvzSJUvcs7Ky 0LV7N26rIYsmhMj5+GZHnohUy5Q3u8bFxUUDfBgUWafcXfnAGTPNriv/+PFjrFm5CgDwzogRCldD ZDoM8kSkWqackY+Pj3cHuLGGrNeY8eOh1WqxYd063Lp1K1Tpel7FLz/9JBMSElDvjTfg6+fHm1zJ ajDIE5FqmXK0hjvkydqVKVNG9OzVCxkZGQj8eoav0vW8imVLfwCQfZMrkTXhjDwRqRaDPJFpfTR+ XIxWq8WPGzbgxo0bZhEMgk+ckBfOn4ebmxs6dOrIbjxZFXbkiUi19Dee6m9ENSbe7EoElC5d2qNX nz7IyMjAou8WKF3OS1n+Q3Y3PmDAANja2ipcDZFpMcgTkWrpvymnp6cb/Sz9GQwCZO2GDX8HALB1 82ZkZmYqXM3z3b9/H1s3b4GNjQ3eGjRotdL1EJkagzwRqZb+gS4ZGRlGP0t/Bh8iQ9auStWqonyF Crh79y6O/vabqsdr1qxaJVNTU9GyVSt4lfDqr3Q9RKaQa/0k98gTkXrpQ7UpO/IM8kRA1+7dAAAb f9mocCXPlpWVhRXLlgMABr/9tsLVECmDHXkiUi2dTgfAtB15/ZlE1qxT584AgH179ypcybPt37tP 3rp1C2XLlkXT5s14kytZJQZ5IlItduSJlFHRx0cUKFAA0VFRiI2JcVe6nqf5ccMGAMDAwYMhBHM8 Waec0RoiIrVhR55IGUII+Pr5AQBCQ0KjFS7nqYJPHAcAtG7bRuFKiJST05HnjDwRqQ1vdiVSjl/1 1wEAISFnFa7kv2JjYtzv3L6DggULoqy3N9vxZLU4WkNEqsXRGiLleHt7AwAiIyIVruS/Tp06FQ0A NWvX4lgNWTUGeSJSLY7WECkn5/PPBC+kX9Wd23cAAGXLllW4EiJlcUaeiFSLozVEytFqnwT5TON/ /r2q5OQkAICjo5PClRCZ3r/3yAPgjDwRqY9OpzsHmHa0hh15omwaTXb/t5GqAAAgAElEQVREMMUL 6VeV9Dg7yDs5M8iTdeNoDRGpllarXQ2wI0+khKthYQCAUqVKK1vIU+gD/L27dxWuhEhZDPJEpFr6 IM+bXYlM78yZ0wCA6jVrKFzJf/n6Zq/GDDkbonAlRMrKmZHnaA0RqY1Op4sBeLMrkRJCzmSvnaxR o0Z/hUv5j2p+vgIAzp8/h7S0NKXLIVIMO/JEpFq82ZVIGbt37ZL3799HMU9PFPP0XK10Pf9WpEgR VPP1RXJSMtavXctOJFktBnkiUi19d5w3uxKZTlpaGiZP+BgAMPqjDxWu5tk++HA0AGBu4GxV3pBL ZAoM8kSkWllZWQD+3p5hTPqHynDMkKzdN3PmyOvXr6NylSoYOHiwap+21KlLF+Ht7Y3w8HB89skn /MQlq8QZeSJSLf3sq62trdHP0p/BeVuyVpmZmZg8caL8evqXAICvZ82EjY2NwlU9m0ajwaKl38PO zg4L53+H9WvXMciQVRDIeX0t2JEnItVKS0tzBxjkiYztwYMH6N6lq1w4/zvY2tpi/sIFaNCwoWq7 8Xq1atcWgXPnAAA+GDUKK5YvZ5gnq8IgT0SqlZaWNgswTZA35Tw+kZps3rhRNmnQQB4+eBBubm7Y umM7+gYEqD7E6/UNCBBjxo1Deno6Pnz/A4z7aIzkzDxZCwZ5IlKttLS0AIAdeSJjOBkcLFs1byEH vzUQd27fQfUa1bH/8OHVderWNZsQrzdxymSxYPFi2Nra4ofvv0fj+g3k0SNH2J0ni5drRl7hSoiI /sWUM/L6jjyDPFm6W7duhQ4a8JZs1bwFTgYHw93DA98u+A57Dx4UXiW8VLcz/mX17ttHbN2xHd7e 3rj411/o2LYdBr81UEZGRIxRujYiY2FHnohUKzU1FYBpO/IcrTEv0VFR/sf++ENu27pVRkVGBihd j5olJCTg08lTZJ0aNX23bNoEB0cHjB0/HqdDQ0S//v2FKbZDGVudunXF78EnxJTPPoWjoyM2b9yI /9WoOWtOYKDUfz0hsiTm/1lLRBaLW2voaWKio33nzp4tmzVqJCtXqBjUrlVrDOgXgKo+lVa1at5C Lvh2vgwPDw9Suk61kFJi7Zo1stbr1eX8efOQnp6OXn164+SZM2M/njxJODo6Kl2iQdna2mL0Rx+J 4DOnx3bu2hVJSUmY9vkXqFOjppwTGMgXfGRRGOSJSLWUGK1hR169wq5cke+NfFe+XrVa6NTPPkfI 2RA4OzujQcOGaO7fAvYO9jgZHIwpkybh9SpV/Zs1aiTXrl5t1Z3Y06dOyRZNmshRw0fgbmws6tar h32HDmHhkiXCs3jxQKXrMybP4sUDl69cIbbu2I6KPj4IDw/HtM+/QLVKlVe92bWr3Lp5s+QLdzJ3 3CNPRKql/yZrZ2dn9LPYkVevE8ePy369esu6tWpjzapVSEtLQ6vWrbFmw3qE3bguft25Q/y8aZO4 dvOmWL1+HXr27gUXFxeEnA3BqBEj4Vu5ipw1Y4Z89OiR0n8Vk1q8cJFs498SZ8+cRcmSJfF/q1Zi Z9AeUb1GdbO7mTU/GjZqJI4ePyZ+/OUXdOjYETY2Nti/dx8G9h8A38pVZODMmfLBgwdKl0n00oQQ 0fofsiNPRKrFm12tW/CJE7J1C3/Zxr8ldu7YAVtbW/Tr3x/HTgZj/c8/ibbt2gk7e/uc32/v4IB2 7duLRd9/L67cuC6Wr1yB6jVr4G5sLL6aNh31av9PBu3ZY/Fdq5TkZAwbMkROHD8eGRkZGPX++zhx 5rTo1KWLVQX43GxsbODfqqVYuXaNuHD5kpg6fToq+vggNiYGX06dhgZ168krly9b/McGWR4GeSJS LSVm5Dlaow5Xw8Jkj67dEHziBAoWLIgPx4xB6J8XPL5d8J2oULHiCwOpTqdD565dxf5Dh8T23btQ s1YtxERHo1f3N7FqxQqLDWwPHz5Eqxb+8ucff4KDowOWrfg/fD5tqjDFu1rmws3NDSPfGyWOnQwW W3dsx//q1EF0VBTatWqNC+fPW+zHBlmmnNEaIiK14c2u1mvkO8MRHx+P1m3a4Pyli2Lyp5+Iou7u MXm51hv164s9+/eJiVMmAwAmfzwRlriSMDMzE4PfekueP3cOJUuWxJ59+9ClWzer7cK/jIaNGomt 27cJ/1Ytcf/+fQwZOIgv5sms5HTkOSNPRGrD0RrrlJGRgdCQEADAd4sXCScnp3xfU6PRYMy4caJF S38kJiZi544ds/J9UZX5/NNP5aED2U9n3b579+qq1aoxxL8EO3t7rFqzRnh7e+PK5ctYtGABAxGZ DY7WEJFqcY+8dYqMjAxKS0tDkSJFULhwYYNeu36DBgCAGzduGPS6Stu+bZv8bt630Ol0WLFmNcz5 wU5KsLO3R+A3cwEAM7/6Grz5lcwFgzwRqRZHa6yTp6dnSzt7ezx48ABhV64YrDuanp6Oq1fCAGTf /GhJ5szKfoPhi+nTUe+NN9iJz4PGTZqIRo0bIykpCVs3b2ZXnsyCFvoZeY7WEJHKxMXFAQBcXFyM flaBAgX+cSYpR6vVolq1ajh18iTq1KwFZ2dnWalyZVSqXBmt2rRGm7ZtXxhUDx04KIODT+Bu7F3E xsYi4s4d/Pnnn0hNSQEA9OzVy+h/D1M5c/q0DDkbAjc3NwwcPIghPh969u6N3w4fxs8//oSBgwcr XQ7RC2mVLoCI6FkePnwIAAYfr3ga/Rl8S10dBgx8CxqNBlfDwvDgwQOcDA7GyeBgrF29Gr9s2Swb N2ny3MC6bOlS7Ni+/T8/7+3tjRYt/VGlalWLCbw/fP89AKBvQIBJ3r2yZB07dxJjPhwtTxw/jtvh t4NKlCzRUumaiP5NCOhv/OceeSJSL32oNlGQF7nPJGX1DQgQu/ftFVdv3RRhN2+IX3fuQN+AAGRm ZmJQ/wGIj49/7p9PTkkGAAwaMgTfL1uGrTu24+qtm+JkyFnx1cyZFhPi79+/j80bN0Gj0WDAoIHn lK7H3Dk5OaF9hw6QUmLd2jX+StdD9CIM8kSkWqbsyBcqVOgfZ5J6FClSBA0aNhTzvpsvKvr44OHD h7j411/PnQdNSc4eoenavRu693hTNGzUSJji48jUVq1YIVNTU+HfsiVKlSrlp3Q9liBgwAAAwNrV q5GVlaVwNUTPl7NHXnKdPBGpjL47rg/ZxqTT6eDs7IyMjAzOyauURqOBr58vACDsypXn/l59R97B 3sHodSklMzMTy39YBgB4e9gwhauxHA0aNhTe3t64c/sO9u/dx3BEqsaOPBGplik78rnPefDgAb95 q1S58uUBAGFPts88i74jb+9gb/SalDLr6xky4s4deHt7o2nzZhYzLqQG/QZkb+/8aPQHHLcjVWOQ JyLVyjUjb5LZX97wqn76d2dSnnTcnyUlOfvX7R0ssyO/betWOWvGDNjY2CBw7hwIwRxvSMNHjhQ1 atbEndt3MHTwYMkRG1IrBnkiUq1cHXmTzP4yyKtfakr2Q8Ls7J/faU9+smbSwd7e4raOhIaEyuFD h0FKiWlffYXGTZsyxRuYra0tVq1dM9bNzQ0H9u3HlIkTGeZJlf6ekeceeSJSkczMTMTHx0On0+G1 114zyZkM8uqXkvpkZMbu+UFevy/ezt5+r9GLMqGNP/8i27VqhaSkJPTr3x/Dhr/DEG8knsWLBy5b uQJarRaLFixEt06d5d3YWKXLIoIQgusniUjdHj16BCmlSW501WOQVz99R97W7uX2pVtKkyo9PR0f jxsn3x40CElJSegbEIDAuXMY4o2sQcOG4pctm1HU3R2HDx1Cg3pvyMOHDlnGBxVZBAZ5IlIl/Q2n plwZyCCvfvptNC/qyGu12c87zMzIMHpNxnbl8mXZoU1buWTRYtjZ2WHut/Mwf+ECwYc/mUajxo3F kWN/iCbNmuJubCy6deqMke+8I8PDw4OUro2IQZ6IVMnUG2tyn8Ugr14x0dEAgEJFnv9xYfMkyGdk ZAQYvSgjefjwISaMHSsb1K2H4BMnUNzLCzv37MGAgQPZiTcxNzc3bNyyRUz+9BNoNBqsX7sO/6te w3/C2LEctyFFcUaeiFTJlE911WOQV78rl7P3x5d/sobyWbRaGwBARkam2QX5jIwMfL94iazl97r8 fvESSCkx+O238dsfv4vqNWswxCtECIEPx4wRJ86cRo9ePfX/TqhezVdO+/wL+aKnDRMZAzvyRKRK +o68KWfk9WcxyKuTlBJhYdlBvlz58s8NtFqbJx35zAx/41dmGFJKbNm0SdavU1dOGDsWDx8+RLMW zXH0+DHMmjNbmPJzgZ6tTJkyYvHSpeLo8WPo0LEjkpKSMCcwEH6Vq8jpX0yV9+7dU7pEsiIM8kSk ShEREQAADw8Pk52pP0t/NqnLndt3gpKTklGkSJEXvlOjH61JT0szRWn5IqXE9m3bZMN6b8hBA95C 2JUrKF+hAn7auBG/bN4sKvr4sAuvQj6VKomVa9eI/YcPo1mL5oiLi8PsWbPgW7mKHD9mjLwdfpsz 9GR0DPJEpErXrl0DAHh7e5vsTG9vb4/cZ5O6XL50yR8Ayleo8MLfW7JUSQDAmdNnjFtUPu3etUs2 bdhI9u/TF3/9+Se8Snjhm/nf4vcTx0WLlv4M8Gageo3q4pfNm8X+w4fRoWNHpKWmYumS71HTz89/ xLBh8vKlS5xdJqPhjDwRqZISQd7d3T3G2dkZjx494niNymRmZmL2rFkAgOo1qr/w97dq3QYAsGD+ /Jyd8mqyf+8+2bxJE9mnR0+cCw1FMU9PzJozG6dCQkT/t94S+q07ZD6q16guVq5dI46dDEbffv0g hMCGdevxxv/qoF+v3vL0qVMMWmQQ3CNPRKqnRJAHgLJly+rP5zddlcjKysL4MWPliePH4VGsGMZO mPDCTnW//gHCu1w5/HnhAnq92UMmJSWZotQXOnzwoGzVvIV8s2tXnD19BkXd3fHljBk4ExoiBr/9 NldKWoDyFSqI+YsWijPnQgPfGTEc9g722LljB/ybNkOndu3lwf0H+LWFDIZBnohUJyMjA7du3YJO p0PJkiVNOl5Qrlw5AByvUYvU1FS8PWiwXP7DD7B3cMCSH5aiYMGCL/xzjo6OWLN+Xc6DfLp06Cjj 4uJMUPHT/X70qGzXqrXs0rETTgYHw9XVFVOnT0fI+XPinRHDhZ398/fik/kp7uU19ssZM8T5ixfF uAkTUKhQIRz57Td069wZ3bt0YZgng8gZrSEiUotbt27JzMxMlC5dGjY2NiY9W/8OAIO88s6cPi0b 128gN2/cCBcXF2z+dSsaNmr00i/sKvr4iN379saULl0aJ4OD0bqFvzwXGqrI97zunbvg2B9/oFCh Qvjk888Q8ucFMfK9UcLewUGJcsiEChcujAmTJopzF/8Sn039AgBwKvikwlWRpcjpyHNGnojUQqmx mtxnMsgrJzUlBZ9N+US2at4CVy5fRrny5bF99y7UqVv3ld+dKV26tMeuvUF+latUweVLl+DftBkC Z86USs3NB589Iz748EPh6OioyPmkHCcnJ7z3wQfCzs4O8fHxUMu4F5k3jtYQkepcvXoVgLJBXl8D mc6jR4+wYd162ah+A/ntN99ASokRo97FkT9+F1WqVs3ziJW7h8e5fQcPiOHvjkRmZia+nDoN5cuU lSOGDZMH9u2XmZmZhvxrPJezk5PJziJ1KlasGAAgKiqKHVTKNwZ5IlIdfTdcP69uSuXKlYvJXQMZ 193YWKxYvlx269xZVizrLUcMG4awK1dQpkwZbN+9C9O+/NIg8+P2Dg6Y/tVXYmfQHtSoWROJiYnY sG49unfpgsrlK8jxY8bIk8HBDFZkdMU8PQEA0VFRCldClkALrp8kIpVRcrSmRIkSHjqdTkZFRSE5 ORkOnGE2qLS0NJw4flweOnAQhw4eQGhIKLKysgAAOp0O/q1aolOXLujSpatwcDT8//f/q1NH7Dt0 ENeuXZO//PQTfvnpZ1y7ehVLl3yPpUu+R6lSpWS3N99EqzatUaNmTWHqezTI8umDfFQkgzzlHxfV EpHqKBnkbWxsULp0aYSFheH69euySpUqfChPPt26dSt057btvgcPHsDvR48iOSk559fsHRzQsFFD dOrSBe3atxcuLi4mqcnb21uM//hjjP/4Y4ScDZG//PwTNm/chFu3bmFOYCDmBAaiUKFCskmzZmjZ qhU6d+nMzTJkEMU8s0dr2JGnvBJCROt/yCBPRKoipcT169chhEDZsmUVCdHe3t4ICwvDtWvXUKVK FSVKsAhRkZEBM7+esWrt6tXIyMgAAAgh4OvnhyZNm6Jp82aoW6+esLOzU7TO16u/Ll6v/jq+mDYN vx89Knds24Z9QXtx/fp1bN64EZs3bsQnkybJIcOGYsjQoaJQoUKK1kvmzbPYk458VKTClZAlYJAn IlUJDQ2VSUlJqFixIuwV6oD6+flh9+7d+P3339GxY0dFajBnmZmZ+PzTT+XSJd8jNSUFtra26Nm7 F1r4t0Tjpk2Eq6ur0iU+lUajQcNGjUTDRo2AWcCNGzfk/r17sWHdepw5fRpfTZuOBd/Ol6vWrUWj xo35Tg3liWdxfZCPfsHvJHqxnD3ynJEnIjUICgoCALRo0UKxGvz9/QEAe/fuVawGczb1s8/ld/O+ RVpqKrr3eBMnzpw+t+j770W3N7urNsQ/TZkyZcSQoUPFvkMHxdYd29GwUSPEx8ejR9du+PnHn/hN k/Lk7xl5duQp/7i1hohURR+elQzy9evXFw4ODggJCcG9e/cUq8Mcbd+2TX77zTfQarXY9OtWfL9s mShVqpSf0nXlV8NGjcSW7dvEqPffR1paGt55+22sX7uOYZ5eWbFinnsBzsiTYTDIE5FqpKSk4OjR o7CxsUHTpk0VG12wt7dHgwYNIKXEvn37GNZe0rWrV+XIYe8AAD79/HM0btLEosZPhBD4fNpUMf3r ryGlxIfvv4/Tp07x44NeiUcxj5ZCCERHc7SG8o9BnohU48iRIzIlJQW1a9eGqbaXPAvHa15NZmYm hg4ZgoSEBHTo2BEj3xtlUSE+t+EjR4i3hw1Famoq+vXug+ioKH+layLzodPp4OrqitTUVDx48EDp csjMcUaeiFRDDWM1egzyr2bxgoXy7OkzKFmyJBYsWWyxIV5v+tdfi0aNGyMmOhpvBfQP0u/CJ3oZ uR4KxfBF+cKOPBGphpqCvJ+fnyhatChu376Ny5cv85vtc9y4cUNOnzYNADD322/h7OyscEXGp9Vq 8X+rVwmvEl4IPnECy5b+wI8RemkFCxYEAHbkKU+EEDH6HzLIE5Eq3L17F6GhoXByckK9evUU7+gK IdC8eXMA7Mq/yAfvjkJKcjL69O2Lps2bKf5vZyqFChXCzNmzAQDTPv+cIzb00jQ22fErPS1d4UrI 3DHIE5Eq7Nu3T0op0ahRI9ja2ipdDgCO17yM1StXyiO//Yai7u6Y9vVXVhPi9Vq3aSPatW+PhIQE TBg3Pkjpesg86HQ6AMh5UBpRXnFGnohUQU1jNXr+/v6BAHDo0CF+w32K6Kgo/ykTJwEAZs0OzBkX sDZfz5oZ6OjoiF+3bMHePUH8ZkovpNNmB/n0DHbkKX/YkSciVdAHeX0XXA28vLzG+vj4ID4+HidO nGBAyyU9PR0D+w8Iio+PR4eOHdGhUyer68brFffyGvvxpOwXNGM+HI2EhASFKyK10+o78ukM8pQ/ DPJEpLhLly7JO3fuwN3dHVWrVlVVIOR4zdN9OnmyPHH8ONw9PBA4d46q/s2UMGzEcOH3uh9uh9/G +DFj+KKPnkun0wIA0tP5Th/lD4M8ESlu27ZtALLHaoRQVyZs2bIlgL9rJGDzxo1y8cJF0Ol0WLlm NdyKFlW6JMVptVosXb4cDo4O2LBuPbZs2sQwT8+kn5FPZ0ee8okz8kSkuNWrVwMAevbsqXAl/+Xv 7y8KFSqEM2fO4K+//rL6L5Rnz5yV7418FwDw1cwZ+F+dOup65aWgcuXLiy+//hoAMPq99/HnhQtW //FCT6fV6m92ZZCn/GFHnogUFRISIs+fPw83Nze0adNGdaHQzs4u5wXGqlWrFK5GWcePHZOd27fH 48eP0bdfPwwaMkR1/15KGzBwoOjUpQvi4uLQqV17nD93jmGe/oMdecoP7pEnItXQh+PevXtDq9Uq XM3T9e/fHwCwZs0aWOsTPA8dOCi7de6MhIQE9OjVE3Pnf8sQ/wxLflgq2rRtiwcPHqBz+w44dfIk wzz9A2fkyVA4WkNEisnIyMC6desAAAEBAQpX82z16tUT5cqVQ0REBA4cOGB1Xyx3bN8ue/fogeSk ZLw1aBAWLlki1PqiSw1sbW3xf6tXiTZt2+Lhw4fo1L691b4ApKfj1hoyFHbkiUgxQUFBMiYmBpUq VUKtWrVU3eHVv9CwtvGaH9dvkAMD+iM1NRUj3xuFOfO+ERoNv3W8iK2tLVauXSP69uuH5KRkjlDQ P3CPPBkKvxoTkWL0oVg/uqJmAQEBEEJg06ZNSExMVLockwicOVMOHzoUGRkZGD/xY0ydPl3VL7bU RqvVYv6iheLDMWNyfm5OYKDVvaND/8UZeTIUBnkiUkR4eHjQpk2bYGNjg379+gUqXc+LlClTRjRs 2BCPHz/GDz/8YNFhLD09He++M1x+OXUatFot5n03H+M//pghPo8mf/qJmDVnNjQaDWbNmIkP3/9A ZmZmKl0WKUj7ZEY+gzPylE+ckSciRcycOdM/PT0dffr0gZeX11il63kZ48aNAwDMmjULqampCldj HPHx8ejRtZtct3YtnJ2dseHnnxEwYABDfD4Nfvtt8X+rV8HO3h4rli/HW/0CZEpystJlkULYkSdD YUeeiEwuJibGfdmyZdBoNJg4caLS5by0du3aiddffx2RkZFYsWKFxXU/YmNi3Fs1byEPHzqEYp6e 2Bm0B81aNGeIN5AOHTuKjVs2w8XFBTu2b8ebXbvJ1JQUpcsiBXBGnvIj1/pJBnkiMr3Zs2dHp6Sk 4M0334SPj49ZBUX9C48ZM2YgI8Ny3hZPTExEj27doy9fuoTKVapg74H9Y6tWq2ZW/zbm4I369cXO oD3wKFYMvx89iqFD3pbcaGN9uLWGDIR75InItO7fv49FixZBCIFJkyYpXc4r69atm/Dx8cGNGzew bt06i+jKp6WlIaB3H3kuNBTe3t7Ysn2b8CxeXPX3LZirSpUri41bNqNAgQLYtnUrJk2YYBEfR/Ty tFobANwjT/nHGXkiMqn33ntPJiYmolOnTqhmhh1fjUaDjz/+GAAwfvx43L17V+GK8m/KxIny8KFD cPfwwC9bt5xzdXVVuiSLV6lyZbFmw3rY2tpiyaLF+G7et/wmbEU4I0+Gwo48EZnMypUr5bp16+Di 4oK5c+fGvPhPqFO/fv1E06ZNER0djQEDBkhzboRER0X5r/y/FdBoNNjw888oVaqUn9I1WYsGDRuK hUsWQwiBT6dMweaNG833A4leCUdryFAY5InIJMLCwuS7774LAFi8eDFKly7toXBJeabRaLB69eqx RYoUwa5du/DNN9+YbQBb8N13QWlpaWjfsSP8Xvczu3dIzF3X7t3FF9OmQUqJSR9PZIfWSuhvds3I 5GgN5Q+DPBEZXVpaGnr16oXExES89dZb6NWrl9kHxuLFiwcuW7YMADBhwgScOXPGLMP8xp9/AQC8 P3q0wpVYr5HvjRIVfXwQHRWFXTt2mOXHEb0a3ZM98pyRp/zijDwRGd3HH38sz5w5g/Lly2P+/Plm H+L1OnXqJIYPH460tDT07t3b7J74+ujRI0RHRcHZ2RnVa1S3mH8Xc9ShY0cAwIXzFxSuhEyBozVk KOzIE5FR7dq1S86dOxc6nQ7r16+Hs7Oz0iUZ1OzZs0WVKlVw5coVjBo1yqw6IpcuXpQAUL5CeaVL sXolSpYAAMTGxipcCZkCb3alfBE5fReunyQi44mOjvZ96623IKXEl19+iZo1a1pc19fBwQHr16+H vb09VqxYgfXr15tNmL9y+TIAoHyFCgpXQh4exQAAUVGRCldCpsAHQpGhMMgTkVEkJyejU6dOobGx sfD398dHH31kcSFer1q1aiIwMHvt+tChQxESEmIWYf7iX38BAHwqVVK4EnL3cAcARNyJULgSMgXt kxn5DM7IUz7lzMiDM/JEZCBSSvTr108GBwejbNmyWLt2rRDCYnM8AGDkyJEiICAAiYmJaN++Pe7c uTNL6ZpeJDQkFADg5/e6wpWQu7u7HwBE3LmjdClkAhytIUNhR56IDG7cuHFy06ZNKFSoEHbs2AE3 NzelSzKJH374QTRu3BgRERFo3779mISEBKVLeqbMzEycC80O8r5cO6k4t6JFz7kVLYq4uDjs37uP nTULxyBPhsIgT0QGtWTJEhkYGAidTodNmzbBx8fHakKira0tNm/eLCpWrIjQ0FD07NlTZmZmKl3W U61euVImJSWhfIUKKFKkiNLlWD2NRoOh7wwDAMyfN0/hasjYtPo98pyRp3xikCcig9mzZ0/OQ5+W Ll2KJk2aWE2I19O/C+Hq6opdu3bh3XffVV139cGDB/hy6jQAwKQpkxWuhvQGDRkiHB0d8dvhw/h0 8hTVfdyQ4Wi1NgCAjAx1vtAn85Frj7zClRCRWTt//rzs0aMHMjIyMGXKFAwYMMDqQryet7e32Lp1 K+zt7bF48WIEBgaq5ivsiePHZdOGDeW9e/dQv0EDdOzc2Wr/ndSmUKFC+G7RQtja2mL+vHkYMWyY vH//vtJlkRFkZWV/SdBo+OlH+cOOPBHlW3R0tG/79u0RHx+PPn364IsvvrD6705vvPGGWLFiBYQQ GDduHDZu3KhYmJdS4vixY/K9ke/K9q3b4Hb4bdSoWRMLlizeq1RN9HSdu3YVP/7yM5ycnLBh3Xr4 Va4iP508Rd69e1fp0siAsp6M3GlsbBSuhMyR4B55IjKUpKQkdMrn3+8AACAASURBVOjQITQ8PBwN GjTA8uXLrT7E6/Xs2VNMmzYNUkoEBAQgODjYpGE+Jjrad8aXX8ka1Xxl25atsGbVKkgp8eGYMdi9 b68oWbJkS1PWQy+ncdOmYu/BA2jbrh2SkpIwf948vF61qvz8k0/lw4cPlS6PDCAzKzvI22gY5Cl/ co3WqOadXyIyExkZGejRo4c8deoUypcvjy1btgg7Ozuly1KViRMnikGDBun36uPGjRtG/2L7159/ yhHDhkm/KlVDZ3z1FW7dugWvEl74cMwYnDh9CpM//URotVpjl0H54FOpklizYb04dPQI2rZrh+Sk ZMybOxevV6kqZ3z1lUxMTFS6RMoH/U3wNuzIUz6xI09EeTZs2DCpXy+5c+dObj95hsWLF4v27dsj OjoarVq1gjHHJE6fOiWbN2mKDevWIysrC526dMHWHdsR+uefYvKnnwjvcuX4jokZ8fXzE2s2rBf7 Dx9G0+bNkJCQgBlffoWWzZrL2JgYd6Xro7xhkCdDYZAnojyZPHmyXL58OZydnbFz506UY0B8Jp1O hx9//FHUq1cPYWFhaNeunXz8+LHBz4m4c2dWn569kJqSgh69eiLkwvmx/7dqpWjYqJHFP5DL0lWv UV1s3LJF/LpzB8pXqIBLFy+iXes20VGRkQFK10avLisrC0D22lGi/OBHEBG9soULF8rp06dDp9Ph l19+Qa1atZgSX8DR0RHbt28XPj4+OHnyJLp37y4zMgz7ePagPXvG3I2Nxf/q1MGCxYuFZ/HigQY9 gBTXoGFDsWtvkPB73Q/Xrl7FqhUrVyldE706duTJUDgjT0SvZNOmTXLUqFEQQmDZsmVo1aoVQ/xL Kly4MPbs2bPX09MTu3fvxuDBg6Uhv/amp2e/MPD182NAsGCFCxdGj569AACPkwz/zg4ZX1bmk468 DfuplD/8CCKil/bbb7/Jvn37IisrCzNmzEBAQABD/CsqWbJky927d8PFxQWrVq3ChAkTDJbkM548 7l2n442sls7B0QEAkPQ4SeFKKC/YkSdDYZAnopdy4cIF2alTJ6SkpGD06NEYO3YsQ3weVatWTfz6 66+ws7PDzJkzMW/ePIOE+fQnj3vXP/6dLJejoxMAIDmZQd4ccf0k5Qf3yBPRK7l9+/aq1q1b49Gj R+jduzdmz57NEJ9PjRo1EmvXroVGo8Ho0aOxYcOGfId5/cy9Tscgb+n0HfnH7MibJf3NruzIU35x Rp6InuvBgwdo1apVQEREBFq0aIEVK1ZwA4qBdOvWTcyfPx9SSgwYMAD79+/P1xfijCcz8twRb/mc nnTkkzgjb5b0ozXcWkP5xY8gInqm5ORkdOzYUV68eBHVq1fHpk2bhK2trdJlWZQRI0aIyZMnIy0t DV26dMHZs2fzHObTn8zIazkjb/H0HfnkpGSFK6G8yNIHeXbkKZ8Y5InoqTIzM9G7d2/5+++/o2zZ sti1a5fHa6+9pnRZFmnq1Kli8ODBSEhIQNu2bXH9+vU8hfn0nJtdOVpj6RwcHAGwI2+ueLMrGQqD PBE91YgRI+TWrVvh5uaGPXv2wN3dPUbpmizZkiVLRIcOHRAd/f/s3XdYU9cbB/DvTQgkTAMqqIAD 0Lr3at2rrVbFPVBa994gbkTUynDvveveG60KWkd/Wot7MBTcg6ESSEJyfn9AqG21DgI3N/f9PM99 QJDwAsm535y895yn+O67775o99dMXXaPPF3savZsbAxBnmbkhUinM/TIUwwjuUM98oSQf5k6dSpb sWIF7dqaj6RS6d92f23ZsuVn7/5qWH5SSj3yZk+hsN4I0Iy8UNHFrsRY6KkgIeRvVqxYwYKCgmjX Vh4oFAocPHiQK1u2LC5duoQOHTowQ7vMpzBsCEXryJs/hbXCF6B15IWKLnYlxkL3IEJIjoMHD7LB gweD4zisWbOGdm3lgaOjI44ePXq8WLFiOHbsGPr16/fJL5fS8pPiYWOd3VpD68gLkl5vCPI0I08+ H60jTwj5l+vXr7Pu3btDp9MhJCQEPXr0oBDPE3d39xZHjhyBra0t1q9fj9DQ0E8K85m0IZRoyBUK cByHjPQMao0VILrYlRgL9cgTQvDixQu0bt0ab968QZ8+fWjXVhNQsWJFbtOmTeA4DuPHj8eBAwc+ OkjnLD9JPfKioFAowBhDejpd8Co0FOSJsdCMPCEip9Fo0L59e3b//n3Ur18fS5YsoRBvItq2bcvN nDkTer0ePj4+uH79+n+GeeqRFxdrQ3uNitprhIaCPDEWCvKEiNzAgQPZ2bNnUaJECezatYs2fDIx 48aN43x8fPDmzRu0adMGL1++/OD/1WX3yFtQj7woGDaFUqlUETyXQj6TXp/1nFwioXkTkjt/tdaA WmsIEZvZs2eztWvXwtbWFvv370ehQoX4Lom8x6pVq7jatWsjPj7+P1eyoQ2hxEUuzwry6oyM5jyX Qj4TzcgTY6EZeUJE6tChQ2zs2LGQSCTYvHkzKlasSFNDJkoul2Pv3r2VXV1dERUVhcGDB7935kVr uNhVSq01YmC4FsKwWhERDr1h+UkK8iSXKMgTIkI3btxg3bp1g16vx4wZM9CmTRsK8SbOxcXl6r59 +2BtbY1Vq1Zh/vz5/wrzmVpDaw0FeTEwzOYaZneJcOiyl5+U0vKT5Au8s/wkBXlCxObly5c5K9T4 +Phg3LhxFOIFolq1aty6devAcRzGjBmDY8eO/S3M0zry4iKVZp3CdTo9z5WQz0WtNcRIOFp+khAR 0Wq16NChA4uPj0ft2rWxatUqCvEC06lTJ27KlCnQ6XTo0qULbt++nTN4U4+8uEizW6h0OmqtERq9 PuvJF+3sSnKL7kGEiMigQYNYVFQUXF1dsXfv3spyuZzvksgXCAwM5Dp27IjU1FS0adMGycnJAN7Z EIp65EWBWmuEi2bkibFQkCdEJFasWMFWr14Na2tr7Nu3Dy4uLlf5rol8GY7jsH79eq5q1aq4d+8e fHx8GGMMmZlZ4YB65MWBgrxw6bPboSRSimEkd+geRIgIXLt2jY0YMQIAsGrVKlSrVo1aagQu+wnZ RicnJxw5cgRhYWGMWmvEhVatES6akSfGQj3yhJi5tLQ0dO7cGRkZGejXrx+6detGId5MuLm5+Rou fp04cSLevHkDgIK8WNCMvHBRkCfGQjPyhJi5IUOGsNu3b6NChQqYP38+hXgz88MPP3CjRo1CZmYm nj55AgCQWlg847kskg8MbRm6TAryQkMXuxJjoXsQIWZs48aNbP369bC2tsa2bdugUCj4LonkgVmz ZnE1a9ZEZvYsn8zCYiPPJZF8YGitoRl54aF15Elu0DryhIjAnTt32KBBgwAAixYtQrly5Wg23kzJ ZDJs3boVkuzBXSaThfNcEskHhhBoCIVEOGhnV2IktI48IeZIp9OhW7duSEtLQ48ePdCrVy8K8Wau VKlSnI2NDQDAQiaj1hoRoItdhYt65Imx0Iw8IWZo3rx57MqVKyhZsiSWLl1KIV4kDP22hoBHzJth NldPrTWCY9iNV0rLT5JconsQIWYmISEhIjAwEACwePFi2Nra8lwRyS/a7JlZmQWtWiMGtGqNcNHF rsRY6B5EiJkZOnRo87S0NHTs2BHff/89zcaLSGb2OvK0IZQ4WFhkBflMWrVGcKi1hhgL9cgTYkZ2 797NDhw4ADs7O8yfP9+X73pI/jL0SlNrjTjQjLxwUZAnxkIz8oSYiTdv3mD48OEAgOnTp6No0aK0 BKGIvBvi312ajJgvWrVGuPTZfzMJLT9JcomCPCFmIigoiD169AjVqlXDkCFDKMmJjKGtRkqz8aJh +FvraNUawaEZeZIb70zWcDlBnlprCBGuly9fYunSpeA4DsuXL6eTgwj9daErBXmxoNYa4aKLXYmx 5PTIE0KEa8GCBUylUqF169aoUaMGzcaLkDZ7Rl4moxVrxIKCvHDR8pPEWOgeRIjAvX37FosWLQIA jB8/nudqCF8M7RUWFORFg1atES5qrSHGQkGeEIFbvnw5S05ORqNGjVCnTh2ajRcprVbrB9CKNWJC G0IJl+FvJqEgT3KJlp8kRMA0Gg3mzJkDgGbjxU6bmdkToB55MaFVa4SLZuSJsdCMPCECtnfvXvb4 8WNUq1YNLVq0oNl4EcvMzKwEUI+8mBhefcmkVWsEhy52JcZC9yBCBGzLli0AgD59+vBcCeHbX7u6 UpAXC7rYVbgMr6JIaR15kksU5AkRqJSUFBw5cgQWFhbo1KkTzcaLnGHVGuqRF4+cIE8XuwoOtdaQ 3PjnOvLUI0+IAO3evZup1Wo0bdoUhQoV4rscwjOtNnsdeRkFebGQWtCMvFDps5eflNDykySX6B5E iEAZ2mq6d+/OcyXEFOh02ctPWlBrjVhQa41w0Yw8MRYK8oQI0LNnz5xPnToFuVwOb29vaqshtCGU CNHFrsJFj1diLBTkCRGgkydPPtXpdGjWrBns7e35LoeYAOqRFx9aflK4NFoNAMBSZslzJUTocnrk QT3yhAjG6dOnAQCNGjXitQ5iOgwXPFpQj7xo0IZQwqVRZwV5mSXNyJPcoRl5QgQoMjISANCwYUOe KyGmQpuZ/VI99ciLhkX2xa6ZtGqN4Gg0WUHeysqK50qI0FGQJ0Rgnjx50vzOnTuws7ND1apVqT+e AKCeWzGii12FS6sxzMhbPuO5FCJwFOQJEZjIyMgIAKhXrx6teEByGDaEklKPvGgY1pKm5aOFR60x 9MjLwnkuhQgQrSNPiIBdvHgRANCgQQOeKyGmxNBeQevIiwcFeeEyzMhbWllRkCe5QjPyhAjMnTt3 AACVKlXiuRJiSqi1RnwoyAuXoUfe0pJWrSG5Q0GeEIG5e/cuAKB06dI8V0JMSWamYflJCvJiQUFe uN5preG5EiJ09BosERyVSoVtW7aI8syVmZmJ+Ph4yGQylCxZki50JTkMmwLROvLiQUFeuAytNb9s 3sze6Xcm5JNkZKgN71pagHrkicDMCQtnc8LF2Vao0+uh1+vh5eVFF7qSv9Hr9QAAiYReaBULCvLC pNPpch6vfqNG81wNETg5Td0QQYmPj2eLFy4EAHTs3El0/cBx8fE4GhFBbTXkXwxhjmb3RMTwt6Yg LyiGzaCkUik6d+3CczVEqLZs/gUAtdYQgZkYMA5qtRqdunTG8lWrRJdYlixZwo5GRMDV1ZXvUoiJ oSAvXjQjLywabVaQt7W1xeJly+gBS77Ils2/MOCdi11pICCm7kTEcXb0yBHY2NggKDi4Bd/18IFW OiAfYhjCKceLBz1pEyYax4kx5awjT4gp02g0GB8QAADwHxcAlyJFjvNcEi/oBEA+xNBzS+FOPDhk 98jTaVxQNGp1GADIaBwnRkBXRRFBWLZkCYuNiYGHpycGDh4s2qRCQZ58iOFVVbrYVTzoYldh0mi1 fgBgReM4MQIa8YnJe/b0aaWwWSEAgJ9DQkQdYinIkw+hHnnxoSAvTBp11tKBNCNPjCGntYYGAmKq AidPjk5LS8N333+PZi2aizqlGHbvpCBP/oWa5EWHgrww0YQMMSaakScm7feLF9n2rdtgZWWFGSGz +C6Hd3QCIB9CM/LiQ0FemGhChhgTBXlisvR6PcaO8QMADBk2jHYyxV9BXmzr55OPo4tdxYeCvDCp s1trKMgTY6AgT0zWhnXr2NXoaBQtVgyj/f0onYBm5MmHGVYukXA0rIsFBXlhonGcGBP1yBOTlJKS gulB0wAA06YHw9ramueKTAOdAMiHUGuN+NDGrsKk1WS31ljROE5yj6ZuiEmaGTydJSUl4etvvkH7 jh0pmWSj3kryIRTkCREGtSa7tUZG4zjJPQryxOTcuH6drV29GlKpFCHhYXyXY1KsrKwAACqViudK iKmhIC8+1FojTFrDtU40IUOMgII8MTkBfv7Q6XTo1acPyleoQKnkHSVKlAAA3L9/n9c6iOmhi13F h4K8MGmyW2usqLWGGME7PfI8V0IIgN07d7Jzv/0GJycnTJg8iRLJP1CQJx9CO7uKDwV5YdJkt9bI qLWGGAGN+MRkqFQqTJk0GQAwKXAKChQowHNFpoeCPPkQaq0RHwrywmRYtMDQKklIblCQJyZjTlg4 e/zoESpXqYyeP/5IaeQ9SpQosREA4uPj+S6FmBgK8uJDQV6YDK01lpa0HwjJPQryxCTEx8ezxQsX guM4hISHU3vABxQrVsxXJpPh6dOnOZuKEAJQkBclWn9SkKi1hhgTrSNPTMLEgHFQq9Xo1KUzatWu TUnkAyQSCdzd3cEYw4MHD+hBS3IwfXaQl9DDRyxoRl6YqLWGGBNNexLenYg4zo4eOQJbW1sEBQdX 5rseU2fok6f2GvIumpEXHwrywmTYEEpGrTXECCjIE15pNBqMDwgAAPiPC4Czi8tVnksyeXTBK3kf CvKECIOhLZI29iPGYGF4h57REz4sW7KExcbEwMPTEwMHD6YE8gkoyJP3oSAvPnkxI69Wq5GRkQGt Vgu5XA65XA4LC4uPfyH5ZFptVmuNpSW11pDcs0B2jzwh+e3Z06eVwmaFAABmhYZCJqOXGT+FIcjf u3eP30KISaEgLz4fCvJv3rxBbEwsi42JQWxsDO7Hx+Ptm7dIz0hHRnoG0tPTkZGRgYz0dKRnv81Q ZyAjPeO9TwpkMhnkcjkU1tZQGN4q5FAorCFXyGGd/dbR0REenl7w9PSEh5fncVdX1xa0cMG/0ao1 xJjoaTbhTeDkydFpaWn4vmVLNG3ejNLHJ6pVqxYA4MyZM2CMUXDLR+qMDKg1GnAcB4lEAgknAccB nEQCiUTy18d5CC+GnV0pOImHIXTHxsZi2OAhLC42FjExMXjx/PkX36aVlRXkcjlkMllW2M+enddq tXjz5s3n3FRzK7mclSpVKivYZ4V71KhRA2W++krUgxa11hBjoiBPeHHxwgW2fes2WFlZYUbIrGd8 1yMkpUuX5tzc3FhiYiKuXbvGKlWqJOqTooFer0dSUhJevXzJUlNTka5S5cw2qtLTs2Yd0zOgSldl zUpmpCNdlY6MjHSoVNmfz8iASqVCRkbWrGV69tcZZjI/p4WB47i/BXuO47IC/3s+/u77MktL2Nvb w8HBIeso4AAHhwL/+HfWYe9QwPBvTqfT5XxfYt4y0tOxedMmFhYSCgC4e+cO7t65k/N5hbUCpUp5 oJSHBzw8PFDKoxQKKJVQyBWQK+RQKBSQy+WwksuhkMv95QpFuOFz77v/aLVaw2PBWZWeHp2Rnu6c rkrPeQwZ3j5/9gwxMTHIeiUgFk8eP8atmzdx6+bNv91e/QYN2IDBg/Dd999zYnziSa01xJioR57k O71ejwA/fwDA0OHDUaJECReeSxKcpk2bYt26dThx4gQqVarEdzl5QqvVIunVq0ovX76MfvnyJV69 fImXL19lv806Xr3zNjk5OWdWOq9YyeWwsrQEYwx6vR56pgdjANProdfr//p49vuGf3+ux48efe6X 5Azgc2fPwfat29g/nwgUKFAA7sXd4ebmBld3d7i6unK0/J2wvHnzBksWLWKrlq/Aq1evAABu7m5o 4+0NT09PlPLwgKenp69LkSIbjfmETiaTQSaTwd7e/hmATx6vVSoVYmNicl4puHvnDg4fPIQzUVE4 ExWF4sWLs+GjRuKn3r05MT0BVasNy0/SjDzJPeqRJ/luw7p17Gp0NIq5umK0n594Rm8jatasWU6Q Hz16NN/lfDZ1Rgbi4uKYYfYuPi7+b6H85cuXSE1N/azb5DgOSqUSTgULQqlUwtraOutiPYUC1tYK yOUKKKwVObOShr5euTz78woFFNmHXC43fH24XKHwN/zfzwkb7wb5nGCv10P/no+/+75Wo/FLTU0N S01NRWpqKlJTst6mpCTn/Pu14XOpKTmff/36NXQ6Hd68fo3br19/yu+LFSpcGG5ubnBzd89+m/V+ 1iyuhyhnS03VxQsXWP8+fZCYkAgAqFqtKoYOH4423t6cVCrlubr3s7a2RsVKlbiK70w2vHnzBps3 bmIrly1DfHw8xowchd07d7EFSxajZMmSojgfpKW9BQBY29jwXAkxB9RaQ/JVSkoKpgdNAwBMmx4M hbWC54qEqWnTppUBREdFRUGr1ZrkhcJ6vR6JiYnRsfdiKmUF9ntZL7vfi8HDhw8/OlMtkUhygnmh QoXgVLAgCmYfWe875XysUKFCnNLR0aRW13i3teYzhRctViz8c7+IMYa0tDSkpqSEpaSk+L3vicCT x0+QmJiAhAcJePjwIZ4/e4bnz57h8qVL/7o9hbWClS1bDuUrVECFihVRoWIFlK9QgbO3t//c0kgu 6HQ6hIeEsvDQUOh0OlStXg3Tpk/HN/XqCTL02tnZYeDgQVz/gQNwcP9+FuA/Fr+dPYv6depiSlAQ 6zegv9nPzqe9TQMA2FCQJ0ZgOmc9Igozg6ezpKQk1KtfH+06dDDv0ToPubi4XC1fvjxu3LiBCxcu sPr16/P2u2SM4fq1a+xqdDRi7mXNsMfExCA+Li7noq5/srS0RMlSpeDl5QUPT0+4ubu9E9ALwqlg Qc7R0ZEu3PwMHMfB1tYWtra2/sVcXf0/9v8ZY3j54gUSExNZwoMHSExMRGJCIhIePMDtW7eQkJCA Py5fxh+XL//ty9zc3VChQkVUq1EdTZo0ReWqVWjmPo8kJiRG9O/Tp/nFCxcgkUgwaswYjJ80kTOl J6xfSiKRoI23N9egUSOM8/dn27duwzh/fxzcv5+t27SRc3R05LvEPGOYkbexseW5EmIOclprqEee 5LUb16+ztatXQyqVYlZYKN/lCF6zZs1w48YNnDhxAvXr18/X733//v2nkadOOUeejsSZyMicft1/ KlqsGDw9PeGZHdi9vLzgWdrrmZubm4uptgOIBcdxKFS4MAoVLsxVq179X59/8+YNbly/zm5cv47r 167jxvXruHnjBhITsgL/kcOHMWNaMJRKJWvQqBGaNG2CRo2bHHdzd2vBw49jds5ERTHf7j5ITU1F 0WLFsGzlCtTj8Ql7XilQoACWrVzJtfH2ZqNHjMTZM2fQonETtm33Lnh4eJjdzwsAb7Nn5O3sKMiT 3BP+03oiGAF+/tDpdOg3oD/KlS9vlgN0fmratCnmz5+PX3/9FUFBQXn+/XQ6Hfbs2s3mz52LG9ev /+1zxVxdUaduHXiVLp0zy+7p5cVZW1vneV0kb9jZ2aFO3bpcnbp1cz7GGEN8fDyLvnIFp0+dxulT J5GYkIh9e/Zg3549ANDcw9OTtfjuW/Tq3RueXl70OP8CRw4fZr1//AnqjAy0bNUKi5Yt5QoUKMB3 WXmqZatWXM1atdCtU2f2x+XL+LZJU2zauoXVqVvX7O5Db98aZuRt6EkvyT2lrd0Gpa0d2/rLFma4 OIsO0z6KFy3GlLZ2LCUlhfdaPvXYtWMHU9raMc/iJVhycjLv9ZjD8fr1a1hYWDALCwv2+vXrPP1e +/ftY9UqVmJKWzumtLVj7kWKMp8uXdmKZcvZvbt3Gd+/Czr4O2JiYtiqFStYj67dmHuRojn3EUc7 e9auTRt2+NAhptPpeK9TKMe2LVtZoQJKprS1Y6NHjBTd706VpoJPl65MaWvHXJwKsp3bdzC+azL2 4eZShClt7fJ83KbDvA/DWEtBXoCH0IJ8Wloaypf5iilt7dj6tWsZ3/WY01G3bl0GgO3duzfPfq+P Hz3qWaywM1Pa2rEalauwTRs3Mq1Wy/vPTofpHVqtFhcvXGB+o0YzV2eXnFBfuVx5Nn/uXJaUlMR7 jaZ8rFy+nDna2TOlrR0LnhrE+K6Hr0On0yHAzy/nCeHa1avN6nfhZO/AlLZ2onuSRodxj3eD/Hql rR3bsvkXxndRdHzaIbQgHzw1iClt7Vjj+vVp4DLyMXfuXAaAtWnThuXV9xjQty9T2toxX58eLDMz k/efmQ5hHKmpqVi6eAmrXqlyTqD3LF6C8V2XqR5hISE5wXXxgoX0e2IMixcsZEpbO+Zk78B2bNtu Fr8TVZoKSls7VqRQYbP4eejg76AgL+BDSEE+Li6OuTgVZI529uz3ixcZ3/WY25GUlAS5XM6kUilL TEwMM/bt/3nlT+ZoZ8+KFCrMEhMSN/D989IhvEOv1yPi6DFmeFWHWuv+fSyav4Apbe1YQYcCbPOm TYzvekzpMIT5QgWU7PChQ4L/3Tx/9gxKWztWumQpwf8sdPB7GII8rRlG8tTEgHFQq9Xo0q0rataq ZXYXLfFNqVSiU6dO0Ol0WLVqlZ+xb//8uXNgjKFrt25wdXP1NfbtE/PHcRyaf9uC8/TyAgAkJiTQ Emnv2LNrF5syaRI4jsPSFSvQ3ceHxsl3DB42lAsYPx6ZmZno7fsjIk+fFvT9521aGgNoDXliPBTk SZ45EXGcHT1yBLa2tpg6bdonb+tNPk///v0BAKtWrYJOpzPqbcfcuwcA+KpsWaPeLhEfwwpGhhU7 CPDb2bNs8ICBYIxhavA0dOzciUL8ewRMGM8NGjoEarUaPl264n+//y7YMJ9mWLHGlpaeJMYhAa0j T/KARqPB+IAAAMDYceNQ2Nn5Gc8lma169epx5cqVw6NHj3Dw4EGjPpANQd7Dw8OYN0tEyEouBwBo PrBJmNjcvnWL9ejaDWq1Gv0HDsCwESMoxP+H6TNncj18faFSqdC1Yyc8ePAgmu+avkRaGu3qSoyL ZuRJnli2ZAmLjYmBp5cXBgweRCeoPGaYlV+2bJlRb/dedpAv5UlBnuSO3MoKAJBBQR5Pnzxp3ql9 B6SmpqJ127aYGRJCY+RHcByHeQsXcM1aNEdycjJ6duteKV2VzndZny0tezMoG1sK8sQ4KMgTo3v6 5EnzsFkhAIBZoaGQyWQ8V2T+fH19OblcjoiICMTHxxtlVl6r1eLJ48eQSqVwc3OjoEFyxTI7yIt9 Rl6j0cCna9eIRw8fok7dulixaiUnkdCp+FNIJBKsXLOGMBMlewAAIABJREFU8/DwwPVr1zB86BDB tRK8ffsGAGBra8dzJcRc5IweDIJ7PBATNXXKlIi0tDS0bNUKTZo1pQCYD5RKJTp37gy9Xo+VK1ca 5TbfDRcWFrQJNMkduTx7Rj5D3EF+ysSJ7MofV+Dh6YnN27ZyhpYj8mkcHBywaesW2NraYteOnVi8 YKGgwsvb7NYaW5qRJ0aS0yNPiDFcvHCBbd+6DVZyOabP+pn64vORob1m9erVUKlUub49qVQKiUQC nU4HvV6f69sj4mZpmRXk1eoMnivhz4F9+9iKZcthJZdj3cYNUCqVfJckSGW++opbtmolOI7D1ClT BLWSTU5rjQ1d7EqMg17PI0aj1+sR4OcPABg2fDhKlChBK9Xko2+++YarVasWnj9/jjlz5hjlxGZo i9Jqtca4OSJi8uyZZ7VIW2vi4+PZsMFDAACzQkNQvkIFerUyF1q2asWNHT8OOp0OfX/qhRfPn/Nd 0idJS8tetYYudiVGQkGeGM2GdevY1ehoFHN1xagxY+gkxYPw8HAAQEhICJ49e+ac29sztNRQkCe5 ZZXdWqMWYWuNWq1Gb19fvH79Gh06dcSPvXrR+GgEY8eN45p/2wKvXr3CiKHDBDErTxe7EmP7q0ee lp8kuZCSkoLpQdMAANNnzoDCWsFzReJUv359ztvbG2/fvsXUqVOf5vb2LC0tAVCQJ7lnZWit0Ygv yE8aP4FF/xkNDw8PzF2wgEK8kXAchwWLFlVWKpU4euQINm/aZPJBxnCxK7XWEGOhHnliFDODp7Ok pCTUb9AAbdu1oxMVj0JCQmBhYYGVK1fi1q1buXp8y7KDvDojo7lRiiOiJdYZ+QP79rHVK1fCSi7H 2o0bYEsbARmVs4vL1fC5cwAAE8YGIDEhMYLnkv7T2+wZeTs7uh8Q46DWGpJrN65fZ2tXr4aFhQVm hYXyXY7olS5dmhswYAB0Oh0Csjfl+lIuLlmXOTx+/NikT47E9EmlUgBAZmYmz5Xkn9TUVPiNHgMA mDZ9OipUrEiTHHmgXYcOXLsOHfDmzRsMHTSouSl3GBg2hLKzo+UniXFQkCe5FuDnD51Ohz79+qJs uXJ0ojIBgYGBnL29PQ4cOIDTuVjRwc3NDQCQmJBgtNqIOKWmpgIAHAo48FxJ/gmcNJm9eP4cNWvV Qt/+/WhszEPhc+dwhZ2dcSYqCsuXLjPZJJ/w4AEAwM3dnedKiLn4K8ib8DNYYrp279zJzv32GwoW LIhxEyfSicpEFCpUCOPHjwcA+Pn5ffE1MK5urgCABAryJJeSk5IBQDRLLp4/d45tXL8eMpkM8xct BMfR8JiXlEolFixeBAAICgw02sZ4xhYXGwsAKOXhQXcIYhTUI0++mEqlwpRJkwEAk6cGwsFBPDNt QjBy5EjOzc0Nly9fxooVK77oce7mljVrlJiQaNTaiPgkJyUBAJSOjjxXkvc0Gg1GDhsOxhiGjxyJ r8qWpdCWD1p8+y3XqUtnqDMyMGnceL7L+Zfk5GSkpKRAqVSiQIECfJdDzAS11pAvNicsnD1+9AhV q1WFT8+edKIyMXK5HPPmzQMAjBw5ElevXv3sMO/mntVaY3g5mJAvlWQI8iKYkZ87eza7d/cuPDw8 4DfWn8bGfBQUHNzCxsYGRw4fxqlfT5rURGVcbCwDgJKlSvFdCjEjFOTJF4mPj2eLF2a9XBwSHg6J hO5Kpqh9+/bc4MGDkZGRgc6dO+Pt27ef9fWurtk98ok0I09yJzlZHK019+7eZfNmZ62iMnfhAlhl b4RF8odLkSLH/QLGAgAmjBtnUhdXx8YY2mooyBPjyWmtMeWrvInpmTA2AGq1Gl27d0ONmjVpxsmE zZkzh6tatSru3LmDgQMHftYD3b1EcQ7ImpGnMYLkhmFG3tHRsTLPpeSpaYFToVar4dOjB+rVr09j Iw8GDRnCeXh44M7t21i1YqXJDFyG/ngPD0+eKyHmhKZRyWc7EXGcHTt6FHZ2dggMCnLhux7y36ys rLBt2zbY2dlh8+bNWLVq1Sef2JycnFCkaFGkpaXh/v37JnNCJMKTkj0jX0CpvMpzKXnm8qVL7NDB g7CxsUFg8DQK8TyxtLTEjJBZAICQmTPx6tUrnivKEhsbA4Baa4hxUZAnn0Wj0WB89trkY8eNQ2Fn 52c8l0Q+gZeXF7d8+XIAwPDhw3Ht2rVPDuWVK2dNoF7988+8KY6Yvbdv30Kr1UJhrYCVlRXf5eSZ 4KlBAIDBQ4eiYMGCPFcjbi2+/ZZr8e23SE1NxYxpwSYxCREXFweAWmuIcVGQJ59l2ZIlLDYmBl6l S6P/oIE04yQg3bp14/r164f09HR06tQJKSkpn/R1lbKDfPSf0XlZHjFjDxMTGQA4F3bmu5Q8E3nq FIuKjISjoyOGjhhOY6MJmDHrZ0ilUmzasAEJCQm8b2oXl90jX7JUKbp/EKOhHnnyyZ4+edI8bFYI AGBWaChkMhnPFZHPNX/+fK5SpUq4c+cOvL29mVqt/ujXVKqSHeSjaUaefJlbN28CAL4qW5bnSvLO tKCs2fiRo0fTrp0mwsPTk+vQqSMyMzOxYO685nzW8urVK6SmpsLBwQFOTk58lkLMDM3Ik08WOHly RFpaGlr98AMaN21CMwoCpFAocPDgwY3FihVDZGQkfH192ceexFeqVHkjAFylGXnyhW7dvAUAKFe+ PM+V5I0D+/ezK5f/gEuRIrSDq4kZ4+8PiUSCzRs34tnTp5X4quP0yVMMACpW4q0EYqYoyJNPcvHC BbZj23ZYyeWYPutns71YTQzc3Nx8jxw5AgcHB2zfvh2jR4/+zyTv6ubq6+joiFevXuHRw4dh+VUn MR83b9wAAJQrX47nSoxPr9djxrRgAMDYcQGQKxQ8V0Te5VW6NNfG2xtqtRqLFi7kbTZi29YtAIAO nTryVQIxUxTkyUfp9XoE+PkDAIaPGIHixYub9fJxYlCxYkVuz549sLS0xLx58zB79uz/DPMVDX3y 0dF++VIgMSuG1pryFSrwXInxHY+IYHfv3EGJEiXQw9eXZuNNkN9Yf3Ach7WrVucsg5qfEhISIk6f PAVLS0u0bdeO7iPEqKhHnnzUhnXr2NXoaLi6uWLUmNE0CJmJxo0bc+vWrQPHcfD398cvv/zywUHA sHLNpd//l2/1EfOQrkrHgwcPYGlpCQ9PT7MbP9auWg0A6NOvHywsLHiuhrxPufLluZatWkGlUmHZ 4iX5HnYCJ01unpmZifYdO6BAgQL5/e2JmaMZefKfkpOTMT1oGgBg+syZ9LKxmenWrRsXGhoKxhh8 fX2xdu3a957kvq73DQAgMvJ0fpZHzMDt27eZXq9H6TJlzC7oJiYkRpw4fhxWcjm69+xhdk9SzMmY sVm7va5euTJfd3s9ExXF9u3ZA2tra0wODPTNt29MRIOCPPlPM4Ons6SkJDRo2BBtvL3pRGWG/Pz8 uClTpkCn06FPnz7vbbP5+ptvOAsLC1z9Mxqpqal8lEkE6uZN8+2PX792bXO9Xo927dtBqVTyXQ75 D1WqVuEqVKyI5ORknD93Ll9m5R89fBjWt1dvAMDIMaNRpGjRjfnxfYm45AR5aq0h/3Tj+nW2bs0a WFhYYFZYKN/lkDwUFBTEzZ8/HwDg5+eHCRMm/G1AsLW1RdVq1aDT6XD2zBkaLMgnM2wkZm4r1mi1 WmzcsAEA0KtPH56rIZ/i+5YtAQBHDx/O8++VrkpH9y5d/V48f46GjRph5GhqSyV5I6dHnpB/CvDz h06nQ9/+/fBV2bI0CJm54cOHcxs2bICFhQV+/vlnDBw4kOn1+pzPN2zUCAAQdfo0PwUSQTp54lcA QPUaNXiuxLgOHzzIXjx/jgoVK6JmrVo0PgrAd9lB/sihvA3yarUa/Xr3ZteuXoWnlxfWbdrImVtb GTEd1FpD3mv3zp3s3G+/oWDBggiYMIFOUiLRo0cPbu/evVAoFFi+fDk6derEDDvANmjUEAAQeTqS zxKJgNy/f/9pbGws7OzsULtOHbMaR9atXQcA6N2XZuOFokrVKpxLkSK4f/8+bt+6lSeTmKmpqejo 3Y4dPnQISqUSW3Zsh4ODQ158K0IAUJAn76FSqTB54iQAwJSgqTQIiUyrVq24iIgIODg4YPfu3Shf vjw7cOAAq1mrFidXKHD3zh1eN1YhwnEiIsIZABo1bmxWF7pqtVpcOHcOHMfBu317s3qCYs44jsO3 330H4K9Xiozp0cOHYd83b8F+O3sWRYsVw6FjR+Hh4UH3D5KnqEee/Mvs0DD25PFjVK1eDT49e9Ig JEL16tXjLl68iLp16+Lx48do06YN+vTpw6pXrw4AiDwdSdu8ko/69fgJAECzFs15rsS4bt64ydRq NUqVKkXLCQpMlapVAACxsbFGvd0d27azJg0a+t2+dQtflS2LiF9P+FNLKskP1CNP/iY+Pp4tWbQI HMchNDwcHEfjkFiVKVOGO3v2LDdnzhxYW1tj8+bNuPD7RQDAyV9P8FwdMXVqtRpnoqIAAE2bNfPn uRyjuvLHZQBAlWpVea6EfK7ixUsAAB48uG+U27t39y5r2+oHNqBvX7x48QKNmzbBkeMRXNFixcKN 8g0I+QhqrSF/M2FsANRqNbp1747qNWpQihc5iUSCUaNGcVevXkXDhg2RlN0vf/TwEajVap6rI6bs wrlzTKVSoWy5cjC3UGOYza1UmTa5Fhr3EsUBAA/uP8jV7WSkp2PGtGBWv+7XOBMVhUKFC2PF6tXY tXcvR+2oJD9RkCc5TkQcZ8eOHoWdnR0CpwVRiCc5PDw8uFOnTnELFy4EA/D69WucOnmSXs0jH3Ti RHZbTXPzaqsBgJTkrCe0BQsW4rkS8rnc3Nw4iUSCh4mJX9xSfPxYBKtbsxabHRaGzMxM9O7bF7// cZnr2LkTnTdJvqMeeQIA0Gg0GJ+9813A+PEoVLgwzxURU8NxHAYPHsyNGDkSALBvzx6eKyKm7Pix CADm1x8PAKnZr0w5FKCZV6GRyWQoWqwo1Go1nj550vNzvvb+/ftPf/Tpwbp07IgHDx6gYqVKiDj5 K8LnzqFZeMIb6pEnAIClixez2NhYlC5TBv0GDqBZBfJBvr1+ApC1FjO115D3uXL5D3b3zh04OTmh Tt26ZjeeJCcnAwBd6CpQhj75+/fvb/jY/9Vqtdi/dy/r4O3Nqleq7Hxg/37Y2tpixqxZOBkVyVWr Xt3s7t9EWMxnPTDyxZ4+edI8PCRr59ZZoaGQyWQ8V0RMWalSpbhKlSuzq9HROHXyJPvu++/pREb+ Zt3atQCArj7dzXI8MeytQLOwwqRUKgEAr169+uD/iY2NZRvXrceWzZvx4sULAIC1tTU6dOqEcRPG +xYpWnRjvhRLyEdQkCcInDw5Ii0tDT+0bo1GTRpTKCMf1badN65GR2Pfnj347vvv+S6HmJC3b99i 986dAIAff/qJ32LyiKEVlVb1EiaJVAoA0GVm/u3jarUaB/btZxvWrcPZM2dyPl65SmX82KsXOnbu zNna2uZrrYR8jAWyW2uoR16cLl64wHZs2w4ruRzTZ/18nO96iDC08fZG8NSgnPYaKysrvksiJmLX jh0sLS0NX3/zDTy9vMwy6drY2ADI2jyPCI9hczKdToe3b9/iwrnz7MTxCOzYtj2nbcrW1hYdO3fG j716oXKVymZ5PybmgWbkRUyv1yPAL2t555GjRsHd3b0FzyURgfDw8OAqV6nMov+MxqEDB1j7jh3p REcAAOuz22p8zXQ2HgCss4N82tu3PFdCvoRUmrXOx/RpwRjQtx/T6XQ5n6tWvTp+6t0L7Tt25Kyt rfkqkZBPRstPitj6tWvZ1ehouLm7YcSokRTEyGfp1acPAGDVipU8V0JMxdXoaPbnlT9RoEABtPVu a7Zjik12wEujGXlBMszI34+Ph0QiQe06deA3dizOnD+HE6dPcT18fSnEE8GgIC9SycnJmDEtGAAw feZMyBUKnisiQtOpcxfOwcEBF86fx43r16k3j2D92nUAgC7dusJKLue3mDxkbZMV8lRpFOSFSCLJ 6pEfMmwY7j98yB05HsFNmDyJK1+hgtk++STmK2f5SeqRF5eZwdNZUlISGjZqhNZtzXfmjOQdhbUC 3Xv4AKBZeQK8efMGO7dvB2DebTUAYG1t6JFP47kS8iWk2Re7epX2gsKaJrGIsNGMvAhdv3aNrVuz BhYWFpgVFsp3OUTAevftC47jsGPbNrx+/ZrvcgiPlixcxN68eYNv6tVD2XLlzHpywCZ7Rj6NZuQF ybBajSHQEyJkFORFaJz/WOh0OvQb0B9lvvrKrE+4JG95eHpyDRs3gkqlwi+bNtPLeiKVlJSExQsX AgDGTZzAczV5zzAjn5ZGF7sKUc6GXtnryRMiZDlBnlprxGHXjp3s3G+/oVChQgiYMIFCPMm1vv37 AwDWrFpF44hIzZ8zl719+xYNGzfGN/Xqmf24Qj3ywmbYCEpJQZ6YgZweeWL+VCoVpkyaBACYEjQV 9vb2PFdEzMG3333Hubq5IubePRzcv5/GE5F59vRppZUrVgAAJk2ZzHM1+cPGJmtTIOqRF6akpCQA gKOjI8+VEJJ71FojIrNDw9iTx49RrXp1dO/Rw+xnzUj+kEqlGOOftR/BhHHjaZMckZkTHh6dkZ6O 777/HtVr1BDFuEI98sKW/FeQd+G5FEJyjYK8SMTFxbElixaB4ziEzg6nrcWJUfX88UeuWvXqePTw IUJm/kyz8iKRmJAYsX7tOnAchwmTJ/FdTr6hnV2FizGGlJQUAEABpfIZz+UQkmvv9MjzWQbJaxMD xkGtVqO7jw+qVa9OKZ4YlUQiwex58yCVSrFsyRLcvnWLRhQRCJ01q7lGo0Ebb29UqFhRNOOKm7s7 AOBhYiLPlZDP9fr1a2RmZsLGxgaWlpZ8l0NIrlGPvAgcPxbBjh09Cnt7e0yZFiSaky3JX5WrVOZ6 9+0DrVYLv1Gj+S6H5LErl/9gW3/5BRKJBONFsFLNu0qULMkBWTuDEmFJSkpiAODoRP3xxDxQa42Z 02g0mBAQAAAIGD8ehQoV4rkiYs4mTpnCFXZ2xrnffsO2LVtpksBMabVaDBsyBDqdDoOGDkHpMmVE NUHg5OQEOzs7vHjxAm/f0hKUQpKYkAAAcHEpwnMlhBgHBXkzt3TxYhYbG4syX32FfgMHiOpkS/Kf vb09ps+cCQCYMnEiUlNTea6I5IV5c+awmzduoFSpUpg4aZIox5VSHqUAAPFxcfSEVUBi7t0DAHh5 efFcCSHGQevIm7GnT540Dw/J2rl1VlgoLCwseK6IiEHHzp24+g0a4MWLF5geNI0GFjNz5/ZtNjs0 DBzHYcGSxZArxLnFfYmSWUGe2muExRDkPUtTkCfmgXrkzVjg5MkRaWlpaN2mDRo2aiTKWTPCj/C5 cyCTybB29Wpc+eMKjTFmQq/XY/iQodBoNOjdty++/uYb0Y4rJUuWBADEU5AXlHuGGfnSpXmuhBDj oNYaM3XxwgW2Y9t2yBUKTP/55+N810PExat0aW7o8OHQ6/UYOmgQ0tJo4xxzsHL5Cva/33+Hq5sr AkV+4fxfrTUU5IUk5i611hDzQkHeDOn1egT4ZW3QM2LUSLi5u7XguSQiQn5jx3Kly5TBrZs3Mbj/ AEbte8KWmJAYETx1KgBg3oKFsLW15bcgnpUwzMjHxfFcCflUarUaiYmJkEqlOSsPESJ0Oa01dJI1 H+vXrmVXo6Ph7u6OESNH0mBFeKGwVmDztq1wcHDAgf37ERYSQoOMQGVmZmJQ//7NVSoVuvv4oEmz pqIfV0qWLBkOAPHxFOSFIi42lun1epQoUYLWkCdmg2bkzUxycjJmTAsGAAT/PFO0F6IR0+Dh4cGt XrcOUqkUITN/xuFDhyjMC9DEcePYud9+g7OLC6bP+ln0IR4AihYr5m8ll+PRw0fQaDR8l0M+wb27 dwEAntRWQ8wIBXkzMzN4OktKSkLDxo3Ruk0bOuES3jVp1pQLDAoCYwwD+/bDndu3KcwLyOZNm9jK 5SsAADY2Nrhy+Q/6+wHgOA7FixeHXq9HYkIC/U4E4PKlywCAsuXK8VwJIcZDQd6MXL92ja1bswYW FhYICQvluxxCcgwdMZzr1KUz3r59C58uXZGSksJ3SeQT/HH5MvMbOQoAoFQqERcbiw7e3mjfti07 eOAAS05O5rlCfpUqlXXB680bN3iuhHyK//3+OwCgdt06PFdCiPFQj7wZCfDzh06nQ7+BA0S30yIx fQsWLeKqVquKuLg49PnpJ6bT6fguifyHF8+fo2d3H6jVavTp1w83797hAqcFwd7eHqdPnoJvdx94 Fi/BGn5Tj00cP54dPHCAxdy7x7RaLd+l55satWoCACJPR/JcCfkYjUaDK1eugOM41Kpdm86PxGzQ DkFmYteOnez8uXMoVLgwxk2YQIMUMTlWcjk2/vKLf+MGDcNO/XoSQYGBbNr06XRfNUFarRY/9ujJ njx+jLpff42ZIbM4mUyGEaNGcT1//BGrV65kUacjcel//8O1q1dx7epVLF20GAAglUqZu7s7Snl6 wNPTEx6envDw8IRLERc4OTm5KB0dn8lkMp5/wk+XmpqK58+esadPn+L5s+d49vQpnj17hoSEBFz6 3/8AAFGRFORN3bWrV5k6IwOly5SBUqnkuxxCjIaCvBlQqVSYMmkSAGBK0FTY2dnxXBEh71e0WLHw jb9sDmvTshUWzV+AihUrsU5dOlOYNzHjxwawC+fPo5irK9Zt2si9G7wdHR3hHxDA+QcEICM9Hb// /js7G3UGf/xxGXExsUhMTER8fDzi4+Px6/ET/7zppwBgb28PJycnODo5wcnJCU4F33n/nY87OjrC 0cmJUyqVkEqlufqZ0lXpSE1Naf769euI169f43Xqa7x+nYrU1FQY/p2SkoLnz57h6dOnWYH9+XOo MzI+etsx9+7h6ZMnzV2KFKE9O0zU7xez22rqUFsNMS85QZ5aa4RrdmgYe/L4MarXqIHuPj4UiohJ q1W7Nhc2ZzYbMXQYhg8dipKlSrIaNWvS/dZELJw/n61ZtcrwCgoKFSr0wf8rVyjQoGFDrkHDhjkf 02q1SHjwgMXGxiI2JhZxsbGIiYnB40ePkPTqFZKTk7OC8+vXn7orKuM4DgUKFMgJ+Da2NtDr9NDp dDlHZmYm9HoddO98XJ2RkfO9MjMzv+j3obBWwMXZBYWdnVHY2RnOzs5wdnGGu3txVKhYAVMnT8Hx iAhERUZFdO7ahe7HJur3ixcBUH88MT8WyO6RJ8IUFxfHlixaBI7jEBoeDo6j8wgxfT1//JG7dvUa W7ViBTq09cbOvXtYzVq16M7Ls+VLl7HASZMhkUiwZNlSVKla5bP/JjKZDB6enpyHpyfw7b8/r9fr kZqaiqRXr9irV6/w6tUrJOW8Tfrbv1+9eoXkpCSkpKQgOTkZycnJiI2J+aKfTa5QwN7eHvb29nBw cIC9gz3s7R2yPuZg+HgBFC5cCM4uLobQzn1s46uGjRqx4xEROBMZic5du3xRbSTv5VzoSjPyxMxQ a43ATQwYB7VaDZ+ePVG1ejUKQkQwZobM4l6+fMn27t6NDm29sWPPbla7Th26D/Nk3Zo1bPzYseA4 DvMXL0K7Dh3y5G8hkUigVCqhVCqzwv4n0Ov1SE5Ozgn/6ap0SKQSSKXSfxwWkL7zcUsrK9jb23P2 9vbIq778Bo2yXo2IjDydJ7dPcu/BgwfRjx89QqFCheDh4UFjDDErFOQF7NTJk+zY0aOwt7fHlKCp NDgRQbGwsMDKNas5qVTCdu3YiY7e7bB99y5W9+uv6b6cz37ZvJmNyV5mcva8ufDp0cOk/gYSicTQ P8+Z2lY+5StU4BwdHdnDxIeIj49nJUuWNKnfHQEOHzhYCQDqv9MCRoi5+GsdeeqRF5xpgVMBAOMm TvzPPlZCTJVUKsWylSu5zl27IC0tDZ3atcdvZ8/SYJSPdu3YyYYPHgLGGH4ODcVPvXtTEP0MHMeh XoMGAIAztHqNSTqwfz8AoHWb1jxXQojx5awjT4Tnfnw8vipbFn3796MTLxEsqVSKJcuXc919fKBS qdC5QweciYqicSkfHNi3jw3q3x96vR5B04MxYNBAGku+QIOGWUE+KjKK50rIP714/hy/X7wIK7kc zVq0oPs3MTu0s6sAvbvC0KywUFhYUIcUETaJRIKFS5dwPXx9ka5KR5eOnRB5+jSF+Ty0f+9e1rdX b2RmZmL8pIkYNmIEhZwvZFi150xkJGijM9Ny+NAhptfr0aRJE9jY2PBdDiFGR0FegDKy1zVu4+2N Bg0b0smXmAWO4zB/0ULup969kZGejm6du+D0yVMU5o1Mr9djxrRg1sv3R2i1Wozx94d/QACNI7ng 6eXFlS1XDi9evMChAwfoPmtCDG01raithpipnCBP68gLw4Xz55lWq4VcLsf0mTM38l0PIcbEcRxm z5vL9enXLyvMd+mCw4cO0eBkJKmpqejaqRObHRYGqVSKmSEhmDhlMoV4IxgwaCAAYNmSpTxXQgxe v36NM5FRsLCwwPctW9L9nJgl6pEXEL1ejwA/fwDAyDGj4erm6stzSYQYHcdxCJszmxswaCDUGRno 2a07ZkwLZnq9nu/SBO3WzZusaYOG7ETEcRQsWBC79+/DwMGDKNwYSecuXTilUokL588j+s9oOq+a gKOHjzCtVotv6tWDUqnkuxxC8gS11gjI+rVr2bWrV+Hu7o4RI0fSCZiYtZ9DQ7npM2dCKpVidlgY Oni3Y69eveK7LMFhjOGXzZtZ88ZNEBcXh6rVquLUmajwevXr0xhiRHKFAr4//QQAWL50Cb/FEADA xvXrAQBt23nzXAkheYeCvEAkJydjxrRgAMD0WT/DSi7nuSJC8t7gYUO5vQcPoLCzMyJPnUKjevUZ 9c1/usuXLrEWTZqyoQMHQaVSoZtPdxw+dowr5uodJ2RrAAAWWklEQVTqz3dt5qhPv34bpVIpdu/c hRfPn/NdjqjduH6d/Xb2LOzt7dGpSxd60krMFvXIC8TM4OksKSkJjZo0xg+tW9OgRETj62++4SLP nqlcp25dPHr4EO3btkXPbt3Z/fv3n/Jdm6l68vhxz4H9+rEWTZri8qVLcHZxwfJVq7B42TKOJgHy jqubq2+r1q2h0WiwZvVqOqnyaPnSZQAAn549aLUaYtaoR14Arl+7xtatWQOZTIZZoaF8l0NIvnN2 cbm6//AhbsbPP8Pe3h6HDh5E3Ro1nacHTWMqlYrv8kxGZmYmFi9YyGpWrbZh+9ZtkMlkGDFqFC79 eYXr1KUzTQDkA8NFr2tWrYZGo+G5GnFKSkrCzh07IJFI0HfAAL7LISRPUWuNAAT4+UOn06HfwAEo XaYMnYyJKFlYWGDQ0CHc//68wvXw9YVGo8Gc8HDUqlad7dm1S/QTEpGnT7P6db9mkydOhEqlwrff fYdz//sdgdOCOJqRzD91v/6aq1S5Ml48f449u3aL/n7Jhw3r1rGM9HQ0b9ECJUuWpHMmMWsU5E3c rh072flz51CocGEEjB9PAxIRvUKFCmHB4kXcidOnUaNmTTx+9Ah9fuqF1t+3FG27zcRx41i71m1w 5/ZteHp5YdfevdiyYztXqlQpGjN40D97Vp4ues1/Op0Oq1euAgAMGDSI52oIyXs5rTXUI296VCoV pkyaBACYOm0a7OzseK6IENNRtVpV7tivJ7jFy5ahsLMzfjt7Fj5dujqnq9L5Li1fRf8ZzZYtWQor KysETQ/GbxcvcI2bNqEAz6MOHTtyBQsWxJ9X/sTFCxfo5JqPdu3YyR49fIjSZcqgUZPG9DggZo9m 5E3Y7NAw9uTxY9SoWRNdu3ejAYmQf+A4Dt18unP/u/IH91XZsrh18ya2bvlFVMFpysSJYIxhwKBB GDZiBCeTyfguSfSsrKzwU+/eAGiDqPyUlpaGoMBAAMDI0aN5roaQ/EFB3kTFxcWxJYsWQSKRICQ8 HBxHOZ6QD7Gzs0P7jh0AAPfu3uW5mvyTkZ6OC+fPAwB69+t7nOdyyDt69+3TQiaT4eD+/Xj08GEY 3/WIgWHyq2atWujSrSudNIkoUJA3URMDxkGtVsOnZ09UrVaVBiRCPuJMZBQAoMxXX/FcSf6RKxSo XacOAODK5cvNeS6HvMOlSJHjbbzbQqfTYfmyZX5812PuYmNjcya/QmfPpskvIhp/9cjTKpQm4/ix CHbs6FE4ODhg8tRAGo0I+Ygtm39hZ6KiYGNjg3YdOojqMdOkWVMAwIb166HT6XiuhrxryLDh4DgO K5ctR1xcHJ1k89D4sWOh0WjwY69eqFylsqjGACJuNCNvYjQaDSYEBAAAxk2ciIIFC/JcESGm7djR o2zMqFEAgNnz5sHe3p7nivJXG29v2NnZ4dSvJzFy2HBGCxeYjipVq3Dde/SAWq3GOH/aTDevHD1y hJ2IOA5HR0dMCpxCIZ6ICgV5E7N08WIWGxuLsuXKoU+/vjQgEfIfNm/axHp2646M9HT0G9AfnbuK byv2UqVKcdt27YTCWoHNGzdi0vjxlORNSOC0IK5AgQI4EXEchw4epL+NkanVakwYmzX5NSlwCpRK Jc8VEZK/coI8zeLw7+mTJ83DQ7J2bp0VFgoLCwueKyLEdM2dPZsNGzQYmZmZGDVmDELCw0UX4g3q 1K3Lbd6yFVZWVli6eAnGjBzFqM3GNBQsWBATp0wGAEwICIDYlkfNawvnz2f3799HlapV4PvTT6Id A4h45fTIE/4FTp4ckZaWhrbt2qF+gwY0IBHyHnq9HuP8/Vnw1CBwHIefQ0PpWhIAjZo05tZv3gSF tQJrV69G106d2Nu3b/kuiwDo1acPV6lyZSQmJCIsJITOuUZy4fx5FjYrBBzHIXT2bEgk1GRAxIfu 9SbiwvnzbMe27VBYKxA8Y8ZGvushxBRpNBr0692HrVi2HJaWlli1dg0GDBoo+hBv0OLbb7mDh4+g sLMzfj1+At81a84eJj7cwHddYieRSBA2JytoLpg3D78eP0FhPpcePXwY9qNPD2i1WgwdPhw1atak cYCIEgV5E6DX6xHgl3Uh1MjRo+Hq5urLc0mEmJy0tDR06diJ7dm1Cw4ODti2a6foVqj5FFWrV+NO nDq1sWy5crh54waaNW7c88ofVyg48qxmrVrcxCmTodfr0b9PHyQkJETwXZNQZaSno0e3bn4vXrxA 0+bNEDgtiMYBIlrUI28C1q9dy65dvYrixYtj+IgRNCAR8g8vX75Em5YtWeSpU3B2ccGhY0fRsFEj eqx8gKubq+/RE8e5Js2a4vmzZ2j13XeIPH2aBnmejRw9mmvZqhWSk5PxU48ezdVqNd8lCdKwIUNY 9J/R8PD0xKq1azlqqSFiRj3yPEtOTsaMacEAgOmzfoaVXM5zRYSYlsSExIjvm7dgV/64Ag8PDxz7 9cTxcuXLU4j/CDs7O2zdsYPr4euLjPR0+HTpikv/+x+N9zziOA5LViznPDw88OeVPzF6xAhaLvQz zZ87l+3asRP29vbYsn0bHBwc+C6JEF7R01iezQyezpKSktC4aRO0+uEHCieEvOPWzZvs22bNmsfG xKBK1So4cuI45+7u3oLvuoTCwsIC8xct5Lp27waVSoXO7TvgxvXrlBx5ZG9vjw2/bIa1tTW2bP4F QwcNohWGPtHxYxEseGoQJBIJVq5ZA08vLzpnEtGjIM+j69eusXVr1kAmk2FWaCjf5RBiUl48f46O 7drj6ZMnaNioEfYfPszRBmmfj+M4LFyyhGvdti1SUlLQvq03Xjx/zndZola2XDlu89YtOWG+b6/e TKvV8l2WSYs4doz18vWFXq/HlKCpaP5tCwrxhIB65HkV4OcPnU6H/oMGwqt0aRqUCMmWmZmJ3j/+ xJ48foy6X3+Nbbt2cra2tnyXJVhSqRQr16zmGjVpjBfPn2NG8HQa8HnWsHFjbvf+fbC3t8e+PXvg 292HqTMy+C7LJK1asYL5dOkKlUqFXn36YPjIkXS+JCQb9cjzZNeOnez8uXMo7OyMgPHjaVAi5B1T p0xhv509C5ciRbB2w3oXS0tLvksSPEtLSyxcvDhcrlBg04YN1GJjAmrVrs3tP3wITk5OOHb0KBrV b8BohaG/6PV6TBw3jo0d4we9Xo/JUwMxe95cOl8S8g5qreGBSqXClEmTAABTp00DzTQS8pfLly6x JQsXQSaTYd3GDSjs7PyM75rMRTFXV/+hw4ZBr9cjeGoQ3+UQAJUqV+YOHTuKMl99hTu3b+Pbpk0x Y1ow02g0fJfGq3RVOny7+7Cli5fAysoKK9esxqgxYyjEE/IPFOR5MDs0jD15/Bg1a9VCl25daWAi 5B2JCQkAgO9atkSt2rXp8WFk/bM30Pr94kW+SyHZSpcpw50+e4YbMWoUGGOYHRaGJg0asqjISFHO zt+5fZv98P137PChQ1Aqldi9fx/ad+xIYwEh70E98vksLi6OLV64EBKJBCHh4eA4GpsIeVdSUhIA wNHRkedKzFPBggXh6OiIlJQUuujVhFhZWSFwWhB39MRxeJUujZs3bsD7h9Zo3rgJO3L4sCiWqbxz +zbr81Mv9k3tOrjyxxWULFkSESd/Rd2vv6YTJSEfQD3y+WzC2ABoNBr08PVFlapVaHAi5B+Sk5MB AJaWMp4rMV/FS5YAkDWxwGsh5F+q16jBRf12lhs/aSIcHR1x+dIl+HTpinp16rJtW7aydFU63yUa 3bsBfs+uXZBZWmLg4EE4fvoU5+HpSedJQv4Dp7S1mwlg/OSpgdR/lseOH4tgXTp2hIODAy5F/8k5 OTnxXRIhJudMVBRr2+oHOLu44OrNG5xMRoHe2Mp4eLIXz5/jyvVrV4sXL16Z73rI+6lUKqxfs5Yt WrgQTx4/BgBYW1vj+1Yt0a5DBzRt1oyzsrLiucpPl5Gejvj4eBYXF4e42Fj8v737D266vuM4/kpS mtImEWhLoojQH8wTsEVPRPnl1Lag+8dfU5z8qCJOGQqllDIssFFw/Ki7211lf8yjIvMXP8TN4WzZ P+4OisoGtHDnhASH2ia0pZA0RSLpd3+0FJmgUFrStM/HXS/J95s07+Su377vk1feX/dhtw4fOqTd lZVqaWmRNS5OuU/mat78+ZlOl6sq0vUC3dkAu8OQaOSvmlAopHG3jzHcbrdWrV2rZ579Je81cBET 7hxrHDxwQH9av14P/5xsbGeqq6vTjalphs1m039rvjYR7+v+QqGQ3n7zTWNDWZn2/ntv+3aHw6Gc yZOUkpIqp8spp8sll8slp9O1caBz4PSunvZ0qvmUmpoCCjQ1GU2BgJqamlp/2q6fOHFCRzxHdMTj kdvtVs3XX18wxmu1WjU9d4by8vNzXNdeu6NLiwZ6iLONfIzaojW9IX8XSX985RXD7XZr+IgRmjnr af5zAj/g2dnP6fnZv9KaVauUlZPNadg70e5duwxJumn4cL6jEyViY2M1PTfXND03V1988YV329at zm1b39WB6mpt2bT5Qg+ZZjKZpg0YMEBOl0tOl1N94/p26LkNw1DzqVPtzXkgEFBTIKBgMKjLPSNt bGyshgwdqrS0NKWmpyktLU1p6ekaMXIkn1ADHWTqb7OvlLS4aNlSzV+wgKN6F/DW1maPvuXWimAw qL9+sF3jJ0zgfQZ+wOlvvtH4O8ca7sOHNXbcOG19b5vJGhcX6bKiXt2xY5o4brzh83rFMT/6HT50 yPjnRx/JW+uVz+eTz+uVz+eV1+tTfV3dZTfal8saFye7zSabzSab3d52aZPN1nrd7rBryJChSk9P V2p6mm/w4MEui8XSpTUBvcV3V+TRxZYWFVUEg0E98NBDNPHAJbDGxWnrX97bMTkrO3vXzp2a9dRM o2zj6yaagI47c+aMnpn5tOHzejV+wgTNzcvjWBTl0ocNM6UPG3bBfS0tLaqvq3P6fD6vz+vT6dDp Dj2HyWRSfN/4tgbdJpvNvtFmt0232WyKiaGFACKt/a+QaE3X2F1ZaWzZtFl94/uqeOWKkkjXA0SL G264IWfLtneNn02arL+9/75mPDHV+MMrpXwE3wGffvKJMX/uPB08cEDJAwfq1bL1rIz2cGazWQOd Tt9Ap9N0c0akqwHQVRg/2YVaWlpUuKBAkpSXn69B119fEOGSgKgyfMQI05ub3pHD4dAH27dr7O1j jA+2b+eYdYlOnDihvBfmGpOzsnXwwAENvmGwNr75BmfLBYAegjO7dqENZWVGdVWVhg4dqufnzuVj bKAD7hw71rTz490ld919t+qOHdPUKY9rzrPPGbU1NdMiXVt39eknnxhz5zxvZNw03NhQVqY+ffoo v6BAH+/ZY+JsuQDQc5j62+wrJL344tIlyi8o4ADfSRobGzV61C3G8ePH9cY7b+u+++/nvQWugGEY Wv/qq8ayoiVqbm6WJN2ckaHsnBxlT8rRbaNH9+oM/TGfz/n2W29539j4Zx36/PP27fdk3avVJSVK S0vjGAQAPcT3vuxKRr5zrVxebBw/flz3ZN1LEw90ApPJpJmzZpnuycoyVi4v1j8qKlRdVaXqqir9 vqRECQkJRlp6ulJSU5WSkqLUtFQNTUlRampqwbXXXVfSk0YthsNh/eezz4z9+/Zr/7692rd3n/61 Z0/7lJLkgQP12ONTNHXaNP3kxht7zgsHAJzH1N9mL5ZUtHhJkRYsXMgBvxMcqK427p4wUWazWTs/ 3q30YcN4X4FO9u2332p3ZaVR/uGHKv/7h3IfPnzR+1rj4pScnCS73SGHwyG7wy6H4xrZ7fbv377G 0bb9mrbtDpPDbtfVGn958uRJ1dfVGfX19aqrq1N9Xd13Luv15dGjOnjwoL45deq8x8XExChn0iQ9 MX2asnNyTEwUAYCei/GTXahwQYHC4bBmz5lDEw90kT59+mjCxImmCRMnasVLL6mhoUFHPB7D4/bo yBGPjng87WeVrK+v11dfftXRpzKk1pPZnGv8HUpISJDUujoeDofV0hJWONyicDisM2fOtG5r2xf+ zr72be37Ws7bdilMJpNSU1OVMWqUMjIzlJk5SqNuvcXUv3//jr5GAEAUopHvZFs3bzEqd+2S0+VS waJCmnjgKklMTFRiYqLpttGjv7evqalJDQ0N+wN+f4bf71cgEFDAH5Dff1KBQED+k23bAv4LXvf7 /QqFQmpoaFBDQ0OXvg673a6kpCQlJScrOTlZiUlJSk5OVlJyspKSkjTo+kEaefPNJrvd3qV1AAC6 PzLynai5uVlLi4okSb9Zvlw2my3CFQGQ1HYiG1vmlfyO06dPn23qjYA/oGCwSWazWRaLRRaLRWaz RRbLudsWi0Xm1ssqi9my32Ix77BYLBVmi8X33ftYzOaz91Nv/rIuAODyxYg58p2mZPUao7amRreP GaNHpzzGajzQg1itVlmtViUlJfG3DQDoFpgj30k8Ho+xrrRUZrNZq0tK1JMmZAAAAKD7oZHvJIsX FioUCmnajBnKHJVJFw8AAIAu1d7Ik5HvuB3lFUZFebn69eunomVLaeIBAADQ5cwiI39FQqGQFhcW SpJ+XVSkxMTECFcEAACA3oBozRVaV1pquN1uDR8xQk89PZPVeAAAAFwVNPJXwFtbm/3ymrWSpNUl axkdBwAAgKuGjPwVWFpUVBEMBvXgww9r3PjxrMYDAADgqiEj30G7KyuNLZs2Kz4+XsUrVxREuh4A AAD0LkRrOqClpUWFC1p797wF+bpu0KCSCJcEAACAXuZcI8+6/CV7bf16o7qqSikpKZrzwgtEagAA AHDVEa25TI2NjVq5vFiStHL1Klmt1ghXBAAAgN6IaM1lWrm82GhsbNS92VmafN99rMYDAAAgImjk L0N1VZWxoaxMsbGxWrVmTaTLAQAAQC/G+MnLsKhgocLhsJ6dPVtp6emsxgMAACBiyMhfoi2bNhuV u3bJ6XKpYFEhTTwAAAAiimjNJWhubtayJUskSb8tLlZCQkKEKwIAAEBvRyN/CUpWrzFqa2o05o47 9OiUx1iNBwAAQMSRkf8RHo/HWFdaKrPZrNUlayNdDgAAACCJjPyPWrywUKFQSNNzc5WRmclqPAAA ALoFojU/oKK83KgoL1e/fv1UtGwpTTwAAAC6DRr5iwiFQlq8sFCStHhJkQYMGBDhigAAAIBzyMhf xLrSUsPj8WjEyJF6cuZMVuMBAADQrZCRv4DampppL69p/WLr6pK1slgsEa4IAAAAOB/RmgtYtmTJ 68FgUA898ojGjhvHajwAAAC6HRr5/7O7stLYsmmz4uPjtXxFcUGk6wEAAAAuJObsFTLy0hGPx5j6 +C8kSTExMXr4gQfXSmJ4PAAAALqdGJGRb7eh7DUdb2iQJPn9fvn9/ghXBAAAAFxYzI/fpfdwOByS pCFDhuiFvHkRrgYAAAD4vvx5eZJo5M8z8ad3SculpORkRk4CAACgW8qfl2dIzJEHAAAAohJz5AEA AIAoxPhJAAAAIAoRrQEAAACiENEaAAAAIAoRrQEAAACiEI08AAAAEIXIyAMAAABRiIw8AAAAEIWI 1gAAAABRKCbSBXRHoVBIR48erYh0HQAAAMDFmPrb7Isk/S7ShQAAAAC4dKzI905BSfWRLgIAAAAd 9z+WHsdeB6iLUwAAAABJRU5ErkJggg== ";
  var imagenFondo = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAvIAAAILCAYAAACKBnidAAAABHNCSVQICAgIfAhkiAAAIABJREFU eJzs3Xd0VPXWxvFvkkklEnrvoVcBeQEpgvTelF4EVBQsFwtY8FoAlaYiFvqlw71Kk14UUBQIXVCk SC+hQxLSk3n/CBNB6ZmZ35nk+ax110JJzu/JlZA9e/bZxytr8EPTADs3s9/m1/o9a/zeYMAfERER EcmottiAXqZTiIiIiIjI/bE5fvHF+K9v+g273X7jP9z29+wu+L27f+yDft69fU13vQ5mv/5PRo0m Li6OIydPEBISgoiIiIhkDNu3baNR/ceBGwr5rt26GQsk9+fLz8cRFxdnOoaIiIiIGORtOoCIiIiI iNw/b/55g6WIiIiIiFhcakf+73PYIiIiIiJiXRqtERERERHxQCrkRUREREQ8kGbkRUREREQ8j5dm 5EVEREREPISXl1fqrzVaIyIiIiLigVTIi4iIiIh4IM3Ii4iIiIh4IM3Ii4iIiIh4II3WiIiIiIh4 IBXyIiIiIiIeSDPyIiIiIiKeR3vkRUREREQ8hRfaIy8iIiIi4tFUyIuIiIiIeKDUGXmN1oiIiIiI eA515EVEREREPJAKeRERERERD6T1kyIiIiIinkfrJ0VEREREPIaX1k+KiIiIiHg0FfIiIiLicna7 nWvXrpGcnGw6iki6YUMz8iIiIuIkly9fZse27WzbtpXt27Zx6MBBrly5QmRkJElJSXh7e5MtWzay 58hBsWLFaN6yBU2bNyd79uymo4t4HJvjF5qRFxERkQdx/PhxZk6bzqIFC/jzzz9v+3GZMmUiNjaW CxcucOHCBfb/8Qcrli/Hx8eHGjVr0qJVK1q0bEnBQgXdmF7Ec9nu/iEiIiIiN7Pb7axYvpxpU6fy w9rvU0dm/P39KV+hAo9Ue4Sqj1SjYqWKZM+Rg5CQEGw2G3a7nYiICC5cuMDGH39k2dKl/LThR37e uJGfN27krcGDqV6jBiNGj6JipUqGv0oRa1MhLyIiIvfl0qVL9H+2H6tXrQLAPyCA9h3a06NXL6pU rYqfn99tP9fLy4uQkBBCQkIIDQ2lV+/eREVFsXb1apYvW8bqlavYsnkzDR6rx/MvDOCtt98mIDDQ XV+aiEfRHnkRERG5Z2FbtvBYrdqsXrWKkJAQ3h82lN/2/8GX48dTo2bNOxbxtxMcHEzb9u2ZOGUK e/f/Qb/nn8Nut/PF2M9p36YtV69edcFXIuLx/tojj2bkRURE5A72/PorrZo159TJk1SpWpX1P2/k xZdfJlu2bE47Izg4mI9GjmTNunUULlyYzZs20bJpMy5cuOC0M0Q8mZf2yIuIiMj9iI+P5/ln+5GQ kEDXbt1YsWY1hQsXdtl5latUZsWa1ZQsVYrf9u7lXy+86LKzRDyVCnkRERG5qxEffsTvv/1G8RIl GPPZp/j6+rr8zDx587J46RJCQkJYvmwZC+fPd/mZIp5EM/IiIiJyR8nJyUyaMAGAL77+Cv+AALed nTtPHoZ+OByAIW+9rXXZIjdI7cjrG0NERERu5cD+/URFRZG/QAH+r3p1t5/fvWdPihUrxpnTp9m5 Y4fbzxexKo3WiIiIyB1t37YNgOo1ahjL0KRZUwBWr1xlLIOI1aiQFxERkTvav38/AOXKlzOWoUzZ sgCcOnXKWAYRq9GMvIiIiNxRzpw5Abhy+YqxDPHx8QAPtKdeJJ3yumFG3mQOERERsaq8efMBcPZs uLEM0deiAQgIdN+NtiJWpD3yIiIics/y5ssLwJnTZ4xl2LVrFwDlypc3lkHEajRaIyIiIndUsmRJ vL29CQsLIyoqykiGzZs2AVDdwNYcEav6a7RG9byIiIjcQs5cuXi0Vi3iYmNZsWy5288/dPAgp0+d Ilu2bIQWL+7280WsSqM1IiIiclftn+gAwKIFC9x+9pRJkwBo3rKl288WsTIV8iIiInJXrdq0wWaz 8cP333Plivu210RERDBrxkwA+r8wwG3ningCzciLiIjIXWXPnp0mTZsSFxfHuM/Guu3cmdOmc+3a Neo3eJzSZcq47VwRT3DD+knV8yIiInJ7b7z9Ft7e3oz/+ivOhrt+FWVSUhITJ4wHoP+AF1x+noiH 8dJojYiIiNyTcuXL0+HJJ4iJjmHERx+7/Lyl333HieMnKFW6NI83bODy80Q8wQ1r5DUjLyIiIvfu zSFD8PX1ZdaMGfx56JBLz/rqiy+BlNn4Gx+CIyIpNCMvIiIi96xIkSL06t2bxMRE3nvn3y47Z8P6 9WwNCyNHjhx07NTJZeeIeDLNyIuIiMh9eW3Q6wQGBbJs6VJ2bN/ukjM+eO89AF4eOBD/gACXnCHi 6TRaIyIiIvclV+7cPP3MswAMff8Dp19/yeLF7Ny+g7z58vH0s884/foi6YUKeREREblvL78ykODg YDasW8fGn35y2nWTkpIY9sFQAAa9MVjdeJE70Iy8iIiI3Lds2bLx/ICUBzR9OmaM0667bMkSDh44 QLFixejWo4fTriuSHmlGXkRERB5Iv/7P4+3tzS8//0JcXJxTrvnD9z8A0KtPb2w2m1OuKZJOaY+8 iIiIPJhs2bJRrnx54mJj2b5tm1Ou+eP69QDUqfuYU64nkt7cuIpVhbyIiIg8sFq1awE4ZU7+xPET HD16lJCQECpWqpjm64mkd5qRFxERkQdW89FHAdi2dWuar7U1bEvqNb291WsUuRvNyIuIiMgDy5I1 KwBxsWmfkY+9PmefNVvWNF9LJCPQy10RERF5YMnJyQDqoIsYoO86EREReXCOd/RvuAFPRNwjdUZe ozUiIiJyv5KTU+oHb28V8iLupo68iIiIPLBr0dcACPBP+xNYbT4pe+Pj4+PTfC2R9OqG9ZPaIy8i IiIP7ujhIwAUKVokzdcqULAAAMeOHkvztUQyAq2fFBERkQf2559/AlC0WLE0X6vY9Wscvn5NEbkz rZ8UERGRB+YouosVC03ztXLnyUNgUCCXLl3i6tWrab6eSHqn0RoRERF5YKkd+dC0d+S9vLwoWvR6 V/6QuvIid6NCXkRERB5IbEwMZ06fxmazUbBgQadcM3W85vBhp1xPJD3TjLyIiIg8kMOHD2O32ylU qBA2m80p1yyaWsirIy9yN5qRFxERkQdy/PhxAAoXLeK0axYuUjjl2seOO+2aIumU1k+KiIjIgzl1 8iQA+fMXcNo18+XPD8Dp06ecdk2R9OSGPfKakRcREZEHc/rUaeCv/e/OkP96IX/qpAp5kbvRjLyI iIg8kFOnrnfkC7igI39KhbzI3WhGXkRERB5Iakf+evHtDNmzZ8c/IICoqCgiIyOddl2R9EijNSIi IvJAUmfkndiRB8ifL99N1xeRW1MhLyIiIg/k9OmUjrwzb3aFv14YODr+InJrmpEXERGR+3bhwgXi 4uLIli0bgUGBTr12vvzXO/Kn1JEXuRPNyIuIiMh9c2yVcfZYDfzV4VdHXuSOtEdeRERE7p9jz3sB FxTyf3XktblG5O+0R15ERETSxFU3ut54TY3WiNxZ6oy8RmtERETkXv01WuO81ZMO+a5vrdFojcid qSMvIiIi9+2v0ZqCTr/2X1trNFojcicq5EVEROS+ubIjny1bNgICA4mMjNRDoUTuQIW8iIiI3LfU GXkn75B3yJ86XqOuvMjtaEZeRERE7lv42bN4eXmRN19el1w/T96U6549e9Yl1xdJD9SRFxERkfsS FxtLXGwsmTJlwmazueSMkJAQACIiIlxyfZF0QHvkRURE5P44iuvM14ttV8gckvmms0Qkxd/3yGum RkRERO7Z1atXAcicObPLznBcO+KqCnmR2/mrI68ZeREREbkHqR15lxbyjtGaqy47Q8TTabRGRERE 7svVKynFdUgWF47WZNZojcjdqJAXERGR+3L16hXAxR35EI3WiNyNZuRFRETkvvw1WqOOvIhJqR15 7ZEXERGRe+Gem101Iy9yNxqtERERkfviGHdxjL+4gkZrRO7KyzVPcRCRDC8xMZFff/2VPXv2EB4e ztmzZzl79iznzp0jJiaG+Ph44uPjSUhISP31rf6dj48P/v7++Pv74+fnd9dfO/7Z29ub+Ph44uLi iIuLu+2v//7PCQkJ2Gw2/Pz88PX1xc/P76b/3fjv/P39yZYtG3ny5CF37tzkzp2b4sWLU61aNZd2 KkVMc3TkQ1y5R16jNSK3dOMeeRuakRcRJ1qwYAGfffYZ27dvJzo6Os3XS0xMJDExkWvXrjkh3b1J SEggISHhgT/f29ubsmXL0qJFC4YOHYqvr68T04mY5xh30Yy8iFmpHXnNyItIWn377bd07Ngx9e+T UqVKUa1aNQoUKECePHnImzcvuXLlSu1q36rj/fd/n5SUdNeu+q067MnJyffVwXf82tfXl8TExHt6 xyAhIYHLly9z+vRpzpw5w+nTp/n999/Zvn07e/fuZe/evRw/fpw5c+YY/i8j4lyO9ZOuHa1xzMir kBe5HY3WiIjTfPjhh9jtdt5++20GDhxI9uzZ03xNm82GzWYjU6ZMTkh4b3x9ffH19X3gM+Pi4li/ fj3t2rVj3rx5fPDBBxQvXtzJKUXMccfNrkFBQdhsNmJjYkhISNA7WyK3oJtdRcQpEhIS2LVrF97e 3rzzzjtOKeI9lb+/P02aNKFFixbY7XZ27dplOpKIU7njya4ADz300E3nicjNtEdeRJzi7Nmz2O12 cubMib+/v+k4lpAvXz4AwsPDDScRcS533OwKmpMXuRvtkRcRp3AUq/nz5zecxDpy5MgBqJCX9CfC MVrj6kLeMSevFZQit6TRGhFxCj8/PyBly4zcTI0SSU+Sk5OJiorC29ub4OBgl571V0deD4UScbhh /aSXCnkRcYrixYvj5eXFwYMHVbhet2/fPgBKlChhOImI80RERGC32wkODr5pn7UrhGhzjcgdpc7I 6weviKRFUFAQ+fPnJyYmhpMnT5qOYwkq5CU9Sr3R1YWrJx0eynz9ZleN1ojckjryIuI05cqVA2Dp 0qWGk5h37tw5fv/9d2w2G2XKlDEdR8RpoiIjAXjoIdcX8sHBKYX8tWtRLj9LxBOpkBcRp+nbty8A n3zyCcnJyYbTmDVu3Dji4+Pp2LEj2bJlMx1HxGkcT1l29Xw8pLzTd+OZInIzFfIi4jTt27enaNGi HDp0iEceeYR169aZjuR2p06domfPngwfPhyAV1991XAiEee6FpVSVGcKdv1D2hxnOM4UkZtpRl5E nMbHx4dJkyZRpEgRdu7cyeOPP069evX47LPPOHjwoOl4LnPlyhW++eYbevfuTcmSJZk5cyb+/v4M HTqUKlWqmI4n4lTXoq935DO5viPvOEOjNSK3ZjMdQETSlwYNGrBv3z5Gjx7NRx99xIYNG9iwYQMD Bw6kRIkStGjRgieffJKaNWu6fOOFKx0/fpxvv/2WRYsWsWnTppvWbrZr145PPvmEIkWKmAso4iKO 7njwQ64v5B0d+Sh15EVuSaM1IuJ0AQEBDBkyhGPHjjFz5ky6d+9Orly5OHjwIJ999hm1atWiUKFC vPLKK5w9e9Z03HuWlJTE+PHjqVGjBkWKFOHVV1/lp59+wsvLi/r16zNq1Ch+++03FixYoCJe0i1H dzyTGzrymVI78irkRRxu3CNv4/pojYiIs+XIkYPu3bvTvXt37HY727Zt45tvvuGbb77h6NGjfPrp p0ybNo2pU6fStm1b03Hv6Pjx47Rt25adO3cCKTf6Od5daNy4MQ899JDhhCLukTojn8mdM/IarRG5 ldSOvGbkRcSVvLy8qFatGiNHjuTIkSOEhYXRrFkzLl++TK9evThx4oTpiHfUu3dvdu7cScGCBZk9 ezbnzp1j3rx5dOjQQUW8ZCipM/LuGK25/mJBHXmRW9NojYgYUa1aNZYvX06bNm2IiIhgwoQJpiPd 1p49e/jhhx/IkSMHO3bsoGvXrgQGBpqOJWKEo6h2x2iNY8WlbnYVuTUV8iJiVJ8+fQDYuHGj4SS3 58jWrFkzcuTIYTiNiFmpN7u6Y/1kJt3sKnInqesnRURMqFWrFl5eXoSFhREfH286zi399NNPANSp U8dwEhHzoqPd+UAojdaI3MkNM/ImY4hIRpU9e3ZKly5NTEwM27dvNx3nlhyFfO3atQ0nETEvKvL6 1ho3FPJZs2UF4NKlSy4/S8QTabRGRIxzdLqtOF5z9OhRTp48SY4cOShdurTpOCLGhYeHA5ArV26X nxUcHEyWLFmIjYnh/LlzLj9PxMN4qZAXEeMcnW4rFvKObrxjBEgko3NsmCpQsIBbzitYqNBN54pk dDf+LNKMvIgY5yjkf/75Z8utwtV8vMhf4uLiOH/uHAGBgW678btgwYIAHD92zC3niXgS7ZEXEeOK Fi1Kvnz5uHjxIn/88YfpODdxvEugQl4ETp06hd1up0AB93TjAQoWSink1ZEX+SeN1oiIJVhxTv7C hQvs27ePoKAgqlSpYjqOiHEnjh8H/iqu3aFgweujNcdVyIv8nQp5EbEEx3iNY5TFChwvKmrUqIHN ZjOcRsS8kydPAlCggPsKeccsvkZrRP4pdUberlF5ETHIije8au2kyM1OHHN/R75EyZIA7N27V2PA In+jjryIWELFihXJnDkzR44c4fTp06bjAPDLL78Amo8Xcdiwfj0AJa8X1+5QpmxZihYtyulTp9i+ bZvbzhXxBCrkRcQSvL29qVixIgC//vqr4TQp9u3bB0ClSpUMJxEx78zp04Rt2UJgUCANGzd269mt 27YFYOGCBW49V8TitEdeRKzD8cCl/fv3G06S8tCbq1evkjVrVnLmzGk6johx3y3+DrvdTuMmTQkK CnLr2W3btwdg8cJFGq+RDO+We+T1jSEippUqVQqwRiHvyODIJJLRLV64EIB27du5/exKD1dKHa+Z M2uW288XsSp15EXEMhwd+QMHDhhOQuo+exXyIjBz+nQ2b9pEpkyZaNykiZEMA197FYDXBr7Czu07 jGQQsRoV8iJiGerIi1jP+h/W8eq/BgLw6eefExAYaCRH9549efrZZ4mLi6NHt26cDQ83kkPESlTI i4hlFCtWDD8/P06dOsW1a9eMZlEhLwK7d+3mqR49SExM5LVBg3ii45NG83w44mMeq1eP06dO0bJZ c86dPWs0j4hpmpEXEcvw8fEhNDQUu93OwYMHjWZRIS8Z3c7tO2jbsiURERG0adeON4e8bToSNpuN /8ycQYWKFfnz0CHatmrNxYsXTccSMUYdeRGxFCtsromLi+Po0aP4+PhQvHhxYzlETNm2dSvtWrfm 6tWrtGrdmolTJt+0KcOkLFmysOC7xZQpW5Y/9u2jfes2XLlyxXQsESNUyIuIpVhhTv7QoUMkJSVR uHBh/P39jeUQMWHzpk20b92GiIgI2j/xBFOmT8PX19d0rJtkz56dRUu+o0TJkuz59Vc6tG1LTHSM 6VgibnHDi2qv1NEaERErsEJHXmM1klGdP3eOHl26EhUVRacunZkweRI2m810rFvKmSsXi5cuoWjR ouzcvoN333nHdCQRt0vtyGtGXkSswFE8m1xB6Vg96XhRIZJRvNh/ABcvXqRZ8+Z8OX48Pj4+piPd UZ68eZk6Ywa+vr5MmTSJ9T+sMx1JxK00WiMilqKOvIgZM6ZNY/WqVeTIkYOxX36Bt7dnlAiVHq7E 628Mxm6380L//ly9etV0JBG38YzvUhHJMLJkyUKuXLmIjIzkzJkzRjKokJeM5siRI7z9xpsAfPL5 WHLkyGE40f0Z+OqrVH3kEU6fOsVbgwebjiPiNpqRFxHLcRTQhw4dMnK+Y/VlyZIljZwv4m7vDXmH a9eu0alLZ1q2amU6zn3z8fFh/ORJ+Pv789+58zh69KjpSCJuoRl5EbGcAgUKAHD69Gm3nx0XF8el S5fw8fEhT548bj9fxN2OHTvGsqVL8fPz470PPjAd54GFhobyxJNPkpyczNdffGE6johbaLRGRCwn b968gJlC3jHOkydPHo+ZERZJi4lff01ycjLtn+hAbg9/8TrgpRcBmD1zFpcvXzacRsT19FNKRCzH UcibmJEPDw+/KYNIehYVFcWsGTMBeH7AAMNp0q50mTI0aNSQ6Ohopk6ebDqOiGvcao+8RmtExCpM FvKOM/Ply+f2s0Xcbd6cOURGRlKnbl0qVKxoOo5T9B/wAgBzZ802nETE9dSRFxHLscJojTrykhFs WLcegC7dupkN4kS169YhMCiQw4cPc/b6O2wi6ZUKeRGxHHXkRdxjy+bNADxau5bhJM7j6+vL/1Wv AcDmTZsMpxFxLRXyImI5Vijk1ZGX9O7PP//kwoUL5Mmbl0KFCpmO41S1rr8wUSEv6d1fe+Q1Iy8i FpElSxYCAgK4cuUKMTExbj1bHXnJKBzd+Bo1axpO4ny1atcGVMhL+qeOvIhYkmOHu7u78tpaIxnF 7p07AahWrZrhJM5XqnRpAI4dPWY4iYhrqZAXEUsyNV6j0RrJKK5evQpAtuzZDSdxvoceeghIWa8p kp6pkBcRSzKxuSY5OZlz587h4+ND7ty53XauiAnXoq4BkCk4k+Ekzufr60tAYCCJiYnEunk8T8TV vLRHXkSszkRH/ty5cyQlJZErVy491VXSvWvRKYV8cKZgw0lcw9GVj1RXXtIx/aQSEUsyUcjrRlfJ SNJzRx4gOFPK13Xt2jXDSURcR4W8iFiSidEa3egqGUliYgJw09v06cqlS5cAyJ4O7wEQcVAhLyKW pI68iGvly5cfgBPHjxtO4nwRERFcvXqVzJkzp47YiKRHmpEXEUvKmTMnABcvXnTbmY6zQkJC3Ham iCmFihQG4Hg6LOSPH0tZO1kwnT3oSuTv1JEXEUvKnDkzkNJZcxfHWergSUZQqFBKIZ8ed607XpwU KFDAcBIR11IhLyKW5OiKO3Zdu4PjLMeLCJH0rHBqRz79FfJHDx8B1JGX9C91tEZExEpMduQ1WiMZ gePpp7t37iIpKclwGufa+NNPADxcpbLhJCLO9/c98oBm5EXEWgIDA7HZbMTFxREfH++WMx2FvDry khEULVqUkqVKcfHiRbaGhZmO4zTx8fH8uGEDXl5eNGzY0HQcEZfSaI2IWJa7u/Iq5CWjada8OQAr li03nMR5Nv3yC9HR0VSoWJFcekKzpHMq5EXEshwjLirkRVyjWYvrhfzy9FPIf792LQANGzUynETE 9TQjLyKW5Sio3XXDq252lYzmkWrVyJkzJ4cOHuTggQOm4zjF6pWrAGjYWIW8pH+akRcRyzI1WqOb XSWj8Pb2pkWrVgB8/eVXhtOk3caffuLA/v3kyJGDR6pVMx1HxOU0WiMilqXRGhHXe+Hll/Dx8WH2 zJmcOH7CdJw0mfDV1wD0efppbDab4TQirqdCXkQsy50d+cTERKKjo/Hx8SFTpkwuP0/EKooVK0bH zp1ISEhgzKhRpuM8sKNHj7Ji+XL8/Pzo83Rf03FE3MErdUZeozUiYjXuLOQjIyMBPdVVMqZXBw3C x8eHubNnpz4V1dNMmjCB5ORk2j/RQdtqJF27YY+8OvIiYl3uvNnVcYbm4yUjurErP3rESNNx7tu1 a9eYNX0GAM/17284jYj7qJAXEcty54y85uMlo3tt8GBsNhvz5szh2LFjpuPcl2//9z8iIyOp+eij VKxUyXQcEbdRIS8iluXO0RoV8pLRFS1alE6dO5OYmMjoj0eYjnNfpkyaDKTc5CqSkWhGXkQsS4W8 iHu9OngQNpuN/86bx5EjR0zHuSdhW7awd88ecubMSas2rU3HEXErdeRFxLIcN546bkR1Jd3sKgJF ihShc9euJCYm8vUXX5qOc0+mTk7pxvfo1Qs/Pz/DaUTcS4W8iFiW44dyQkKCy89ynKFCQDK6fs8/ B8DihQtJSkoynObOLl68yOKFi/Dx8eGpPn1MxxFxOxXyImJZjge6JCYmuvwsxxl6iIxkdOXKl6dE yZKcP3+ejT/+aDrOHc2aMYO4uDgaN2lCgYIFTMcRcYsb1k9qj7yIWJejqHZnR16FvAi0f6IDAPO/ nW84ye0lJyczbcpUAPo+84zhNCJmqCMvIpbl6+sLuLcj7zhTJCNr07YtAGvXrDGc5Pa+X7OWY8eO UaxYMeo3eNx0HBEjVMiLiGWpIy9iRqnSpcmcOTPhZ85w7uxZ03Fu6b/z5gHQu2/fm550KZKRpI7W iIhYjTryImZ4eXmlPlhp967dhtPcWtiWzQA0bd7McBIRc1I78pqRFxGr0c2uIuZUqvwwALt27TSc 5J/OnT3LyRMnyZIlC8VCQ03HETFGozUiYlkarRExJ/R6gXz61GnDSf5p27ZtAFSt9ojGaiRDUyEv Ipal0RoRc1K//9zwQvp+nTxxEoBixYoZTiJilmbkRcSyNFojYo7Ndr2QT3L999/9iomJBiAoKJPh JCLu9/c98oBm5EXEehwdQXeO1qgjL5LC2zulRHDHC+n7FX0tpZDPFKxCXjI2jdaIiGWpIy9izqGD BwEoXLiI2SC34CjgL5w/bziJiFkq5EXEsnSzq4g5O3ZsB6By1SqGk/xTxYopqzF37dxlOImIWakz 8hqtERGr0c2uIubs2pGydrJKFesV8hUqVQRgz55fiY+PN5xGxBx15EXEsjRaI2LGyhUruHjxInnz 5SNvvnym4/xD9uzZqVCxIjHRMcydPdt0HBFjVMiLiGXpZlcR94uPj2fIG28CMPDVVwynub1/vTIQ gE9Hj7HkDbki7qBCXkQsKzk5Gfhre4YrOdZ5acxQMrrPPvmEw4cPU7ZcOXr37Ws6zm21adeO0NBQ jh8/znv//rfpOCJGaEZeRCzLMfvq5+fn8rMcZ2jeVjKqpKQkhrz1Fh8P/xCAj0eNxMfHx3Cq2/P2 9ubrSRPx9/fnq3FfMHf2HNORRNzCi1vskRcRsRoV8iLucenSJZ5o156vxn2Bn58f4776ktp16piO dVePVKvG6E8/AeBfL77ItKlTDScScS8V8iJiWe4s5N05jy9iJQvnz6dgOZUhAAAgAElEQVRe7dps WLeOnDlzsnjZUrr16GE61j3r1qMHrw0aREJCAq+8/C8GvfqaZuYlw1AhLyKWpY68iOtsDQujSYOG 9H2qNydPnKRylcp8v2ED1WvUMB3tvr31zhC+HD8ePz8/Jk+cyGO1arPxp59MxxJxuRtm5A0nERH5 GxMdeRXykt4dO3aMPr2eokmDhmwNCyN3njx8/uUXrFm3jgIFC5iO98C6dOvK4mVLCQ0NZd/vv9O6 eQv6PtWb06dOmY4m4jLqyIuIZcXFxQHu7chrtMazhJ85w6ZffmHJ4sWcOX3adBxLi4yM5N0h71C9 SlUWLVhAYFAgrw8ezPbdu+jes6dbtkO5WvUaNfg5bAvvvPcuQUFBLJw/n/+rUpVPRo9O/ftEJD3x /O9aEUm3NFojt3I2PJxPx4zh8bp1KVuyFC2aNKVX9x6UL12GJg0a8uXn4zh+/LjpmJZht9uZPWsW jzxcmXFjx5KQkEDnrl3YumMHbw55m6CgINMRncrPz4+Br75K2I7ttG3fnujoaIa9/wHVrxf0esEn 6YkKeRGxLN3sKjc6eOAALw14gYfLV2Doe++za+cugoODqV2nDg0aNSQgMICtYWG88/bbPFyuPI/X rcvsmTMzdCd2+7ZtNKxXjxef78/5c+eoUbMma9ev56sJE8iXP7/peC6VL39+pk6fxuJlSylVujTH jx9n2PsfUKFMWZ5s357FCxfqhbt4PO2RFxHLcvyQ9ff3d/lZ6shb15bNm+neuQs1HqnGrBkziI+P p0nTpsyaN5eDRw7z3fJlfLNgAX8ePcrMuXPo1KUzISEh7Nq5ixf7D6Bi2XKMGjGCK1eumP5S3Gr8 V1/TrFFjdu7YSaFChfjPjOksX72KylUqm47mVnXq1mXj5k3899tvadW6NT4+Pny/Zi29e/aiYtly jB45kkuXLpmOKXLPHA8wRHvkRcTKdLNrxha2ZQtNGzaiWaPGLF+2DD8/P7r37MmmrWHM/eZ/NG/R Av+AgNSPDwgMpEXLlnw9cSIHjhxm6vRpVK5ahfPnzvHRsOHUrPZ/rF61yuBX5B6xMTH0e/pp3ho8 mMTERF58+WW27NhOm3btTEczxsfHh0ZNGjN99iz27v+DocOHU6p0ac6dPcuHQ4dRu0ZNDuzfbzqm yH1TIS8ilmViRl6jNdZw6OBBOrbvQNiWLWTJkoVXXnuN3b/t5fMvv6BkqVJ3/XxfX1/atm/P9+vX s3TlCqo+8ghnw8Pp/MSTzJg2zfVfgCGXL1+mScNGfPPf/xEYFMiUaf/h/WFD3fKulqfImTMnA156 kU1bw1i8bCn/V7064WfO0KJJU/bu2WM6nsh9SR2tERGxGt3smnENeO55IiIiaNqsGXv+2MeQd/9N rty5H+haj9aqxarv1/LWO0MAGPLmW+lyJWFSUhJ9n3qKPb/+SqFChVi1di3tOnQwHcvS6tSty+Kl S2jUpDEXL17k6d599GJePEpqR14z8iJiNRqtyZgSExPZvWsXAF+M/5pMmTKl+Zre3t68NmgQDRs3 IioqiuXLlqX5mlbz/rvvsv6HlKezLl25kvIVKpiO5BH8AwKYMWsWoaGhHNi/n6+//NJ0JJF7ptEa EbEs7ZHPmE6fPk18fDzZs2cnW7ZsTr12rdq1AThy5IhTr2va0iVL+GLs5/j6+jJt1kyPfrCTCf4B AYz+7FMARn70sW5+FY+hQl5ELEujNRlTvnz58A8I4NKlSxw8cMBp101ISODQgYNAys2P6ckno0YB 8MHw4dR89FHDaTzTY/XqUfexx4iOjmbxwoWm44jcExuOGXmN1oiIxVy9ehWAkJAQl5+VOXPmm84U c2w2GxUqVGDb1q1Ur/oIwcHBlClbljJly9KkWVOaNW9+12us/2EdYWFbOH/uPOfOnePUyZP89ttv xMXGAtCpc2dXfxlus2P7dnbt3EXOnDnp3beP6TgerVOXLvy4YQPf/Pd/9O7b13QckbuymQ4gInI7 ly9fBnD6eMWtOM7QW+rW0Kv3U3h7e3Po4EEuXbrE1rAwtoaFMXvmTL5dtJDH6tW74+dPmTSJZUuX /uPfh4aG0rBxI8qVL++i5O43eeJEALr16OGWd6/Ss9Zt2/DaKwPZsnkzJ46foGChgqYjifzDX2vk tUdeRCzMUVSrkM94uvXowcq1azh07CgHjx7hu+XL6NajB0lJSfTp2YuIiIg7fn5MbAwAfZ5+molT prB42VIOHTvK1l07+WjkSHd8CW5x8eJFFs5fgLe3N7369DYdx+NlypSJlq1aYbfbmTN7luk4Inel Ql5ELMudHfmsWbPedKZYR/bs2aldpw5jvxhHqdKluXz5Mvt+//2OnxMbkzJC0/6JDjzR8Unq1K3r lj9H7jZj2jTi4uJo1LgxhQsXNh0nXejRqxcAs2fOJDk52XAakTtL3SNv1zp5EbEYR3fcUWS7kq+v L8HBwSQmJmpO3qK8vb2pWKkiwF1vgnV05AMDAl2ey5SkpCSmTp4CwDP9+hlOk37UrlOH0NBQTp44 yfdr1pqOI3JH6siLiGW5syN/4zkar7Gu4iVKAHDw+vaZ23F05AMCA1yeyZRRH4/g1MmThIaGUr/B 46bjpCvde/UE4NWB/9LfB2JpKuRFxLLcOSN/4zn6wW1djndnYq933G8nNibl9wMC02dHfsnixYwa MQIfHx9Gf/oJXjfc/SZp9/yAAVSpWpWTJ07ybN++GrERy1IhLyKWpY68/F1cbMpDwvwD7txpj7m+ ZjLwLh/niXbv2s3zz/bDbrcz7KOPeKx+fdOR0h0/Pz9mzJ5Fzpw5+WHt97zz1lsq5sWS/pqR1x55 EbGQpKQkIiIi8PX15aGHHnLLmSrkrS827vrIjP+dC3THvvi7FfyeZv4339KiSROio6Pp3rMn/Z5/ znSkdCtf/vxMmT4Nm83G119+RYc2bTl/7pzpWCI3vgOn9ZMiYk1XrlzBbre75UZXBxXy1ufoyPv5 39u+9PTSpEpISODNQYN4pk8foqOj6dajB6M//cR0rHSvdp06fLtoIbly52bD+vXUrvkoG9avNx1L JJUKeRGxJHfPx994lgp563Jso7lbR95mS3neYVJiosszudqB/ftp1aw5E74ej7+/P59+PpZxX32p hz+5Sd3HHuOnTb9Q7/H6nD93jg5t2jLguec4fvy46WgiKuRFxJrcPR9/41kq5K3rbHg4AFmz3/nP hc/1Qj7Rgwv5y5cv88brr1O7Rk3Ctmwhf4ECLF+1il699eAnd8uZMyfzFy1iyLv/xtvbm7mz5/B/ lavwxuuva9xGjNKMvIhYkjrycisH9qfsjy9xfQ3l7dhsPgAkJia5PJOzJSYmMnH8BB6p9DATx0/A brfT95ln+PGXn6lctYrpeBmWl5cXr7z2Glt2bKdj506p/50qV6jIsPc/uOvThkVcQR15EbEkR0fe nTPyjrNUyFuT3W7n4MGUQr743Qp5n+sd+STP6cjb7XYWLVhAreo1eOP117l8+TKPN2zAxs2bGPXJ GLd+L8jtFS1alPGTJrFx8yZatW5NdHQ0n4weTaWy5Rj+wVAuXLhgOqJkICrkRcSSTp06BUCePHnc dqbjLMfZYi0nT5wkJjqG7Nmz3/WdGsdoTUJ8vDuipYndbmfpkiXUqfkofXo9xcEDByhRsiT/mz+f bxcupFTp0qYjyi2ULlOG6bNn8f2GDTzesAFXr15lzKhRVCxbjsGvvcaJ4ydMR5QMQIW8iFjSn3/+ CUBoaKjbznSc5ThbrGX/H38AUKJkybt+bKHChQDYsX2HSzOl1coVK6hfpy49u3bj999+o0DBAnw2 7nN+3rKZho0bmY4n96Bylcp8u3Ah32/YQKvWrYmPi2PShIlUrVSJ/v36pf65FXEFzciLiCWZKORz 585NcHAwV65c0XiNxSQlJTFm1CggpXC6myZNmwHw5bhxqTvlreT7NWtpUK8eXTt24tfdu8mbLx+j PhnDtl276PnUU6lbd8RzVK5SmemzZ7FpaxjdunfHy8uLeXPm8uj/Vad75y5s37bNdERJJ7RHXkQs z0QhD1CsWLGbzhfzkpOTGfza62zZvJk8efPy+htv3PVzuvfsQWjx4vy2dy+dn+xIdHS0G5Le3YZ1 62jSoCFPtm/Pzu07yJU7Nx+OGMGO3bvo+8wzWimZDpQoWZJxX3/Fjl9381z/5wkIDGD5smU0qv84 bVq0ZN33P5iOKOmICnkRsZzExESOHTuGr68vhQoVcuvZxYsXB1TIW0VcXBzP9OnL1MmTCQgMZMLk SWTJkuWunxcUFMSsuXNSH+TTrlVrrl696obEt/bzxo20aNKUdq3bsDUsjBw5cjB0+HB27fmV5/o/ n+6eQCuQv0ABPhwxgj379jHojTfImjUrP/34Ix3atuWJdu1Mx5N0InW0RkTEKo4dO0ZSUhJFihTB x8fHrWdrTt46dmzfzmO1arNw/nxCQkJY+N1i6tSte8+fX6p0aVauXUORIkXYGhZG04aN+HX3bhcm vr0n2rZj0y+/kDVrVv79/nvs+m0vA156kYDAQCN5xH2yZcvGG2+/xa/7fue9oR8AsC1sq+FUkl6k duQ1Iy8iVmFqrObGM1XImxMXG8t77/ybJg0acmD/foqXKMHSlSuoXqPGfV+rSJEirFizmrLlyrH/ jz9oVP9xRo8caWxuPmznDv71yisEBQUZOV/MyZQpEy/961/4+/sTERFhmXEv8WwarRERyzl06BBg tpB3ZBD3uXLlCvPmzKVurdp8/tln2O12+r/4Aj/98jPlypd/4OvmzpOHtet+4PkXBpCUlMSHQ4dR omgx+vfrxw9rvycpyX0PjQrOlMltZ4k15c2bF4AzZ84YTiLpgQp5EbEcRzfcMa/uTpqRd6/z584x bepUOrRtS6liofTv14+DBw5QtGhRlq5cwbAPP3TK/HhAYCDDP/qI5atXUaVqVaKiopg3Zy5PtGtH 2RIlGfzaa2wNC3PCVyRyZ3nz5QMgXIW8OIENrZ8UEYsxOVpTsGBBfH19OXPmDDExMQRqhtmp4uPj 2bJ5M+t/WMf6dT+we9dukpOTAfD19aVRk8a0adeOdu3aExjk/P/v/696ddauX8eff/7Jt//7H9/+ 7xv+PHSISRMmMmnCRAoXLkyHJ5+kSbOmVKla1e33aEj65yjkz5xWIS9pp0W1ImI5Jgt5Hx8fihQp wsGDBzl8+DDlypVze4b05tixYyxfspR1637g540biYmOSf29gMBA6tStQ5t27WjRsiUhISFuyRQa GsrgN99k8JtvsmvnLr795n8snL+AY8eO8cno0XwyejRZs2al3uOP07hJE9q2a6vNMuIUefOljNao Iy8P6sY98irkRcRS7HY7hw8fxsvLK3Wnu7uFhoZy8OBB/vzzTxXyaXDm9GlGfjyC2TNnkpiYCKT8 AKpYqRL16tenfoPHqVGzJv7+/kZzPlz5YR6u/DAfDBvGzxs3smzJEtauXsPhw4dZOH8+C+fP599v v83T/Z7l6WefJWvWrEbzimfLl/d6R/7MacNJJD1QIS8ilrJ7926io6MpVaoUAYY6oJUqVWLlypX8 /PPPtG7d2kgGT5aUlMT7777LpAkTiYuNxc/Pj05dOtOwUWMeq1+PHDlymI54S97e3tSpWzdlxeUo OHLkCN+vWcO8OXPZsX07Hw0bzpefj2PGnNnUfewx03HFQ+XL7yjkww0nkfQgdY+8ZuRFxApWr14N QMOGDY1laNSoEQBr1qwxlsGTDX3vfb4Y+znxcXE80fFJtuzYztcTJ9LhyScsW8TfStGiRXn62WdZ u34di5ctpU7dukRERNCxfQe++e//TMcTD/XXjLw68pJ22lojIpbiKJ5NFvK1atUiMDCQXbt2ceHC BWM5PNHSJUv4/LPPsNlsLPhuMROnTKFw4cKmY6VZnbp1WbR0CS++/DLx8fE898wzzJ09x3Qs8UB5 82prjTiPCnkRsYzY2Fg2btyIj48P9evXN5YjICCA2rVrY7fbWbt2rbEcnubPQ4cY0O85AN59/30e q1fPbCAn8/Ly4v1hQxn+8cfY7XZeeflltm/bZjqWeJg8efPg5eVFeLhGayTtVMiLiGX89NNPxMbG Uq1aNbdtL7kdjdfcn6SkJJ59+mkiIyNp1bo1A1560XQkl3l+QH+e6fcscXFxdO/SVZ1VuS++vr7k yJGDuLg4Ll26ZDqOeDjNyIuIZVhhrMZBhfz9Gf/lV+zcvoNChQrx5YTxpuO43PCPP6buY49xNjyc p3r0TN2FL3Iv9FAocRZ15EXEMqxUyFeqVIlcuXJx4sQJ9u/fbzqOpR05coThw4YB8OnnnxMcHGw4 kevZbDb+M3MGBQoWIGzLFqZMmmw6kniQLFmyAKgjLw/kxj3yKuRFxBLOnz/P7t27yZQpEzVr1jQd By8vLxo0aACoK383/3rhRWJjYujarRv1GzxuOo7bZM2alZFjxgAw7P331V2Ve+btk1J+JcQnGE4i nk6FvIhYwtq1a7Hb7dStWxc/Pz/TcQCN19yLmdOn89OPP5Ird26GffyR6Thu17RZM1q0bElkZCRv DBpsOo54CF9fX4DUB6WJPCjNyIuIJVhprMbBUcivX79eP3BvIfzMGd55620ARo0ZnToukNF8PGok QUFBfLdoEWtWrTYdRzyAry2lkE9IVEde0kYdeRGxBEch7yieraBAgQKULl2aiIgItmzZYjqOpSQk JNC7Zy8iIiJo1bo1rdq0MR3JmPwFCvDm2ykvaF57ZSCRkZGGE4nV2Rwd+QQV8pI2KuRFxLg//viD kydPkjt3bsqXL286zk00XnNr7w4ZwpbNm8mdJw+jP/3EdBzj+vV/nkoPV+LE8RMMfu0103HE4nx9 bQAkJOidPkkbFfIiYtySJUuAlLGaG+7Gt4TGjRsDf2UUWDh/PuO/+hpfX1+mz5pJzly5TEcyzmaz MWnqVAKDApk3Zy6LFiwwHUkszDEjn6COvKSRZuRFxLiZM2cC0KlTJ8NJ/qlRo0ZkzZqVHTt28Pvv v5uOY9zOHTt5acALAHw0cgT/V7264UTWUbxECT78+GMABr70Mr/t3Ws4kViVzea42VWFvKSNOvIi YtSuXbvYs2cPOXPmpFmzZqbj/IO/v3/qC4wZM2YYTmPW5k2baNuyJdeuXaNb9+70efpp05Esp1fv 3rRp146rV6/SpkVL9vz6q+lIYkHqyEtaaI+8iFiGozju0qULNpvNcJpb69mzJwCzZs3KsE/wXP/D Ojq0bUtkZCQdO3fi03Gfm45kWRMmT6JZ8+ZcunSJti1bsW3rVtORxGI0Iy/OotEaETEmMTGROXPm ANCjRw/DaW6vZs2aFC9enFOnTvHDDz+YjuN2y5YupUvHjsREx/BUnz58NWGCZV90WYGfnx//mTmD Zs2bc/nyZdq0bJlhXwDKrWlrjTiLOvIiYszq1as5e/YsZcqU4ZFHHjEd544cLzQy2njNf+fOo3eP nsTFxTHgpRf5ZOxneHvrR8fd+Pn5MX32LLp1705MdIxGKOQm2iMvzqK/jUXEGEdR7BhdsbIePXrg 5eXFggULiIqKMh3HLUaPHMnzzz5LYmIig996k6HDh5uO5FFsNhvjvv6KV25YR/nJ6NEGE4lVaEZe nEWFvIgYcfz4cRYsWICPjw/du3c3HeeuihYtSp06dbh27RqTJ082HcelEhISeOG55/lw6DBsNhtj vxjH4DffNB3LYw1599+M+mQM3t7ejBoxklde/hdJSUmmY4lBtusz8omakZc00oy8iBgxcuRIEhIS 6Nq1KwUKFDAd554MGjQIgFGjRhEXF2c4jWtERETQsX0H5syeTXBwMPO++YYevXqZjuXx+j7zDP+Z OQP/gACmTZ3KU917EBsTYzqWGKKOvDiLOvIi4nZnz55lypQpeHt789Zbb5mOc89atGjBww8/zOnT p5k2bZrpOE537uxZmjRoyIb168mbLx/LV6/i8YYNTMdKN1q1bs38RQsJCQlh2dKlPNm+A3GxsaZj iQGakZe0uPHBiSrkRcTtxowZQ2xsLE8++SSlS5c2Hee+OF54jBgxgsTE9PO2eFRUFB07PMH+P/6g bLlyrPnhe8pXqGA6VrrzaK1aLF+9ijx58/Lzxo08+/Qz2miTAWlrjTiJ9siLiHtdvHiRr7/+Gi8v L95++23Tce5bhw4dKF26NEeOHEldnenp4uPj6dGlK7/u3k1oaCiLli4hX/78pmOlW2XKlmX+ooVk zpyZJYsX8/Ybb5iOJG5ms/kA2iMvaacZeRFxq5deeomoqCjatGlDBQ/s+Hp7e/Pm9Rs/Bw8ezPnz 5w0nSrt33nqLDevXkztPHr5dvIgcOXKYjpTulSlbllnz5uLn58eEr8fzxVg9YCsj0Yy8OIs68iLi NtOnT2fOnDmEhITw6aefmo7zwLp37079+vUJDw+nV69eHt0ICT9zhun/mYa3tzfzvvmGwoULm46U YdSuU4evJozHy8uLd995h4Xz55uOJG6i0RpxFhXyIuIWBw8e5IUXXgBg/PjxFClSxGygNPD29mbm zJlkz56dFStW8Nlnn5mO9MC+/OIL4uPjadm6NZUermQ6TobT/okn+GDYMOx2O2+/+ZY6tBmE42bX xCSN1kjaqJAXEZeLj4+nc+fOREVF8dRTT9G5c2fTkdIsf/78TJkyBYA33niDHTt2GE70YOZ/8y0A Lw8caDhJxjXgpRcpVbo04WfOsGLZMtNxxA18r++R14y8pJVm5EXE5d5880127NhBiRIlGDdunOk4 TtOmTRuef/554uPj6dKli8c98fXKlSuEnzlDcHAwlatUNh0nQ2vVujUAe/fsNZxE3EGjNeIs6siL iEutWLGCTz/9FF9fX+bOnUtwcLDpSE41ZswYypUrx4EDB3jxxRdNx7kvf+zbB0CJkiUMJ5GChQoC cO7cOcNJxB10s6ukyV975LV+UkRcJzw8nKeeegq73c6HH35I1apVTUdyusDAQObOnUtAQADTpk1j 7ty5piPdswP79wNQomRJw0kkT568AJw5c9pwEnEHPRBKnEWFvIi4RExMDG3atOHcuXM0atSIV199 1XQkl6lQoQKjR48G4Nlnn2XXrl2GE92bfb//DkDpMmUMJ5HceXIDcOrkKcNJxB1s12fkEzUjL2mU OiOPZuRFxEnsdjvdu3cnLCyMYsWKMXv27JseKZ0eDRgwgB49ehAVFUXLli05efKk6Uh3tXvXbgAq VXrYcBLJndtRyFv/z42knUZrxFnUkRcRpxs0aBALFiwga9asLFu2jJw5c5qO5BaTJ0/mscce49Sp U7Rs2ZLIyEjTkW4rKSmJX3enFPIVtXbSuJy5cpEzVy6uXr3K92vWmo4jLqZCXpxFhbyIONWECRMY PXo0vr6+LFiwgNKlS5uO5DZ+fn4sXLiQUqVKsXv3bjp16kRSUpLpWLc0c/p0oqOjKVGyJNmzZzcd J8Pz9vbm2ef6ATBu7FjDacTVbI498pqRlzRSIS8iTrNq1arUhz5NmjSJevXqmQ1kgONdiBw5crBi xYrU/z+s5NKlS3w4dBgAb78zxHAacejz9NMEBQXx44YNvDvkHdNxxIVsNh8AEhOt+UJfPMcNe+QN JxERj7Znzx46duxIYmIi77zzDr169TIdyZjQ0FAWL15MQEAA48ePT70R1gq2bN5M/Tp1uHDhArVq 16Z127amI8l1WbNm5Yuvv8LPz49xY8fSv18/Ll68aDqWuEByckrR5e2dvu8dEtdTR15E0iw8PJyW LVsSERFB165d+eCDD0xHMu7RRx9l2rRpeHl5MWjQIObPn28si91uZ/OmTbw04AVaNm3GieMnqFK1 Kl9OGG8sk9xa2/bt+e+335ApUybmzZlLpbLleHfIO5w/f950NHGi5Osjd94+PoaTiCfy0h55EXGW 6OhoWrVqxfHjx6lduzZTp041HckyOnXqxLBhw7Db7fTo0YOwsDC3nn82PJwRH35ElQoVad64CbNm zMBut/PKa6+xcu0aChUq5NY8cm8eq1+fNet+oHmLFkRHRzNu7FgeLl+e9//9LpcvXzYdT5wgKTml kPfxViEvaXPDaI1ma0Tk/iQmJtKxY0e2bdtGiRIlWLRoEf7+/qZjWcpbb71Fnz59UvfqHzlyxOVn /v7bb/Tv149K5coz4qOPOHbsGAUKFuCV115jy/ZtDHn339hsNpfnkAdXukwZZs2by/qNP9G8RQti omMY++mnPHz9v2lUVJTpiJIGjpvgfdSRlzRSR15EHli/fv1S10suX75c209uY/z48bRs2ZLw8HCa NGni0jGJ7du20aBefebNmUtycjJt2rVj8bKl7P7tN4a8+29Cixd32dnifBUrVWLWvLl8v2ED9Rs8 TmRkJCM+/IjGjzfg3NmzpuPJA1IhL86iQl5EHsiQIUOYOnUqwcHBLF++nOIqEG/L19eX//73v9Ss WZODBw/SokULrl275vRzTp08SddOnYmLjaVj507s2ruH/8yYTp26ddP9A7nSu8pVKjN/0SK+W76M EiVL8se+fbRo2owzp0+bjiYPIDk5GUhZOyqSFvoTJCL37auvvmL48OH4+vry7bff8sgjj5iOZHlB QUEsXbqU0qVLs3XrVp544gkSE537ePbVq1Zx/tw5/q96db4cP558+fM79fpiXu06dVixZjWVHq7E n4cOMWPadNOR5AGoIy/Oohl5EbkvCxYs4MUXX8TLy4spU6bQpEkT05E8RrZs2Vi1ahX58uVj5cqV 9O3b16l/9yYkpLwwqFipkgqEdCxbtmx07NQZgGvRzn9nR1wvOel6R95H/VRJG/0JEpF79uOPP9Kt WzeSk5MZMWIEPXr0MB3J4xQqVIiVK1cSEhLCjBkzeOONN5x27cTrj3v39dWNrOldYFAgANHXog0n kQehjrw4iwp5Ebkne/fupU2bNsTGxjJw4EBef/1105E8VoUKFbDGIxgAACAASURBVPjuu+/w9/dn 5MiRjB071inXTbj+uHfH498l/QoKygRATIwKeU+k9ZOSFtojLyL35cSJEzRt2pQrV67QpUsXxowZ YzqSx6tbty6zZ8/G29ubgQMHMm/evDRf0zFz7+urQj69c3Tkr6kj75EcN7uqIy9ppRl5EbmjS5cu 0aRJE06dOkXDhg1Tn1YqadehQwfGjRuH3W6nV69efP/992m6XuL1GXntiE//Ml3vyEdrRt4jOUZr tLVG0kp/gkTktmJiYmjdujX79u2jcuXKLFiwAD8/P9Ox0pX+/fszZMgQ4uPjadeuHTt37nzgayVc n5G3aUY+3XN05GOiYwwnkQeR7Cjk1ZGXNFIhLyK3lJSURJcuXfj5558pVqwYK1as4KGHHjIdK10a OnQoffv2JTIykubNm3P48OEHuk5C6s2uGq1J7wIDgwB15D2VbnYVZ1EhLyK31L9/fxYvXkzOnDlZ tWoVuXPnNh0pXZswYQKtWrUiPDycpk2bPtDTXxOTrs/I62bXdC9TJkchr468J0pKcszIqwyTtNGM vIj8w3vvvcfEiRP11FY38vHxuenpr82bN7/vp7861k/6aEY+3VNH3rPpZldxFr0UFJGbTJw4kfff f19PbTUgMDCQpUuXUqZMGbZt20aHDh1Sx2XuheOBUNojn/5pj7xn082u4iz6EyQiqZYuXUr//v3x 8vJi6tSpemqrAdmyZWPlypXkz5+fVatW8cwzz9zz52r9ZMaRKeh6R1575D1ScrKjkFdHXu6f9siL yD/s3buXrl27kpSUxIgRI+jevbvpSBlWoUKFWLFiBcHBwUyfPp2RI0fe0+cl6oFQGUZAYCBeXl7E xsRqNNYD6WZXcRbNyIsI58+fp1WrVkRGRtK3b189tdUCKlSowKxZs/Dy8uLNN99kyZIld/2c1PWT mpHPEAIDA7Hb7cTE6IZXT6NCXpxFHXmRDC4+Pp727dtz9OhR6tSpw1dffWU6klzXpk0bPvzwQ5KT k+nWrRt79+6948drRj5jCXKM10RrvMbTqJAXZ1EhL5LBPffcc2zcuJEiRYowf/58PfDJYt544w26 detGZGQkrVu35sKFC7f92KTrM/I2zchnCKk3vKqQ9zjJySlTEN7eekq2pM1fozVotEYkoxkzZgz/ +c9/CA4O5rvvviNnzpymI8ktTJ48merVq3PkyJE7brLRA6EyloCAlEI+LjbWcBK5X+rIi7OoIy+S QS1btoxBgwbh7e3N7NmzqVChgulIchsBAQEsWrSIAgUK8OOPP9K/f/9bflyC42ZXH43WZASOeyEc 24rEcyQ71k+qkJc0UiEvkgH99ttvdOnSheTkZIYPH07r1q1NR5K7yJMnD4sXLyYoKIjJkyczduzY f3xMYoJjtEaFfEbg6OY6urviOZKur5/8f/buO6zq+v3j+PMc1gEZggNKcIFartTSstyaDcss98i9 cy/cuFMcWe6tlea23CtnOSozZ5ogKu7BUDhwgHP4/QGH7PtrqBx4n3E/rosLZBxeJR7uc5/7c7+d ZP2keAaPrZ+UQl4IR3P//v2sDTWtW7dm6NChqiOJJ1SpUiWWL1+ORqNh4MCB7Nq16y8flz3yjsXJ KeNXuNFoUpxEPC0ZrREWopH1k0I4kNTUVBo3bkxUVBSvvvoqixcvVh1JPKWmTZsyevRojEYjzZs3 58KFC1kfkxl5x+KUOUJlNMpoja0xmTIefMnJriK75CdICAfSo0cPDh06RGBgIN9++y06nU51JPEM wsLCaNKkCfHx8TRs2JDY2FjgsQOhZEbeIchoje2SjrywFCnkhXAQCxcuZMmSJXh4ePDdd98REBCg OpJ4RhqNhhUrVlCxYkUuXbpE69atSU9PJy0toziQGXnHIIW87TJljkNpnaQME9kjP0FCOIAzZ87Q t29fIGOVYaVKlRQnEtllfkCWL18+duzYwdSpU2W0xsHI1hrbJR15YSkyIy+EnUtMTKRZs2YkJyfT pUsXWrZsqTqSsJCgoKCsi19HjBjBo0ePACnkHYV05G2XFPLCUqQjL4Sd++STT7hw4QJly5b925WF wra999579O/fn7S0NG7fugWAk7OM1jgC81iGMU0KeVsjF7sKS5GfICHs2FdffcWKFSvw8PBgzZo1 uLu7q44kcsDkyZOpXLkyaZldPhcp5B2CebRGOvK2R/bIi+yQPfJCOICLFy/So0cPAGbPnk3p0qUV JxI5xcXFhdWrV6PNvHOX0RrHYC4CzUWhsB1ysquwENkjL4Q9MhqNtGzZksTERNq0aUOHDh1URxI5 rHjx4uTJkwcAZynkHYJc7Gq7ZEZeWIp05IWwQzNnzuTkyZMUK1aMefPmqY4jcol53tZZRmscgrmb a5LRGptjPo3XSdZPimySnyAh7My1a9cICwsDYM6cOXh6eipOJHJLamZn1sVZOvKOQLbW2C652FVY ivwECWFnevXqRWJiIk2aNOGdd95RHUfkorTMPfJyIJRjcHbOKOTTZGuNzZHRGmEpMiMvhB3ZuHEj W7ZswcvLS1ZNOiDzrLSM1jgG6cjbLinkhaVIR14IO/Ho0SP69OkDwIQJE3j++ecVJxK56fEi/vHV ZMJ+ydYa22XK/DvTyvpJkU1SyAthJ8aOHcuNGzeoVKkSn3zyieo4IpeZx2rkMCjHYf67NsrWGpsj HXmRHY81azRZhbyM1ghhu+7fv8+8efPQaDQsWLBAfjk4oD8vdJVC3lHIaI3tkotdhaVkzcgLIWzX F198gV6v5/333+eVV15RHUcokJrZkZfDoByHFPK2S9ZPCkuRnyAhbFxCQgKzZ88GYNiwYYrTCFXM 4xVyGJTjkK01tktGa4SlSCEvhI1bsGABsbGx1KpVi9dee011HKGIuSMvG2schxwIZbvMf2daKeRF Nsn6SSFsWEpKCjNmzACkG+/oZEbe8cjWGtslHXlhKdKRF8KGffvtt9y8eZNKlSpRv3591XGEQub1 kzIj7zjMz76kydYamyMXuwpLkZ8gIWzYN998A0CnTp0UJxGq/XmqqxTyjkIudrVd5mdRnGSPvMgm KeSFsFFxcXHs2LEDZ2dnmjZtqjqOUExm5B1PViEvF7vaHBmtEdnxv3vkZUZeCBu0ceNGDAYDdevW pUCBAqrjCMVSU82jNVLIOwonZ+nI2ypT5vpJrayfFNkkP0FC2CjzWE2rVq0UJxHWwGjMXD/pLKM1 jkJGa2yXdOSFpUghL4QNunPnDvv370en09GoUSPVcYQVkAOhHI9c7Gq75N+rsBQp5IWwQfv27cNo NFKvXj28vb1VxxFWQGbkHY+sn7RdKakpALi6uCpOImxd1ow8MiMvhM04cOAAALVq1VKaQ1gP8wWP zjIj7zDkQCjblWLIKORdXKUjL7JHOvJC2KCDBw8CULNmTcVJhLVITct8ql5m5B2Gc+bFrmmytcbm pKRkFPJubm6KkwhbJ4W8EDbm1q1bXLx4ES8vLypWrKg6jrASMnPreORiV9uVmmLuyMtojcgeKeSF sDHmbny1atVk44HIYj4Qyklm5B2GeZe0rI+2PYYU84y8PPAWT0/2yAthw44fPw5AjRo1FCcR1sQ8 XiF75B2HFPK2y9yRd5XRGpFN0pEXwsZcvHgRgPLlyytOIqyJjNY4HinkbZd5Rt5VRmtENkkhL4SN +eOPPwAoWbKk4iTCmqSlmddPSiHvKKSQt10yWiMsRZ6DFTZHr9ezJvNUU0eTlpZGVFQULi4uFCtW THUcYUXMhwLJHnnHIYW87TKP1qxaufLxeWchnkhyssH8pqszMiMvbMyMqdOYMW2a6hhKGE0mTCYT JUqUkAtdxV+YTCYAtFp5otVRSCFvm4xGY9a/10H9ByhOI2ycTlo3wqZERUUxZ9YsAJo0a+pw88CX o6LYuXu3jNWI/8dczEl3z4GY/66lkLcp5sOgnJycaNaiueI0wlZ9s3IVIKM1wsaMCB2KwWCgafNm LFi8WHWcXDd37lx27t5NYGCg6ijCykgh77ikI29bUlIzCnlPT0/mzJ+vOI2wVeZCPus5WLkjENZu 7+497Nyxgzx58jB2/HjVcZSQTQfin5jvwqWOdxzyoM02yf24sKSsPfJCWLOUlBSGhYYCMHhoKAHP Pac4kRryC0D8E/PMrRR3jkND5oy8/Bq3KSmGjAsV5VRXYQlyVZSwCfPnziUyIoLgkBC69+ypOo4y UsiLf2J+VlUudnUccrGrbUrJPPPBTe7HhQXIPb6wendu32bq5CkAfDplikMXsVLIi38iM/KORwp5 2yQdeWFJWaM1ckcgrFXYqFEkJiby9jvvUK/+m6rjKGU+vVMKefH/yJC8w5FC3jZJQ0ZYknTkhVX7 6fhx1q5eg5ubGxOnTFYdRzn5BSD+iXTkHY8U8rZJGjLCkqSQF1bLZDIxZOAgAD7p3VtOMuXPQt7R 9ueL/yYXuzoeKeRtkyFztEYKeWEJUsgLq/Xl8uWcPnWK5wsVYsDgQarjWAXpyIt/Yt5cotXI3bqj kELeNsn9uLAkmZEXVikuLo4JY8cBMG7CeDw8PBQnsg7yC0D8ExmtcTxysKttSk3JHK1xk/txkX3S uhFWadL4CcTExPD6G2/wUZMmquNYDZmtFP9ECnkhbIMhJXO0xkXux0X2SSEvrM65s2dZtmQJTk5O TJk2VXUcq+Lm5gaAXq9XnERYGynkHY+M1timVPO1TtKQERYghbywOqGDBmM0GunQqRNlypZVHceq FC1aFIArV64ozSGsj1zs6nikkLdNKZmjNW4yWiMs4LEZecVJhAA2rl/PkR9/JF++fAwfNVJ1HKsj hbz4J3Kyq+ORQt42pWSO1rjIaI2wALnHF1ZDr9czeuQoAEaGjSZv3ryKE1kfKeTFP5HRGscjhbxt Mi8tMI9KCpEdUsgLqzFj6jRu3rjBSxVe4uN27VTHsUrmQj4qKkptEGF1pJB3PFLI2ybzaI2rq5wH IrJPCnlhFaKiopgzaxYajYYp06bJeMA/KFSoEC4uLty+fTvrUBEhQAp5hyT7J22SjNYIS5I98sIq jAgdisFgoGnzZlR59VXVcayWVqulcOHCpKenc/XqVdVxhBVJN2UW8lop5B2FdORtk4zWCEuStqdQ bu/uPezcsQNPT0/Gjh+vOo7Vk/Ea8XekI+94pJC3TeYDoVxktEZYgBTyQqmUlBSGhYYCMHhoKP4B AYoTWT+54FX8HSnkhbAN5rFIOdhPWIKz+Q15RC9UmD93LpEREQSHhNC9Z0/VcWyCFPLi70gh73hy oiNvMBhITk4mNTUVnU6HTqfD2dn5v79QPLHU1IzRGldXGa0R2edM5oy8ELntzu3bTJ08BYDJ4eG4 uMjTjE/CXMhfunRJbRBhVaSQdzz/VMg/evSIyIhIIiMiiIyM4EpUFAmPEkhKTiI5KZmkpCSSk5NJ TkoiKfN1siGZ5KTkv31Q4OLigk6nw93DA3fza3cd7u4e6Nx1eGS+9vPzIzikBCEhIQSXCCEwMFAW F/wN2VojLEkeZgtlwkaNIjExkXfefZe6b9ZTHcdmVKlSBYDDhw+Tnp4uhVsuMiQnY0hJQaPRoNVq 0Wq0aDSg0WrRarV/vl9B8WI+2VUKJ8dhLrojIyPp3fMTLkdGEhERwb27d5/5Nt3c3NDpdLi4uGQU +5nd+dTUVB49evR0t6XTUbx48YzCPrO4f+WVVyj1wgvPnM8eyGiNsCQp5IUSx48dY+3qNbi5uTFx ymTVcWxKyZIlCQoKIjo6mjNnzlC+fHnVkayCyWQiJiaGB/fvEx8fT5Jen9Vt1CclZXQdk5LRJ+kz upLJSSTpk0hOTkKvz/x4cjJ6vZ7k5IyuZVLm15k7mU8zwqDRaP5S2Gs0moyC/2/e//jbLq6ueHt7 4+Pjk/GS1wcfn7z/8+eMF2+fvFl/NhqNWd9X2LfkpCRWfv01U6eEA/DHxYv8cfFi1sfdPdwpXjyY 4sHBBAcHUzy4OHl9fXHXuaNz1+Hu7o5Op8NNp8Ndp0Pn7p71sb/7+UlNTc36t2D+t5SkT8r6N2R+ fffOHSIiIjKfCYjk1s2b/H7+PL+fP/+X26teowbdevbg7XfeccgHnjJaIyxJZuRFrjOZTIQOGgxA rz59skZFxJOrW7cuy5cvZ+/evXZbyKemphLz4AH379/n/v37PLh/n/v3H2S+fvx9Ga9jY2OzutI5 xU2nw83VlfT0dEwmE6Z0E+npkG4yYTKZ/nx/5tvmPz+tmzduPHPGz6bPYO3qNf/vgUDevHkpXKQw QUFBBBYuTGBgoKy/szGPHj1i7uzZLF6wkAcPHgAQVDiIho0aERISQvHgYEJCQgh47jmLPqBzcXHB xcUFb2/vp/o6vV5PZERE1jMFf1y8yPat2zh86BCHDx2iSJEi9Onfj/YdOzrUA1CDwbx+UjryIvtk Rl7kui+XL+f0qVMUCgxkwKBBquPYpHr16mUV8gMGDFAd56kZkpO5fPlyVvcu6nLUX4ry+5ld9aeh 0Wjw9fUlX/78+Pr64uHhkXGxnrs7Hh7u6HTuuHv82Xk0z/XqdJkfd3fHPfNFp9P99eszP/dpio3H C/mswt5kwvQ373/87dSUFOLj4/98ict4HRcXm/Xnh1kfj8v6+MOHDzEajTx6+JALDx8+0f+vAgUL EhQURFDhwpmvM97O6OIGO2S31FodP3aMrp06EX0tGoCKlSrSq08fGjZqhJOTk+J0f8/Dw4Ny5ctT 7rFmw6NHj1j51dcsmj+fqKgoBvbrz8b1G/hi7hyKFSumMG3uSUxMAMAjTx7FSYQ9kNEakavi4uKY MHYcAOMmjMfdw11xIttUt25dAA4dOkRqaqpVXihsMpmIjo4m8lJEZsF+KeP1pQiuX7/+n51qrVab VZgXKFCAfPnzkz/zJePtfFnvK1CgAL5+fla1XePx0Zqn9XyhQk/9Nenp6SQmJhIfF0dcXNzfPhC4 dfMW0dHXuHb1GtevX+funTvcvXOHE7/88v9uz93DnRdfLE2ZsmUpW64cZcuVpUzZsk/dlRXZYzQa mTYlnGnh4RiNRiq+XIlxEybwRrVqqqM9Ey8vL7r37EHX7t3YunkzoYOH8OMPP1D9taqMHjuWLt26 2n13PjEhEYA8UsgLC7Ce33rCIUwaP4GYmBiqVa/Oh40bq45jswICAihTpgznzp3j2LFjVK9eXVmW 9PR0zp45w+lTp4i4lNFhj4iIIOry5ayLuv6Xq6srxYoXp0SJEgSHhBBUOOixAj3jtZ+fn3SEn4JG o8HT0xNPT08KBQb+5+enp6dz/949oqOjuXb1KtHR0URfy3j7wu+/c+3aNX49cYJfT5z4y9cFFQ6i bNlyVHrlZerUqctLFSvI31MOib4WTddOnTh+7BharZb+AwcybOQIq3rA+qy0Wi0NGzWiRq1aDB08 mLWr1zB08GC2bt7M8q+/ws/PT3XEHGPuyOfJ46k4ibAHWaM1MiMvctq5s2dZtmQJTk5OTJ4arjqO zatXrx7nzp1j7969uV7IX7lyhYP793PwwEEOHzyYNa/7v54vVIiQkBBCMgv2EiVKEFKyBEFBQVY7 DuAozKM1BQoWpNLLL/+/jz969IhzZ89y7uxZzp7JeH3+3Dmir2UU/Du2b2fiuPH4+vpSo1Yt6tSt Q63adQgqHKTgv8b+HD50iLatWhMfH8/zhQoxf9FCqil8wJ5T8ubNy/xFi2jYqBED+vbjh8OHqV+7 Dms2biA4OFh1vByRkNmR9/KSQl5kn+0/rBc2I3TQYIxGI126daV0mTKq49i8unXr8vnnn/P9998z duzYHP9+RqORTRs28vlnn3Hu7Nm/fKxQYCCvVX2NEiVLZnXZQ0qUwMPDI8dziZzh5eXFa1Wr8lrV qlnvS09PJyoqilMnT3Jg/wEO7N9H9LVovtu0ie82bQIgOCSE+m+/RYeOHQkpUUJVfJu2Y/t2OrZr jyE5mXcbNGD2/HnkzZtXdawc9W6DBlSuUoWWTZvx64kTvFWnLl+v/uYvP3/2IiHB3JGX0RqRfRpf T68vgY/nLVxI85YtVOcRT6BooUAePnxI1PVofHx8VMd5IhvXr6dzh47ky5ePn387afe/lHLDo0eP sp5+jomJwcvLK8e+15bNmxkzchRRUVFARpFXvUYNatauTe06taVgc2CRkZEc2LePA/v2c+jgwaxd 4xqNhpq1a9GlWzfeevttGb95QmtXr6FXjx6kpaXRoVMnps6Y7lD/75L0SXTp2JHt27bh5ubG7Hnz aNy0iepYFlX4uedJSEjg6s0bOXq/Leybn1fG9UqOc+8glNHr9YweOQqAUWPCpIi3EC8vLypXrkxa Whr79u3Lse9z6+ZNenTpSlRUFMHBwcyaN5fIa1f5evU3dOnWVYp4BxccHEynLl346ptVRF67ys69 e+jUpQseHh4c2Lef1s1bUKlceb6YOZPY2FjVca3a4oUL6dG1K2lpaQwYNIjpMz9zqCIeMi6y/nLV Srp274bBYKBrp04sX7pUdSyL0uv1gHTkhWVokRl5kcNmTJ3GzRs3qFCxAm3atlUdx640a9YMgKU5 +ItubFgYer2e9z/4gGMnfqF1mzZ2cbGdsDxnZ2eqvPoqU2dM59wfF5k0ZQrFixfn2rVrjBk1mioV K6mOaLWmhYczZGDGOt4JkyYxMmy04kTqaLVaJk+dyoRJk0hPT2dQ/wGsX7tOdSyLSNInYTKZ0Lm7 O9yDNJEz5KdI5KioqCjmzJqFRqNhyrRpcsdlYe3atUOn07Ft2zauX79u8ds/9dsp1q1Zi87dnYmf fioXqIon5u3tTfeePfj5t5OsWb8eDw8PHjx4QFxcnOpoVmfOF7OYNH4CTk5OzJo3l569e6mOZBV6 9u7FhEmTMJlM9OzWjR3bt6uOlG0JCRmjZ16ecqGrsAypqkSOGhE6FIPBQPOWLahcpYrqOHbH19eX pk2bYjQaWbx4scVv/+iRI6Snp9OiZUsCg/57paEQ/0uj0fDmW/WzRrCir11TnMi6bNqwgdEjR6LR aJi3cCGtWrdWHcmq9Ozdi9Bhw0hLS6Nj23YcPHBAdaRsSUiUHfLCsqSQFzlm7+497NyxA09PT8aM G6c6jt3q2rUrAIsXL8ZoNFr0tiMuXQLghRdftOjtCsdj3mBk3tgh4McffqBnt+6kp6czZvw4mjRr qjqSVQodPowevT7BYDDQunkLfv7pJ9WRnlmieWONdOSFhciMvMgRKSkpDAsNBWDI0KEU9PdXnMh+ VatWjdKlS3Pjxg22bt1q0ds2F/L2us9Z5B43nQ6AlH84JMzRXPj9d9q0aJlxQWf3bvTu21d1JKs2 YdIk2rRti16vp0WTply9elV1pGeSKB15YWHSkRc5Yv7cuURGRBBSogTdevZQHcfumbvy8+fPt+jt Xsos5IuHSCEvskfn5gZAshTy3L51i6YfNSY+Pp73P/iASVOmqI5k9TQaDTNnfUG9+m8SGxvLxy1b kaRPUh3rqSVmHgaVx1MKeWEZUsgLi7t96xZTJ2f8YpocHo6Li4viRPavbdu26HQ6du/enbXrPbtS U1O5dfMmTk5OBAXJaZ0ie1wzC3lH78inpKTQukULbly/zmtVq7Jw8SJZAvCEtFoti5YuJTg4mLNn ztCn1yeqIz0188Wunp6yP15YRta9RzoyWiMsY8zo0SQmJvJugwbUqVdXdRyH4OvrS7NmzTCZTCxa tMgit/l4cSHrJkV26XSZHflkxy7kR48YwclfTxIcEsLKNauzRo7Ek/Hx8eHr1d/g6enJhnXrmfPF LNWRnor5YldP6cgLC8makRfCEo4fO8ba1Wtw0+mYMPlT1XEcinm8ZsmSJVkHjmSHk5MTWq0Wo9GI yWTK9u0Jx+bqmlHIGwzJipOos+W771g4fwFuOh3Lv/oSX19f1ZFsUqkXXmD+4kVoNBrGjB5tU5ts skZr8sjFrsIy5Pk8YTEmk4nQQYMB6N2nD0WLFlUbyMG88cYbVKlShbt37zJjxgyL3KZ5LCo1NdUi tyccly6z82xw0NGaqKgoevfMGAWZHD6FMmXLKk5k295t0IAhw4ZiNBrp3L4D9+7eVR3piSQmZm6t kYtdhYVIIS8s5svlyzl96hSFAgPpP3Cg6jgOadq0aQBMmTKFO3fuZPv2zCM1UsiL7HLLHK0xOOBo jcFgoGPbtjx8+JDGTZvQrkMH1ZHswpChQ3nzrfo8ePCAvr16q47zRORiV2Fpf87Iy/pJkQ1xcXFM GJuxK37CpIm4e7grTuSYqlevTqNGjUhISGDMmDHZvj1XV1dACnmRfW7m0ZoUxyvkRw4bzqnfThEc HMxnX3yhOo7d0Gg0fDF7Nr6+vuzcsYOVX3+tOtJ/Ml/sKqM1wlJkRl5YxKTxE4iJiaF6jRp88OGH quM4tClTpuDs7MyiRYv4/fffs3VbLpmFvCHZceeahWU4akd+y3ffsWTRItx0OpZ99SWechCQRfkH BDDts4xRwuFDQom+Fq040b9LyOzIe3nJz4GwDBmtEdl27uxZli1ZgrOzM5OnhquO4/BKlixJt27d MBqNhGYeyvWsAgICALh586YlogkH5uTkBEBaWpriJLknPj6eQQMyxgzHTZhA2XLlFCeyTx82bsyH jRvz6NEjevXoYdUTBuYDoby8ZP2ksAwp5EW2hQ4ajNFopFOXzrxYurTqOAIICwvD29ubLVu2cCAb Gx3M++Ojr12zUDLhqOLj4wHwyeujOEnuCRs5int371K5ShU6d+2iOo5dm/bZDAr6+3P40CEWzLPs wXiWdC3zRNqgwoUVJxH24s9C3oofwQrrtXH9eo78+CP58+dn6IgRquOITAUKFGDYsGEADBo06Jk7 VIFBgQBck0JeZFNsTCyAw6xcPHrkCF+tWIGLiwufz56FRqNRHcmu+fr68sWc2QCMDQuz2MF4lnY5 MhKA4sFyWrawDJmRF89Mr9czeuQoAEaNCcPHx3E6bbagrDsmfAAAIABJREFUX79+BAUFceLECRYu XPhMtxEUlNE1sva5U2H9YmNiAPD181OcJOelpKTQr3cf0tPT6dOvHy+8+KLqSA6h/ltv0bR5MwzJ yYwcOkx1nP8nNjaWuLg4fH19yZs3r+o4wk7IaI14ZjOmTuPmjRtUrFSR1h9/rDqO+B86nY6ZM2cC GUX96dOnn/o2ggpnjNaYnw4W4lnFmAt5B+jIfzZ9Opf++IPg4GAGDRmsOo5DGTt+PHny5GHH9u3s /36f6jh/Ye7GFyteXHESYU+kkBfPJCoqijmzMp4unjJtGlqt/ChZo48++oiePXuSnJxMs2bNSEhI eKqvDwzMnJGPlo68yJ7YWMcYrbn0xx/MnJ6xReWzWV/glnkQlsgdAc89x6DQIQAMHzrUqi6ujoww j9VIIS8sJ2u0xpqv8hbWZ/iQUAwGAy1ateSVypVVxxH/YsaMGVSsWJGLFy/SvXv3p/rawkWLABkd ebmPENlh7sj72flozbiwMRgMBlq3aUO16tVVx3FIPT75hODgYC5euMDihYtUx8li7sgHB4coTiLs ibRRxVPbu3sPu3buxMvLi7CxY1XHEf/Bzc2NNWvW4OXlxcqVK1m8ePETf22+fPl47vnnSUxM5MqV KzkXUti9uMyOfF477sif+OUXtm3dSp48eQgbP051HIfl6urKxCmTAZgyaRIPHjxQnChDZGQEIKM1 wrKkkBdPJSUlhWGZu8mHDB1KQX9/xYnEkyhRogQLFiwAoE+fPpw5c+aJv/all14C4PRvv+VINmH/ EhISSE1Nxd3DHTc3N9Vxcsz4MRmNjZ69epE/f37FaRxb/bfeov5bbxEfH8/EceNVxwHg8uXLgIzW CMuSQl48lflz5xIZEUGJkiXp2uPpxjSEWi1btqRLly4kJSXRtGlT4uLinujrymcW8qd+O5WT8YQd u555jYV/Qft94H9w/34OHTyIn58fvfr2UR1HABMnf4qTkxNff/mlVazQvRwhF7sKy5MZefHEbt+6 xdTJUwCYHB6Oi4uL4kTiaX3++eeUL1+eixcv0qhRIwwGw39+TfkKmYX8KenIi2fz+/nzAHa9hnFc 5phhvwED5NROKxEcEkLjpk1IS0vji89mKs3y4MED4uPj8fHxIV++fEqzCPsiHXnxxMJGjSIxMZEG 771H7bp1VMcRz8Dd3Z2tW7dSqFAhDh48SNu2bf/zQXz58ubRGunIi2fz+/nfAShdpoziJDljy+bN nDzxKwHPPScnuFqZgYMHo9VqWfnVV9y5fVtZjgP79gNQrnx5ZRmEfZJCXjyR48eOsW7NWtx0OiZM /lR1HJENQUFB7NixAx8fH9auXcuAAQP+9fMDgwLx8/PjwYMH3Lh+PZdSCnty/tw5AEqXKa04ieWZ TKasGewhQ0PRubsrTiQeV6JkSRpmPvs4e9YsZTnWrP4GgMZNmyjLIOyTFPLiP5lMJkIHZRxq0qdv X4oUKaI4kciucuXKsWnTJlxdXZk5cybTp0//9883z8mfkq68eHrm0ZoyZcsqTmJ5e3bv5o+LFyla tCht2rZVHUf8jUFDBqPRaFi2eEnWGtTcdO3aNQ7s24+rqysffPhhrn9/Yd9kRl78py+XL+f0qVME BgXSf+C/d2+F7ahduzbLly9Ho9EwePBgVq1a9Y+fa95c88tPP+dWPGEnkvRJXL16FVdXV4JD7G9/ 9rLFSwDo1KULzs7OitOIv1O6TBnebdAAvV7P/Dlzc/37h40cRVpaGh81aUzevHlz/fsL+yYdefGv YmNjmTA2Yx/yhEmT5GljO9OyZUvCw8NJT0+nbdu2LFu27G8/7/VqbwBw8OCBXEwn7MGFCxcwmUyU LFXK7grd6GvR7N2zBzedjlYft1EdR/yLgUMyTntdsmhRrp72evjQIb7btAkPDw9GhYXl2vcVjkMK efGvJo2fQExMDDVq1qRho0aq44gcMGjQIEaPHo3RaKRTp05/O2bz+htv4OzszOnfThEfH68gpbBV 58/b73z8imXLMJlMfPjRh/ja8UFX9qBCxQqULVeO2NhYjh45kivf88b163Tu0BGAfgMH8Nzzz+fK 9xWOJauQl9Ea8b/OnT3L8qVLcXZ2ZvLUcNVxRA4aO3Ysn3/+OZBR2A8fPvwvH/f09KRipUoYjUZ+ OHxYRURho8wHidnbxprU1FS++vJLADp06qQ4jXgS77z7LgA7t2/P8e+VpE+iVfMW3Lt7l5q1atHv P5YKCPGssmbkhfhfoYMGYzQa6dy1i13vfxYZ+vTpw5dffomzszOffvop3bt3x2QyZX28Zq1aABw6 cEBNQGGT9u39HoCXX3lFcRLL2r51K/fu3qVsuXJUrlJFdRzxBN7OLOR3bMvZQt5gMNClY0fOnD5N SIkSLP/6K7sbKxPWQ0ZrxN/auH49R378kfz58xP6P91ZYb/atGnDt99+i7u7OwsWLPjLCbA1atUE 4OCBgyojChty5coVIiMj8fLy4tXXXlMdx6KWL1sOQMfO0o23FRUqViDguee4cuUKF37/PUe+R3x8 PE0afcj2bdvw9fXlm3Vr8fHxyZHvJQRIIS/+hl6vZ9SIkQCMHjtG7oQcTIMGDdi9ezc+Pj5s3LiR MmXKsGXLFipXqYLO3Z0/Ll5UerCKsB17d+8GoFbt2nbVkUxNTeXYkSNoNBoaffSR6jjiCWk0Gt56 +23gz2eKLOnG9eu882Z9fvzhB54vVIhtu3YSHBxs8e8jxONkRl78P9PDp3Lr5k0qvlyJ1h9/rDqO UKBatWocP36cqlWrcvPmTRo2bEinTp14+eWXAenKiyfz/Z69ANSr/6biJJZ1/tx5DAYDxYsXl3WC NqZCxQoAREZGWvR2161ZS50aNbnw+++88OKL7P5+r4ykilwhM/LiL6Kiopg7ezYajYbwadPQaDSq IwlFSpUqxQ8//MCMGTPw8PBg5cqVHPvpOAD7vt+rOJ2wdgaDgcOHDgFQt149xWks6+SvJwCoUKmi 4iTiaRUpUhSAq1evWOT2Lv3xBx80eI9unTtz7949atetw449u3m+UCGL3L4Q/0VGa8RfDB8SisFg oGWrVnZ3cZp4elqtlv79+3P69Glq1qxJTOa8/M7tOzAYDIrTCWt27MgR9Ho9L5YubXdFjbmbWz7z oDRhOwoXzTiZ/OqVq9m6neSkJCaOG0/1qq9z+NAhChQsyMIlS9jw7bcyjipylRTyIsve3XvYtXMn Xl5ehI0bqzqOsCLBwcHs37+fWbNmkQ48fPiQ/fv2qY4lrNjevZljNW/a11gNQFxsxgPa/PkLKE4i nlZQUBBarZbr0dHPPFK8Z9duqlauwvSpU0lLS6Nj58789OsJmjRrauG0Qvw3mZEXAKSkpDAs8+S7 0GHDKFCwoOJEwtpoNBp69uxJ3379APhu0ybFiYQ127Mr40JXe5uPB4jPfGbKJ690Xm2Ni4sLzxd6 HoPBwO1bt57qa69cuUK71m1o3qQJV69epVz58uze9z3TPpshXXihjMzICwDmzZlDZGQkJUuVokv3 bqrjCCvWtkN7IGMXs4zXiL9z8sSv/HHxIvny5eO1qlVVx7G42NhYALnQ1UaZ5+SvXLnyn5+bmprK 5m+/pXGjRrxc/iW2bN6Mp6cnEydPZt+hg1TKXAAghCr2sw9MPLPbt24xbUrGya2Tw8NxcXFRnEhY s+LFi1P+pZc4feoU+/ft4+133lEdSViZ5cuWAdCidSu7vD8xn60gXVjb5OvrC8CDBw/+8XMiIyP5 avkKvlm5knv37gHg4eFB46ZNGTp8GM89/3yuZBXiv0ghLwgbNYrExETee/99atWprTqOsAEffNiI 06dO8d2mTVLIi79ISEhg4/r1ALRr315tmBxiHkWVrV62SevkBIAxLe0v7zcYDGz5bjNfLl/OD4cP Z73/pQov0a5DB5o0a4anp2euZhXivziTOVojM/KO6fixY6xbsxY3nY4Jkz9VHUfYiIaNGjF+zNis 8Ro3NzfVkYSV2LBuHYmJibz+xhuElCihOk6OyJMnD5BxeJ6wPebDyYxGIwkJCRw7cpS9e3azbs3a rLEpT09PmjRrRrsOHXipgmwnEtZLOvIOzGQyETpoMAD9+vencOHCihMJWxEcHMxLFV7i1G+n2LZl Cx81aaI6krASKzLHatraaTcewCOzkE9MSFCcRDwLJ6eMPR8Txo2nW+cuGI3GrI9Vevll2nfswEdN muDh4aEqohBPTNZPOrAVy5Zx+tQpggoH0bd/P9VxhI3p0KkTAIsXLlKcRFiL06dO8dvJ38ibNy8f NPpAdZwckyezwEuUjrxNMnfkr0RFodVqefW11xg0ZAiHjx5h74H9tGnbVop4YTOkkHdQsbGxTBw3 HoAJkyahc3dXnEjYmqbNmuPj48Oxo0c5d/as6jjCCqxYthyA5i1b4KbTqQ2TgzzyZBR5+kQp5G2R VpsxI/9J795cuX6dHXt2M3zUSMqULas4mRBPL2v9pMzIO5ZJ4ycQExNDzVq1eP8D++2ciZzj7uFO qzatAenKC3j06BHr164F7HusBsDDwzwjn6g4iXgWTpkXu5YoWQJ3D2liCdsmHXkHdPbMGZYvXYqz szOTp4arjiNsWMfOndFoNKxbs4aHDx+qjiMUmjtrNo8ePeKNatV4sXRp1XFyVJ7MjnyidORtknlb jbmgF8KWSSHvgIYOHoLRaKRLt66UeuEF1XGEDQsOCaFm7Vro9XpWfb1SdRyhSExMDHNmzQJg6Ijh itPkPHNHPjFRLna1RVkHemXukxfClmUV8jJa4xg2rFvPkR9/pECBAoQOt/9fuCLnde7aFYClixfL /YiD+nzGZyQkJFCzdm3eqFZNdZwcJzPyts18EJSvFPLCDmTNyAv7p9frGT1yJACjx47B29tbcSJh D956+20CgwKJuHSJrZs3q44jctmd27dZtHAhACNHj1KcJnfkyZNxKJDMyNummJgYAPz8/BQnESL7 ZLTGgUwPn8qtmzep9PLLtGrTRnUcYSecnJwYODjjPILhQ4fJITkOZsa0aSQnJfH2O+/w8iuvqI6T K2RG3rbFSiEv7IgU8g7i8uXLzJ09G41GQ/j0aXK0uLCoj9u1o9LLL3Pj+nWmTJITgh1F9LVoVixb jkajYfiokarj5Bo52dV2paenExcXB8iMvLAPj83Iq4whctqI0KEYDAZatW5NpZdfVh1H2BmtVsv0 mTNxcnJi/ty5XPj9d9WRRC4InzyZlJQUGjZqRNly5VTHyTVBmadgX4+OVpxEPK2HDx+SlpZGnjx5 cHV1VR1HiGyTGXkHsGfXbnbt3Im3tzejx41VHUfYqZcqvETHzp1ITU1lUP8BquOIHHbyxK+sXrUK rVbLMAfYVPO4osWKARkngwrbkjUfn0/GaoR9kNEaO5eSksLw0FAAQocNo0CBAooTCXs2YvRoCvr7 c+THH1nzzWrVcUQOSU1Npfcnn2A0GunR6xNKliqlOlKuypcvH15eXty7d4+EBFlBaUuir10DICDg OcVJhLAMKeTt3Lw5c4iMjKTUCy/QpXs31XGEnfP29mbCpEkAjB4xgvj4eMWJRE6YOWMG58+do3jx 4owY6Tiz8Y8rHlwcgKjLlxUnEU8j4tIlAEqUKKE4iRCWIXvk7djtW7eYNiXj5NbJU8NxdnZWnEg4 gibNmlK9Rg3u3bvHhLHjVMcRFnbxwgWmh09Fo9Hwxdw56Nwd84j7osUyCnkZr7Et5kI+pKQU8sI+ yIy8HQsbNYrExETeb9iQmrVqqY4jHMi0z2bg4uLCsiVLOPnrSdVxhIWYTCb6fNKLlJQUOnbuzOtv vKE6kjLFMufko6SQtymXzB35kiUVJxHCMmS0xk4dP3aMdWvWonN3Z8Knsg5Q5K4SJUvSq08fTCYT vXr0IDFRDs6xB4sWLOTnn34iMCiQMAe/cP7P0Rop5G1JxB8yWiPsixTydshkMhE6KOOAnr79+xFU OEhxIuGIBg0ZQslSpfj9/Hl6du0m43s2LvpaNOPHjAFg5hez8PT0VBtIMfPmGpmRtx0Gg4Ho6Gic nJyy/v6EsHVZozXyS9Z+rFi2jNOnTlG4cGH69uunOo5wUO4e7qxcsxofHx+2bN7M1ClTVEcSzygt LY0eXbui1+tp1bo1derVVR1JuT9Ha6SQtxWXIyMxmUwULVpUdsgLuyEdeTsTGxvLxHHjARj/6SSH vRBNWIfg4GCWLF+Ok5MTUyZ9yvZt21RHEs9gxNChHPnxR/wDApgwWUb1AJ4vVAg3nY4b12+QkpKi Oo54Apf++AOAEBmrEXZECnk7M2n8BGJiYqhZuzbvN2yoOo4Q1KlXl7CxY0lPT6d75y5cvHBBdSTx FFZ+/TWLFiwEIE+ePJw88aviRNZBo9FQpEgRTCZT1m5yYd1O/HICgBdLl1acRAjLkULejpw9c4bl S5fi7OzMlKnhquMIkaVX3z40bd6MhIQEWjdvQVxcnOpI4gn8euIEg/r1B8DX15fLkZE0btSIjz74 gK1bthAbG6s4oVrFi2dc8Hr+3DnFScST+PmnnwB4tepripMIYTkyI29HQgcNxmg00qV7N4c7aVFY vy9mz6ZipYpcvnyZTu3bYzQaVUcS/+Le3bt83Ko1BoOBTl26cP6Pi4SNG4u3tzcH9u2nbavWhBQp Ss03qjFi2DC2btlCxKVLpKamqo6ea16pUhmAgwcOKk4i/ktKSgonT55Eo9FQ5dVXVccRwmLkhCA7 sWHdeo4eOUKBggUZOny46jhC/D9uOh1frVpF7Ro12f/9PsaGhTFuwgTVscTfSE1NpV2bj7l18yZV X3+dSVMm4+LiQt/+/fm4XTuWLFrEoQMH+eXnnzlz+jRnTp9m3uw5ADg5OVG4cGGKhwQTEhJCcEgI wcEhBDwXQL58+fD188PFxUXxf+GTi4+P5+6dO9y+fZu7d+5y5/Zt7ty5w7Vr1/jl558BOHRQCnlr d+b0aQzJyZQsVQpfX1/VcYSwGCnk7YBer2d05jHpo8eOwcvLS3EiIf7e84UK8dWqlTR8twGzP/+C cuXK07R5M9WxxP8YNiSUY0ePUigwkOVff/WXwtvPz4/BoaEMDg0lOSmJn376iR8OHebXX09wOSKS 6OhooqKiiIqK4vs9e//29r29vcmXLx9++fKRL18+8uV/7O3H3u/n54dfvnz4+vri5OSUrf+mJH0S 8fFxPHz4MOMl/iEPH8YTHx+f9ee4uLisov3O7dvcuXsXQ3Lyf952xKVL3L51i4DnnstWRpFzfjqe OVbzmozVCPuSVcjLaI3tmh4+lVs3b/LyK6/QqnVr1XGE+FdVXn2VqTOm07dXb/r06kWx4sV4pXJl 1bFEplmff87SxYuznkEpUKDAP36uzt2dGjVrUqNmzaz3paamcu3qVSIjI4mMiORyZCQRERHcvHGD mAcPiI2NzSqmn/RUVI1GQ968ebMK/DyeeTAZTRiNxqyXtLQ0TCYjxsfeb0hOzvpeaWlpz/T/w93D nQD/AAr6+1PQ3x9/f3/8A/wpXLgIZcuVZcyo0ezZvZtDBw/RrEXzZ/oeIuf9dPw4IPPxwv44kzkj L2zT5cuXmTt7NhqNhvBp09BoNKojCfGfPm7XjjOnz7B44UIaf9CI9d9uonKVKqpjObwF8+YTNnIU Wq2WufPnUaFihae+DRcXl4xxmpAQeOv/f9xkMhEfH0/Mgwc8yHyJyXod85c/P3jwgNiYGOLi4oiN jSU2NpbIiIhn+m/Tubvj7e2Nt7c3Pj4+ePt44+3tk/E+H/P781KwYAH8AwKyivb/OviqZq1a7Nm9 m8MHD0ohb8WyLnSVjrywMzJaY+NGhA7FYDDQ+uOPqfhyJdVxhHhik6ZM5v79+3y7cSONP2jEuk0b 5ZesQsuXLmXYkCFoNBo+nzObDxs3zpHvo9Vq8fX1xdfXN6PYfwImk4nY2NisAj9Jn4TWSYuTk9P/ vDjj9Nj7Xd3csor3nJrLr1Er49mIgwcP5Mjti+y7evUqN2/coECBAgQHB6uOI4RFSSFvw/bv28eu nTvx9vZm9NgxquMI8VScnZ1ZtHQJTk5aNqxbT5NGH7J24waqvv666mgOZ9XKlQzMXDM5feZntG7T RnGiv9JqtVnz89Z2lE+ZsmXx8/PjevR1oqKisk58FdZj+5atAFR/bARMCHvx5x55mZG3OePCxgAw dMSIf51jFcJaOTk5MX/RIpq1aE5iYiJNP/yIH3/4QXUsh7Jh3Xr69PyE9PR0Pg0Pp33Hjqoj2RSN RkO1GjUAOCzba6zSls2bAXi/4fuKkwhheVl75IXtuRIVxQsvvkjnrl1URxHimTk5OTF3wQJatW6N Xq+nWePGHD50SHUsh7Dlu+/o0bUrJpOJsRPG061Hd9WRbFKNmhmF/KGD8nNrbe7dvctPx4/jptNR r3591XGEsDg52dUGPb5haPLUcJydZUJK2DatVsuseXNp07YtSfokmjdpysEDB1THsmubv/2Wzh06 kpaWxrCRI+jdt6/qSDbLvLXn8MGDctCZldm+bRsmk4k6deqQJ08e1XGEsDgp5G1QcuZe44aNGv1l 7ZsQtkyj0fD57Fm079iR5KQkWjZrzoF9+1XHsjsmk4mJ48bToW07UlNTGTh4MINDQ1XHsmkhJUrw YunS3Lt3j21btqiOIx5jHqtpIGM1wk5lFfKyR942HDt6lNTUVHQ6HRMmTVIdRwiL0mg0TJ/5GZ26 dMko5ps3Z/u2bapj2Y34+HhaNG3K9KlTcXJyYtKUKYwYPUp1LLtgHkuaP3ee4iTC7OHDhxw+eAhn Z2feefdd1XGEyBEyI29DTCYToYMGA9Bv4AACgwIVJxLC8jQaDVNnTKdbj+4YkpP5uGUrJo4bj8lk Uh3Npv1+/jx1a9Rk7+495M+fn42bv6N7zx6qY9mNZs2b4+vry7GjRzn12ynVcQSwc/sOUlNTeaNa NXx9fVXHESJHyGiNDVmxbBlnTp+mcOHC9O3XT3UcIXLUp+HhTJg0CScnJ6ZPnUrjRh/y4MED1bFs Tnp6OqtWruTN2nW4fPkyFStVZP/hQ1SrXl11NLuic3enbfv2ACyYN1dtGAHAVytWAPDBh40UJxEi 50ghbyNiY2OZOG48ABMmf4qbTqc4kRA5r2fvXny7dQsF/f05uH8/tapVl7n5p3Dil1+oX6cuvbr3 QK/X07J1K7bv2kWhQHk2Lyd06tIFJycnNq7fwL27d1XHcWjnzp7lxx9+wNvbm6bN5cRdYb9kRt5G TBo/gZiYGGrVqc1778tFO8JxvP7GGxz84TCvVa3KjevX+eiDD/i4ZSuuXLmiOprVunXzJt27dKF+ nbqc+OUX/AMCWLB4MXPmz5cmQA4KDAqkwfvvk5KSwtIlS1THcWgL5s0HoPXHbWRbjbBrMiNvA86e OcPypUtxcXFhcni46jhC5Dr/gAA2b9/GxE8/xdvbm21bt1L1lcpMGDsOvV6vOp7VSEtLY84Xs6hc sRJrV6/BxcWFvv3788tvJ2navJnqeA7BfNHr0sVLSElJUZzGMcXExLB+3Tq0Wi2du3VTHUeIHCWj NTYgdNBgjEYjXbp3o2SpUqrjCKGEs7MzPXp9ws+/naRN27akpKQwY9o0qlR6mU0bNqiOp9zBAweo XvV1Ro0YgV6v56233+bIzz8RNm6sdCRzUdXXX6f8Sy9x7+5dNm3YqDqOQ/py+XKSk5J4s359ihUr pjqOEDlKCnkrt2Hdeo4eOUKBggUJHTZMdRwhlCtQoABfzJnN3gMHeKVyZW7euEGn9h14/513HXbc ZsTQoXz4fkMuXrhASIkSbPj2W75Zt5bixYurjuaQumZ25eWi19xnNBpZsmgxAN16yFYmYf+yRmtk Rt766PV6Ro8cCcCYcePw8vJSnEgI61GxUkV2fb+XOfPnU9Dfnx9/+IHWzVuQpE9SHS1XnfrtFPPn zsPNzY2xE8bz4/Fj1K5bR3Ush9a4SRPy58/Pbyd/4/ixY6rjOJQN69Zz4/p1SpYqRa06tVXHESLH SUfeik0Pn8qtmzd5pXJlWrRqqTqOEFZHo9HQsnUrfj75Ky+8+CK/nz/P6m9WqY6Vq0aPGEF6ejrd evSgd9++uLi4qI7k8Nzc3GjfsSMgB0TlpsTERMaGhQHQb8AAxWmEyB1SyFupy5cvM3f2bLRaLVOm TUOj0aiOJITV8vLy4qMmjQG49McfitPknuSkJI4dPQpAxy6dFacRj+vYuRMuLi5s3byZG9evq47j EMzNr8pVqtC8ZQvVcYTIFVLIW6kRoUMxGAy0/vhjKlaqqDqOEFbv8MFDAJR64QXFSXKPzt2dV197 DYCTJ04oTiMeF/DcczRs9AFGo5EF8+erjmP3IiMjs5pf4dOnS/NLOIw/Z+RlC6XV2LNrN7t27sTH x4dRY8JUxxHC6n2zchWHDx0iT548fNi4seo4uapOvboAfLliBUajUXEa8bhPevdBo9GwaP4CLl++ rDqOXRs2ZAgpKSm069CBlyq8pDqOELlGOvJWJiUlheGhoQAMHTGC/PnzK04khHXbtXMnA/v3B2D6 zJl4e3srTpS7GjZqhJeXF/u/30e/3n1kcYEVqVCxAq3atMFgMDB08GDVcezWzh072Lt7D35+fowM G606jhC5Sgp5KzNvzhwiIyN5sXRpOsnMqxD/auXXX/Nxy1YkJyXRpVtXmrVwvKPYixcvzpoN63H3 cGflV18xUtbUWpWwcWPJmzcve3fvYdvWrarj2B2DwcDwIRnNr5Fho/H19VWcSIjclVXISxdHvdu3 bjFtSsbJrZOnhuPs7Kw4kRDW67Pp0+ndoydpaWn0HziQKdOmqY6kzGtVq7Lym9W4ubkxb85cBvbr L2M2ViJ//vyMGD0KgOGhoQ63HjWnzfr8c65cuUKFihVo27696jhC5LqsGXmhXtioUSQmJvLBhx9S vUYN1XGEsEomk4mhgwczfsxYNBoNn4aHy7UkQK1ZVq8mAAAQKUlEQVQ6tVmx8mvcPdxZtmQJLZo2 JSEhQXUsAXTo1InyL71E9LVopk6ZojqO3Th29ChTJ09Bo9EQPn06Wq0MGQjHIz/1VuLY0aOsW7MW dw93xk+cqDqOEFYpJSWFLh07sXD+AlxdXVm8bCndMk/RFFD/rbfYun0HBf39+X7PXt6u9ybXo2X1 oWparZapMzIKzS9mzuT7PXtVR7J5N65fp13rNqSmptKrTx9eqVxZdSQhlJBC3gqYTCZCB2VcCNVv wAACgwIVJxLC+iQmJtK8SVM2bdiAj48Pazasd7gNNU+i4suV2Lt/Py+WLs35c+eoV7s2J389qTqW w6tcpQojRo/CZDLRtVMnrl27pjqSzUpOSqJNy5bcu3ePum/WI2zcWNWRhFBGZuStwIplyzhz+jRF ihShT9++quMIYXXu379Pw3ff5eD+/fgHBLBt105q1qqlOpbVCgwKZOfePdSpV5e7d+7Q4O23OXjg gOpYDq/fgAG826ABsbGxtM/cZiOeXu9PPuHUb6cIDglh8bJlMlIjHJrMyCsWGxvLxHHjAZgw+VPc dDrFiYSwLtHXonnnzfqc/PUkwcHB7Pp+L6XLlFEdy+p5eXmxet062rRtS3JSEq2bt+CXn39WHcuh aTQa5i5cQHBwML+d/I0BfftKE+0pff7ZZ2xYtx5vb2++WbsGHx8f1ZGEUEoexio2afwEYmJiqF23 Dg3ee091HCGsyu/nz/NWvXpERkRQoWIFduzdQ+HChVXHshnOzs58PnsWLVq1RK/X0+yjxpw7e1Z1 LIfm7e3Nl6tW4uHhwTcrV9GrRw/ZMPSE9uzazfgxY9FqtSxaupSQEiVURxJCOSnkFTp75gzLly7F xcWFyeHhquMIYVXu3b1Lkw8/4vatW9SsVYvN27fLAWnPQKPRMGvuXN7/4APi4uL46ING3Lt7V3Us h/Zi6dKsXP1NVjHfuUNHUlNTVceyart37aJD27aYTCZGjx3Dm2/VVx1JCKsgM/IKhQ4ajNFopGuP 7pQoWVJ1HCGsRlpaGh3btefWzZtUff111mxYj6enp+pYNsvJyYlFS5dQq05t7t29y8TxE1RHcng1 a9dm4+bv8Pb25rtNm2jbqjWG5GTVsazS4oULad28BXq9ng6dOtGnXz/VkYSwGjIjr8iGdes5euQI Bf39CZWTGIX4izGjR/PjDz8Q8NxzLPtyBa6urqoj2TxXV1dmzZmDzt2dr7/8UkZsrECVV19l8/Zt 5MuXj107d1Kreg3ZMPQYk8nEiKFDGTJwECaTiVFjwpg+8zPVsYSwKjJao4Ber2f0yJEAjBk3TjqN QjzmxC+/MHfWbFxcXFj+1ZcU9PdXHcluFAoMpFfv3phMJsaPkZV91qD8Sy+xbddOSr3wAhcvXOCt unWZOG48KSkpqqMplaRPom2r1sybMxc3NzcWLV1C/4EDVccSwupIIa/A9PCp3Lp5k8pVqtC8ZQvV cYSwKtGZ+7Xffvddqrz6quI09qdr5gFaPx0/rjiJMCtZqhQHfjhM3/79SU9PZ/rUqdSpUZNDBw+q jqbExQsXeO+dt9m+bRu+vr5s3PwdHzVpojqWEFZJZuRz2eXLl5kzaxZarZYp06ah0WhURxLCqsTE xADg5+enOIl9yp8/P35+fsTFxclFr1bEzc2NsHFj2bl3DyVKluT8uXM0eu993qxdhx3btzvE7+iL Fy7QqX0H3nj1NU7+epJixYqxe9/3VH39ddXRhLBaMiOfy4YPCSUlJYU2bdtSoWIF1XGEsDqxsbEA uLq6KE5iv4oUKwpkNBaEdXn5lVc49OMPDBs5Aj8/P0788gutm7eg2mtVWfPNapL0SaojWtzjBfym DRtwcXWle88e7Dmwn+CQENXxhLBqGl9Pr0nAsFFjwmT+LIft2bWb5k2a4OPjwy+nfiNfvnyqIwlh dQ4fOsQHDd7DPyCA0+fP4eIiBb2llQoO4d7du5w8e4YiRYqojiP+gV6vZ8XSZcyeNYtbN28C4OHh wTsN3uXDxo2pW68ebm5uilM+ueSkJKKiorh8+TKXIyOJjIgk4tIljh09islkwk2no32H9vQbMAD/ gADVcYWwan5e3gA4K87hMFJSUhgeGgrAsJEjpYgX4h9Ur1GDMmXLcu7sWTZ/+x2Nm8psrCXdu3eP e3fv4unpKYdrWTkPDw969PqETl27sHrVKlYsW8bJX0+yYd36rNNN67/9FsWKFcc/wB//gAACAgLw 9w+goH/BHN/2lKRPIiHhEY8SEkh49IiEhISMl8y34+LiiLocRdTly0RGRnLzxo2/HRFyc3Ojbft2 9B84kIDnnsvRzELYG2cyR2scYf5OpXlz5hAZGUnpMmXo1KWz6jhCWLXuPXvQu+cnhE+eTL36b8ox 7BZ07MgRIONQIrlGxza4urrStn172rZvz5UrV9i0YQObNmzk7JkzrF+77m+/RqPR4Ofnh39AAP4B /rjr3J/pe6enp6NPSsoqzh89ekTCo0ckJiY+9Ym0rq6uFClalODgYIqHBBMcHExwSAhlypaV5pYQ z0jj6+k1ERg+Mmw0AwYNUp3HLt2+dYvKFSuRmJjI5u3bqFa9uupIQlg1Q3Iy1aq+TmREBK+/8QYb vt2Em06nOpbNu3f3LjXeqMad27eR+3zbF3HpEocOHuT2rdvcuXOHO7dvc+fObW7fvsP9e/eeutB+ Wm46HV6ennh6euLp5ZX52hNPz4y3vby9KFKkKCEhIRQPCSYoKAgnJ6cczSSEo5DRmlw0euRIEhMT afTRR1LEC/EE3HQ6Nnz3LW/Xe5MjP/5Il46dWPbVl1IEZENaWhpdO3Xmzu3bVKtenb79+6uOJLIp pEQJQkqU+NuPmUwm7t+7l1ng38GQYnim76HRaPBw98gs0DOL9My3nZ2lhBBCtax/hTJakzOOHT3K +rXrcPdwZ/xEORZdiCdVuHBh1m/aSIO33mbrli20a92Gz+fMlqfgn8HPP/3EgL79OHf2LAUKFmTx sqXyoMjOabVaCvr7U9Dfn3LlVacRQuQUWT+Zg0wmE6GDBgPQf+BACgUGKk4khG0pXaYMq9auwdvb m+3btvF6lVfZvm2b6lg2Iy4ujv59+vJ2vTc5d/YsQYWD+GrVSjktVwgh7ISc7JqDVixbxpnTpyla tCi9+/ZVHUcIm1T19df58fgxatauzb27d2nToiW9uvfIWscn/r+ff/qJvr16U/7F0qxYtgwXFxcG Dh7M8V9+kdNyhRDCjsiAWw6JjY1l4rjxAEycMtmmdv0KYW0KBQay8btvWbp4MWEjR7Fq5UpWrVxJ ufLlebN+fd58qz6vVK7s0OMid+/cYfU337Dyq6+59McfWe+vU68uU6ZNIzg4WGE68X/t3V9sk/Ue x/HP2rKalZZBW0UwwRZyTATZzslRjOg0ikbw5ihG8A/qORwTQwiRyBguHZyzMWWjerVwZUBvAa8P nV4zLjSy7pBo4p4l02wnWcuyp3TKA89yLjbKdjYOg23+KM/7dbP296zZpxdbvmk/+xYAFgId+QXS 2tyiixcv6tlNz2nzli2m4wBlr6KiQjvfe0/Pbtqk1uYWfdPZqZ5sVj3ZrD5LpxUKhbR6zRolkkkl EgklVyf1YCKhZDKp+1esuKtWLbquqx9/+EHd57vVff57nf/+vL779tvSlpL4vfdq2+vb9daOHfrD Qw8ZTgsAWCilPfKYP//u6Sm9nX2kvd10HOCukkgk9PmJ47py5YrOdXUpc+aMMv86o96fflK2u1vZ 7u5pjwnec4/i8ZjC4YgikYjCkbAikSUKh8PT7y+JTJwvmTiPKBIO/27rL0dGRpQbGlIul9PQ0JBy Q0OTvub0c3+/Lly4oN9+/XXK4wKBgLa89JLefHuHnn/hBTaKAIAH8Jd+ATTsq5frutq1e/cNV4MB mJtFixbpqbo6PVVXp8Mff6x8Pq8+y5LVa6mvz1KfZZU+VTKXy+mXn3+Z08+rrKycNPhHFAqFJI2/ Ou66rsbGXLnumFzX1dWrV8fPJq65k66VzkrXxqaczUZFRYWSyaTW19Zqfc161dTUqvZPf9TSpUvn 9BwBAOWFQX6efXXqtLrOntV9y5er/kCD6TiAZ0SjUUWjUf350UenXbt06ZLy+bwKti3btlUoFFSw C7LtERUKBdkjE2cFe8bbtm3LcRzl83nl8/kFfR7hcFixWEyxeFzxeFzRWEzxeFyxeFyxWEwrH1ip dY88onA4vKA5AAB3Pjry82h0dFQHUylJ0j+am7V48WLDiQBImvggm7n9Pl6+fLk01BfsgorFS/L5 fPL7/fL7/fL5/PL7r9/3+/3yXbs96Zpv0vXxa74pZwAAzBYd+XmUbmvX4MCAHtuwQa9t32Y6DoB5 FAwGFQwGFYvFTEcBAEASe+TnjWVZOtbRIZ/Pp7Z0+q7akAEAAIA7D4P8PGnc3yDHcbTjnXdUU1tj Og4AAADucqVBno787fs606nOTEbV1dVKHTpoOg4AAAA8wCc68nPiOI4aG8a303yUSikajRpOBAAA AC+gWjNHxzo61Nvbq4fXrtXf/r7TdBwAAAB4BIP8HPxncFCfth+VJLWlj7I6DgAAAL8bOvJzcDCV UrFY1Mtbt2rjk0+ajgMAAAAPoSN/m851den0yVOqqqpSS+th03EAAADgMVRrbsPY2Jga9tVLkvbu +1ArVq40nAgAAABec32Q53X5Wfvi+HH1ZLNKJBLavWeP6TgAAADwIKo1t2h4eFitzS2SpNa2IwoG g4YTAQAAwIuo1tyi1uYWDQ8P67nnN+nFzZtNxwEAAIBHMcjfgp5sVl+eOKHKykodaW83HQcAAAAe xvrJW3Cgfr9c19X7u3Zp9Zo1puMAAADAw+jIz9Lpk6fUdfas7lu+XPUHGkzHAQAAgMdRrZmF0dFR HWpqkiT9s6VFoVDIcCIAAAB4HYP8LKTb2jU4MKANjz+u17ZvMx0HAAAAoCN/M5Zl6VhHh3w+n9rS R03HAQAAACTRkb+pxv0NchxHb7/7rtbX1JiOAwAAAEiiWvN/dWYy6sxkVF1drdShg6bjAAAAACUM 8jfgOI4a949vp2lsSmnZsmWGEwEAAADX0ZG/gWMdHbIsS2vXrdNfd+40HQcAAACYgo78DAYHBvRp +/g/tralj8rv9xtOBAAAAExFtWYGh5qaVCwW9cqrr+qJjRtNxwEAAACmYZD/H+e6unT65ClVVVWp +XCL6TgAAADAjALXbtCRl/osS2+9/oYkKRAIaOtfXjacCAAAAJhZQHTkS7488YUu5vOSJNu2Zdu2 4UQAAADAzAI3/xbviEQikqRVq1Zpz94PDKcBAAAApvvwg72SGOSnqHvmaalZisXjrJwEAADAHena IM8eeQAAAKAMsUceAAAAKEOsnwQAAADKENUaAAAAoAxRrQEAAADKENUaAAAAoAwxyAMAAABliI48 AAAAUIboyAMAAABliGoNAAAAUIYCpgPciRzHUX9/v+kYAAAAwA1VLF0cPiDpE9NBAAAAAMwer8h7 U1FSznQIAAAA3L7/AuKOx5aZWk9DAAAAAElFTkSuQmCC ";
  rellenoR = 244;
  rellenoG = 237;
  rellenoB = 200;
  var fin = 'round';
  var grid = 20;//Tamao de rejilla
  var colorFondo = '#f3f0e7';//color de fondo y del borrador
  var radioPuntos = 1.5;//radio de crculos en punteado
  var densidad = 5;//factor que marca la distancia entre puntos respecto al grosor del punto en punteado2 y pincelPluma
  var espaciado = densidad * 5;//separacin entre pinceladas en pincel compuesto
  var pincel = 10;//radio del area donde se dibujan los puntos en pincel aleatorio y del borrador
  var anchopluma = 2;//en pincel pluma el ancho en el que hay trazos
  var grosorpluma = 1;//Grosor de los trazos en pincel pluma
  var canvasWidth;
  var canvasHeight;
 var cir_3px_sin = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAoAAAAKCAYAAACNMs+9AAAABHNCSVQICAgIfAhkiAAAAFZJREFU GJWNkFEKwDAIQ1/KTtfcd9dzH7XQDTsa8EMM8SkRwSzAQGR5nSkNAEgS0LO9Yxm+jH9qkpxJpTRk Kp6Kux3tTXmybhIF+PiY6wvO5j0leHXgA0MzY7PnNfzfAAAAAElFTkSuQmCC "
 var cir_4px_sin = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAoAAAAKCAYAAACNMs+9AAAABHNCSVQICAgIfAhkiAAAAE5JREFU GJWNkEsKwFAIA2feubw/eCq7sdCPpS+QVQZMpKo4DSRQ7bxlDzAaTiCumQ38aqmpxheghppMfabe a+tu61V8Grg/Zio+Dtx9+AG9HXKZXgI35AAAAABJRU5ErkJggg== "
 var cir_5px_sin = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAoAAAAKCAYAAACNMs+9AAAABHNCSVQICAgIfAhkiAAAAEdJREFU GJWVkFEKACAIQx+ez+t7nvVTIVlggj/bZHNIQhKAAzrWN5+EBkQSBWCJxxcwxf7A6vXDpea55TY+ pm3de6ZdT7fwAabkfn9iz+3mAAAAAElFTkSuQmCC "
 var cir_6px_sin = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAoAAAAKCAYAAACNMs+9AAAABHNCSVQICAgIfAhkiAAAAEZJREFU GJWVkFEKACAIQx99dsvO66HWj0SkggkiuMnmkIQkAAP0tB38Iq6EuC4cc9L0acUuXhcq0U/me/BR beneM+14uoFvi4aA5WGdJEwAAAAASUVORK5CYII= "
 var cir_7px_sin = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAoAAAAKCAYAAACNMs+9AAAABHNCSVQICAgIfAhkiAAAAGlJREFU GJWN0NsJwzAMheHPoQ/dpKN0Eg/VUTqKJ2neTl9sSLADEQghoct/JAlU5MJrElsppaJhN9uO1nsE P3x6zKpWenFMv/HqecMXz7F+4llxbwuupT2uwA8CT6dviRnvOYFPAu8+/A9LH0hBQWduCgAAAABJ RU5ErkJggg== "
  var triangulo = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAoAAAAQCAYAAAAvf+5AAAAABHNCSVQICAgIfAhkiAAAAKNJREFU KJGN0LENg0AQRNG/IHICeiCjBqeuhJhGiOmCDNfhzD04wLGFNE4OtAeH7ZVGOt28aEwS/szsCiDp FhWStgAF8Agpom4HO0AhXRICFTA7OANVCg4OrRkiCDTAkoAL0Hg4Aq+TjJKw/Txnl/2lgMzMLr/Q au5A7jfbbZsHg4D2C2yDQcATKBOoDN0GBfQJ2Lt+e7yB2qE6/B2ggMnByXcf2QLQMzDzTScAAAAA SUVORK5CYII= "
  var triangulo_20 = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABQAAAAmCAYAAADEO7urAAAABHNCSVQICAgIfAhkiAAAAVBJREFU SInt1K1uAkEUhuH3kDQhGBRuEySqCaI1CHwvAENSi8dhuAU8usFwAVQjUBUVvQGSuioMadKGnIrO NLQM87drmnaST+zMOU8muzsjqkpoiMgNgKreB2tDoIhcAE/m8VJV370NquoNMAbUZBysD2AtYHcE 7oBWGXB+hNnMs0CgCxwc4AHo5oBrB2azTgKBgQezGUSBQB3YRoBboB4DTiMwm6kXBApgnwDugcIH LhIwm4UTBHoZmE3POl9nWUTugGvyxoOq3kLE5ZA6apVqvwMUkauqMGttQpdmbIANfP5HwwqwobFQ 4BlolMAaxlD7UQpgUuL1TYyB3aECr0A7Y3dt02udb2dymQEufxgnB72fgPUd/ScTj0AtAquZ2iCo wCgCHJ3pdU6+AE0P1jQ10aACMw848/SdXXgDOg6sY9aSQQVWDnDl6/m/sf8C+AGAi5AGoUzTuwAA AABJRU5ErkJggg== "
  var triangulo_40 = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACgAAABACAYAAABoWTVaAAAABHNCSVQICAgIfAhkiAAAAxJJREFU aIHtmr9PFEEUxz/vwGgCCVdoQWi4QsgVQkfoCA3E0BFKQksIVFBhCQ3VBf8OQiliQ2voRAuiFloo JmKhiUaUH89iZ+Oxd8fOzszuNnyTl9ztvXnvk7c7uzNvT1SVUBKRxwCq+jxYzFCAInIHeGO+PlLV 8xBxKyGCGK0Aw8ZWQgUNUkEReQC8B/rMoR/AQ1U99Y0dqoKb/IfDfN4MEllVvQwYBS4BTdglMOob P0QFn9L+TFTMb37yrN4crZVL2pxPDudJIiL3gGNgMMX1I1BX1TOXPD6neI10OIzPmmsSpwqKyADw FuixHPILGFbVz1lzuVZwC3s4jO+WUyaHiTEOXJE+OZJ2BYxnzpcRToBDB7jYDjGXVV6ACx5wsS3k Agj0AicBAE+A3jyeJE+A/gz+ndRvYtnJsno14Az/6sV2BtSCnWJgNyBcbLtBAIHJHOBim/QCBLqA oxwBj4AuH8ClHOFiW3ICBKrAaQGAp0DVBXC7ALjYtjMBAnXgvEDAc6I1ozXgfoFwse1bAQIzJcDF NpPk6aZVU8CLNseL0BTwrPlAsNZHXgrZ+shFt4C+ugX01S2gryoiMlQ2RCeJyFAFaJQNcoMaED0D p232B0UaMA2oGMBjYERVL0qrVZNEpBt4DdTjSVIHlstDatEyERNxBQG+E3Xmv5VFBSAi94neGFTh +m2mCmyUAZXQBgYuVvOC8YLoWixrYowYhmamllXtQYmAB2142i69Z0uAm23H0jxJmvWBaJf1x/eC spGI3CW61dWSv3V6FteA1TyhElqlDRxcv80k9RMYUtUveVEBiEg/8I6oQdqim1Yzvbh25rNpiw5w sW7ap14BYzlOjDHS3xikbqZfkrEzbwknJnZafqsd/3wOgPOWua2cPgE9AeF6TMzU3LZL/gFg3dLX RusmppVsGzu/gcEA1Rs0sWzzZuo+7QQA3MmYM5OzAhMecBMO+TIPeAVUHOAqZmzugAosOgAuOuZy GvQV6MsA12fGFAaoQCMDYMMjj/PAv0T/Q0iDGza+hQMqsGcBuOeT4x9j5Oaai6NJLgAAAABJRU5E rkJggg== "
  var elipse = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAABHNCSVQICAgIfAhkiAAAAJZJREFU OI3NlcENgDAIRR/GPdzABdyhIziPi7mAid4dxOClB6O1Um0TSbiU8BLgQ1FVjg7MgBp9vuQHgD2w GWAb0D8CPdQBSwS2AC6UKx4QNBHpgBZo/NMKTKo63ubEgG+sykoDBBgwlBKFnFpjanbC8GxySJCX TbDWBcg+lOIlfx5Kdtn8f1PqWPDNcch+vsofWD5+ATuG8a+mdnoINAAAAABJRU5ErkJggg== "
  var estrella = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAoAAAAKCAYAAACNMs+9AAAABHNCSVQICAgIfAhkiAAAAIFJREFU GJWNzzEKAlEMhOHvWVsJa2PjFay0EG/jIb2EYCHeQgRRUFjHZlfwsYKBQJgM+TMliX9qVAullNWg M8lX44Smm8eYJlFqdCnlggPOmGOd5NZfabDFDi8EDyx6Uv9j0HbLHtHi+SH9QO9xxQybJPehMEdM 6jBDxmWtDab+VW/DC26DHJtNZgAAAABJRU5ErkJggg== "
  var estrella_20 = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAABHNCSVQICAgIfAhkiAAAAPdJREFU OI2t1LtKBDEUANCTRRRLKxu11wULKys7QbC00dbK37AXtBUEK0t/wC9REEWw2EYr38jGwlkcx8k8 1rlwISQ3h1wSEmKMuoxep1oTMIQw3ymIkxDCdJfgIg6bgmKMlYlbRGyVrC1j+9dcA/A6Ax+xgD72 cYkX9NuCVxkY8ZQbR+z9qU8gE1jHMV4LyCjPS/fmkEls4hQPCWSUd5gpA4u3PMRnllXxkaxJtNzD mu/n8p445VllyxWXMsghbwV09z/gALNYxQFu8IylccAhNkrWVrAzDnhUV9cGvMBUUzBkm5IRQpiL Md7XPKOf+jqwbXT+Y38BH8Ds21K6c7YAAAAASUVORK5CYII= "
  var estrella_40 = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACgAAAAoCAYAAACM/rhtAAAABHNCSVQICAgIfAhkiAAAAiZJREFU WIXtmDtoFFEUhr9/heAjSBpjYa8WIj5IJQk2xsZWBAMWghaSJoWFpSAmlYhWFimSRpNUVgqCCjY+ +6DGRxECCjZBxLjmWLiBmc3cnZ2555Ig/nCauef+++15wDAyMzazGhsNUKb/gLGKBpSU9E96mF92 8AjKA/C0pPMOPoXyAFwFbkna6+C1Tl6AO4B7knoc/HLyAgQ4DIw7+OXkCQgwJulkVQNJ+0Jn3oAC piT1dwF1RNKEpA/AQDDRzKICeApYWzwAVJB7CLgOvM/kTnf0dwB8XABowFjr/CBwDXhbkPMO6E0N +CgA+BOYD5ytnR8t8/eewax6gODwA1fM7E2pe0TleoEzwEfCVQpF4YxGtxjoA84B94EfNcAMWAL6 u/7NLqB2AReAh8BKTai1WAVOVCpKAGoPMAo8AZqRUNmYqDpKoSUx4Dfwi/AS1NHXyje6nLsRYA5Y Jq6CK8BAdIs7wG4FTgGTwJeakAvAziSAbbANYAj4VANyJjlgBvR5zUpejFmSKlLg+XfgW4d7NyUd KDNPCXgJ2A0MA3f4O7NZbQNmJW3v6O7Q4pesb9/dgrwtwHHgNrCYyZ1MPYOv2uA+A30ldwQcA260 8s+mBHydgWsCgzU89qdckqzGzexZ1UtmNh8681ySF8BVB7+cvACXgREzazr45eTV4lEzW3DyyskD cMbMph18CqXWFtU3kBpm5vlKlvePBUytf/8La2ptesA/dTPi5y51kRgAAAAASUVORK5CYII= "
  var cua_4_6 = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAoAAAAKCAYAAACNMs+9AAAABHNCSVQICAgIfAhkiAAAAD1JREFU GJWtkDEOACAIA6/G/3+5LhLFwTDQCZKDFmSbkKTTALYV9aAo3Ru/IODXJgE7Ttm6HywfM9NUxx8X O5oWCc0mDvgAAAAASUVORK5CYII= "
  var ajedrez_10_10 = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAABHNCSVQICAgIfAhkiAAAASVJREFU OI3lVDFyxCAMBIFlGuae4B9cyU/ySr+ElP6Bn5ChwAELpQkZn61Ul+JmohkVq5EWgVYopRSfHQDI OZc7DiHEGGNgZsXMKufsiAg6PjqoP7Z/SGgBoF1OAWjHuNaamVl33FqD1prYjEXEIhEOw1A7NsYQ EZmOa61Dz7sQbtvmJMJjB/u+W2vt3vE4jp+IWMTbSW0/YzaE8H4Oaq3ZGEMpJV9KwWma1nVdp9vt 9lFKwZSSN8aQ1povtTHGcA4ysyYi471PiFiWZbnP8/y2LMsdEYv3PhGROQ7qWHxxIoKcs+s4xhhC CFF9r6JzLgMAKWltn3+1RxOn3FqDWuvgnNuUkqd8VsIPoaTDc6Kkw1IKioSSlpR6FO1vmyIRvv7n 8PqEXzA22aszfDLnAAAAAElFTkSuQmCC "
  var ajedrez_20_20 = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACgAAAAoCAYAAACM/rhtAAAABHNCSVQICAgIfAhkiAAAAFdJREFU WIXt18ENwAAMwkDo/jvTIZxKffgGQFZ+aZLl0LZe7j2XY18wkDKQMpAykDKQMpAykDKQMpDqdvqS pO3p4O8vaCBlIGUgZSBlIGUgZSBlIGUg9QJHyQhLIyBatgAAAABJRU5ErkJggg== "
  var ver_1_3 = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAQAAAAKCAYAAACT+/8OAAAABHNCSVQICAgIfAhkiAAAABpJREFU CJljZGBg+P///39GBihgYkADg0UAAJd8BBHF/SdNAAAAAElFTkSuQmCC "
  var ver_2_2 = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAgAAAAKCAYAAACJxx+AAAAABHNCSVQICAgIfAhkiAAAACVJREFU GJVjZGBg+M/AwMDw//9/RgYGBgZGRkYUPhMDATCqAAIA1v0IEbe0EMsAAAAASUVORK5CYII= "
  var ver_3_1 = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAQAAAAKCAYAAACT+/8OAAAABHNCSVQICAgIfAhkiAAAABpJREFU CJljZGBg+M8ABf///2dkYkADg0UAAH+MBBHdQgvAAAAAAElFTkSuQmCC "
  var ver_4_4 = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAgAAAAKCAYAAACJxx+AAAAABHNCSVQICAgIfAhkiAAAAB1JREFU GJVjZGBg+M+ABP7//8+IzGdiIABGFUAAAPiyBBG50ohbAAAAAElFTkSuQmCC "
  var hor_1_3 = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAoAAAAECAYAAAC3OK7NAAAABHNCSVQICAgIfAhkiAAAABxJREFU CJljZGBg+M9ABGD8/58odQxMRKkiRSEAC8wEAwax3ZsAAAAASUVORK5CYII= "
  var hor_2_2 = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAoAAAAICAYAAADA+m62AAAABHNCSVQICAgIfAhkiAAAACNJREFU GJVjZGBg+M9ABGAiRhEDAwMD4///RBlIgokMg9+NALQ3CAWV3oefAAAAAElFTkSuQmCC "
  var hor_3_1 = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAoAAAAECAYAAAC3OK7NAAAABHNCSVQICAgIfAhkiAAAABxJREFU CJljZGBg+M9ABGAiRhFJChn//yfKZgYAFwUEA1IZ30sAAAAASUVORK5CYII= "
  var hor_4_4 = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAoAAAAICAYAAADA+m62AAAABHNCSVQICAgIfAhkiAAAAB5JREFU GJVjZGBg+M9ABGAiRhFtFDL+/0+UEwfSjQAx5wQLEQYrtAAAAABJRU5ErkJggg== "
  
  function init () {
    // Localiza el elemento canvas.
    canvaso = document.getElementById('imageView');
    if (!canvaso) {
      alert('Error: No puedo encontrar el elemento canvas!');
      return;
    }
   altoNuevo = canvaso.height;
   anchoNuevo = canvaso.width;
    if (!canvaso.getContext) {
      alert('Error: no canvas.getContext!');
      return;
    }

    // Toma el 2D canvas context.
    contexto = canvaso.getContext('2d');
    if (!contexto) {
      alert('Error: Necesitas un navegador ms moderno para poder ver esta aplicacin!');
      return;
    }
	
    // Crea contexto para canvas que est encima de todo
	
    canvasTop = document.getElementById('imageTop');	
    contextTop = canvasTop.getContext('2d');
    if (!contextTop) {
      alert('Error: failed to getContext!');
      return;
    }	
	
	canvasWidth = canvaso.width;
	canvasHeight = canvaso.height;
	
	//Ponemos fondo color
	fondoColor();
	

    // Aade un canvas temporal.
    var container = canvaso.parentNode;
    canvas = document.createElement('canvas');
    if (!canvas) {
    alert('Error: No puedo crar un nuevo lienzo!');
    return;
    }
    canvas.id     = 'imageTemp';
    canvas.width  = canvaso.width;
    canvas.height = canvasHeight - 22;
	contTemp = document.getElementById('contenedor1');
    contTemp.appendChild(canvas);
    context = canvas.getContext('2d');



    // Activa la herramienta por defecto.
    if (tools[tool_default]) {
      tool = new tools[tool_default]();
    }
	//Pone por defecto el cursor lpiz
	$('canvas').css("cursor","url(imagenes/cursores/cursor_lapiz.png),auto");
	

    // Coloca mousedown, mousemove and mouseup event listeners.
    canvas.addEventListener('mousedown', ev_canvas, false);
    canvas.addEventListener('mousemove', ev_canvas, false);
    canvas.addEventListener('mouseup',  ev_canvas, false);
	canvas.addEventListener('dblclick',  ev_canvas, false);
	canvas.addEventListener('mouseout',  ev_canvas, false);
	canvaso.addEventListener('mouseup',  ev_canvas, false);
	
	//Eventos cuando se presiona una tecla
	window.onkeydown = function(evt) {
	evt = evt || window.event;
	if (evt.keyCode === 17) {
		keyControl = true;
		}
	}
	window.onkeyup = function(evt) {
	evt = evt || window.event;
		if (evt.keyCode === 17) {
			keyControl = false;
		}else if(evt.keyCode === 90 &&(keyControl)){//Deshace al presionar Ctrl + z
		undoDraw();
		}
	}
	//Evita seleccion azul
	document.onselectstart = function() {
	return false;
	}
	
	//si existe almacenada imagen de anterior trabajo en navegador la carga

	if (localStorage.dibujo_bodegon_punto){
		if (confirm('Quieres recuperar el ltimo trabajo que se hizo con esta aplicacin?')) {
			localStorageImage = new Image();
			localStorageImage.addEventListener("load", function(event){
				localStorageImage.removeEventListener(event.type, arguments.callee, false);
				contexto.drawImage(localStorageImage,0,0);
			}, false);
			localStorageImage.src = localStorage.dibujo_bodegon_punto;	
		}else{ponerFondo(imagenFondo);return}
	}else{ponerFondo(imagenFondo);return}

	//Pone imagen por encima
	//ponerRejilla();

}
	//Carga imagen para patrn y lo crea.
	$('.textura').click(function (){
		var img = new Image();
			var direccion = $(this).attr('id');
			var textFondo = $(this).css('backgroundImage');
			img.src =  eval(direccion);
			img.onload = function(){
			var ptrn = context.createPattern(img,'repeat');
			relleno = ptrn;
		}
		$('#paleta3').css('backgroundImage', textFondo);
	})
	
	
	//Abre ventana para escribir texto en canvas
	$('#texto').click( function() {
		document.getElementById('text-controls').style.display = 'block';
		var textE1 = document.getElementById('text');
		//textE1.focus();
	})
	//Coloca texto al aceptar
	$('#botonTexto').click(function (){
		saveActions();
		contexto.save();
		contexto.fillStyle = colorFondo;
		contexto.fillRect(0,523, canvaso.width, 22);//rellena con color de fondo Si fuera una imagen habra que recargarla
		contexto.restore();
		titulo = document.getElementById('text').value;
		contexto.font = "12pt Verdana";
		contexto.fillStyle = "black";
		contexto.fillText(titulo, 20, 540);
		saveLocalStorage();
		document.getElementById('text-controls').style.display = 'none';
	})
	//Cierra ventana de colocar texto
	$('#botonTexCan').click(function (){document.getElementById('text-controls').style.display = 'none'});
	
	// Controlador de evento general. Esta funcin determina la
	// posicion relativa del ratn respecto al elemento canvas.Da las coordenadas del raton dentro del canvas
	function ev_canvas (ev) {
		if (ev.layerX || ev.layerX == 0) { // Firefox
		  ev._x = Math.round(ev.layerX / canvasScale);//multiplicamos por canvasScale para conpensar zoom
		  ev._y = Math.round(ev.layerY / canvasScale);
		} else if (ev.offsetX || ev.offsetX == 0) { // Opera
		  ev._x = Math.round(ev.offsetX / canvasScale);
		  ev._y = Math.round(ev.offsetY / canvasScale);
		}

		// Llama al manejador del evento de la herramienta
		var func = tool[ev.type];
		if (func) {
		  func(ev);
		}
	}

	// Esta funcin dibuja #imageTemp canvas encima de #imageView, despus
	// #imageTemp se limpia. Esto se realiza cada vez que el usuario
	// completa unaa operacin de dibujo.
	function img_update () {
  		saveActions();//Guarda copia de la imagen
		contexto.drawImage(canvas, 0, 0);//copia imagen temporal en definitiva
		context.clearRect(0, 0, canvas.width, canvas.height);//Limpia la imagen temporal
		ponerRejilla();
		redoHistory = [];
		saveLocalStorage();

	}
	//Function guarda imagen en array para poder deshacer
	function saveActions() {
		var imgData = document.getElementById("imageView").toDataURL("image/png");
		undoHistory.push(imgData);//guarda imagen en matriz deshacer
	}
	//Guarda imagen en el cache del navegador
	function saveLocalStorage(){
		var imgData = document.getElementById("imageView").toDataURL("image/png");
		localStorage.dibujo_bodegon_punto = imgData;//guarda imagen en el cache del navegador
	}
	
	//Funcin pone fondo de color
	function fondoColor(){
	contexto.save();
	contexto.fillStyle = colorFondo;
	contexto.fillRect(0,0, canvaso.width, canvaso.height);
	contexto.restore();
	}
	
	//Funcion deshacer
	function undoDraw(){
		if(undoHistory.length > 0){
		var imgData = document.getElementById("imageView").toDataURL("image/png");
		redoHistory.push(imgData);//Guarda la imagen actual en array rehacer
        var undoImg = new Image();
			undoImg.onload = function(){//funcion para que le de tiempo a cargar la imagen
			contexto.drawImage(undoImg, 0,0);//copia imagen rescatada en canvas
			var imgData = document.getElementById("imageView").toDataURL("image/png");
			localStorage.dibujo_bodegon_punto = imgData;//guarda imagen en el cache del navegador
			};
			undoImg.src = undoHistory.pop();//saca ultima imagen guardada en el array y la guarda en undoImg
        } else if(undoHistory.length == 0){
		return
		}		
	}
	
	function redoDraw(){
		if(redoHistory.length > 0){
		saveActions();
        var redoImg = new Image();
			redoImg.onload = function(){//funcion para que le de tiempo a cargar la imagen
			contexto.drawImage(redoImg, 0,0);//copia imagen rescatada en canvas
			var imgData = document.getElementById("imageView").toDataURL("image/png");
			localStorage.dibujo_bodegon_punto = imgData;//guarda imagen en el cache del navegador
			};
			redoImg.src = redoHistory.pop();//saca ultima imagen guardada en el array y la guarda en redoImg
		}
	}
	
	
	//Pone una imagen como fondo
	function ponerFondo (imagenUrl){
		var img = new Image();
		img.src = imagenUrl;
		img.onload = function(){
		//contexto = canvaso.getContext('2d');
		contexto.drawImage(img,0,0,750,523);
		}
	}
	//Pone imagen de lnea negra por encima para mantenerla siempre
	function ponerRejilla(){
		var imgTop = new Image();
		imgTop.src = imagenEncima;
		imgTop.onload = function(){
		contexto.drawImage(imgTop,0,0,750,523);
		}
	}
	//Control del boton limpiar
    $('#reset').click(function() {
        if (confirm('Se reiniciar el ejercicio y se perder la imagen actual. Ests seguro?')) {
		//canvaso.width = canvaso.width;
		undoHistory.length = 0;//vacia array con estados anteriores
		redoHistory.length = 0;
		contexto.save();
		contexto.fillStyle = colorFondo;
		contexto.fillRect(0,0, canvaso.width, canvaso.height);//rellena con color de fondo Si fuera una imagen habra que recargarla
		contexto.restore();
		ponerFondo(imagenFondo);
        }
    })

	//controlamos el boton guardar imagen
	$('#guardar').click (function() {
	var imgData = document.getElementById("imageView").toDataURL("image/png");
			var ventana = window.open('','imagenGenerada', "toolbar=no,location=no,status=no,menubar=no,resizable=yes,scrollbars=1");
			ventana.document.write('<html><head><title>Imagen Generada</title><meta http-equiv="content-type" content="text/html; charset=iso-8859-1"><link rel="stylesheet" type="text/css" href="css/dibujo_00.css" /> ');
			ventana.document.write('</head>');
			ventana.document.write('<body style="background-color:#F4EDC8">');
			ventana.document.write('<div  style="position:absolute; top:40px; left:50%; margin-left: -375px;  width:750px; height:545px; box-shadow: -2px 2px 10px 1px #999;"><div style="position:relative"></div><div><img src="');
			ventana.document.write(imgData);
			ventana.document.write('"width="750" height="545">');
			ventana.document.write('</div><br><div style="border-width:1;border-color:#901420;border-style:dashed;border-radius:15px; margin-top: 50px;margin-left: 150px; margin-right: 150px; margin-bottom: 20px; padding-left:20px; padding-right:20px; font-family:Verdana;font-size:16px;background-color:#f3f0e7;text-align:center">');
			ventana.document.write('<br><br>Para guardar la imagen haz clic sobre ella con el botn derecho. En el men que aparece selecciona: "Guardar imagen como..."');
			ventana.document.write('<br><br><button onclick="window.close();" class="botonVentana">Cerrar Ventana</button><br><br></div><br><br></div></body>');
			ventana.document.close();
	//window.open(document.getElementById("imageView").toDataURL("image/png"),'Canvas Export','height=450,width=625');
	})
	
	//Controla boton para poner o quitar la rejilla
	$('#rejilla').click (function(){
		if(flagRejilla == false){
			ponerRejilla();
			flagRejilla = true;
		}else{
			contextTop.clearRect(0,0,750,545);
			flagRejilla = false;
		}
	})

	// tools Contiene la implementacion de cada herramienta
	var tools = {};
	//Controles para saber que botn se ha seleccionado
	$('#lapiz').click(function (){
	tool = new tools['pencil']();
	$('canvas').css("cursor","url(imagenes/cursores/cursor_lapiz.png),auto");
	})
	$('#cubo_pintura').click (function (){
	tool = new tools['cubo_pintura']();
	$('canvas').css("cursor","url(imagenes/cursores/cursor_cubo.png),auto");
	})
	$('#rectangulo').click (function (){
	tool = new tools['rect']();
	$('canvas').css("cursor","crosshair");
	})
	$('#borrar').click(function (){
	tool = new tools['borrador']();
	$('canvas').css("cursor","url(imagenes/cursores/cursor_goma.png),auto");	
	})
	$('#circulo').click(function (){
	tool = new tools['circle']();
	$('canvas').css("cursor","crosshair");
	})
	$('#linea').click(function (){
	tool = new tools['linea']();
	$('canvas').css("cursor","url(imagenes/cursores/cursor_lapiz.png),auto");
	})
	$('#poly').click(function (){
	tool = new tools['poly']();
	$('canvas').css("cursor","url(imagenes/cursores/cursor_lapiz.png),auto");
	})
	$('#punteado3').click(function (){
	tool = new tools['punteado3']();
	$('canvas').css("cursor","url(imagenes/cursores/cursor_lapiz.png),auto");	
	})
	$('#colorPicker').click(function (){
	tool = new tools['cuentagotas']();
	$('canvas').css("cursor","url(imagenes/cursores/cursor_cuenta.png),auto");	
	})
	$('#deshacer').click (function() {
	undoDraw();
	})
	$('#rehacer').click (function() {
	redoDraw();
	})
	
    // Coloca una imagen encima
	function ponerImg(urlImg) {
	var img = new Image();
	img.src = urlImg;
		img.onload = function(){
		context = canvas.getContext('2d');
		context.drawImage(img,0,0,canvasWidth,canvasHeight);
		img_update();
		}
	}
	// Lapiz dibujo libre.
	tools.pencil = function () {
		var tool = this;
		this.started = false;

		// This is called when you start holding down the mouse button.
		// This starts the pencil drawing.
		this.mousedown = function (ev) {
			context.lineWidth = fileteAnc;
			context.lineJoin = "round";		
			context.lineCap = fin;
			context.strokeStyle = relleno;
			//context.strokeStyle = fileteCol;
			context.beginPath();
			context.moveTo(ev._x, ev._y);
			tool.started = true;
		};

		// This function is called every time you move the mouse. Obviously, it only
		// draws if the tool.started state is set to true (when you are holding down
		// the mouse button).
		this.mousemove = function (ev) {
		  if (tool.started) {
			context.lineTo(ev._x, ev._y);
			context.stroke();
		  }
		};

		// This is called when you release the mouse button.
		this.mouseup = function (ev) {
			if (tool.started) {
			tool.mousemove(ev);
			tool.started = false;
			img_update();
			}
		};
	};

    // Cuentagotas
	tools.cuentagotas = function () {
    var tool = this;
		this.mousedown = function (ev) {
		  pixelColor = contexto.getImageData( ev._x,ev._y,1,1);
		  rellenoR = pixelColor.data[0];
		  rellenoG = pixelColor.data[1];
		  rellenoB = pixelColor.data[2];
		  alfaColor();
		  actTri();
		  $('#paleta').css('backgroundColor', relleno);
		};
	};

	//Borrador. Si hubiera imagen de fondo habra que copiarla primero cada vez que se hace imgUpdate
	//o colocarla en otro canvas por debajo
	tools.borrador = function () {
    var tool = this;
    this.started = false;

	saveActions();

		this.mousedown = function (ev) {
		  context.lineWidth = 1;
		  pincel = fileteAnc*3;
		  context.strokeStyle = 'black';
		  contexto.fillStyle = 'white';
		  tool.started = true;
		};

		this.mousemove = function (ev) {
		  if (tool.started) {
		  context.clearRect(0, 0, canvas.width, canvas.height);
		  context.strokeRect( ev._x-pincel/2, ev._y-pincel/2, pincel, pincel);
		  // contexto.clearRect( ev._x-pincel/2, ev._y-pincel/2, pincel, pincel);//elimina fondo
		  contexto.fillRect( ev._x-pincel/2, ev._y-pincel/2, pincel, pincel);//pinta con color de fondo
		  }
		};

		this.mouseup = function (ev) {
		  if (tool.started) {
			tool.mousemove(ev);
			tool.started = false;
			context.clearRect(0, 0, canvas.width, canvas.height);
			img_update ();
			saveActions();
		  }
		};

	};

		//Cubo Pintura
		tools.cubo_pintura = function () {
		var tool = this;
		this.started = false;

			this.mousedown = function (ev) {
			curColor = { r:rellenoR, g:rellenoG, b:rellenoB};//toma color seleccionado en rgb
			saveActions();
			colorLayerData = contexto.getImageData(0, 0, canvasWidth, canvasHeight);//copia canvas a colorLayerData
			paintAt(ev._x, ev._y);
			saveLocalStorage();
			};
			floodFill = function (startX, startY, startR, startG, startB) {


					var newPos,
						x,
						y,
						pixelPos,
						reachLeft,
						reachRight,
						drawingBoundLeft = 0,
						drawingBoundTop = 0,
						drawingBoundRight = canvasWidth,
						drawingBoundBottom = canvasHeight-22;
						pixelStack = [[startX, startY]];

					while (pixelStack.length) {

						newPos = pixelStack.pop();
						x = newPos[0];
						y = newPos[1];

						// Get current pixel position
						pixelPos = (y * canvasWidth + x) * 4;

						// Go up as long as the color matches and are inside the canvas
						while (y >= drawingBoundTop && matchStartColor(pixelPos, startR, startG, startB)) {
							y -= 1;
							pixelPos -= canvasWidth * 4;
						}

						pixelPos += canvasWidth * 4;
						y += 1;
						reachLeft = false;
						reachRight = false;

						// Go down as long as the color matches and in inside the canvas
						while (y <= drawingBoundBottom && matchStartColor(pixelPos, startR, startG, startB)) {
							y += 1;

							colorPixel(pixelPos, curColor.r, curColor.g, curColor.b);

							if (x > drawingBoundLeft) {
								if (matchStartColor(pixelPos - 4, startR, startG, startB)) {
									if (!reachLeft) {
										// Add pixel to stack
										pixelStack.push([x - 1, y]);
										reachLeft = true;
									}
								} else if (reachLeft) {
									reachLeft = false;
								}
							}

							if (x < drawingBoundRight) {
								if (matchStartColor(pixelPos + 4, startR, startG, startB)) {
									if (!reachRight) {
										// Add pixel to stack
										pixelStack.push([x + 1, y]);
										reachRight = true;
									}
								} else if (reachRight) {
									reachRight = false;
								}
							}

							pixelPos += canvasWidth * 4;
						}
					}

				},


			clearCanvas = function () {
			contexto.clearRect(0, 0,canvasWidth, canvasHeight);
			}

			matchStartColor = function (pixelPos, startR, startG, startB) {

				r = colorLayerData.data[pixelPos];
				g = colorLayerData.data[pixelPos + 1];
				b = colorLayerData.data[pixelPos + 2];

				// If the current pixel matches the clicked color
				if (r === startR && g === startG && b === startB) {
					return true;
				}

				// If current pixel matches the new color
				if (r === curColor.r && g === curColor.g && b === curColor.b) {
					return false;
				}
				// If current pixel has different colour
				return false;
			}

			colorPixel = function (pixelPos, r, g, b, a) {

				colorLayerData.data[pixelPos] = r;
				colorLayerData.data[pixelPos + 1] = g;
				colorLayerData.data[pixelPos + 2] = b;
				colorLayerData.data[pixelPos + 3] = a !== undefined ? a : 255;
			};
			paintAt = function (startX, startY) {

				var pixelPos = (startY * canvasWidth + startX) * 4,
					r = colorLayerData.data[pixelPos],
					g = colorLayerData.data[pixelPos + 1],
					b = colorLayerData.data[pixelPos + 2],
					a = colorLayerData.data[pixelPos + 3];

				if (r === curColor.r && g === curColor.g && b === curColor.b) {
					// Return because trying to fill with the same color
					return;
				};

				floodFill(startX, startY, r, g, b);
				contexto.putImageData(colorLayerData, 0, 0);
			}
		}; //fin cubo pintura
	
		//Aumenta de tamao el escritorio
		document.getElementById('zoom_in').onclick = function() {
			if (canvasScale > 2) {
				return;	
			}
			canvasScale = canvasScale * scaleFactor;
			altoNuevo = Math.round(altoNuevo* scaleFactor);
			anchoNuevo = Math.round( anchoNuevo* scaleFactor);
			$('#imageView').css('height',altoNuevo);
			$('#imageView').css('width',anchoNuevo);
			$('.lienzo').css('height',altoNuevo);
			$('.lienzo').css('width',anchoNuevo);
			$('#imageTemp').css('height',altoNuevo-(22*canvasScale));
			$('#imageTemp').css('width',anchoNuevo);
			$('#imageTop').css('height',altoNuevo);
			$('#imageTop').css('width',anchoNuevo);
			objeto = document.getElementById('herram');
			objeto.style.height = altoNuevo +'px';
		}
	
		//Disminuye de tamao el escritorio
		document.getElementById('zoom_out').onclick = function() {
			if (canvasScale < 0.9) {
				return;	
			}
			canvasScale = canvasScale / scaleFactor;
			altoNuevo = Math.round(altoNuevo * (1 / scaleFactor));
			anchoNuevo = Math.round(anchoNuevo * (1 / scaleFactor));
			$('#imageView').css('height',altoNuevo);
			$('#imageView').css('width',anchoNuevo);
			$('.lienzo').css('height',altoNuevo);
			$('.lienzo').css('width',anchoNuevo);
			$('#imageTemp').css('height',altoNuevo-(22 * canvasScale));
			$('#imageTemp').css('width',anchoNuevo);
			$('#imageTop').css('height',altoNuevo);
			$('#imageTop').css('width',anchoNuevo);
			objeto = document.getElementById('herram');
			objeto.style.height = altoNuevo +'px';
		}
	
	
		//Importa imagen desde archivo y la coloca como fondo del canvas fabric
		formEl = document.forms[0],
		fileEl = formEl.elements[0],

		formEl.onsubmit = fileEl.onchange = uploadHandler;
//
		function uploadHandler() {
		uploadFile(fileEl.files && fileEl.files[0]);
		return false;
		}		
		$('#subirArc').click(function(){fileEl.click()});
		
		//Sube archivo de imagen desde el ordenador
		function uploadFile(file) {
			if (file && file.type && file.type.match(/^image\/.*/)) {
				var fileReader = new FileReader();
				fileReader.onload = function(e) {
					var dataURL = e.target.result;
					var newImg = new Image();
					newImg.onload = ajustar;
					newImg.src = dataURL;
					
					function ajustar(){
						fondoColor();
						alto = newImg.height;
						ancho = newImg.width;
						altoCanvas =canvaso.height-22;
						if(ancho/alto >= canvaso.width/altoCanvas){
							yCoor = Math.floor((altoCanvas-canvaso.width*alto/ancho)/2);
							altoPNG = Math.floor(canvaso.width*alto/ancho);
							contexto.drawImage(newImg,0,yCoor,canvaso.width,altoPNG);
							return
						}else{
							xCoor = Math.floor((canvaso.width-altoCanvas*ancho/alto)/2);
							anchoPNG = Math.floor(altoCanvas*ancho/alto);
							contexto.drawImage(newImg,xCoor,0,anchoPNG,altoCanvas);
						}
					}
				}
			fileReader.readAsDataURL(file);
			}return
		}

	init();

}, false); }
