// Keep everything in anonymous function, called on window load.
if(window.addEventListener) {
window.addEventListener('load', function () {
  var canvas, context, canvaso, contexto;

  // Variables de herramientas.
  var tool;
  var undoHistory = new Array();//Matriz que guarda imagenes para el deshacer
  var redoHistory = new Array();//Matriz que guarda imagenes para el rehacer
  var tool_default = 'cubo_pintura';
  var imagenFondo = "data:image/gif;base64,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";
  rellenoR = 244;
  rellenoG = 237;
  rellenoB = 200;
  var fin = 'round';
  var grid = 20;//Tamao de rejilla
  var colorFondo = '#f3f0e7';//color de fondo y del borrador
  var radioPuntos = 1.5;//radio de crculos en punteado
  var densidad = 5;//factor que marca la distancia entre puntos respecto al grosor del punto en punteado2 y pincelPluma
  var espaciado = densidad * 5;//separacin entre pinceladas en pincel compuesto
  var pincel = 10;//radio del area donde se dibujan los puntos en pincel aleatorio y del borrador
  var anchopluma = 2;//en pincel pluma el ancho en el que hay trazos
  var grosorpluma = 1;//Grosor de los trazos en pincel pluma
  var canvasWidth;
  var canvasHeight;

  function init () {
    // Localiza el elemento canvas.
    canvaso = document.getElementById('imageView');
    if (!canvaso) {
      alert('Error: No puedo encontrar el elemento canvas!');
      return;
    }
   altoNuevo = canvaso.height;
   anchoNuevo = canvaso.width;
    if (!canvaso.getContext) {
      alert('Error: no canvas.getContext!');
      return;
    }

    // Toma el 2D canvas context.
    contexto = canvaso.getContext('2d');
    if (!contexto) {
      alert('Error: Necesitas un navegador ms moderno para poder ver esta aplicacin!');
      return;
    }
	
    // Crea contexto para canvas que est encima de todo
	
    canvasTop = document.getElementById('imageTop');	
    contextTop = canvasTop.getContext('2d');
    if (!contextTop) {
      alert('Error: failed to getContext!');
      return;
    }	
	
	canvasWidth = canvaso.width;
	canvasHeight = canvaso.height;
	
	//Ponemos fondo color
	fondoColor();
	

    // Aade un canvas temporal.
    var container = canvaso.parentNode;
    canvas = document.createElement('canvas');
    if (!canvas) {
    alert('Error: No puedo crar un nuevo lienzo!');
    return;
    }
    canvas.id     = 'imageTemp';
    canvas.width  = canvaso.width;
    canvas.height = canvasHeight - 22;
	contTemp = document.getElementById('contenedor1');
    contTemp.appendChild(canvas);
    context = canvas.getContext('2d');



    // Activa la herramienta por defecto.
    if (tools[tool_default]) {
      tool = new tools[tool_default]();
    }
	//Pone por defecto el cursor lpiz
	$('canvas').css("cursor","url(imagenes/cursores/cursor_cubo.png),auto");
	

    // Coloca mousedown, mousemove and mouseup event listeners.
    canvas.addEventListener('mousedown', ev_canvas, false);
    canvas.addEventListener('mousemove', ev_canvas, false);
    canvas.addEventListener('mouseup',  ev_canvas, false);
	canvas.addEventListener('dblclick',  ev_canvas, false);
	canvas.addEventListener('mouseout',  ev_canvas, false);
	canvaso.addEventListener('mouseup',  ev_canvas, false);
	
	//Eventos cuando se presiona una tecla
	window.onkeydown = function(evt) {
	evt = evt || window.event;
	if (evt.keyCode === 17) {
		keyControl = true;
		}
	}
	window.onkeyup = function(evt) {
	evt = evt || window.event;
		if (evt.keyCode === 17) {
			keyControl = false;
		}else if(evt.keyCode === 90 &&(keyControl)){//Deshace al presionar Ctrl + z
		undoDraw();
		}
	}
	//Evita seleccion azul
	document.onselectstart = function() {
	return false;
	}
	
	//si existe almacenada imagen de anterior trabajo en navegador la carga

	if (localStorage.dibujo_bodegon_flores){
		if (confirm('Quieres recuperar el ltimo trabajo que se hizo con esta aplicacin?')) {
			localStorageImage = new Image();
			localStorageImage.addEventListener("load", function(event){
				localStorageImage.removeEventListener(event.type, arguments.callee, false);
				contexto.drawImage(localStorageImage,0,0);
				filtroByN(0);
			}, false);
			localStorageImage.src = localStorage.dibujo_bodegon_flores;	
		}else{ponerFondo(imagenFondo);return}
	}else{ponerFondo(imagenFondo);return}

}
	//Carga imagen para patrn y lo crea.
	$('.textura').click(function (){
		var img = new Image();
			var direccion = $(this).attr('id');
			var textFondo = $(this).css('backgroundImage');
			img.src =  eval(direccion);
			img.onload = function(){
			var ptrn = context.createPattern(img,'repeat');
			relleno = ptrn;
		}
		$('#paleta3').css('backgroundImage', textFondo);
	})
	
	
	//Abre ventana para escribir texto en canvas
	$('#texto').click( function() {
		document.getElementById('text-controls').style.display = 'block';
		var textE1 = document.getElementById('text');
		//textE1.focus();
	})
	//Coloca texto al aceptar
	$('#botonTexto').click(function (){
		saveActions();
		contexto.save();
		contexto.fillStyle = colorFondo;
		contexto.fillRect(0,523, canvaso.width, 22);//rellena con color de fondo Si fuera una imagen habra que recargarla
		contexto.restore();
		titulo = document.getElementById('text').value;
		contexto.font = "12pt Verdana";
		contexto.fillStyle = "black";
		contexto.fillText(titulo, 20, 540);
		saveLocalStorage();
		document.getElementById('text-controls').style.display = 'none';
	})
	//Cierra ventana de colocar texto
	$('#botonTexCan').click(function (){document.getElementById('text-controls').style.display = 'none'});
	
	// Controlador de evento general. Esta funcin determina la
	// posicion relativa del ratn respecto al elemento canvas.Da las coordenadas del raton dentro del canvas
	function ev_canvas (ev) {
		if (ev.layerX || ev.layerX == 0) { // Firefox
		  ev._x = Math.round(ev.layerX / canvasScale);//multiplicamos por canvasScale para conpensar zoom
		  ev._y = Math.round(ev.layerY / canvasScale);
		} else if (ev.offsetX || ev.offsetX == 0) { // Opera
		  ev._x = Math.round(ev.offsetX / canvasScale);
		  ev._y = Math.round(ev.offsetY / canvasScale);
		}

		// Llama al manejador del evento de la herramienta
		var func = tool[ev.type];
		if (func) {
		  func(ev);
		}
	}

	// Esta funcin dibuja #imageTemp canvas encima de #imageView, despus
	// #imageTemp se limpia. Esto se realiza cada vez que el usuario
	// completa unaa operacin de dibujo.
	function img_update () {
  		saveActions();//Guarda copia de la imagen
		contexto.drawImage(canvas, 0, 0);//copia imagen temporal en definitiva
		context.clearRect(0, 0, canvas.width, canvas.height);//Limpia la imagen temporal
		redoHistory = [];
		saveLocalStorage();

	}
	//Function guarda imagen en array para poder deshacer
	function saveActions() {
		var imgData = document.getElementById("imageView").toDataURL("image/png");
		undoHistory.push(imgData);//guarda imagen en matriz deshacer
	}
	//Guarda imagen en el cache del navegador
	function saveLocalStorage(){
		var imgData = document.getElementById("imageView").toDataURL("image/png");
		localStorage.dibujo_bodegon_flores = imgData;//guarda imagen en el cache del navegador
	}
	
	//Funcin pone fondo de color
	function fondoColor(){
	contexto.save();
	contexto.fillStyle = colorFondo;
	contexto.fillRect(0,0, canvaso.width, canvaso.height);
	contexto.restore();
	}
	
	//Funcion deshacer
	function undoDraw(){
		if(undoHistory.length > 0){
		var imgData = document.getElementById("imageView").toDataURL("image/png");
		redoHistory.push(imgData);//Guarda la imagen actual en array rehacer
        var undoImg = new Image();
			undoImg.onload = function(){//funcion para que le de tiempo a cargar la imagen
			contexto.drawImage(undoImg, 0,0);//copia imagen rescatada en canvas
			var imgData = document.getElementById("imageView").toDataURL("image/png");
			localStorage.dibujo_bodegon_punto = imgData;//guarda imagen en el cache del navegador
			};
			undoImg.src = undoHistory.pop();//saca ultima imagen guardada en el array y la guarda en undoImg
        } else if(undoHistory.length == 0){
		return
		}		
	}
	
	function redoDraw(){
		if(redoHistory.length > 0){
		saveActions();
        var redoImg = new Image();
			redoImg.onload = function(){//funcion para que le de tiempo a cargar la imagen
			contexto.drawImage(redoImg, 0,0);//copia imagen rescatada en canvas
			var imgData = document.getElementById("imageView").toDataURL("image/png");
			localStorage.dibujo_bodegon_punto = imgData;//guarda imagen en el cache del navegador
			};
			redoImg.src = redoHistory.pop();//saca ultima imagen guardada en el array y la guarda en redoImg
		}
	}
	
	
	//Pone una imagen como fondo
	function ponerFondo (imagenUrl){
		var img = new Image();
		img.src = imagenUrl;
		img.onload = function(){
		contexto.drawImage(img,0,0,750,523,0,0,750,523);
		}
	}

	//Control del boton limpiar
    $('#reset').click(function() {
        if (confirm('Se reiniciar el ejercicio y se perder la imagen actual. Ests seguro?')) {
		undoHistory.length = 0;//vacia array con estados anteriores
		redoHistory.length = 0;
		contexto.save();
		contexto.fillStyle = colorFondo;
		contexto.fillRect(0,0, canvaso.width, canvaso.height);//rellena con color de fondo Si fuera una imagen habra que recargarla
		contexto.restore();
		ponerFondo(imagenFondo);
        }
    })

	//controlamos el boton guardar imagen
	$('#guardar').click (function() {
	var imgData = document.getElementById("imageView").toDataURL("image/png");
			var ventana = window.open('','imagenGenerada', "toolbar=no,location=no,status=no,menubar=no,resizable=yes,scrollbars=1");
			ventana.document.write('<html><head><title>Imagen Generada</title><meta http-equiv="content-type" content="text/html; charset=iso-8859-1"><link rel="stylesheet" type="text/css" href="css/dibujo_00.css" /> ');
			ventana.document.write('</head>');
			ventana.document.write('<body style="background-color:#F4EDC8">');
			ventana.document.write('<div  style="position:absolute; top:40px; left:50%; margin-left: -375px;  width:750px; height:545px; box-shadow: -2px 2px 10px 1px #999;"><div style="position:relative"></div><div><img src="');
			ventana.document.write(imgData);
			ventana.document.write('"width="750" height="545">');
			ventana.document.write('</div><br><div style="border-width:1;border-color:#901420;border-style:dashed;border-radius:15px; margin-top: 50px;margin-left: 150px; margin-right: 150px; margin-bottom: 20px; padding-left:20px; padding-right:20px; font-family:Verdana;font-size:16px;background-color:#f3f0e7;text-align:center">');
			ventana.document.write('<br><br>Para guardar la imagen haz clic sobre ella con el botn derecho. En el men que aparece selecciona: "Guardar imagen como..."');
			ventana.document.write('<br><br><button onclick="window.close();" class="botonVentana">Cerrar Ventana</button><br><br></div><br><br></div></body>');
			ventana.document.close();
	//window.open(document.getElementById("imageView").toDataURL("image/png"),'Canvas Export','height=450,width=625');
	})

	// tools Contiene la implementacion de cada herramienta
	var tools = {};
	//Controles para saber que botn se ha seleccionado
	$('#cubo_pintura').click (function (){
	tool = new tools['cubo_pintura']();
	$('canvas').css("cursor","url(imagenes/cursores/cursor_cubo.png),auto");
	})
	$('#colorPicker').click(function (){
	tool = new tools['cuentagotas']();
	$('canvas').css("cursor","url(imagenes/cursores/cursor_cuenta.png),auto");	
	})
	$('#deshacer').click (function() {
	undoDraw();
	})
	$('#rehacer').click (function() {
	redoDraw();
	})
	
    // Coloca una imagen encima
	function ponerImg(urlImg) {
	var img = new Image();
	img.src = urlImg;
		img.onload = function(){
		context = canvas.getContext('2d');
		context.drawImage(img,0,0,canvasWidth,canvasHeight);
		img_update();
		}
	}

    // Cuentagotas
	tools.cuentagotas = function () {
    var tool = this;
		this.mousedown = function (ev) {
		  pixelColor = contexto.getImageData( ev._x,ev._y,1,1);
		  if(pixelColor.data[0] + pixelColor.data[1] + pixelColor.data[2] == 0){
			  rellenoR = 1;
			  rellenoG = 1;
			  rellenoB = 1;		  
			}else{
			  rellenoR = pixelColor.data[0];
			  rellenoG = pixelColor.data[1];
			  rellenoB = pixelColor.data[2];
			}  
			  alfaColor();
			  actTri();
			  $('#paleta').css('backgroundColor', relleno);
		};
	};


		//Cubo Pintura
		tools.cubo_pintura = function () {
		var tool = this;
		this.started = false;

			this.mousedown = function (ev) {
			curColor = { r:rellenoR, g:rellenoG, b:rellenoB};//toma color seleccionado en rgb
			saveActions();
			colorLayerData = contexto.getImageData(0, 0, canvasWidth, canvasHeight);//copia canvas a colorLayerData
			paintAt(ev._x, ev._y);
			saveLocalStorage();
			};
			floodFill = function (startX, startY, startR, startG, startB) {


					var newPos,
						x,
						y,
						pixelPos,
						reachLeft,
						reachRight,
						drawingBoundLeft = 0,
						drawingBoundTop = 0,
						drawingBoundRight = canvasWidth,
						drawingBoundBottom = canvasHeight-22;
						pixelStack = [[startX, startY]];

					while (pixelStack.length) {

						newPos = pixelStack.pop();
						x = newPos[0];
						y = newPos[1];

						// Get current pixel position
						pixelPos = (y * canvasWidth + x) * 4;

						// Go up as long as the color matches and are inside the canvas
						while (y >= drawingBoundTop && matchStartColor(pixelPos, startR, startG, startB)) {
							y -= 1;
							pixelPos -= canvasWidth * 4;
						}

						pixelPos += canvasWidth * 4;
						y += 1;
						reachLeft = false;
						reachRight = false;

						// Go down as long as the color matches and in inside the canvas
						while (y <= drawingBoundBottom && matchStartColor(pixelPos, startR, startG, startB)) {
							y += 1;

							colorPixel(pixelPos, curColor.r, curColor.g, curColor.b);

							if (x > drawingBoundLeft) {
								if (matchStartColor(pixelPos - 4, startR, startG, startB)) {
									if (!reachLeft) {
										// Add pixel to stack
										pixelStack.push([x - 1, y]);
										reachLeft = true;
									}
								} else if (reachLeft) {
									reachLeft = false;
								}
							}

							if (x < drawingBoundRight) {
								if (matchStartColor(pixelPos + 4, startR, startG, startB)) {
									if (!reachRight) {
										// Add pixel to stack
										pixelStack.push([x + 1, y]);
										reachRight = true;
									}
								} else if (reachRight) {
									reachRight = false;
								}
							}

							pixelPos += canvasWidth * 4;
						}
					}

				},


			clearCanvas = function () {
			contexto.clearRect(0, 0,canvasWidth, canvasHeight);
			}

			matchStartColor = function (pixelPos, startR, startG, startB) {

				r = colorLayerData.data[pixelPos];
				g = colorLayerData.data[pixelPos + 1];
				b = colorLayerData.data[pixelPos + 2];

				//Si el color que clickeamos es el negro
				if(r+g+b < 3){
				return false;
				}
				
				// If the current pixel matches the clicked color
				if (r === startR && g === startG && b === startB) {
					return true;
				}

				// If current pixel matches the new color
				if (r === curColor.r && g === curColor.g && b === curColor.b) {
					return false;
				}
				// If current pixel has different colour
				return false;
			}

			colorPixel = function (pixelPos, r, g, b, a) {

				colorLayerData.data[pixelPos] = r;
				colorLayerData.data[pixelPos + 1] = g;
				colorLayerData.data[pixelPos + 2] = b;
				colorLayerData.data[pixelPos + 3] = a !== undefined ? a : 255;
			};
			paintAt = function (startX, startY) {

				var pixelPos = (startY * canvasWidth + startX) * 4,
					r = colorLayerData.data[pixelPos],
					g = colorLayerData.data[pixelPos + 1],
					b = colorLayerData.data[pixelPos + 2],
					a = colorLayerData.data[pixelPos + 3];

				if (r === curColor.r && g === curColor.g && b === curColor.b) {
					// Return because trying to fill with the same color
					return;
				};

				floodFill(startX, startY, r, g, b);
				contexto.putImageData(colorLayerData, 0, 0);
			}
		}; //fin cubo pintura
	
		//Aumenta de tamao el escritorio
		document.getElementById('zoom_in').onclick = function() {
			if (canvasScale > 2) {
				return;	
			}
			canvasScale = canvasScale * scaleFactor;
			altoNuevo = Math.round(altoNuevo* scaleFactor);
			anchoNuevo = Math.round( anchoNuevo* scaleFactor);
			$('#imageView').css('height',altoNuevo);
			$('#imageView').css('width',anchoNuevo);
			$('.lienzo').css('height',altoNuevo);
			$('.lienzo').css('width',anchoNuevo);
			$('#imageTemp').css('height',altoNuevo-(22*canvasScale));
			$('#imageTemp').css('width',anchoNuevo);
			$('#imageTop').css('height',altoNuevo);
			$('#imageTop').css('width',anchoNuevo);
			objeto = document.getElementById('herram');
			objeto.style.height = altoNuevo +'px';
		}
	
		//Disminuye de tamao el escritorio
		document.getElementById('zoom_out').onclick = function() {
			if (canvasScale < 0.9) {
				return;	
			}
			canvasScale = canvasScale / scaleFactor;
			altoNuevo = Math.round(altoNuevo * (1 / scaleFactor));
			anchoNuevo = Math.round(anchoNuevo * (1 / scaleFactor));
			$('#imageView').css('height',altoNuevo);
			$('#imageView').css('width',anchoNuevo);
			$('.lienzo').css('height',altoNuevo);
			$('.lienzo').css('width',anchoNuevo);
			$('#imageTemp').css('height',altoNuevo-(22 * canvasScale));
			$('#imageTemp').css('width',anchoNuevo);
			$('#imageTop').css('height',altoNuevo);
			$('#imageTop').css('width',anchoNuevo);
			objeto = document.getElementById('herram');
			objeto.style.height = altoNuevo +'px';
		}
	
	
		//Transforma imagen importada a blanco y negro
		function filtroByN(flag){
		canvasData = contexto.getImageData(0, 0, canvasWidth, canvasHeight);
		pixel = canvasData.data;
			for (var x = 0; x < canvasWidth; x++) {
				for (var y = 0; y < canvasHeight; y++) {

					var idx = (x + y * canvasWidth) * 4;

					var r = pixel[idx + 0];
					var g = pixel[idx + 1];
					var b = pixel[idx + 2];
					var a = pixel[idx + 3];
					//var v = 0.2126*r + 0.7152*g + 0.0722*b;//filtro a grises
					
					
					var v = (r+g+b)/3;
					if (v <= 80){
					pixel[idx + 0] = 0;
					pixel[idx + 1] = 0;
					pixel[idx + 2] = 0;
					}else{
					pixel[idx + 0] = 255;
					pixel[idx + 1] = 255;
					pixel[idx + 2] = 255;
					pixel[idx + 3] = 0;
					}
				}
			}
			contextTop.putImageData(canvasData, 0, 0);
			imagenFondo = canvasTop.toDataURL("image/png");
			if(flag == 1){
			fondoColor();
			ponerFondo(imagenFondo);
			img_update ();
			}else{
			return;
			}
		}
	
		//Importa imagen desde archivo y la coloca como fondo del canvas fabric
		formEl = document.forms[0],
		fileEl = formEl.elements[0],

		formEl.onsubmit = fileEl.onchange = uploadHandler;
//
		function uploadHandler() {
		uploadFile(fileEl.files && fileEl.files[0]);
		return false;
		}		
		$('#subirArc').click(function(){fileEl.click()});
		
		//Sube archivo de imagen desde el ordenador
		function uploadFile(file) {
			if (file && file.type && file.type.match(/^image\/.*/)) {
				var fileReader = new FileReader();
				fileReader.onload = function(e) {
					var dataURL = e.target.result;
					var newImg = new Image();
					newImg.onload = ajustar;
					newImg.src = dataURL;
					contexto.clearRect(0, 0, canvas.width, canvas.height);	
					function ajustar(){
						
						alto = newImg.height;
						ancho = newImg.width;
						altoCanvas =canvaso.height-22;
						if(ancho/alto >= canvaso.width/altoCanvas){
							yCoor = Math.floor((altoCanvas-canvaso.width*alto/ancho)/2);
							altoPNG = Math.floor(canvaso.width*alto/ancho);
							contexto.drawImage(newImg,0,yCoor,canvaso.width,altoPNG);
							filtroByN(1);
							return
						}else{
							xCoor = Math.floor((canvaso.width-altoCanvas*ancho/alto)/2);
							anchoPNG = Math.floor(altoCanvas*ancho/alto);
							contexto.drawImage(newImg,xCoor,0,anchoPNG,altoCanvas);
							filtroByN(1);
						}
					}
				}
			fileReader.readAsDataURL(file);
			}return
		}

	init();

}, false); }
