// Keep everything in anonymous function, called on window load.
if(window.addEventListener) {
window.addEventListener('load', function () {
  var canvas, context, canvaso, contexto;

  // Variables de herramientas.
  var tool;
  var undoHistory = new Array();//Matriz que guarda imagenes para el deshacer
  var redoHistory = new Array();//Matriz que guarda imagenes para el rehacer
  var tool_default = 'cubo_pintura';
  var imagenFondo = "data:image/png;base64,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";
  rellenoR = 244;
  rellenoG = 237;
  rellenoB = 200;
  var fin = 'round';
  var grid = 20;//Tamao de rejilla
  var colorFondo = '#f3f0e7';//color de fondo y del borrador
  var radioPuntos = 1.5;//radio de crculos en punteado
  var densidad = 5;//factor que marca la distancia entre puntos respecto al grosor del punto en punteado2 y pincelPluma
  var espaciado = densidad * 5;//separacin entre pinceladas en pincel compuesto
  var pincel = 10;//radio del area donde se dibujan los puntos en pincel aleatorio y del borrador
  var anchopluma = 2;//en pincel pluma el ancho en el que hay trazos
  var grosorpluma = 1;//Grosor de los trazos en pincel pluma
  var canvasWidth;
  var canvasHeight;

  function init () {
    // Localiza el elemento canvas.
    canvaso = document.getElementById('imageView');
    if (!canvaso) {
      alert('Error: No puedo encontrar el elemento canvas!');
      return;
    }
   altoNuevo = canvaso.height;
   anchoNuevo = canvaso.width;
    if (!canvaso.getContext) {
      alert('Error: no canvas.getContext!');
      return;
    }

    // Toma el 2D canvas context.
    contexto = canvaso.getContext('2d');
    if (!contexto) {
      alert('Error: Necesitas un navegador ms moderno para poder ver esta aplicacin!');
      return;
    }
	
    // Crea contexto para canvas que est encima de todo
	
    canvasTop = document.getElementById('imageTop');	
    contextTop = canvasTop.getContext('2d');
    if (!contextTop) {
      alert('Error: failed to getContext!');
      return;
    }	
	
	canvasWidth = canvaso.width;
	canvasHeight = canvaso.height;
	
	//Ponemos fondo color
	fondoColor();
	

    // Aade un canvas temporal.
    var container = canvaso.parentNode;
    canvas = document.createElement('canvas');
    if (!canvas) {
    alert('Error: No puedo crar un nuevo lienzo!');
    return;
    }
    canvas.id     = 'imageTemp';
    canvas.width  = canvaso.width;
    canvas.height = canvasHeight - 22;
	contTemp = document.getElementById('contenedor1');
    contTemp.appendChild(canvas);
    context = canvas.getContext('2d');



    // Activa la herramienta por defecto.
    if (tools[tool_default]) {
      tool = new tools[tool_default]();
    }
	//Pone por defecto el cursor lpiz
	$('canvas').css("cursor","url(imagenes/cursores/cursor_cubo.png),auto");
	

    // Coloca mousedown, mousemove and mouseup event listeners.
    canvas.addEventListener('mousedown', ev_canvas, false);
    canvas.addEventListener('mousemove', ev_canvas, false);
    canvas.addEventListener('mouseup',  ev_canvas, false);
	canvas.addEventListener('dblclick',  ev_canvas, false);
	canvas.addEventListener('mouseout',  ev_canvas, false);
	canvaso.addEventListener('mouseup',  ev_canvas, false);
	
	//Eventos cuando se presiona una tecla
	window.onkeydown = function(evt) {
	evt = evt || window.event;
	if (evt.keyCode === 17) {
		keyControl = true;
		}
	}
	window.onkeyup = function(evt) {
	evt = evt || window.event;
		if (evt.keyCode === 17) {
			keyControl = false;
		}else if(evt.keyCode === 90 &&(keyControl)){//Deshace al presionar Ctrl + z
		undoDraw();
		}
	}
	//Evita seleccion azul
	document.onselectstart = function() {
	return false;
	}
	
	//si existe almacenada imagen de anterior trabajo en navegador la carga

	if (localStorage.dibujo_armonia_cromatica){
		if (confirm('Quieres recuperar el ltimo trabajo que se hizo con esta aplicacin?')) {
			localStorageImage = new Image();
			localStorageImage.addEventListener("load", function(event){
				localStorageImage.removeEventListener(event.type, arguments.callee, false);
				contexto.drawImage(localStorageImage,0,0);
				filtroByN(0);
			}, false);
			localStorageImage.src = localStorage.dibujo_armonia_cromatica;
			
		}else{ponerFondo(imagenFondo);return}
	}else{ponerFondo(imagenFondo);return}

}
	//Carga imagen para patrn y lo crea.
	$('.textura').click(function (){
		var img = new Image();
			var direccion = $(this).attr('id');
			var textFondo = $(this).css('backgroundImage');
			img.src =  eval(direccion);
			img.onload = function(){
			var ptrn = context.createPattern(img,'repeat');
			relleno = ptrn;
		}
		$('#paleta3').css('backgroundImage', textFondo);
	})
	
	
	//Abre ventana para escribir texto en canvas
	$('#texto').click( function() {
		document.getElementById('text-controls').style.display = 'block';
		var textE1 = document.getElementById('text');
		//textE1.focus();
	})
	//Coloca texto al aceptar
	$('#botonTexto').click(function (){
		saveActions();
		contexto.save();
		contexto.fillStyle = colorFondo;
		contexto.fillRect(0,523, canvaso.width, 22);//rellena con color de fondo Si fuera una imagen habra que recargarla
		contexto.restore();
		titulo = document.getElementById('text').value;
		contexto.font = "12pt Verdana";
		contexto.fillStyle = "black";
		contexto.fillText(titulo, 20, 540);
		saveLocalStorage();
		document.getElementById('text-controls').style.display = 'none';
	})
	//Cierra ventana de colocar texto
	$('#botonTexCan').click(function (){document.getElementById('text-controls').style.display = 'none'});
	
	// Controlador de evento general. Esta funcin determina la
	// posicion relativa del ratn respecto al elemento canvas.Da las coordenadas del raton dentro del canvas
	function ev_canvas (ev) {
		if (ev.layerX || ev.layerX == 0) { // Firefox
		  ev._x = Math.round(ev.layerX / canvasScale);//multiplicamos por canvasScale para conpensar zoom
		  ev._y = Math.round(ev.layerY / canvasScale);
		} else if (ev.offsetX || ev.offsetX == 0) { // Opera
		  ev._x = Math.round(ev.offsetX / canvasScale);
		  ev._y = Math.round(ev.offsetY / canvasScale);
		}

		// Llama al manejador del evento de la herramienta
		var func = tool[ev.type];
		if (func) {
		  func(ev);
		}
	}

	// Esta funcin dibuja #imageTemp canvas encima de #imageView, despus
	// #imageTemp se limpia. Esto se realiza cada vez que el usuario
	// completa unaa operacin de dibujo.
	function img_update () {
  		saveActions();//Guarda copia de la imagen
		contexto.drawImage(canvas, 0, 0);//copia imagen temporal en definitiva
		context.clearRect(0, 0, canvas.width, canvas.height);//Limpia la imagen temporal
		redoHistory = [];
		saveLocalStorage();

	}
	//Function guarda imagen en array para poder deshacer
	function saveActions() {
		var imgData = document.getElementById("imageView").toDataURL("image/png");
		undoHistory.push(imgData);//guarda imagen en matriz deshacer
	}
	//Guarda imagen en el cache del navegador
	function saveLocalStorage(){
		var imgData = document.getElementById("imageView").toDataURL("image/png");
		localStorage.dibujo_armonia_cromatica = imgData;//guarda imagen en el cache del navegador
	}
	
	//Funcin pone fondo de color
	function fondoColor(){
	contexto.save();
	contexto.fillStyle = colorFondo;
	contexto.fillRect(0,0, canvaso.width, canvaso.height);
	contexto.restore();
	}
	
	//Funcion deshacer
	function undoDraw(){
		if(undoHistory.length > 0){
		var imgData = document.getElementById("imageView").toDataURL("image/png");
		redoHistory.push(imgData);//Guarda la imagen actual en array rehacer
        var undoImg = new Image();
			undoImg.onload = function(){//funcion para que le de tiempo a cargar la imagen
			contexto.drawImage(undoImg, 0,0);//copia imagen rescatada en canvas
			var imgData = document.getElementById("imageView").toDataURL("image/png");
			localStorage.dibujo_bodegon_punto = imgData;//guarda imagen en el cache del navegador
			};
			undoImg.src = undoHistory.pop();//saca ultima imagen guardada en el array y la guarda en undoImg
        } else if(undoHistory.length == 0){
		return
		}		
	}
	
	function redoDraw(){
		if(redoHistory.length > 0){
		saveActions();
        var redoImg = new Image();
			redoImg.onload = function(){//funcion para que le de tiempo a cargar la imagen
			contexto.drawImage(redoImg, 0,0);//copia imagen rescatada en canvas
			var imgData = document.getElementById("imageView").toDataURL("image/png");
			localStorage.dibujo_bodegon_punto = imgData;//guarda imagen en el cache del navegador
			};
			redoImg.src = redoHistory.pop();//saca ultima imagen guardada en el array y la guarda en redoImg
		}
	}
	
	
	//Pone una imagen como fondo
	function ponerFondo (imagenUrl){
		var img = new Image();
		img.src = imagenUrl;
		img.onload = function(){
		//contexto = canvaso.getContext('2d');
		contexto.drawImage(img,0,0,750,523,0,0,750,523);
		}
	}

	//Control del boton limpiar
    $('#reset').click(function() {
        if (confirm('Se reiniciar el ejercicio y se perder la imagen actual. Ests seguro?')) {
		//canvaso.width = canvaso.width;
		undoHistory.length = 0;//vacia array con estados anteriores
		redoHistory.length = 0;
		contexto.save();
		contexto.fillStyle = colorFondo;
		contexto.fillRect(0,0, canvaso.width, canvaso.height);//rellena con color de fondo Si fuera una imagen habra que recargarla
		contexto.restore();
		ponerFondo(imagenFondo);
        }
    })

	//controlamos el boton guardar imagen
	$('#guardar').click (function() {
	var imgData = document.getElementById("imageView").toDataURL("image/png");
			var ventana = window.open('','imagenGenerada', "toolbar=no,location=no,status=no,menubar=no,resizable=yes,scrollbars=1");
			ventana.document.write('<html><head><title>Imagen Generada</title><meta http-equiv="content-type" content="text/html; charset=iso-8859-1"><link rel="stylesheet" type="text/css" href="css/dibujo_00.css" /> ');
			ventana.document.write('</head>');
			ventana.document.write('<body style="background-color:#F4EDC8">');
			ventana.document.write('<div  style="position:absolute; top:40px; left:50%; margin-left: -375px;  width:750px; height:545px; box-shadow: -2px 2px 10px 1px #999;"><div style="position:relative"></div><div><img src="');
			ventana.document.write(imgData);
			ventana.document.write('"width="750" height="545">');
			ventana.document.write('</div><br><div style="border-width:1;border-color:#901420;border-style:dashed;border-radius:15px; margin-top: 50px;margin-left: 150px; margin-right: 150px; margin-bottom: 20px; padding-left:20px; padding-right:20px; font-family:Verdana;font-size:16px;background-color:#f3f0e7;text-align:center">');
			ventana.document.write('<br><br>Para guardar la imagen haz clic sobre ella con el botn derecho. En el men que aparece selecciona: "Guardar imagen como..."');
			ventana.document.write('<br><br><button onclick="window.close();" class="botonVentana">Cerrar Ventana</button><br><br></div><br><br></div></body>');
			ventana.document.close();
	//window.open(document.getElementById("imageView").toDataURL("image/png"),'Canvas Export','height=450,width=625');
	})

	// tools Contiene la implementacion de cada herramienta
	var tools = {};
	//Controles para saber que botn se ha seleccionado
	$('#cubo_pintura').click (function (){
	tool = new tools['cubo_pintura']();
	$('canvas').css("cursor","url(imagenes/cursores/cursor_cubo.png),auto");
	})
	$('#colorPicker').click(function (){
	tool = new tools['cuentagotas']();
	$('canvas').css("cursor","url(imagenes/cursores/cursor_cuenta.png),auto");	
	})
	$('#deshacer').click (function() {
	undoDraw();
	})
	$('#rehacer').click (function() {
	redoDraw();
	})
	
    // Coloca una imagen encima
	function ponerImg(urlImg) {
	var img = new Image();
	img.src = urlImg;
		img.onload = function(){
		context = canvas.getContext('2d');
		context.drawImage(img,0,0,canvasWidth,canvasHeight);
		img_update();
		}
	}

    // Cuentagotas
	tools.cuentagotas = function () {
    var tool = this;
		this.mousedown = function (ev) {
		  pixelColor = contexto.getImageData( ev._x,ev._y,1,1);
		  if(pixelColor.data[0] + pixelColor.data[1] + pixelColor.data[2] == 0){
			  rellenoR = 1;
			  rellenoG = 1;
			  rellenoB = 1;		  
			}else{
			  rellenoR = pixelColor.data[0];
			  rellenoG = pixelColor.data[1];
			  rellenoB = pixelColor.data[2];
			}  
			  alfaColor();
			  actTri();
			  $('#paleta').css('backgroundColor', relleno);
			  $('#paleta').html('&nbsp');
		};
	};


		//Cubo Pintura
		tools.cubo_pintura = function () {
		var tool = this;
		this.started = false;

			this.mousedown = function (ev) {
			curColor = { r:rellenoR, g:rellenoG, b:rellenoB};//toma color seleccionado en rgb
			saveActions();
			colorLayerData = contexto.getImageData(0, 0, canvasWidth, canvasHeight);//copia canvas a colorLayerData
			paintAt(ev._x, ev._y);
			saveLocalStorage();
			};
			floodFill = function (startX, startY, startR, startG, startB) {


					var newPos,
						x,
						y,
						pixelPos,
						reachLeft,
						reachRight,
						drawingBoundLeft = 0,
						drawingBoundTop = 0,
						drawingBoundRight = canvasWidth,
						drawingBoundBottom = canvasHeight-22;
						pixelStack = [[startX, startY]];

					while (pixelStack.length) {

						newPos = pixelStack.pop();
						x = newPos[0];
						y = newPos[1];

						// Get current pixel position
						pixelPos = (y * canvasWidth + x) * 4;

						// Go up as long as the color matches and are inside the canvas
						while (y >= drawingBoundTop && matchStartColor(pixelPos, startR, startG, startB)) {
							y -= 1;
							pixelPos -= canvasWidth * 4;
						}

						pixelPos += canvasWidth * 4;
						y += 1;
						reachLeft = false;
						reachRight = false;

						// Go down as long as the color matches and in inside the canvas
						while (y <= drawingBoundBottom && matchStartColor(pixelPos, startR, startG, startB)) {
							y += 1;

							colorPixel(pixelPos, curColor.r, curColor.g, curColor.b);

							if (x > drawingBoundLeft) {
								if (matchStartColor(pixelPos - 4, startR, startG, startB)) {
									if (!reachLeft) {
										// Add pixel to stack
										pixelStack.push([x - 1, y]);
										reachLeft = true;
									}
								} else if (reachLeft) {
									reachLeft = false;
								}
							}

							if (x < drawingBoundRight) {
								if (matchStartColor(pixelPos + 4, startR, startG, startB)) {
									if (!reachRight) {
										// Add pixel to stack
										pixelStack.push([x + 1, y]);
										reachRight = true;
									}
								} else if (reachRight) {
									reachRight = false;
								}
							}

							pixelPos += canvasWidth * 4;
						}
					}

				},


			clearCanvas = function () {
			contexto.clearRect(0, 0,canvasWidth, canvasHeight);
			}

			matchStartColor = function (pixelPos, startR, startG, startB) {

				r = colorLayerData.data[pixelPos];
				g = colorLayerData.data[pixelPos + 1];
				b = colorLayerData.data[pixelPos + 2];

				//Si el color que clickeamos es el negro
				if(r+g+b < 3){
				return false;
				}
				
				// If the current pixel matches the clicked color
				if (r === startR && g === startG && b === startB) {
					return true;
				}

				// If current pixel matches the new color
				if (r === curColor.r && g === curColor.g && b === curColor.b) {
					return false;
				}
				// If current pixel has different colour
				return false;
			}

			colorPixel = function (pixelPos, r, g, b, a) {

				colorLayerData.data[pixelPos] = r;
				colorLayerData.data[pixelPos + 1] = g;
				colorLayerData.data[pixelPos + 2] = b;
				colorLayerData.data[pixelPos + 3] = a !== undefined ? a : 255;
			};
			paintAt = function (startX, startY) {

				var pixelPos = (startY * canvasWidth + startX) * 4,
					r = colorLayerData.data[pixelPos],
					g = colorLayerData.data[pixelPos + 1],
					b = colorLayerData.data[pixelPos + 2],
					a = colorLayerData.data[pixelPos + 3];

				if (r === curColor.r && g === curColor.g && b === curColor.b) {
					// Return because trying to fill with the same color
					return;
				};

				floodFill(startX, startY, r, g, b);
				contexto.putImageData(colorLayerData, 0, 0);
			}
		}; //fin cubo pintura
	
		//Aumenta de tamao el escritorio
		document.getElementById('zoom_in').onclick = function() {
			if (canvasScale > 2) {
				return;	
			}
			canvasScale = canvasScale * scaleFactor;
			altoNuevo = Math.round(altoNuevo* scaleFactor);
			anchoNuevo = Math.round( anchoNuevo* scaleFactor);
			$('#imageView').css('height',altoNuevo);
			$('#imageView').css('width',anchoNuevo);
			$('.lienzo').css('height',altoNuevo);
			$('.lienzo').css('width',anchoNuevo);
			$('#imageTemp').css('height',altoNuevo-(22*canvasScale));
			$('#imageTemp').css('width',anchoNuevo);
			$('#imageTop').css('height',altoNuevo);
			$('#imageTop').css('width',anchoNuevo);
			objeto = document.getElementById('herram');
			objeto.style.height = altoNuevo +'px';
		}
	
		//Disminuye de tamao el escritorio
		document.getElementById('zoom_out').onclick = function() {
			if (canvasScale < 0.9) {
				return;	
			}
			canvasScale = canvasScale / scaleFactor;
			altoNuevo = Math.round(altoNuevo * (1 / scaleFactor));
			anchoNuevo = Math.round(anchoNuevo * (1 / scaleFactor));
			$('#imageView').css('height',altoNuevo);
			$('#imageView').css('width',anchoNuevo);
			$('.lienzo').css('height',altoNuevo);
			$('.lienzo').css('width',anchoNuevo);
			$('#imageTemp').css('height',altoNuevo-(22 * canvasScale));
			$('#imageTemp').css('width',anchoNuevo);
			$('#imageTop').css('height',altoNuevo);
			$('#imageTop').css('width',anchoNuevo);
			objeto = document.getElementById('herram');
			objeto.style.height = altoNuevo +'px';
		}
	
				//Transforma imagen importada a blanco y negro
		function filtroByN(flag){
		canvasData = contexto.getImageData(0, 0, canvasWidth, canvasHeight);
		pixel = canvasData.data;
			for (var x = 0; x < canvasWidth; x++) {
				for (var y = 0; y < canvasHeight; y++) {

					var idx = (x + y * canvasWidth) * 4;

					var r = pixel[idx + 0];
					var g = pixel[idx + 1];
					var b = pixel[idx + 2];
					var a = pixel[idx + 3];
					//var v = 0.2126*r + 0.7152*g + 0.0722*b;//filtro a grises
					
					
					var v = (r+g+b)/3;
					if (v <= 80){
					pixel[idx + 0] = 0;
					pixel[idx + 1] = 0;
					pixel[idx + 2] = 0;
					}else{
					pixel[idx + 0] = 255;
					pixel[idx + 1] = 255;
					pixel[idx + 2] = 255;
					pixel[idx + 3] = 0;
					}
				}
			}
			contextTop.putImageData(canvasData, 0, 0);
			imagenFondo = canvasTop.toDataURL("image/png");
			if(flag == 1){
			fondoColor();
			ponerFondo(imagenFondo);
			img_update ();
			}else{
			return;
			}
		}
	
		//Importa imagen desde archivo y la coloca como fondo del canvas fabric
		formEl = document.forms[0],
		fileEl = formEl.elements[0],

		formEl.onsubmit = fileEl.onchange = uploadHandler;
//
		function uploadHandler() {
		uploadFile(fileEl.files && fileEl.files[0]);
		return false;
		}		
		$('#subirArc').click(function(){fileEl.click()});
		
		//Sube archivo de imagen desde el ordenador
		function uploadFile(file) {
			if (file && file.type && file.type.match(/^image\/.*/)) {
				var fileReader = new FileReader();
				fileReader.onload = function(e) {
					var dataURL = e.target.result;
					var newImg = new Image();
					newImg.onload = ajustar;
					newImg.src = dataURL;
					contexto.clearRect(0, 0, canvas.width, canvas.height);	
					function ajustar(){
						
						alto = newImg.height;
						ancho = newImg.width;
						altoCanvas =canvaso.height-22;
						if(ancho/alto >= canvaso.width/altoCanvas){
							yCoor = Math.floor((altoCanvas-canvaso.width*alto/ancho)/2);
							altoPNG = Math.floor(canvaso.width*alto/ancho);
							contexto.drawImage(newImg,0,yCoor,canvaso.width,altoPNG);
							filtroByN(1);
							return
						}else{
							xCoor = Math.floor((canvaso.width-altoCanvas*ancho/alto)/2);
							anchoPNG = Math.floor(altoCanvas*ancho/alto);
							contexto.drawImage(newImg,xCoor,0,anchoPNG,altoCanvas);
							filtroByN(1);
						}
					}
				}
			fileReader.readAsDataURL(file);
			}return
		}

	init();

}, false); }
