/*
 * Project: RegularPolygonGenerator
 * @Autor: Daniel Martinez
 *
 **************************************/
var RegularPolygonGenerator = function(canvasID){
		
        this.canvasID = canvasID;
        
	//** Options
	this.config = {
            fillStyle : '',
            strokeStyle:'#000',
            lineWidth:1,
            lSide:10,
            rotationAngle:0,
            x:0,
            y:0,
            n:3,
            points: []
	}
	
        // Canvas 2d context
        this.getContext = function(canvasID) {
            var canvas = document.getElementById(canvasID),
                    ctx = canvas.getContext("2d");
            return ctx;
	};
        
        //**  canvas context 
	this.contextCanvas = this.getContext(this.canvasID);
        
	//**  @To radians function		
	this.toRadians = function(angle){ return (Math.PI * angle)/ 180 };
	
	//**  @a point structure			
	this.p = function(_x,_y){ 
            return {
                x:_x,
                y:_y
            };
	};
	//**  @a list of polygons		
	this.polygons = new Array();
}
/**	Prototype **/
RegularPolygonGenerator.prototype = {

	/*
	 * Generate list of points
	 **/
	generate : function( pol ){

		var args = arguments,argPol,i = 0;
		var obj = this;
		var w;
		while (argPol = args[i]) {
			extend(argPol,this.config);
			argPol.points = genPoints( argPol );
			this.polygons.push(argPol);
			i++;
		}
		
		
		// gen Points 
		function genPoints( pol ) {

			var p = new obj.p( pol['x'], pol['y'] ), x, y, tmpPol = new Array();
			//**  @External angle			
			w = 2 * Math.PI / pol['n'];

			tmpPol.push(p);
			
			for (var i=1; i <= pol['n']; i++){
				x = Math.cos(obj.toRadians(pol['rotationAngle']) + (w * (i-1))) * pol['lSide'] + tmpPol[i-1].x;
				y = Math.sin(obj.toRadians(pol['rotationAngle']) + (w * (i-1))) * pol['lSide'] + tmpPol[i-1].y;
				p = new obj.p(x,y);
				tmpPol.push(p);
			}
			return tmpPol;
		}
		
		// function extend
		function extend( pol, def) {
			for (var opt in def) {
				if (! pol[opt])
						pol[opt] = def[opt]
			}
		};
	},
	
	/*
	 * draw()
	 **/
	draw : function(){
		var obj = this;
		var i = 0, pol;
		
		while (pol = this.polygons[i]) {
			drawPol.call(this,pol);
			i++;
		}
		
		/**
		 * Draw polygon
		 */
		function drawPol ( pol ) {alert(pol.points[0].x);
			this.contextCanvas.beginPath();
			this.contextCanvas.strokeStyle = pol['strokeStyle'];
			
			this.contextCanvas.lineWidth= pol['lineWidth'];
			this.contextCanvas.moveTo(pol.points[0].x,pol.points[0].y);
			
			for(var i=1; i <= pol['n']; i++) {
				this.contextCanvas.lineTo(pol.points[i].x,pol.points[i].y);
			}
				this.contextCanvas.lineTo(pol.points[1].x,pol.points[1].y);
			this.contextCanvas.stroke();
			
			// With fill
			if (pol['fillStyle'] != '') {
				
				this.contextCanvas.fillStyle = pol['fillStyle'];
				this.contextCanvas.fill();	
			}
			this.contextCanvas.closePath();

		}
		
	},
        /**
         * Clear canvas
         */
        clear : function () {
			this.polygons = [];
            var canvas = document.getElementById(this.canvasID);
            this.contextCanvas.clearRect(0,0,canvas.width,canvas.height);
        }

}